goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return cljs.core._vreset_BANG_(shadow.cljs.devtools.client.browser.active_modules_ref,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(shadow.cljs.devtools.client.browser.active_modules_ref),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4534__auto__ = [];
var len__4531__auto___40432 = arguments.length;
var i__4532__auto___40433 = (0);
while(true){
if((i__4532__auto___40433 < len__4531__auto___40432)){
args__4534__auto__.push((arguments[i__4532__auto___40433]));

var G__40434 = (i__4532__auto___40433 + (1));
i__4532__auto___40433 = G__40434;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(null,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq40430){
var G__40431 = cljs.core.first(seq40430);
var seq40430__$1 = cljs.core.next(seq40430);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40431,seq40430__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5455__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5455__auto__)){
var s = temp__5455__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__40435){
var map__40436 = p__40435;
var map__40436__$1 = ((((!((map__40436 == null)))?(((((map__40436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40436):map__40436);
var src = map__40436__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40436__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40436__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__3949__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__3949__auto__){
return or__3949__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_(output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_(cljs.core.deref(shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__40438 = cljs.core.seq(sources);
var chunk__40439 = null;
var count__40440 = (0);
var i__40441 = (0);
while(true){
if((i__40441 < count__40440)){
var map__40442 = chunk__40439.cljs$core$IIndexed$_nth$arity$2(null,i__40441);
var map__40442__$1 = ((((!((map__40442 == null)))?(((((map__40442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40442.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40442):map__40442);
var src = map__40442__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__40446 = seq__40438;
var G__40447 = chunk__40439;
var G__40448 = count__40440;
var G__40449 = (i__40441 + (1));
seq__40438 = G__40446;
chunk__40439 = G__40447;
count__40440 = G__40448;
i__40441 = G__40449;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40438);
if(temp__5457__auto__){
var seq__40438__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40438__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__40438__$1);
var G__40450 = cljs.core.chunk_rest(seq__40438__$1);
var G__40451 = c__4351__auto__;
var G__40452 = cljs.core.count(c__4351__auto__);
var G__40453 = (0);
seq__40438 = G__40450;
chunk__40439 = G__40451;
count__40440 = G__40452;
i__40441 = G__40453;
continue;
} else {
var map__40444 = cljs.core.first(seq__40438__$1);
var map__40444__$1 = ((((!((map__40444 == null)))?(((((map__40444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40444):map__40444);
var src = map__40444__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40444__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40444__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40444__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40444__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__40454 = cljs.core.next(seq__40438__$1);
var G__40455 = null;
var G__40456 = (0);
var G__40457 = (0);
seq__40438 = G__40454;
chunk__40439 = G__40455;
count__40440 = G__40456;
i__40441 = G__40457;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__40458 = cljs.core.seq(js_requires);
var chunk__40459 = null;
var count__40460 = (0);
var i__40461 = (0);
while(true){
if((i__40461 < count__40460)){
var js_ns = chunk__40459.cljs$core$IIndexed$_nth$arity$2(null,i__40461);
var require_str_40462 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_40462);


var G__40463 = seq__40458;
var G__40464 = chunk__40459;
var G__40465 = count__40460;
var G__40466 = (i__40461 + (1));
seq__40458 = G__40463;
chunk__40459 = G__40464;
count__40460 = G__40465;
i__40461 = G__40466;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40458);
if(temp__5457__auto__){
var seq__40458__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40458__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__40458__$1);
var G__40467 = cljs.core.chunk_rest(seq__40458__$1);
var G__40468 = c__4351__auto__;
var G__40469 = cljs.core.count(c__4351__auto__);
var G__40470 = (0);
seq__40458 = G__40467;
chunk__40459 = G__40468;
count__40460 = G__40469;
i__40461 = G__40470;
continue;
} else {
var js_ns = cljs.core.first(seq__40458__$1);
var require_str_40471 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_40471);


var G__40472 = cljs.core.next(seq__40458__$1);
var G__40473 = null;
var G__40474 = (0);
var G__40475 = (0);
seq__40458 = G__40472;
chunk__40459 = G__40473;
count__40460 = G__40474;
i__40461 = G__40475;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__40476 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__40476) : callback.call(null,G__40476));
} else {
var G__40477 = shadow.cljs.devtools.client.env.files_url();
var G__40478 = ((function (G__40477){
return (function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
});})(G__40477))
;
var G__40479 = "POST";
var G__40480 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0));
var G__40481 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__40477,G__40478,G__40479,G__40480,G__40481);
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__40483){
var map__40484 = p__40483;
var map__40484__$1 = ((((!((map__40484 == null)))?(((((map__40484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40484):map__40484);
var msg = map__40484__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40484__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40484__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__40486 = info;
var map__40486__$1 = ((((!((map__40486 == null)))?(((((map__40486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40486):map__40486);
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40486__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40486__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4324__auto__ = ((function (map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40488(s__40489){
return (new cljs.core.LazySeq(null,((function (map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info){
return (function (){
var s__40489__$1 = s__40489;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__40489__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var map__40494 = cljs.core.first(xs__6012__auto__);
var map__40494__$1 = ((((!((map__40494 == null)))?(((((map__40494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40494):map__40494);
var src = map__40494__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40494__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40494__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4320__auto__ = ((function (s__40489__$1,map__40494,map__40494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40488_$_iter__40490(s__40491){
return (new cljs.core.LazySeq(null,((function (s__40489__$1,map__40494,map__40494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info){
return (function (){
var s__40491__$1 = s__40491;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__40491__$1);
if(temp__5457__auto____$1){
var s__40491__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40491__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__40491__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__40493 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__40492 = (0);
while(true){
if((i__40492 < size__4323__auto__)){
var warning = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__40492);
cljs.core.chunk_append(b__40493,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__40514 = (i__40492 + (1));
i__40492 = G__40514;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40493),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40488_$_iter__40490(cljs.core.chunk_rest(s__40491__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40493),null);
}
} else {
var warning = cljs.core.first(s__40491__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40488_$_iter__40490(cljs.core.rest(s__40491__$2)));
}
} else {
return null;
}
break;
}
});})(s__40489__$1,map__40494,map__40494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info))
,null,null));
});})(s__40489__$1,map__40494,map__40494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info))
;
var fs__4321__auto__ = cljs.core.seq(iterys__4320__auto__(warnings));
if(fs__4321__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4321__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40488(cljs.core.rest(s__40489__$1)));
} else {
var G__40515 = cljs.core.rest(s__40489__$1);
s__40489__$1 = G__40515;
continue;
}
} else {
var G__40516 = cljs.core.rest(s__40489__$1);
s__40489__$1 = G__40516;
continue;
}
} else {
return null;
}
break;
}
});})(map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info))
,null,null));
});})(map__40486,map__40486__$1,sources,compiled,map__40484,map__40484__$1,msg,info,reload_info))
;
return iter__4324__auto__(sources);
})()));
var seq__40496_40517 = cljs.core.seq(warnings);
var chunk__40497_40518 = null;
var count__40498_40519 = (0);
var i__40499_40520 = (0);
while(true){
if((i__40499_40520 < count__40498_40519)){
var map__40500_40521 = chunk__40497_40518.cljs$core$IIndexed$_nth$arity$2(null,i__40499_40520);
var map__40500_40522__$1 = ((((!((map__40500_40521 == null)))?(((((map__40500_40521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40500_40521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40500_40521):map__40500_40521);
var w_40523 = map__40500_40522__$1;
var msg_40524__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40500_40522__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_40525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40500_40522__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_40526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40500_40522__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_40527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40500_40522__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_40527)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_40525),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_40526),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_40524__$1)].join(''));


var G__40528 = seq__40496_40517;
var G__40529 = chunk__40497_40518;
var G__40530 = count__40498_40519;
var G__40531 = (i__40499_40520 + (1));
seq__40496_40517 = G__40528;
chunk__40497_40518 = G__40529;
count__40498_40519 = G__40530;
i__40499_40520 = G__40531;
continue;
} else {
var temp__5457__auto___40532 = cljs.core.seq(seq__40496_40517);
if(temp__5457__auto___40532){
var seq__40496_40533__$1 = temp__5457__auto___40532;
if(cljs.core.chunked_seq_QMARK_(seq__40496_40533__$1)){
var c__4351__auto___40534 = cljs.core.chunk_first(seq__40496_40533__$1);
var G__40535 = cljs.core.chunk_rest(seq__40496_40533__$1);
var G__40536 = c__4351__auto___40534;
var G__40537 = cljs.core.count(c__4351__auto___40534);
var G__40538 = (0);
seq__40496_40517 = G__40535;
chunk__40497_40518 = G__40536;
count__40498_40519 = G__40537;
i__40499_40520 = G__40538;
continue;
} else {
var map__40502_40539 = cljs.core.first(seq__40496_40533__$1);
var map__40502_40540__$1 = ((((!((map__40502_40539 == null)))?(((((map__40502_40539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40502_40539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40502_40539):map__40502_40539);
var w_40541 = map__40502_40540__$1;
var msg_40542__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40502_40540__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_40543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40502_40540__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_40544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40502_40540__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_40545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40502_40540__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_40545)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_40543),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_40544),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_40542__$1)].join(''));


var G__40546 = cljs.core.next(seq__40496_40533__$1);
var G__40547 = null;
var G__40548 = (0);
var G__40549 = (0);
seq__40496_40517 = G__40546;
chunk__40497_40518 = G__40547;
count__40498_40519 = G__40548;
i__40499_40520 = G__40549;
continue;
}
} else {
}
}
break;
}

if(!(shadow.cljs.devtools.client.env.autoload)){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info){
return (function (p__40504){
var map__40505 = p__40504;
var map__40505__$1 = ((((!((map__40505 == null)))?(((((map__40505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40505):map__40505);
var src = map__40505__$1;
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40505__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40505__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src))) || (((cljs.core.contains_QMARK_(compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info){
return (function (p__40507){
var map__40508 = p__40507;
var map__40508__$1 = ((((!((map__40508 == null)))?(((((map__40508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40508.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40508):map__40508);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40508__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info){
return (function (p__40510){
var map__40511 = p__40510;
var map__40511__$1 = ((((!((map__40511 == null)))?(((((map__40511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40511):map__40511);
var rc = map__40511__$1;
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40511__$1,new cljs.core.Keyword(null,"module","module",1424618191));
var or__3949__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("js",shadow.cljs.devtools.client.env.module_format);
if(or__3949__auto__){
return or__3949__auto__;
} else {
return shadow.cljs.devtools.client.browser.module_is_active_QMARK_(module);
}
});})(map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,((function (sources_to_get,map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info){
return (function (p1__40482_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__40482_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,map__40486,map__40486__$1,sources,compiled,warnings,map__40484,map__40484__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
var and__3938__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new);
if(and__3938__auto__){
return rel_new;
} else {
return and__3938__auto__;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
var and__3938__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())));
if(and__3938__auto__){
var and__3938__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$);
if(and__3938__auto____$1){
return new$;
} else {
return and__3938__auto____$1;
}
} else {
return and__3938__auto__;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__40554){
var map__40555 = p__40554;
var map__40555__$1 = ((((!((map__40555 == null)))?(((((map__40555.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40555.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40555):map__40555);
var msg = map__40555__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40555__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__40557 = cljs.core.seq(updates);
var chunk__40559 = null;
var count__40560 = (0);
var i__40561 = (0);
while(true){
if((i__40561 < count__40560)){
var path = chunk__40559.cljs$core$IIndexed$_nth$arity$2(null,i__40561);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__40563_40587 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__40566_40588 = null;
var count__40567_40589 = (0);
var i__40568_40590 = (0);
while(true){
if((i__40568_40590 < count__40567_40589)){
var node_40591 = chunk__40566_40588.cljs$core$IIndexed$_nth$arity$2(null,i__40568_40590);
var path_match_40592 = shadow.cljs.devtools.client.browser.match_paths(node_40591.getAttribute("href"),path);
if(cljs.core.truth_(path_match_40592)){
var new_link_40593 = (function (){var G__40571 = node_40591.cloneNode(true);
G__40571.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_40592),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__40571;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_40592], 0));

goog.dom.insertSiblingAfter(new_link_40593,node_40591);

goog.dom.removeNode(node_40591);


var G__40594 = seq__40563_40587;
var G__40595 = chunk__40566_40588;
var G__40596 = count__40567_40589;
var G__40597 = (i__40568_40590 + (1));
seq__40563_40587 = G__40594;
chunk__40566_40588 = G__40595;
count__40567_40589 = G__40596;
i__40568_40590 = G__40597;
continue;
} else {
var G__40598 = seq__40563_40587;
var G__40599 = chunk__40566_40588;
var G__40600 = count__40567_40589;
var G__40601 = (i__40568_40590 + (1));
seq__40563_40587 = G__40598;
chunk__40566_40588 = G__40599;
count__40567_40589 = G__40600;
i__40568_40590 = G__40601;
continue;
}
} else {
var temp__5457__auto___40602 = cljs.core.seq(seq__40563_40587);
if(temp__5457__auto___40602){
var seq__40563_40603__$1 = temp__5457__auto___40602;
if(cljs.core.chunked_seq_QMARK_(seq__40563_40603__$1)){
var c__4351__auto___40604 = cljs.core.chunk_first(seq__40563_40603__$1);
var G__40605 = cljs.core.chunk_rest(seq__40563_40603__$1);
var G__40606 = c__4351__auto___40604;
var G__40607 = cljs.core.count(c__4351__auto___40604);
var G__40608 = (0);
seq__40563_40587 = G__40605;
chunk__40566_40588 = G__40606;
count__40567_40589 = G__40607;
i__40568_40590 = G__40608;
continue;
} else {
var node_40609 = cljs.core.first(seq__40563_40603__$1);
var path_match_40610 = shadow.cljs.devtools.client.browser.match_paths(node_40609.getAttribute("href"),path);
if(cljs.core.truth_(path_match_40610)){
var new_link_40611 = (function (){var G__40572 = node_40609.cloneNode(true);
G__40572.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_40610),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__40572;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_40610], 0));

goog.dom.insertSiblingAfter(new_link_40611,node_40609);

goog.dom.removeNode(node_40609);


var G__40612 = cljs.core.next(seq__40563_40603__$1);
var G__40613 = null;
var G__40614 = (0);
var G__40615 = (0);
seq__40563_40587 = G__40612;
chunk__40566_40588 = G__40613;
count__40567_40589 = G__40614;
i__40568_40590 = G__40615;
continue;
} else {
var G__40616 = cljs.core.next(seq__40563_40603__$1);
var G__40617 = null;
var G__40618 = (0);
var G__40619 = (0);
seq__40563_40587 = G__40616;
chunk__40566_40588 = G__40617;
count__40567_40589 = G__40618;
i__40568_40590 = G__40619;
continue;
}
}
} else {
}
}
break;
}


var G__40620 = seq__40557;
var G__40621 = chunk__40559;
var G__40622 = count__40560;
var G__40623 = (i__40561 + (1));
seq__40557 = G__40620;
chunk__40559 = G__40621;
count__40560 = G__40622;
i__40561 = G__40623;
continue;
} else {
var G__40624 = seq__40557;
var G__40625 = chunk__40559;
var G__40626 = count__40560;
var G__40627 = (i__40561 + (1));
seq__40557 = G__40624;
chunk__40559 = G__40625;
count__40560 = G__40626;
i__40561 = G__40627;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40557);
if(temp__5457__auto__){
var seq__40557__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40557__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__40557__$1);
var G__40628 = cljs.core.chunk_rest(seq__40557__$1);
var G__40629 = c__4351__auto__;
var G__40630 = cljs.core.count(c__4351__auto__);
var G__40631 = (0);
seq__40557 = G__40628;
chunk__40559 = G__40629;
count__40560 = G__40630;
i__40561 = G__40631;
continue;
} else {
var path = cljs.core.first(seq__40557__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__40573_40632 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__40576_40633 = null;
var count__40577_40634 = (0);
var i__40578_40635 = (0);
while(true){
if((i__40578_40635 < count__40577_40634)){
var node_40636 = chunk__40576_40633.cljs$core$IIndexed$_nth$arity$2(null,i__40578_40635);
var path_match_40637 = shadow.cljs.devtools.client.browser.match_paths(node_40636.getAttribute("href"),path);
if(cljs.core.truth_(path_match_40637)){
var new_link_40638 = (function (){var G__40582 = node_40636.cloneNode(true);
G__40582.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_40637),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__40582;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_40637], 0));

goog.dom.insertSiblingAfter(new_link_40638,node_40636);

goog.dom.removeNode(node_40636);


var G__40639 = seq__40573_40632;
var G__40640 = chunk__40576_40633;
var G__40641 = count__40577_40634;
var G__40642 = (i__40578_40635 + (1));
seq__40573_40632 = G__40639;
chunk__40576_40633 = G__40640;
count__40577_40634 = G__40641;
i__40578_40635 = G__40642;
continue;
} else {
var G__40643 = seq__40573_40632;
var G__40644 = chunk__40576_40633;
var G__40645 = count__40577_40634;
var G__40646 = (i__40578_40635 + (1));
seq__40573_40632 = G__40643;
chunk__40576_40633 = G__40644;
count__40577_40634 = G__40645;
i__40578_40635 = G__40646;
continue;
}
} else {
var temp__5457__auto___40647__$1 = cljs.core.seq(seq__40573_40632);
if(temp__5457__auto___40647__$1){
var seq__40573_40648__$1 = temp__5457__auto___40647__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40573_40648__$1)){
var c__4351__auto___40649 = cljs.core.chunk_first(seq__40573_40648__$1);
var G__40650 = cljs.core.chunk_rest(seq__40573_40648__$1);
var G__40651 = c__4351__auto___40649;
var G__40652 = cljs.core.count(c__4351__auto___40649);
var G__40653 = (0);
seq__40573_40632 = G__40650;
chunk__40576_40633 = G__40651;
count__40577_40634 = G__40652;
i__40578_40635 = G__40653;
continue;
} else {
var node_40654 = cljs.core.first(seq__40573_40648__$1);
var path_match_40655 = shadow.cljs.devtools.client.browser.match_paths(node_40654.getAttribute("href"),path);
if(cljs.core.truth_(path_match_40655)){
var new_link_40656 = (function (){var G__40586 = node_40654.cloneNode(true);
G__40586.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_40655),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__40586;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_40655], 0));

goog.dom.insertSiblingAfter(new_link_40656,node_40654);

goog.dom.removeNode(node_40654);


var G__40657 = cljs.core.next(seq__40573_40648__$1);
var G__40658 = null;
var G__40659 = (0);
var G__40660 = (0);
seq__40573_40632 = G__40657;
chunk__40576_40633 = G__40658;
count__40577_40634 = G__40659;
i__40578_40635 = G__40660;
continue;
} else {
var G__40661 = cljs.core.next(seq__40573_40648__$1);
var G__40662 = null;
var G__40663 = (0);
var G__40664 = (0);
seq__40573_40632 = G__40661;
chunk__40576_40633 = G__40662;
count__40577_40634 = G__40663;
i__40578_40635 = G__40664;
continue;
}
}
} else {
}
}
break;
}


var G__40665 = cljs.core.next(seq__40557__$1);
var G__40666 = null;
var G__40667 = (0);
var G__40668 = (0);
seq__40557 = G__40665;
chunk__40559 = G__40666;
count__40560 = G__40667;
i__40561 = G__40668;
continue;
} else {
var G__40669 = cljs.core.next(seq__40557__$1);
var G__40670 = null;
var G__40671 = (0);
var G__40672 = (0);
seq__40557 = G__40669;
chunk__40559 = G__40670;
count__40560 = G__40671;
i__40561 = G__40672;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__40675){
var map__40677 = p__40675;
var map__40677__$1 = ((((!((map__40677 == null)))?(((((map__40677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40677.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40677):map__40677);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40677__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40677__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call(((function (map__40677,map__40677__$1,id,js){
return (function (){
return eval(js);
});})(map__40677,map__40677__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__40682){
var map__40683 = p__40682;
var map__40683__$1 = ((((!((map__40683 == null)))?(((((map__40683.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40683.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40683):map__40683);
var msg = map__40683__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40683__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40683__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40683__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40683__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__40683,map__40683__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__40689){
var map__40690 = p__40689;
var map__40690__$1 = ((((!((map__40690 == null)))?(((((map__40690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40690):map__40690);
var src = map__40690__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40690__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__3938__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__3938__auto__;
}
});})(map__40683,map__40683__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,((function (sources_to_load,map__40683,map__40683__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
});})(sources_to_load,map__40683,map__40683__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__40706){
var map__40707 = p__40706;
var map__40707__$1 = ((((!((map__40707 == null)))?(((((map__40707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40707):map__40707);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40707__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40707__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(repl_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603),new cljs.core.Keyword(null,"ns","ns",441598760)], null)));

return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__40707,map__40707__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

return shadow.cljs.devtools.client.browser.devtools_msg("REPL init successful");
});})(map__40707,map__40707__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__40716){
var map__40717 = p__40716;
var map__40717__$1 = ((((!((map__40717 == null)))?(((((map__40717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40717):map__40717);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40717__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40717__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,ns);

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__40723){
var map__40724 = p__40723;
var map__40724__$1 = ((((!((map__40724 == null)))?(((((map__40724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40724.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40724):map__40724);
var msg = map__40724__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40724__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__40726 = type;
var G__40726__$1 = (((G__40726 instanceof cljs.core.Keyword))?G__40726.fqn:null);
switch (G__40726__$1) {
case "asset-watch":
return shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
return shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
return shadow.cljs.devtools.client.browser.repl_require(msg);

break;
case "repl/set-ns":
return shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
return shadow.cljs.devtools.client.browser.repl_init(msg);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

return shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

return shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
return shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

return shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":
return null;

break;
case "client/stale":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"\" not running"].join(''));

break;
default:
return new cljs.core.Keyword(null,"ignored","ignored",1227374526);

}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
var G__40728 = ["http",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((shadow.cljs.devtools.client.env.ssl)?"s":null)),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_host),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/browser"].join('');
var G__40729 = ((function (G__40728){
return (function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
});})(G__40728))
;
var G__40730 = "POST";
var G__40731 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0));
var G__40732 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__40728,G__40729,G__40730,G__40731,G__40732);
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)], 0)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__3949__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_();
});})(print_fn,ws_url,socket))
;

socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
});})(print_fn,ws_url,socket))
;

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
}catch (e40735){var e = e40735;
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("WebSocket setup failed",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5457__auto___40736 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto___40736)){
var s_40737 = temp__5457__auto___40736;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

s_40737.onclose = ((function (s_40737,temp__5457__auto___40736){
return (function (e){
return null;
});})(s_40737,temp__5457__auto___40736))
;

s_40737.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
return s.close();
} else {
return null;
}
}));

setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
