goog.provide('rf_utils.core');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('akiroz.re_frame.storage');
goog.require('re_frame.core');
goog.require('re_frame.db');
rf_utils.core.collify = (function rf_utils$core$collify(x){
if(cljs.core.map_QMARK_(x)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
} else {
if(cljs.core.coll_QMARK_(x)){
return x;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);
}
}
});
/**
 * Given a subscription, call on-change-fn when it changes, passing the
 *   old-value and the new-value. Returns an unwatch function for cleanup. This is
 *   basically a convenience function around add-watch/remove-watch on re-frame
 *   subscriptions.
 */
rf_utils.core.watch_sub = (function rf_utils$core$watch_sub(sub,on_change_fn){
var kw = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("SUB"));
cljs.core.add_watch(sub,kw,((function (kw){
return (function (_,___$1,old_val,new_val){
return (on_change_fn.cljs$core$IFn$_invoke$arity$2 ? on_change_fn.cljs$core$IFn$_invoke$arity$2(old_val,new_val) : on_change_fn.call(null,old_val,new_val));
});})(kw))
);

return ((function (kw){
return (function (){
return cljs.core.remove_watch(sub,kw);
});
;})(kw))
});
/**
 * A re-frame interceptor that, after an event, will persist to local storage
 *   anything in the app-db that exists under the `:local-storage` key. If the
 *   `:sync-before` flag is passed, the interceptor will read from local storage
 *   and reset the value at the `:local-storage` key to what was read before
 *   running the event handler.
 */
rf_utils.core.local_storage = (function rf_utils$core$local_storage(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43490 = arguments.length;
var i__4532__auto___43491 = (0);
while(true){
if((i__4532__auto___43491 < len__4531__auto___43490)){
args__4534__auto__.push((arguments[i__4532__auto___43491]));

var G__43492 = (i__4532__auto___43491 + (1));
i__4532__auto___43491 = G__43492;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.local_storage.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.local_storage.cljs$core$IFn$_invoke$arity$variadic = (function (p__43477){
var vec__43478 = p__43477;
var flag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43478,(0),null);
var store_key = new cljs.core.Keyword(null,"wf-app-db-persistent","wf-app-db-persistent",814791649);
var db_ls_key = new cljs.core.Keyword(null,"local-storage","local-storage",-1301104068);
akiroz.re_frame.storage.register_store(store_key);

var G__43481 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__43482 = new cljs.core.Keyword(null,"local-storage","local-storage",-1301104068);
var G__43483 = new cljs.core.Keyword(null,"before","before",-1633692388);
var G__43484 = ((function (G__43481,G__43482,G__43483,store_key,db_ls_key,vec__43478,flag){
return (function (context){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(flag,new cljs.core.Keyword(null,"sync-before","sync-before",883015193))){
return cljs.core.assoc_in(context,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coeffects","coeffects",497912985),new cljs.core.Keyword(null,"db","db",993250759),db_ls_key], null),akiroz.re_frame.storage._LT__store(store_key));
} else {
return context;
}
});})(G__43481,G__43482,G__43483,store_key,db_ls_key,vec__43478,flag))
;
var G__43485 = new cljs.core.Keyword(null,"after","after",594996914);
var G__43486 = ((function (G__43481,G__43482,G__43483,G__43484,G__43485,store_key,db_ls_key,vec__43478,flag){
return (function (context){
var temp__5457__auto___43495 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(context,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"effects","effects",-282369292),new cljs.core.Keyword(null,"db","db",993250759),db_ls_key], null));
if(cljs.core.truth_(temp__5457__auto___43495)){
var value_43496 = temp__5457__auto___43495;
akiroz.re_frame.storage.__GT_store(store_key,value_43496);
} else {
}

return context;
});})(G__43481,G__43482,G__43483,G__43484,G__43485,store_key,db_ls_key,vec__43478,flag))
;
return (re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$6 ? re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$6(G__43481,G__43482,G__43483,G__43484,G__43485,G__43486) : re_frame.core.__GT_interceptor.call(null,G__43481,G__43482,G__43483,G__43484,G__43485,G__43486));
});

rf_utils.core.local_storage.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.local_storage.cljs$lang$applyTo = (function (seq43476){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43476));
});

/**
 * Listen to a re-frame subscription, so we can more easily use it when writing
 *   Reagent components. Probably don't want to use this inside of a lazy `seq`
 *   (for, map, etc.). cf: https://goo.gl/MWsDz5
 */
rf_utils.core.listen = (function rf_utils$core$listen(qv){
return cljs.core.deref((function (){var G__43497 = rf_utils.core.collify(qv);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43497) : re_frame.core.subscribe.call(null,G__43497));
})());
});
var G__43498_43504 = new cljs.core.Keyword("rf-utils.core","app-db","rf-utils.core/app-db",805324455);
var G__43499_43505 = ((function (G__43498_43504){
return (function (db,_){
return db;
});})(G__43498_43504))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2(G__43498_43504,G__43499_43505) : re_frame.core.reg_sub.call(null,G__43498_43504,G__43499_43505));
var G__43507_43513 = new cljs.core.Keyword("rf-utils.core","get","rf-utils.core/get",1809481808);
var G__43508_43514 = ((function (G__43507_43513){
return (function (db,p__43509){
var vec__43510 = p__43509;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43510,(0),null);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43510,(1),null);
var not_found = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43510,(2),null);
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(db,k,not_found);
});})(G__43507_43513))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2(G__43507_43513,G__43508_43514) : re_frame.core.reg_sub.call(null,G__43507_43513,G__43508_43514));
/**
 * Read a value from db by `k`, `not-found` or `nil` if value not present.
 */
rf_utils.core.get = (function rf_utils$core$get(var_args){
var G__43517 = arguments.length;
switch (G__43517) {
case 1:
return rf_utils.core.get.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rf_utils.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rf_utils.core.get.cljs$core$IFn$_invoke$arity$1 = (function (k){
return rf_utils.core.listen(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rf-utils.core","get","rf-utils.core/get",1809481808),k], null));
});

rf_utils.core.get.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
return rf_utils.core.listen(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rf-utils.core","get","rf-utils.core/get",1809481808),k,not_found], null));
});

rf_utils.core.get.cljs$lang$maxFixedArity = 2;

var G__43522_43543 = new cljs.core.Keyword("rf-utils.core","get-in","rf-utils.core/get-in",771118211);
var G__43523_43544 = ((function (G__43522_43543){
return (function (p__43525){
var vec__43526 = p__43525;
var seq__43527 = cljs.core.seq(vec__43526);
var first__43528 = cljs.core.first(seq__43527);
var seq__43527__$1 = cljs.core.next(seq__43527);
var _ = first__43528;
var first__43528__$1 = cljs.core.first(seq__43527__$1);
var seq__43527__$2 = cljs.core.next(seq__43527__$1);
var path = first__43528__$1;
var vec__43529 = seq__43527__$2;
var not_found = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43529,(0),null);
if((cljs.core.count(path) <= (1))){
return re_frame.db.app_db;
} else {
var G__43532 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rf-utils.core","get-in","rf-utils.core/get-in",771118211),cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(path),not_found], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43532) : re_frame.core.subscribe.call(null,G__43532));
}
});})(G__43522_43543))
;
var G__43524_43545 = ((function (G__43522_43543,G__43523_43544){
return (function (parent,p__43533){
var vec__43536 = p__43533;
var seq__43537 = cljs.core.seq(vec__43536);
var first__43538 = cljs.core.first(seq__43537);
var seq__43537__$1 = cljs.core.next(seq__43537);
var _ = first__43538;
var first__43538__$1 = cljs.core.first(seq__43537__$1);
var seq__43537__$2 = cljs.core.next(seq__43537__$1);
var path = first__43538__$1;
var vec__43539 = seq__43537__$2;
var not_found = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43539,(0),null);
if(cljs.core.empty_QMARK_(path)){
return parent;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(parent,cljs.core.last(path),not_found);
}
});})(G__43522_43543,G__43523_43544))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$3 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$3(G__43522_43543,G__43523_43544,G__43524_43545) : re_frame.core.reg_sub.call(null,G__43522_43543,G__43523_43544,G__43524_43545));
/**
 * Read a value from db by `path`, `not-found` or `nil` if value not present.
 */
rf_utils.core.get_in = (function rf_utils$core$get_in(var_args){
var G__43552 = arguments.length;
switch (G__43552) {
case 1:
return rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$1 = (function (path){
return rf_utils.core.listen(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rf-utils.core","get-in","rf-utils.core/get-in",771118211),path], null));
});

rf_utils.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (path,not_found){
return rf_utils.core.listen(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rf-utils.core","get-in","rf-utils.core/get-in",771118211),path,not_found], null));
});

rf_utils.core.get_in.cljs$lang$maxFixedArity = 2;

rf_utils.core.dispatch_into = (function rf_utils$core$dispatch_into(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43562 = arguments.length;
var i__4532__auto___43563 = (0);
while(true){
if((i__4532__auto___43563 < len__4531__auto___43562)){
args__4534__auto__.push((arguments[i__4532__auto___43563]));

var G__43564 = (i__4532__auto___43563 + (1));
i__4532__auto___43563 = G__43564;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rf_utils.core.dispatch_into.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rf_utils.core.dispatch_into.cljs$core$IFn$_invoke$arity$variadic = (function (k,args,p__43557){
var vec__43558 = p__43557;
var sync_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43558,(0),null);
var disp_fn = (cljs.core.truth_(sync_QMARK_)?re_frame.core.dispatch_sync:re_frame.core.dispatch);
var G__43561 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),args);
return (disp_fn.cljs$core$IFn$_invoke$arity$1 ? disp_fn.cljs$core$IFn$_invoke$arity$1(G__43561) : disp_fn.call(null,G__43561));
});

rf_utils.core.dispatch_into.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rf_utils.core.dispatch_into.cljs$lang$applyTo = (function (seq43554){
var G__43555 = cljs.core.first(seq43554);
var seq43554__$1 = cljs.core.next(seq43554);
var G__43556 = cljs.core.first(seq43554__$1);
var seq43554__$2 = cljs.core.next(seq43554__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43555,G__43556,seq43554__$2);
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rf-utils.core","assoc","rf-utils.core/assoc",454492588),(function (db,p__43565){
var vec__43566 = p__43565;
var seq__43567 = cljs.core.seq(vec__43566);
var first__43568 = cljs.core.first(seq__43567);
var seq__43567__$1 = cljs.core.next(seq__43567);
var _ = first__43568;
var kvs = seq__43567__$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,db,kvs);
}));
/**
 * Applies assoc to app-db with `args`.
 */
rf_utils.core.assoc = (function rf_utils$core$assoc(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43570 = arguments.length;
var i__4532__auto___43571 = (0);
while(true){
if((i__4532__auto___43571 < len__4531__auto___43570)){
args__4534__auto__.push((arguments[i__4532__auto___43571]));

var G__43572 = (i__4532__auto___43571 + (1));
i__4532__auto___43571 = G__43572;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.assoc.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","assoc","rf-utils.core/assoc",454492588),args);
});

rf_utils.core.assoc.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.assoc.cljs$lang$applyTo = (function (seq43569){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43569));
});

/**
 * Synchronously applies assoc to app-db with `args`. Should only be used to
 *   init state.
 */
rf_utils.core.assoc_sync = (function rf_utils$core$assoc_sync(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43574 = arguments.length;
var i__4532__auto___43575 = (0);
while(true){
if((i__4532__auto___43575 < len__4531__auto___43574)){
args__4534__auto__.push((arguments[i__4532__auto___43575]));

var G__43576 = (i__4532__auto___43575 + (1));
i__4532__auto___43575 = G__43576;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.assoc_sync.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.assoc_sync.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("rf-utils.core","assoc","rf-utils.core/assoc",454492588),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([true], 0));
});

rf_utils.core.assoc_sync.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.assoc_sync.cljs$lang$applyTo = (function (seq43573){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43573));
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("rf-utils.core","assoc-in","rf-utils.core/assoc-in",-1699059851),rf_utils.core.local_storage(),(function (db,p__43577){
var vec__43578 = p__43577;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43578,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43578,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43578,(2),null);
return cljs.core.assoc_in(db,path,v);
}));
/**
 * Applies assoc-in to app-db with `args`.
 */
rf_utils.core.assoc_in = (function rf_utils$core$assoc_in(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43582 = arguments.length;
var i__4532__auto___43583 = (0);
while(true){
if((i__4532__auto___43583 < len__4531__auto___43582)){
args__4534__auto__.push((arguments[i__4532__auto___43583]));

var G__43584 = (i__4532__auto___43583 + (1));
i__4532__auto___43583 = G__43584;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.assoc_in.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.assoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","assoc-in","rf-utils.core/assoc-in",-1699059851),args);
});

rf_utils.core.assoc_in.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.assoc_in.cljs$lang$applyTo = (function (seq43581){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43581));
});

/**
 * Synchronously applies assoc-in to app-db with `args`. Should only be used
 *   to init state.
 */
rf_utils.core.assoc_in_sync = (function rf_utils$core$assoc_in_sync(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43586 = arguments.length;
var i__4532__auto___43587 = (0);
while(true){
if((i__4532__auto___43587 < len__4531__auto___43586)){
args__4534__auto__.push((arguments[i__4532__auto___43587]));

var G__43588 = (i__4532__auto___43587 + (1));
i__4532__auto___43587 = G__43588;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.assoc_in_sync.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.assoc_in_sync.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("rf-utils.core","assoc-in","rf-utils.core/assoc-in",-1699059851),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([true], 0));
});

rf_utils.core.assoc_in_sync.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.assoc_in_sync.cljs$lang$applyTo = (function (seq43585){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43585));
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rf-utils.core","update","rf-utils.core/update",1135228605),(function (db,p__43589){
var vec__43590 = p__43589;
var seq__43591 = cljs.core.seq(vec__43590);
var first__43592 = cljs.core.first(seq__43591);
var seq__43591__$1 = cljs.core.next(seq__43591);
var _ = first__43592;
var first__43592__$1 = cljs.core.first(seq__43591__$1);
var seq__43591__$2 = cljs.core.next(seq__43591__$1);
var k = first__43592__$1;
var first__43592__$2 = cljs.core.first(seq__43591__$2);
var seq__43591__$3 = cljs.core.next(seq__43591__$2);
var f = first__43592__$2;
var args = seq__43591__$3;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update,db,k,f,args);
}));
/**
 * Applies update to app-db with `args`.
 */
rf_utils.core.update = (function rf_utils$core$update(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43594 = arguments.length;
var i__4532__auto___43595 = (0);
while(true){
if((i__4532__auto___43595 < len__4531__auto___43594)){
args__4534__auto__.push((arguments[i__4532__auto___43595]));

var G__43596 = (i__4532__auto___43595 + (1));
i__4532__auto___43595 = G__43596;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.update.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","update","rf-utils.core/update",1135228605),args);
});

rf_utils.core.update.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.update.cljs$lang$applyTo = (function (seq43593){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43593));
});

/**
 * Applies update to app-db with `args`.
 */
rf_utils.core.update_sync = (function rf_utils$core$update_sync(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43598 = arguments.length;
var i__4532__auto___43599 = (0);
while(true){
if((i__4532__auto___43599 < len__4531__auto___43598)){
args__4534__auto__.push((arguments[i__4532__auto___43599]));

var G__43600 = (i__4532__auto___43599 + (1));
i__4532__auto___43599 = G__43600;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.update_sync.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.update_sync.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("rf-utils.core","update","rf-utils.core/update",1135228605),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([true], 0));
});

rf_utils.core.update_sync.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.update_sync.cljs$lang$applyTo = (function (seq43597){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43597));
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("rf-utils.core","update-in","rf-utils.core/update-in",1136039729),rf_utils.core.local_storage(),(function (db,p__43601){
var vec__43602 = p__43601;
var seq__43603 = cljs.core.seq(vec__43602);
var first__43604 = cljs.core.first(seq__43603);
var seq__43603__$1 = cljs.core.next(seq__43603);
var _ = first__43604;
var first__43604__$1 = cljs.core.first(seq__43603__$1);
var seq__43603__$2 = cljs.core.next(seq__43603__$1);
var path = first__43604__$1;
var first__43604__$2 = cljs.core.first(seq__43603__$2);
var seq__43603__$3 = cljs.core.next(seq__43603__$2);
var f = first__43604__$2;
var args = seq__43603__$3;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in,db,path,f,args);
}));
/**
 * Applies update-in to app-db with `args`.
 */
rf_utils.core.update_in = (function rf_utils$core$update_in(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43606 = arguments.length;
var i__4532__auto___43607 = (0);
while(true){
if((i__4532__auto___43607 < len__4531__auto___43606)){
args__4534__auto__.push((arguments[i__4532__auto___43607]));

var G__43608 = (i__4532__auto___43607 + (1));
i__4532__auto___43607 = G__43608;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.update_in.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","update-in","rf-utils.core/update-in",1136039729),args);
});

rf_utils.core.update_in.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.update_in.cljs$lang$applyTo = (function (seq43605){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43605));
});

/**
 * Applies update-in to app-db with `args`.
 */
rf_utils.core.update_in_sync = (function rf_utils$core$update_in_sync(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43610 = arguments.length;
var i__4532__auto___43611 = (0);
while(true){
if((i__4532__auto___43611 < len__4531__auto___43610)){
args__4534__auto__.push((arguments[i__4532__auto___43611]));

var G__43612 = (i__4532__auto___43611 + (1));
i__4532__auto___43611 = G__43612;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.update_in_sync.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.update_in_sync.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("rf-utils.core","update-in","rf-utils.core/update-in",1136039729),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([true], 0));
});

rf_utils.core.update_in_sync.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.update_in_sync.cljs$lang$applyTo = (function (seq43609){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43609));
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rf-utils.core","dissoc","rf-utils.core/dissoc",-657949656),(function (db,p__43613){
var vec__43614 = p__43613;
var seq__43615 = cljs.core.seq(vec__43614);
var first__43616 = cljs.core.first(seq__43615);
var seq__43615__$1 = cljs.core.next(seq__43615);
var _ = first__43616;
var ks = seq__43615__$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,db,ks);
}));
/**
 * Applies dissoc to app-db with `args`.
 */
rf_utils.core.dissoc = (function rf_utils$core$dissoc(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43618 = arguments.length;
var i__4532__auto___43619 = (0);
while(true){
if((i__4532__auto___43619 < len__4531__auto___43618)){
args__4534__auto__.push((arguments[i__4532__auto___43619]));

var G__43620 = (i__4532__auto___43619 + (1));
i__4532__auto___43619 = G__43620;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","dissoc","rf-utils.core/dissoc",-657949656),args);
});

rf_utils.core.dissoc.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.dissoc.cljs$lang$applyTo = (function (seq43617){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43617));
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("rf-utils.core","dissoc-in","rf-utils.core/dissoc-in",-1937614459),rf_utils.core.local_storage(),(function (db,p__43621){
var vec__43622 = p__43621;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43622,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43622,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,cljs.core.butlast(path),cljs.core.dissoc,cljs.core.last(path));
}));
/**
 * Applies dissoc-in to app-db with `args`.
 */
rf_utils.core.dissoc_in = (function rf_utils$core$dissoc_in(var_args){
var args__4534__auto__ = [];
var len__4531__auto___43626 = arguments.length;
var i__4532__auto___43627 = (0);
while(true){
if((i__4532__auto___43627 < len__4531__auto___43626)){
args__4534__auto__.push((arguments[i__4532__auto___43627]));

var G__43628 = (i__4532__auto___43627 + (1));
i__4532__auto___43627 = G__43628;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return rf_utils.core.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

rf_utils.core.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","dissoc-in","rf-utils.core/dissoc-in",-1937614459),args);
});

rf_utils.core.dissoc_in.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
rf_utils.core.dissoc_in.cljs$lang$applyTo = (function (seq43625){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43625));
});

re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rf-utils.core","reset","rf-utils.core/reset",-678784145),(function (db,_){
console.warn("Resetting store");

return cljs.core.empty(db);
}));
/**
 * Clears the store. Useful for testing.
 */
rf_utils.core.reset = (function rf_utils$core$reset(){
return rf_utils.core.dispatch_into(new cljs.core.Keyword("rf-utils.core","reset","rf-utils.core/reset",-678784145),null);
});
/**
 * Same thing as lunar.lib.util/watch-sub, but allows you to pass a get or get-in
 *   value instead of a full subscription, so that it feels more like all the
 *   other utils.
 */
rf_utils.core.watch = (function rf_utils$core$watch(path,on_change_fn){
var p = ((cljs.core.vector_QMARK_(path))?path:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [path], null));
var sub = (function (){var G__43629 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rf-utils.core","get-in","rf-utils.core/get-in",771118211),p], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__43629) : re_frame.core.subscribe.call(null,G__43629));
})();
return rf_utils.core.watch_sub(sub,on_change_fn);
});

//# sourceMappingURL=rf_utils.core.js.map
