goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__35939 = arguments.length;
switch (G__35939) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35940 = (function (f,blockable,meta35941){
this.f = f;
this.blockable = blockable;
this.meta35941 = meta35941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35942,meta35941__$1){
var self__ = this;
var _35942__$1 = this;
return (new cljs.core.async.t_cljs$core$async35940(self__.f,self__.blockable,meta35941__$1));
});

cljs.core.async.t_cljs$core$async35940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35942){
var self__ = this;
var _35942__$1 = this;
return self__.meta35941;
});

cljs.core.async.t_cljs$core$async35940.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35940.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async35940.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async35940.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async35940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta35941","meta35941",-1595272828,null)], null);
});

cljs.core.async.t_cljs$core$async35940.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35940";

cljs.core.async.t_cljs$core$async35940.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async35940");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35940.
 */
cljs.core.async.__GT_t_cljs$core$async35940 = (function cljs$core$async$__GT_t_cljs$core$async35940(f__$1,blockable__$1,meta35941){
return (new cljs.core.async.t_cljs$core$async35940(f__$1,blockable__$1,meta35941));
});

}

return (new cljs.core.async.t_cljs$core$async35940(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__35946 = arguments.length;
switch (G__35946) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__35952 = arguments.length;
switch (G__35952) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__35957 = arguments.length;
switch (G__35957) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_35959 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_35959) : fn1.call(null,val_35959));
} else {
cljs.core.async.impl.dispatch.run(((function (val_35959,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_35959) : fn1.call(null,val_35959));
});})(val_35959,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__35961 = arguments.length;
switch (G__35961) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___35973 = n;
var x_35974 = (0);
while(true){
if((x_35974 < n__4408__auto___35973)){
(a[x_35974] = (0));

var G__35975 = (x_35974 + (1));
x_35974 = G__35975;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__35976 = (i + (1));
i = G__35976;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35977 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35977 = (function (flag,meta35978){
this.flag = flag;
this.meta35978 = meta35978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_35979,meta35978__$1){
var self__ = this;
var _35979__$1 = this;
return (new cljs.core.async.t_cljs$core$async35977(self__.flag,meta35978__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async35977.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_35979){
var self__ = this;
var _35979__$1 = this;
return self__.meta35978;
});})(flag))
;

cljs.core.async.t_cljs$core$async35977.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35977.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async35977.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async35977.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async35977.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta35978","meta35978",-1040886745,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async35977.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35977.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35977";

cljs.core.async.t_cljs$core$async35977.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async35977");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35977.
 */
cljs.core.async.__GT_t_cljs$core$async35977 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async35977(flag__$1,meta35978){
return (new cljs.core.async.t_cljs$core$async35977(flag__$1,meta35978));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async35977(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async35980 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35980 = (function (flag,cb,meta35981){
this.flag = flag;
this.cb = cb;
this.meta35981 = meta35981;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35980.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35982,meta35981__$1){
var self__ = this;
var _35982__$1 = this;
return (new cljs.core.async.t_cljs$core$async35980(self__.flag,self__.cb,meta35981__$1));
});

cljs.core.async.t_cljs$core$async35980.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35982){
var self__ = this;
var _35982__$1 = this;
return self__.meta35981;
});

cljs.core.async.t_cljs$core$async35980.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35980.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async35980.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async35980.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async35980.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta35981","meta35981",-2115922599,null)], null);
});

cljs.core.async.t_cljs$core$async35980.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35980.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35980";

cljs.core.async.t_cljs$core$async35980.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async35980");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35980.
 */
cljs.core.async.__GT_t_cljs$core$async35980 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async35980(flag__$1,cb__$1,meta35981){
return (new cljs.core.async.t_cljs$core$async35980(flag__$1,cb__$1,meta35981));
});

}

return (new cljs.core.async.t_cljs$core$async35980(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__35983_SHARP_){
var G__35985 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35983_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__35985) : fret.call(null,G__35985));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__35984_SHARP_){
var G__35986 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35984_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__35986) : fret.call(null,G__35986));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__35987 = (i + (1));
i = G__35987;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___35993 = arguments.length;
var i__4532__auto___35994 = (0);
while(true){
if((i__4532__auto___35994 < len__4531__auto___35993)){
args__4534__auto__.push((arguments[i__4532__auto___35994]));

var G__35995 = (i__4532__auto___35994 + (1));
i__4532__auto___35994 = G__35995;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__35990){
var map__35991 = p__35990;
var map__35991__$1 = ((((!((map__35991 == null)))?(((((map__35991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35991):map__35991);
var opts = map__35991__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq35988){
var G__35989 = cljs.core.first(seq35988);
var seq35988__$1 = cljs.core.next(seq35988);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35989,seq35988__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__36008 = arguments.length;
switch (G__36008) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__35868__auto___36094 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___36094){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___36094){
return (function (state_36054){
var state_val_36055 = (state_36054[(1)]);
if((state_val_36055 === (7))){
var inst_36042 = (state_36054[(2)]);
var state_36054__$1 = state_36054;
var statearr_36056_36095 = state_36054__$1;
(statearr_36056_36095[(2)] = inst_36042);

(statearr_36056_36095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (1))){
var state_36054__$1 = state_36054;
var statearr_36057_36096 = state_36054__$1;
(statearr_36057_36096[(2)] = null);

(statearr_36057_36096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (4))){
var inst_36022 = (state_36054[(7)]);
var inst_36022__$1 = (state_36054[(2)]);
var inst_36023 = (inst_36022__$1 == null);
var state_36054__$1 = (function (){var statearr_36058 = state_36054;
(statearr_36058[(7)] = inst_36022__$1);

return statearr_36058;
})();
if(cljs.core.truth_(inst_36023)){
var statearr_36059_36097 = state_36054__$1;
(statearr_36059_36097[(1)] = (5));

} else {
var statearr_36060_36098 = state_36054__$1;
(statearr_36060_36098[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (13))){
var state_36054__$1 = state_36054;
var statearr_36064_36099 = state_36054__$1;
(statearr_36064_36099[(2)] = null);

(statearr_36064_36099[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (6))){
var inst_36022 = (state_36054[(7)]);
var state_36054__$1 = state_36054;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36054__$1,(11),to,inst_36022);
} else {
if((state_val_36055 === (3))){
var inst_36044 = (state_36054[(2)]);
var state_36054__$1 = state_36054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36054__$1,inst_36044);
} else {
if((state_val_36055 === (12))){
var state_36054__$1 = state_36054;
var statearr_36065_36100 = state_36054__$1;
(statearr_36065_36100[(2)] = null);

(statearr_36065_36100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (2))){
var state_36054__$1 = state_36054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36054__$1,(4),from);
} else {
if((state_val_36055 === (11))){
var inst_36035 = (state_36054[(2)]);
var state_36054__$1 = state_36054;
if(cljs.core.truth_(inst_36035)){
var statearr_36066_36107 = state_36054__$1;
(statearr_36066_36107[(1)] = (12));

} else {
var statearr_36067_36108 = state_36054__$1;
(statearr_36067_36108[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (9))){
var state_36054__$1 = state_36054;
var statearr_36068_36109 = state_36054__$1;
(statearr_36068_36109[(2)] = null);

(statearr_36068_36109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (5))){
var state_36054__$1 = state_36054;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36069_36110 = state_36054__$1;
(statearr_36069_36110[(1)] = (8));

} else {
var statearr_36073_36111 = state_36054__$1;
(statearr_36073_36111[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (14))){
var inst_36040 = (state_36054[(2)]);
var state_36054__$1 = state_36054;
var statearr_36079_36112 = state_36054__$1;
(statearr_36079_36112[(2)] = inst_36040);

(statearr_36079_36112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (10))){
var inst_36032 = (state_36054[(2)]);
var state_36054__$1 = state_36054;
var statearr_36082_36113 = state_36054__$1;
(statearr_36082_36113[(2)] = inst_36032);

(statearr_36082_36113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36055 === (8))){
var inst_36026 = cljs.core.async.close_BANG_(to);
var state_36054__$1 = state_36054;
var statearr_36083_36114 = state_36054__$1;
(statearr_36083_36114[(2)] = inst_36026);

(statearr_36083_36114[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___36094))
;
return ((function (switch__35726__auto__,c__35868__auto___36094){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_36086 = [null,null,null,null,null,null,null,null];
(statearr_36086[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_36086[(1)] = (1));

return statearr_36086;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_36054){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36054);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36087){if((e36087 instanceof Object)){
var ex__35730__auto__ = e36087;
var statearr_36088_36115 = state_36054;
(statearr_36088_36115[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36054);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36087;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36116 = state_36054;
state_36054 = G__36116;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_36054){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_36054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___36094))
})();
var state__35870__auto__ = (function (){var statearr_36089 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36089[(6)] = c__35868__auto___36094);

return statearr_36089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___36094))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__36117){
var vec__36118 = p__36117;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36118,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36118,(1),null);
var job = vec__36118;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__35868__auto___36329 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___36329,res,vec__36118,v,p,job,jobs,results){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___36329,res,vec__36118,v,p,job,jobs,results){
return (function (state_36128){
var state_val_36129 = (state_36128[(1)]);
if((state_val_36129 === (1))){
var state_36128__$1 = state_36128;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36128__$1,(2),res,v);
} else {
if((state_val_36129 === (2))){
var inst_36125 = (state_36128[(2)]);
var inst_36126 = cljs.core.async.close_BANG_(res);
var state_36128__$1 = (function (){var statearr_36130 = state_36128;
(statearr_36130[(7)] = inst_36125);

return statearr_36130;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36128__$1,inst_36126);
} else {
return null;
}
}
});})(c__35868__auto___36329,res,vec__36118,v,p,job,jobs,results))
;
return ((function (switch__35726__auto__,c__35868__auto___36329,res,vec__36118,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0 = (function (){
var statearr_36131 = [null,null,null,null,null,null,null,null];
(statearr_36131[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__);

(statearr_36131[(1)] = (1));

return statearr_36131;
});
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1 = (function (state_36128){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36128);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36132){if((e36132 instanceof Object)){
var ex__35730__auto__ = e36132;
var statearr_36133_36333 = state_36128;
(statearr_36133_36333[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36132;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36334 = state_36128;
state_36128 = G__36334;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = function(state_36128){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1.call(this,state_36128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___36329,res,vec__36118,v,p,job,jobs,results))
})();
var state__35870__auto__ = (function (){var statearr_36134 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36134[(6)] = c__35868__auto___36329);

return statearr_36134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___36329,res,vec__36118,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__36135){
var vec__36136 = p__36135;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36136,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36136,(1),null);
var job = vec__36136;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___36335 = n;
var __36336 = (0);
while(true){
if((__36336 < n__4408__auto___36335)){
var G__36139_36337 = type;
var G__36139_36338__$1 = (((G__36139_36337 instanceof cljs.core.Keyword))?G__36139_36337.fqn:null);
switch (G__36139_36338__$1) {
case "compute":
var c__35868__auto___36340 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36336,c__35868__auto___36340,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (__36336,c__35868__auto___36340,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async){
return (function (state_36153){
var state_val_36154 = (state_36153[(1)]);
if((state_val_36154 === (1))){
var state_36153__$1 = state_36153;
var statearr_36155_36349 = state_36153__$1;
(statearr_36155_36349[(2)] = null);

(statearr_36155_36349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36154 === (2))){
var state_36153__$1 = state_36153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36153__$1,(4),jobs);
} else {
if((state_val_36154 === (3))){
var inst_36151 = (state_36153[(2)]);
var state_36153__$1 = state_36153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36153__$1,inst_36151);
} else {
if((state_val_36154 === (4))){
var inst_36143 = (state_36153[(2)]);
var inst_36144 = process(inst_36143);
var state_36153__$1 = state_36153;
if(cljs.core.truth_(inst_36144)){
var statearr_36156_36370 = state_36153__$1;
(statearr_36156_36370[(1)] = (5));

} else {
var statearr_36160_36371 = state_36153__$1;
(statearr_36160_36371[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36154 === (5))){
var state_36153__$1 = state_36153;
var statearr_36161_36372 = state_36153__$1;
(statearr_36161_36372[(2)] = null);

(statearr_36161_36372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36154 === (6))){
var state_36153__$1 = state_36153;
var statearr_36162_36373 = state_36153__$1;
(statearr_36162_36373[(2)] = null);

(statearr_36162_36373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36154 === (7))){
var inst_36149 = (state_36153[(2)]);
var state_36153__$1 = state_36153;
var statearr_36163_36374 = state_36153__$1;
(statearr_36163_36374[(2)] = inst_36149);

(statearr_36163_36374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__36336,c__35868__auto___36340,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async))
;
return ((function (__36336,switch__35726__auto__,c__35868__auto___36340,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0 = (function (){
var statearr_36164 = [null,null,null,null,null,null,null];
(statearr_36164[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__);

(statearr_36164[(1)] = (1));

return statearr_36164;
});
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1 = (function (state_36153){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36153);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36165){if((e36165 instanceof Object)){
var ex__35730__auto__ = e36165;
var statearr_36166_36375 = state_36153;
(statearr_36166_36375[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36153);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36165;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36376 = state_36153;
state_36153 = G__36376;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = function(state_36153){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1.call(this,state_36153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__;
})()
;})(__36336,switch__35726__auto__,c__35868__auto___36340,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async))
})();
var state__35870__auto__ = (function (){var statearr_36167 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36167[(6)] = c__35868__auto___36340);

return statearr_36167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(__36336,c__35868__auto___36340,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async))
);


break;
case "async":
var c__35868__auto___36377 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__36336,c__35868__auto___36377,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (__36336,c__35868__auto___36377,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async){
return (function (state_36180){
var state_val_36181 = (state_36180[(1)]);
if((state_val_36181 === (1))){
var state_36180__$1 = state_36180;
var statearr_36182_36383 = state_36180__$1;
(statearr_36182_36383[(2)] = null);

(statearr_36182_36383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (2))){
var state_36180__$1 = state_36180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36180__$1,(4),jobs);
} else {
if((state_val_36181 === (3))){
var inst_36178 = (state_36180[(2)]);
var state_36180__$1 = state_36180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36180__$1,inst_36178);
} else {
if((state_val_36181 === (4))){
var inst_36170 = (state_36180[(2)]);
var inst_36171 = async(inst_36170);
var state_36180__$1 = state_36180;
if(cljs.core.truth_(inst_36171)){
var statearr_36183_36384 = state_36180__$1;
(statearr_36183_36384[(1)] = (5));

} else {
var statearr_36184_36385 = state_36180__$1;
(statearr_36184_36385[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (5))){
var state_36180__$1 = state_36180;
var statearr_36185_36386 = state_36180__$1;
(statearr_36185_36386[(2)] = null);

(statearr_36185_36386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (6))){
var state_36180__$1 = state_36180;
var statearr_36186_36387 = state_36180__$1;
(statearr_36186_36387[(2)] = null);

(statearr_36186_36387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (7))){
var inst_36176 = (state_36180[(2)]);
var state_36180__$1 = state_36180;
var statearr_36187_36389 = state_36180__$1;
(statearr_36187_36389[(2)] = inst_36176);

(statearr_36187_36389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__36336,c__35868__auto___36377,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async))
;
return ((function (__36336,switch__35726__auto__,c__35868__auto___36377,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0 = (function (){
var statearr_36188 = [null,null,null,null,null,null,null];
(statearr_36188[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__);

(statearr_36188[(1)] = (1));

return statearr_36188;
});
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1 = (function (state_36180){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36180);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36189){if((e36189 instanceof Object)){
var ex__35730__auto__ = e36189;
var statearr_36190_36390 = state_36180;
(statearr_36190_36390[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36189;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36397 = state_36180;
state_36180 = G__36397;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = function(state_36180){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1.call(this,state_36180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__;
})()
;})(__36336,switch__35726__auto__,c__35868__auto___36377,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async))
})();
var state__35870__auto__ = (function (){var statearr_36194 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36194[(6)] = c__35868__auto___36377);

return statearr_36194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(__36336,c__35868__auto___36377,G__36139_36337,G__36139_36338__$1,n__4408__auto___36335,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36139_36338__$1)].join('')));

}

var G__36398 = (__36336 + (1));
__36336 = G__36398;
continue;
} else {
}
break;
}

var c__35868__auto___36399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___36399,jobs,results,process,async){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___36399,jobs,results,process,async){
return (function (state_36216){
var state_val_36217 = (state_36216[(1)]);
if((state_val_36217 === (1))){
var state_36216__$1 = state_36216;
var statearr_36218_36400 = state_36216__$1;
(statearr_36218_36400[(2)] = null);

(statearr_36218_36400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36217 === (2))){
var state_36216__$1 = state_36216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36216__$1,(4),from);
} else {
if((state_val_36217 === (3))){
var inst_36214 = (state_36216[(2)]);
var state_36216__$1 = state_36216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36216__$1,inst_36214);
} else {
if((state_val_36217 === (4))){
var inst_36197 = (state_36216[(7)]);
var inst_36197__$1 = (state_36216[(2)]);
var inst_36198 = (inst_36197__$1 == null);
var state_36216__$1 = (function (){var statearr_36219 = state_36216;
(statearr_36219[(7)] = inst_36197__$1);

return statearr_36219;
})();
if(cljs.core.truth_(inst_36198)){
var statearr_36220_36401 = state_36216__$1;
(statearr_36220_36401[(1)] = (5));

} else {
var statearr_36221_36402 = state_36216__$1;
(statearr_36221_36402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36217 === (5))){
var inst_36200 = cljs.core.async.close_BANG_(jobs);
var state_36216__$1 = state_36216;
var statearr_36222_36403 = state_36216__$1;
(statearr_36222_36403[(2)] = inst_36200);

(statearr_36222_36403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36217 === (6))){
var inst_36202 = (state_36216[(8)]);
var inst_36197 = (state_36216[(7)]);
var inst_36202__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36204 = [inst_36197,inst_36202__$1];
var inst_36205 = (new cljs.core.PersistentVector(null,2,(5),inst_36203,inst_36204,null));
var state_36216__$1 = (function (){var statearr_36223 = state_36216;
(statearr_36223[(8)] = inst_36202__$1);

return statearr_36223;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36216__$1,(8),jobs,inst_36205);
} else {
if((state_val_36217 === (7))){
var inst_36212 = (state_36216[(2)]);
var state_36216__$1 = state_36216;
var statearr_36224_36404 = state_36216__$1;
(statearr_36224_36404[(2)] = inst_36212);

(statearr_36224_36404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36217 === (8))){
var inst_36202 = (state_36216[(8)]);
var inst_36207 = (state_36216[(2)]);
var state_36216__$1 = (function (){var statearr_36225 = state_36216;
(statearr_36225[(9)] = inst_36207);

return statearr_36225;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36216__$1,(9),results,inst_36202);
} else {
if((state_val_36217 === (9))){
var inst_36209 = (state_36216[(2)]);
var state_36216__$1 = (function (){var statearr_36226 = state_36216;
(statearr_36226[(10)] = inst_36209);

return statearr_36226;
})();
var statearr_36227_36405 = state_36216__$1;
(statearr_36227_36405[(2)] = null);

(statearr_36227_36405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___36399,jobs,results,process,async))
;
return ((function (switch__35726__auto__,c__35868__auto___36399,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0 = (function (){
var statearr_36228 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36228[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__);

(statearr_36228[(1)] = (1));

return statearr_36228;
});
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1 = (function (state_36216){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36216);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36229){if((e36229 instanceof Object)){
var ex__35730__auto__ = e36229;
var statearr_36230_36406 = state_36216;
(statearr_36230_36406[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36229;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36407 = state_36216;
state_36216 = G__36407;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = function(state_36216){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1.call(this,state_36216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___36399,jobs,results,process,async))
})();
var state__35870__auto__ = (function (){var statearr_36231 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36231[(6)] = c__35868__auto___36399);

return statearr_36231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___36399,jobs,results,process,async))
);


var c__35868__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto__,jobs,results,process,async){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto__,jobs,results,process,async){
return (function (state_36281){
var state_val_36282 = (state_36281[(1)]);
if((state_val_36282 === (7))){
var inst_36277 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36283_36408 = state_36281__$1;
(statearr_36283_36408[(2)] = inst_36277);

(statearr_36283_36408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (20))){
var state_36281__$1 = state_36281;
var statearr_36284_36409 = state_36281__$1;
(statearr_36284_36409[(2)] = null);

(statearr_36284_36409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (1))){
var state_36281__$1 = state_36281;
var statearr_36285_36410 = state_36281__$1;
(statearr_36285_36410[(2)] = null);

(statearr_36285_36410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (4))){
var inst_36234 = (state_36281[(7)]);
var inst_36234__$1 = (state_36281[(2)]);
var inst_36235 = (inst_36234__$1 == null);
var state_36281__$1 = (function (){var statearr_36286 = state_36281;
(statearr_36286[(7)] = inst_36234__$1);

return statearr_36286;
})();
if(cljs.core.truth_(inst_36235)){
var statearr_36287_36420 = state_36281__$1;
(statearr_36287_36420[(1)] = (5));

} else {
var statearr_36288_36421 = state_36281__$1;
(statearr_36288_36421[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (15))){
var inst_36259 = (state_36281[(8)]);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36281__$1,(18),to,inst_36259);
} else {
if((state_val_36282 === (21))){
var inst_36272 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36289_36422 = state_36281__$1;
(statearr_36289_36422[(2)] = inst_36272);

(statearr_36289_36422[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (13))){
var inst_36274 = (state_36281[(2)]);
var state_36281__$1 = (function (){var statearr_36290 = state_36281;
(statearr_36290[(9)] = inst_36274);

return statearr_36290;
})();
var statearr_36291_36423 = state_36281__$1;
(statearr_36291_36423[(2)] = null);

(statearr_36291_36423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (6))){
var inst_36234 = (state_36281[(7)]);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36281__$1,(11),inst_36234);
} else {
if((state_val_36282 === (17))){
var inst_36267 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
if(cljs.core.truth_(inst_36267)){
var statearr_36292_36424 = state_36281__$1;
(statearr_36292_36424[(1)] = (19));

} else {
var statearr_36293_36425 = state_36281__$1;
(statearr_36293_36425[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (3))){
var inst_36279 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36281__$1,inst_36279);
} else {
if((state_val_36282 === (12))){
var inst_36256 = (state_36281[(10)]);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36281__$1,(14),inst_36256);
} else {
if((state_val_36282 === (2))){
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36281__$1,(4),results);
} else {
if((state_val_36282 === (19))){
var state_36281__$1 = state_36281;
var statearr_36294_36426 = state_36281__$1;
(statearr_36294_36426[(2)] = null);

(statearr_36294_36426[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (11))){
var inst_36256 = (state_36281[(2)]);
var state_36281__$1 = (function (){var statearr_36295 = state_36281;
(statearr_36295[(10)] = inst_36256);

return statearr_36295;
})();
var statearr_36296_36427 = state_36281__$1;
(statearr_36296_36427[(2)] = null);

(statearr_36296_36427[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (9))){
var state_36281__$1 = state_36281;
var statearr_36297_36428 = state_36281__$1;
(statearr_36297_36428[(2)] = null);

(statearr_36297_36428[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (5))){
var state_36281__$1 = state_36281;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36298_36429 = state_36281__$1;
(statearr_36298_36429[(1)] = (8));

} else {
var statearr_36299_36430 = state_36281__$1;
(statearr_36299_36430[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (14))){
var inst_36261 = (state_36281[(11)]);
var inst_36259 = (state_36281[(8)]);
var inst_36259__$1 = (state_36281[(2)]);
var inst_36260 = (inst_36259__$1 == null);
var inst_36261__$1 = cljs.core.not(inst_36260);
var state_36281__$1 = (function (){var statearr_36300 = state_36281;
(statearr_36300[(11)] = inst_36261__$1);

(statearr_36300[(8)] = inst_36259__$1);

return statearr_36300;
})();
if(inst_36261__$1){
var statearr_36301_36431 = state_36281__$1;
(statearr_36301_36431[(1)] = (15));

} else {
var statearr_36302_36432 = state_36281__$1;
(statearr_36302_36432[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (16))){
var inst_36261 = (state_36281[(11)]);
var state_36281__$1 = state_36281;
var statearr_36308_36433 = state_36281__$1;
(statearr_36308_36433[(2)] = inst_36261);

(statearr_36308_36433[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (10))){
var inst_36253 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36309_36434 = state_36281__$1;
(statearr_36309_36434[(2)] = inst_36253);

(statearr_36309_36434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (18))){
var inst_36264 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36310_36435 = state_36281__$1;
(statearr_36310_36435[(2)] = inst_36264);

(statearr_36310_36435[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36282 === (8))){
var inst_36238 = cljs.core.async.close_BANG_(to);
var state_36281__$1 = state_36281;
var statearr_36311_36436 = state_36281__$1;
(statearr_36311_36436[(2)] = inst_36238);

(statearr_36311_36436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto__,jobs,results,process,async))
;
return ((function (switch__35726__auto__,c__35868__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0 = (function (){
var statearr_36312 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36312[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__);

(statearr_36312[(1)] = (1));

return statearr_36312;
});
var cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1 = (function (state_36281){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36281);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36313){if((e36313 instanceof Object)){
var ex__35730__auto__ = e36313;
var statearr_36314_36440 = state_36281;
(statearr_36314_36440[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36281);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36313;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36441 = state_36281;
state_36281 = G__36441;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__ = function(state_36281){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1.call(this,state_36281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__35727__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto__,jobs,results,process,async))
})();
var state__35870__auto__ = (function (){var statearr_36315 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36315[(6)] = c__35868__auto__);

return statearr_36315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto__,jobs,results,process,async))
);

return c__35868__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__36443 = arguments.length;
switch (G__36443) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__36452 = arguments.length;
switch (G__36452) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__36461 = arguments.length;
switch (G__36461) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__35868__auto___36524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___36524,tc,fc){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___36524,tc,fc){
return (function (state_36487){
var state_val_36488 = (state_36487[(1)]);
if((state_val_36488 === (7))){
var inst_36483 = (state_36487[(2)]);
var state_36487__$1 = state_36487;
var statearr_36492_36525 = state_36487__$1;
(statearr_36492_36525[(2)] = inst_36483);

(statearr_36492_36525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (1))){
var state_36487__$1 = state_36487;
var statearr_36493_36526 = state_36487__$1;
(statearr_36493_36526[(2)] = null);

(statearr_36493_36526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (4))){
var inst_36464 = (state_36487[(7)]);
var inst_36464__$1 = (state_36487[(2)]);
var inst_36465 = (inst_36464__$1 == null);
var state_36487__$1 = (function (){var statearr_36497 = state_36487;
(statearr_36497[(7)] = inst_36464__$1);

return statearr_36497;
})();
if(cljs.core.truth_(inst_36465)){
var statearr_36501_36527 = state_36487__$1;
(statearr_36501_36527[(1)] = (5));

} else {
var statearr_36502_36528 = state_36487__$1;
(statearr_36502_36528[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (13))){
var state_36487__$1 = state_36487;
var statearr_36503_36529 = state_36487__$1;
(statearr_36503_36529[(2)] = null);

(statearr_36503_36529[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (6))){
var inst_36464 = (state_36487[(7)]);
var inst_36470 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36464) : p.call(null,inst_36464));
var state_36487__$1 = state_36487;
if(cljs.core.truth_(inst_36470)){
var statearr_36504_36530 = state_36487__$1;
(statearr_36504_36530[(1)] = (9));

} else {
var statearr_36505_36534 = state_36487__$1;
(statearr_36505_36534[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (3))){
var inst_36485 = (state_36487[(2)]);
var state_36487__$1 = state_36487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36487__$1,inst_36485);
} else {
if((state_val_36488 === (12))){
var state_36487__$1 = state_36487;
var statearr_36506_36535 = state_36487__$1;
(statearr_36506_36535[(2)] = null);

(statearr_36506_36535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (2))){
var state_36487__$1 = state_36487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36487__$1,(4),ch);
} else {
if((state_val_36488 === (11))){
var inst_36464 = (state_36487[(7)]);
var inst_36474 = (state_36487[(2)]);
var state_36487__$1 = state_36487;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36487__$1,(8),inst_36474,inst_36464);
} else {
if((state_val_36488 === (9))){
var state_36487__$1 = state_36487;
var statearr_36507_36536 = state_36487__$1;
(statearr_36507_36536[(2)] = tc);

(statearr_36507_36536[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (5))){
var inst_36467 = cljs.core.async.close_BANG_(tc);
var inst_36468 = cljs.core.async.close_BANG_(fc);
var state_36487__$1 = (function (){var statearr_36508 = state_36487;
(statearr_36508[(8)] = inst_36467);

return statearr_36508;
})();
var statearr_36509_36540 = state_36487__$1;
(statearr_36509_36540[(2)] = inst_36468);

(statearr_36509_36540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (14))){
var inst_36481 = (state_36487[(2)]);
var state_36487__$1 = state_36487;
var statearr_36510_36541 = state_36487__$1;
(statearr_36510_36541[(2)] = inst_36481);

(statearr_36510_36541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (10))){
var state_36487__$1 = state_36487;
var statearr_36511_36542 = state_36487__$1;
(statearr_36511_36542[(2)] = fc);

(statearr_36511_36542[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36488 === (8))){
var inst_36476 = (state_36487[(2)]);
var state_36487__$1 = state_36487;
if(cljs.core.truth_(inst_36476)){
var statearr_36512_36543 = state_36487__$1;
(statearr_36512_36543[(1)] = (12));

} else {
var statearr_36513_36544 = state_36487__$1;
(statearr_36513_36544[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___36524,tc,fc))
;
return ((function (switch__35726__auto__,c__35868__auto___36524,tc,fc){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_36516 = [null,null,null,null,null,null,null,null,null];
(statearr_36516[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_36516[(1)] = (1));

return statearr_36516;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_36487){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36487);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36520){if((e36520 instanceof Object)){
var ex__35730__auto__ = e36520;
var statearr_36521_36548 = state_36487;
(statearr_36521_36548[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36487);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36520;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36549 = state_36487;
state_36487 = G__36549;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_36487){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_36487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___36524,tc,fc))
})();
var state__35870__auto__ = (function (){var statearr_36522 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36522[(6)] = c__35868__auto___36524);

return statearr_36522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___36524,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__35868__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto__){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto__){
return (function (state_36572){
var state_val_36573 = (state_36572[(1)]);
if((state_val_36573 === (7))){
var inst_36568 = (state_36572[(2)]);
var state_36572__$1 = state_36572;
var statearr_36574_36596 = state_36572__$1;
(statearr_36574_36596[(2)] = inst_36568);

(statearr_36574_36596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (1))){
var inst_36550 = init;
var state_36572__$1 = (function (){var statearr_36575 = state_36572;
(statearr_36575[(7)] = inst_36550);

return statearr_36575;
})();
var statearr_36576_36600 = state_36572__$1;
(statearr_36576_36600[(2)] = null);

(statearr_36576_36600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (4))){
var inst_36555 = (state_36572[(8)]);
var inst_36555__$1 = (state_36572[(2)]);
var inst_36556 = (inst_36555__$1 == null);
var state_36572__$1 = (function (){var statearr_36577 = state_36572;
(statearr_36577[(8)] = inst_36555__$1);

return statearr_36577;
})();
if(cljs.core.truth_(inst_36556)){
var statearr_36578_36601 = state_36572__$1;
(statearr_36578_36601[(1)] = (5));

} else {
var statearr_36579_36602 = state_36572__$1;
(statearr_36579_36602[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (6))){
var inst_36550 = (state_36572[(7)]);
var inst_36555 = (state_36572[(8)]);
var inst_36559 = (state_36572[(9)]);
var inst_36559__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_36550,inst_36555) : f.call(null,inst_36550,inst_36555));
var inst_36560 = cljs.core.reduced_QMARK_(inst_36559__$1);
var state_36572__$1 = (function (){var statearr_36580 = state_36572;
(statearr_36580[(9)] = inst_36559__$1);

return statearr_36580;
})();
if(inst_36560){
var statearr_36581_36603 = state_36572__$1;
(statearr_36581_36603[(1)] = (8));

} else {
var statearr_36582_36604 = state_36572__$1;
(statearr_36582_36604[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (3))){
var inst_36570 = (state_36572[(2)]);
var state_36572__$1 = state_36572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36572__$1,inst_36570);
} else {
if((state_val_36573 === (2))){
var state_36572__$1 = state_36572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36572__$1,(4),ch);
} else {
if((state_val_36573 === (9))){
var inst_36559 = (state_36572[(9)]);
var inst_36550 = inst_36559;
var state_36572__$1 = (function (){var statearr_36583 = state_36572;
(statearr_36583[(7)] = inst_36550);

return statearr_36583;
})();
var statearr_36584_36612 = state_36572__$1;
(statearr_36584_36612[(2)] = null);

(statearr_36584_36612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (5))){
var inst_36550 = (state_36572[(7)]);
var state_36572__$1 = state_36572;
var statearr_36589_36613 = state_36572__$1;
(statearr_36589_36613[(2)] = inst_36550);

(statearr_36589_36613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (10))){
var inst_36566 = (state_36572[(2)]);
var state_36572__$1 = state_36572;
var statearr_36590_36619 = state_36572__$1;
(statearr_36590_36619[(2)] = inst_36566);

(statearr_36590_36619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36573 === (8))){
var inst_36559 = (state_36572[(9)]);
var inst_36562 = cljs.core.deref(inst_36559);
var state_36572__$1 = state_36572;
var statearr_36591_36620 = state_36572__$1;
(statearr_36591_36620[(2)] = inst_36562);

(statearr_36591_36620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto__))
;
return ((function (switch__35726__auto__,c__35868__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__35727__auto__ = null;
var cljs$core$async$reduce_$_state_machine__35727__auto____0 = (function (){
var statearr_36592 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36592[(0)] = cljs$core$async$reduce_$_state_machine__35727__auto__);

(statearr_36592[(1)] = (1));

return statearr_36592;
});
var cljs$core$async$reduce_$_state_machine__35727__auto____1 = (function (state_36572){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36572);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36593){if((e36593 instanceof Object)){
var ex__35730__auto__ = e36593;
var statearr_36594_36621 = state_36572;
(statearr_36594_36621[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36593;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36622 = state_36572;
state_36572 = G__36622;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__35727__auto__ = function(state_36572){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__35727__auto____1.call(this,state_36572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__35727__auto____0;
cljs$core$async$reduce_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__35727__auto____1;
return cljs$core$async$reduce_$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto__))
})();
var state__35870__auto__ = (function (){var statearr_36595 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36595[(6)] = c__35868__auto__);

return statearr_36595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto__))
);

return c__35868__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__35868__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto__,f__$1){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto__,f__$1){
return (function (state_36628){
var state_val_36629 = (state_36628[(1)]);
if((state_val_36629 === (1))){
var inst_36623 = cljs.core.async.reduce(f__$1,init,ch);
var state_36628__$1 = state_36628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36628__$1,(2),inst_36623);
} else {
if((state_val_36629 === (2))){
var inst_36625 = (state_36628[(2)]);
var inst_36626 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_36625) : f__$1.call(null,inst_36625));
var state_36628__$1 = state_36628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36628__$1,inst_36626);
} else {
return null;
}
}
});})(c__35868__auto__,f__$1))
;
return ((function (switch__35726__auto__,c__35868__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__35727__auto__ = null;
var cljs$core$async$transduce_$_state_machine__35727__auto____0 = (function (){
var statearr_36630 = [null,null,null,null,null,null,null];
(statearr_36630[(0)] = cljs$core$async$transduce_$_state_machine__35727__auto__);

(statearr_36630[(1)] = (1));

return statearr_36630;
});
var cljs$core$async$transduce_$_state_machine__35727__auto____1 = (function (state_36628){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36628);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36631){if((e36631 instanceof Object)){
var ex__35730__auto__ = e36631;
var statearr_36632_36634 = state_36628;
(statearr_36632_36634[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36631;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36635 = state_36628;
state_36628 = G__36635;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__35727__auto__ = function(state_36628){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__35727__auto____1.call(this,state_36628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__35727__auto____0;
cljs$core$async$transduce_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__35727__auto____1;
return cljs$core$async$transduce_$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto__,f__$1))
})();
var state__35870__auto__ = (function (){var statearr_36633 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36633[(6)] = c__35868__auto__);

return statearr_36633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto__,f__$1))
);

return c__35868__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__36641 = arguments.length;
switch (G__36641) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__35868__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto__){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto__){
return (function (state_36670){
var state_val_36671 = (state_36670[(1)]);
if((state_val_36671 === (7))){
var inst_36652 = (state_36670[(2)]);
var state_36670__$1 = state_36670;
var statearr_36675_36705 = state_36670__$1;
(statearr_36675_36705[(2)] = inst_36652);

(statearr_36675_36705[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (1))){
var inst_36646 = cljs.core.seq(coll);
var inst_36647 = inst_36646;
var state_36670__$1 = (function (){var statearr_36676 = state_36670;
(statearr_36676[(7)] = inst_36647);

return statearr_36676;
})();
var statearr_36677_36706 = state_36670__$1;
(statearr_36677_36706[(2)] = null);

(statearr_36677_36706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (4))){
var inst_36647 = (state_36670[(7)]);
var inst_36650 = cljs.core.first(inst_36647);
var state_36670__$1 = state_36670;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36670__$1,(7),ch,inst_36650);
} else {
if((state_val_36671 === (13))){
var inst_36664 = (state_36670[(2)]);
var state_36670__$1 = state_36670;
var statearr_36681_36707 = state_36670__$1;
(statearr_36681_36707[(2)] = inst_36664);

(statearr_36681_36707[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (6))){
var inst_36655 = (state_36670[(2)]);
var state_36670__$1 = state_36670;
if(cljs.core.truth_(inst_36655)){
var statearr_36682_36708 = state_36670__$1;
(statearr_36682_36708[(1)] = (8));

} else {
var statearr_36683_36709 = state_36670__$1;
(statearr_36683_36709[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (3))){
var inst_36668 = (state_36670[(2)]);
var state_36670__$1 = state_36670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36670__$1,inst_36668);
} else {
if((state_val_36671 === (12))){
var state_36670__$1 = state_36670;
var statearr_36684_36710 = state_36670__$1;
(statearr_36684_36710[(2)] = null);

(statearr_36684_36710[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (2))){
var inst_36647 = (state_36670[(7)]);
var state_36670__$1 = state_36670;
if(cljs.core.truth_(inst_36647)){
var statearr_36685_36711 = state_36670__$1;
(statearr_36685_36711[(1)] = (4));

} else {
var statearr_36686_36712 = state_36670__$1;
(statearr_36686_36712[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (11))){
var inst_36661 = cljs.core.async.close_BANG_(ch);
var state_36670__$1 = state_36670;
var statearr_36687_36713 = state_36670__$1;
(statearr_36687_36713[(2)] = inst_36661);

(statearr_36687_36713[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (9))){
var state_36670__$1 = state_36670;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36688_36714 = state_36670__$1;
(statearr_36688_36714[(1)] = (11));

} else {
var statearr_36689_36715 = state_36670__$1;
(statearr_36689_36715[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (5))){
var inst_36647 = (state_36670[(7)]);
var state_36670__$1 = state_36670;
var statearr_36690_36716 = state_36670__$1;
(statearr_36690_36716[(2)] = inst_36647);

(statearr_36690_36716[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (10))){
var inst_36666 = (state_36670[(2)]);
var state_36670__$1 = state_36670;
var statearr_36691_36717 = state_36670__$1;
(statearr_36691_36717[(2)] = inst_36666);

(statearr_36691_36717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36671 === (8))){
var inst_36647 = (state_36670[(7)]);
var inst_36657 = cljs.core.next(inst_36647);
var inst_36647__$1 = inst_36657;
var state_36670__$1 = (function (){var statearr_36692 = state_36670;
(statearr_36692[(7)] = inst_36647__$1);

return statearr_36692;
})();
var statearr_36693_36718 = state_36670__$1;
(statearr_36693_36718[(2)] = null);

(statearr_36693_36718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto__))
;
return ((function (switch__35726__auto__,c__35868__auto__){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_36694 = [null,null,null,null,null,null,null,null];
(statearr_36694[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_36694[(1)] = (1));

return statearr_36694;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_36670){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36670);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e36695){if((e36695 instanceof Object)){
var ex__35730__auto__ = e36695;
var statearr_36696_36719 = state_36670;
(statearr_36696_36719[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36695;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36720 = state_36670;
state_36670 = G__36720;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_36670){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_36670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto__))
})();
var state__35870__auto__ = (function (){var statearr_36700 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_36700[(6)] = c__35868__auto__);

return statearr_36700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto__))
);

return c__35868__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async36731 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36731 = (function (ch,cs,meta36732){
this.ch = ch;
this.cs = cs;
this.meta36732 = meta36732;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_36733,meta36732__$1){
var self__ = this;
var _36733__$1 = this;
return (new cljs.core.async.t_cljs$core$async36731(self__.ch,self__.cs,meta36732__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_36733){
var self__ = this;
var _36733__$1 = this;
return self__.meta36732;
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta36732","meta36732",668383426,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async36731.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async36731.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36731";

cljs.core.async.t_cljs$core$async36731.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async36731");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36731.
 */
cljs.core.async.__GT_t_cljs$core$async36731 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async36731(ch__$1,cs__$1,meta36732){
return (new cljs.core.async.t_cljs$core$async36731(ch__$1,cs__$1,meta36732));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async36731(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__35868__auto___37016 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___37016,cs,m,dchan,dctr,done){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___37016,cs,m,dchan,dctr,done){
return (function (state_36871){
var state_val_36872 = (state_36871[(1)]);
if((state_val_36872 === (7))){
var inst_36867 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36874_37017 = state_36871__$1;
(statearr_36874_37017[(2)] = inst_36867);

(statearr_36874_37017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (20))){
var inst_36770 = (state_36871[(7)]);
var inst_36782 = cljs.core.first(inst_36770);
var inst_36783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36782,(0),null);
var inst_36784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36782,(1),null);
var state_36871__$1 = (function (){var statearr_36875 = state_36871;
(statearr_36875[(8)] = inst_36783);

return statearr_36875;
})();
if(cljs.core.truth_(inst_36784)){
var statearr_36876_37021 = state_36871__$1;
(statearr_36876_37021[(1)] = (22));

} else {
var statearr_36877_37022 = state_36871__$1;
(statearr_36877_37022[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (27))){
var inst_36814 = (state_36871[(9)]);
var inst_36739 = (state_36871[(10)]);
var inst_36819 = (state_36871[(11)]);
var inst_36812 = (state_36871[(12)]);
var inst_36819__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_36812,inst_36814);
var inst_36820 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_36819__$1,inst_36739,done);
var state_36871__$1 = (function (){var statearr_36878 = state_36871;
(statearr_36878[(11)] = inst_36819__$1);

return statearr_36878;
})();
if(cljs.core.truth_(inst_36820)){
var statearr_36879_37023 = state_36871__$1;
(statearr_36879_37023[(1)] = (30));

} else {
var statearr_36880_37024 = state_36871__$1;
(statearr_36880_37024[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (1))){
var state_36871__$1 = state_36871;
var statearr_36881_37025 = state_36871__$1;
(statearr_36881_37025[(2)] = null);

(statearr_36881_37025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (24))){
var inst_36770 = (state_36871[(7)]);
var inst_36789 = (state_36871[(2)]);
var inst_36790 = cljs.core.next(inst_36770);
var inst_36748 = inst_36790;
var inst_36749 = null;
var inst_36750 = (0);
var inst_36751 = (0);
var state_36871__$1 = (function (){var statearr_36882 = state_36871;
(statearr_36882[(13)] = inst_36789);

(statearr_36882[(14)] = inst_36751);

(statearr_36882[(15)] = inst_36749);

(statearr_36882[(16)] = inst_36748);

(statearr_36882[(17)] = inst_36750);

return statearr_36882;
})();
var statearr_36883_37026 = state_36871__$1;
(statearr_36883_37026[(2)] = null);

(statearr_36883_37026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (39))){
var state_36871__$1 = state_36871;
var statearr_36887_37027 = state_36871__$1;
(statearr_36887_37027[(2)] = null);

(statearr_36887_37027[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (4))){
var inst_36739 = (state_36871[(10)]);
var inst_36739__$1 = (state_36871[(2)]);
var inst_36740 = (inst_36739__$1 == null);
var state_36871__$1 = (function (){var statearr_36888 = state_36871;
(statearr_36888[(10)] = inst_36739__$1);

return statearr_36888;
})();
if(cljs.core.truth_(inst_36740)){
var statearr_36889_37028 = state_36871__$1;
(statearr_36889_37028[(1)] = (5));

} else {
var statearr_36890_37029 = state_36871__$1;
(statearr_36890_37029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (15))){
var inst_36751 = (state_36871[(14)]);
var inst_36749 = (state_36871[(15)]);
var inst_36748 = (state_36871[(16)]);
var inst_36750 = (state_36871[(17)]);
var inst_36766 = (state_36871[(2)]);
var inst_36767 = (inst_36751 + (1));
var tmp36884 = inst_36749;
var tmp36885 = inst_36748;
var tmp36886 = inst_36750;
var inst_36748__$1 = tmp36885;
var inst_36749__$1 = tmp36884;
var inst_36750__$1 = tmp36886;
var inst_36751__$1 = inst_36767;
var state_36871__$1 = (function (){var statearr_36892 = state_36871;
(statearr_36892[(14)] = inst_36751__$1);

(statearr_36892[(15)] = inst_36749__$1);

(statearr_36892[(16)] = inst_36748__$1);

(statearr_36892[(18)] = inst_36766);

(statearr_36892[(17)] = inst_36750__$1);

return statearr_36892;
})();
var statearr_36893_37030 = state_36871__$1;
(statearr_36893_37030[(2)] = null);

(statearr_36893_37030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (21))){
var inst_36793 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36897_37031 = state_36871__$1;
(statearr_36897_37031[(2)] = inst_36793);

(statearr_36897_37031[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (31))){
var inst_36819 = (state_36871[(11)]);
var inst_36823 = done(null);
var inst_36824 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_36819);
var state_36871__$1 = (function (){var statearr_36898 = state_36871;
(statearr_36898[(19)] = inst_36823);

return statearr_36898;
})();
var statearr_36899_37032 = state_36871__$1;
(statearr_36899_37032[(2)] = inst_36824);

(statearr_36899_37032[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (32))){
var inst_36814 = (state_36871[(9)]);
var inst_36811 = (state_36871[(20)]);
var inst_36813 = (state_36871[(21)]);
var inst_36812 = (state_36871[(12)]);
var inst_36826 = (state_36871[(2)]);
var inst_36827 = (inst_36814 + (1));
var tmp36894 = inst_36811;
var tmp36895 = inst_36813;
var tmp36896 = inst_36812;
var inst_36811__$1 = tmp36894;
var inst_36812__$1 = tmp36896;
var inst_36813__$1 = tmp36895;
var inst_36814__$1 = inst_36827;
var state_36871__$1 = (function (){var statearr_36900 = state_36871;
(statearr_36900[(9)] = inst_36814__$1);

(statearr_36900[(20)] = inst_36811__$1);

(statearr_36900[(21)] = inst_36813__$1);

(statearr_36900[(22)] = inst_36826);

(statearr_36900[(12)] = inst_36812__$1);

return statearr_36900;
})();
var statearr_36901_37033 = state_36871__$1;
(statearr_36901_37033[(2)] = null);

(statearr_36901_37033[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (40))){
var inst_36839 = (state_36871[(23)]);
var inst_36843 = done(null);
var inst_36844 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_36839);
var state_36871__$1 = (function (){var statearr_36902 = state_36871;
(statearr_36902[(24)] = inst_36843);

return statearr_36902;
})();
var statearr_36903_37034 = state_36871__$1;
(statearr_36903_37034[(2)] = inst_36844);

(statearr_36903_37034[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (33))){
var inst_36830 = (state_36871[(25)]);
var inst_36832 = cljs.core.chunked_seq_QMARK_(inst_36830);
var state_36871__$1 = state_36871;
if(inst_36832){
var statearr_36904_37038 = state_36871__$1;
(statearr_36904_37038[(1)] = (36));

} else {
var statearr_36905_37039 = state_36871__$1;
(statearr_36905_37039[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (13))){
var inst_36760 = (state_36871[(26)]);
var inst_36763 = cljs.core.async.close_BANG_(inst_36760);
var state_36871__$1 = state_36871;
var statearr_36906_37046 = state_36871__$1;
(statearr_36906_37046[(2)] = inst_36763);

(statearr_36906_37046[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (22))){
var inst_36783 = (state_36871[(8)]);
var inst_36786 = cljs.core.async.close_BANG_(inst_36783);
var state_36871__$1 = state_36871;
var statearr_36911_37047 = state_36871__$1;
(statearr_36911_37047[(2)] = inst_36786);

(statearr_36911_37047[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (36))){
var inst_36830 = (state_36871[(25)]);
var inst_36834 = cljs.core.chunk_first(inst_36830);
var inst_36835 = cljs.core.chunk_rest(inst_36830);
var inst_36836 = cljs.core.count(inst_36834);
var inst_36811 = inst_36835;
var inst_36812 = inst_36834;
var inst_36813 = inst_36836;
var inst_36814 = (0);
var state_36871__$1 = (function (){var statearr_36912 = state_36871;
(statearr_36912[(9)] = inst_36814);

(statearr_36912[(20)] = inst_36811);

(statearr_36912[(21)] = inst_36813);

(statearr_36912[(12)] = inst_36812);

return statearr_36912;
})();
var statearr_36913_37048 = state_36871__$1;
(statearr_36913_37048[(2)] = null);

(statearr_36913_37048[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (41))){
var inst_36830 = (state_36871[(25)]);
var inst_36846 = (state_36871[(2)]);
var inst_36847 = cljs.core.next(inst_36830);
var inst_36811 = inst_36847;
var inst_36812 = null;
var inst_36813 = (0);
var inst_36814 = (0);
var state_36871__$1 = (function (){var statearr_36914 = state_36871;
(statearr_36914[(9)] = inst_36814);

(statearr_36914[(27)] = inst_36846);

(statearr_36914[(20)] = inst_36811);

(statearr_36914[(21)] = inst_36813);

(statearr_36914[(12)] = inst_36812);

return statearr_36914;
})();
var statearr_36915_37049 = state_36871__$1;
(statearr_36915_37049[(2)] = null);

(statearr_36915_37049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (43))){
var state_36871__$1 = state_36871;
var statearr_36916_37050 = state_36871__$1;
(statearr_36916_37050[(2)] = null);

(statearr_36916_37050[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (29))){
var inst_36855 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36917_37051 = state_36871__$1;
(statearr_36917_37051[(2)] = inst_36855);

(statearr_36917_37051[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (44))){
var inst_36864 = (state_36871[(2)]);
var state_36871__$1 = (function (){var statearr_36923 = state_36871;
(statearr_36923[(28)] = inst_36864);

return statearr_36923;
})();
var statearr_36924_37052 = state_36871__$1;
(statearr_36924_37052[(2)] = null);

(statearr_36924_37052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (6))){
var inst_36803 = (state_36871[(29)]);
var inst_36802 = cljs.core.deref(cs);
var inst_36803__$1 = cljs.core.keys(inst_36802);
var inst_36804 = cljs.core.count(inst_36803__$1);
var inst_36805 = cljs.core.reset_BANG_(dctr,inst_36804);
var inst_36810 = cljs.core.seq(inst_36803__$1);
var inst_36811 = inst_36810;
var inst_36812 = null;
var inst_36813 = (0);
var inst_36814 = (0);
var state_36871__$1 = (function (){var statearr_36925 = state_36871;
(statearr_36925[(9)] = inst_36814);

(statearr_36925[(29)] = inst_36803__$1);

(statearr_36925[(30)] = inst_36805);

(statearr_36925[(20)] = inst_36811);

(statearr_36925[(21)] = inst_36813);

(statearr_36925[(12)] = inst_36812);

return statearr_36925;
})();
var statearr_36926_37053 = state_36871__$1;
(statearr_36926_37053[(2)] = null);

(statearr_36926_37053[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (28))){
var inst_36811 = (state_36871[(20)]);
var inst_36830 = (state_36871[(25)]);
var inst_36830__$1 = cljs.core.seq(inst_36811);
var state_36871__$1 = (function (){var statearr_36927 = state_36871;
(statearr_36927[(25)] = inst_36830__$1);

return statearr_36927;
})();
if(inst_36830__$1){
var statearr_36928_37054 = state_36871__$1;
(statearr_36928_37054[(1)] = (33));

} else {
var statearr_36929_37055 = state_36871__$1;
(statearr_36929_37055[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (25))){
var inst_36814 = (state_36871[(9)]);
var inst_36813 = (state_36871[(21)]);
var inst_36816 = (inst_36814 < inst_36813);
var inst_36817 = inst_36816;
var state_36871__$1 = state_36871;
if(cljs.core.truth_(inst_36817)){
var statearr_36933_37056 = state_36871__$1;
(statearr_36933_37056[(1)] = (27));

} else {
var statearr_36934_37057 = state_36871__$1;
(statearr_36934_37057[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (34))){
var state_36871__$1 = state_36871;
var statearr_36935_37058 = state_36871__$1;
(statearr_36935_37058[(2)] = null);

(statearr_36935_37058[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (17))){
var state_36871__$1 = state_36871;
var statearr_36936_37059 = state_36871__$1;
(statearr_36936_37059[(2)] = null);

(statearr_36936_37059[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (3))){
var inst_36869 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36871__$1,inst_36869);
} else {
if((state_val_36872 === (12))){
var inst_36798 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36939_37060 = state_36871__$1;
(statearr_36939_37060[(2)] = inst_36798);

(statearr_36939_37060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (2))){
var state_36871__$1 = state_36871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36871__$1,(4),ch);
} else {
if((state_val_36872 === (23))){
var state_36871__$1 = state_36871;
var statearr_36940_37061 = state_36871__$1;
(statearr_36940_37061[(2)] = null);

(statearr_36940_37061[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (35))){
var inst_36853 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36941_37062 = state_36871__$1;
(statearr_36941_37062[(2)] = inst_36853);

(statearr_36941_37062[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (19))){
var inst_36770 = (state_36871[(7)]);
var inst_36774 = cljs.core.chunk_first(inst_36770);
var inst_36775 = cljs.core.chunk_rest(inst_36770);
var inst_36776 = cljs.core.count(inst_36774);
var inst_36748 = inst_36775;
var inst_36749 = inst_36774;
var inst_36750 = inst_36776;
var inst_36751 = (0);
var state_36871__$1 = (function (){var statearr_36942 = state_36871;
(statearr_36942[(14)] = inst_36751);

(statearr_36942[(15)] = inst_36749);

(statearr_36942[(16)] = inst_36748);

(statearr_36942[(17)] = inst_36750);

return statearr_36942;
})();
var statearr_36943_37063 = state_36871__$1;
(statearr_36943_37063[(2)] = null);

(statearr_36943_37063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (11))){
var inst_36748 = (state_36871[(16)]);
var inst_36770 = (state_36871[(7)]);
var inst_36770__$1 = cljs.core.seq(inst_36748);
var state_36871__$1 = (function (){var statearr_36944 = state_36871;
(statearr_36944[(7)] = inst_36770__$1);

return statearr_36944;
})();
if(inst_36770__$1){
var statearr_36947_37067 = state_36871__$1;
(statearr_36947_37067[(1)] = (16));

} else {
var statearr_36948_37068 = state_36871__$1;
(statearr_36948_37068[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (9))){
var inst_36800 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36949_37072 = state_36871__$1;
(statearr_36949_37072[(2)] = inst_36800);

(statearr_36949_37072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (5))){
var inst_36746 = cljs.core.deref(cs);
var inst_36747 = cljs.core.seq(inst_36746);
var inst_36748 = inst_36747;
var inst_36749 = null;
var inst_36750 = (0);
var inst_36751 = (0);
var state_36871__$1 = (function (){var statearr_36950 = state_36871;
(statearr_36950[(14)] = inst_36751);

(statearr_36950[(15)] = inst_36749);

(statearr_36950[(16)] = inst_36748);

(statearr_36950[(17)] = inst_36750);

return statearr_36950;
})();
var statearr_36951_37073 = state_36871__$1;
(statearr_36951_37073[(2)] = null);

(statearr_36951_37073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (14))){
var state_36871__$1 = state_36871;
var statearr_36952_37074 = state_36871__$1;
(statearr_36952_37074[(2)] = null);

(statearr_36952_37074[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (45))){
var inst_36861 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36953_37075 = state_36871__$1;
(statearr_36953_37075[(2)] = inst_36861);

(statearr_36953_37075[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (26))){
var inst_36803 = (state_36871[(29)]);
var inst_36857 = (state_36871[(2)]);
var inst_36858 = cljs.core.seq(inst_36803);
var state_36871__$1 = (function (){var statearr_36954 = state_36871;
(statearr_36954[(31)] = inst_36857);

return statearr_36954;
})();
if(inst_36858){
var statearr_36955_37076 = state_36871__$1;
(statearr_36955_37076[(1)] = (42));

} else {
var statearr_36956_37077 = state_36871__$1;
(statearr_36956_37077[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (16))){
var inst_36770 = (state_36871[(7)]);
var inst_36772 = cljs.core.chunked_seq_QMARK_(inst_36770);
var state_36871__$1 = state_36871;
if(inst_36772){
var statearr_36957_37078 = state_36871__$1;
(statearr_36957_37078[(1)] = (19));

} else {
var statearr_36958_37079 = state_36871__$1;
(statearr_36958_37079[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (38))){
var inst_36850 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36959_37080 = state_36871__$1;
(statearr_36959_37080[(2)] = inst_36850);

(statearr_36959_37080[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (30))){
var state_36871__$1 = state_36871;
var statearr_36960_37081 = state_36871__$1;
(statearr_36960_37081[(2)] = null);

(statearr_36960_37081[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (10))){
var inst_36751 = (state_36871[(14)]);
var inst_36749 = (state_36871[(15)]);
var inst_36759 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_36749,inst_36751);
var inst_36760 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36759,(0),null);
var inst_36761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36759,(1),null);
var state_36871__$1 = (function (){var statearr_36970 = state_36871;
(statearr_36970[(26)] = inst_36760);

return statearr_36970;
})();
if(cljs.core.truth_(inst_36761)){
var statearr_36974_37082 = state_36871__$1;
(statearr_36974_37082[(1)] = (13));

} else {
var statearr_36978_37083 = state_36871__$1;
(statearr_36978_37083[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (18))){
var inst_36796 = (state_36871[(2)]);
var state_36871__$1 = state_36871;
var statearr_36997_37084 = state_36871__$1;
(statearr_36997_37084[(2)] = inst_36796);

(statearr_36997_37084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (42))){
var state_36871__$1 = state_36871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36871__$1,(45),dchan);
} else {
if((state_val_36872 === (37))){
var inst_36839 = (state_36871[(23)]);
var inst_36739 = (state_36871[(10)]);
var inst_36830 = (state_36871[(25)]);
var inst_36839__$1 = cljs.core.first(inst_36830);
var inst_36840 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_36839__$1,inst_36739,done);
var state_36871__$1 = (function (){var statearr_37001 = state_36871;
(statearr_37001[(23)] = inst_36839__$1);

return statearr_37001;
})();
if(cljs.core.truth_(inst_36840)){
var statearr_37005_37085 = state_36871__$1;
(statearr_37005_37085[(1)] = (39));

} else {
var statearr_37006_37086 = state_36871__$1;
(statearr_37006_37086[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36872 === (8))){
var inst_36751 = (state_36871[(14)]);
var inst_36750 = (state_36871[(17)]);
var inst_36753 = (inst_36751 < inst_36750);
var inst_36754 = inst_36753;
var state_36871__$1 = state_36871;
if(cljs.core.truth_(inst_36754)){
var statearr_37010_37087 = state_36871__$1;
(statearr_37010_37087[(1)] = (10));

} else {
var statearr_37011_37088 = state_36871__$1;
(statearr_37011_37088[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___37016,cs,m,dchan,dctr,done))
;
return ((function (switch__35726__auto__,c__35868__auto___37016,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__35727__auto__ = null;
var cljs$core$async$mult_$_state_machine__35727__auto____0 = (function (){
var statearr_37012 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37012[(0)] = cljs$core$async$mult_$_state_machine__35727__auto__);

(statearr_37012[(1)] = (1));

return statearr_37012;
});
var cljs$core$async$mult_$_state_machine__35727__auto____1 = (function (state_36871){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_36871);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e37013){if((e37013 instanceof Object)){
var ex__35730__auto__ = e37013;
var statearr_37014_37089 = state_36871;
(statearr_37014_37089[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37013;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37090 = state_36871;
state_36871 = G__37090;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__35727__auto__ = function(state_36871){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__35727__auto____1.call(this,state_36871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__35727__auto____0;
cljs$core$async$mult_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__35727__auto____1;
return cljs$core$async$mult_$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___37016,cs,m,dchan,dctr,done))
})();
var state__35870__auto__ = (function (){var statearr_37015 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_37015[(6)] = c__35868__auto___37016);

return statearr_37015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___37016,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__37092 = arguments.length;
switch (G__37092) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto__.call(null,m,state_map));
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto__.call(null,m,mode));
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___37114 = arguments.length;
var i__4532__auto___37115 = (0);
while(true){
if((i__4532__auto___37115 < len__4531__auto___37114)){
args__4534__auto__.push((arguments[i__4532__auto___37115]));

var G__37116 = (i__4532__auto___37115 + (1));
i__4532__auto___37115 = G__37116;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37108){
var map__37109 = p__37108;
var map__37109__$1 = ((((!((map__37109 == null)))?(((((map__37109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37109.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37109):map__37109);
var opts = map__37109__$1;
var statearr_37111_37117 = state;
(statearr_37111_37117[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__37109,map__37109__$1,opts){
return (function (val){
var statearr_37112_37118 = state;
(statearr_37112_37118[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__37109,map__37109__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_37113_37119 = state;
(statearr_37113_37119[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37104){
var G__37105 = cljs.core.first(seq37104);
var seq37104__$1 = cljs.core.next(seq37104);
var G__37106 = cljs.core.first(seq37104__$1);
var seq37104__$2 = cljs.core.next(seq37104__$1);
var G__37107 = cljs.core.first(seq37104__$2);
var seq37104__$3 = cljs.core.next(seq37104__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37105,G__37106,G__37107,seq37104__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_(solos)))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37120 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37120 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta37121){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta37121 = meta37121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37122,meta37121__$1){
var self__ = this;
var _37122__$1 = this;
return (new cljs.core.async.t_cljs$core$async37120(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta37121__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_37122){
var self__ = this;
var _37122__$1 = this;
return self__.meta37121;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta37121","meta37121",-1845654952,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async37120.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37120.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37120";

cljs.core.async.t_cljs$core$async37120.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async37120");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37120.
 */
cljs.core.async.__GT_t_cljs$core$async37120 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async37120(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta37121){
return (new cljs.core.async.t_cljs$core$async37120(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta37121));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async37120(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__35868__auto___37331 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___37331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___37331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_37232){
var state_val_37233 = (state_37232[(1)]);
if((state_val_37233 === (7))){
var inst_37143 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37234_37332 = state_37232__$1;
(statearr_37234_37332[(2)] = inst_37143);

(statearr_37234_37332[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (20))){
var inst_37159 = (state_37232[(7)]);
var state_37232__$1 = state_37232;
var statearr_37239_37333 = state_37232__$1;
(statearr_37239_37333[(2)] = inst_37159);

(statearr_37239_37333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (27))){
var state_37232__$1 = state_37232;
var statearr_37240_37334 = state_37232__$1;
(statearr_37240_37334[(2)] = null);

(statearr_37240_37334[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (1))){
var inst_37130 = (state_37232[(8)]);
var inst_37130__$1 = calc_state();
var inst_37132 = (inst_37130__$1 == null);
var inst_37133 = cljs.core.not(inst_37132);
var state_37232__$1 = (function (){var statearr_37241 = state_37232;
(statearr_37241[(8)] = inst_37130__$1);

return statearr_37241;
})();
if(inst_37133){
var statearr_37242_37335 = state_37232__$1;
(statearr_37242_37335[(1)] = (2));

} else {
var statearr_37243_37336 = state_37232__$1;
(statearr_37243_37336[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (24))){
var inst_37192 = (state_37232[(9)]);
var inst_37206 = (state_37232[(10)]);
var inst_37183 = (state_37232[(11)]);
var inst_37206__$1 = (inst_37183.cljs$core$IFn$_invoke$arity$1 ? inst_37183.cljs$core$IFn$_invoke$arity$1(inst_37192) : inst_37183.call(null,inst_37192));
var state_37232__$1 = (function (){var statearr_37244 = state_37232;
(statearr_37244[(10)] = inst_37206__$1);

return statearr_37244;
})();
if(cljs.core.truth_(inst_37206__$1)){
var statearr_37245_37337 = state_37232__$1;
(statearr_37245_37337[(1)] = (29));

} else {
var statearr_37246_37338 = state_37232__$1;
(statearr_37246_37338[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (4))){
var inst_37146 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37146)){
var statearr_37247_37339 = state_37232__$1;
(statearr_37247_37339[(1)] = (8));

} else {
var statearr_37248_37340 = state_37232__$1;
(statearr_37248_37340[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (15))){
var inst_37177 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37177)){
var statearr_37249_37341 = state_37232__$1;
(statearr_37249_37341[(1)] = (19));

} else {
var statearr_37250_37342 = state_37232__$1;
(statearr_37250_37342[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (21))){
var inst_37182 = (state_37232[(12)]);
var inst_37182__$1 = (state_37232[(2)]);
var inst_37183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37182__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37182__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37182__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_37232__$1 = (function (){var statearr_37251 = state_37232;
(statearr_37251[(13)] = inst_37184);

(statearr_37251[(11)] = inst_37183);

(statearr_37251[(12)] = inst_37182__$1);

return statearr_37251;
})();
return cljs.core.async.ioc_alts_BANG_(state_37232__$1,(22),inst_37185);
} else {
if((state_val_37233 === (31))){
var inst_37214 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37214)){
var statearr_37252_37343 = state_37232__$1;
(statearr_37252_37343[(1)] = (32));

} else {
var statearr_37253_37344 = state_37232__$1;
(statearr_37253_37344[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (32))){
var inst_37191 = (state_37232[(14)]);
var state_37232__$1 = state_37232;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37232__$1,(35),out,inst_37191);
} else {
if((state_val_37233 === (33))){
var inst_37182 = (state_37232[(12)]);
var inst_37159 = inst_37182;
var state_37232__$1 = (function (){var statearr_37254 = state_37232;
(statearr_37254[(7)] = inst_37159);

return statearr_37254;
})();
var statearr_37255_37345 = state_37232__$1;
(statearr_37255_37345[(2)] = null);

(statearr_37255_37345[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (13))){
var inst_37159 = (state_37232[(7)]);
var inst_37166 = inst_37159.cljs$lang$protocol_mask$partition0$;
var inst_37167 = (inst_37166 & (64));
var inst_37168 = inst_37159.cljs$core$ISeq$;
var inst_37169 = (cljs.core.PROTOCOL_SENTINEL === inst_37168);
var inst_37170 = ((inst_37167) || (inst_37169));
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37170)){
var statearr_37256_37349 = state_37232__$1;
(statearr_37256_37349[(1)] = (16));

} else {
var statearr_37257_37350 = state_37232__$1;
(statearr_37257_37350[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (22))){
var inst_37192 = (state_37232[(9)]);
var inst_37191 = (state_37232[(14)]);
var inst_37190 = (state_37232[(2)]);
var inst_37191__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37190,(0),null);
var inst_37192__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37190,(1),null);
var inst_37193 = (inst_37191__$1 == null);
var inst_37194 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37192__$1,change);
var inst_37195 = ((inst_37193) || (inst_37194));
var state_37232__$1 = (function (){var statearr_37258 = state_37232;
(statearr_37258[(9)] = inst_37192__$1);

(statearr_37258[(14)] = inst_37191__$1);

return statearr_37258;
})();
if(cljs.core.truth_(inst_37195)){
var statearr_37259_37351 = state_37232__$1;
(statearr_37259_37351[(1)] = (23));

} else {
var statearr_37260_37352 = state_37232__$1;
(statearr_37260_37352[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (36))){
var inst_37182 = (state_37232[(12)]);
var inst_37159 = inst_37182;
var state_37232__$1 = (function (){var statearr_37261 = state_37232;
(statearr_37261[(7)] = inst_37159);

return statearr_37261;
})();
var statearr_37262_37353 = state_37232__$1;
(statearr_37262_37353[(2)] = null);

(statearr_37262_37353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (29))){
var inst_37206 = (state_37232[(10)]);
var state_37232__$1 = state_37232;
var statearr_37263_37354 = state_37232__$1;
(statearr_37263_37354[(2)] = inst_37206);

(statearr_37263_37354[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (6))){
var state_37232__$1 = state_37232;
var statearr_37264_37355 = state_37232__$1;
(statearr_37264_37355[(2)] = false);

(statearr_37264_37355[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (28))){
var inst_37202 = (state_37232[(2)]);
var inst_37203 = calc_state();
var inst_37159 = inst_37203;
var state_37232__$1 = (function (){var statearr_37265 = state_37232;
(statearr_37265[(7)] = inst_37159);

(statearr_37265[(15)] = inst_37202);

return statearr_37265;
})();
var statearr_37266_37356 = state_37232__$1;
(statearr_37266_37356[(2)] = null);

(statearr_37266_37356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (25))){
var inst_37228 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37267_37357 = state_37232__$1;
(statearr_37267_37357[(2)] = inst_37228);

(statearr_37267_37357[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (34))){
var inst_37226 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37268_37358 = state_37232__$1;
(statearr_37268_37358[(2)] = inst_37226);

(statearr_37268_37358[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (17))){
var state_37232__$1 = state_37232;
var statearr_37269_37359 = state_37232__$1;
(statearr_37269_37359[(2)] = false);

(statearr_37269_37359[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (3))){
var state_37232__$1 = state_37232;
var statearr_37270_37360 = state_37232__$1;
(statearr_37270_37360[(2)] = false);

(statearr_37270_37360[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (12))){
var inst_37230 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37232__$1,inst_37230);
} else {
if((state_val_37233 === (2))){
var inst_37130 = (state_37232[(8)]);
var inst_37135 = inst_37130.cljs$lang$protocol_mask$partition0$;
var inst_37136 = (inst_37135 & (64));
var inst_37137 = inst_37130.cljs$core$ISeq$;
var inst_37138 = (cljs.core.PROTOCOL_SENTINEL === inst_37137);
var inst_37139 = ((inst_37136) || (inst_37138));
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37139)){
var statearr_37271_37361 = state_37232__$1;
(statearr_37271_37361[(1)] = (5));

} else {
var statearr_37272_37362 = state_37232__$1;
(statearr_37272_37362[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (23))){
var inst_37191 = (state_37232[(14)]);
var inst_37197 = (inst_37191 == null);
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37197)){
var statearr_37273_37363 = state_37232__$1;
(statearr_37273_37363[(1)] = (26));

} else {
var statearr_37274_37365 = state_37232__$1;
(statearr_37274_37365[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (35))){
var inst_37217 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
if(cljs.core.truth_(inst_37217)){
var statearr_37275_37369 = state_37232__$1;
(statearr_37275_37369[(1)] = (36));

} else {
var statearr_37276_37370 = state_37232__$1;
(statearr_37276_37370[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (19))){
var inst_37159 = (state_37232[(7)]);
var inst_37179 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37159);
var state_37232__$1 = state_37232;
var statearr_37282_37377 = state_37232__$1;
(statearr_37282_37377[(2)] = inst_37179);

(statearr_37282_37377[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (11))){
var inst_37159 = (state_37232[(7)]);
var inst_37163 = (inst_37159 == null);
var inst_37164 = cljs.core.not(inst_37163);
var state_37232__$1 = state_37232;
if(inst_37164){
var statearr_37283_37378 = state_37232__$1;
(statearr_37283_37378[(1)] = (13));

} else {
var statearr_37284_37379 = state_37232__$1;
(statearr_37284_37379[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (9))){
var inst_37130 = (state_37232[(8)]);
var state_37232__$1 = state_37232;
var statearr_37285_37380 = state_37232__$1;
(statearr_37285_37380[(2)] = inst_37130);

(statearr_37285_37380[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (5))){
var state_37232__$1 = state_37232;
var statearr_37286_37381 = state_37232__$1;
(statearr_37286_37381[(2)] = true);

(statearr_37286_37381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (14))){
var state_37232__$1 = state_37232;
var statearr_37287_37382 = state_37232__$1;
(statearr_37287_37382[(2)] = false);

(statearr_37287_37382[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (26))){
var inst_37192 = (state_37232[(9)]);
var inst_37199 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37192);
var state_37232__$1 = state_37232;
var statearr_37292_37383 = state_37232__$1;
(statearr_37292_37383[(2)] = inst_37199);

(statearr_37292_37383[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (16))){
var state_37232__$1 = state_37232;
var statearr_37293_37384 = state_37232__$1;
(statearr_37293_37384[(2)] = true);

(statearr_37293_37384[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (38))){
var inst_37222 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37294_37385 = state_37232__$1;
(statearr_37294_37385[(2)] = inst_37222);

(statearr_37294_37385[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (30))){
var inst_37192 = (state_37232[(9)]);
var inst_37184 = (state_37232[(13)]);
var inst_37183 = (state_37232[(11)]);
var inst_37209 = cljs.core.empty_QMARK_(inst_37183);
var inst_37210 = (inst_37184.cljs$core$IFn$_invoke$arity$1 ? inst_37184.cljs$core$IFn$_invoke$arity$1(inst_37192) : inst_37184.call(null,inst_37192));
var inst_37211 = cljs.core.not(inst_37210);
var inst_37212 = ((inst_37209) && (inst_37211));
var state_37232__$1 = state_37232;
var statearr_37295_37386 = state_37232__$1;
(statearr_37295_37386[(2)] = inst_37212);

(statearr_37295_37386[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (10))){
var inst_37130 = (state_37232[(8)]);
var inst_37152 = (state_37232[(2)]);
var inst_37156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37152,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37152,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37152,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_37159 = inst_37130;
var state_37232__$1 = (function (){var statearr_37296 = state_37232;
(statearr_37296[(7)] = inst_37159);

(statearr_37296[(16)] = inst_37156);

(statearr_37296[(17)] = inst_37157);

(statearr_37296[(18)] = inst_37158);

return statearr_37296;
})();
var statearr_37297_37387 = state_37232__$1;
(statearr_37297_37387[(2)] = null);

(statearr_37297_37387[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (18))){
var inst_37174 = (state_37232[(2)]);
var state_37232__$1 = state_37232;
var statearr_37301_37388 = state_37232__$1;
(statearr_37301_37388[(2)] = inst_37174);

(statearr_37301_37388[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (37))){
var state_37232__$1 = state_37232;
var statearr_37305_37389 = state_37232__$1;
(statearr_37305_37389[(2)] = null);

(statearr_37305_37389[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37233 === (8))){
var inst_37130 = (state_37232[(8)]);
var inst_37148 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37130);
var state_37232__$1 = state_37232;
var statearr_37306_37390 = state_37232__$1;
(statearr_37306_37390[(2)] = inst_37148);

(statearr_37306_37390[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___37331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__35726__auto__,c__35868__auto___37331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__35727__auto__ = null;
var cljs$core$async$mix_$_state_machine__35727__auto____0 = (function (){
var statearr_37313 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37313[(0)] = cljs$core$async$mix_$_state_machine__35727__auto__);

(statearr_37313[(1)] = (1));

return statearr_37313;
});
var cljs$core$async$mix_$_state_machine__35727__auto____1 = (function (state_37232){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_37232);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e37314){if((e37314 instanceof Object)){
var ex__35730__auto__ = e37314;
var statearr_37315_37391 = state_37232;
(statearr_37315_37391[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37232);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37314;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37392 = state_37232;
state_37232 = G__37392;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__35727__auto__ = function(state_37232){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__35727__auto____1.call(this,state_37232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__35727__auto____0;
cljs$core$async$mix_$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__35727__auto____1;
return cljs$core$async$mix_$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___37331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__35870__auto__ = (function (){var statearr_37316 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_37316[(6)] = c__35868__auto___37331);

return statearr_37316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___37331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto__.call(null,p,v,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__37402 = arguments.length;
switch (G__37402) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto__.call(null,p));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto__.call(null,p,v));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__37414 = arguments.length;
switch (G__37414) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__3949__auto__,mults){
return (function (p1__37412_SHARP_){
if(cljs.core.truth_((p1__37412_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__37412_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__37412_SHARP_.call(null,topic)))){
return p1__37412_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__37412_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37415 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37415 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta37416){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta37416 = meta37416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_37417,meta37416__$1){
var self__ = this;
var _37417__$1 = this;
return (new cljs.core.async.t_cljs$core$async37415(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta37416__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_37417){
var self__ = this;
var _37417__$1 = this;
return self__.meta37416;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta37416","meta37416",-611201654,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async37415.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async37415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37415";

cljs.core.async.t_cljs$core$async37415.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async37415");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37415.
 */
cljs.core.async.__GT_t_cljs$core$async37415 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async37415(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37416){
return (new cljs.core.async.t_cljs$core$async37415(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta37416));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async37415(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__35868__auto___37577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___37577,mults,ensure_mult,p){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___37577,mults,ensure_mult,p){
return (function (state_37495){
var state_val_37496 = (state_37495[(1)]);
if((state_val_37496 === (7))){
var inst_37489 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37501_37578 = state_37495__$1;
(statearr_37501_37578[(2)] = inst_37489);

(statearr_37501_37578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (20))){
var state_37495__$1 = state_37495;
var statearr_37502_37579 = state_37495__$1;
(statearr_37502_37579[(2)] = null);

(statearr_37502_37579[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (1))){
var state_37495__$1 = state_37495;
var statearr_37503_37580 = state_37495__$1;
(statearr_37503_37580[(2)] = null);

(statearr_37503_37580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (24))){
var inst_37472 = (state_37495[(7)]);
var inst_37481 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_37472);
var state_37495__$1 = state_37495;
var statearr_37504_37581 = state_37495__$1;
(statearr_37504_37581[(2)] = inst_37481);

(statearr_37504_37581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (4))){
var inst_37421 = (state_37495[(8)]);
var inst_37421__$1 = (state_37495[(2)]);
var inst_37422 = (inst_37421__$1 == null);
var state_37495__$1 = (function (){var statearr_37505 = state_37495;
(statearr_37505[(8)] = inst_37421__$1);

return statearr_37505;
})();
if(cljs.core.truth_(inst_37422)){
var statearr_37506_37582 = state_37495__$1;
(statearr_37506_37582[(1)] = (5));

} else {
var statearr_37507_37583 = state_37495__$1;
(statearr_37507_37583[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (15))){
var inst_37466 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37508_37584 = state_37495__$1;
(statearr_37508_37584[(2)] = inst_37466);

(statearr_37508_37584[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (21))){
var inst_37486 = (state_37495[(2)]);
var state_37495__$1 = (function (){var statearr_37511 = state_37495;
(statearr_37511[(9)] = inst_37486);

return statearr_37511;
})();
var statearr_37512_37585 = state_37495__$1;
(statearr_37512_37585[(2)] = null);

(statearr_37512_37585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (13))){
var inst_37447 = (state_37495[(10)]);
var inst_37450 = cljs.core.chunked_seq_QMARK_(inst_37447);
var state_37495__$1 = state_37495;
if(inst_37450){
var statearr_37514_37586 = state_37495__$1;
(statearr_37514_37586[(1)] = (16));

} else {
var statearr_37515_37587 = state_37495__$1;
(statearr_37515_37587[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (22))){
var inst_37478 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
if(cljs.core.truth_(inst_37478)){
var statearr_37516_37588 = state_37495__$1;
(statearr_37516_37588[(1)] = (23));

} else {
var statearr_37519_37589 = state_37495__$1;
(statearr_37519_37589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (6))){
var inst_37421 = (state_37495[(8)]);
var inst_37474 = (state_37495[(11)]);
var inst_37472 = (state_37495[(7)]);
var inst_37472__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_37421) : topic_fn.call(null,inst_37421));
var inst_37473 = cljs.core.deref(mults);
var inst_37474__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37473,inst_37472__$1);
var state_37495__$1 = (function (){var statearr_37522 = state_37495;
(statearr_37522[(11)] = inst_37474__$1);

(statearr_37522[(7)] = inst_37472__$1);

return statearr_37522;
})();
if(cljs.core.truth_(inst_37474__$1)){
var statearr_37523_37593 = state_37495__$1;
(statearr_37523_37593[(1)] = (19));

} else {
var statearr_37526_37594 = state_37495__$1;
(statearr_37526_37594[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (25))){
var inst_37483 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37527_37595 = state_37495__$1;
(statearr_37527_37595[(2)] = inst_37483);

(statearr_37527_37595[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (17))){
var inst_37447 = (state_37495[(10)]);
var inst_37457 = cljs.core.first(inst_37447);
var inst_37458 = cljs.core.async.muxch_STAR_(inst_37457);
var inst_37459 = cljs.core.async.close_BANG_(inst_37458);
var inst_37460 = cljs.core.next(inst_37447);
var inst_37431 = inst_37460;
var inst_37432 = null;
var inst_37433 = (0);
var inst_37434 = (0);
var state_37495__$1 = (function (){var statearr_37528 = state_37495;
(statearr_37528[(12)] = inst_37434);

(statearr_37528[(13)] = inst_37431);

(statearr_37528[(14)] = inst_37459);

(statearr_37528[(15)] = inst_37433);

(statearr_37528[(16)] = inst_37432);

return statearr_37528;
})();
var statearr_37529_37597 = state_37495__$1;
(statearr_37529_37597[(2)] = null);

(statearr_37529_37597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (3))){
var inst_37491 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37495__$1,inst_37491);
} else {
if((state_val_37496 === (12))){
var inst_37468 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37530_37600 = state_37495__$1;
(statearr_37530_37600[(2)] = inst_37468);

(statearr_37530_37600[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (2))){
var state_37495__$1 = state_37495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37495__$1,(4),ch);
} else {
if((state_val_37496 === (23))){
var state_37495__$1 = state_37495;
var statearr_37533_37601 = state_37495__$1;
(statearr_37533_37601[(2)] = null);

(statearr_37533_37601[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (19))){
var inst_37421 = (state_37495[(8)]);
var inst_37474 = (state_37495[(11)]);
var inst_37476 = cljs.core.async.muxch_STAR_(inst_37474);
var state_37495__$1 = state_37495;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37495__$1,(22),inst_37476,inst_37421);
} else {
if((state_val_37496 === (11))){
var inst_37431 = (state_37495[(13)]);
var inst_37447 = (state_37495[(10)]);
var inst_37447__$1 = cljs.core.seq(inst_37431);
var state_37495__$1 = (function (){var statearr_37535 = state_37495;
(statearr_37535[(10)] = inst_37447__$1);

return statearr_37535;
})();
if(inst_37447__$1){
var statearr_37539_37602 = state_37495__$1;
(statearr_37539_37602[(1)] = (13));

} else {
var statearr_37540_37603 = state_37495__$1;
(statearr_37540_37603[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (9))){
var inst_37470 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37541_37608 = state_37495__$1;
(statearr_37541_37608[(2)] = inst_37470);

(statearr_37541_37608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (5))){
var inst_37428 = cljs.core.deref(mults);
var inst_37429 = cljs.core.vals(inst_37428);
var inst_37430 = cljs.core.seq(inst_37429);
var inst_37431 = inst_37430;
var inst_37432 = null;
var inst_37433 = (0);
var inst_37434 = (0);
var state_37495__$1 = (function (){var statearr_37542 = state_37495;
(statearr_37542[(12)] = inst_37434);

(statearr_37542[(13)] = inst_37431);

(statearr_37542[(15)] = inst_37433);

(statearr_37542[(16)] = inst_37432);

return statearr_37542;
})();
var statearr_37543_37609 = state_37495__$1;
(statearr_37543_37609[(2)] = null);

(statearr_37543_37609[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (14))){
var state_37495__$1 = state_37495;
var statearr_37548_37610 = state_37495__$1;
(statearr_37548_37610[(2)] = null);

(statearr_37548_37610[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (16))){
var inst_37447 = (state_37495[(10)]);
var inst_37452 = cljs.core.chunk_first(inst_37447);
var inst_37453 = cljs.core.chunk_rest(inst_37447);
var inst_37454 = cljs.core.count(inst_37452);
var inst_37431 = inst_37453;
var inst_37432 = inst_37452;
var inst_37433 = inst_37454;
var inst_37434 = (0);
var state_37495__$1 = (function (){var statearr_37549 = state_37495;
(statearr_37549[(12)] = inst_37434);

(statearr_37549[(13)] = inst_37431);

(statearr_37549[(15)] = inst_37433);

(statearr_37549[(16)] = inst_37432);

return statearr_37549;
})();
var statearr_37550_37611 = state_37495__$1;
(statearr_37550_37611[(2)] = null);

(statearr_37550_37611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (10))){
var inst_37434 = (state_37495[(12)]);
var inst_37431 = (state_37495[(13)]);
var inst_37433 = (state_37495[(15)]);
var inst_37432 = (state_37495[(16)]);
var inst_37441 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37432,inst_37434);
var inst_37442 = cljs.core.async.muxch_STAR_(inst_37441);
var inst_37443 = cljs.core.async.close_BANG_(inst_37442);
var inst_37444 = (inst_37434 + (1));
var tmp37544 = inst_37431;
var tmp37545 = inst_37433;
var tmp37546 = inst_37432;
var inst_37431__$1 = tmp37544;
var inst_37432__$1 = tmp37546;
var inst_37433__$1 = tmp37545;
var inst_37434__$1 = inst_37444;
var state_37495__$1 = (function (){var statearr_37554 = state_37495;
(statearr_37554[(12)] = inst_37434__$1);

(statearr_37554[(13)] = inst_37431__$1);

(statearr_37554[(15)] = inst_37433__$1);

(statearr_37554[(16)] = inst_37432__$1);

(statearr_37554[(17)] = inst_37443);

return statearr_37554;
})();
var statearr_37555_37612 = state_37495__$1;
(statearr_37555_37612[(2)] = null);

(statearr_37555_37612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (18))){
var inst_37463 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37558_37613 = state_37495__$1;
(statearr_37558_37613[(2)] = inst_37463);

(statearr_37558_37613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (8))){
var inst_37434 = (state_37495[(12)]);
var inst_37433 = (state_37495[(15)]);
var inst_37436 = (inst_37434 < inst_37433);
var inst_37437 = inst_37436;
var state_37495__$1 = state_37495;
if(cljs.core.truth_(inst_37437)){
var statearr_37559_37614 = state_37495__$1;
(statearr_37559_37614[(1)] = (10));

} else {
var statearr_37560_37615 = state_37495__$1;
(statearr_37560_37615[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___37577,mults,ensure_mult,p))
;
return ((function (switch__35726__auto__,c__35868__auto___37577,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_37561 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37561[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_37561[(1)] = (1));

return statearr_37561;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_37495){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_37495);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e37562){if((e37562 instanceof Object)){
var ex__35730__auto__ = e37562;
var statearr_37563_37616 = state_37495;
(statearr_37563_37616[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37495);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37562;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37617 = state_37495;
state_37495 = G__37617;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_37495){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_37495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___37577,mults,ensure_mult,p))
})();
var state__35870__auto__ = (function (){var statearr_37564 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_37564[(6)] = c__35868__auto___37577);

return statearr_37564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___37577,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__37619 = arguments.length;
switch (G__37619) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__37631 = arguments.length;
switch (G__37631) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__37644 = arguments.length;
switch (G__37644) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__35868__auto___37755 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___37755,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___37755,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_37689){
var state_val_37690 = (state_37689[(1)]);
if((state_val_37690 === (7))){
var state_37689__$1 = state_37689;
var statearr_37696_37765 = state_37689__$1;
(statearr_37696_37765[(2)] = null);

(statearr_37696_37765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (1))){
var state_37689__$1 = state_37689;
var statearr_37699_37766 = state_37689__$1;
(statearr_37699_37766[(2)] = null);

(statearr_37699_37766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (4))){
var inst_37649 = (state_37689[(7)]);
var inst_37651 = (inst_37649 < cnt);
var state_37689__$1 = state_37689;
if(cljs.core.truth_(inst_37651)){
var statearr_37702_37769 = state_37689__$1;
(statearr_37702_37769[(1)] = (6));

} else {
var statearr_37703_37770 = state_37689__$1;
(statearr_37703_37770[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (15))){
var inst_37685 = (state_37689[(2)]);
var state_37689__$1 = state_37689;
var statearr_37707_37771 = state_37689__$1;
(statearr_37707_37771[(2)] = inst_37685);

(statearr_37707_37771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (13))){
var inst_37677 = cljs.core.async.close_BANG_(out);
var state_37689__$1 = state_37689;
var statearr_37710_37773 = state_37689__$1;
(statearr_37710_37773[(2)] = inst_37677);

(statearr_37710_37773[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (6))){
var state_37689__$1 = state_37689;
var statearr_37711_37774 = state_37689__$1;
(statearr_37711_37774[(2)] = null);

(statearr_37711_37774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (3))){
var inst_37687 = (state_37689[(2)]);
var state_37689__$1 = state_37689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37689__$1,inst_37687);
} else {
if((state_val_37690 === (12))){
var inst_37674 = (state_37689[(8)]);
var inst_37674__$1 = (state_37689[(2)]);
var inst_37675 = cljs.core.some(cljs.core.nil_QMARK_,inst_37674__$1);
var state_37689__$1 = (function (){var statearr_37720 = state_37689;
(statearr_37720[(8)] = inst_37674__$1);

return statearr_37720;
})();
if(cljs.core.truth_(inst_37675)){
var statearr_37721_37775 = state_37689__$1;
(statearr_37721_37775[(1)] = (13));

} else {
var statearr_37723_37776 = state_37689__$1;
(statearr_37723_37776[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (2))){
var inst_37648 = cljs.core.reset_BANG_(dctr,cnt);
var inst_37649 = (0);
var state_37689__$1 = (function (){var statearr_37724 = state_37689;
(statearr_37724[(9)] = inst_37648);

(statearr_37724[(7)] = inst_37649);

return statearr_37724;
})();
var statearr_37725_37778 = state_37689__$1;
(statearr_37725_37778[(2)] = null);

(statearr_37725_37778[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (11))){
var inst_37649 = (state_37689[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_37689,(10),Object,null,(9));
var inst_37659 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_37649) : chs__$1.call(null,inst_37649));
var inst_37660 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_37649) : done.call(null,inst_37649));
var inst_37661 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37659,inst_37660);
var state_37689__$1 = state_37689;
var statearr_37728_37782 = state_37689__$1;
(statearr_37728_37782[(2)] = inst_37661);


cljs.core.async.impl.ioc_helpers.process_exception(state_37689__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (9))){
var inst_37649 = (state_37689[(7)]);
var inst_37663 = (state_37689[(2)]);
var inst_37666 = (inst_37649 + (1));
var inst_37649__$1 = inst_37666;
var state_37689__$1 = (function (){var statearr_37730 = state_37689;
(statearr_37730[(7)] = inst_37649__$1);

(statearr_37730[(10)] = inst_37663);

return statearr_37730;
})();
var statearr_37731_37783 = state_37689__$1;
(statearr_37731_37783[(2)] = null);

(statearr_37731_37783[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (5))){
var inst_37672 = (state_37689[(2)]);
var state_37689__$1 = (function (){var statearr_37732 = state_37689;
(statearr_37732[(11)] = inst_37672);

return statearr_37732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37689__$1,(12),dchan);
} else {
if((state_val_37690 === (14))){
var inst_37674 = (state_37689[(8)]);
var inst_37680 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_37674);
var state_37689__$1 = state_37689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37689__$1,(16),out,inst_37680);
} else {
if((state_val_37690 === (16))){
var inst_37682 = (state_37689[(2)]);
var state_37689__$1 = (function (){var statearr_37736 = state_37689;
(statearr_37736[(12)] = inst_37682);

return statearr_37736;
})();
var statearr_37737_37784 = state_37689__$1;
(statearr_37737_37784[(2)] = null);

(statearr_37737_37784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (10))){
var inst_37654 = (state_37689[(2)]);
var inst_37655 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_37689__$1 = (function (){var statearr_37739 = state_37689;
(statearr_37739[(13)] = inst_37654);

return statearr_37739;
})();
var statearr_37740_37785 = state_37689__$1;
(statearr_37740_37785[(2)] = inst_37655);


cljs.core.async.impl.ioc_helpers.process_exception(state_37689__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37690 === (8))){
var inst_37670 = (state_37689[(2)]);
var state_37689__$1 = state_37689;
var statearr_37741_37786 = state_37689__$1;
(statearr_37741_37786[(2)] = inst_37670);

(statearr_37741_37786[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___37755,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__35726__auto__,c__35868__auto___37755,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_37744 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37744[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_37744[(1)] = (1));

return statearr_37744;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_37689){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_37689);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e37746){if((e37746 instanceof Object)){
var ex__35730__auto__ = e37746;
var statearr_37747_37791 = state_37689;
(statearr_37747_37791[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37746;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37794 = state_37689;
state_37689 = G__37794;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_37689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_37689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___37755,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__35870__auto__ = (function (){var statearr_37749 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_37749[(6)] = c__35868__auto___37755);

return statearr_37749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___37755,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__37801 = arguments.length;
switch (G__37801) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__35868__auto___37884 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___37884,out){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___37884,out){
return (function (state_37843){
var state_val_37844 = (state_37843[(1)]);
if((state_val_37844 === (7))){
var inst_37818 = (state_37843[(7)]);
var inst_37820 = (state_37843[(8)]);
var inst_37818__$1 = (state_37843[(2)]);
var inst_37820__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37818__$1,(0),null);
var inst_37821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37818__$1,(1),null);
var inst_37822 = (inst_37820__$1 == null);
var state_37843__$1 = (function (){var statearr_37848 = state_37843;
(statearr_37848[(7)] = inst_37818__$1);

(statearr_37848[(8)] = inst_37820__$1);

(statearr_37848[(9)] = inst_37821);

return statearr_37848;
})();
if(cljs.core.truth_(inst_37822)){
var statearr_37849_37887 = state_37843__$1;
(statearr_37849_37887[(1)] = (8));

} else {
var statearr_37850_37888 = state_37843__$1;
(statearr_37850_37888[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (1))){
var inst_37807 = cljs.core.vec(chs);
var inst_37808 = inst_37807;
var state_37843__$1 = (function (){var statearr_37851 = state_37843;
(statearr_37851[(10)] = inst_37808);

return statearr_37851;
})();
var statearr_37852_37898 = state_37843__$1;
(statearr_37852_37898[(2)] = null);

(statearr_37852_37898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (4))){
var inst_37808 = (state_37843[(10)]);
var state_37843__$1 = state_37843;
return cljs.core.async.ioc_alts_BANG_(state_37843__$1,(7),inst_37808);
} else {
if((state_val_37844 === (6))){
var inst_37839 = (state_37843[(2)]);
var state_37843__$1 = state_37843;
var statearr_37854_37899 = state_37843__$1;
(statearr_37854_37899[(2)] = inst_37839);

(statearr_37854_37899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (3))){
var inst_37841 = (state_37843[(2)]);
var state_37843__$1 = state_37843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37843__$1,inst_37841);
} else {
if((state_val_37844 === (2))){
var inst_37808 = (state_37843[(10)]);
var inst_37811 = cljs.core.count(inst_37808);
var inst_37812 = (inst_37811 > (0));
var state_37843__$1 = state_37843;
if(cljs.core.truth_(inst_37812)){
var statearr_37857_37902 = state_37843__$1;
(statearr_37857_37902[(1)] = (4));

} else {
var statearr_37858_37903 = state_37843__$1;
(statearr_37858_37903[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (11))){
var inst_37808 = (state_37843[(10)]);
var inst_37832 = (state_37843[(2)]);
var tmp37855 = inst_37808;
var inst_37808__$1 = tmp37855;
var state_37843__$1 = (function (){var statearr_37859 = state_37843;
(statearr_37859[(10)] = inst_37808__$1);

(statearr_37859[(11)] = inst_37832);

return statearr_37859;
})();
var statearr_37860_37905 = state_37843__$1;
(statearr_37860_37905[(2)] = null);

(statearr_37860_37905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (9))){
var inst_37820 = (state_37843[(8)]);
var state_37843__$1 = state_37843;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37843__$1,(11),out,inst_37820);
} else {
if((state_val_37844 === (5))){
var inst_37837 = cljs.core.async.close_BANG_(out);
var state_37843__$1 = state_37843;
var statearr_37868_37906 = state_37843__$1;
(statearr_37868_37906[(2)] = inst_37837);

(statearr_37868_37906[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (10))){
var inst_37835 = (state_37843[(2)]);
var state_37843__$1 = state_37843;
var statearr_37871_37907 = state_37843__$1;
(statearr_37871_37907[(2)] = inst_37835);

(statearr_37871_37907[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37844 === (8))){
var inst_37818 = (state_37843[(7)]);
var inst_37808 = (state_37843[(10)]);
var inst_37820 = (state_37843[(8)]);
var inst_37821 = (state_37843[(9)]);
var inst_37827 = (function (){var cs = inst_37808;
var vec__37814 = inst_37818;
var v = inst_37820;
var c = inst_37821;
return ((function (cs,vec__37814,v,c,inst_37818,inst_37808,inst_37820,inst_37821,state_val_37844,c__35868__auto___37884,out){
return (function (p1__37797_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__37797_SHARP_);
});
;})(cs,vec__37814,v,c,inst_37818,inst_37808,inst_37820,inst_37821,state_val_37844,c__35868__auto___37884,out))
})();
var inst_37828 = cljs.core.filterv(inst_37827,inst_37808);
var inst_37808__$1 = inst_37828;
var state_37843__$1 = (function (){var statearr_37875 = state_37843;
(statearr_37875[(10)] = inst_37808__$1);

return statearr_37875;
})();
var statearr_37876_37909 = state_37843__$1;
(statearr_37876_37909[(2)] = null);

(statearr_37876_37909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___37884,out))
;
return ((function (switch__35726__auto__,c__35868__auto___37884,out){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_37877 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37877[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_37877[(1)] = (1));

return statearr_37877;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_37843){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_37843);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e37878){if((e37878 instanceof Object)){
var ex__35730__auto__ = e37878;
var statearr_37879_37911 = state_37843;
(statearr_37879_37911[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37843);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37878;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37912 = state_37843;
state_37843 = G__37912;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_37843){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_37843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___37884,out))
})();
var state__35870__auto__ = (function (){var statearr_37881 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_37881[(6)] = c__35868__auto___37884);

return statearr_37881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___37884,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__37914 = arguments.length;
switch (G__37914) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__35868__auto___37984 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___37984,out){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___37984,out){
return (function (state_37945){
var state_val_37946 = (state_37945[(1)]);
if((state_val_37946 === (7))){
var inst_37925 = (state_37945[(7)]);
var inst_37925__$1 = (state_37945[(2)]);
var inst_37927 = (inst_37925__$1 == null);
var inst_37928 = cljs.core.not(inst_37927);
var state_37945__$1 = (function (){var statearr_37950 = state_37945;
(statearr_37950[(7)] = inst_37925__$1);

return statearr_37950;
})();
if(inst_37928){
var statearr_37951_37987 = state_37945__$1;
(statearr_37951_37987[(1)] = (8));

} else {
var statearr_37953_37988 = state_37945__$1;
(statearr_37953_37988[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (1))){
var inst_37919 = (0);
var state_37945__$1 = (function (){var statearr_37954 = state_37945;
(statearr_37954[(8)] = inst_37919);

return statearr_37954;
})();
var statearr_37955_37989 = state_37945__$1;
(statearr_37955_37989[(2)] = null);

(statearr_37955_37989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (4))){
var state_37945__$1 = state_37945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37945__$1,(7),ch);
} else {
if((state_val_37946 === (6))){
var inst_37939 = (state_37945[(2)]);
var state_37945__$1 = state_37945;
var statearr_37959_37990 = state_37945__$1;
(statearr_37959_37990[(2)] = inst_37939);

(statearr_37959_37990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (3))){
var inst_37941 = (state_37945[(2)]);
var inst_37942 = cljs.core.async.close_BANG_(out);
var state_37945__$1 = (function (){var statearr_37960 = state_37945;
(statearr_37960[(9)] = inst_37941);

return statearr_37960;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_37945__$1,inst_37942);
} else {
if((state_val_37946 === (2))){
var inst_37919 = (state_37945[(8)]);
var inst_37921 = (inst_37919 < n);
var state_37945__$1 = state_37945;
if(cljs.core.truth_(inst_37921)){
var statearr_37961_37993 = state_37945__$1;
(statearr_37961_37993[(1)] = (4));

} else {
var statearr_37962_37994 = state_37945__$1;
(statearr_37962_37994[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (11))){
var inst_37919 = (state_37945[(8)]);
var inst_37931 = (state_37945[(2)]);
var inst_37932 = (inst_37919 + (1));
var inst_37919__$1 = inst_37932;
var state_37945__$1 = (function (){var statearr_37963 = state_37945;
(statearr_37963[(10)] = inst_37931);

(statearr_37963[(8)] = inst_37919__$1);

return statearr_37963;
})();
var statearr_37964_37995 = state_37945__$1;
(statearr_37964_37995[(2)] = null);

(statearr_37964_37995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (9))){
var state_37945__$1 = state_37945;
var statearr_37965_37997 = state_37945__$1;
(statearr_37965_37997[(2)] = null);

(statearr_37965_37997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (5))){
var state_37945__$1 = state_37945;
var statearr_37968_37998 = state_37945__$1;
(statearr_37968_37998[(2)] = null);

(statearr_37968_37998[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (10))){
var inst_37936 = (state_37945[(2)]);
var state_37945__$1 = state_37945;
var statearr_37969_37999 = state_37945__$1;
(statearr_37969_37999[(2)] = inst_37936);

(statearr_37969_37999[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37946 === (8))){
var inst_37925 = (state_37945[(7)]);
var state_37945__$1 = state_37945;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37945__$1,(11),out,inst_37925);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___37984,out))
;
return ((function (switch__35726__auto__,c__35868__auto___37984,out){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_37973 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37973[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_37973[(1)] = (1));

return statearr_37973;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_37945){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_37945);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e37974){if((e37974 instanceof Object)){
var ex__35730__auto__ = e37974;
var statearr_37975_38002 = state_37945;
(statearr_37975_38002[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37945);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37974;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38005 = state_37945;
state_37945 = G__38005;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_37945){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_37945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___37984,out))
})();
var state__35870__auto__ = (function (){var statearr_37976 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_37976[(6)] = c__35868__auto___37984);

return statearr_37976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___37984,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38013 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38013 = (function (f,ch,meta38014){
this.f = f;
this.ch = ch;
this.meta38014 = meta38014;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38015,meta38014__$1){
var self__ = this;
var _38015__$1 = this;
return (new cljs.core.async.t_cljs$core$async38013(self__.f,self__.ch,meta38014__$1));
});

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38015){
var self__ = this;
var _38015__$1 = this;
return self__.meta38014;
});

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38019 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38019 = (function (f,ch,meta38014,_,fn1,meta38020){
this.f = f;
this.ch = ch;
this.meta38014 = meta38014;
this._ = _;
this.fn1 = fn1;
this.meta38020 = meta38020;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_38021,meta38020__$1){
var self__ = this;
var _38021__$1 = this;
return (new cljs.core.async.t_cljs$core$async38019(self__.f,self__.ch,self__.meta38014,self__._,self__.fn1,meta38020__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async38019.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_38021){
var self__ = this;
var _38021__$1 = this;
return self__.meta38020;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38019.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38019.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38019.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async38019.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__38008_SHARP_){
var G__38027 = (((p1__38008_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38008_SHARP_) : self__.f.call(null,p1__38008_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38027) : f1.call(null,G__38027));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async38019.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38014","meta38014",1991364342,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async38013","cljs.core.async/t_cljs$core$async38013",-1409608492,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta38020","meta38020",-769362983,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async38019.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38019.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38019";

cljs.core.async.t_cljs$core$async38019.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async38019");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38019.
 */
cljs.core.async.__GT_t_cljs$core$async38019 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38019(f__$1,ch__$1,meta38014__$1,___$2,fn1__$1,meta38020){
return (new cljs.core.async.t_cljs$core$async38019(f__$1,ch__$1,meta38014__$1,___$2,fn1__$1,meta38020));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async38019(self__.f,self__.ch,self__.meta38014,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38031 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38031) : self__.f.call(null,G__38031));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38013.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async38013.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38014","meta38014",1991364342,null)], null);
});

cljs.core.async.t_cljs$core$async38013.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38013.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38013";

cljs.core.async.t_cljs$core$async38013.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async38013");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38013.
 */
cljs.core.async.__GT_t_cljs$core$async38013 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38013(f__$1,ch__$1,meta38014){
return (new cljs.core.async.t_cljs$core$async38013(f__$1,ch__$1,meta38014));
});

}

return (new cljs.core.async.t_cljs$core$async38013(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38052 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38052 = (function (f,ch,meta38053){
this.f = f;
this.ch = ch;
this.meta38053 = meta38053;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38054,meta38053__$1){
var self__ = this;
var _38054__$1 = this;
return (new cljs.core.async.t_cljs$core$async38052(self__.f,self__.ch,meta38053__$1));
});

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38054){
var self__ = this;
var _38054__$1 = this;
return self__.meta38053;
});

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38052.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async38052.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38053","meta38053",1000788110,null)], null);
});

cljs.core.async.t_cljs$core$async38052.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38052.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38052";

cljs.core.async.t_cljs$core$async38052.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async38052");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38052.
 */
cljs.core.async.__GT_t_cljs$core$async38052 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38052(f__$1,ch__$1,meta38053){
return (new cljs.core.async.t_cljs$core$async38052(f__$1,ch__$1,meta38053));
});

}

return (new cljs.core.async.t_cljs$core$async38052(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38064 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38064 = (function (p,ch,meta38065){
this.p = p;
this.ch = ch;
this.meta38065 = meta38065;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38066,meta38065__$1){
var self__ = this;
var _38066__$1 = this;
return (new cljs.core.async.t_cljs$core$async38064(self__.p,self__.ch,meta38065__$1));
});

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38066){
var self__ = this;
var _38066__$1 = this;
return self__.meta38065;
});

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38064.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async38064.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38065","meta38065",-125516959,null)], null);
});

cljs.core.async.t_cljs$core$async38064.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38064.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38064";

cljs.core.async.t_cljs$core$async38064.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async38064");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38064.
 */
cljs.core.async.__GT_t_cljs$core$async38064 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38064(p__$1,ch__$1,meta38065){
return (new cljs.core.async.t_cljs$core$async38064(p__$1,ch__$1,meta38065));
});

}

return (new cljs.core.async.t_cljs$core$async38064(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__38083 = arguments.length;
switch (G__38083) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__35868__auto___38129 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___38129,out){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___38129,out){
return (function (state_38105){
var state_val_38106 = (state_38105[(1)]);
if((state_val_38106 === (7))){
var inst_38101 = (state_38105[(2)]);
var state_38105__$1 = state_38105;
var statearr_38107_38130 = state_38105__$1;
(statearr_38107_38130[(2)] = inst_38101);

(statearr_38107_38130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (1))){
var state_38105__$1 = state_38105;
var statearr_38108_38131 = state_38105__$1;
(statearr_38108_38131[(2)] = null);

(statearr_38108_38131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (4))){
var inst_38087 = (state_38105[(7)]);
var inst_38087__$1 = (state_38105[(2)]);
var inst_38088 = (inst_38087__$1 == null);
var state_38105__$1 = (function (){var statearr_38110 = state_38105;
(statearr_38110[(7)] = inst_38087__$1);

return statearr_38110;
})();
if(cljs.core.truth_(inst_38088)){
var statearr_38114_38132 = state_38105__$1;
(statearr_38114_38132[(1)] = (5));

} else {
var statearr_38115_38133 = state_38105__$1;
(statearr_38115_38133[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (6))){
var inst_38087 = (state_38105[(7)]);
var inst_38092 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38087) : p.call(null,inst_38087));
var state_38105__$1 = state_38105;
if(cljs.core.truth_(inst_38092)){
var statearr_38116_38134 = state_38105__$1;
(statearr_38116_38134[(1)] = (8));

} else {
var statearr_38117_38135 = state_38105__$1;
(statearr_38117_38135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (3))){
var inst_38103 = (state_38105[(2)]);
var state_38105__$1 = state_38105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38105__$1,inst_38103);
} else {
if((state_val_38106 === (2))){
var state_38105__$1 = state_38105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38105__$1,(4),ch);
} else {
if((state_val_38106 === (11))){
var inst_38095 = (state_38105[(2)]);
var state_38105__$1 = state_38105;
var statearr_38118_38136 = state_38105__$1;
(statearr_38118_38136[(2)] = inst_38095);

(statearr_38118_38136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (9))){
var state_38105__$1 = state_38105;
var statearr_38119_38137 = state_38105__$1;
(statearr_38119_38137[(2)] = null);

(statearr_38119_38137[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (5))){
var inst_38090 = cljs.core.async.close_BANG_(out);
var state_38105__$1 = state_38105;
var statearr_38120_38138 = state_38105__$1;
(statearr_38120_38138[(2)] = inst_38090);

(statearr_38120_38138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (10))){
var inst_38098 = (state_38105[(2)]);
var state_38105__$1 = (function (){var statearr_38121 = state_38105;
(statearr_38121[(8)] = inst_38098);

return statearr_38121;
})();
var statearr_38122_38139 = state_38105__$1;
(statearr_38122_38139[(2)] = null);

(statearr_38122_38139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38106 === (8))){
var inst_38087 = (state_38105[(7)]);
var state_38105__$1 = state_38105;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38105__$1,(11),out,inst_38087);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___38129,out))
;
return ((function (switch__35726__auto__,c__35868__auto___38129,out){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_38123 = [null,null,null,null,null,null,null,null,null];
(statearr_38123[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_38123[(1)] = (1));

return statearr_38123;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_38105){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_38105);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e38124){if((e38124 instanceof Object)){
var ex__35730__auto__ = e38124;
var statearr_38125_38140 = state_38105;
(statearr_38125_38140[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38105);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38124;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38141 = state_38105;
state_38105 = G__38141;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_38105){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_38105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___38129,out))
})();
var state__35870__auto__ = (function (){var statearr_38126 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_38126[(6)] = c__35868__auto___38129);

return statearr_38126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___38129,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__38143 = arguments.length;
switch (G__38143) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__35868__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto__){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto__){
return (function (state_38206){
var state_val_38207 = (state_38206[(1)]);
if((state_val_38207 === (7))){
var inst_38202 = (state_38206[(2)]);
var state_38206__$1 = state_38206;
var statearr_38208_38268 = state_38206__$1;
(statearr_38208_38268[(2)] = inst_38202);

(statearr_38208_38268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (20))){
var inst_38172 = (state_38206[(7)]);
var inst_38183 = (state_38206[(2)]);
var inst_38184 = cljs.core.next(inst_38172);
var inst_38158 = inst_38184;
var inst_38159 = null;
var inst_38160 = (0);
var inst_38161 = (0);
var state_38206__$1 = (function (){var statearr_38212 = state_38206;
(statearr_38212[(8)] = inst_38159);

(statearr_38212[(9)] = inst_38158);

(statearr_38212[(10)] = inst_38160);

(statearr_38212[(11)] = inst_38161);

(statearr_38212[(12)] = inst_38183);

return statearr_38212;
})();
var statearr_38214_38269 = state_38206__$1;
(statearr_38214_38269[(2)] = null);

(statearr_38214_38269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (1))){
var state_38206__$1 = state_38206;
var statearr_38216_38274 = state_38206__$1;
(statearr_38216_38274[(2)] = null);

(statearr_38216_38274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (4))){
var inst_38147 = (state_38206[(13)]);
var inst_38147__$1 = (state_38206[(2)]);
var inst_38148 = (inst_38147__$1 == null);
var state_38206__$1 = (function (){var statearr_38217 = state_38206;
(statearr_38217[(13)] = inst_38147__$1);

return statearr_38217;
})();
if(cljs.core.truth_(inst_38148)){
var statearr_38219_38279 = state_38206__$1;
(statearr_38219_38279[(1)] = (5));

} else {
var statearr_38220_38280 = state_38206__$1;
(statearr_38220_38280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (15))){
var state_38206__$1 = state_38206;
var statearr_38224_38281 = state_38206__$1;
(statearr_38224_38281[(2)] = null);

(statearr_38224_38281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (21))){
var state_38206__$1 = state_38206;
var statearr_38225_38286 = state_38206__$1;
(statearr_38225_38286[(2)] = null);

(statearr_38225_38286[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (13))){
var inst_38159 = (state_38206[(8)]);
var inst_38158 = (state_38206[(9)]);
var inst_38160 = (state_38206[(10)]);
var inst_38161 = (state_38206[(11)]);
var inst_38168 = (state_38206[(2)]);
var inst_38169 = (inst_38161 + (1));
var tmp38221 = inst_38159;
var tmp38222 = inst_38158;
var tmp38223 = inst_38160;
var inst_38158__$1 = tmp38222;
var inst_38159__$1 = tmp38221;
var inst_38160__$1 = tmp38223;
var inst_38161__$1 = inst_38169;
var state_38206__$1 = (function (){var statearr_38230 = state_38206;
(statearr_38230[(14)] = inst_38168);

(statearr_38230[(8)] = inst_38159__$1);

(statearr_38230[(9)] = inst_38158__$1);

(statearr_38230[(10)] = inst_38160__$1);

(statearr_38230[(11)] = inst_38161__$1);

return statearr_38230;
})();
var statearr_38231_38287 = state_38206__$1;
(statearr_38231_38287[(2)] = null);

(statearr_38231_38287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (22))){
var state_38206__$1 = state_38206;
var statearr_38232_38288 = state_38206__$1;
(statearr_38232_38288[(2)] = null);

(statearr_38232_38288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (6))){
var inst_38147 = (state_38206[(13)]);
var inst_38156 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38147) : f.call(null,inst_38147));
var inst_38157 = cljs.core.seq(inst_38156);
var inst_38158 = inst_38157;
var inst_38159 = null;
var inst_38160 = (0);
var inst_38161 = (0);
var state_38206__$1 = (function (){var statearr_38233 = state_38206;
(statearr_38233[(8)] = inst_38159);

(statearr_38233[(9)] = inst_38158);

(statearr_38233[(10)] = inst_38160);

(statearr_38233[(11)] = inst_38161);

return statearr_38233;
})();
var statearr_38237_38289 = state_38206__$1;
(statearr_38237_38289[(2)] = null);

(statearr_38237_38289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (17))){
var inst_38172 = (state_38206[(7)]);
var inst_38176 = cljs.core.chunk_first(inst_38172);
var inst_38177 = cljs.core.chunk_rest(inst_38172);
var inst_38178 = cljs.core.count(inst_38176);
var inst_38158 = inst_38177;
var inst_38159 = inst_38176;
var inst_38160 = inst_38178;
var inst_38161 = (0);
var state_38206__$1 = (function (){var statearr_38241 = state_38206;
(statearr_38241[(8)] = inst_38159);

(statearr_38241[(9)] = inst_38158);

(statearr_38241[(10)] = inst_38160);

(statearr_38241[(11)] = inst_38161);

return statearr_38241;
})();
var statearr_38242_38291 = state_38206__$1;
(statearr_38242_38291[(2)] = null);

(statearr_38242_38291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (3))){
var inst_38204 = (state_38206[(2)]);
var state_38206__$1 = state_38206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38206__$1,inst_38204);
} else {
if((state_val_38207 === (12))){
var inst_38192 = (state_38206[(2)]);
var state_38206__$1 = state_38206;
var statearr_38247_38292 = state_38206__$1;
(statearr_38247_38292[(2)] = inst_38192);

(statearr_38247_38292[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (2))){
var state_38206__$1 = state_38206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38206__$1,(4),in$);
} else {
if((state_val_38207 === (23))){
var inst_38200 = (state_38206[(2)]);
var state_38206__$1 = state_38206;
var statearr_38248_38293 = state_38206__$1;
(statearr_38248_38293[(2)] = inst_38200);

(statearr_38248_38293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (19))){
var inst_38187 = (state_38206[(2)]);
var state_38206__$1 = state_38206;
var statearr_38249_38294 = state_38206__$1;
(statearr_38249_38294[(2)] = inst_38187);

(statearr_38249_38294[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (11))){
var inst_38158 = (state_38206[(9)]);
var inst_38172 = (state_38206[(7)]);
var inst_38172__$1 = cljs.core.seq(inst_38158);
var state_38206__$1 = (function (){var statearr_38250 = state_38206;
(statearr_38250[(7)] = inst_38172__$1);

return statearr_38250;
})();
if(inst_38172__$1){
var statearr_38251_38300 = state_38206__$1;
(statearr_38251_38300[(1)] = (14));

} else {
var statearr_38252_38301 = state_38206__$1;
(statearr_38252_38301[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (9))){
var inst_38194 = (state_38206[(2)]);
var inst_38195 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38206__$1 = (function (){var statearr_38254 = state_38206;
(statearr_38254[(15)] = inst_38194);

return statearr_38254;
})();
if(cljs.core.truth_(inst_38195)){
var statearr_38255_38302 = state_38206__$1;
(statearr_38255_38302[(1)] = (21));

} else {
var statearr_38256_38303 = state_38206__$1;
(statearr_38256_38303[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (5))){
var inst_38150 = cljs.core.async.close_BANG_(out);
var state_38206__$1 = state_38206;
var statearr_38257_38304 = state_38206__$1;
(statearr_38257_38304[(2)] = inst_38150);

(statearr_38257_38304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (14))){
var inst_38172 = (state_38206[(7)]);
var inst_38174 = cljs.core.chunked_seq_QMARK_(inst_38172);
var state_38206__$1 = state_38206;
if(inst_38174){
var statearr_38258_38305 = state_38206__$1;
(statearr_38258_38305[(1)] = (17));

} else {
var statearr_38259_38306 = state_38206__$1;
(statearr_38259_38306[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (16))){
var inst_38190 = (state_38206[(2)]);
var state_38206__$1 = state_38206;
var statearr_38260_38307 = state_38206__$1;
(statearr_38260_38307[(2)] = inst_38190);

(statearr_38260_38307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38207 === (10))){
var inst_38159 = (state_38206[(8)]);
var inst_38161 = (state_38206[(11)]);
var inst_38166 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_38159,inst_38161);
var state_38206__$1 = state_38206;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38206__$1,(13),out,inst_38166);
} else {
if((state_val_38207 === (18))){
var inst_38172 = (state_38206[(7)]);
var inst_38181 = cljs.core.first(inst_38172);
var state_38206__$1 = state_38206;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38206__$1,(20),out,inst_38181);
} else {
if((state_val_38207 === (8))){
var inst_38160 = (state_38206[(10)]);
var inst_38161 = (state_38206[(11)]);
var inst_38163 = (inst_38161 < inst_38160);
var inst_38164 = inst_38163;
var state_38206__$1 = state_38206;
if(cljs.core.truth_(inst_38164)){
var statearr_38261_38308 = state_38206__$1;
(statearr_38261_38308[(1)] = (10));

} else {
var statearr_38262_38332 = state_38206__$1;
(statearr_38262_38332[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto__))
;
return ((function (switch__35726__auto__,c__35868__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__35727__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__35727__auto____0 = (function (){
var statearr_38264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38264[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__35727__auto__);

(statearr_38264[(1)] = (1));

return statearr_38264;
});
var cljs$core$async$mapcat_STAR__$_state_machine__35727__auto____1 = (function (state_38206){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_38206);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e38265){if((e38265 instanceof Object)){
var ex__35730__auto__ = e38265;
var statearr_38266_38335 = state_38206;
(statearr_38266_38335[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38265;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38336 = state_38206;
state_38206 = G__38336;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__35727__auto__ = function(state_38206){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__35727__auto____1.call(this,state_38206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__35727__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__35727__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto__))
})();
var state__35870__auto__ = (function (){var statearr_38267 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_38267[(6)] = c__35868__auto__);

return statearr_38267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto__))
);

return c__35868__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__38346 = arguments.length;
switch (G__38346) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__38360 = arguments.length;
switch (G__38360) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__38374 = arguments.length;
switch (G__38374) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__35868__auto___38464 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___38464,out){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___38464,out){
return (function (state_38403){
var state_val_38404 = (state_38403[(1)]);
if((state_val_38404 === (7))){
var inst_38398 = (state_38403[(2)]);
var state_38403__$1 = state_38403;
var statearr_38412_38465 = state_38403__$1;
(statearr_38412_38465[(2)] = inst_38398);

(statearr_38412_38465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (1))){
var inst_38380 = null;
var state_38403__$1 = (function (){var statearr_38413 = state_38403;
(statearr_38413[(7)] = inst_38380);

return statearr_38413;
})();
var statearr_38414_38469 = state_38403__$1;
(statearr_38414_38469[(2)] = null);

(statearr_38414_38469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (4))){
var inst_38383 = (state_38403[(8)]);
var inst_38383__$1 = (state_38403[(2)]);
var inst_38384 = (inst_38383__$1 == null);
var inst_38385 = cljs.core.not(inst_38384);
var state_38403__$1 = (function (){var statearr_38417 = state_38403;
(statearr_38417[(8)] = inst_38383__$1);

return statearr_38417;
})();
if(inst_38385){
var statearr_38418_38471 = state_38403__$1;
(statearr_38418_38471[(1)] = (5));

} else {
var statearr_38419_38472 = state_38403__$1;
(statearr_38419_38472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (6))){
var state_38403__$1 = state_38403;
var statearr_38420_38476 = state_38403__$1;
(statearr_38420_38476[(2)] = null);

(statearr_38420_38476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (3))){
var inst_38400 = (state_38403[(2)]);
var inst_38401 = cljs.core.async.close_BANG_(out);
var state_38403__$1 = (function (){var statearr_38421 = state_38403;
(statearr_38421[(9)] = inst_38400);

return statearr_38421;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38403__$1,inst_38401);
} else {
if((state_val_38404 === (2))){
var state_38403__$1 = state_38403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38403__$1,(4),ch);
} else {
if((state_val_38404 === (11))){
var inst_38383 = (state_38403[(8)]);
var inst_38392 = (state_38403[(2)]);
var inst_38380 = inst_38383;
var state_38403__$1 = (function (){var statearr_38422 = state_38403;
(statearr_38422[(7)] = inst_38380);

(statearr_38422[(10)] = inst_38392);

return statearr_38422;
})();
var statearr_38423_38478 = state_38403__$1;
(statearr_38423_38478[(2)] = null);

(statearr_38423_38478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (9))){
var inst_38383 = (state_38403[(8)]);
var state_38403__$1 = state_38403;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38403__$1,(11),out,inst_38383);
} else {
if((state_val_38404 === (5))){
var inst_38383 = (state_38403[(8)]);
var inst_38380 = (state_38403[(7)]);
var inst_38387 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38383,inst_38380);
var state_38403__$1 = state_38403;
if(inst_38387){
var statearr_38425_38480 = state_38403__$1;
(statearr_38425_38480[(1)] = (8));

} else {
var statearr_38426_38481 = state_38403__$1;
(statearr_38426_38481[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (10))){
var inst_38395 = (state_38403[(2)]);
var state_38403__$1 = state_38403;
var statearr_38428_38482 = state_38403__$1;
(statearr_38428_38482[(2)] = inst_38395);

(statearr_38428_38482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38404 === (8))){
var inst_38380 = (state_38403[(7)]);
var tmp38424 = inst_38380;
var inst_38380__$1 = tmp38424;
var state_38403__$1 = (function (){var statearr_38432 = state_38403;
(statearr_38432[(7)] = inst_38380__$1);

return statearr_38432;
})();
var statearr_38433_38483 = state_38403__$1;
(statearr_38433_38483[(2)] = null);

(statearr_38433_38483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___38464,out))
;
return ((function (switch__35726__auto__,c__35868__auto___38464,out){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_38443 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38443[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_38443[(1)] = (1));

return statearr_38443;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_38403){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_38403);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e38446){if((e38446 instanceof Object)){
var ex__35730__auto__ = e38446;
var statearr_38447_38484 = state_38403;
(statearr_38447_38484[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38403);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38446;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38485 = state_38403;
state_38403 = G__38485;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_38403){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_38403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___38464,out))
})();
var state__35870__auto__ = (function (){var statearr_38461 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_38461[(6)] = c__35868__auto___38464);

return statearr_38461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___38464,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__38488 = arguments.length;
switch (G__38488) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__35868__auto___38564 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___38564,out){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___38564,out){
return (function (state_38527){
var state_val_38528 = (state_38527[(1)]);
if((state_val_38528 === (7))){
var inst_38523 = (state_38527[(2)]);
var state_38527__$1 = state_38527;
var statearr_38529_38565 = state_38527__$1;
(statearr_38529_38565[(2)] = inst_38523);

(statearr_38529_38565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (1))){
var inst_38489 = (new Array(n));
var inst_38491 = inst_38489;
var inst_38492 = (0);
var state_38527__$1 = (function (){var statearr_38530 = state_38527;
(statearr_38530[(7)] = inst_38492);

(statearr_38530[(8)] = inst_38491);

return statearr_38530;
})();
var statearr_38531_38567 = state_38527__$1;
(statearr_38531_38567[(2)] = null);

(statearr_38531_38567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (4))){
var inst_38495 = (state_38527[(9)]);
var inst_38495__$1 = (state_38527[(2)]);
var inst_38496 = (inst_38495__$1 == null);
var inst_38497 = cljs.core.not(inst_38496);
var state_38527__$1 = (function (){var statearr_38532 = state_38527;
(statearr_38532[(9)] = inst_38495__$1);

return statearr_38532;
})();
if(inst_38497){
var statearr_38533_38568 = state_38527__$1;
(statearr_38533_38568[(1)] = (5));

} else {
var statearr_38534_38569 = state_38527__$1;
(statearr_38534_38569[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (15))){
var inst_38517 = (state_38527[(2)]);
var state_38527__$1 = state_38527;
var statearr_38535_38570 = state_38527__$1;
(statearr_38535_38570[(2)] = inst_38517);

(statearr_38535_38570[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (13))){
var state_38527__$1 = state_38527;
var statearr_38536_38571 = state_38527__$1;
(statearr_38536_38571[(2)] = null);

(statearr_38536_38571[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (6))){
var inst_38492 = (state_38527[(7)]);
var inst_38513 = (inst_38492 > (0));
var state_38527__$1 = state_38527;
if(cljs.core.truth_(inst_38513)){
var statearr_38537_38572 = state_38527__$1;
(statearr_38537_38572[(1)] = (12));

} else {
var statearr_38538_38573 = state_38527__$1;
(statearr_38538_38573[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (3))){
var inst_38525 = (state_38527[(2)]);
var state_38527__$1 = state_38527;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38527__$1,inst_38525);
} else {
if((state_val_38528 === (12))){
var inst_38491 = (state_38527[(8)]);
var inst_38515 = cljs.core.vec(inst_38491);
var state_38527__$1 = state_38527;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38527__$1,(15),out,inst_38515);
} else {
if((state_val_38528 === (2))){
var state_38527__$1 = state_38527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38527__$1,(4),ch);
} else {
if((state_val_38528 === (11))){
var inst_38507 = (state_38527[(2)]);
var inst_38508 = (new Array(n));
var inst_38491 = inst_38508;
var inst_38492 = (0);
var state_38527__$1 = (function (){var statearr_38543 = state_38527;
(statearr_38543[(7)] = inst_38492);

(statearr_38543[(10)] = inst_38507);

(statearr_38543[(8)] = inst_38491);

return statearr_38543;
})();
var statearr_38544_38574 = state_38527__$1;
(statearr_38544_38574[(2)] = null);

(statearr_38544_38574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (9))){
var inst_38491 = (state_38527[(8)]);
var inst_38505 = cljs.core.vec(inst_38491);
var state_38527__$1 = state_38527;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38527__$1,(11),out,inst_38505);
} else {
if((state_val_38528 === (5))){
var inst_38492 = (state_38527[(7)]);
var inst_38491 = (state_38527[(8)]);
var inst_38495 = (state_38527[(9)]);
var inst_38500 = (state_38527[(11)]);
var inst_38499 = (inst_38491[inst_38492] = inst_38495);
var inst_38500__$1 = (inst_38492 + (1));
var inst_38501 = (inst_38500__$1 < n);
var state_38527__$1 = (function (){var statearr_38545 = state_38527;
(statearr_38545[(12)] = inst_38499);

(statearr_38545[(11)] = inst_38500__$1);

return statearr_38545;
})();
if(cljs.core.truth_(inst_38501)){
var statearr_38546_38575 = state_38527__$1;
(statearr_38546_38575[(1)] = (8));

} else {
var statearr_38547_38576 = state_38527__$1;
(statearr_38547_38576[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (14))){
var inst_38520 = (state_38527[(2)]);
var inst_38521 = cljs.core.async.close_BANG_(out);
var state_38527__$1 = (function (){var statearr_38552 = state_38527;
(statearr_38552[(13)] = inst_38520);

return statearr_38552;
})();
var statearr_38553_38577 = state_38527__$1;
(statearr_38553_38577[(2)] = inst_38521);

(statearr_38553_38577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (10))){
var inst_38511 = (state_38527[(2)]);
var state_38527__$1 = state_38527;
var statearr_38554_38578 = state_38527__$1;
(statearr_38554_38578[(2)] = inst_38511);

(statearr_38554_38578[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38528 === (8))){
var inst_38491 = (state_38527[(8)]);
var inst_38500 = (state_38527[(11)]);
var tmp38548 = inst_38491;
var inst_38491__$1 = tmp38548;
var inst_38492 = inst_38500;
var state_38527__$1 = (function (){var statearr_38555 = state_38527;
(statearr_38555[(7)] = inst_38492);

(statearr_38555[(8)] = inst_38491__$1);

return statearr_38555;
})();
var statearr_38556_38579 = state_38527__$1;
(statearr_38556_38579[(2)] = null);

(statearr_38556_38579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___38564,out))
;
return ((function (switch__35726__auto__,c__35868__auto___38564,out){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_38557 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38557[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_38557[(1)] = (1));

return statearr_38557;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_38527){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_38527);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e38558){if((e38558 instanceof Object)){
var ex__35730__auto__ = e38558;
var statearr_38559_38580 = state_38527;
(statearr_38559_38580[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38527);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38558;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38581 = state_38527;
state_38527 = G__38581;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_38527){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_38527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___38564,out))
})();
var state__35870__auto__ = (function (){var statearr_38560 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_38560[(6)] = c__35868__auto___38564);

return statearr_38560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___38564,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__38589 = arguments.length;
switch (G__38589) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__35868__auto___38743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__35868__auto___38743,out){
return (function (){
var f__35869__auto__ = (function (){var switch__35726__auto__ = ((function (c__35868__auto___38743,out){
return (function (state_38648){
var state_val_38649 = (state_38648[(1)]);
if((state_val_38649 === (7))){
var inst_38643 = (state_38648[(2)]);
var state_38648__$1 = state_38648;
var statearr_38654_38745 = state_38648__$1;
(statearr_38654_38745[(2)] = inst_38643);

(statearr_38654_38745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (1))){
var inst_38596 = [];
var inst_38597 = inst_38596;
var inst_38598 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_38648__$1 = (function (){var statearr_38658 = state_38648;
(statearr_38658[(7)] = inst_38597);

(statearr_38658[(8)] = inst_38598);

return statearr_38658;
})();
var statearr_38662_38746 = state_38648__$1;
(statearr_38662_38746[(2)] = null);

(statearr_38662_38746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (4))){
var inst_38604 = (state_38648[(9)]);
var inst_38604__$1 = (state_38648[(2)]);
var inst_38605 = (inst_38604__$1 == null);
var inst_38606 = cljs.core.not(inst_38605);
var state_38648__$1 = (function (){var statearr_38666 = state_38648;
(statearr_38666[(9)] = inst_38604__$1);

return statearr_38666;
})();
if(inst_38606){
var statearr_38667_38747 = state_38648__$1;
(statearr_38667_38747[(1)] = (5));

} else {
var statearr_38668_38748 = state_38648__$1;
(statearr_38668_38748[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (15))){
var inst_38637 = (state_38648[(2)]);
var state_38648__$1 = state_38648;
var statearr_38678_38749 = state_38648__$1;
(statearr_38678_38749[(2)] = inst_38637);

(statearr_38678_38749[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (13))){
var state_38648__$1 = state_38648;
var statearr_38679_38750 = state_38648__$1;
(statearr_38679_38750[(2)] = null);

(statearr_38679_38750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (6))){
var inst_38597 = (state_38648[(7)]);
var inst_38632 = inst_38597.length;
var inst_38633 = (inst_38632 > (0));
var state_38648__$1 = state_38648;
if(cljs.core.truth_(inst_38633)){
var statearr_38680_38751 = state_38648__$1;
(statearr_38680_38751[(1)] = (12));

} else {
var statearr_38681_38752 = state_38648__$1;
(statearr_38681_38752[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (3))){
var inst_38645 = (state_38648[(2)]);
var state_38648__$1 = state_38648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38648__$1,inst_38645);
} else {
if((state_val_38649 === (12))){
var inst_38597 = (state_38648[(7)]);
var inst_38635 = cljs.core.vec(inst_38597);
var state_38648__$1 = state_38648;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38648__$1,(15),out,inst_38635);
} else {
if((state_val_38649 === (2))){
var state_38648__$1 = state_38648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38648__$1,(4),ch);
} else {
if((state_val_38649 === (11))){
var inst_38604 = (state_38648[(9)]);
var inst_38608 = (state_38648[(10)]);
var inst_38621 = (state_38648[(2)]);
var inst_38625 = [];
var inst_38626 = inst_38625.push(inst_38604);
var inst_38597 = inst_38625;
var inst_38598 = inst_38608;
var state_38648__$1 = (function (){var statearr_38688 = state_38648;
(statearr_38688[(7)] = inst_38597);

(statearr_38688[(8)] = inst_38598);

(statearr_38688[(11)] = inst_38626);

(statearr_38688[(12)] = inst_38621);

return statearr_38688;
})();
var statearr_38692_38753 = state_38648__$1;
(statearr_38692_38753[(2)] = null);

(statearr_38692_38753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (9))){
var inst_38597 = (state_38648[(7)]);
var inst_38619 = cljs.core.vec(inst_38597);
var state_38648__$1 = state_38648;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38648__$1,(11),out,inst_38619);
} else {
if((state_val_38649 === (5))){
var inst_38598 = (state_38648[(8)]);
var inst_38604 = (state_38648[(9)]);
var inst_38608 = (state_38648[(10)]);
var inst_38608__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38604) : f.call(null,inst_38604));
var inst_38612 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38608__$1,inst_38598);
var inst_38613 = cljs.core.keyword_identical_QMARK_(inst_38598,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_38614 = ((inst_38612) || (inst_38613));
var state_38648__$1 = (function (){var statearr_38696 = state_38648;
(statearr_38696[(10)] = inst_38608__$1);

return statearr_38696;
})();
if(cljs.core.truth_(inst_38614)){
var statearr_38700_38754 = state_38648__$1;
(statearr_38700_38754[(1)] = (8));

} else {
var statearr_38701_38755 = state_38648__$1;
(statearr_38701_38755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (14))){
var inst_38640 = (state_38648[(2)]);
var inst_38641 = cljs.core.async.close_BANG_(out);
var state_38648__$1 = (function (){var statearr_38706 = state_38648;
(statearr_38706[(13)] = inst_38640);

return statearr_38706;
})();
var statearr_38707_38756 = state_38648__$1;
(statearr_38707_38756[(2)] = inst_38641);

(statearr_38707_38756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (10))){
var inst_38630 = (state_38648[(2)]);
var state_38648__$1 = state_38648;
var statearr_38711_38757 = state_38648__$1;
(statearr_38711_38757[(2)] = inst_38630);

(statearr_38711_38757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38649 === (8))){
var inst_38597 = (state_38648[(7)]);
var inst_38604 = (state_38648[(9)]);
var inst_38608 = (state_38648[(10)]);
var inst_38616 = inst_38597.push(inst_38604);
var tmp38702 = inst_38597;
var inst_38597__$1 = tmp38702;
var inst_38598 = inst_38608;
var state_38648__$1 = (function (){var statearr_38713 = state_38648;
(statearr_38713[(7)] = inst_38597__$1);

(statearr_38713[(8)] = inst_38598);

(statearr_38713[(14)] = inst_38616);

return statearr_38713;
})();
var statearr_38714_38758 = state_38648__$1;
(statearr_38714_38758[(2)] = null);

(statearr_38714_38758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__35868__auto___38743,out))
;
return ((function (switch__35726__auto__,c__35868__auto___38743,out){
return (function() {
var cljs$core$async$state_machine__35727__auto__ = null;
var cljs$core$async$state_machine__35727__auto____0 = (function (){
var statearr_38717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38717[(0)] = cljs$core$async$state_machine__35727__auto__);

(statearr_38717[(1)] = (1));

return statearr_38717;
});
var cljs$core$async$state_machine__35727__auto____1 = (function (state_38648){
while(true){
var ret_value__35728__auto__ = (function (){try{while(true){
var result__35729__auto__ = switch__35726__auto__(state_38648);
if(cljs.core.keyword_identical_QMARK_(result__35729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__35729__auto__;
}
break;
}
}catch (e38727){if((e38727 instanceof Object)){
var ex__35730__auto__ = e38727;
var statearr_38728_38759 = state_38648;
(statearr_38728_38759[(5)] = ex__35730__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38727;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__35728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38760 = state_38648;
state_38648 = G__38760;
continue;
} else {
return ret_value__35728__auto__;
}
break;
}
});
cljs$core$async$state_machine__35727__auto__ = function(state_38648){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__35727__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__35727__auto____1.call(this,state_38648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__35727__auto____0;
cljs$core$async$state_machine__35727__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__35727__auto____1;
return cljs$core$async$state_machine__35727__auto__;
})()
;})(switch__35726__auto__,c__35868__auto___38743,out))
})();
var state__35870__auto__ = (function (){var statearr_38732 = (f__35869__auto__.cljs$core$IFn$_invoke$arity$0 ? f__35869__auto__.cljs$core$IFn$_invoke$arity$0() : f__35869__auto__.call(null));
(statearr_38732[(6)] = c__35868__auto___38743);

return statearr_38732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__35870__auto__);
});})(c__35868__auto___38743,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
