goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_41640 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__41641 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__41642 = null;
var count__41643 = (0);
var i__41644 = (0);
while(true){
if((i__41644 < count__41643)){
var vec__41645 = chunk__41642.cljs$core$IIndexed$_nth$arity$2(null,i__41644);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41645,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41645,(1),null);
var temp__5455__auto___41669 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___41669)){
var effect_fn_41670 = temp__5455__auto___41669;
(effect_fn_41670.cljs$core$IFn$_invoke$arity$1 ? effect_fn_41670.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_41670.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__41671 = seq__41641;
var G__41672 = chunk__41642;
var G__41673 = count__41643;
var G__41674 = (i__41644 + (1));
seq__41641 = G__41671;
chunk__41642 = G__41672;
count__41643 = G__41673;
i__41644 = G__41674;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__41641);
if(temp__5457__auto__){
var seq__41641__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41641__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__41641__$1);
var G__41675 = cljs.core.chunk_rest(seq__41641__$1);
var G__41676 = c__4351__auto__;
var G__41677 = cljs.core.count(c__4351__auto__);
var G__41678 = (0);
seq__41641 = G__41675;
chunk__41642 = G__41676;
count__41643 = G__41677;
i__41644 = G__41678;
continue;
} else {
var vec__41650 = cljs.core.first(seq__41641__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41650,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41650,(1),null);
var temp__5455__auto___41679 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___41679)){
var effect_fn_41682 = temp__5455__auto___41679;
(effect_fn_41682.cljs$core$IFn$_invoke$arity$1 ? effect_fn_41682.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_41682.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__41683 = cljs.core.next(seq__41641__$1);
var G__41684 = null;
var G__41685 = (0);
var G__41686 = (0);
seq__41641 = G__41683;
chunk__41642 = G__41684;
count__41643 = G__41685;
i__41644 = G__41686;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__41266__auto___41688 = re_frame.interop.now();
var duration__41267__auto___41689 = (end__41266__auto___41688 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__41267__auto___41689,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__41266__auto___41688);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_41640;
}} else {
var seq__41654 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__41655 = null;
var count__41656 = (0);
var i__41657 = (0);
while(true){
if((i__41657 < count__41656)){
var vec__41659 = chunk__41655.cljs$core$IIndexed$_nth$arity$2(null,i__41657);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41659,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41659,(1),null);
var temp__5455__auto___41692 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___41692)){
var effect_fn_41693 = temp__5455__auto___41692;
(effect_fn_41693.cljs$core$IFn$_invoke$arity$1 ? effect_fn_41693.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_41693.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__41695 = seq__41654;
var G__41696 = chunk__41655;
var G__41697 = count__41656;
var G__41698 = (i__41657 + (1));
seq__41654 = G__41695;
chunk__41655 = G__41696;
count__41656 = G__41697;
i__41657 = G__41698;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__41654);
if(temp__5457__auto__){
var seq__41654__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41654__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__41654__$1);
var G__41699 = cljs.core.chunk_rest(seq__41654__$1);
var G__41700 = c__4351__auto__;
var G__41701 = cljs.core.count(c__4351__auto__);
var G__41702 = (0);
seq__41654 = G__41699;
chunk__41655 = G__41700;
count__41656 = G__41701;
i__41657 = G__41702;
continue;
} else {
var vec__41665 = cljs.core.first(seq__41654__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41665,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41665,(1),null);
var temp__5455__auto___41703 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___41703)){
var effect_fn_41704 = temp__5455__auto___41703;
(effect_fn_41704.cljs$core$IFn$_invoke$arity$1 ? effect_fn_41704.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_41704.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__41705 = cljs.core.next(seq__41654__$1);
var G__41706 = null;
var G__41707 = (0);
var G__41708 = (0);
seq__41654 = G__41705;
chunk__41655 = G__41706;
count__41656 = G__41707;
i__41657 = G__41708;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__41709 = cljs.core.seq(value);
var chunk__41710 = null;
var count__41711 = (0);
var i__41712 = (0);
while(true){
if((i__41712 < count__41711)){
var map__41713 = chunk__41710.cljs$core$IIndexed$_nth$arity$2(null,i__41712);
var map__41713__$1 = ((((!((map__41713 == null)))?(((((map__41713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41713):map__41713);
var effect = map__41713__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41713__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41713__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__41709,chunk__41710,count__41711,i__41712,map__41713,map__41713__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__41709,chunk__41710,count__41711,i__41712,map__41713,map__41713__$1,effect,ms,dispatch))
,ms);
}


var G__41725 = seq__41709;
var G__41726 = chunk__41710;
var G__41727 = count__41711;
var G__41728 = (i__41712 + (1));
seq__41709 = G__41725;
chunk__41710 = G__41726;
count__41711 = G__41727;
i__41712 = G__41728;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__41709);
if(temp__5457__auto__){
var seq__41709__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41709__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__41709__$1);
var G__41733 = cljs.core.chunk_rest(seq__41709__$1);
var G__41734 = c__4351__auto__;
var G__41735 = cljs.core.count(c__4351__auto__);
var G__41736 = (0);
seq__41709 = G__41733;
chunk__41710 = G__41734;
count__41711 = G__41735;
i__41712 = G__41736;
continue;
} else {
var map__41717 = cljs.core.first(seq__41709__$1);
var map__41717__$1 = ((((!((map__41717 == null)))?(((((map__41717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41717):map__41717);
var effect = map__41717__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41717__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41717__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__41709,chunk__41710,count__41711,i__41712,map__41717,map__41717__$1,effect,ms,dispatch,seq__41709__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__41709,chunk__41710,count__41711,i__41712,map__41717,map__41717__$1,effect,ms,dispatch,seq__41709__$1,temp__5457__auto__))
,ms);
}


var G__41738 = cljs.core.next(seq__41709__$1);
var G__41739 = null;
var G__41740 = (0);
var G__41741 = (0);
seq__41709 = G__41738;
chunk__41710 = G__41739;
count__41711 = G__41740;
i__41712 = G__41741;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value], 0));
} else {
var seq__41744 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__41745 = null;
var count__41746 = (0);
var i__41747 = (0);
while(true){
if((i__41747 < count__41746)){
var event = chunk__41745.cljs$core$IIndexed$_nth$arity$2(null,i__41747);
re_frame.router.dispatch(event);


var G__41752 = seq__41744;
var G__41753 = chunk__41745;
var G__41754 = count__41746;
var G__41755 = (i__41747 + (1));
seq__41744 = G__41752;
chunk__41745 = G__41753;
count__41746 = G__41754;
i__41747 = G__41755;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__41744);
if(temp__5457__auto__){
var seq__41744__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41744__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__41744__$1);
var G__41756 = cljs.core.chunk_rest(seq__41744__$1);
var G__41757 = c__4351__auto__;
var G__41758 = cljs.core.count(c__4351__auto__);
var G__41759 = (0);
seq__41744 = G__41756;
chunk__41745 = G__41757;
count__41746 = G__41758;
i__41747 = G__41759;
continue;
} else {
var event = cljs.core.first(seq__41744__$1);
re_frame.router.dispatch(event);


var G__41761 = cljs.core.next(seq__41744__$1);
var G__41762 = null;
var G__41763 = (0);
var G__41764 = (0);
seq__41744 = G__41761;
chunk__41745 = G__41762;
count__41746 = G__41763;
i__41747 = G__41764;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__41767 = cljs.core.seq(value);
var chunk__41768 = null;
var count__41769 = (0);
var i__41770 = (0);
while(true){
if((i__41770 < count__41769)){
var event = chunk__41768.cljs$core$IIndexed$_nth$arity$2(null,i__41770);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__41771 = seq__41767;
var G__41772 = chunk__41768;
var G__41773 = count__41769;
var G__41774 = (i__41770 + (1));
seq__41767 = G__41771;
chunk__41768 = G__41772;
count__41769 = G__41773;
i__41770 = G__41774;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__41767);
if(temp__5457__auto__){
var seq__41767__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41767__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__41767__$1);
var G__41775 = cljs.core.chunk_rest(seq__41767__$1);
var G__41776 = c__4351__auto__;
var G__41777 = cljs.core.count(c__4351__auto__);
var G__41778 = (0);
seq__41767 = G__41775;
chunk__41768 = G__41776;
count__41769 = G__41777;
i__41770 = G__41778;
continue;
} else {
var event = cljs.core.first(seq__41767__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__41779 = cljs.core.next(seq__41767__$1);
var G__41780 = null;
var G__41781 = (0);
var G__41782 = (0);
seq__41767 = G__41779;
chunk__41768 = G__41780;
count__41769 = G__41781;
i__41770 = G__41782;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
