package com.wikia.commons.utils;

public class SystemUtils {
	public static String env(String key) {
		return env(key, null);
	}

	public static String env(String key, String defaultIfMissing) {
		String val = System.getenv(key);

		if (val == null) {
			val = defaultIfMissing;
		}

		return val;
	}

	public static int env(String key, int defaultIfMissing) {
		String val = System.getenv(key);

		if (val == null) {
			return defaultIfMissing;
		}

		return new Integer(val);
	}

	public static String[] envArray(String key) {
		return envArray(key, ",");
	}

	public static String[] envArray(String key, String splitRegex) {
		String raw = System.getenv(key);

		if (raw == null) {
			return new String[0];
		}

		return raw.split(splitRegex);
	}
}
