# WikiaLogger

Logback-based logger for application logs.

## Installation

Using `lein`

```clojure
(defproject
  ;...
  :dependencies [[com.wikia.commons/logger "0.1.0-SNAPSHOT"]])
```

## Configuration
The following environment variables are supported
* `WIKIA_APPNAME` - how to label the application. Defaults to `wikia`
* `WIKIA_LOGGER_MODE` - where to send logs. Leave blank to disable the logger. Can be a comma separated list of `syslog`, `console`, and/or `file`
* `WIKIA_LOGGER_HOST` - For mode `syslog`, the IP address of the syslog host
* `WIKIA_LOGGER_LOGFILE` - For mode `file`, the file to write logs to

## Usage

First, at some point in your application you must initialize the logger:
`WikiaLogger.getInstance().init()`
This will take the appropriate environment variables and open the logger for writing. Then, the logger can be used with these signatures:

```java
debug(String message);
debug(String message, Throwable t);
debug(String message, LogContext context);
debug(String message, LogContext context, Throwable t);

info(...); // same as for debug
warn(...); // same as for debug
error(...); // same as debug
```

Examples:
```java
import com.wikia.commons.logging.WikiaLogger;

// normal logging
WikiaLogger.getInstance().debug("debugging something..");

// logging an exception
try {
  doSomethingCrazy();
} catch (Exception e) {
  WikiaLogger.getInstance().warn("exception maybe broke something", e);
}
```

The `LogContext` Object has one method: `add`:
```java
WikiaLogger.getInstance().debug("trying to figure out why it broke", new LogContext().add("someKey", "someVal").add("anotherKey", 4);
```
