/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.base;

import com.whimsy.map.api.Edge;
import com.whimsy.map.api.GeoPoint;
import com.whimsy.map.base.ValueBox;
import edu.princeton.cs.algs4.Point2D;
import org.fest.assertions.api.Assertions;

public class Utils {
    public static double sqr(double x) {
        return x * x;
    }

    public static double distM(double lat1, double lon1, double lat2, double lon2) {
        return Math.sqrt(Utils.sqr(lat1 - lat2) + Utils.sqr(lon1 - lon2)) * 111195.00747992701;
    }

    public static double dist(double lat1, double lon1, double lat2, double lon2) {
        return Math.sqrt(Utils.sqr(lat1 - lat2) + Utils.sqr(lon1 - lon2));
    }

    public static double distM(double lat, double lon, Edge edge) {
        double minDist = 1.0E20;
        for (Edge.Figure figure : edge.figures) {
            double tmpDist = Utils.distM(lat, lon, figure.lat, figure.lon);
            if (!(tmpDist < minDist)) continue;
            minDist = tmpDist;
        }
        for (int i = 0; i < edge.figures.size() - 1; ++i) {
            Edge.Figure from = edge.figures.get(i);
            Edge.Figure to = edge.figures.get(i + 1);
            if (!(Utils.cosAng(lat, lon, from.lat, from.lon, to.lat, to.lon) <= 0.0) || !(Utils.cosAng(lat, lon, to.lat, to.lon, from.lat, from.lon) <= 0.0)) continue;
            double v1x = to.lat - from.lat;
            double v1y = to.lon - from.lon;
            double v2x = lat - from.lat;
            double v2y = lon - from.lon;
            double dist = Math.abs((v1x * v2y - v2x * v1y) / Math.sqrt(v1x * v1x + v1y * v1y));
            if (!((dist *= 111195.00747992701) < minDist)) continue;
            minDist = dist;
        }
        return minDist;
    }

    public static double cosAng(double x0, double y0, double x1, double y1, double x2, double y2) {
        double v1x = x1 - x0;
        double v1y = y1 - y0;
        double v2x = x2 - x1;
        double v2y = y2 - y1;
        return (v1x * v2x + v1y * v2y) / Math.sqrt((v1x * v1x + v1y * v1y) * (v2x * v2x + v2y * v2y));
    }

    public static Point2D intersectPoint(Point2D A, Point2D B, Point2D C, Point2D D) {
        double s_abc = Point2D.area2((Point2D)B, (Point2D)C, (Point2D)A);
        double s_abd = Point2D.area2((Point2D)B, (Point2D)D, (Point2D)A);
        double s_cda = Point2D.area2((Point2D)D, (Point2D)A, (Point2D)C);
        double s_cdb = Point2D.area2((Point2D)D, (Point2D)B, (Point2D)C);
        double x = s_cda / (s_cda - s_cdb) * B.x() + -s_cdb / (s_cda - s_cdb) * A.x();
        double y = s_abc / (s_abc - s_abd) * D.y() + -s_abd / (s_abc - s_abd) * C.y();
        return new Point2D(x, y);
    }

    public static Point2D project(GeoPoint trajPoint, Edge edge) {
        return Utils.project(trajPoint, edge, new ValueBox<Double>(), new ValueBox<Double>());
    }

    public static Point2D project(GeoPoint trajPoint, Edge edge, ValueBox<Double> distVertical, ValueBox<Double> distLeft) {
        double minDist = 1.0E20;
        double lat = trajPoint.lat;
        double lon = trajPoint.lon;
        Point2D res = null;
        double distSum = 0.0;
        Edge.Figure formerFigure = null;
        for (Edge.Figure figure : edge.figures) {
            double tmpDist = Utils.distM(lat, lon, figure.lat, figure.lon);
            if (formerFigure != null) {
                distSum += Utils.distM(formerFigure.lat, formerFigure.lon, figure.lat, figure.lon);
            }
            if (tmpDist < minDist) {
                minDist = tmpDist;
                res = new Point2D(figure.lat, figure.lon);
                distLeft.value = distSum;
            }
            formerFigure = figure;
        }
        distSum = 0.0;
        for (int i = 0; i < edge.figures.size() - 1; ++i) {
            Edge.Figure from = edge.figures.get(i);
            Edge.Figure to = edge.figures.get(i + 1);
            if (Utils.cosAng(lat, lon, from.lat, from.lon, to.lat, to.lon) <= 0.0 && Utils.cosAng(lat, lon, to.lat, to.lon, from.lat, from.lon) <= 0.0) {
                double v1x = to.lat - from.lat;
                double v1y = to.lon - from.lon;
                double v2x = lat - from.lat;
                double v2y = lon - from.lon;
                double dist = Math.abs((v1x * v2y - v2x * v1y) / Math.sqrt(v1x * v1x + v1y * v1y));
                if ((dist *= 111195.00747992701) < minDist) {
                    minDist = dist;
                    res = Utils.intersectPoint(new Point2D(from.lat, from.lon), new Point2D(to.lat, to.lon), new Point2D(lat, lon), new Point2D(lat + v1y, lon - v1x));
                    distLeft.value = distSum + Utils.distM(from.lat, from.lon, res.x(), res.y());
                }
            }
            distSum += Utils.distM(from.lat, from.lon, to.lat, to.lon);
        }
        distVertical.value = minDist;
        return res;
    }

    public static void isDoubleEqual(double actual, double expected) {
        Assertions.assertThat((Math.abs(actual - expected) < 1.0E-8 ? 1 : 0) != 0).isTrue();
    }

    public static void isGeoDistEqual(double actual, double expected) {
        Assertions.assertThat((Math.abs(actual - expected) < 1.0 ? 1 : 0) != 0).isTrue();
    }
}

