/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.api;

import com.google.common.collect.Lists;
import com.whimsy.map.algo.AStar;
import com.whimsy.map.api.Edge;
import com.whimsy.map.api.Node;
import edu.princeton.cs.algs4.Stopwatch;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph {
    Logger LOG = LoggerFactory.getLogger(Graph.class);
    boolean isNodeLoaded;
    public List<Node> nodes;
    boolean isEdgeLoaded;
    public List<Edge> edges;
    AStar shortestPathAlgo;

    public Graph() {
    }

    public Graph(List<Node> nodes, List<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
        this.isNodeLoaded = true;
        this.isEdgeLoaded = true;
    }

    public void loadNode(InputStream nodeFile) {
        this.LOG.info("Start Loading Node File");
        Stopwatch stopwatch = new Stopwatch();
        Scanner in = new Scanner(nodeFile);
        this.nodes = Lists.newArrayList();
        while (in.hasNext()) {
            int id = in.nextInt();
            double lat = in.nextDouble();
            double lon = in.nextDouble();
            this.nodes.add(new Node(id, lat, lon));
        }
        in.close();
        this.isNodeLoaded = true;
        this.LOG.info("Loaded Node File {} sec", (Object)stopwatch.elapsedTime());
    }

    public void loadEdge(InputStream edgeFile) {
        this.LOG.info("Start Loading Edge file");
        Stopwatch stopwatch = new Stopwatch();
        Scanner in = new Scanner(edgeFile);
        this.edges = Lists.newArrayList();
        while (in.hasNext()) {
            Edge edge = new Edge();
            int edgeId = in.nextInt();
            int sId = in.nextInt();
            int eId = in.nextInt();
            edge.id = edgeId;
            edge.sId = sId;
            edge.eId = eId;
            int num = in.nextInt();
            for (int i = 0; i < num; ++i) {
                double lat = in.nextDouble();
                double lon = in.nextDouble();
                Edge.Figure figure = new Edge.Figure();
                figure.lat = lat;
                figure.lon = lon;
                edge.figures.add(figure);
            }
            this.edges.add(edge);
        }
        this.isEdgeLoaded = true;
        this.LOG.info("Loaded Edge file {} sec", (Object)stopwatch.elapsedTime());
    }
}

