/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.api;

import com.whimsy.map.algo.AStar;
import com.whimsy.map.algo.CachedAstar;
import com.whimsy.map.algo.GridIndex;
import com.whimsy.map.algo.KdTree;
import com.whimsy.map.algo.MapMatching;
import com.whimsy.map.api.Edge;
import com.whimsy.map.api.GeoPoint;
import com.whimsy.map.api.Graph;
import com.whimsy.map.api.Node;
import com.whimsy.map.exception.GraphNotBuildException;
import com.whimsy.map.exception.GridNotBuildedException;
import com.whimsy.map.exception.KdTreeNotBuildException;
import com.whimsy.map.exception.MapMatchingNotBuildException;
import com.whimsy.map.exception.ShortestPathAlgoNotBuildException;
import java.io.InputStream;
import java.util.List;

public class Facade {
    boolean isGraphBuilded = false;
    public Graph graph;
    boolean isKdTreebuilded = false;
    public KdTree kdTree;
    boolean isShortestPathAlgoBuilded;
    public AStar shortestPathAlgo;
    boolean isGridIndexBuilded;
    public GridIndex gridIndex;
    boolean isMapMatchingBuilded;
    public MapMatching mapMatching;

    public void buildGraph(InputStream nodeIS, InputStream edgeIS) {
        this.graph = new Graph();
        this.graph.loadNode(nodeIS);
        this.graph.loadEdge(edgeIS);
        this.isGraphBuilded = true;
    }

    public void buildKdTree() {
        if (!this.isGraphBuilded) {
            throw new GraphNotBuildException();
        }
        this.kdTree = new KdTree(this.graph);
        this.isKdTreebuilded = true;
    }

    public KdTree.Point nearest(double lat, double lon) {
        if (!this.isKdTreebuilded) {
            throw new KdTreeNotBuildException();
        }
        return this.kdTree.nearest(lat, lon);
    }

    public void buildShortestPathAlgo() {
        if (!this.isGraphBuilded) {
            throw new GraphNotBuildException();
        }
        this.shortestPathAlgo = new CachedAstar(this.graph);
        this.isShortestPathAlgoBuilded = true;
    }

    public Node[] query(int s, int t) {
        if (!this.isShortestPathAlgoBuilded) {
            throw new ShortestPathAlgoNotBuildException();
        }
        return this.shortestPathAlgo.findPath(s, t);
    }

    public void buildGridIndex(int gridPartition) {
        if (!this.isGraphBuilded) {
            throw new GraphNotBuildException();
        }
        this.gridIndex = new GridIndex(this.graph, gridPartition);
        this.isGridIndexBuilded = true;
    }

    public List<Edge> getNearEdges(double lat, double lon, int k) {
        if (!this.isGridIndexBuilded) {
            throw new GridNotBuildedException();
        }
        return this.gridIndex.getNearEdges(lat, lon, k);
    }

    public void buildMapMatching(int gridPartition) {
        if (!this.isGraphBuilded) {
            throw new GraphNotBuildException();
        }
        this.mapMatching = new MapMatching(this.graph, gridPartition);
        this.isMapMatchingBuilded = true;
    }

    public List<Edge> nearestMatching(List<GeoPoint> trajectory) {
        if (!this.isMapMatchingBuilded) {
            throw new MapMatchingNotBuildException();
        }
        return this.mapMatching.nearestMatching(trajectory);
    }

    public List<Edge> hmmMatching(List<GeoPoint> trajectory, int k) {
        if (!this.isMapMatchingBuilded) {
            throw new MapMatchingNotBuildException();
        }
        return this.mapMatching.hmmMatching(trajectory, k);
    }
}

