/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.algo;

import com.google.common.collect.Lists;
import com.whimsy.map.algo.AStar;
import com.whimsy.map.algo.CachedAstar;
import com.whimsy.map.algo.GridIndex;
import com.whimsy.map.api.Edge;
import com.whimsy.map.api.GeoPoint;
import com.whimsy.map.api.Graph;
import com.whimsy.map.base.Utils;
import com.whimsy.map.base.ValueBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MapMatching {
    Graph graph;
    AStar aStar;
    GridIndex gridIndex;
    public double MAXSPEED = 50.0;
    public static final double COEFFICIENT_FOR_EMISSIONPROB = 140.23845998229973;
    public static final double COEFFICIENT_FOR_TRANSITIONPROB = 0.31273997011;

    public MapMatching(Graph graph) {
        this(graph, 10);
    }

    public MapMatching(Graph roadNetwork, int gridPartition) {
        this.graph = roadNetwork;
        this.aStar = new CachedAstar(roadNetwork);
        this.gridIndex = new GridIndex(this.graph, gridPartition);
    }

    public List<Edge> nearestMatching(List<GeoPoint> trajectory) {
        ArrayList resEdges = Lists.newArrayList();
        for (GeoPoint trajPoint : trajectory) {
            List<Edge> edges = this.gridIndex.getNearEdges(trajPoint.lat, trajPoint.lon, 1);
            assert (edges.size() == 1);
            resEdges.add(edges.get(0));
        }
        return resEdges;
    }

    public List<Edge> hmmMatching(List<GeoPoint> trajectory, int k) {
        ArrayList scoreMatrix = Lists.newArrayList();
        GeoPoint formerTrajPoint = null;
        boolean cutFlag = true;
        int currentTrajPointIndex = 0;
        int cnt = 0;
        for (GeoPoint point : trajectory) {
            double deltaT = 1.0;
            if (formerTrajPoint != null) {
                deltaT = point.time - formerTrajPoint.time;
            }
            double currentMaxProb = 1.0E20;
            ArrayList<Score> scores = new ArrayList<Score>();
            List<Edge> candidateEdges = this.gridIndex.getNearEdges(point.lat, point.lon, k);
            double[] emmissionProbs = new double[candidateEdges.size()];
            int currentCandidateEdgeIndex = 0;
            for (Edge candidateEdge : candidateEdges) {
                int preColumnIndex = -1;
                double currentDistLeft = 0.0;
                ValueBox<Double> distBetweenTrajPointAndEdge = new ValueBox<Double>();
                ValueBox<Double> distLeft = new ValueBox<Double>();
                Utils.project(point, candidateEdge, distBetweenTrajPointAndEdge, distLeft);
                emmissionProbs[currentCandidateEdgeIndex] = deltaT * Math.sqrt((Double)distBetweenTrajPointAndEdge.value);
                if (!cutFlag) {
                    double currentMaxProbTmp = 1.0E20;
                    int formerCandidateEdgeIndex = 0;
                    for (Score formerCandidateEdge : (ArrayList)scoreMatrix.get(scoreMatrix.size() - 1)) {
                        double routeNetworkDistBetweenTwoTrajPoints;
                        double formerDistLeft = formerCandidateEdge.distLeft;
                        double formerDistToEnd = formerCandidateEdge.edge.lenM() - formerDistLeft;
                        double routeNetworkDistBetweenTwoEdges = 0.0;
                        if (candidateEdge == formerCandidateEdge.edge) {
                            routeNetworkDistBetweenTwoTrajPoints = Math.abs(currentDistLeft - formerCandidateEdge.distLeft);
                        } else {
                            Double res = this.aStar.query(formerCandidateEdge.edge.eId, candidateEdge.sId) * 111195.00747992701;
                            routeNetworkDistBetweenTwoEdges = res <= this.MAXSPEED * deltaT ? res : res * 100.0;
                            routeNetworkDistBetweenTwoTrajPoints = routeNetworkDistBetweenTwoEdges + currentDistLeft + formerDistToEnd;
                        }
                        double transitionProb = routeNetworkDistBetweenTwoTrajPoints * 0.31273997011;
                        double tmpTotalProbForTrasition = formerCandidateEdge.score + transitionProb;
                        if (currentMaxProbTmp > tmpTotalProbForTrasition) {
                            currentMaxProbTmp = tmpTotalProbForTrasition;
                            preColumnIndex = formerCandidateEdgeIndex;
                        }
                        ++formerCandidateEdgeIndex;
                    }
                    int n = currentCandidateEdgeIndex;
                    emmissionProbs[n] = emmissionProbs[n] + currentMaxProbTmp;
                }
                scores.add(new Score(candidateEdge, emmissionProbs[currentCandidateEdgeIndex], preColumnIndex, currentDistLeft));
                if (currentMaxProb > emmissionProbs[currentCandidateEdgeIndex]) {
                    currentMaxProb = emmissionProbs[currentCandidateEdgeIndex];
                }
                ++currentCandidateEdgeIndex;
            }
            formerTrajPoint = point;
            ++currentTrajPointIndex;
            scoreMatrix.add(scores);
            if (scores.size() == 0) {
                cutFlag = true;
                formerTrajPoint = null;
            } else {
                cutFlag = false;
            }
            ++cnt;
        }
        for (int i = 0; i < scoreMatrix.size(); ++i) {
            for (int j = 0; j < ((ArrayList)scoreMatrix.get(i)).size(); ++j) {
                System.out.printf("%d  %d %s\n", i, j, ((ArrayList)scoreMatrix.get(i)).get(j));
            }
        }
        int startColumnIndex = this.getStartColumnIndex((List)scoreMatrix.get(scoreMatrix.size() - 1));
        ArrayList resEdges = Lists.newArrayList();
        for (int i = scoreMatrix.size() - 1; i >= 0; --i) {
            if (startColumnIndex != -1) {
                resEdges.add(((Score)((ArrayList)scoreMatrix.get((int)i)).get((int)startColumnIndex)).edge);
                startColumnIndex = ((Score)((ArrayList)scoreMatrix.get((int)i)).get((int)startColumnIndex)).preColumnIndex;
                continue;
            }
            resEdges.add(null);
            if (i <= 0) continue;
            startColumnIndex = this.getStartColumnIndex((List)scoreMatrix.get(i - 1));
        }
        Collections.reverse(resEdges);
        return resEdges;
    }

    private int getStartColumnIndex(List<Score> scores) {
        int resultIndex = -1;
        double currentMaxProb = 1.0E20;
        int idx = 0;
        for (Score score : scores) {
            if (currentMaxProb > score.score) {
                currentMaxProb = score.score;
                resultIndex = idx;
            }
            ++idx;
        }
        return resultIndex;
    }

    static class Score {
        Edge edge;
        double score;
        int preColumnIndex;
        double distLeft;

        public Score(Edge edge, double score, int preColumnIndex, double disLeft) {
            this.edge = edge;
            this.score = score;
            this.preColumnIndex = preColumnIndex;
            this.distLeft = disLeft;
        }

        public String toString() {
            return String.format("%d %.2f %d %.2f", this.edge.id, this.score, this.preColumnIndex, this.distLeft);
        }
    }
}

