/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.algo;

import com.whimsy.map.api.Graph;
import edu.princeton.cs.algs4.Point2D;
import edu.princeton.cs.algs4.Stopwatch;
import edu.princeton.cs.introcs.StdDraw;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdTree {
    static final Logger logger = LoggerFactory.getLogger(KdTree.class);
    private static final boolean HORIZONTAL = true;
    private static final double MARGIN = 1.0;
    private Bound bound;
    private Node root;
    private int size = 0;
    private Point nearest;

    public KdTree(Graph graph) {
        logger.info("Building KdTree start!");
        Stopwatch stopwatch = new Stopwatch();
        this.bound = new Bound();
        this.bound.minLat = 9.223372036854776E18;
        this.bound.maxLat = -9.223372036854776E18;
        this.bound.minLon = 9.223372036854776E18;
        this.bound.maxLon = -9.223372036854776E18;
        for (com.whimsy.map.api.Node node : graph.nodes) {
            this.bound.minLat = Math.min(this.bound.minLat, node.lat);
            this.bound.maxLat = Math.max(this.bound.maxLat, node.lat);
            this.bound.minLon = Math.min(this.bound.minLon, node.lon);
            this.bound.maxLon = Math.max(this.bound.maxLon, node.lon);
        }
        logger.info("Bound here is minLon = {} maxLon = {} minLat = {}  maxLat {}", new Object[]{this.bound.minLon, this.bound.maxLon, this.bound.minLat, this.bound.maxLat});
        for (com.whimsy.map.api.Node node : graph.nodes) {
            this.insert(new Point((Integer)node.id, node.lon, node.lat));
        }
        logger.info("Node inserted : {} \nBuilding KdTree end. used Time {}", (Object)this.size(), (Object)stopwatch.elapsedTime());
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        return this.size;
    }

    public void insert(Point p) {
        this.root = this.insert(this.root, null, p, true);
        ++this.size;
    }

    private Node insert(Node node, Node parentNode, Point p, boolean orient) {
        double nodeKey;
        if (node == null) {
            double rectXmin = this.bound.minLon - 1.0;
            double rectXmax = this.bound.maxLon + 1.0;
            double rectYmin = this.bound.minLat - 1.0;
            double rectYmax = this.bound.maxLat + 1.0;
            if (parentNode != null) {
                if (orient) {
                    rectXmin = parentNode.rect.xmin();
                    rectXmax = parentNode.rect.xmax();
                    if (p.y() < parentNode.point.y()) {
                        rectYmin = parentNode.rect.ymin();
                        rectYmax = parentNode.point.y();
                    } else if (p.y() > parentNode.point.y()) {
                        rectYmin = parentNode.point.y();
                        rectYmax = parentNode.rect.ymax();
                    }
                } else {
                    rectYmax = parentNode.rect.ymax();
                    rectYmin = parentNode.rect.ymin();
                    if (p.x() < parentNode.point.x()) {
                        rectXmin = parentNode.rect.xmin();
                        rectXmax = parentNode.point.x();
                    } else if (p.x() > parentNode.point.x()) {
                        rectXmin = parentNode.point.x();
                        rectXmax = parentNode.rect.xmax();
                    }
                }
            }
            return new Node(p, new RectHV(rectXmin, rectYmin, rectXmax, rectYmax));
        }
        double newKey = true == orient ? p.x() : p.y();
        double d = nodeKey = true == orient ? node.point.x() : node.point.y();
        if (newKey < nodeKey) {
            node.left = this.insert(node.left, node, p, !orient);
        } else if (newKey > nodeKey) {
            node.right = this.insert(node.right, node, p, !orient);
        } else {
            double nodeValue;
            double newValue = true == orient ? p.y() : p.x();
            double d2 = nodeValue = true == orient ? node.point.y() : node.point.x();
            if (newValue == nodeValue) {
                node.point = p;
            } else {
                node.right = this.insert(node.right, node, p, !orient);
            }
        }
        return node;
    }

    public boolean contains(Point p) {
        return this.get(this.root, p, true) != null;
    }

    private Point get(Node node, Point p, boolean orient) {
        double nodeKey;
        double newKey;
        if (node == null) {
            return null;
        }
        if (orient) {
            newKey = p.x();
            nodeKey = node.point.x();
        } else {
            newKey = p.y();
            nodeKey = node.point.y();
        }
        if (newKey < nodeKey) {
            return this.get(node.left, p, !orient);
        }
        if (newKey > nodeKey) {
            return this.get(node.right, p, !orient);
        }
        if (orient) {
            newKey = p.y();
            nodeKey = node.point.y();
        } else {
            newKey = p.x();
            nodeKey = node.point.x();
        }
        if (newKey == nodeKey) {
            return node.point;
        }
        return this.get(node.right, p, !orient);
    }

    public void draw() {
        this.drawPoint(this.root, null, true);
    }

    private void drawPoint(Node node, Node parentNode, boolean orient) {
        if (node == null) {
            return;
        }
        StdDraw.setPenColor((Color)StdDraw.BLACK);
        StdDraw.setPenRadius((double)0.01);
        node.point.draw();
        StdDraw.setPenRadius();
        StdDraw.setPenColor((Color)(true == orient ? StdDraw.RED : StdDraw.BLUE));
        if (orient) {
            if (parentNode != null) {
                if (node.point.y() < parentNode.point.y()) {
                    new Point(node.point.x(), parentNode.rect.ymin()).drawTo(new Point(node.point.x(), parentNode.point.y()));
                } else if (node.point.y() > parentNode.point.y()) {
                    new Point(node.point.x(), parentNode.point.y()).drawTo(new Point(node.point.x(), parentNode.rect.ymax()));
                }
            } else {
                new Point(node.point.x(), 0.0).drawTo(new Point(node.point.x(), 1.0));
            }
        } else if (parentNode != null) {
            if (node.point.x() < parentNode.point.x()) {
                new Point(parentNode.rect.xmin(), node.point.y()).drawTo(new Point(parentNode.point.x(), node.point.y()));
            } else if (node.point.x() > parentNode.point.x()) {
                new Point(parentNode.point.x(), node.point.y()).drawTo(new Point(parentNode.rect.xmax(), node.point.y()));
            }
        } else {
            new Point(0.0, node.point.y()).drawTo(new Point(1.0, node.point.y()));
        }
        this.drawPoint(node.left, node, !orient);
        this.drawPoint(node.right, node, !orient);
    }

    public Iterable<Point> range(RectHV rect) {
        HashSet<Point> result = new HashSet<Point>();
        this.rangeSearch(this.root, rect, result);
        return result;
    }

    private void rangeSearch(Node node, RectHV rect, Set<Point> result) {
        if (node == null || !rect.intersects(node.rect)) {
            return;
        }
        if (KdTree.rectContainsPoint(rect, node.point)) {
            result.add(node.point);
        }
        this.rangeSearch(node.left, rect, result);
        this.rangeSearch(node.right, rect, result);
    }

    private static boolean rectContainsPoint(RectHV rect, Point point) {
        double pX = point.x();
        double pY = point.y();
        return pX >= rect.xmin() && pX <= rect.xmax() && pY >= rect.ymin() && pY <= rect.ymax();
    }

    public Point nearest(Point p) {
        if (this.root == null) {
            return null;
        }
        this.nearest = this.root.point;
        this.nearestSearch(this.root, p, true);
        return this.nearest;
    }

    public Point nearest(double lat, double lon) {
        return this.nearest(new Point(lon, lat));
    }

    private void nearestSearch(Node node, Point queryPoint, boolean orient) {
        double distanceToCurNodeRect;
        if (node == null) {
            return;
        }
        double distanceToFoundSoFar = this.nearest.distanceSquaredTo(queryPoint);
        if (distanceToFoundSoFar < (distanceToCurNodeRect = node.rect.distanceSquaredTo(queryPoint))) {
            return;
        }
        if (this.nearest.distanceSquaredTo(queryPoint) > node.point.distanceSquaredTo(queryPoint)) {
            this.nearest = node.point;
        }
        Node firstNode = null;
        Node secondNode = null;
        if (orient) {
            if (queryPoint.x() < node.point.x()) {
                firstNode = node.left;
                secondNode = node.right;
            } else {
                firstNode = node.right;
                secondNode = node.left;
            }
        } else if (queryPoint.y() < node.point.y()) {
            firstNode = node.left;
            secondNode = node.right;
        } else {
            firstNode = node.right;
            secondNode = node.left;
        }
        this.nearestSearch(firstNode, queryPoint, !orient);
        this.nearestSearch(secondNode, queryPoint, !orient);
    }

    public static void main(String[] args) {
    }

    public class RectHV {
        private final double xmin;
        private final double ymin;
        private final double xmax;
        private final double ymax;

        public RectHV(double xmin, double ymin, double xmax, double ymax) {
            if (xmax < xmin || ymax < ymin) {
                throw new IllegalArgumentException("Invalid rectangle");
            }
            this.xmin = xmin;
            this.ymin = ymin;
            this.xmax = xmax;
            this.ymax = ymax;
        }

        public double xmin() {
            return this.xmin;
        }

        public double ymin() {
            return this.ymin;
        }

        public double xmax() {
            return this.xmax;
        }

        public double ymax() {
            return this.ymax;
        }

        public double width() {
            return this.xmax - this.xmin;
        }

        public double height() {
            return this.ymax - this.ymin;
        }

        public boolean intersects(RectHV that) {
            return this.xmax >= that.xmin && this.ymax >= that.ymin && that.xmax >= this.xmin && that.ymax >= this.ymin;
        }

        public void draw() {
            StdDraw.line((double)this.xmin, (double)this.ymin, (double)this.xmax, (double)this.ymin);
            StdDraw.line((double)this.xmax, (double)this.ymin, (double)this.xmax, (double)this.ymax);
            StdDraw.line((double)this.xmax, (double)this.ymax, (double)this.xmin, (double)this.ymax);
            StdDraw.line((double)this.xmin, (double)this.ymax, (double)this.xmin, (double)this.ymin);
        }

        public double distanceTo(Point2D p) {
            return Math.sqrt(this.distanceSquaredTo(p));
        }

        public double distanceSquaredTo(Point2D p) {
            double dx = 0.0;
            double dy = 0.0;
            if (p.x() < this.xmin) {
                dx = p.x() - this.xmin;
            } else if (p.x() > this.xmax) {
                dx = p.x() - this.xmax;
            }
            if (p.y() < this.ymin) {
                dy = p.y() - this.ymin;
            } else if (p.y() > this.ymax) {
                dy = p.y() - this.ymax;
            }
            return dx * dx + dy * dy;
        }

        public boolean contains(Point2D p) {
            return p.x() >= this.xmin && p.x() <= this.xmax && p.y() >= this.ymin && p.y() <= this.ymax;
        }

        public boolean equals(Object y) {
            if (y == this) {
                return true;
            }
            if (y == null) {
                return false;
            }
            if (y.getClass() != this.getClass()) {
                return false;
            }
            RectHV that = (RectHV)y;
            if (this.xmin != that.xmin) {
                return false;
            }
            if (this.ymin != that.ymin) {
                return false;
            }
            if (this.xmax != that.xmax) {
                return false;
            }
            return this.ymax == that.ymax;
        }

        public String toString() {
            return "[" + this.xmin + ", " + this.xmax + "] x [" + this.ymin + ", " + this.ymax + "]";
        }
    }

    public static class Bound {
        public double minLat;
        public double maxLat;
        public double minLon;
        public double maxLon;
    }

    public static class Point
    extends Point2D {
        private Integer id;

        public Point(double x, double y) {
            super(x, y);
        }

        public Point(Integer id, double x, double y) {
            super(x, y);
            this.id = id;
        }

        public Point(double x, double y, Integer id) {
            super(x, y);
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    private static class Node {
        private Point point;
        private RectHV rect;
        private Node left;
        private Node right;

        public Node(Point p, RectHV rect) {
            this.point = p;
            this.rect = rect;
        }
    }
}

