/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.algo;

import com.google.common.collect.Maps;
import com.whimsy.map.algo.AStar;
import com.whimsy.map.api.Graph;
import com.whimsy.map.base.Pair;
import java.util.Map;

public class CachedAstar
extends AStar {
    public Map<Pair<Integer, Integer>, Double> shorestPairCache = Maps.newHashMap();

    public CachedAstar(Graph graph) {
        super(graph);
    }

    @Override
    public double query(int sId, int tId) {
        Double dist = this.shorestPairCache.get(new Pair<Integer, Integer>(sId, tId));
        if (dist != null) {
            return dist;
        }
        dist = super.query(sId, tId);
        this.shorestPairCache.put(new Pair<Integer, Integer>(sId, tId), dist);
        LOG.info("Query shortestPath bewteen {} to {}, length = {}", new Object[]{sId, tId, dist});
        return dist;
    }
}

