package com.whimsy.map.api;


import java.io.InputStream;
import java.util.List;
import java.util.Scanner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Lists;
import com.whimsy.map.algo.AStar;

import edu.princeton.cs.algs4.Stopwatch;

/**
 * Created by whimsy on 5/27/15.
 */
public class Graph {

    Logger LOG = LoggerFactory.getLogger(Graph.class);


    // raw data
    boolean isNodeLoaded;
    public List<Node> nodes;

    boolean isEdgeLoaded;
    public List<Edge> edges;





    AStar shortestPathAlgo;

    public Graph() {
    }

    public Graph(List<Node> nodes, List<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
        isNodeLoaded = true;
        isEdgeLoaded = true;
    }

    public void loadNode(InputStream nodeFile) {

        LOG.info("Start Loading Node File");

        Stopwatch stopwatch = new Stopwatch();

        Scanner in = new Scanner(nodeFile);

        nodes = Lists.newArrayList();

        while (in.hasNext()) {
            int id = in.nextInt();
            double lat = in.nextDouble();
            double lon = in.nextDouble();

            nodes.add(new Node(id, lat, lon));
        }

        in.close();

        isNodeLoaded = true;
        LOG.info("Loaded Node File {} sec", stopwatch.elapsedTime());

    }

    public void loadEdge(InputStream edgeFile) {

        LOG.info("Start Loading Edge file");
        Stopwatch stopwatch = new Stopwatch();

        Scanner in = new Scanner(edgeFile);


        edges = Lists.newArrayList();
        while (in.hasNext()) {

            Edge edge = new Edge();

            int edgeId = in.nextInt();

            int sId = in.nextInt();
            int eId = in.nextInt();

            edge.id = edgeId;
            edge.sId = sId;
            edge.eId = eId;

            int num = in.nextInt();
            for (int i = 0; i < num; ++i) {
                double lat = in.nextDouble();
                double lon = in.nextDouble();

                Edge.Figure figure = new Edge.Figure();
                figure.lat = lat;
                figure.lon = lon;

                edge.figures.add(figure);

            }

            edges.add(edge);
        }

        isEdgeLoaded = true;
        LOG.info("Loaded Edge file {} sec", stopwatch.elapsedTime());
    }

}
