package com.whimsy.map.api;

import java.io.InputStream;
import java.util.List;

import com.whimsy.map.algo.AStar;
import com.whimsy.map.algo.CachedAstar;
import com.whimsy.map.algo.GridIndex;
import com.whimsy.map.algo.KdTree;
import com.whimsy.map.algo.MapMatching;
import com.whimsy.map.exception.GraphNotBuildException;
import com.whimsy.map.exception.GridNotBuildedException;
import com.whimsy.map.exception.KdTreeNotBuildException;
import com.whimsy.map.exception.MapMatchingNotBuildException;
import com.whimsy.map.exception.ShortestPathAlgoNotBuildException;

/**
 * Created by whimsy on 6/11/15.
 */
public class Facade {

    boolean isGraphBuilded = false;
    public Graph graph;
    public void buildGraph(InputStream nodeIS, InputStream edgeIS) {
        graph = new Graph();
        graph.loadNode(nodeIS);
        graph.loadEdge(edgeIS);

        isGraphBuilded = true;
    }

    // KDTree start

    boolean isKdTreebuilded = false;
    public KdTree kdTree;

    public void buildKdTree() {
        if (!isGraphBuilded) {
            throw new GraphNotBuildException();
        }
        kdTree = new KdTree(graph);
        isKdTreebuilded = true;
    }

    public KdTree.Point nearest(double lat, double lon) {
        if (!isKdTreebuilded) {
            throw new KdTreeNotBuildException();
        }

        return kdTree.nearest(lat, lon);
    }

    // KDTree end


    // Shortest Path Algorithm Start


    boolean isShortestPathAlgoBuilded;
    public AStar shortestPathAlgo;

    public void buildShortestPathAlgo() {
        if (!isGraphBuilded) {
            throw new GraphNotBuildException();
        }
        shortestPathAlgo = new CachedAstar(graph);

        isShortestPathAlgoBuilded = true;
    }

    public Node [] query(int s, int t) {

        if (!isShortestPathAlgoBuilded) {
            throw new ShortestPathAlgoNotBuildException();
        }
        return shortestPathAlgo.findPath(s, t);
    }


    // Shortest Path Algorithm End.


    // GridIndex Start
    boolean isGridIndexBuilded;

    public GridIndex gridIndex;

    public void buildGridIndex(int gridPartition) {
        if (!isGraphBuilded) {
            throw new GraphNotBuildException();
        }

        gridIndex = new GridIndex(graph, gridPartition);
        isGridIndexBuilded = true;
    }

    public List<Edge> getNearEdges(double lat, double lon, int k) {

        if (!isGridIndexBuilded) {
            throw new GridNotBuildedException();
        }
        return gridIndex.getNearEdges(lat, lon, k);
    }

    // GridIndex End.

    // Map Matching Start
    boolean isMapMatchingBuilded;
    public MapMatching mapMatching;
    public void buildMapMatching(int gridPartition) {
        if (!isGraphBuilded) {
            throw new GraphNotBuildException();
        }

        mapMatching = new MapMatching(graph, gridPartition);
        isMapMatchingBuilded = true;
    }

    public List<Edge> nearestMatching(List<GeoPoint> trajectory) {

        if (!isMapMatchingBuilded) {
            throw new MapMatchingNotBuildException();
        }
        return mapMatching.nearestMatching(trajectory);
    }

    public List<Edge> hmmMatching(List<GeoPoint> trajectory, int k) {
        if (!isMapMatchingBuilded) {
            throw new MapMatchingNotBuildException();
        }
        return mapMatching.hmmMatching(trajectory, k);
    }

    // Map Matching End.

}
