package com.whimsy.map.algo;

import java.util.Map;

import com.google.common.collect.Maps;
import com.whimsy.map.api.Graph;
import com.whimsy.map.base.Pair;

/**
 * Created by whimsy on 6/11/15.
 */
public class CachedAstar extends AStar {
    public CachedAstar(Graph graph) {
        super(graph);
    }


    // should memorize
    public Map<Pair<Integer, Integer>, Double> shorestPairCache = Maps.newHashMap();

    public double query(int sId, int tId) {

        Double dist = shorestPairCache.get(new Pair<Integer, Integer>(sId, tId));

        if (dist != null) {
            return dist;
        } else {
            dist = super.query(sId, tId);

            shorestPairCache.put(new Pair<Integer, Integer>(sId, tId), dist);
        }


        LOG.info("Query shortestPath bewteen {} to {}, length = {}", sId, tId, dist);

        return dist;
    }
}
