/*
 * Decompiled with CFR 0.152.
 */
package com.whimsy.map.entry;

import com.google.common.collect.Lists;
import com.whimsy.map.algo.MapMaptching;
import com.whimsy.map.base.Edge;
import com.whimsy.map.base.GeoPoint;
import com.whimsy.map.base.Graph;
import edu.princeton.cs.algs4.Stopwatch;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainEntry {
    static final Logger LOG = LoggerFactory.getLogger(MainEntry.class);
    public static int K = 20;
    Graph graph = new Graph();

    public MainEntry() {
        this.graph.loadNode(this.getClass().getClassLoader().getResourceAsStream("nodeOSM.txt"));
        this.graph.loadEdge(this.getClass().getClassLoader().getResourceAsStream("edgeOSM.txt"));
        this.graph.buildGridIndex(50);
        this.graph.buildShortestPathAlgorithm();
    }

    void NearestEdgeMatch() {
        MapMaptching mapMaptching = new MapMaptching(this.graph);
        List<GeoPoint> trajectory = this.loadTrajectory();
        LOG.info("Going to start naive MapMatching");
        Stopwatch stopwatch = new Stopwatch();
        List<Edge> edges = mapMaptching.nearestMatching(trajectory);
        LOG.info("Matching time comsumes {} sec", (Object)stopwatch.elapsedTime());
        this.printEdges(edges, "naiveMatch.txt");
    }

    void HmmMatch() {
        MapMaptching mapMaptching = new MapMaptching(this.graph);
        List<GeoPoint> trajectory = this.loadTrajectory();
        LOG.info("Going to start Hmm MapMatching");
        Stopwatch stopwatch = new Stopwatch();
        List<Edge> edges = mapMaptching.hmmMatching(trajectory, 20);
        LOG.info("Matching time consumes {} sec", (Object)stopwatch.elapsedTime());
        this.printEdges(edges, "hmmMatch.txt");
    }

    private void printEdges(List<Edge> edges, String rawFilename) {
        String filename = this.getClass().getClassLoader().getResource("").getPath() + "/" + rawFilename;
        LOG.info("Generate Matching Edge File : {}", (Object)filename);
        try {
            PrintWriter out = new PrintWriter(filename);
            int cnt = 0;
            for (Edge edge : edges) {
                if (edge != null) {
                    out.println(edge.id);
                } else {
                    LOG.info("Not found Matching Edge in traj {}", (Object)cnt);
                }
                ++cnt;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private List<GeoPoint> loadTrajectory() {
        Scanner in = new Scanner(this.getClass().getClassLoader().getResourceAsStream("20081023025304.plt.path"));
        ArrayList res = Lists.newArrayList();
        while (in.hasNext()) {
            res.add(new GeoPoint(in.nextDouble(), in.nextDouble(), in.nextDouble()));
        }
        return res;
    }

    public static void main(String[] args) {
        MainEntry mainEntry = new MainEntry();
        mainEntry.HmmMatch();
    }
}

