package com.whimsy.map.base;

import java.util.List;

import com.google.common.collect.Lists;


import static com.whimsy.map.base.Utils.*;

/**
 * Created by whimsy on 5/27/15.
 * 路网中的边
 */
public class Edge {

    public int id;
    public int sId;
    public int eId;

    public List<Figure> figures = Lists.newArrayList();


    private boolean isCalculatedM = false;
    private boolean isCalculated = false;

    private double lenM = 0;
    private double len = 0;

    public static class Figure {
        public double lon;
        public double lat;

        public Figure() {
        }

        public Figure(double lat, double lon) {
            this.lon = lon;
            this.lat = lat;
        }
    }

    public double lenM() {
        if (!isCalculatedM) {
            for (int i = 0; i < figures.size() - 1; ++i) {
                lenM += distM(figures.get(i).lat, figures.get(i).lon, figures.get(i+1).lat, figures.get(i+1).lon);
            }

            isCalculatedM = true;
        }

        return lenM;
    }

    public double len() {
        if (!isCalculated) {
            for (int i = 0; i < figures.size() - 1; ++i) {
                len += dist(figures.get(i).lat, figures.get(i).lon, figures.get(i + 1).lat,
                                     figures.get(i + 1).lon);
            }

            isCalculated = true;
        }
        return len;
    }

    @Override
    public String toString() {
        return "" + id;
    }
}
