/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.introcs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.InputMismatchException;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class In {
    private Scanner scanner;
    private static final String charsetName = "UTF-8";
    private static final Locale usLocale = new Locale("en", "US");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static final Pattern EMPTY_PATTERN = Pattern.compile("");
    private static final Pattern EVERYTHING_PATTERN = Pattern.compile("\\A");

    public In() {
        this.scanner = new Scanner((InputStream)new BufferedInputStream(System.in), charsetName);
        this.scanner.useLocale(usLocale);
    }

    public In(Socket socket) {
        try {
            InputStream is = socket.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), charsetName);
            this.scanner.useLocale(usLocale);
        }
        catch (IOException ioe) {
            System.err.println("Could not open " + socket);
        }
    }

    public In(URL url) {
        try {
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), charsetName);
            this.scanner.useLocale(usLocale);
        }
        catch (IOException ioe) {
            System.err.println("Could not open " + url);
        }
    }

    public In(File file) {
        try {
            this.scanner = new Scanner(file, charsetName);
            this.scanner.useLocale(usLocale);
        }
        catch (IOException ioe) {
            System.err.println("Could not open " + file);
        }
    }

    public In(String s) {
        try {
            File file = new File(s);
            if (file.exists()) {
                this.scanner = new Scanner(file, charsetName);
                this.scanner.useLocale(usLocale);
                return;
            }
            URL url = this.getClass().getResource(s);
            if (url == null) {
                url = new URL(s);
            }
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            this.scanner = new Scanner((InputStream)new BufferedInputStream(is), charsetName);
            this.scanner.useLocale(usLocale);
        }
        catch (IOException ioe) {
            System.err.println("Could not open " + s);
        }
    }

    public In(Scanner scanner) {
        this.scanner = scanner;
    }

    public boolean exists() {
        return this.scanner != null;
    }

    public boolean isEmpty() {
        return !this.scanner.hasNext();
    }

    public boolean hasNextLine() {
        return this.scanner.hasNextLine();
    }

    public boolean hasNextChar() {
        this.scanner.useDelimiter(EMPTY_PATTERN);
        boolean result = this.scanner.hasNext();
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return result;
    }

    public String readLine() {
        String line;
        try {
            line = this.scanner.nextLine();
        }
        catch (Exception e) {
            line = null;
        }
        return line;
    }

    public char readChar() {
        this.scanner.useDelimiter(EMPTY_PATTERN);
        String ch = this.scanner.next();
        assert (ch.length() == 1) : "Internal (Std)In.readChar() error! Please contact the authors.";
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return ch.charAt(0);
    }

    public String readAll() {
        if (!this.scanner.hasNextLine()) {
            return "";
        }
        String result = this.scanner.useDelimiter(EVERYTHING_PATTERN).next();
        this.scanner.useDelimiter(WHITESPACE_PATTERN);
        return result;
    }

    public String readString() {
        return this.scanner.next();
    }

    public int readInt() {
        return this.scanner.nextInt();
    }

    public double readDouble() {
        return this.scanner.nextDouble();
    }

    public float readFloat() {
        return this.scanner.nextFloat();
    }

    public long readLong() {
        return this.scanner.nextLong();
    }

    public short readShort() {
        return this.scanner.nextShort();
    }

    public byte readByte() {
        return this.scanner.nextByte();
    }

    public boolean readBoolean() {
        String s = this.readString();
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equals("1")) {
            return true;
        }
        if (s.equals("0")) {
            return false;
        }
        throw new InputMismatchException();
    }

    public String[] readAllStrings() {
        String[] tokens = WHITESPACE_PATTERN.split(this.readAll());
        if (tokens.length == 0 || tokens[0].length() > 0) {
            return tokens;
        }
        String[] decapitokens = new String[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            decapitokens[i] = tokens[i + 1];
        }
        return decapitokens;
    }

    public int[] readAllInts() {
        String[] fields = this.readAllStrings();
        int[] vals = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Integer.parseInt(fields[i]);
        }
        return vals;
    }

    public double[] readAllDoubles() {
        String[] fields = this.readAllStrings();
        double[] vals = new double[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vals[i] = Double.parseDouble(fields[i]);
        }
        return vals;
    }

    public void close() {
        this.scanner.close();
    }

    public static int[] readInts(String filename) {
        return new In(filename).readAllInts();
    }

    public static double[] readDoubles(String filename) {
        return new In(filename).readAllDoubles();
    }

    public static String[] readStrings(String filename) {
        return new In(filename).readAllStrings();
    }

    public static int[] readInts() {
        return new In().readAllInts();
    }

    public static double[] readDoubles() {
        return new In().readAllDoubles();
    }

    public static String[] readStrings() {
        return new In().readAllStrings();
    }

    public static void main(String[] args) {
        String s;
        In in;
        String urlName = "http://introcs.cs.princeton.edu/stdlib/InTest.txt";
        System.out.println("readAll() from URL " + urlName);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(urlName);
            System.out.println(in.readAll());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from URL " + urlName);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(urlName);
            while (!in.isEmpty()) {
                s = in.readLine();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readString() from URL " + urlName);
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In(urlName);
            while (!in.isEmpty()) {
                s = in.readString();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from current directory");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("./InTest.txt");
            while (!in.isEmpty()) {
                s = in.readLine();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from relative path");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("../stdlib/InTest.txt");
            while (!in.isEmpty()) {
                s = in.readLine();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readChar() from file");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("InTest.txt");
            while (!in.isEmpty()) {
                char c = in.readChar();
                System.out.print(c);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println();
        System.out.println("readLine() from absolute OS X / Linux path");
        System.out.println("---------------------------------------------------------------------------");
        in = new In("/n/fs/introcs/www/java/stdlib/InTest.txt");
        try {
            while (!in.isEmpty()) {
                String s2 = in.readLine();
                System.out.println(s2);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("readLine() from absolute Windows path");
        System.out.println("---------------------------------------------------------------------------");
        try {
            in = new In("G:\\www\\introcs\\stdlib\\InTest.txt");
            while (!in.isEmpty()) {
                String s3 = in.readLine();
                System.out.println(s3);
            }
            System.out.println();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
    }
}

