/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Queue;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieST<Value> {
    private static final int R = 256;
    private Node root = new Node();

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public Value get(String key) {
        Node x = this.get(this.root, key, 0);
        if (x == null) {
            return null;
        }
        return (Value)x.val;
    }

    private Node get(Node x, String key, int d) {
        if (x == null) {
            return null;
        }
        if (d == key.length()) {
            return x;
        }
        char c = key.charAt(d);
        return this.get(x.next[c], key, d + 1);
    }

    public void put(String key, Value val) {
        this.root = this.put(this.root, key, val, 0);
    }

    private Node put(Node x, String key, Value val, int d) {
        if (x == null) {
            x = new Node();
        }
        if (d == key.length()) {
            x.val = val;
            return x;
        }
        char c = key.charAt(d);
        ((Node)x).next[c] = this.put(x.next[c], key, val, d + 1);
        return x;
    }

    public String longestPrefixOf(String query) {
        int length = this.longestPrefixOf(this.root, query, 0, 0);
        return query.substring(0, length);
    }

    private int longestPrefixOf(Node x, String query, int d, int length) {
        if (x == null) {
            return length;
        }
        if (x.val != null) {
            length = d;
        }
        if (d == query.length()) {
            return length;
        }
        char c = query.charAt(d);
        return this.longestPrefixOf(x.next[c], query, d + 1, length);
    }

    public Iterable<String> keys() {
        return this.keysWithPrefix("");
    }

    public Iterable<String> keysWithPrefix(String prefix) {
        Queue<String> queue = new Queue<String>();
        Node x = this.get(this.root, prefix, 0);
        this.collect(x, prefix, queue);
        return queue;
    }

    private void collect(Node x, String key, Queue<String> queue) {
        if (x == null) {
            return;
        }
        if (x.val != null) {
            queue.enqueue(key);
        }
        for (int c = 0; c < 256; ++c) {
            this.collect(x.next[c], key + (char)c, queue);
        }
    }

    public Iterable<String> keysThatMatch(String pat) {
        Queue<String> q = new Queue<String>();
        this.collect(this.root, "", pat, q);
        return q;
    }

    public void collect(Node x, String prefix, String pat, Queue<String> q) {
        if (x == null) {
            return;
        }
        if (prefix.length() == pat.length() && x.val != null) {
            q.enqueue(prefix);
        }
        if (prefix.length() == pat.length()) {
            return;
        }
        int next = pat.charAt(prefix.length());
        for (int c = 0; c < 256; ++c) {
            if (next != 46 && next != c) continue;
            this.collect(x.next[c], prefix + (char)c, pat, q);
        }
    }

    public void delete(String key) {
        this.root = this.delete(this.root, key, 0);
    }

    private Node delete(Node x, String key, int d) {
        int c;
        if (x == null) {
            return null;
        }
        if (d == key.length()) {
            x.val = null;
        } else {
            c = key.charAt(d);
            ((Node)x).next[c] = this.delete(x.next[c], key, d + 1);
        }
        if (x.val != null) {
            return x;
        }
        for (c = 0; c < 256; ++c) {
            if (x.next[c] == null) continue;
            return x;
        }
        return null;
    }

    public static void main(String[] args) {
        TrieST<Integer> st = new TrieST<Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        for (String key : st.keys()) {
            StdOut.println(key + " " + st.get(key));
        }
    }

    private static class Node {
        private Object val;
        private Node[] next = new Node[256];

        private Node() {
        }
    }
}

