/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Arrays;

public class SuffixArray {
    private Suffix[] suffixes;

    public SuffixArray(String text) {
        int N = text.length();
        this.suffixes = new Suffix[N];
        for (int i = 0; i < N; ++i) {
            this.suffixes[i] = new Suffix(text, i);
        }
        Arrays.sort(this.suffixes);
    }

    public int length() {
        return this.suffixes.length;
    }

    public int index(int i) {
        return this.suffixes[i].index;
    }

    public int lcp(int i) {
        return SuffixArray.lcp(this.suffixes[i], this.suffixes[i - 1]);
    }

    private static int lcp(Suffix s, Suffix t) {
        int N = Math.min(s.length(), t.length());
        for (int i = 0; i < N; ++i) {
            if (s.charAt(i) == t.charAt(i)) continue;
            return i;
        }
        return N;
    }

    public String select(int i) {
        return this.suffixes[i].toString();
    }

    public int rank(String query) {
        int lo = 0;
        int hi = this.suffixes.length - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            int cmp = SuffixArray.compare(query, this.suffixes[mid]);
            if (cmp < 0) {
                hi = mid - 1;
                continue;
            }
            if (cmp > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return lo;
    }

    private static int compare(String query, Suffix suffix) {
        int N = Math.min(query.length(), suffix.length());
        for (int i = 0; i < N; ++i) {
            if (query.charAt(i) < suffix.charAt(i)) {
                return -1;
            }
            if (query.charAt(i) <= suffix.charAt(i)) continue;
            return 1;
        }
        return query.length() - suffix.length();
    }

    public static void main(String[] args) {
        String s = StdIn.readAll().replaceAll("\\s+", " ").trim();
        SuffixArray suffix = new SuffixArray(s);
        StdOut.println("rank(" + args[0] + ") = " + suffix.rank(args[0]));
        StdOut.println("  i ind lcp rnk  select");
        StdOut.println("---------------------------");
        for (int i = 0; i < s.length(); ++i) {
            int index = suffix.index(i);
            String ith = "\"" + s.substring(index, Math.min(index + 50, s.length())) + "\"";
            int rank = suffix.rank(suffix.select(i));
            if (i == 0) {
                StdOut.printf("%3d %3d %3s %3d  %s\n", i, index, "-", rank, ith);
                continue;
            }
            int lcp = suffix.lcp(i);
            StdOut.printf("%3d %3d %3d %3d  %s\n", i, index, lcp, rank, ith);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Suffix
    implements Comparable<Suffix> {
        private final String text;
        private final int index;

        private Suffix(String text, int index) {
            this.text = text;
            this.index = index;
        }

        private int length() {
            return this.text.length() - this.index;
        }

        private char charAt(int i) {
            return this.text.charAt(this.index + i);
        }

        @Override
        public int compareTo(Suffix that) {
            if (this == that) {
                return 0;
            }
            int N = Math.min(this.length(), that.length());
            for (int i = 0; i < N; ++i) {
                if (this.charAt(i) < that.charAt(i)) {
                    return -1;
                }
                if (this.charAt(i) <= that.charAt(i)) continue;
                return 1;
            }
            return this.length() - that.length();
        }

        public String toString() {
            return this.text.substring(this.index);
        }
    }
}

