/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Queue;
import edu.princeton.cs.algs4.SequentialSearchST;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparateChainingHashST<Key, Value> {
    private static final int INIT_CAPACITY = 4;
    private int N;
    private int M;
    private SequentialSearchST<Key, Value>[] st;

    public SeparateChainingHashST() {
        this(4);
    }

    public SeparateChainingHashST(int M) {
        this.M = M;
        this.st = new SequentialSearchST[M];
        for (int i = 0; i < M; ++i) {
            this.st[i] = new SequentialSearchST();
        }
    }

    private void resize(int chains) {
        SeparateChainingHashST<Key, Value> temp = new SeparateChainingHashST<Key, Value>(chains);
        for (int i = 0; i < this.M; ++i) {
            for (Key key : this.st[i].keys()) {
                temp.put(key, this.st[i].get(key));
            }
        }
        this.M = temp.M;
        this.N = temp.N;
        this.st = temp.st;
    }

    private int hash(Key key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.M;
    }

    public int size() {
        return this.N;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Key key) {
        return this.get(key) != null;
    }

    public Value get(Key key) {
        int i = this.hash(key);
        return this.st[i].get(key);
    }

    public void put(Key key, Value val) {
        int i;
        if (val == null) {
            this.delete(key);
            return;
        }
        if (this.N >= 10 * this.M) {
            this.resize(2 * this.M);
        }
        if (!this.st[i = this.hash(key)].contains(key)) {
            ++this.N;
        }
        this.st[i].put(key, val);
    }

    public void delete(Key key) {
        int i = this.hash(key);
        if (this.st[i].contains(key)) {
            --this.N;
        }
        this.st[i].delete(key);
        if (this.M > 4 && this.N <= 2 * this.M) {
            this.resize(this.M / 2);
        }
    }

    public Iterable<Key> keys() {
        Queue<Key> queue = new Queue<Key>();
        for (int i = 0; i < this.M; ++i) {
            for (Key key : this.st[i].keys()) {
                queue.enqueue(key);
            }
        }
        return queue;
    }

    public static void main(String[] args) {
        SeparateChainingHashST<String, Integer> st = new SeparateChainingHashST<String, Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        for (String s : st.keys()) {
            StdOut.println(s + " " + st.get(s));
        }
    }
}

