/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ST<Key extends Comparable<Key>, Value>
implements Iterable<Key> {
    private TreeMap<Key, Value> st = new TreeMap();

    public void put(Key key, Value val) {
        if (val == null) {
            this.st.remove(key);
        } else {
            this.st.put(key, val);
        }
    }

    public Value get(Key key) {
        return this.st.get(key);
    }

    public Value delete(Key key) {
        return this.st.remove(key);
    }

    public boolean contains(Key key) {
        return this.st.containsKey(key);
    }

    public int size() {
        return this.st.size();
    }

    public Iterable<Key> keys() {
        return this.st.keySet();
    }

    @Override
    public Iterator<Key> iterator() {
        return this.st.keySet().iterator();
    }

    public Key min() {
        return (Key)((Comparable)this.st.firstKey());
    }

    public Key max() {
        return (Key)((Comparable)this.st.lastKey());
    }

    public Key ceil(Key k) {
        SortedMap<Key, Value> tail = this.st.tailMap(k);
        if (tail.isEmpty()) {
            return null;
        }
        return (Key)((Comparable)tail.firstKey());
    }

    public Key floor(Key k) {
        if (this.st.containsKey(k)) {
            return k;
        }
        SortedMap<Key, Value> head = this.st.headMap(k);
        if (head.isEmpty()) {
            return null;
        }
        return (Key)((Comparable)head.lastKey());
    }

    public static void main(String[] args) {
        ST<String, Integer> st = new ST<String, Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        for (String s : st.keys()) {
            StdOut.println(s + " " + st.get(s));
        }
    }
}

