/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Bag;
import edu.princeton.cs.algs4.Digraph;
import edu.princeton.cs.algs4.DirectedDFS;
import edu.princeton.cs.algs4.Stack;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;

public class NFA {
    private Digraph G;
    private String regexp;
    private int M;

    public NFA(String regexp) {
        this.regexp = regexp;
        this.M = regexp.length();
        Stack<Integer> ops = new Stack<Integer>();
        this.G = new Digraph(this.M + 1);
        for (int i = 0; i < this.M; ++i) {
            int lp = i;
            if (regexp.charAt(i) == '(' || regexp.charAt(i) == '|') {
                ops.push(i);
            } else if (regexp.charAt(i) == ')') {
                int or = (Integer)ops.pop();
                if (regexp.charAt(or) == '|') {
                    lp = (Integer)ops.pop();
                    this.G.addEdge(lp, or + 1);
                    this.G.addEdge(or, i);
                } else if (regexp.charAt(or) == '(') {
                    lp = or;
                } else assert (false);
            }
            if (i < this.M - 1 && regexp.charAt(i + 1) == '*') {
                this.G.addEdge(lp, i + 1);
                this.G.addEdge(i + 1, lp);
            }
            if (regexp.charAt(i) != '(' && regexp.charAt(i) != '*' && regexp.charAt(i) != ')') continue;
            this.G.addEdge(i, i + 1);
        }
    }

    public boolean recognizes(String txt) {
        DirectedDFS dfs = new DirectedDFS(this.G, 0);
        Bag<Integer> pc = new Bag<Integer>();
        for (int v = 0; v < this.G.V(); ++v) {
            if (!dfs.marked(v)) continue;
            pc.add(v);
        }
        for (int i = 0; i < txt.length(); ++i) {
            Bag<Integer> match = new Bag<Integer>();
            Iterator i$ = pc.iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                if (v == this.M || this.regexp.charAt(v) != txt.charAt(i) && this.regexp.charAt(v) != '.') continue;
                match.add(v + 1);
            }
            dfs = new DirectedDFS(this.G, match);
            pc = new Bag();
            for (int v = 0; v < this.G.V(); ++v) {
                if (!dfs.marked(v)) continue;
                pc.add(v);
            }
            if (pc.size() != 0) continue;
            return false;
        }
        Iterator i$ = pc.iterator();
        while (i$.hasNext()) {
            int v = (Integer)i$.next();
            if (v != this.M) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String regexp = "(" + args[0] + ")";
        String txt = args[1];
        NFA nfa = new NFA(regexp);
        StdOut.println(nfa.recognizes(txt));
    }
}

