/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.DijkstraSP;
import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.algs4.EdgeWeightedDigraph;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;

public class AssignmentProblem {
    private static final int UNMATCHED = -1;
    private int N;
    private double[][] weight;
    private double[] px;
    private double[] py;
    private int[] xy;
    private int[] yx;

    public AssignmentProblem(double[][] weight) {
        int i;
        this.N = weight.length;
        this.weight = new double[this.N][this.N];
        for (i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.weight[i][j] = weight[i][j];
            }
        }
        this.px = new double[this.N];
        this.py = new double[this.N];
        this.xy = new int[this.N];
        this.yx = new int[this.N];
        for (i = 0; i < this.N; ++i) {
            this.xy[i] = -1;
        }
        for (int j = 0; j < this.N; ++j) {
            this.yx[j] = -1;
        }
        for (int k = 0; k < this.N; ++k) {
            assert (this.isDualFeasible());
            assert (this.isComplementarySlack());
            this.augment();
        }
        assert (this.check());
    }

    private void augment() {
        int i;
        EdgeWeightedDigraph G = new EdgeWeightedDigraph(2 * this.N + 2);
        int s = 2 * this.N;
        int t = 2 * this.N + 1;
        for (i = 0; i < this.N; ++i) {
            if (this.xy[i] != -1) continue;
            G.addEdge(new DirectedEdge(s, i, 0.0));
        }
        for (int j = 0; j < this.N; ++j) {
            if (this.yx[j] != -1) continue;
            G.addEdge(new DirectedEdge(this.N + j, t, this.py[j]));
        }
        for (i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (this.xy[i] == j) {
                    G.addEdge(new DirectedEdge(this.N + j, i, 0.0));
                    continue;
                }
                G.addEdge(new DirectedEdge(i, this.N + j, this.reduced(i, j)));
            }
        }
        DijkstraSP spt = new DijkstraSP(G, s);
        for (DirectedEdge e : spt.pathTo(t)) {
            int i2 = e.from();
            int j = e.to() - this.N;
            if (i2 >= this.N) continue;
            this.xy[i2] = j;
            this.yx[j] = i2;
        }
        for (int i3 = 0; i3 < this.N; ++i3) {
            int n = i3;
            this.px[n] = this.px[n] + spt.distTo(i3);
        }
        for (int j = 0; j < this.N; ++j) {
            int n = j;
            this.py[n] = this.py[n] + spt.distTo(this.N + j);
        }
    }

    private double reduced(int i, int j) {
        return this.weight[i][j] + this.px[i] - this.py[j];
    }

    public double dualRow(int i) {
        return this.px[i];
    }

    public double dualCol(int j) {
        return this.py[j];
    }

    public double weight() {
        double total = 0.0;
        for (int i = 0; i < this.N; ++i) {
            if (this.xy[i] == -1) continue;
            total += this.weight[i][this.xy[i]];
        }
        return total;
    }

    public int sol(int i) {
        return this.xy[i];
    }

    private boolean isDualFeasible() {
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (!(this.reduced(i, j) < 0.0)) continue;
                StdOut.println("Dual variables are not feasible");
                return false;
            }
        }
        return true;
    }

    private boolean isComplementarySlack() {
        for (int i = 0; i < this.N; ++i) {
            if (this.xy[i] == -1 || this.reduced(i, this.xy[i]) == 0.0) continue;
            StdOut.println("Primal and dual variables are not complementary slack");
            return false;
        }
        return true;
    }

    private boolean isPerfectMatching() {
        int i;
        boolean[] perm = new boolean[this.N];
        for (i = 0; i < this.N; ++i) {
            if (perm[this.xy[i]]) {
                StdOut.println("Not a perfect matching");
                return false;
            }
            perm[this.xy[i]] = true;
        }
        for (int j = 0; j < this.N; ++j) {
            if (this.xy[this.yx[j]] == j) continue;
            StdOut.println("xy[] and yx[] are not inverses");
            return false;
        }
        for (i = 0; i < this.N; ++i) {
            if (this.yx[this.xy[i]] == i) continue;
            StdOut.println("xy[] and yx[] are not inverses");
            return false;
        }
        return true;
    }

    private boolean check() {
        return this.isPerfectMatching() && this.isDualFeasible() && this.isComplementarySlack();
    }

    public static void main(String[] args) {
        int i;
        int j;
        In in = new In(args[0]);
        int N = in.readInt();
        double[][] weight = new double[N][N];
        for (int i2 = 0; i2 < N; ++i2) {
            for (j = 0; j < N; ++j) {
                weight[i2][j] = in.readDouble();
            }
        }
        AssignmentProblem assignment = new AssignmentProblem(weight);
        StdOut.println("weight = " + assignment.weight());
        for (i = 0; i < N; ++i) {
            StdOut.println(i + "-" + assignment.sol(i) + "' " + weight[i][assignment.sol(i)]);
        }
        for (i = 0; i < N; ++i) {
            StdOut.println("px[" + i + "] = " + assignment.dualRow(i));
        }
        for (j = 0; j < N; ++j) {
            StdOut.println("py[" + j + "] = " + assignment.dualCol(j));
        }
        for (i = 0; i < N; ++i) {
            for (int j2 = 0; j2 < N; ++j2) {
                StdOut.println("reduced[" + i + "-" + j2 + "] = " + assignment.reduced(i, j2));
            }
        }
    }
}

