/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.FlowEdge;
import edu.princeton.cs.algs4.FlowNetwork;
import edu.princeton.cs.algs4.FordFulkerson;
import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class BipartiteMatching {
    public static void main(String[] args) {
        int v;
        int i;
        int N = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        int s = 2 * N;
        int t = 2 * N + 1;
        FlowNetwork G = new FlowNetwork(2 * N + 2);
        for (i = 0; i < E; ++i) {
            v = StdRandom.uniform(N);
            int w = StdRandom.uniform(N) + N;
            G.addEdge(new FlowEdge(v, w, Double.POSITIVE_INFINITY));
            StdOut.println(v + "-" + w);
        }
        for (i = 0; i < N; ++i) {
            G.addEdge(new FlowEdge(s, i, 1.0));
            G.addEdge(new FlowEdge(i + N, t, 1.0));
        }
        FordFulkerson maxflow = new FordFulkerson(G, s, t);
        StdOut.println();
        StdOut.println("Size of maximum matching = " + (int)maxflow.value());
        for (v = 0; v < N; ++v) {
            for (FlowEdge e : G.adj(v)) {
                if (e.from() != v || !(e.flow() > 0.0)) continue;
                StdOut.println(e.from() + "-" + e.to());
            }
        }
    }
}

