/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Graph;
import edu.princeton.cs.algs4.Stack;
import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bipartite {
    private boolean isBipartite = true;
    private boolean[] color;
    private boolean[] marked;
    private int[] edgeTo;
    private Stack<Integer> cycle;

    public Bipartite(Graph G) {
        this.color = new boolean[G.V()];
        this.marked = new boolean[G.V()];
        this.edgeTo = new int[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
        assert (this.check(G));
    }

    private void dfs(Graph G, int v) {
        this.marked[v] = true;
        for (int w : G.adj(v)) {
            if (this.cycle != null) {
                return;
            }
            if (!this.marked[w]) {
                this.edgeTo[w] = v;
                this.color[w] = !this.color[v];
                this.dfs(G, w);
                continue;
            }
            if (this.color[w] != this.color[v]) continue;
            this.isBipartite = false;
            this.cycle = new Stack();
            this.cycle.push(w);
            int x = v;
            while (x != w) {
                this.cycle.push(x);
                x = this.edgeTo[x];
            }
            this.cycle.push(w);
        }
    }

    boolean isBipartite() {
        return this.isBipartite;
    }

    boolean color(int v) {
        return this.color[v];
    }

    public Iterable<Integer> cycle() {
        return this.cycle;
    }

    private boolean check(Graph G) {
        if (this.isBipartite) {
            for (int v = 0; v < G.V(); ++v) {
                for (int w : G.adj(v)) {
                    if (this.color[v] != this.color[w]) continue;
                    System.err.printf("edge %d-%d with %d and %d in same side of bipartition\n", v, w, v, w);
                    return false;
                }
            }
        } else {
            int first = -1;
            int last = -1;
            for (int v : this.cycle()) {
                if (first == -1) {
                    first = v;
                }
                last = v;
            }
            if (first != last) {
                System.err.printf("cycle begins with %d and ends with %d\n", first, last);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int w;
        int v;
        int i;
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        int F = Integer.parseInt(args[2]);
        Graph G = new Graph(V);
        int[] vertices = new int[V];
        for (i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle(vertices);
        for (i = 0; i < E; ++i) {
            v = StdRandom.uniform(V / 2);
            w = StdRandom.uniform(V / 2);
            G.addEdge(vertices[v], vertices[V / 2 + w]);
        }
        for (i = 0; i < F; ++i) {
            v = (int)(Math.random() * (double)V);
            w = (int)(Math.random() * (double)V);
            G.addEdge(v, w);
        }
        StdOut.println(G);
        Bipartite b = new Bipartite(G);
        if (b.isBipartite()) {
            StdOut.println("Graph is bipartite");
            for (v = 0; v < G.V(); ++v) {
                StdOut.println(v + ": " + b.color(v));
            }
        } else {
            StdOut.print("Graph has an odd-length cycle: ");
            for (int x : b.cycle()) {
                StdOut.print(x + " ");
            }
            StdOut.println();
        }
    }
}

