(ns com.webcomrades.horza.spec
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str]))

(defn attach-enum-specs
  [ns enums]
  (doseq [[enum-name enum-def] enums]
    (let [spec-kw (keyword (name ns) (str/lower-case (name enum-name)))
          spec-def (:values enum-def)]
      (eval `(s/def ~spec-kw ~spec-def)))))

(defn attach-entity-specs
  [ns entities])

(defn attach-specs
  [ns {:keys [entity enum]}]
  (do (attach-enum-specs ns enum)
      (attach-entity-specs ns entity)))