(ns com.webcomrades.horza.datomic)

(defn attributes-from-entities
  [entities]
  (into [] (comp (mapcat (fn [[_ entity]] (:horza.entity/attrs entity)))
                 (filter #(not= :horza.attr.type/ref (:horza.attr/type %)))
                 (map (fn [{:horza.attr/keys [name type qualifiers doc cardinality]}]
                        (cond-> {:db/ident       name
                                 :db/cardinality (if (= 'many cardinality) :db.cardinality/many :db.cardinality/one)
                                 :db/valueType   (keyword "db.type" (clojure.core/name type))}

                                (some #{'identity 'unique} qualifiers)
                                (assoc :db/unique :db.unique/identity)

                                doc
                                (assoc :db/doc doc)))))
        entities))

(defmulti attributes-from-model-component :horza.model/type)

(defmethod attributes-from-model-component
  :horza.model/entity
  [{:horza.entity/keys [attrs]}]
  (map (fn [{:horza.attr/keys [name type qualifiers doc cardinality component]}]
         (cond-> {:db/ident       name
                  :db/cardinality (if (= 'many cardinality) :db.cardinality/many :db.cardinality/one)
                  :db/valueType   (keyword "db.type" (clojure.core/name type))}

                 (some #{'identity 'unique} qualifiers)
                 (assoc :db/unique :db.unique/identity)

                 component
                 (assoc :db/isComponent true)

                 doc
                 (assoc :db/doc doc)))
       attrs))

(defmethod attributes-from-model-component
  :horza.model/enum
  [{:horza.enum/keys [values]}]
  (map (comp #(hash-map :db/ident %) :horza.enum.type/value) values))

(defn generate-schema
  [model]
  (into [] (comp (map second)
                 (mapcat attributes-from-model-component))
        model))