// Copyright 2010 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Character lists and their classifications used by character
 * picker widget. Autogenerated from Unicode data:
 * https://sites/cibu/character-picker.
 *
 */

goog.provide('goog.i18n.CharPickerData');



/**
 * Object holding two level character organization and character listing.
 * @constructor
 */
goog.i18n.CharPickerData = function() {};


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYMBOL = goog.getMsg('Symbol');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ARROWS = goog.getMsg('Arrows');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BRAILLE = goog.getMsg('Braille');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CONTROL_PICTURES =
      goog.getMsg('Control Pictures');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CURRENCY = goog.getMsg('Currency');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GAME_PIECES = goog.getMsg('Game Pieces');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GENDER_AND_GENEALOGICAL =
      goog.getMsg('Gender and Genealogical');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GEOMETRIC_SHAPES =
      goog.getMsg('Geometric Shapes');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KEYBOARD_AND_UI =
      goog.getMsg('Keyboard and UI');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MATH = goog.getMsg('Math');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MISCELLANEOUS = goog.getMsg('Miscellaneous');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MUSICAL = goog.getMsg('Musical');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_STARS_ASTERISKS =
      goog.getMsg('Stars/Asterisks');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SUBSCRIPT = goog.getMsg('Subscript');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SUPERSCRIPT = goog.getMsg('Superscript');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TECHNICAL = goog.getMsg('Technical');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_WEATHER_AND_ASTROLOGICAL =
      goog.getMsg('Weather and Astrological');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_YIJING_TAI_XUAN_JING =
      goog.getMsg('Yijing / Tai Xuan Jing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HISTORIC = goog.getMsg('Historic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY = goog.getMsg('Compatibility');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PUNCTUATION = goog.getMsg('Punctuation');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ASCII_BASED = goog.getMsg('ASCII Based');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DASH_CONNECTOR = goog.getMsg('Dash/Connector');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OTHER = goog.getMsg('Other');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PAIRED = goog.getMsg('Paired');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NUMBER = goog.getMsg('Number');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DECIMAL = goog.getMsg('Decimal');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ENCLOSED_DOTTED =
      goog.getMsg('Enclosed/Dotted');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FRACTIONS_RELATED =
      goog.getMsg('Fractions/Related');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FORMAT_WHITESPACE =
      goog.getMsg('Format & Whitespace');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FORMAT = goog.getMsg('Format');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_VARIATION_SELECTOR =
      goog.getMsg('Variation Selector');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_WHITESPACE = goog.getMsg('Whitespace');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MODIFIER = goog.getMsg('Modifier');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ENCLOSING = goog.getMsg('Enclosing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NONSPACING = goog.getMsg('Nonspacing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SPACING = goog.getMsg('Spacing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LATIN = goog.getMsg('Latin');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_COMMON = goog.getMsg('Common');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ENCLOSED = goog.getMsg('Enclosed');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FLIPPED_MIRRORED =
      goog.getMsg('Flipped/Mirrored');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHONETICS_IPA = goog.getMsg('Phonetics (IPA)');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHONETICS_X_IPA =
      goog.getMsg('Phonetics (X-IPA)');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OTHER_EUROPEAN_SCRIPTS =
      goog.getMsg('Other European Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ARMENIAN = goog.getMsg('Armenian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CYRILLIC = goog.getMsg('Cyrillic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GEORGIAN = goog.getMsg('Georgian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GREEK = goog.getMsg('Greek');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_COPTIC = goog.getMsg('Coptic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CYPRIOT = goog.getMsg('Cypriot');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GLAGOLITIC = goog.getMsg('Glagolitic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GOTHIC = goog.getMsg('Gothic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LINEAR_B = goog.getMsg('Linear B');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OGHAM = goog.getMsg('Ogham');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OLD_ITALIC = goog.getMsg('Old Italic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_RUNIC = goog.getMsg('Runic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SHAVIAN = goog.getMsg('Shavian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_AMERICAN_SCRIPTS =
      goog.getMsg('American Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CANADIAN_ABORIGINAL =
      goog.getMsg('Canadian Aboriginal');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CHEROKEE = goog.getMsg('Cherokee');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DESERET = goog.getMsg('Deseret');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_AFRICAN_SCRIPTS =
      goog.getMsg('African Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ETHIOPIC = goog.getMsg('Ethiopic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NKO = goog.getMsg('Nko');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TIFINAGH = goog.getMsg('Tifinagh');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_VAI = goog.getMsg('Vai');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OSMANYA = goog.getMsg('Osmanya');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MIDDLE_EASTERN_SCRIPTS =
      goog.getMsg('Middle Eastern Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ARABIC = goog.getMsg('Arabic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HEBREW = goog.getMsg('Hebrew');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_THAANA = goog.getMsg('Thaana');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CARIAN = goog.getMsg('Carian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CUNEIFORM = goog.getMsg('Cuneiform');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LYCIAN = goog.getMsg('Lycian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LYDIAN = goog.getMsg('Lydian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OLD_PERSIAN = goog.getMsg('Old Persian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHOENICIAN = goog.getMsg('Phoenician');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYRIAC = goog.getMsg('Syriac');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_UGARITIC = goog.getMsg('Ugaritic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SOUTH_ASIAN_SCRIPTS =
      goog.getMsg('South Asian Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BENGALI = goog.getMsg('Bengali');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DEVANAGARI = goog.getMsg('Devanagari');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GUJARATI = goog.getMsg('Gujarati');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GURMUKHI = goog.getMsg('Gurmukhi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KANNADA = goog.getMsg('Kannada');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LEPCHA = goog.getMsg('Lepcha');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LIMBU = goog.getMsg('Limbu');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MALAYALAM = goog.getMsg('Malayalam');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OL_CHIKI = goog.getMsg('Ol Chiki');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ORIYA = goog.getMsg('Oriya');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SAURASHTRA = goog.getMsg('Saurashtra');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SINHALA = goog.getMsg('Sinhala');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAMIL = goog.getMsg('Tamil');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TELUGU = goog.getMsg('Telugu');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TIBETAN = goog.getMsg('Tibetan');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KHAROSHTHI = goog.getMsg('Kharoshthi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHAGS_PA = goog.getMsg('Phags Pa');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYLOTI_NAGRI = goog.getMsg('Syloti Nagri');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SOUTHEAST_ASIAN_SCRIPTS =
      goog.getMsg('Southeast Asian Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BALINESE = goog.getMsg('Balinese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CHAM = goog.getMsg('Cham');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KAYAH_LI = goog.getMsg('Kayah Li');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KHMER = goog.getMsg('Khmer');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LAO = goog.getMsg('Lao');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MYANMAR = goog.getMsg('Myanmar');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NEW_TAI_LUE = goog.getMsg('New Tai Lue');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAI_LE = goog.getMsg('Tai Le');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_THAI = goog.getMsg('Thai');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BUGINESE = goog.getMsg('Buginese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BUHID = goog.getMsg('Buhid');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HANUNOO = goog.getMsg('Hanunoo');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_REJANG = goog.getMsg('Rejang');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SUNDANESE = goog.getMsg('Sundanese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAGALOG = goog.getMsg('Tagalog');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAGBANWA = goog.getMsg('Tagbanwa');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HANGUL = goog.getMsg('Hangul');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OTHER_EAST_ASIAN_SCRIPTS =
      goog.getMsg('Other East Asian Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BOPOMOFO = goog.getMsg('Bopomofo');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HIRAGANA = goog.getMsg('Hiragana');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KATAKANA = goog.getMsg('Katakana');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MONGOLIAN = goog.getMsg('Mongolian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_YI = goog.getMsg('Yi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_1_STROKE_RADICALS =
      goog.getMsg('Han 1-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LESS_COMMON = goog.getMsg('Less Common');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_2_STROKE_RADICALS =
      goog.getMsg('Han 2-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_3_STROKE_RADICALS =
      goog.getMsg('Han 3-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_4_STROKE_RADICALS =
      goog.getMsg('Han 4-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_5_STROKE_RADICALS =
      goog.getMsg('Han 5-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_6_STROKE_RADICALS =
      goog.getMsg('Han 6-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_7_STROKE_RADICALS =
      goog.getMsg('Han 7-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_8_STROKE_RADICALS =
      goog.getMsg('Han 8-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_9_STROKE_RADICALS =
      goog.getMsg('Han 9-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_10_STROKE_RADICALS =
      goog.getMsg('Han 10-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_11_17_STROKE_RADICALS =
      goog.getMsg('Han 11~17-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_OTHER = goog.getMsg('Han - Other');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CJK_STROKES = goog.getMsg('CJK Strokes');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_IDEOGRAPHIC_DESCRIPTION =
      goog.getMsg('Ideographic Description');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NUMERICS = goog.getMsg('Numerics');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PINYIN = goog.getMsg('Pinyin');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ALL = goog.getMsg('All');


/**
 * Top catagory names of character organization.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.prototype.categories = [
  goog.i18n.CharPickerData.MSG_CP_SYMBOL,
  goog.i18n.CharPickerData.MSG_CP_PUNCTUATION,
  goog.i18n.CharPickerData.MSG_CP_NUMBER,
  goog.i18n.CharPickerData.MSG_CP_FORMAT_WHITESPACE,
  goog.i18n.CharPickerData.MSG_CP_MODIFIER,
  goog.i18n.CharPickerData.MSG_CP_LATIN,
  goog.i18n.CharPickerData.MSG_CP_OTHER_EUROPEAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_AMERICAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_AFRICAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_MIDDLE_EASTERN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_SOUTH_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_SOUTHEAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_HANGUL,
  goog.i18n.CharPickerData.MSG_CP_OTHER_EAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_HAN_1_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_2_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_3_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_4_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_5_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_6_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_7_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_8_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_9_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_10_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_11_17_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_OTHER,
  goog.i18n.CharPickerData.MSG_CP_MISCELLANEOUS
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SYMBOL = [
  goog.i18n.CharPickerData.MSG_CP_ARROWS,
  goog.i18n.CharPickerData.MSG_CP_BRAILLE,
  goog.i18n.CharPickerData.MSG_CP_CONTROL_PICTURES,
  goog.i18n.CharPickerData.MSG_CP_CURRENCY,
  goog.i18n.CharPickerData.MSG_CP_GAME_PIECES,
  goog.i18n.CharPickerData.MSG_CP_GENDER_AND_GENEALOGICAL,
  goog.i18n.CharPickerData.MSG_CP_GEOMETRIC_SHAPES,
  goog.i18n.CharPickerData.MSG_CP_KEYBOARD_AND_UI,
  goog.i18n.CharPickerData.MSG_CP_MATH,
  goog.i18n.CharPickerData.MSG_CP_MISCELLANEOUS,
  goog.i18n.CharPickerData.MSG_CP_MUSICAL,
  goog.i18n.CharPickerData.MSG_CP_STARS_ASTERISKS,
  goog.i18n.CharPickerData.MSG_CP_SUBSCRIPT,
  goog.i18n.CharPickerData.MSG_CP_SUPERSCRIPT,
  goog.i18n.CharPickerData.MSG_CP_TECHNICAL,
  goog.i18n.CharPickerData.MSG_CP_WEATHER_AND_ASTROLOGICAL,
  goog.i18n.CharPickerData.MSG_CP_YIJING_TAI_XUAN_JING,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_SYMBOL = [
  '2>807A;f10O728F1f4V1PNF2Wd78?PZl1%2l2',
  ';oA0FN',
  '(j90d3',
  'H3XBMgq30w<40F2Y:Z0;+M01E]J6O6',
  'Q6A06f5#1H2,]4M9Psv+V1I.V1@3W}8',
  '2JA0sOc',
  '2+90FN2U10t2H3kg3u0%E6OW6',
  ';O906$UGv771.Uv46',
  'w010EGX26G6D010f1E:2v2894WX3:2v+]lEQ?60f2E11OH1P1M]1U11U]571WO6WUv1u,8OUmO6G68E8cOF18H6Ue6WGGu:26G8:2NO$M:16H8%2V28H211cvg.]4s9AnU?8ON4PNdkX4-1Gc^RO1t78V686GG6GM8|88k8-58MGs8k8d28M8U8Ok8-UGdQGd4bZw0:;c8%Ef1Ev28v28]BmM',
  '1F68W8e2>90c8GN3]3uV1[72$Ef1E.U8t18W728M8MG-1148MO!GkgOv0',
  ';DA0k2mO1NM[d3Gl5O!f16ut2WN4',
  'oUA0k873g510E',
  'I)B0>E30N18U',
  'XFX1x6e1oUg2701+6G|nE8I030QjW0',
  'A-80PdsWF1GMG6$l7H1!%2N2G|mk]7?',
  'Q4A0F1mv3}1v8,uU',
  'YnK0#5A>E1-7',
  'I{)0%4!P7|%4}3',
  '(PD0MAbU1}2P1!'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_PUNCTUATION = [
  goog.i18n.CharPickerData.MSG_CP_ASCII_BASED,
  goog.i18n.CharPickerData.MSG_CP_DASH_CONNECTOR,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_PAIRED,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_PUNCTUATION = [
  ']2E8EG886[6O6f2H6]1u',
  '14f4gX808M%36%1gu30',
  '(s70:<.MO$EGGG8OEms88Iu3068G6n1',
  'n36f48v2894X1;P80sP26[6^>10F1H76:2,va@1%5M]26;7106G,Q)s06',
  'gm808kIr3072v1U8A(t06',
  'Ig80e91E91686W8$EH1X36P162pw0,12-1G|8F18W86nDE8c8M[6O6X2E8f2886'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_NUMBER = [
  goog.i18n.CharPickerData.MSG_CP_DECIMAL,
  goog.i18n.CharPickerData.MSG_CP_ENCLOSED_DOTTED,
  goog.i18n.CharPickerData.MSG_CP_FRACTIONS_RELATED,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_NUMBER = [
  'P4,At10,HC,1I,fb,%A,%A,%A,%A,%A,%A,%A,%A,XK,%A,X6,PP,X6,Q]10,f3,PR,vB?1F,m,nG,]K,m,Yca0,vz,f3,1I,%A,]a,',
  'gs90V597@1Pvt2g+20,%2s8N1]2,n3N1',
  '9G6eGEoX80Ocm,1IV1%3',
  'ot20cvjE9Ck]Lcvd,^910#1oF10,(V60P2!QZV0,9Ts8^aP0sHn6%JsH2s](#2^5q0l1',
  'o560EgM10,Yk10EGMo230w6u0}39175n1:aMv2$HCUXI,^E10cnQso,60@8',
  'w.80-2o?30EHVM2Us0,w{#0?'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_FORMAT_WHITESPACE = [
  goog.i18n.CharPickerData.MSG_CP_FORMAT,
  goog.i18n.CharPickerData.MSG_CP_VARIATION_SELECTOR,
  goog.i18n.CharPickerData.MSG_CP_WHITESPACE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_FORMAT_WHITESPACE = [
  'vF;Z10Mwx406^H20UX2Uf4Ugn#0;`o0sbwt0vME',
  ']=gg50E^$zA#LDF1AV1',
  ':2;S60gC206',
  'w-10f4^#206IV10(970',
  'fEAQ80?P3P4wB40^@s0'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MODIFIER = [
  goog.i18n.CharPickerData.MSG_CP_ENCLOSING,
  goog.i18n.CharPickerData.MSG_CP_NONSPACING,
  goog.i18n.CharPickerData.MSG_CP_SPACING,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_MODIFIER = [
  '(y80M8E',
  '%+#5GG,8t1(#60E8718kWfJ,P4v%71WO|oWQ1En1sGk%2MT_t0k',
  'f!!^)30(C30f1H5E8?8l18d2X4N32D40XH',
  '%?71HP62x60M[F2926^Py0',
  'n<686'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_LATIN = [
  goog.i18n.CharPickerData.MSG_CP_COMMON,
  goog.i18n.CharPickerData.MSG_CP_ENCLOSED,
  goog.i18n.CharPickerData.MSG_CP_FLIPPED_MIRRORED,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_PHONETICS_IPA,
  goog.i18n.CharPickerData.MSG_CP_PHONETICS_X_IPA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_LATIN = [
  ':5N2mN2P6}18#28V1G,GcGcGcGMW68cGsO6GcGMGMG6GMGd1G$W$6m6H16X9M15O8%c86$N2G8d2G86W86956g<60cH2878Lf706Gf6',
  '^x90}6^yX1#2G118GOOU$uP286G[MG',
  ']r=i1jKjnjQq40L!401GCpwGi0Trh04pM83:liJK1qQMnmaJQE10jm10(;50Lj50wX50{W50A1i0TJd0bB506(T40v]a8zE50I0105010IUi0{Zh0:7=w*Uc:V%Dih:h`h9X%B41n1WSL1Qau9q`jh_Bnm4lPm*mHn6amfmSmH6;+80j630Lj50wX50{W50QW80P1T#806f=^Y40(d30gtZ0bUi06AL10D9102g70+M70(#80+q80P3*jA#80{z80',
  ']N6[6m6m6m6m6Gn1O6m6W6W6G6W6v186GM8688sGcGUGGEGk]1F3OE8-2md4A570@3%5718}2H9lBm#1Xyf2o]20}1u62cW0F1v6N1O6zIi081s868EG68s8E8EGcu8E8UGEw^60-41293N3v!H1f1U9AO11G6e6O88m11X186IWZ072f9E',
  '%8N2%96$uH4H3u:9M%CF28718M868UO?86G68E8868GHOeP1SPE8GW11OO6918Of26868886OV3WU%2Wg|70EO6',
  '1uH1WGeE11G6GO8G868s',
  'HZ6uP268691s15P361Jd1oQ7068H8cHw!Y?20kAZW0sH26P1l6:BU',
  'HF8WWO8:A6116v5H6!P3E%KcA170!nR6vtM8E8?86GUGE8O8M8E86W8.U12-2Qd40HBMvE,et8:2Qtq0kg710N2mN2'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EUROPEAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_ARMENIAN,
  goog.i18n.CharPickerData.MSG_CP_CYRILLIC,
  goog.i18n.CharPickerData.MSG_CP_GEORGIAN,
  goog.i18n.CharPickerData.MSG_CP_GREEK,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_COPTIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CYPRIOT,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CYRILLIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GEORGIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GLAGOLITIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GOTHIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GREEK,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_LINEAR_B,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OGHAM,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OLD_ITALIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_RUNIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SHAVIAN,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ARMENIAN,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GREEK
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EUROPEAN_SCRIPTS = [
  '(W10V3[V32Bg0l3zIg0k%36QEg0s',
  '2510#B$7E4uHfWE',
  'Id40@2mML230Y230',
  ']]8E88#18@3P3$wC70@1GcGV3GcGs8888l1888888O#48U8eE8E88OEOUeE8k8eE8E88{l706W',
  'Q210F12$A0NAuk',
  '^-+0cG8@386OG',
  '^G106g^A0-2o,V0-2Gl1$d2',
  ';Y40V3]3cW2a70V3',
  '^tB0F48F4',
  '^l*0V2',
  ']@MG6OEX7EO71f18GU8E;{(0#6YBt0N6',
  '(z)0|8N28t1868N1GF1937B',
  'o_50l2',
  'oh*0#28M',
  'g|50N7',
  'A;*0N4',
  'oe10g^$0U',
  'XG%$e68%6Ef26OoN70888888n58Uu88EOu8EOu8E.886:Q'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AMERICAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_CANADIAN_ABORIGINAL,
  goog.i18n.CharPickerData.MSG_CP_CHEROKEE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_DESERET
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_AMERICAN_SCRIPTS = [
  'gP50NuGd1]oN6TR10Xu6',
  'wG50t7',
  ';(*0F7'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AFRICAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_ETHIOPIC,
  goog.i18n.CharPickerData.MSG_CP_NKO,
  goog.i18n.CharPickerData.MSG_CP_TIFINAGH,
  goog.i18n.CharPickerData.MSG_CP_VAI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_NKO,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OSMANYA
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_AFRICAN_SCRIPTS = [
  ';(40l68MGk88MGt38MG@28MGk88MGN18758MG}5X3V1w<60}1.k8k8k8k8k8k8k8kr070t2%1,',
  'I520t2i3,13V1',
  'o_B0-4.',
  '^th0NOWV1[6*2Mf1,',
  '^720E',
  'g?*0t2G,'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MIDDLE_EASTERN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_ARABIC,
  goog.i18n.CharPickerData.MSG_CP_HEBREW,
  goog.i18n.CharPickerData.MSG_CP_THAANA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ARABIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CARIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CUNEIFORM,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HEBREW,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_LYCIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_LYDIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OLD_PERSIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_PHOENICIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SYRIAC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_UGARITIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ARABIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HEBREW
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_MIDDLE_EASTERN_SCRIPTS = [
  'os10N2m,f3MW-18F68H26[EGP774g7g0N6oDN05!%0MGN1mG6]2[#18F1G19f2,O62t606IwZ0l1oUR0#25W40',
  'Il10V2eE`5#1P46o:$0',
  'g|10V311KcP1O:5,%S?',
  'gr10c]2UH46%2f6k8V19D6',
  ';Y*0V4',
  'gE=0-@HD@8H1M',
  'gf10#2:1M;>$0!f3',
  '^V*0l2',
  'AA,0N2e',
  'Aw*0F3WF1',
  'I7,0d2O',
  'wq10P1O]2[?X21DF18V5GE',
  'It*0t28',
  'I!10MA($0-813@Wv1#5G-4v371fAE88FC',
  '2a(08.F18U886868!'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTH_ASIAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_BENGALI,
  goog.i18n.CharPickerData.MSG_CP_DEVANAGARI,
  goog.i18n.CharPickerData.MSG_CP_GUJARATI,
  goog.i18n.CharPickerData.MSG_CP_GURMUKHI,
  goog.i18n.CharPickerData.MSG_CP_KANNADA,
  goog.i18n.CharPickerData.MSG_CP_LEPCHA,
  goog.i18n.CharPickerData.MSG_CP_LIMBU,
  goog.i18n.CharPickerData.MSG_CP_MALAYALAM,
  goog.i18n.CharPickerData.MSG_CP_OL_CHIKI,
  goog.i18n.CharPickerData.MSG_CP_ORIYA,
  goog.i18n.CharPickerData.MSG_CP_SAURASHTRA,
  goog.i18n.CharPickerData.MSG_CP_SINHALA,
  goog.i18n.CharPickerData.MSG_CP_TAMIL,
  goog.i18n.CharPickerData.MSG_CP_TELUGU,
  goog.i18n.CharPickerData.MSG_CP_TIBETAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KANNADA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KHAROSHTHI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_PHAGS_PA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SYLOTI_NAGRI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BENGALI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_DEVANAGARI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GURMUKHI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ORIYA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TIBETAN
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_SOUTH_ASIAN_SCRIPTS = [
  'gj20sG6G@18k8OMOf1n16P16*C6f2E958kG6GE.[6G,G,:*6g4506',
  '(X20-4Ov1X16f1mk(Eg0cODRg0M958d1GU91V1X]6g4506IGa0l1mE',
  '(*20!8E8@18k868UOv1X16y8E958s8E8E:16G,8fk6g4506',
  'Av20cW6G@18k8GG693]1EyO69EE958UW6GEO:1|O%v6g4506',
  'QR30s8E8}18,8UO936q86958k8E8Mu6116G,86g4506',
  'oZ70F3%3E=3#1ON1',
  '(r60l2O|W|WO|',
  '^c30s8E8}18V1O936H2cSB6P5k8E8M.[6GV1OI[406',
  '(h70t2i3,%2s',
  'Y[20sG6G@18k868UO13EX1yl6XbE958kG6GE$6[6G?]Y6g4506',
  'oni0d4q46n4d1.|',
  'oo30l1O728!8GkC66X6Wc88sv1E2+406',
  ';3308cOE8MO6886O6OEO|1247X5UOE8M.P1-1',
  'wF30s8E8}18,8UOX26m6y8EP5k8E8Mu6116G,$sPA6g4506',
  '2{30%5E8M8M8M8M8M8|8Ef2MiC?8l4f468ek8c$E8M8M8M8M8M8|8E8N18k(i806e,Gs',
  '(u70M8M5f30M',
  'YZ30',
  'gU,0M86es8E8V2WEW!$!',
  'wU6068AU606e,Gs2*V0}4w|M0M',
  '(bi0@3',
  'Yr2068',
  'Yf20s',
  'Qz20G93EG',
  'Q0306',
  'A|30]4.WWW91.868$n1.WWW91YX#0M'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTHEAST_ASIAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_BALINESE,
  goog.i18n.CharPickerData.MSG_CP_CHAM,
  goog.i18n.CharPickerData.MSG_CP_KAYAH_LI,
  goog.i18n.CharPickerData.MSG_CP_KHMER,
  goog.i18n.CharPickerData.MSG_CP_LAO,
  goog.i18n.CharPickerData.MSG_CP_MYANMAR,
  goog.i18n.CharPickerData.MSG_CP_NEW_TAI_LUE,
  goog.i18n.CharPickerData.MSG_CP_TAI_LE,
  goog.i18n.CharPickerData.MSG_CP_THAI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BUGINESE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BUHID,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HANUNOO,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KHMER,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_REJANG,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SUNDANESE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TAGALOG,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TAGBANWA
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_SOUTHEAST_ASIAN_SCRIPTS = [
  '(C70F4n1k*6UP4d111}3',
  'Q`i0t392E8s43F191$6G,GM',
  '^zi0d2S3,n2,',
  ';I6073GE8?v3q3l28,W,m,Hi-2',
  'g:3068G68GmM8k8E88G68M86.GU926`3Gc86.8cG,',
  'QK40-3:1f1cWMOO6uEW7191(xe0V18cOD-e0#18V1mMWE8EGkOMH1|8d1wxe0mE8',
  'Y%60@3]1k42d1u6m?O6',
  '2z60t2GU',
  ';z30N48691c*1Gk11@1',
  '2>60d2G6',
  '2C606.#1',
  'AA60}1',
  'gM60v311',
  'Y%i0F311',
  '^N70-3O|',
  'I760718k]26',
  '2C606%3718E86'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HANGUL = [
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  '\u1100',
  '\u1102',
  '\u1103',
  '\u1105',
  '\u1106',
  '\u1107',
  '\u1109',
  '\u110B',
  '\u110C',
  '\u110E',
  '\u110F',
  '\u1110',
  '\u1111',
  '\u1112',
  '\u1159',
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HANGUL = [
  'ozC0:42Pi0}1WV4Lbi0MO,8F1H1EmeEPqQ?r06',
  ';gj0}}-I',
  '(zk0Vr',
  '(+i0MAj20}}-I',
  'A,i0?2#30Vr',
  'A-i0EIS40Vr',
  'Y-i0EY]40}}-I',
  'w-i0IC60}}-I',
  '(-i06^U70Vr',
  '^-i0Q`70}}-I',
  'I}r0Vr',
  'wqs0Vr',
  '2.i02YA0Vr',
  'A.i0Y}A0Vr',
  'I.i0(qB0Vr',
  'Q.i0',
  'oh40FN^L80d8',
  'oJD0#2]5#2IGs0MX5#2OcGcGcGE'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EAST_ASIAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_BOPOMOFO,
  goog.i18n.CharPickerData.MSG_CP_HIRAGANA,
  goog.i18n.CharPickerData.MSG_CP_KATAKANA,
  goog.i18n.CharPickerData.MSG_CP_MONGOLIAN,
  goog.i18n.CharPickerData.MSG_CP_YI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BOPOMOFO,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HIRAGANA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KATAKANA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_YI
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EAST_ASIAN_SCRIPTS = [
  'ozC0:4HIt3XA72IQv0l2{z+06I]B0MO,8F1.MGmeE2#v0EjK306',
  'ozC0:4W#7iDMOF2X1c8eE986G68H86XD6^Bs061R946',
  'ozC0:49978PMV1SkMOF2X1c8eE986eH8MHD6^Bs061R946',
  'YX60738t4$t38aFN18,%3H9',
  'oRg0-18}}-FL.U06e,Gs^rT0IG10@4',
  'Ql)0M',
  '^%C0996G1MF1gas0U2E$0',
  '^%C0996]8PDF1vRF48@7g`r0N18}3',
  'Ql)0M'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_1_STROKE_RADICALS = [
  '\u4E00',
  '\u4E28',
  '\u4E36',
  '\u4E3F',
  '\u4E59',
  '\u4E85',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_1_STROKE_RADICALS = [
  'ItK071]BYL10TX10kOJE8F192426',
  ';wK0M8!',
  'AyK0Ef1a1M8',
  '^yK0,8E2y30{x30|',
  'Q#K0U^iL0>iL0EG}2',
  'Q)K0k',
  '(bC0c]R]q8O8f2Eoeq0]116$f7fG;(k1E',
  'A(D0t3(rX1V288k8!8k8868|8l188U8718M8N48E88GE8#48MG@3oA20]G2P60;QB0]9^(20^7L0t2'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_2_STROKE_RADICALS = [
  '\u4E8C',
  '\u4EA0',
  '\u4EBA',
  '\u513F',
  '\u5165',
  '\u516B',
  '\u5182',
  '\u5196',
  '\u51AB',
  '\u51E0',
  '\u51F5',
  '\u5200',
  '\u529B',
  '\u52F9',
  '\u5315',
  '\u531A',
  '\u5338',
  '\u5341',
  '\u535C',
  '\u5369',
  '\u5382',
  '\u53B6',
  '\u53C8',
  '\u8BA0',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_2_STROKE_RADICALS = [
  '^)K0M8N1',
  '(+K0N2',
  'A.K0VA15`4@48l6AGL05GL0VT86GZG68d39141|8t1',
  '(gL0V3',
  'IkL0MY870T8706',
  '(kL0,gzK0bzK0U838c',
  ';mL0#1Yw50',
  'woL0-1',
  'oqL0#4',
  'YvL0-1',
  'QxL0?',
  'QyL0d98sWC1$M8F3',
  'Y;L0V58@2',
  '^^L0d2',
  'g{L0U',
  '^{L0l12KK0{JK0|',
  'w0M0!',
  'g1M0E8c838,(HK0zHK0U',
  '^3M071',
  'A5M0F2',
  'Y7M0t2;ZD0+ZD0MeZU8|',
  'ACM0l1',
  '(DM0V2IS10',
  'Y]a0tD',
  'QcC0}1%P8]qG688P1W6G6mO8;fq0f1E9386H18e11Ee[n16[91e11.G$H1n18611$X2cX5kg(k1F28d292%B6f6%A15P1O',
  ';+D0tN8l49H2i40kQRl0(Q+0uH3v1H788]9@18}2872Gk8E8|8s88E8G-18778@28lF8-6G,8@48#486GF28d28t18t48N3874868-78F58V18}28F48l48lG868d18N18#18!8FN8@98FP8s8}F8N28,8VG8F18tF8}2(s30%U;@101bI-50QE60^{40;X60IhB0}Oo_20d3'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_3_STROKE_RADICALS = [
  '\u53E3',
  '\u56D7',
  '\u571F',
  '\u58EB',
  '\u5902',
  '\u590A',
  '\u5915',
  '\u5927',
  '\u5973',
  '\u5B50',
  '\u5B80',
  '\u5BF8',
  '\u5C0F',
  '\u5C22',
  '\u5C38',
  '\u5C6E',
  '\u5C71',
  '\u5DDB',
  '\u5DE5',
  '\u5DF1',
  '\u5DFE',
  '\u5E72',
  '\u5E7A',
  '\u5E7F',
  '\u5EF4',
  '\u5EFE',
  '\u5F0B',
  '\u5F13',
  '\u5F50',
  '\u5F61',
  '\u5F73',
  '\u7E9F',
  '\u95E8',
  '\u98DE',
  '\u9963',
  '\u9A6C',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_3_STROKE_RADICALS = [
  'IGM0@X8U8?8F1=2n1P1t18V4HCyGf4t8Gk%38y46ul28?888s12`1@18#2f3a3V38,$xkGBGs',
  '^`M0c^MJ0>MJ0F4OJE8N1',
  'g3N0EAHJ05HJ0VDH2C2728V28-3=3]3d38U8U_eel88F32(I0{%I0?;%I0+%I0!8!',
  'QjN0!iXnXF1',
  'YlN0k',
  'AmN0EJOU838',
  'AnN0l1',
  '(oN0738|4191d2',
  'wvN0N28t6y6%6#18}18Mi2n2738s$i1$s8V78#2:2y5:2#28d7n1i1d18M8MRWl1',
  '2DO0@283871',
  'YHO0t1;260+260#18MRW#3:1*1#1871',
  'QSO0?OJE8s',
  'YUO0k2?H0{>H0|',
  'AWO0@1',
  'AYO08t4',
  '2dO0E',
  'QdO0D#30I#30V28}44595@B8t1y1%1V88kpu?86BGU838E',
  'I.O0c8E',
  'A:O0|',
  'I;O071',
  'Y<O0t68kp$!838@1',
  '^{O0s',
  '2$K0oM40U',
  'A}O0@1OJE8-3mZU86x$@2I8H0D8H0c',
  '(9P0,',
  'wAP071',
  ';BP0s',
  'oCP0d5',
  'AIP0d1',
  'wJP0!8s',
  'QLP0!Y0H06b0H0l1mhc8U8,<[7186BGF1',
  '(gX071[<,8dB',
  'wud0t4',
  'obe0',
  'wne0V386BG,',
  '(:e0V5',
  'YeC0#2P=11Wm11686W(dq0G86:1mP26m6%1me%1E11X1OmEf1692Ge6H1%1Gm8GX3kX4[F1A,k1}18l58E8EGMP8:5]6]9',
  'YAE0@G8V(I!20|I!10E:5fX18EA8k08QQ+0%1u8Gn3v11B1693P2uO91$8OH2H713vMXG%1%K:6]SG13%2H@vX93tU8F587w8}V8-68tA8dO8db8V38758V28t58F18k8#C8t!8V78V98tU8lT8de8}}V98lB8}B8#387987H8#38NJ8@78U8N18U8kgE10(L10v_X4ngA6109Nn2v2Ac101O1}HSQ*1094^.50N2:BP6Ay10Q<40]5;s20AE20V1H9^j20l1%g-3YY20YU10}zAv10@2;310F1]E72X3}1'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_4_STROKE_RADICALS = [
  '\u5FC3',
  '\u6208',
  '\u6236',
  '\u624B',
  '\u652F',
  '\u6534',
  '\u6587',
  '\u6597',
  '\u65A4',
  '\u65B9',
  '\u65E0',
  '\u65E5',
  '\u66F0',
  '\u6708',
  '\u6728',
  '\u6B20',
  '\u6B62',
  '\u6B79',
  '\u6BB3',
  '\u6BCB',
  '\u6BD4',
  '\u6BDB',
  '\u6C0F',
  '\u6C14',
  '\u6C34',
  '\u706B',
  '\u722A',
  '\u7236',
  '\u723B',
  '\u723F',
  '\u7247',
  '\u7259',
  '\u725B',
  '\u72AC',
  '\u89C1',
  '\u8D1D',
  '\u8F66',
  '\u97E6',
  '\u98CE',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_4_STROKE_RADICALS = [
  'oSP0NW]5=5-58M8V2a2f2d48F2K2P2l4',
  'Y]P072mhc8!838838',
  'o{P0-1',
  'g}P0E2LG0{KG08kpus871C1H1?8}34494NO8?_11k8#5]6=6-38F24C9Ck8E874G*7P3H468l411_?8t28|4191#2838l186BGk',
  '((Q0U',
  'I)Q0F2rI40wI40t2GB68@12dA0{cA0E',
  '(;Q0(OF0zOF0N1',
  'I=Q071',
  'Y>Q0-1',
  'Q@Q0F1OJE8-1',
  ';^Q0U',
  'Q_Q0NA(+60j_B0(D50t1XDSDN2H1C1718V523F0{2F0,GB68-1',
  'oJR0!8rS50gS5086868k',
  '(LR0V2;070+070U',
  'wOR0@59242}187LAuE05uE0#H2R10{Q10F886uOK1Gk8E8l6uH6=6k8768Ev4P1`5l48F18NAW8hM88!8F1m=1P1c8t1',
  '2TS0E838d5',
  '2ZS0I:D0D:D0@1',
  'AbS0F5',
  'YgS072',
  'oiS0!',
  'YjS0k',
  '2kS0t4',
  '(oS0U',
  'IpS0-2',
  'AsS06WRM8VE8N28!K3P3F18s8t5i6$%5}58V1a1f1}78#1G98KA:168}7872v5v1S7l5G718E8|v3a6H1f1-28k8t38V1`5f4f1d48728Mn4`4Wd48EG*7n768d28@2`213758-1=1]1k',
  'I$T0!%1y1t18tC8MRWl39444}38,838#291(350>450|8N1g^B0nI12DFC0t78Em<Oc8#1',
  ';GU0,jW70oW706',
  '^HU0U',
  'YIU0M',
  'IxK0gl90s',
  'gJU0l1',
  'ALU06',
  'QLU0N3838#3',
  'wSU0tA$6)sGF1un1K2k868chuk86<[74',
  ';ba0U8?',
  '2Sb0V6',
  'I]b0#4',
  '2Fe0k',
  'Aae0k838M',
  '^SC0HE}2::MGEG.Ogeq0G$mEm6OGOEWE%1eE916Ou6m868W$6m6GU11OE8W91WEWGMmOG6eM$8e6W6mG611Of371136P2}18EH4M(!k1:8e#4G6G-28}2871]7$6',
  '^aE0]uFq8#@^U20U%LEY`k06AW+0f7HLfkX2vCH4vM(a10gv10IO10Yg30Hz}}VE8to8-w8@J8-28tK8td8N48FC8E8l68cGNM8V#8#98lK8-A8-A8|8728E8l287N8}}#E8@N8V%8tC88V88-88lC8N18@48t38l`;Y20(>101dYk201)XQ6nUv^Xao940kAi10cv3QF40UHdXG|fe8o^40}}l3YD10c]Ak]7@19YcX4U'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_5_STROKE_RADICALS = [
  '\u7384',
  '\u7389',
  '\u74DC',
  '\u74E6',
  '\u7518',
  '\u751F',
  '\u7528',
  '\u7530',
  '\u758B',
  '\u7592',
  '\u7676',
  '\u767D',
  '\u76AE',
  '\u76BF',
  '\u76EE',
  '\u77DB',
  '\u77E2',
  '\u77F3',
  '\u793A',
  '\u79B8',
  '\u79BE',
  '\u7A74',
  '\u7ACB',
  '\u9485',
  '\u957F',
  '\u9E1F',
  '\u9F99',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_5_STROKE_RADICALS = [
  'QmU0U',
  '(mU0838N912`1M8d18,i2n2,8t2y2%2F78Wh8M8F186BG@4',
  'o@U0,',
  'g[U0d4',
  '2{U0k',
  'w{U0!',
  'g|U0s',
  'I}U0?838738k8mhcG!).V1',
  'g7V0k',
  'A8V0t2[<,8d8muK1c8k872[<,8}1838l1',
  ';SV0k',
  'gTV0|=Q]QN3',
  '^XV0s^;A0>;A0!',
  'gZV0N2GB68l1',
  '(dV0t5v1q1l1G38V1IzA0DzA0N18|4191V98EJO',
  'QzV0k',
  '^zV0d1',
  'g#V0N15]20A]20FB8t2%1i4%2t18!upk872Gu<68k8t7',
  'I5W0-1IV40^-50DFA0}18!).!11^L40{M40?8-3Q6A0L6A0s',
  'wGW0c((20',
  'IHW0-5upk8}312`1-1Gs).t2GB6',
  '(XW0-7',
  'wfW0#1G?Qj70Lj70686BGs',
  'YOd0@L',
  'Ald0',
  ';-f0758MRW72',
  'IIg0E',
  'QkC0}1n.O86n1;eq0$f2u6[P1[68$$P1P16926u[[E91$6.u:2UH4|f6O|11X1[Ew`k1V18V3',
  'AoG0@:;12071n^kXD6I4R1:4WnB9d[15:49lHkX.1pP5Hw]nf]^H20()109d;u101@]2%KY!10:9f.;(307k8dL8}38@88-98?8V?WdA8}S87Q8748l!8-T8#d8d28lI8FK8#12@30nQI,10w^402B20F22,50-1AQ30}b(F10V49f}3]3'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_6_STROKE_RADICALS = [
  '\u7AF9',
  '\u7C73',
  '\u7CF8',
  '\u7F36',
  '\u7F51',
  '\u7F8A',
  '\u7FBD',
  '\u8001',
  '\u800C',
  '\u8012',
  '\u8033',
  '\u807F',
  '\u8089',
  '\u81E3',
  '\u81EA',
  '\u81F3',
  '\u81FC',
  '\u820C',
  '\u821B',
  '\u821F',
  '\u826E',
  '\u8272',
  '\u8278',
  '\u864D',
  '\u866B',
  '\u8840',
  '\u884C',
  '\u8863',
  '\u897E',
  '\u9875',
  '\u9F50',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_6_STROKE_RADICALS = [
  ';jW0?8F5K5P5@5%5y5t58s8,<[d213OS3@28E8F5e6hUGl1838s',
  'I[W0Mr990w990V2r?10w?10|eZU8l1[<,8}2eZU8s838U',
  'Q4X0@88d2i2n2F3%4y4t48686BGNA8686Ze728.a3X28!8}3',
  'guX0U838#1',
  '^wX0t2OJE8}1',
  'A$X0?8MLI20;H20W73',
  '(*X0F5eZU8M',
  '^;X0?',
  '^<X0c',
  'g=X0@2',
  'g@X0}211_?8718UZe?',
  'Y|X0,',
  'Q}X0}8n2i2d28N7bN90gN90l68V486BG,',
  '(UY0k',
  'YVY0!',
  'IWY0!',
  '2XY0,86BGE',
  'gYY0N1',
  ';ZY0M',
  'IaY077',
  'YhY0M',
  '(hY0c',
  'QiY0EY$70T$70768V11AiBf1@58EJOk8U8N28#18d2a7e]6d58V1(a70bk70v9t9H4(L70Lb70HBE8#38t88@3838lH8E8o=605>60O8N3P7K7N28kpud286H1a1G7188|8cI(60+(60m-1',
  'gjZ0EDPA0IPA06872',
  'ImZ0l28}283873a6f6c8t2y2%273%1X2C4t18N28d48k%8a9ut39444t3H4C4M8!8#1H2C2?8|8@1X1S1N18?',
  ';2a0|',
  '^3a0}1',
  '26a06DVE0IVE0t6838#48t2y2%274838d1P1K1F18w^50r^50l2>YD0^YD06$xs',
  '(Va071',
  '2Se0l4',
  'oBg06',
  'YmC0l2IPr0MemO68691Em6e6.6GO6n1Oem6P268me$6n19112Eue86WWW:168:4?v6G?%2^,k1Wn56XC-28U86G68M8@4',
  'o5E0oq10;%10VE8VH91l;P^(ok08wb+0Q0101Io3102E20XZoi10n>2;10XUPN18e]1;n30v6m6(L40vHvCX1:8;g10A{30HM}}N@X2#B8F68@D8VI8@(8NQG#L8#68t18tO8#v8Na8##8VC8#^8tt(j10wB30YE30E(870NF13#hfxd1'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_7_STROKE_RADICALS = [
  '\u5364',
  '\u898B',
  '\u89D2',
  '\u8A00',
  '\u8C37',
  '\u8C46',
  '\u8C55',
  '\u8C78',
  '\u8C9D',
  '\u8D64',
  '\u8D70',
  '\u8DB3',
  '\u8EAB',
  '\u8ECA',
  '\u8F9B',
  '\u8FB0',
  '\u8FB5',
  '\u9091',
  '\u9149',
  '\u91C6',
  '\u91CC',
  '\u9F9F',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_7_STROKE_RADICALS = [
  'w4M0(<J0',
  '^Wa069141!868d3',
  'Yda0,86BG@1QC50LC50?',
  'oha0lC]1wp50rr50-18F5P1K1F18@88N12Y50bZ50X1}5',
  'A7b0N1',
  'g8b0N1',
  ';9b0@283',
  '2Db0N3',
  'YGb0}88V2',
  'gYb0|',
  'oZb0cw-40r-40d5',
  'wfb0!8}212C593@18#48M[S1W,8}3mn1C2c8d18d386B',
  'I$b0#2',
  '2)b0738V1Aa40rb40f1772V40{U40F2',
  '2|b0-1',
  '^}b0U',
  'Y0c0!TGD0YGD0}29141|8}B8OZ8E8U.)!OB68k',
  'YKc0-5838-9838c',
  'Abc0NB',
  'gmc0c',
  '2nc0U',
  '(Ig0',
  'oaC0XE#1X*en1Ydq086X1ev1[.mn1Gn18116P1[8m]111%1n1v1[G92G6P5kX7|v1o5l1n5F18E8!',
  'QAE0gj40lFu-8etLO#D2.k06(T,0PL9,AY30v9]_A^60Yl10;N50Az10oi10(I80F`8M8V58Nh8lCu}}}hml3Glb8N@;820o{80|m-3n3V3u-712#9nwv3'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_8_STROKE_RADICALS = [
  '\u91D1',
  '\u9577',
  '\u9580',
  '\u961C',
  '\u96B6',
  '\u96B9',
  '\u96E8',
  '\u9751',
  '\u975E',
  '\u9C7C',
  '\u9F7F',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_8_STROKE_RADICALS = [
  'gnc0@3zLA0(LA0-AX2Yf30+h30k8l18N94B9BV48t28QO30LR30%28t88@12E305G3012l4mh8M8F4y4%4@3v1q1l18l2',
  'Ykd0s',
  'Ild0@48?_11N3',
  'Yzd0l58N1S1X1-6',
  'Y<d0E',
  'w<d0F4',
  '^@d0d9',
  'g1e071',
  'w2e0M',
  '(Xf0@5871C1H1F2',
  ';Fg0F1',
  ';qC0!:(Ihq094m.uu14:1]1EWH191$H1m92v1:6X8MYzk1vf7186',
  'QTJ0l8H1F4OV68-5:ss2?j0E2W+0AQ50Q>U0#88@yP2dcf1798N#8FJQn30@1^;106;y30l8f4@1P1N61OV39B!'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_9_STROKE_RADICALS = [
  '\u9762',
  '\u9769',
  '\u97CB',
  '\u97ED',
  '\u97F3',
  '\u9801',
  '\u98A8',
  '\u98DB',
  '\u98DF',
  '\u9996',
  '\u9999',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_9_STROKE_RADICALS = [
  '23e0k',
  'w3e0-8',
  'oCe0V18MRWc',
  'wFe0c',
  'IGe0zy706wy7071',
  'gHe0t1eZU8,Gkx6ud18|4191#3',
  'wWe0V3',
  'Qbe0E',
  'wbe0V28UZeN2OJE872838-3',
  'Qse0E',
  'ose0t1',
  'wrC0?f)2vq0f298Ef56n8MIGl1N1',
  'ooH0g520-Q8!IHS1:_P32-30ARC0YA40](^b70gd807Y8lBelaW728NG91}Zv1t288-4Iz70d1mt1n1|el1H2N1'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_10_STROKE_RADICALS = [
  '\u99AC',
  '\u9AA8',
  '\u9AD8',
  '\u9ADF',
  '\u9B25',
  '\u9B2F',
  '\u9B32',
  '\u9B3C',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_10_STROKE_RADICALS = [
  'Que0V68V1a1f176ob10jb10-2(Y10zY10M',
  'I@e0N4',
  'o_e0k',
  'I`e0l211_?8d1WRM8k',
  'o2f0,',
  'g3f0E',
  '(3f0,',
  'w4f0t2',
  'wsC0s;Lr0:9nTgHl1U',
  '^_J077O#9wM(1gQ10#Y]3};gl60@192l2'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_11_17_STROKE_RADICALS = [
  '\u9B5A',
  '\u9CE5',
  '\u9E75',
  '\u9E7F',
  '\u9EA5',
  '\u9EA6',
  '\u9EBB',
  '\u9EC3',
  '\u9ECD',
  '\u9ED1',
  '\u9EF9',
  '\u9EFD',
  '\u9EFE',
  '\u9F0E',
  '\u9F13',
  '\u9F20',
  '\u9F3B',
  '\u9F4A',
  '\u9F52',
  '\u9F8D',
  '\u9F9C',
  '\u9FA0',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_11_17_STROKE_RADICALS = [
  'Y7f0-2IB10DB10#2[<,8d1eZU8F2%3y3}2eZU88t2WRM8l31b`a#28EJOV1',
  'Qhf0N38MRWt78]s=s#3838758MRWV18728EJO}2',
  'w@f0!',
  'o[f0V3',
  '2`f08d1',
  'A`f0n1E',
  '2|f0s',
  '(|f0,',
  'w}f0M',
  '20g06>mI0^mI0c8#2',
  'w3g0M',
  '24g08|',
  'A4g091E',
  'o5g0U',
  '26g071',
  'I7g0V2',
  'w9g0N1',
  '2Bg0c',
  '(Bg0}3',
  'AHg0E8s',
  'gIg0E',
  ';Ig0c',
  'YtC0#1QIr0692H26ef66P5946H5nE.6Q,k1fYt1',
  'IDK0t9$@9uNDGkoOR1fk^x102.20nDQf301=^N50;g202j30M^>90od80g320to12t!]1-H8F[GN6284075f3@394E8l2.G'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_OTHER = [
  goog.i18n.CharPickerData.MSG_CP_NUMERICS,
  goog.i18n.CharPickerData.MSG_CP_PUNCTUATION,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_NUMERICS,
  goog.i18n.CharPickerData.MSG_CP_PINYIN,
  goog.i18n.CharPickerData.MSG_CP_IDEOGRAPHIC_DESCRIPTION,
  goog.i18n.CharPickerData.MSG_CP_CJK_STROKES
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_OTHER = [
    'ItK0GO8n7H4u8v36%2$P3]8va]59388:DnS8Em:6v3MH6n%fmuX4oZ10]B691E8PEn.X417IH10Q710H.AI10n)Yv20%j1d^L20WPB2W20P3e]3XBT(d0112T808YG40', /* numerics */
    'ozC0:4>nC0]l8w%70886G6%m^u30U8?8V2GmO8Ewgs06', /* punctuation */
    'HF;S8091:IIk40F3PB|%CF2[U%8#2oyr06868EG8116Of28GX2MGMHB6O', /* compatibility */
    'o(D0XB]`].o#V1]8XBv5^A2018$X1PUv1f2Qf60Qq10gt402ZA0', /* less common */
    'PK6mE86W6e68Wn1uX113v2]88888888', /* pinyin */
    'oxC0|', /* ideo desc */
    'AQC0N28M8d7H%F3' /* strokes */
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MISCELLANEOUS = [
  goog.i18n.CharPickerData.MSG_CP_ALL
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_MISCELLANEOUS = [
  'o070><400V1*10%12#g0q40E1u^vQ0K506L[Q08LEc00s+:400F1Q#g0+;b00Eo;b00nnowQ005LR00UO0EA0P09)0U;d100{^Q00{Cc00ce0Y=b00o%P0Ae100{6%0o<b0fOL6h00}1G0YOh00N2$0kS10k[;qQ00}2eZ0M8071{2R00l588H20TOc00cf40i40#1%20*20,H1C10Um92`106W06i10UP1[<0sO0OJ06ZC1I<b00V3%1y10v1q10U8uh0EOJ0h[g|P00d6*T0#4**0-1:)0-1[0l1ww900@}0F9'
];


/**
 * Subcategory names. Each subarray in this array is a list of subcategory
 * names for the corresponding category specified in
 * {@code goog.i18n.CharPickerData.categories}.
 * @type {Array.<Array.<string>>}
 */
goog.i18n.CharPickerData.prototype.subcategories = [
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SYMBOL,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_PUNCTUATION,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_NUMBER,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_FORMAT_WHITESPACE,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MODIFIER,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_LATIN,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EUROPEAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AMERICAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AFRICAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MIDDLE_EASTERN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTH_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTHEAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HANGUL,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_1_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_2_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_3_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_4_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_5_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_6_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_7_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_8_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_9_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_10_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_11_17_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_OTHER,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MISCELLANEOUS
];


/**
 * Character lists in base88 encoding scheme. Each subarray is a list of
 * base88 encoded charater strings representing corresponding subcategory
 * specified in {@code goog.i18n.CharPickerData.categories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<Array.<string>>}
 */
goog.i18n.CharPickerData.prototype.charList = [
  goog.i18n.CharPickerData.CHARLIST_OF_SYMBOL,
  goog.i18n.CharPickerData.CHARLIST_OF_PUNCTUATION,
  goog.i18n.CharPickerData.CHARLIST_OF_NUMBER,
  goog.i18n.CharPickerData.CHARLIST_OF_FORMAT_WHITESPACE,
  goog.i18n.CharPickerData.CHARLIST_OF_MODIFIER,
  goog.i18n.CharPickerData.CHARLIST_OF_LATIN,
  goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EUROPEAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_AMERICAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_AFRICAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_MIDDLE_EASTERN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_SOUTH_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_SOUTHEAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_HANGUL,
  goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_1_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_2_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_3_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_4_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_5_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_6_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_7_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_8_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_9_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_10_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_11_17_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_OTHER,
  goog.i18n.CharPickerData.CHARLIST_OF_MISCELLANEOUS
];
