// Copyright 2013 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview List formatting symbols for all locales.
 *
 * This file is autogenerated by script.  See
 * http://go/generate_list_symbols.py using --for_closure
 * File generated from CLDR ver. 23.0.0.0
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are usually supported by google products. It is a super
 * set of 40 languages. Rest of the data can be found in another file
 * named "listsymbolsext.js", which will be generated at the same
 * time as this file.
 * Before checkin, this file could have been manually edited. This is
 * to incorporate changes before we could correct CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes land to CLDR.
 */

goog.provide('goog.labs.i18n.ListFormatSymbols');
goog.provide('goog.labs.i18n.ListFormatSymbols_af');
goog.provide('goog.labs.i18n.ListFormatSymbols_am');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar');
goog.provide('goog.labs.i18n.ListFormatSymbols_bg');
goog.provide('goog.labs.i18n.ListFormatSymbols_bn');
goog.provide('goog.labs.i18n.ListFormatSymbols_br');
goog.provide('goog.labs.i18n.ListFormatSymbols_ca');
goog.provide('goog.labs.i18n.ListFormatSymbols_chr');
goog.provide('goog.labs.i18n.ListFormatSymbols_cs');
goog.provide('goog.labs.i18n.ListFormatSymbols_cy');
goog.provide('goog.labs.i18n.ListFormatSymbols_da');
goog.provide('goog.labs.i18n.ListFormatSymbols_de');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_AT');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_el');
goog.provide('goog.labs.i18n.ListFormatSymbols_en');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_AU');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GB');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_IE');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_ISO');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_US');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_ZA');
goog.provide('goog.labs.i18n.ListFormatSymbols_es');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_419');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_ES');
goog.provide('goog.labs.i18n.ListFormatSymbols_et');
goog.provide('goog.labs.i18n.ListFormatSymbols_eu');
goog.provide('goog.labs.i18n.ListFormatSymbols_fa');
goog.provide('goog.labs.i18n.ListFormatSymbols_fi');
goog.provide('goog.labs.i18n.ListFormatSymbols_fil');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CA');
goog.provide('goog.labs.i18n.ListFormatSymbols_gl');
goog.provide('goog.labs.i18n.ListFormatSymbols_gsw');
goog.provide('goog.labs.i18n.ListFormatSymbols_gu');
goog.provide('goog.labs.i18n.ListFormatSymbols_haw');
goog.provide('goog.labs.i18n.ListFormatSymbols_he');
goog.provide('goog.labs.i18n.ListFormatSymbols_hi');
goog.provide('goog.labs.i18n.ListFormatSymbols_hr');
goog.provide('goog.labs.i18n.ListFormatSymbols_hu');
goog.provide('goog.labs.i18n.ListFormatSymbols_id');
goog.provide('goog.labs.i18n.ListFormatSymbols_in');
goog.provide('goog.labs.i18n.ListFormatSymbols_is');
goog.provide('goog.labs.i18n.ListFormatSymbols_it');
goog.provide('goog.labs.i18n.ListFormatSymbols_iw');
goog.provide('goog.labs.i18n.ListFormatSymbols_ja');
goog.provide('goog.labs.i18n.ListFormatSymbols_kn');
goog.provide('goog.labs.i18n.ListFormatSymbols_ko');
goog.provide('goog.labs.i18n.ListFormatSymbols_ln');
goog.provide('goog.labs.i18n.ListFormatSymbols_lt');
goog.provide('goog.labs.i18n.ListFormatSymbols_lv');
goog.provide('goog.labs.i18n.ListFormatSymbols_ml');
goog.provide('goog.labs.i18n.ListFormatSymbols_mo');
goog.provide('goog.labs.i18n.ListFormatSymbols_mr');
goog.provide('goog.labs.i18n.ListFormatSymbols_ms');
goog.provide('goog.labs.i18n.ListFormatSymbols_mt');
goog.provide('goog.labs.i18n.ListFormatSymbols_nb');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl');
goog.provide('goog.labs.i18n.ListFormatSymbols_no');
goog.provide('goog.labs.i18n.ListFormatSymbols_or');
goog.provide('goog.labs.i18n.ListFormatSymbols_pl');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_BR');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_PT');
goog.provide('goog.labs.i18n.ListFormatSymbols_ro');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru');
goog.provide('goog.labs.i18n.ListFormatSymbols_sk');
goog.provide('goog.labs.i18n.ListFormatSymbols_sl');
goog.provide('goog.labs.i18n.ListFormatSymbols_sq');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr');
goog.provide('goog.labs.i18n.ListFormatSymbols_sv');
goog.provide('goog.labs.i18n.ListFormatSymbols_sw');
goog.provide('goog.labs.i18n.ListFormatSymbols_ta');
goog.provide('goog.labs.i18n.ListFormatSymbols_te');
goog.provide('goog.labs.i18n.ListFormatSymbols_th');
goog.provide('goog.labs.i18n.ListFormatSymbols_tl');
goog.provide('goog.labs.i18n.ListFormatSymbols_tr');
goog.provide('goog.labs.i18n.ListFormatSymbols_uk');
goog.provide('goog.labs.i18n.ListFormatSymbols_ur');
goog.provide('goog.labs.i18n.ListFormatSymbols_vi');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_CN');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_HK');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_TW');
goog.provide('goog.labs.i18n.ListFormatSymbols_zu');


/**
 * List formatting symbols for locale af.
 */
goog.labs.i18n.ListFormatSymbols_af = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale am.
 */
goog.labs.i18n.ListFormatSymbols_am = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u12A5\u1293 {1}',
  LIST_START: '{0}\u1363 {1}',
  LIST_MIDDLE: '{0}\u1363 {1}',
  LIST_END: '{0}, \u12A5\u1293 {1}'
};


/**
 * List formatting symbols for locale ar.
 */
goog.labs.i18n.ListFormatSymbols_ar = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0648 {1}',
  LIST_START: '{0}\u060C {1}',
  LIST_MIDDLE: '{0}\u060C {1}',
  LIST_END: '{0}\u060C \u0648 {1}'
};


/**
 * List formatting symbols for locale bg.
 */
goog.labs.i18n.ListFormatSymbols_bg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0438 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0438 {1}'
};


/**
 * List formatting symbols for locale bn.
 */
goog.labs.i18n.ListFormatSymbols_bn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u098F\u09AC\u0982 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, \u098F\u09AC\u0982 {1}'
};


/**
 * List formatting symbols for locale br.
 */
goog.labs.i18n.ListFormatSymbols_br = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ca.
 */
goog.labs.i18n.ListFormatSymbols_ca = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale chr.
 */
goog.labs.i18n.ListFormatSymbols_chr = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale cs.
 */
goog.labs.i18n.ListFormatSymbols_cs = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale cy.
 */
goog.labs.i18n.ListFormatSymbols_cy = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale da.
 */
goog.labs.i18n.ListFormatSymbols_da = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale de.
 */
goog.labs.i18n.ListFormatSymbols_de = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale de_AT.
 */
goog.labs.i18n.ListFormatSymbols_de_AT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale de_CH.
 */
goog.labs.i18n.ListFormatSymbols_de_CH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale el.
 */
goog.labs.i18n.ListFormatSymbols_el = {
  GENDER_STYLE: 1,
  LIST_TWO: '{0} \u03BA\u03B1\u03B9 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u03BA\u03B1\u03B9 {1}'
};


/**
 * List formatting symbols for locale en.
 */
goog.labs.i18n.ListFormatSymbols_en = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_AU.
 */
goog.labs.i18n.ListFormatSymbols_en_AU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} and {1}'
};


/**
 * List formatting symbols for locale en_GB.
 */
goog.labs.i18n.ListFormatSymbols_en_GB = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} and {1}'
};


/**
 * List formatting symbols for locale en_IE.
 */
goog.labs.i18n.ListFormatSymbols_en_IE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} and {1}'
};


/**
 * List formatting symbols for locale en_IN.
 */
goog.labs.i18n.ListFormatSymbols_en_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} and {1}'
};


/**
 * List formatting symbols for locale en_ISO.
 */
goog.labs.i18n.ListFormatSymbols_en_ISO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SG.
 */
goog.labs.i18n.ListFormatSymbols_en_SG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} and {1}'
};


/**
 * List formatting symbols for locale en_US.
 */
goog.labs.i18n.ListFormatSymbols_en_US = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_ZA.
 */
goog.labs.i18n.ListFormatSymbols_en_ZA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale es.
 */
goog.labs.i18n.ListFormatSymbols_es = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_419.
 */
goog.labs.i18n.ListFormatSymbols_es_419 = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_ES.
 */
goog.labs.i18n.ListFormatSymbols_es_ES = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale et.
 */
goog.labs.i18n.ListFormatSymbols_et = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale eu.
 */
goog.labs.i18n.ListFormatSymbols_eu = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} eta {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} eta {1}'
};


/**
 * List formatting symbols for locale fa.
 */
goog.labs.i18n.ListFormatSymbols_fa = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0648 {1}',
  LIST_START: '{0}\u060C\u200F {1}',
  LIST_MIDDLE: '{0}\u060C\u200F {1}',
  LIST_END: '{0}\u060C \u0648 {1}'
};


/**
 * List formatting symbols for locale fi.
 */
goog.labs.i18n.ListFormatSymbols_fi = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale fil.
 */
goog.labs.i18n.ListFormatSymbols_fil = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} at {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} at {1}'
};


/**
 * List formatting symbols for locale fr.
 */
goog.labs.i18n.ListFormatSymbols_fr = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CA.
 */
goog.labs.i18n.ListFormatSymbols_fr_CA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale gl.
 */
goog.labs.i18n.ListFormatSymbols_gl = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale gsw.
 */
goog.labs.i18n.ListFormatSymbols_gsw = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale gu.
 */
goog.labs.i18n.ListFormatSymbols_gu = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0A85\u0AA8\u0AC7 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0A85\u0AA8\u0AC7 {1}'
};


/**
 * List formatting symbols for locale haw.
 */
goog.labs.i18n.ListFormatSymbols_haw = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale he.
 */
goog.labs.i18n.ListFormatSymbols_he = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u05D5{1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u05D5{1}'
};


/**
 * List formatting symbols for locale hi.
 */
goog.labs.i18n.ListFormatSymbols_hi = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0914\u0930 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, \u0914\u0930 {1}'
};


/**
 * List formatting symbols for locale hr.
 */
goog.labs.i18n.ListFormatSymbols_hr = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale hu.
 */
goog.labs.i18n.ListFormatSymbols_hu = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u00E9s {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u00E9s {1}'
};


/**
 * List formatting symbols for locale id.
 */
goog.labs.i18n.ListFormatSymbols_id = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, dan {1}'
};


/**
 * List formatting symbols for locale in.
 */
goog.labs.i18n.ListFormatSymbols_in = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, dan {1}'
};


/**
 * List formatting symbols for locale is.
 */
goog.labs.i18n.ListFormatSymbols_is = {
  GENDER_STYLE: 1,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale it.
 */
goog.labs.i18n.ListFormatSymbols_it = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, e {1}'
};


/**
 * List formatting symbols for locale iw.
 */
goog.labs.i18n.ListFormatSymbols_iw = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u05D5{1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u05D5{1}'
};


/**
 * List formatting symbols for locale ja.
 */
goog.labs.i18n.ListFormatSymbols_ja = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}\u3001{1}',
  LIST_START: '{0}\u3001{1}',
  LIST_MIDDLE: '{0}\u3001{1}',
  LIST_END: '{0}\u3001{1}'
};


/**
 * List formatting symbols for locale kn.
 */
goog.labs.i18n.ListFormatSymbols_kn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0CAE\u0CA4\u0CCD\u0CA4\u0CC1 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, \u0CAE\u0CA4\u0CCD\u0CA4\u0CC1 {1}'
};


/**
 * List formatting symbols for locale ko.
 */
goog.labs.i18n.ListFormatSymbols_ko = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \uBC0F {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \uBC0F {1}'
};


/**
 * List formatting symbols for locale ln.
 */
goog.labs.i18n.ListFormatSymbols_ln = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lt.
 */
goog.labs.i18n.ListFormatSymbols_lt = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} ir {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ir {1}'
};


/**
 * List formatting symbols for locale lv.
 */
goog.labs.i18n.ListFormatSymbols_lv = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} un {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} un {1}'
};


/**
 * List formatting symbols for locale ml.
 */
goog.labs.i18n.ListFormatSymbols_ml = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0D15\u0D42\u0D1F\u0D3E\u0D24\u0D46 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1} \u0D0E\u0D28\u0D4D\u0D28\u0D3F\u0D35'
};


/**
 * List formatting symbols for locale mo.
 */
goog.labs.i18n.ListFormatSymbols_mo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u015Fi {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u015Fi {1}'
};


/**
 * List formatting symbols for locale mr.
 */
goog.labs.i18n.ListFormatSymbols_mr = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0906\u0923\u093F {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0906\u0923\u093F {1}'
};


/**
 * List formatting symbols for locale ms.
 */
goog.labs.i18n.ListFormatSymbols_ms = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, dan {1}'
};


/**
 * List formatting symbols for locale mt.
 */
goog.labs.i18n.ListFormatSymbols_mt = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nb.
 */
goog.labs.i18n.ListFormatSymbols_nb = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale nl.
 */
goog.labs.i18n.ListFormatSymbols_nl = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale no.
 */
goog.labs.i18n.ListFormatSymbols_no = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale or.
 */
goog.labs.i18n.ListFormatSymbols_or = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale pl.
 */
goog.labs.i18n.ListFormatSymbols_pl = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale pt.
 */
goog.labs.i18n.ListFormatSymbols_pt = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_BR.
 */
goog.labs.i18n.ListFormatSymbols_pt_BR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_PT.
 */
goog.labs.i18n.ListFormatSymbols_pt_PT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale ro.
 */
goog.labs.i18n.ListFormatSymbols_ro = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u015Fi {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u015Fi {1}'
};


/**
 * List formatting symbols for locale ru.
 */
goog.labs.i18n.ListFormatSymbols_ru = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0438 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0438 {1}'
};


/**
 * List formatting symbols for locale sk.
 */
goog.labs.i18n.ListFormatSymbols_sk = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale sl.
 */
goog.labs.i18n.ListFormatSymbols_sl = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} in {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} in {1}'
};


/**
 * List formatting symbols for locale sq.
 */
goog.labs.i18n.ListFormatSymbols_sq = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sr.
 */
goog.labs.i18n.ListFormatSymbols_sr = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0438 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0438 {1}'
};


/**
 * List formatting symbols for locale sv.
 */
goog.labs.i18n.ListFormatSymbols_sv = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} och {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} och {1}'
};


/**
 * List formatting symbols for locale sw.
 */
goog.labs.i18n.ListFormatSymbols_sw = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} na {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, na {1}'
};


/**
 * List formatting symbols for locale ta.
 */
goog.labs.i18n.ListFormatSymbols_ta = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0BAE\u0BB1\u0BCD\u0BB1\u0BC1\u0BAE\u0BCD {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0BAE\u0BB1\u0BCD\u0BB1\u0BC1\u0BAE\u0BCD {1}'
};


/**
 * List formatting symbols for locale te.
 */
goog.labs.i18n.ListFormatSymbols_te = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} \u0C2E\u0C30\u0C3F\u0C2F\u0C41 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0C2E\u0C30\u0C3F\u0C2F\u0C41 {1}'
};


/**
 * List formatting symbols for locale th.
 */
goog.labs.i18n.ListFormatSymbols_th = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}\u0E41\u0E25\u0E30{1}',
  LIST_START: '{0} {1}',
  LIST_MIDDLE: '{0} {1}',
  LIST_END: '{0} \u0E41\u0E25\u0E30{1}'
};


/**
 * List formatting symbols for locale tl.
 */
goog.labs.i18n.ListFormatSymbols_tl = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} at {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} at {1}'
};


/**
 * List formatting symbols for locale tr.
 */
goog.labs.i18n.ListFormatSymbols_tr = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ve {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ve {1}'
};


/**
 * List formatting symbols for locale uk.
 */
goog.labs.i18n.ListFormatSymbols_uk = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0442\u0430 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} \u0442\u0430 {1}'
};


/**
 * List formatting symbols for locale ur.
 */
goog.labs.i18n.ListFormatSymbols_ur = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} \u0627\u0648\u0631 {1}',
  LIST_START: '{0}\u060C {1}',
  LIST_MIDDLE: '{0}\u060C {1}',
  LIST_END: '{0}\u060C \u0627\u0648\u0631 {1}'
};


/**
 * List formatting symbols for locale vi.
 */
goog.labs.i18n.ListFormatSymbols_vi = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} v\u00E0 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} v\u00E0 {1}'
};


/**
 * List formatting symbols for locale zh.
 */
goog.labs.i18n.ListFormatSymbols_zh = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}\u548C{1}',
  LIST_START: '{0}\u3001{1}',
  LIST_MIDDLE: '{0}\u3001{1}',
  LIST_END: '{0}\u548C{1}'
};


/**
 * List formatting symbols for locale zh_CN.
 */
goog.labs.i18n.ListFormatSymbols_zh_CN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}\u548C{1}',
  LIST_START: '{0}\u3001{1}',
  LIST_MIDDLE: '{0}\u3001{1}',
  LIST_END: '{0}\u548C{1}'
};


/**
 * List formatting symbols for locale zh_HK.
 */
goog.labs.i18n.ListFormatSymbols_zh_HK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}\u548C{1}',
  LIST_START: '{0}\u3001{1}',
  LIST_MIDDLE: '{0}\u3001{1}',
  LIST_END: '{0}\u548C{1}'
};


/**
 * List formatting symbols for locale zh_TW.
 */
goog.labs.i18n.ListFormatSymbols_zh_TW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}\u548C{1}',
  LIST_START: '{0}\u3001{1}',
  LIST_MIDDLE: '{0}\u3001{1}',
  LIST_END: '{0}\u548C{1}'
};


/**
 * List formatting symbols for locale zu.
 */
goog.labs.i18n.ListFormatSymbols_zu = {
  GENDER_STYLE: 0,
  LIST_TWO: 'I-{0} ne-{1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, no-{1}'
};


/**
 * Default value, in case nothing else matches
 */
goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en;


/**
 * Selecting symbols by locale.
 */
if (goog.LOCALE == 'af') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_af;
}

if (goog.LOCALE == 'am') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_am;
}

if (goog.LOCALE == 'ar') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar;
}

if (goog.LOCALE == 'bg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bg;
}

if (goog.LOCALE == 'bn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bn;
}

if (goog.LOCALE == 'br') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_br;
}

if (goog.LOCALE == 'ca') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ca;
}

if (goog.LOCALE == 'chr') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_chr;
}

if (goog.LOCALE == 'cs') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_cs;
}

if (goog.LOCALE == 'cy') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_cy;
}

if (goog.LOCALE == 'da') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_da;
}

if (goog.LOCALE == 'de') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de;
}

if (goog.LOCALE == 'de_AT' || goog.LOCALE == 'de-AT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_AT;
}

if (goog.LOCALE == 'de_CH' || goog.LOCALE == 'de-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_CH;
}

if (goog.LOCALE == 'el') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_el;
}

if (goog.LOCALE == 'en') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en;
}

if (goog.LOCALE == 'en_AU' || goog.LOCALE == 'en-AU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_AU;
}

if (goog.LOCALE == 'en_GB' || goog.LOCALE == 'en-GB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GB;
}

if (goog.LOCALE == 'en_IE' || goog.LOCALE == 'en-IE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_IE;
}

if (goog.LOCALE == 'en_IN' || goog.LOCALE == 'en-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_IN;
}

if (goog.LOCALE == 'en_ISO' || goog.LOCALE == 'en-ISO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_ISO;
}

if (goog.LOCALE == 'en_SG' || goog.LOCALE == 'en-SG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SG;
}

if (goog.LOCALE == 'en_US' || goog.LOCALE == 'en-US') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_US;
}

if (goog.LOCALE == 'en_ZA' || goog.LOCALE == 'en-ZA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_ZA;
}

if (goog.LOCALE == 'es') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es;
}

if (goog.LOCALE == 'es_419' || goog.LOCALE == 'es-419') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_419;
}

if (goog.LOCALE == 'es_ES' || goog.LOCALE == 'es-ES') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_ES;
}

if (goog.LOCALE == 'et') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_et;
}

if (goog.LOCALE == 'eu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_eu;
}

if (goog.LOCALE == 'fa') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fa;
}

if (goog.LOCALE == 'fi') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fi;
}

if (goog.LOCALE == 'fil') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fil;
}

if (goog.LOCALE == 'fr') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr;
}

if (goog.LOCALE == 'fr_CA' || goog.LOCALE == 'fr-CA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CA;
}

if (goog.LOCALE == 'gl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gl;
}

if (goog.LOCALE == 'gsw') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gsw;
}

if (goog.LOCALE == 'gu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gu;
}

if (goog.LOCALE == 'haw') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_haw;
}

if (goog.LOCALE == 'he') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_he;
}

if (goog.LOCALE == 'hi') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hi;
}

if (goog.LOCALE == 'hr') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hr;
}

if (goog.LOCALE == 'hu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hu;
}

if (goog.LOCALE == 'id') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_id;
}

if (goog.LOCALE == 'in') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_in;
}

if (goog.LOCALE == 'is') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_is;
}

if (goog.LOCALE == 'it') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_it;
}

if (goog.LOCALE == 'iw') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_iw;
}

if (goog.LOCALE == 'ja') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ja;
}

if (goog.LOCALE == 'kn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kn;
}

if (goog.LOCALE == 'ko') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ko;
}

if (goog.LOCALE == 'ln') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ln;
}

if (goog.LOCALE == 'lt') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lt;
}

if (goog.LOCALE == 'lv') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lv;
}

if (goog.LOCALE == 'ml') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ml;
}

if (goog.LOCALE == 'mo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mo;
}

if (goog.LOCALE == 'mr') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mr;
}

if (goog.LOCALE == 'ms') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ms;
}

if (goog.LOCALE == 'mt') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mt;
}

if (goog.LOCALE == 'nb') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nb;
}

if (goog.LOCALE == 'nl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl;
}

if (goog.LOCALE == 'no') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_no;
}

if (goog.LOCALE == 'or') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_or;
}

if (goog.LOCALE == 'pl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pl;
}

if (goog.LOCALE == 'pt') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt;
}

if (goog.LOCALE == 'pt_BR' || goog.LOCALE == 'pt-BR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_BR;
}

if (goog.LOCALE == 'pt_PT' || goog.LOCALE == 'pt-PT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_PT;
}

if (goog.LOCALE == 'ro') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ro;
}

if (goog.LOCALE == 'ru') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru;
}

if (goog.LOCALE == 'sk') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sk;
}

if (goog.LOCALE == 'sl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sl;
}

if (goog.LOCALE == 'sq') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sq;
}

if (goog.LOCALE == 'sr') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr;
}

if (goog.LOCALE == 'sv') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sv;
}

if (goog.LOCALE == 'sw') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sw;
}

if (goog.LOCALE == 'ta') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ta;
}

if (goog.LOCALE == 'te') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_te;
}

if (goog.LOCALE == 'th') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_th;
}

if (goog.LOCALE == 'tl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tl;
}

if (goog.LOCALE == 'tr') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tr;
}

if (goog.LOCALE == 'uk') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uk;
}

if (goog.LOCALE == 'ur') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ur;
}

if (goog.LOCALE == 'vi') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vi;
}

if (goog.LOCALE == 'zh') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh;
}

if (goog.LOCALE == 'zh_CN' || goog.LOCALE == 'zh-CN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_CN;
}

if (goog.LOCALE == 'zh_HK' || goog.LOCALE == 'zh-HK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_HK;
}

if (goog.LOCALE == 'zh_TW' || goog.LOCALE == 'zh-TW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_TW;
}

if (goog.LOCALE == 'zu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zu;
}

