// Compiled by ClojureScript 1.7.228 {}
goog.provide('nativestore.core');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('goog.array');
goog.require('derive.core');
nativestore.core.js_strkey = (function nativestore$core$js_strkey(x){
if(typeof x === 'string'){
return x;
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,x);
} else {
return [cljs.core.str(x)].join('');

}
}
});
nativestore.core.js_lookup = (function nativestore$core$js_lookup(var_args){
var args12027 = [];
var len__7198__auto___12030 = arguments.length;
var i__7199__auto___12031 = (0);
while(true){
if((i__7199__auto___12031 < len__7198__auto___12030)){
args12027.push((arguments[i__7199__auto___12031]));

var G__12032 = (i__7199__auto___12031 + (1));
i__7199__auto___12031 = G__12032;
continue;
} else {
}
break;
}

var G__12029 = args12027.length;
switch (G__12029) {
case 2:
return nativestore.core.js_lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.js_lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12027.length)].join('')));

}
});

nativestore.core.js_lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
return (o[nativestore.core.js_strkey.call(null,k)]);
});

nativestore.core.js_lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
var s = nativestore.core.js_strkey.call(null,k);
var temp__4423__auto__ = (o[s]);
if(cljs.core.truth_(temp__4423__auto__)){
var res = temp__4423__auto__;
return res;
} else {
return not_found;
}
});

nativestore.core.js_lookup.cljs$lang$maxFixedArity = 3;
nativestore.core.js_copy = (function nativestore$core$js_copy(o){
var t = goog.typeOf(o);
if(cljs.core._EQ_.call(null,t,"array")){
return goog.array.clone(o);
} else {
return goog.object.clone(o);

}
});
nativestore.core.js_assoc = (function nativestore$core$js_assoc(var_args){
var args12034 = [];
var len__7198__auto___12042 = arguments.length;
var i__7199__auto___12043 = (0);
while(true){
if((i__7199__auto___12043 < len__7198__auto___12042)){
args12034.push((arguments[i__7199__auto___12043]));

var G__12044 = (i__7199__auto___12043 + (1));
i__7199__auto___12043 = G__12044;
continue;
} else {
}
break;
}

var G__12041 = args12034.length;
switch (G__12041) {
case 3:
return nativestore.core.js_assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7217__auto__ = (new cljs.core.IndexedSeq(args12034.slice((3)),(0)));
return nativestore.core.js_assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7217__auto__);

}
});

nativestore.core.js_assoc.cljs$core$IFn$_invoke$arity$3 = (function (o,k,v){
(o[nativestore.core.js_strkey.call(null,k)] = v);

return o;
});

nativestore.core.js_assoc.cljs$core$IFn$_invoke$arity$variadic = (function (o,k,v,more){
while(true){
nativestore.core.js_assoc.call(null,o,k,v);

if(cljs.core.truth_(more)){
var G__12046 = o;
var G__12047 = cljs.core.first.call(null,more);
var G__12048 = cljs.core.second.call(null,more);
var G__12049 = cljs.core.nnext.call(null,more);
o = G__12046;
k = G__12047;
v = G__12048;
more = G__12049;
continue;
} else {
return o;
}
break;
}
});

nativestore.core.js_assoc.cljs$lang$applyTo = (function (seq12035){
var G__12036 = cljs.core.first.call(null,seq12035);
var seq12035__$1 = cljs.core.next.call(null,seq12035);
var G__12037 = cljs.core.first.call(null,seq12035__$1);
var seq12035__$2 = cljs.core.next.call(null,seq12035__$1);
var G__12038 = cljs.core.first.call(null,seq12035__$2);
var seq12035__$3 = cljs.core.next.call(null,seq12035__$2);
return nativestore.core.js_assoc.cljs$core$IFn$_invoke$arity$variadic(G__12036,G__12037,G__12038,seq12035__$3);
});

nativestore.core.js_assoc.cljs$lang$maxFixedArity = (3);
nativestore.core.js_dissoc = (function nativestore$core$js_dissoc(var_args){
var args__7205__auto__ = [];
var len__7198__auto___12053 = arguments.length;
var i__7199__auto___12054 = (0);
while(true){
if((i__7199__auto___12054 < len__7198__auto___12053)){
args__7205__auto__.push((arguments[i__7199__auto___12054]));

var G__12055 = (i__7199__auto___12054 + (1));
i__7199__auto___12054 = G__12055;
continue;
} else {
}
break;
}

var argseq__7206__auto__ = ((((2) < args__7205__auto__.length))?(new cljs.core.IndexedSeq(args__7205__auto__.slice((2)),(0))):null);
return nativestore.core.js_dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7206__auto__);
});

nativestore.core.js_dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (o,k,more){
while(true){
delete o[nativestore.core.js_strkey.call(null,k)];

if(cljs.core.truth_(more)){
var G__12056 = o;
var G__12057 = cljs.core.first.call(null,more);
var G__12058 = cljs.core.next.call(null,more);
o = G__12056;
k = G__12057;
more = G__12058;
continue;
} else {
return o;
}
break;
}
});

nativestore.core.js_dissoc.cljs$lang$maxFixedArity = (2);

nativestore.core.js_dissoc.cljs$lang$applyTo = (function (seq12050){
var G__12051 = cljs.core.first.call(null,seq12050);
var seq12050__$1 = cljs.core.next.call(null,seq12050);
var G__12052 = cljs.core.first.call(null,seq12050__$1);
var seq12050__$2 = cljs.core.next.call(null,seq12050__$1);
return nativestore.core.js_dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12051,G__12052,seq12050__$2);
});

/**
 * @interface
 */
nativestore.core.IStore = function(){};

nativestore.core.insert_BANG_ = (function nativestore$core$insert_BANG_(store,obj){
if((!((store == null))) && (!((store.nativestore$core$IStore$insert_BANG_$arity$2 == null)))){
return store.nativestore$core$IStore$insert_BANG_$arity$2(store,obj);
} else {
var x__6795__auto__ = (((store == null))?null:store);
var m__6796__auto__ = (nativestore.core.insert_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,store,obj);
} else {
var m__6796__auto____$1 = (nativestore.core.insert_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,store,obj);
} else {
throw cljs.core.missing_protocol.call(null,"IStore.insert!",store);
}
}
}
});

nativestore.core.delete_BANG_ = (function nativestore$core$delete_BANG_(store,id){
if((!((store == null))) && (!((store.nativestore$core$IStore$delete_BANG_$arity$2 == null)))){
return store.nativestore$core$IStore$delete_BANG_$arity$2(store,id);
} else {
var x__6795__auto__ = (((store == null))?null:store);
var m__6796__auto__ = (nativestore.core.delete_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,store,id);
} else {
var m__6796__auto____$1 = (nativestore.core.delete_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,store,id);
} else {
throw cljs.core.missing_protocol.call(null,"IStore.delete!",store);
}
}
}
});


/**
 * @interface
 */
nativestore.core.IIndex = function(){};

nativestore.core.key_fn = (function nativestore$core$key_fn(idx){
if((!((idx == null))) && (!((idx.nativestore$core$IIndex$key_fn$arity$1 == null)))){
return idx.nativestore$core$IIndex$key_fn$arity$1(idx);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core.key_fn[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx);
} else {
var m__6796__auto____$1 = (nativestore.core.key_fn["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"IIndex.key-fn",idx);
}
}
}
});

nativestore.core.index_BANG_ = (function nativestore$core$index_BANG_(idx,obj){
if((!((idx == null))) && (!((idx.nativestore$core$IIndex$index_BANG_$arity$2 == null)))){
return idx.nativestore$core$IIndex$index_BANG_$arity$2(idx,obj);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core.index_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx,obj);
} else {
var m__6796__auto____$1 = (nativestore.core.index_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx,obj);
} else {
throw cljs.core.missing_protocol.call(null,"IIndex.index!",idx);
}
}
}
});

nativestore.core.unindex_BANG_ = (function nativestore$core$unindex_BANG_(idx,obj){
if((!((idx == null))) && (!((idx.nativestore$core$IIndex$unindex_BANG_$arity$2 == null)))){
return idx.nativestore$core$IIndex$unindex_BANG_$arity$2(idx,obj);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core.unindex_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx,obj);
} else {
var m__6796__auto____$1 = (nativestore.core.unindex_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx,obj);
} else {
throw cljs.core.missing_protocol.call(null,"IIndex.unindex!",idx);
}
}
}
});


/**
 * @interface
 */
nativestore.core.IClearable = function(){};

nativestore.core.clear_BANG_ = (function nativestore$core$clear_BANG_(idx){
if((!((idx == null))) && (!((idx.nativestore$core$IClearable$clear_BANG_$arity$1 == null)))){
return idx.nativestore$core$IClearable$clear_BANG_$arity$1(idx);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core.clear_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx);
} else {
var m__6796__auto____$1 = (nativestore.core.clear_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"IClearable.clear!",idx);
}
}
}
});


/**
 * @interface
 */
nativestore.core.ISortedIndex = function(){};

nativestore.core.comparator_fn = (function nativestore$core$comparator_fn(idx){
if((!((idx == null))) && (!((idx.nativestore$core$ISortedIndex$comparator_fn$arity$1 == null)))){
return idx.nativestore$core$ISortedIndex$comparator_fn$arity$1(idx);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core.comparator_fn[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx);
} else {
var m__6796__auto____$1 = (nativestore.core.comparator_fn["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"ISortedIndex.comparator-fn",idx);
}
}
}
});


/**
 * @interface
 */
nativestore.core.IScannable = function(){};

nativestore.core._get_cursor = (function nativestore$core$_get_cursor(var_args){
var args12067 = [];
var len__7198__auto___12070 = arguments.length;
var i__7199__auto___12071 = (0);
while(true){
if((i__7199__auto___12071 < len__7198__auto___12070)){
args12067.push((arguments[i__7199__auto___12071]));

var G__12072 = (i__7199__auto___12071 + (1));
i__7199__auto___12071 = G__12072;
continue;
} else {
}
break;
}

var G__12069 = args12067.length;
switch (G__12069) {
case 1:
return nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12067.length)].join('')));

}
});

nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$1 = (function (idx){
if((!((idx == null))) && (!((idx.nativestore$core$IScannable$_get_cursor$arity$1 == null)))){
return idx.nativestore$core$IScannable$_get_cursor$arity$1(idx);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core._get_cursor[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx);
} else {
var m__6796__auto____$1 = (nativestore.core._get_cursor["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"IScannable.-get-cursor",idx);
}
}
}
});

nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$2 = (function (idx,start){
if((!((idx == null))) && (!((idx.nativestore$core$IScannable$_get_cursor$arity$2 == null)))){
return idx.nativestore$core$IScannable$_get_cursor$arity$2(idx,start);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core._get_cursor[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx,start);
} else {
var m__6796__auto____$1 = (nativestore.core._get_cursor["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx,start);
} else {
throw cljs.core.missing_protocol.call(null,"IScannable.-get-cursor",idx);
}
}
}
});

nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$3 = (function (idx,start,end){
if((!((idx == null))) && (!((idx.nativestore$core$IScannable$_get_cursor$arity$3 == null)))){
return idx.nativestore$core$IScannable$_get_cursor$arity$3(idx,start,end);
} else {
var x__6795__auto__ = (((idx == null))?null:idx);
var m__6796__auto__ = (nativestore.core._get_cursor[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,idx,start,end);
} else {
var m__6796__auto____$1 = (nativestore.core._get_cursor["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,idx,start,end);
} else {
throw cljs.core.missing_protocol.call(null,"IScannable.-get-cursor",idx);
}
}
}
});

nativestore.core._get_cursor.cljs$lang$maxFixedArity = 3;


/**
 * @interface
 */
nativestore.core.IIndexedStore = function(){};

nativestore.core.add_index_BANG_ = (function nativestore$core$add_index_BANG_(store,name,index){
if((!((store == null))) && (!((store.nativestore$core$IIndexedStore$add_index_BANG_$arity$3 == null)))){
return store.nativestore$core$IIndexedStore$add_index_BANG_$arity$3(store,name,index);
} else {
var x__6795__auto__ = (((store == null))?null:store);
var m__6796__auto__ = (nativestore.core.add_index_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,store,name,index);
} else {
var m__6796__auto____$1 = (nativestore.core.add_index_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,store,name,index);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexedStore.add-index!",store);
}
}
}
});

nativestore.core.rem_index_BANG_ = (function nativestore$core$rem_index_BANG_(store,name){
if((!((store == null))) && (!((store.nativestore$core$IIndexedStore$rem_index_BANG_$arity$2 == null)))){
return store.nativestore$core$IIndexedStore$rem_index_BANG_$arity$2(store,name);
} else {
var x__6795__auto__ = (((store == null))?null:store);
var m__6796__auto__ = (nativestore.core.rem_index_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,store,name);
} else {
var m__6796__auto____$1 = (nativestore.core.rem_index_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,store,name);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexedStore.rem-index!",store);
}
}
}
});

nativestore.core.get_index = (function nativestore$core$get_index(store,name){
if((!((store == null))) && (!((store.nativestore$core$IIndexedStore$get_index$arity$2 == null)))){
return store.nativestore$core$IIndexedStore$get_index$arity$2(store,name);
} else {
var x__6795__auto__ = (((store == null))?null:store);
var m__6796__auto__ = (nativestore.core.get_index[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,store,name);
} else {
var m__6796__auto____$1 = (nativestore.core.get_index["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,store,name);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexedStore.get-index",store);
}
}
}
});


/**
 * @interface
 */
nativestore.core.ITransactionalStore = function(){};

nativestore.core._transact_BANG_ = (function nativestore$core$_transact_BANG_(store,f,args){
if((!((store == null))) && (!((store.nativestore$core$ITransactionalStore$_transact_BANG_$arity$3 == null)))){
return store.nativestore$core$ITransactionalStore$_transact_BANG_$arity$3(store,f,args);
} else {
var x__6795__auto__ = (((store == null))?null:store);
var m__6796__auto__ = (nativestore.core._transact_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,store,f,args);
} else {
var m__6796__auto____$1 = (nativestore.core._transact_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,store,f,args);
} else {
throw cljs.core.missing_protocol.call(null,"ITransactionalStore.-transact!",store);
}
}
}
});

/**
 * Mutates r1.  Keep list of merged IDs in sorted order
 */
nativestore.core.sorted_insert_BANG_ = (function nativestore$core$sorted_insert_BANG_(r1,r2){
return goog.array.forEach(r2,(function (v,i,a){
return goog.array.binaryInsert(r1,v);
}));
});
/**
 * Mutates r1. The updated range becomes the union of the two ranges
 */
nativestore.core.merge_range_BANG_ = (function nativestore$core$merge_range_BANG_(compfn,range1,range2){
var r1s = (range1[(0)]);
var r1e = (range1[(1)]);
var r2s = (range2[(0)]);
var r2e = (range2[(1)]);
if((compfn.call(null,r2s,r1s) < (0))){
(range1[(0)] = r2s);
} else {
}

if((compfn.call(null,r2e,r1e) > (0))){
return (range1[(1)] = r2e);
} else {
return null;
}
});
/**
 * Merge the index range or root set
 */
nativestore.core.merge_index_BANG_ = (function nativestore$core$merge_index_BANG_(nset,idx,range1,range2){
if((idx == null)){
return nativestore.core.sorted_insert_BANG_.call(null,range1,range2);
} else {
return nativestore.core.merge_range_BANG_.call(null,nativestore.core.comparator_fn.call(null,idx),range1,range2);
}
});
/**
 * Do two sorted sets of integers intersect?
 */
nativestore.core.intersect_QMARK_ = (function nativestore$core$intersect_QMARK_(set1,set2){
var len1 = (((set1 == null))?(0):set1.length);
var len2 = (((set2 == null))?(0):set2.length);
var i = (0);
var j = (0);
while(true){
if(((i === len1)) || ((j === len2))){
return false;
} else {
var v1 = (set1[i]);
var v2 = (set2[j]);
if(cljs.core._EQ_.call(null,v1,v2)){
return true;
} else {
if((cljs.core.compare.call(null,v1,v2) > (0))){
var G__12085 = i;
var G__12086 = (j + (1));
i = G__12085;
j = G__12086;
continue;
} else {
var G__12087 = (i + (1));
var G__12088 = j;
i = G__12087;
j = G__12088;
continue;

}
}
}
break;
}
});
/**
 * Does the interval of other overlap this?
 */
nativestore.core.overlap_QMARK_ = (function nativestore$core$overlap_QMARK_(compfn,range1,range2){
var r1s = (range1[(0)]);
var r1e = (range1[(1)]);
var r2s = (range2[(0)]);
var r2e = (range2[(1)]);
var res = !((function (){var or__6140__auto__ = (((r1e == null))?(compfn.call(null,r2e,r1s) < (0)):(compfn.call(null,r2s,r1e) > (0)));
if(or__6140__auto__){
return or__6140__auto__;
} else {
if((r2e == null)){
return (compfn.call(null,r1e,r2s) < (0));
} else {
return (compfn.call(null,r2e,r1s) < (0));
}
}
})());
return res;
});
nativestore.core.match_index_QMARK_ = (function nativestore$core$match_index_QMARK_(nset,idx,this_range,other_range){
if((idx == null)){
return nativestore.core.intersect_QMARK_.call(null,this_range,other_range);
} else {
return nativestore.core.overlap_QMARK_.call(null,nativestore.core.comparator_fn.call(null,idx),this_range,other_range);
}
});

/**
* @constructor
 * @implements {derive.core.IDependencySet}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IPrintWithWriter}
*/
nativestore.core.NativeDependencySet = (function (store,deps){
this.store = store;
this.deps = deps;
this.cljs$lang$protocol_mask$partition0$ = 2153775104;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.NativeDependencySet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#ndep ["),cljs.core.str(cljs.core.pr_str.call(null,self__.deps)),cljs.core.str("]")].join(''));
});

nativestore.core.NativeDependencySet.prototype.cljs$core$IHash$_hash$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return goog.getUid(o__$1);
});

nativestore.core.NativeDependencySet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
if((other instanceof nativestore.core.NativeDependencySet)){
return (cljs.core._hash.call(null,o__$1) === cljs.core._hash.call(null,other));
} else {
return false;
}
});

nativestore.core.NativeDependencySet.prototype.derive$core$IDependencySet$ = true;

nativestore.core.NativeDependencySet.prototype.derive$core$IDependencySet$merge_deps$arity$2 = (function (nset,other){
var self__ = this;
var nset__$1 = this;
var fdeps = (((other.deps == null))?other:other.deps);
goog.object.forEach(fdeps,((function (fdeps,nset__$1){
return (function (v,k){
var temp__4423__auto__ = (self__.deps[k]);
if(cljs.core.truth_(temp__4423__auto__)){
var mine = temp__4423__auto__;
return nativestore.core.merge_index_BANG_.call(null,nset__$1,nativestore.core.get_index.call(null,self__.store,k),mine,v);
} else {
return (self__.deps[k] = nativestore.core.js_copy.call(null,v));
}
});})(fdeps,nset__$1))
);

return nset__$1;
});

nativestore.core.NativeDependencySet.prototype.derive$core$IDependencySet$match_deps$arity$2 = (function (nset,other){
var self__ = this;
var nset__$1 = this;
var fdeps = (((other.deps == null))?other:other.deps);
return goog.object.some(fdeps,((function (fdeps,nset__$1){
return (function (v,k,o){
var temp__4425__auto__ = (self__.deps[k]);
if(cljs.core.truth_(temp__4425__auto__)){
var local = temp__4425__auto__;
return nativestore.core.match_index_QMARK_.call(null,nset__$1,nativestore.core.get_index.call(null,self__.store,k),local,v);
} else {
return null;
}
});})(fdeps,nset__$1))
);
});

nativestore.core.NativeDependencySet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"deps","deps",-771075450,null)], null);
});

nativestore.core.NativeDependencySet.cljs$lang$type = true;

nativestore.core.NativeDependencySet.cljs$lang$ctorStr = "nativestore.core/NativeDependencySet";

nativestore.core.NativeDependencySet.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/NativeDependencySet");
});

nativestore.core.__GT_NativeDependencySet = (function nativestore$core$__GT_NativeDependencySet(store,deps){
return (new nativestore.core.NativeDependencySet(store,deps));
});

nativestore.core.make_dependencies = (function nativestore$core$make_dependencies(var_args){
var args12117 = [];
var len__7198__auto___12120 = arguments.length;
var i__7199__auto___12121 = (0);
while(true){
if((i__7199__auto___12121 < len__7198__auto___12120)){
args12117.push((arguments[i__7199__auto___12121]));

var G__12122 = (i__7199__auto___12121 + (1));
i__7199__auto___12121 = G__12122;
continue;
} else {
}
break;
}

var G__12119 = args12117.length;
switch (G__12119) {
case 1:
return nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12117.length)].join('')));

}
});

nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (store){
return (new nativestore.core.NativeDependencySet(store,{}));
});

nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (store,init){
return (new nativestore.core.NativeDependencySet(store,init));
});

nativestore.core.make_dependencies.cljs$lang$maxFixedArity = 2;
nativestore.core.inform_tracker = (function nativestore$core$inform_tracker(var_args){
var args12124 = [];
var len__7198__auto___12127 = arguments.length;
var i__7199__auto___12128 = (0);
while(true){
if((i__7199__auto___12128 < len__7198__auto___12127)){
args12124.push((arguments[i__7199__auto___12128]));

var G__12129 = (i__7199__auto___12128 + (1));
i__7199__auto___12128 = G__12129;
continue;
} else {
}
break;
}

var G__12126 = args12124.length;
switch (G__12126) {
case 2:
return nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12124.length)].join('')));

}
});

nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$2 = (function (store,deps){
if(cljs.core.truth_(derive.core.tracking_QMARK_.call(null))){
return nativestore.core.inform_tracker.call(null,derive.core._STAR_tracker_STAR_,store,deps);
} else {
return null;
}
});

nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$3 = (function (tracker,store,deps){
var dset = nativestore.core.make_dependencies.call(null,store,deps);
return derive.core.depends_BANG_.call(null,tracker,store,dset);
});

nativestore.core.inform_tracker.cljs$lang$maxFixedArity = 3;
/**
 * Inside a transaction?
 */
nativestore.core._STAR_transaction_STAR_ = null;

/**
 * @interface
 */
nativestore.core.IReference = function(){};

nativestore.core.resolve_ref = (function nativestore$core$resolve_ref(ref){
if((!((ref == null))) && (!((ref.nativestore$core$IReference$resolve_ref$arity$1 == null)))){
return ref.nativestore$core$IReference$resolve_ref$arity$1(ref);
} else {
var x__6795__auto__ = (((ref == null))?null:ref);
var m__6796__auto__ = (nativestore.core.resolve_ref[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,ref);
} else {
var m__6796__auto____$1 = (nativestore.core.resolve_ref["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,ref);
} else {
throw cljs.core.missing_protocol.call(null,"IReference.resolve-ref",ref);
}
}
}
});

nativestore.core.reference_id = (function nativestore$core$reference_id(ref){
if((!((ref == null))) && (!((ref.nativestore$core$IReference$reference_id$arity$1 == null)))){
return ref.nativestore$core$IReference$reference_id$arity$1(ref);
} else {
var x__6795__auto__ = (((ref == null))?null:ref);
var m__6796__auto__ = (nativestore.core.reference_id[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,ref);
} else {
var m__6796__auto____$1 = (nativestore.core.reference_id["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,ref);
} else {
throw cljs.core.missing_protocol.call(null,"IReference.reference-id",ref);
}
}
}
});

nativestore.core.reference_db = (function nativestore$core$reference_db(ref){
if((!((ref == null))) && (!((ref.nativestore$core$IReference$reference_db$arity$1 == null)))){
return ref.nativestore$core$IReference$reference_db$arity$1(ref);
} else {
var x__6795__auto__ = (((ref == null))?null:ref);
var m__6796__auto__ = (nativestore.core.reference_db[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,ref);
} else {
var m__6796__auto____$1 = (nativestore.core.reference_db["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,ref);
} else {
throw cljs.core.missing_protocol.call(null,"IReference.reference-db",ref);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {nativestore.core.IReference}
 * @implements {cljs.core.IPrintWithWriter}
*/
nativestore.core.NativeReference = (function (store,id){
this.store = store;
this.id = id;
this.cljs$lang$protocol_mask$partition0$ = 2149580800;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.NativeReference.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#ref ["),cljs.core.str(self__.id),cljs.core.str("]")].join(''));
});

nativestore.core.NativeReference.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (ref,other){
var self__ = this;
var ref__$1 = this;
return (cljs.core._EQ_.call(null,self__.store,other.store)) && (cljs.core._EQ_.call(null,self__.id,other.id));
});

nativestore.core.NativeReference.prototype.nativestore$core$IReference$ = true;

nativestore.core.NativeReference.prototype.nativestore$core$IReference$resolve_ref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.store,self__.id);
});

nativestore.core.NativeReference.prototype.nativestore$core$IReference$reference_id$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.id;
});

nativestore.core.NativeReference.prototype.nativestore$core$IReference$reference_db$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.store;
});

nativestore.core.NativeReference.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
});

nativestore.core.NativeReference.cljs$lang$type = true;

nativestore.core.NativeReference.cljs$lang$ctorStr = "nativestore.core/NativeReference";

nativestore.core.NativeReference.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/NativeReference");
});

nativestore.core.__GT_NativeReference = (function nativestore$core$__GT_NativeReference(store,id){
return (new nativestore.core.NativeReference(store,id));
});

nativestore.core.reference = (function nativestore$core$reference(db,obj){
return (new nativestore.core.NativeReference(db,(((typeof obj === 'string') || (typeof obj === 'number') || (cljs.core.not.call(null,nativestore.core.native_QMARK_.call(null,obj))))?obj:nativestore.core.key_fn.call(null,db.root).call(null,obj))));
});
nativestore.core.identity_QMARK_ = (function nativestore$core$identity_QMARK_(n1,n2){
return cljs.core._EQ_.call(null,(n1["id"]),(n2["id"]));
});

/**
 * @interface
 */
nativestore.core.IReadOnly = function(){};

nativestore.core._read_only_QMARK_ = (function nativestore$core$_read_only_QMARK_(_){
if((!((_ == null))) && (!((_.nativestore$core$IReadOnly$_read_only_QMARK_$arity$1 == null)))){
return _.nativestore$core$IReadOnly$_read_only_QMARK_$arity$1(_);
} else {
var x__6795__auto__ = (((_ == null))?null:_);
var m__6796__auto__ = (nativestore.core._read_only_QMARK_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,_);
} else {
var m__6796__auto____$1 = (nativestore.core._read_only_QMARK_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IReadOnly.-read-only?",_);
}
}
}
});


/**
 * @interface
 */
nativestore.core.INative = function(){};


/**
* @constructor
 * @implements {nativestore.core.IReadOnly}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IEncodeClojure}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {nativestore.core.INative}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.Native = (function (__keyset,__ro){
this.__keyset = __keyset;
this.__ro = __ro;
this.cljs$lang$protocol_mask$partition1$ = 8248;
this.cljs$lang$protocol_mask$partition0$ = 2155874062;
})
nativestore.core.Native.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (native$,k,v){
var self__ = this;
var native$__$1 = this;
if((k instanceof cljs.core.Keyword)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"k","k",-505765866,null))))].join('')));
}

if(cljs.core.truth_((function (){var and__6128__auto__ = nativestore.core._read_only_QMARK_.call(null,native$__$1);
if(cljs.core.truth_(and__6128__auto__)){
return cljs.core.not.call(null,nativestore.core._STAR_transaction_STAR_);
} else {
return and__6128__auto__;
}
})())){
throw (new Error("Cannot mutate store values outside transact!: "));
} else {
}

cljs.core._vreset_BANG_.call(null,self__.__keyset,cljs.core.conj.call(null,cljs.core._deref.call(null,self__.__keyset),k));

(native$__$1[cljs.core.name.call(null,k)] = v);

return native$__$1;
});

nativestore.core.Native.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (native$,k){
var self__ = this;
var native$__$1 = this;
return cljs.core._lookup.call(null,native$__$1,k,null);
});

nativestore.core.Native.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (native$,k,not_found){
var self__ = this;
var native$__$1 = this;
if((k instanceof cljs.core.Keyword)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"k","k",-505765866,null))))].join('')));
}

var v = (native$__$1[cljs.core.name.call(null,k)]);
if((v == null)){
return not_found;
} else {
if(cljs.core.array_QMARK_.call(null,v)){
if((function (){var G__12140 = (v[(0)]);
if(!((G__12140 == null))){
if((false) || (G__12140.nativestore$core$IReference$)){
return true;
} else {
if((!G__12140.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,G__12140);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,G__12140);
}
})()){
var a__7031__auto__ = v;
var ret = cljs.core.aclone.call(null,a__7031__auto__);
var i = (0);
while(true){
if((i < a__7031__auto__.length)){
(ret[i] = nativestore.core.resolve_ref.call(null,(v[i])));

var G__12151 = (i + (1));
i = G__12151;
continue;
} else {
return ret;
}
break;
}
} else {
return v;
}
} else {
if(((!((v == null)))?(((false) || (v.nativestore$core$IReference$))?true:(((!v.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,v):false)):cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,v))){
return nativestore.core.resolve_ref.call(null,v);
} else {
return v;

}
}
}
});

nativestore.core.Native.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (native$,k){
var self__ = this;
var native$__$1 = this;
if((k instanceof cljs.core.Keyword)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"keyword?","keyword?",1917797069,null),new cljs.core.Symbol(null,"k","k",-505765866,null))))].join('')));
}

if(cljs.core.truth_((function (){var and__6128__auto__ = nativestore.core._read_only_QMARK_.call(null,native$__$1);
if(cljs.core.truth_(and__6128__auto__)){
return cljs.core.not.call(null,nativestore.core._STAR_transaction_STAR_);
} else {
return and__6128__auto__;
}
})())){
throw (new Error("Cannot mutate store values outside transact!: "));
} else {
}

cljs.core._vreset_BANG_.call(null,self__.__keyset,cljs.core.disj.call(null,cljs.core._deref.call(null,self__.__keyset),k));

delete native$__$1[cljs.core.name.call(null,k)];

return native$__$1;
});

nativestore.core.Native.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
cljs.core._write.call(null,writer,"#native ");

return cljs.core.print_map.call(null,cljs.core._seq.call(null,native$__$1),cljs.core.pr_writer,writer,opts);
});

nativestore.core.Native.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var clone = (new nativestore.core.Native(cljs.core.volatile_BANG_.call(null,cljs.core.deref.call(null,self__.__keyset)),false));
var seq__12142_12156 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.__keyset));
var chunk__12143_12157 = null;
var count__12144_12158 = (0);
var i__12145_12159 = (0);
while(true){
if((i__12145_12159 < count__12144_12158)){
var key_12164 = cljs.core._nth.call(null,chunk__12143_12157,i__12145_12159);
(clone[cljs.core.name.call(null,key_12164)] = (this$__$1[cljs.core.name.call(null,key_12164)]));

var G__12165 = seq__12142_12156;
var G__12166 = chunk__12143_12157;
var G__12167 = count__12144_12158;
var G__12168 = (i__12145_12159 + (1));
seq__12142_12156 = G__12165;
chunk__12143_12157 = G__12166;
count__12144_12158 = G__12167;
i__12145_12159 = G__12168;
continue;
} else {
var temp__4425__auto___12169 = cljs.core.seq.call(null,seq__12142_12156);
if(temp__4425__auto___12169){
var seq__12142_12170__$1 = temp__4425__auto___12169;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12142_12170__$1)){
var c__6943__auto___12171 = cljs.core.chunk_first.call(null,seq__12142_12170__$1);
var G__12172 = cljs.core.chunk_rest.call(null,seq__12142_12170__$1);
var G__12173 = c__6943__auto___12171;
var G__12174 = cljs.core.count.call(null,c__6943__auto___12171);
var G__12175 = (0);
seq__12142_12156 = G__12172;
chunk__12143_12157 = G__12173;
count__12144_12158 = G__12174;
i__12145_12159 = G__12175;
continue;
} else {
var key_12178 = cljs.core.first.call(null,seq__12142_12170__$1);
(clone[cljs.core.name.call(null,key_12178)] = (this$__$1[cljs.core.name.call(null,key_12178)]));

var G__12179 = cljs.core.next.call(null,seq__12142_12170__$1);
var G__12180 = null;
var G__12181 = (0);
var G__12182 = (0);
seq__12142_12156 = G__12179;
chunk__12143_12157 = G__12180;
count__12144_12158 = G__12181;
i__12145_12159 = G__12182;
continue;
}
} else {
}
}
break;
}

return clone;
});

nativestore.core.Native.prototype.cljs$core$IEncodeClojure$ = true;

nativestore.core.Native.prototype.cljs$core$IEncodeClojure$_js__GT_clj$arity$2 = (function (native$,opts){
var self__ = this;
var native$__$1 = this;
return native$__$1;
});

nativestore.core.Native.prototype.cljs$core$ICounted$_count$arity$1 = (function (native$){
var self__ = this;
var native$__$1 = this;
return cljs.core.count.call(null,cljs.core.deref.call(null,self__.__keyset));
});

nativestore.core.Native.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new nativestore.core.Native(cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY),false));
});

nativestore.core.Native.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (native$,p__12147){
var self__ = this;
var vec__12148 = p__12147;
var k = cljs.core.nth.call(null,vec__12148,(0),null);
var v = cljs.core.nth.call(null,vec__12148,(1),null);
var native$__$1 = this;
return cljs.core._assoc_BANG_.call(null,native$__$1,k,v);
});

nativestore.core.Native.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (native$,k){
var self__ = this;
var native$__$1 = this;
var new$ = cljs.core.clone.call(null,native$__$1);
return cljs.core._dissoc_BANG_.call(null,new$,k);
});

nativestore.core.Native.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (native$,k,v){
var self__ = this;
var native$__$1 = this;
var new$ = cljs.core.clone.call(null,native$__$1);
return cljs.core._assoc_BANG_.call(null,new$,k,v);
});

nativestore.core.Native.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (native$){
var self__ = this;
var native$__$1 = this;
return cljs.core.map.call(null,((function (native$__$1){
return (function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,k),(native$__$1[cljs.core.name.call(null,k)])], null);
});})(native$__$1))
,cljs.core.deref.call(null,self__.__keyset));
});

nativestore.core.Native.prototype.cljs$core$ICollection$_conj$arity$2 = (function (native$,p__12149){
var self__ = this;
var vec__12150 = p__12149;
var k = cljs.core.nth.call(null,vec__12150,(0),null);
var v = cljs.core.nth.call(null,vec__12150,(1),null);
var native$__$1 = this;
return cljs.core._assoc.call(null,native$__$1,k,v);
});

nativestore.core.Native.prototype.nativestore$core$IReadOnly$ = true;

nativestore.core.Native.prototype.nativestore$core$IReadOnly$_read_only_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.__ro;
});

nativestore.core.Native.prototype.nativestore$core$INative$ = true;

nativestore.core.Native.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__keyset","__keyset",1751286013,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__ro","__ro",-1834159981,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

nativestore.core.Native.cljs$lang$type = true;

nativestore.core.Native.cljs$lang$ctorStr = "nativestore.core/Native";

nativestore.core.Native.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/Native");
});

nativestore.core.__GT_Native = (function nativestore$core$__GT_Native(__keyset,__ro){
return (new nativestore.core.Native(__keyset,__ro));
});

/**
 * Return a fresh native, optionally with the read-only set
 */
nativestore.core.native$ = (function nativestore$core$native(var_args){
var args12204 = [];
var len__7198__auto___12213 = arguments.length;
var i__7199__auto___12214 = (0);
while(true){
if((i__7199__auto___12214 < len__7198__auto___12213)){
args12204.push((arguments[i__7199__auto___12214]));

var G__12215 = (i__7199__auto___12214 + (1));
i__7199__auto___12214 = G__12215;
continue;
} else {
}
break;
}

var G__12212 = args12204.length;
switch (G__12212) {
case 0:
return nativestore.core.native$.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return nativestore.core.native$.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12204.length)].join('')));

}
});

nativestore.core.native$.cljs$core$IFn$_invoke$arity$0 = (function (){
return nativestore.core.native$.call(null,false);
});

nativestore.core.native$.cljs$core$IFn$_invoke$arity$1 = (function (ro_QMARK_){
return (new nativestore.core.Native(cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY),ro_QMARK_));
});

nativestore.core.native$.cljs$lang$maxFixedArity = 1;
/**
 * Is this object a #native?
 */
nativestore.core.native_QMARK_ = (function nativestore$core$native_QMARK_(native$){
if(!((native$ == null))){
if((false) || (native$.nativestore$core$INative$)){
return true;
} else {
if((!native$.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.INative,native$);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.INative,native$);
}
});
/**
 * Copying conversion function, will return
 * a fresh, writable, #native
 */
nativestore.core.to_native = (function nativestore$core$to_native(obj){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,obj))){
return cljs.core.clone.call(null,obj);
} else {
if(cljs.core.object_QMARK_.call(null,obj)){
var native$ = nativestore.core.native$.call(null,false);
goog.object.forEach(obj,((function (native$){
return (function (v,k){
return cljs.core._assoc_BANG_.call(null,native$,cljs.core.keyword.call(null,k),v);
});})(native$))
);

return native$;
} else {
if(cljs.core.seqable_QMARK_.call(null,obj)){
var native$ = nativestore.core.native$.call(null,false);
var seq__12229 = cljs.core.seq.call(null,cljs.core.keys.call(null,obj));
var chunk__12230 = null;
var count__12231 = (0);
var i__12232 = (0);
while(true){
if((i__12232 < count__12231)){
var key = cljs.core._nth.call(null,chunk__12230,i__12232);
cljs.core._assoc_BANG_.call(null,native$,cljs.core.keyword.call(null,key),cljs.core.get.call(null,obj,cljs.core.name.call(null,key)));

var G__12233 = seq__12229;
var G__12234 = chunk__12230;
var G__12235 = count__12231;
var G__12236 = (i__12232 + (1));
seq__12229 = G__12233;
chunk__12230 = G__12234;
count__12231 = G__12235;
i__12232 = G__12236;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__12229);
if(temp__4425__auto__){
var seq__12229__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12229__$1)){
var c__6943__auto__ = cljs.core.chunk_first.call(null,seq__12229__$1);
var G__12237 = cljs.core.chunk_rest.call(null,seq__12229__$1);
var G__12238 = c__6943__auto__;
var G__12239 = cljs.core.count.call(null,c__6943__auto__);
var G__12240 = (0);
seq__12229 = G__12237;
chunk__12230 = G__12238;
count__12231 = G__12239;
i__12232 = G__12240;
continue;
} else {
var key = cljs.core.first.call(null,seq__12229__$1);
cljs.core._assoc_BANG_.call(null,native$,cljs.core.keyword.call(null,key),cljs.core.get.call(null,obj,cljs.core.name.call(null,key)));

var G__12241 = cljs.core.next.call(null,seq__12229__$1);
var G__12242 = null;
var G__12243 = (0);
var G__12244 = (0);
seq__12229 = G__12241;
chunk__12230 = G__12242;
count__12231 = G__12243;
i__12232 = G__12244;
continue;
}
} else {
return null;
}
}
break;
}
} else {
throw Error;

}
}
}
});
nativestore.core.read_only_BANG_ = (function nativestore$core$read_only_BANG_(native$){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,native$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"native?","native?",-276459341,null),new cljs.core.Symbol(null,"native","native",1027470649,null))))].join('')));
}

native$.__ro = true;

return native$;
});
nativestore.core.read_only_QMARK_ = (function nativestore$core$read_only_QMARK_(native$){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,native$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"native?","native?",-276459341,null),new cljs.core.Symbol(null,"native","native",1027470649,null))))].join('')));
}

return nativestore.core._read_only_QMARK_.call(null,native$);
});
nativestore.core.writeable_BANG_ = (function nativestore$core$writeable_BANG_(native$){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,native$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"native?","native?",-276459341,null),new cljs.core.Symbol(null,"native","native",1027470649,null))))].join('')));
}

native$.__ro = false;

return native$;
});
/**
 * Only called from internal methods
 */
nativestore.core.upsert_merge = (function nativestore$core$upsert_merge(var_args){
var args12245 = [];
var len__7198__auto___12258 = arguments.length;
var i__7199__auto___12259 = (0);
while(true){
if((i__7199__auto___12259 < len__7198__auto___12258)){
args12245.push((arguments[i__7199__auto___12259]));

var G__12260 = (i__7199__auto___12259 + (1));
i__7199__auto___12259 = G__12260;
continue;
} else {
}
break;
}

var G__12250 = args12245.length;
switch (G__12250) {
case 2:
return nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7217__auto__ = (new cljs.core.IndexedSeq(args12245.slice((2)),(0)));
return nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7217__auto__);

}
});

nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$2 = (function (o1,o2){
var _STAR_transaction_STAR_12252_12262 = nativestore.core._STAR_transaction_STAR_;
nativestore.core._STAR_transaction_STAR_ = (cljs.core.truth_(nativestore.core._STAR_transaction_STAR_)?nativestore.core._STAR_transaction_STAR_:true);

try{var seq__12254_12263 = cljs.core.seq.call(null,cljs.core.keys.call(null,o2));
var chunk__12255_12264 = null;
var count__12256_12265 = (0);
var i__12257_12266 = (0);
while(true){
if((i__12257_12266 < count__12256_12265)){
var k_12269 = cljs.core._nth.call(null,chunk__12255_12264,i__12257_12266);
var kstr_12272 = cljs.core.name.call(null,k_12269);
if(!(((o2[kstr_12272]) == null))){
cljs.core._assoc_BANG_.call(null,o1,k_12269,(o2[kstr_12272]));
} else {
cljs.core._dissoc_BANG_.call(null,o1,k_12269);
}

var G__12273 = seq__12254_12263;
var G__12274 = chunk__12255_12264;
var G__12275 = count__12256_12265;
var G__12276 = (i__12257_12266 + (1));
seq__12254_12263 = G__12273;
chunk__12255_12264 = G__12274;
count__12256_12265 = G__12275;
i__12257_12266 = G__12276;
continue;
} else {
var temp__4425__auto___12277 = cljs.core.seq.call(null,seq__12254_12263);
if(temp__4425__auto___12277){
var seq__12254_12278__$1 = temp__4425__auto___12277;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12254_12278__$1)){
var c__6943__auto___12279 = cljs.core.chunk_first.call(null,seq__12254_12278__$1);
var G__12280 = cljs.core.chunk_rest.call(null,seq__12254_12278__$1);
var G__12281 = c__6943__auto___12279;
var G__12282 = cljs.core.count.call(null,c__6943__auto___12279);
var G__12283 = (0);
seq__12254_12263 = G__12280;
chunk__12255_12264 = G__12281;
count__12256_12265 = G__12282;
i__12257_12266 = G__12283;
continue;
} else {
var k_12284 = cljs.core.first.call(null,seq__12254_12278__$1);
var kstr_12285 = cljs.core.name.call(null,k_12284);
if(!(((o2[kstr_12285]) == null))){
cljs.core._assoc_BANG_.call(null,o1,k_12284,(o2[kstr_12285]));
} else {
cljs.core._dissoc_BANG_.call(null,o1,k_12284);
}

var G__12286 = cljs.core.next.call(null,seq__12254_12278__$1);
var G__12287 = null;
var G__12288 = (0);
var G__12289 = (0);
seq__12254_12263 = G__12286;
chunk__12255_12264 = G__12287;
count__12256_12265 = G__12288;
i__12257_12266 = G__12289;
continue;
}
} else {
}
}
break;
}
}finally {nativestore.core._STAR_transaction_STAR_ = _STAR_transaction_STAR_12252_12262;
}
return o1;
});

nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$variadic = (function (o1,o2,more){
return cljs.core.apply.call(null,nativestore.core.upsert_merge,nativestore.core.upsert_merge.call(null,o1,o2),more);
});

nativestore.core.upsert_merge.cljs$lang$applyTo = (function (seq12246){
var G__12247 = cljs.core.first.call(null,seq12246);
var seq12246__$1 = cljs.core.next.call(null,seq12246);
var G__12248 = cljs.core.first.call(null,seq12246__$1);
var seq12246__$2 = cljs.core.next.call(null,seq12246__$1);
return nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$variadic(G__12247,G__12248,seq12246__$2);
});

nativestore.core.upsert_merge.cljs$lang$maxFixedArity = (2);

/**
* @constructor
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IReduce}
*/
nativestore.core.Cursor = (function (idx,start,end,valid_QMARK_,empty_QMARK_){
this.idx = idx;
this.start = start;
this.end = end;
this.valid_QMARK_ = valid_QMARK_;
this.empty_QMARK_ = empty_QMARK_;
this.cljs$lang$protocol_mask$partition0$ = 8912896;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.Cursor.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,f,f.call(null));
});

nativestore.core.Cursor.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (this$,f,init){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.empty_QMARK_)){
return init;
} else {
var a = (function (){var or__6140__auto__ = self__.idx.arry;
if(cljs.core.truth_(or__6140__auto__)){
return or__6140__auto__;
} else {
return (self__.idx["arry"]);
}
})();
var i = self__.start;
var ret = init;
while(true){
if((i <= self__.end)){
var G__12296 = (i + (1));
var G__12297 = f.call(null,ret,(a[i]));
i = G__12296;
ret = G__12297;
continue;
} else {
return ret;
}
break;
}
}
});

nativestore.core.Cursor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.seq.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,this$__$1));
});

nativestore.core.Cursor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"valid?","valid?",1428119148,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"empty?","empty?",76408555,null)], null);
});

nativestore.core.Cursor.cljs$lang$type = true;

nativestore.core.Cursor.cljs$lang$ctorStr = "nativestore.core/Cursor";

nativestore.core.Cursor.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/Cursor");
});

nativestore.core.__GT_Cursor = (function nativestore$core$__GT_Cursor(idx,start,end,valid_QMARK_,empty_QMARK_){
return (new nativestore.core.Cursor(idx,start,end,valid_QMARK_,empty_QMARK_));
});


/**
* @constructor
 * @implements {nativestore.core.IScannable}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {nativestore.core.IClearable}
 * @implements {nativestore.core.IIndex}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.HashIndex = (function (keyfn,hashmap){
this.keyfn = keyfn;
this.hashmap = hashmap;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.HashIndex.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (idx,val){
var self__ = this;
var idx__$1 = this;
return cljs.core._lookup.call(null,idx__$1,val,null);
});

nativestore.core.HashIndex.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (idx,val,not_found){
var self__ = this;
var idx__$1 = this;
return nativestore.core.js_lookup.call(null,self__.hashmap,val,not_found);
});

nativestore.core.HashIndex.prototype.call = (function() {
var G__12301 = null;
var G__12301__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k);
});
var G__12301__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k,not_found);
});
G__12301 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12301__2.call(this,self__,k);
case 3:
return G__12301__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12301.cljs$core$IFn$_invoke$arity$2 = G__12301__2;
G__12301.cljs$core$IFn$_invoke$arity$3 = G__12301__3;
return G__12301;
})()
;

nativestore.core.HashIndex.prototype.apply = (function (self__,args12298){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12298)));
});

nativestore.core.HashIndex.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k);
});

nativestore.core.HashIndex.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k,not_found);
});

nativestore.core.HashIndex.prototype.cljs$core$ICounted$_count$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return cljs.core.js_keys.call(null,self__.hashmap).length;
});

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$ = true;

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$key_fn$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return self__.keyfn;
});

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$index_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var key = self__.keyfn.call(null,obj);
var old = nativestore.core.js_lookup.call(null,self__.hashmap,key);
return nativestore.core.js_assoc.call(null,self__.hashmap,key,(cljs.core.truth_(old)?nativestore.core.upsert_merge.call(null,old,obj):obj));
});

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$unindex_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var key = self__.keyfn.call(null,obj);
return nativestore.core.js_dissoc.call(null,self__.hashmap,key,obj);
});

nativestore.core.HashIndex.prototype.nativestore$core$IClearable$ = true;

nativestore.core.HashIndex.prototype.nativestore$core$IClearable$clear_BANG_$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return goog.array.clear(self__.hashmap);
});

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$ = true;

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
var vals = (function (){var obj12300 = {"arry":goog.object.getValues(idx__$1.hashmap)};
return obj12300;
})();
return (new nativestore.core.Cursor(vals,(0),((vals["arry"]).length - (1)),true,false));
});

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$2 = (function (idx,start){
var self__ = this;
var idx__$1 = this;
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Hash index does not support range queries"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,false))].join('')));

});

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$3 = (function (idx,start,end){
var self__ = this;
var idx__$1 = this;
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Hash index does not support range queries"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,false))].join('')));

});

nativestore.core.HashIndex.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"hashmap","hashmap",1013955299,null)], null);
});

nativestore.core.HashIndex.cljs$lang$type = true;

nativestore.core.HashIndex.cljs$lang$ctorStr = "nativestore.core/HashIndex";

nativestore.core.HashIndex.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/HashIndex");
});

nativestore.core.__GT_HashIndex = (function nativestore$core$__GT_HashIndex(keyfn,hashmap){
return (new nativestore.core.HashIndex(keyfn,hashmap));
});

nativestore.core.root_index = (function nativestore$core$root_index(){
return (new nativestore.core.HashIndex((function (p1__12302_SHARP_){
return (p1__12302_SHARP_["id"]);
}),{}));
});

/**
* @constructor
 * @implements {nativestore.core.IScannable}
 * @implements {cljs.core.IFn}
 * @implements {nativestore.core.ISortedIndex}
 * @implements {nativestore.core.IClearable}
 * @implements {nativestore.core.IIndex}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.BinaryIndex = (function (keyfn,compfn,arry){
this.keyfn = keyfn;
this.compfn = compfn;
this.arry = arry;
this.cljs$lang$protocol_mask$partition0$ = 257;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.BinaryIndex.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (idx,val){
var self__ = this;
var idx__$1 = this;
return cljs.core._lookup.call(null,idx__$1,val,null);
});

nativestore.core.BinaryIndex.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (idx,val,not_found){
var self__ = this;
var idx__$1 = this;
var index = goog.array.binarySearch(self__.arry,val,((function (idx__$1){
return (function (p1__12303_SHARP_,p2__12304_SHARP_){
return self__.compfn.call(null,p1__12303_SHARP_,self__.keyfn.call(null,p2__12304_SHARP_));
});})(idx__$1))
);
if((index >= (0))){
var end = index;
while(true){
if(cljs.core._EQ_.call(null,self__.compfn.call(null,val,self__.keyfn.call(null,(self__.arry[end]))),(0))){
var G__12319 = (end + (1));
end = G__12319;
continue;
} else {
return goog.array.slice(self__.arry,index,end);
}
break;
}
} else {
return not_found;
}
});

nativestore.core.BinaryIndex.prototype.call = (function() {
var G__12320 = null;
var G__12320__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k);
});
var G__12320__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k,not_found);
});
G__12320 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12320__2.call(this,self__,k);
case 3:
return G__12320__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12320.cljs$core$IFn$_invoke$arity$2 = G__12320__2;
G__12320.cljs$core$IFn$_invoke$arity$3 = G__12320__3;
return G__12320;
})()
;

nativestore.core.BinaryIndex.prototype.apply = (function (self__,args12313){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12313)));
});

nativestore.core.BinaryIndex.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k);
});

nativestore.core.BinaryIndex.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k,not_found);
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$key_fn$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return self__.keyfn;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$index_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var loc_12321 = goog.array.binarySearch(self__.arry,obj,((function (idx__$1){
return (function (p1__12305_SHARP_,p2__12306_SHARP_){
return self__.compfn.call(null,self__.keyfn.call(null,p1__12305_SHARP_),self__.keyfn.call(null,p2__12306_SHARP_));
});})(idx__$1))
);
if((loc_12321 >= (0))){
goog.array.insertAt(self__.arry,obj,loc_12321);
} else {
goog.array.insertAt(self__.arry,obj,(- (loc_12321 + (1))));
}

return idx__$1;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$unindex_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var loc_12324 = goog.array.indexOf(self__.arry,obj);
if((loc_12324 >= (0))){
goog.array.removeAt(self__.arry,loc_12324);
} else {
}

return idx__$1;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IClearable$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$IClearable$clear_BANG_$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return goog.array.clear(self__.arry);
});

nativestore.core.BinaryIndex.prototype.nativestore$core$ISortedIndex$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$ISortedIndex$comparator_fn$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return self__.compfn;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return (new nativestore.core.Cursor(idx__$1,(0),(idx__$1.arry.length - (1)),true,false));
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$2 = (function (idx,start){
var self__ = this;
var idx__$1 = this;
var head = goog.array.binarySearch(self__.arry,start,((function (idx__$1){
return (function (p1__12307_SHARP_,p2__12308_SHARP_){
return self__.compfn.call(null,p1__12307_SHARP_,self__.keyfn.call(null,p2__12308_SHARP_));
});})(idx__$1))
);
var head__$1 = (((head >= (0)))?head:(- (head + (1))));
return (new nativestore.core.Cursor(idx__$1,head__$1,(idx__$1.arry.length - (1)),true,false));
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$3 = (function (idx,start,end){
var self__ = this;
var idx__$1 = this;
var headidx = goog.array.binarySearch(self__.arry,start,((function (idx__$1){
return (function (p1__12309_SHARP_,p2__12310_SHARP_){
return self__.compfn.call(null,p1__12309_SHARP_,self__.keyfn.call(null,p2__12310_SHARP_));
});})(idx__$1))
);
var head = (((headidx >= (0)))?headidx:(- (headidx + (1))));
var tailidx = goog.array.binarySearch(self__.arry,end,((function (headidx,head,idx__$1){
return (function (p1__12311_SHARP_,p2__12312_SHARP_){
return self__.compfn.call(null,p1__12311_SHARP_,self__.keyfn.call(null,p2__12312_SHARP_));
});})(headidx,head,idx__$1))
);
var tail = (((tailidx >= (0)))?tailidx:(- (tailidx + (1))));
var tail__$1 = ((!((tail >= idx__$1.arry.length)))?(function (){var tail__$1 = tail;
while(true){
var next = self__.keyfn.call(null,(self__.arry[tail__$1]));
var c = self__.compfn.call(null,end,next);
if(cljs.core._EQ_.call(null,c,(0))){
if(cljs.core.not_EQ_.call(null,(tail__$1 + (1)),idx__$1.arry.length)){
var G__12342 = (tail__$1 + (1));
tail__$1 = G__12342;
continue;
} else {
return tail__$1;
}
} else {
return (tail__$1 - (1));
}
break;
}
})():tail);
var empty_QMARK_ = (cljs.core._EQ_.call(null,head,tail__$1)) && (((tailidx < (0))) && ((headidx < (0))));
return (new nativestore.core.Cursor(idx__$1,head,tail__$1,true,empty_QMARK_));
});

nativestore.core.BinaryIndex.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"compfn","compfn",-1175460791,null),new cljs.core.Symbol(null,"arry","arry",-2021358270,null)], null);
});

nativestore.core.BinaryIndex.cljs$lang$type = true;

nativestore.core.BinaryIndex.cljs$lang$ctorStr = "nativestore.core/BinaryIndex";

nativestore.core.BinaryIndex.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/BinaryIndex");
});

nativestore.core.__GT_BinaryIndex = (function nativestore$core$__GT_BinaryIndex(keyfn,compfn,arry){
return (new nativestore.core.BinaryIndex(keyfn,compfn,arry));
});

nativestore.core.ordered_index = (function nativestore$core$ordered_index(keyfn,compfn){
return (new nativestore.core.BinaryIndex(keyfn,compfn,[]));
});
/**
 * Return a js array key for compound ordering
 */
nativestore.core.compound_key_fn = (function nativestore$core$compound_key_fn(keyfns){
var cnt = cljs.core.count.call(null,keyfns);
return ((function (cnt){
return (function (obj){
var vals = (new Array(cnt));
var i = (0);
var keyfns__$1 = keyfns;
while(true){
if(cljs.core.empty_QMARK_.call(null,keyfns__$1)){
return vals;
} else {
var temp__4423__auto__ = cljs.core.first.call(null,keyfns__$1).call(null,obj);
if(cljs.core.truth_(temp__4423__auto__)){
var val = temp__4423__auto__;
(vals[i] = val);

var G__12347 = (i + (1));
var G__12348 = cljs.core.rest.call(null,keyfns__$1);
i = G__12347;
keyfns__$1 = G__12348;
continue;
} else {
return null;
}
}
break;
}
});
;})(cnt))
});
/**
 * Compare two compound keys using the array of comparators
 */
nativestore.core.compound_comparator = (function nativestore$core$compound_comparator(comps){
var cnt = cljs.core.count.call(null,comps);
return ((function (cnt){
return (function (akey1,akey2){
var i = (0);
var comps__$1 = comps;
var ans = (0);
while(true){
if(!(cljs.core.empty_QMARK_.call(null,comps__$1))){
var comp = cljs.core.first.call(null,comps__$1);
var res = comp.call(null,(akey1[i]),(akey2[i]));
if(cljs.core._EQ_.call(null,res,(0))){
var G__12351 = (i + (1));
var G__12352 = cljs.core.rest.call(null,comps__$1);
var G__12353 = res;
i = G__12351;
comps__$1 = G__12352;
ans = G__12353;
continue;
} else {
return res;
}
} else {
return ans;
}
break;
}
});
;})(cnt))
});
nativestore.core.compound_index = (function nativestore$core$compound_index(keyfns,compfns){
return (new nativestore.core.BinaryIndex(nativestore.core.compound_key_fn.call(null,keyfns),nativestore.core.compound_comparator.call(null,compfns),[]));
});
/**
 * Ensure submitted object is a native and set to read-only state
 */
nativestore.core.as_ro_native = (function nativestore$core$as_ro_native(obj){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,obj))){
return nativestore.core.read_only_BANG_.call(null,obj);
} else {
var native$ = nativestore.core.to_native.call(null,obj);
return nativestore.core.read_only_BANG_.call(null,native$);
}
});
/**
 * Use this to update store listeners when write dependencies
 * have been accumulatd
 */
nativestore.core.update_listeners = (function nativestore$core$update_listeners(result,dmap){
var vec__12363 = cljs.core.first.call(null,dmap);
var store = cljs.core.nth.call(null,vec__12363,(0),null);
var deps = cljs.core.nth.call(null,vec__12363,(1),null);
if(cljs.core.truth_(store)){
return derive.core.notify_listeners.call(null,store,deps);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {derive.core.IDependencySource}
 * @implements {cljs.core.IFn}
 * @implements {nativestore.core.IIndexedStore}
 * @implements {nativestore.core.ITransactionalStore}
 * @implements {cljs.core.ICounted}
 * @implements {nativestore.core.IClearable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {nativestore.core.IStore}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.NativeStore = (function (root,indices,tx_listeners,listeners){
this.root = root;
this.indices = indices;
this.tx_listeners = tx_listeners;
this.listeners = listeners;
this.cljs$lang$protocol_mask$partition0$ = 2147483907;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
nativestore.core.NativeStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (store,id){
var self__ = this;
var store__$1 = this;
return cljs.core._lookup.call(null,store__$1,id,null);
});

nativestore.core.NativeStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (store,id,not_found){
var self__ = this;
var store__$1 = this;
nativestore.core.inform_tracker.call(null,store__$1,(function (){var obj12367 = {"root":[id]};
return obj12367;
})());

return cljs.core._lookup.call(null,self__.root,id,not_found);
});

nativestore.core.NativeStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#NativeStore[]")].join(''));
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$ = true;

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deps], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
var old_set = cljs.core.get.call(null,self__.listeners,null);
var new_set = cljs.core.disj.call(null,self__.listeners,listener);
if(cljs.core.empty_QMARK_.call(null,new_set)){
return self__.listeners = cljs.core.dissoc.call(null,self__.listeners,null);
} else {
return self__.listeners = cljs.core.assoc.call(null,self__.listeners,null,new_set);
}
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
var old_set = cljs.core.get.call(null,self__.listeners,deps);
var new_set = ((cljs.core.set_QMARK_.call(null,old_set))?cljs.core.disj.call(null,old_set,listener):null);
if(cljs.core.empty_QMARK_.call(null,new_set)){
return self__.listeners = cljs.core.dissoc.call(null,self__.listeners,deps);
} else {
return self__.listeners = cljs.core.assoc.call(null,self__.listeners,deps,new_set);
}
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$empty_deps$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return nativestore.core.make_dependencies.call(null,this$__$1);
});

nativestore.core.NativeStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (store){
var self__ = this;
var store__$1 = this;
return cljs.core._count.call(null,self__.root);
});

nativestore.core.NativeStore.prototype.nativestore$core$ITransactionalStore$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$ITransactionalStore$_transact_BANG_$arity$3 = (function (store,f,args){
var self__ = this;
var store__$1 = this;
var parent_shadow__11979__auto__ = derive.core._STAR_shadow_STAR_;
var handler__11980__auto__ = nativestore.core.update_listeners;
var shadow_QMARK___11981__auto__ = true;
var _STAR_tracker_STAR_12368 = derive.core._STAR_tracker_STAR_;
var _STAR_shadow_STAR_12369 = derive.core._STAR_shadow_STAR_;
derive.core._STAR_tracker_STAR_ = (cljs.core.truth_(derive.core._STAR_shadow_STAR_)?derive.core._STAR_tracker_STAR_:derive.core.default_tracker.call(null));

derive.core._STAR_shadow_STAR_ = (function (){var or__6140__auto__ = derive.core._STAR_shadow_STAR_;
if(cljs.core.truth_(or__6140__auto__)){
return or__6140__auto__;
} else {
return shadow_QMARK___11981__auto__;
}
})();

try{var result__11982__auto__ = (function (){var _STAR_transaction_STAR_12370 = nativestore.core._STAR_transaction_STAR_;
nativestore.core._STAR_transaction_STAR_ = [];

try{var result = cljs.core.apply.call(null,f,store__$1,args);
return cljs.core._notify_watches.call(null,store__$1,null,nativestore.core._STAR_transaction_STAR_);
}finally {nativestore.core._STAR_transaction_STAR_ = _STAR_transaction_STAR_12370;
}})();
if(cljs.core.truth_(parent_shadow__11979__auto__)){
} else {
var dmap__11983__auto___12435 = derive.core.dependencies.call(null,derive.core._STAR_tracker_STAR_);
handler__11980__auto__.call(null,result__11982__auto__,dmap__11983__auto___12435);
}

return result__11982__auto__;
}finally {derive.core._STAR_shadow_STAR_ = _STAR_shadow_STAR_12369;

derive.core._STAR_tracker_STAR_ = _STAR_tracker_STAR_12368;
}});

nativestore.core.NativeStore.prototype.nativestore$core$IStore$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$IStore$insert_BANG_$arity$2 = (function (store,obj){
var self__ = this;
var store__$1 = this;
var parent_shadow__11979__auto__ = derive.core._STAR_shadow_STAR_;
var handler__11980__auto__ = nativestore.core.update_listeners;
var shadow_QMARK___11981__auto__ = null;
var _STAR_tracker_STAR_12371 = derive.core._STAR_tracker_STAR_;
var _STAR_shadow_STAR_12372 = derive.core._STAR_shadow_STAR_;
derive.core._STAR_tracker_STAR_ = (cljs.core.truth_(derive.core._STAR_shadow_STAR_)?derive.core._STAR_tracker_STAR_:derive.core.default_tracker.call(null));

derive.core._STAR_shadow_STAR_ = (function (){var or__6140__auto__ = derive.core._STAR_shadow_STAR_;
if(cljs.core.truth_(or__6140__auto__)){
return or__6140__auto__;
} else {
return shadow_QMARK___11981__auto__;
}
})();

try{var result__11982__auto__ = (function (){var obj__$1 = nativestore.core.as_ro_native.call(null,obj);
var key_12436 = nativestore.core.key_fn.call(null,self__.root).call(null,obj__$1);
var __12437 = (cljs.core.truth_(key_12436)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Must have an ID field"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"key","key",124488940,null)))].join('')))})());
var names_12438 = cljs.core.js_keys.call(null,self__.indices);
var old_12439 = cljs.core.get.call(null,self__.root,key_12436);
var oldref_12440 = (cljs.core.truth_(old_12439)?nativestore.core.js_copy.call(null,old_12439):null);
if(cljs.core.truth_(old_12439)){
var seq__12373_12441 = cljs.core.seq.call(null,names_12438);
var chunk__12374_12442 = null;
var count__12375_12443 = (0);
var i__12376_12444 = (0);
while(true){
if((i__12376_12444 < count__12375_12443)){
var iname_12445 = cljs.core._nth.call(null,chunk__12374_12442,i__12376_12444);
var idx_12446 = (self__.indices[iname_12445]);
var ikey_12447 = nativestore.core.key_fn.call(null,idx_12446).call(null,old_12439);
if(((ikey_12447 == null)) || (cljs.core._EQ_.call(null,ikey_12447,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12380 = cljs.core.name.call(null,iname_12445);
var obj12382 = {};
(obj12382[G__12380] = [ikey_12447,ikey_12447]);

return obj12382;
})());

nativestore.core.unindex_BANG_.call(null,idx_12446,old_12439);
}

var G__12448 = seq__12373_12441;
var G__12449 = chunk__12374_12442;
var G__12450 = count__12375_12443;
var G__12451 = (i__12376_12444 + (1));
seq__12373_12441 = G__12448;
chunk__12374_12442 = G__12449;
count__12375_12443 = G__12450;
i__12376_12444 = G__12451;
continue;
} else {
var temp__4425__auto___12452 = cljs.core.seq.call(null,seq__12373_12441);
if(temp__4425__auto___12452){
var seq__12373_12453__$1 = temp__4425__auto___12452;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12373_12453__$1)){
var c__6943__auto___12454 = cljs.core.chunk_first.call(null,seq__12373_12453__$1);
var G__12455 = cljs.core.chunk_rest.call(null,seq__12373_12453__$1);
var G__12456 = c__6943__auto___12454;
var G__12457 = cljs.core.count.call(null,c__6943__auto___12454);
var G__12458 = (0);
seq__12373_12441 = G__12455;
chunk__12374_12442 = G__12456;
count__12375_12443 = G__12457;
i__12376_12444 = G__12458;
continue;
} else {
var iname_12459 = cljs.core.first.call(null,seq__12373_12453__$1);
var idx_12460 = (self__.indices[iname_12459]);
var ikey_12461 = nativestore.core.key_fn.call(null,idx_12460).call(null,old_12439);
if(((ikey_12461 == null)) || (cljs.core._EQ_.call(null,ikey_12461,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12383 = cljs.core.name.call(null,iname_12459);
var obj12385 = {};
(obj12385[G__12383] = [ikey_12461,ikey_12461]);

return obj12385;
})());

nativestore.core.unindex_BANG_.call(null,idx_12460,old_12439);
}

var G__12462 = cljs.core.next.call(null,seq__12373_12453__$1);
var G__12463 = null;
var G__12464 = (0);
var G__12465 = (0);
seq__12373_12441 = G__12462;
chunk__12374_12442 = G__12463;
count__12375_12443 = G__12464;
i__12376_12444 = G__12465;
continue;
}
} else {
}
}
break;
}
} else {
}

nativestore.core.inform_tracker.call(null,store__$1,(function (){var obj12387 = {"root":[key_12436]};
return obj12387;
})());

nativestore.core.index_BANG_.call(null,self__.root,obj__$1);

var new_12466 = cljs.core.get.call(null,self__.root,key_12436);
var seq__12388_12467 = cljs.core.seq.call(null,names_12438);
var chunk__12389_12468 = null;
var count__12390_12469 = (0);
var i__12391_12470 = (0);
while(true){
if((i__12391_12470 < count__12390_12469)){
var iname_12471 = cljs.core._nth.call(null,chunk__12389_12468,i__12391_12470);
var idx_12472 = (self__.indices[iname_12471]);
var ikey_12473 = nativestore.core.key_fn.call(null,idx_12472).call(null,new_12466);
if(((ikey_12473 == null)) || (cljs.core._EQ_.call(null,ikey_12473,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12394 = cljs.core.name.call(null,iname_12471);
var obj12396 = {};
(obj12396[G__12394] = [ikey_12473,ikey_12473]);

return obj12396;
})());

nativestore.core.index_BANG_.call(null,idx_12472,new_12466);
}

var G__12474 = seq__12388_12467;
var G__12475 = chunk__12389_12468;
var G__12476 = count__12390_12469;
var G__12477 = (i__12391_12470 + (1));
seq__12388_12467 = G__12474;
chunk__12389_12468 = G__12475;
count__12390_12469 = G__12476;
i__12391_12470 = G__12477;
continue;
} else {
var temp__4425__auto___12478 = cljs.core.seq.call(null,seq__12388_12467);
if(temp__4425__auto___12478){
var seq__12388_12479__$1 = temp__4425__auto___12478;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12388_12479__$1)){
var c__6943__auto___12480 = cljs.core.chunk_first.call(null,seq__12388_12479__$1);
var G__12481 = cljs.core.chunk_rest.call(null,seq__12388_12479__$1);
var G__12482 = c__6943__auto___12480;
var G__12483 = cljs.core.count.call(null,c__6943__auto___12480);
var G__12484 = (0);
seq__12388_12467 = G__12481;
chunk__12389_12468 = G__12482;
count__12390_12469 = G__12483;
i__12391_12470 = G__12484;
continue;
} else {
var iname_12485 = cljs.core.first.call(null,seq__12388_12479__$1);
var idx_12486 = (self__.indices[iname_12485]);
var ikey_12487 = nativestore.core.key_fn.call(null,idx_12486).call(null,new_12466);
if(((ikey_12487 == null)) || (cljs.core._EQ_.call(null,ikey_12487,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12398 = cljs.core.name.call(null,iname_12485);
var obj12400 = {};
(obj12400[G__12398] = [ikey_12487,ikey_12487]);

return obj12400;
})());

nativestore.core.index_BANG_.call(null,idx_12486,new_12466);
}

var G__12490 = cljs.core.next.call(null,seq__12388_12479__$1);
var G__12491 = null;
var G__12492 = (0);
var G__12493 = (0);
seq__12388_12467 = G__12490;
chunk__12389_12468 = G__12491;
count__12390_12469 = G__12492;
i__12391_12470 = G__12493;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(nativestore.core._STAR_transaction_STAR_)){
nativestore.core._STAR_transaction_STAR_.push([new cljs.core.Keyword(null,"insert","insert",1286475395),oldref_12440,new_12466]);
} else {
cljs.core._notify_watches.call(null,store__$1,null,[[new cljs.core.Keyword(null,"insert","insert",1286475395),oldref_12440,new_12466]]);
}

return store__$1;
})();
if(cljs.core.truth_(parent_shadow__11979__auto__)){
} else {
var dmap__11983__auto___12494 = derive.core.dependencies.call(null,derive.core._STAR_tracker_STAR_);
handler__11980__auto__.call(null,result__11982__auto__,dmap__11983__auto___12494);
}

return result__11982__auto__;
}finally {derive.core._STAR_shadow_STAR_ = _STAR_shadow_STAR_12372;

derive.core._STAR_tracker_STAR_ = _STAR_tracker_STAR_12371;
}});

nativestore.core.NativeStore.prototype.nativestore$core$IStore$delete_BANG_$arity$2 = (function (store,id){
var self__ = this;
var store__$1 = this;
var parent_shadow__11979__auto__ = derive.core._STAR_shadow_STAR_;
var handler__11980__auto__ = nativestore.core.update_listeners;
var shadow_QMARK___11981__auto__ = null;
var _STAR_tracker_STAR_12401 = derive.core._STAR_tracker_STAR_;
var _STAR_shadow_STAR_12402 = derive.core._STAR_shadow_STAR_;
derive.core._STAR_tracker_STAR_ = (cljs.core.truth_(derive.core._STAR_shadow_STAR_)?derive.core._STAR_tracker_STAR_:derive.core.default_tracker.call(null));

derive.core._STAR_shadow_STAR_ = (function (){var or__6140__auto__ = derive.core._STAR_shadow_STAR_;
if(cljs.core.truth_(or__6140__auto__)){
return or__6140__auto__;
} else {
return shadow_QMARK___11981__auto__;
}
})();

try{var result__11982__auto__ = (function (){
var temp__4425__auto___12495 = cljs.core.get.call(null,self__.root,id);
if(cljs.core.truth_(temp__4425__auto___12495)){
var old_12496 = temp__4425__auto___12495;
var seq__12403_12497 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,self__.indices));
var chunk__12404_12498 = null;
var count__12405_12499 = (0);
var i__12406_12500 = (0);
while(true){
if((i__12406_12500 < count__12405_12499)){
var iname_12501 = cljs.core._nth.call(null,chunk__12404_12498,i__12406_12500);
var idx_12502 = (self__.indices[iname_12501]);
var ikey_12503 = nativestore.core.key_fn.call(null,idx_12502).call(null,old_12496);
if(((ikey_12503 == null)) || (cljs.core._EQ_.call(null,ikey_12503,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12407 = cljs.core.name.call(null,iname_12501);
var obj12409 = {};
(obj12409[G__12407] = [ikey_12503,ikey_12503]);

return obj12409;
})());

nativestore.core.unindex_BANG_.call(null,idx_12502,old_12496);
}

var G__12507 = seq__12403_12497;
var G__12508 = chunk__12404_12498;
var G__12509 = count__12405_12499;
var G__12510 = (i__12406_12500 + (1));
seq__12403_12497 = G__12507;
chunk__12404_12498 = G__12508;
count__12405_12499 = G__12509;
i__12406_12500 = G__12510;
continue;
} else {
var temp__4425__auto___12511__$1 = cljs.core.seq.call(null,seq__12403_12497);
if(temp__4425__auto___12511__$1){
var seq__12403_12513__$1 = temp__4425__auto___12511__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12403_12513__$1)){
var c__6943__auto___12514 = cljs.core.chunk_first.call(null,seq__12403_12513__$1);
var G__12515 = cljs.core.chunk_rest.call(null,seq__12403_12513__$1);
var G__12516 = c__6943__auto___12514;
var G__12517 = cljs.core.count.call(null,c__6943__auto___12514);
var G__12518 = (0);
seq__12403_12497 = G__12515;
chunk__12404_12498 = G__12516;
count__12405_12499 = G__12517;
i__12406_12500 = G__12518;
continue;
} else {
var iname_12519 = cljs.core.first.call(null,seq__12403_12513__$1);
var idx_12520 = (self__.indices[iname_12519]);
var ikey_12521 = nativestore.core.key_fn.call(null,idx_12520).call(null,old_12496);
if(((ikey_12521 == null)) || (cljs.core._EQ_.call(null,ikey_12521,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12412 = cljs.core.name.call(null,iname_12519);
var obj12414 = {};
(obj12414[G__12412] = [ikey_12521,ikey_12521]);

return obj12414;
})());

nativestore.core.unindex_BANG_.call(null,idx_12520,old_12496);
}

var G__12522 = cljs.core.next.call(null,seq__12403_12513__$1);
var G__12523 = null;
var G__12524 = (0);
var G__12525 = (0);
seq__12403_12497 = G__12522;
chunk__12404_12498 = G__12523;
count__12405_12499 = G__12524;
i__12406_12500 = G__12525;
continue;
}
} else {
}
}
break;
}

nativestore.core.inform_tracker.call(null,store__$1,(function (){var obj12416 = {"root":[id]};
return obj12416;
})());

nativestore.core.unindex_BANG_.call(null,self__.root,old_12496);

if(cljs.core.truth_(nativestore.core._STAR_transaction_STAR_)){
nativestore.core._STAR_transaction_STAR_.push([new cljs.core.Keyword(null,"delete","delete",-1768633620),old_12496]);
} else {
cljs.core._notify_watches.call(null,store__$1,null,[new cljs.core.Keyword(null,"delete","delete",-1768633620),old_12496]);
}
} else {
}

return store__$1;
})()
;
if(cljs.core.truth_(parent_shadow__11979__auto__)){
} else {
var dmap__11983__auto___12526 = derive.core.dependencies.call(null,derive.core._STAR_tracker_STAR_);
handler__11980__auto__.call(null,result__11982__auto__,dmap__11983__auto___12526);
}

return result__11982__auto__;
}finally {derive.core._STAR_shadow_STAR_ = _STAR_shadow_STAR_12402;

derive.core._STAR_tracker_STAR_ = _STAR_tracker_STAR_12401;
}});

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$add_index_BANG_$arity$3 = (function (store,iname,index){
var self__ = this;
var store__$1 = this;
if(cljs.core.not.call(null,nativestore.core.get_index.call(null,store__$1,iname))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"get-index","get-index",2080583133,null),new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"iname","iname",-1981846785,null)))))].join('')));
}

nativestore.core.js_assoc.call(null,self__.indices,iname,index);

return store__$1;
});

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$rem_index_BANG_$arity$2 = (function (store,iname){
var self__ = this;
var store__$1 = this;
if(cljs.core.truth_(nativestore.core.get_index.call(null,store__$1,iname))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"get-index","get-index",2080583133,null),new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"iname","iname",-1981846785,null))))].join('')));
}

nativestore.core.js_dissoc.call(null,self__.indices,iname);

return store__$1;
});

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$get_index$arity$2 = (function (store,iname){
var self__ = this;
var store__$1 = this;
if((typeof iname === 'string') || ((iname instanceof cljs.core.Keyword))){
return nativestore.core.js_lookup.call(null,self__.indices,cljs.core.name.call(null,iname));
} else {
return iname;
}
});

nativestore.core.NativeStore.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (store,_,txs){
var self__ = this;
var store__$1 = this;
var seq__12419_12530 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,self__.tx_listeners));
var chunk__12420_12531 = null;
var count__12421_12532 = (0);
var i__12422_12533 = (0);
while(true){
if((i__12422_12533 < count__12421_12532)){
var name_12534 = cljs.core._nth.call(null,chunk__12420_12531,i__12422_12533);
var listener_12535 = (self__.tx_listeners[name_12534]);
listener_12535.call(null,null,txs);

var G__12536 = seq__12419_12530;
var G__12537 = chunk__12420_12531;
var G__12538 = count__12421_12532;
var G__12539 = (i__12422_12533 + (1));
seq__12419_12530 = G__12536;
chunk__12420_12531 = G__12537;
count__12421_12532 = G__12538;
i__12422_12533 = G__12539;
continue;
} else {
var temp__4425__auto___12540 = cljs.core.seq.call(null,seq__12419_12530);
if(temp__4425__auto___12540){
var seq__12419_12541__$1 = temp__4425__auto___12540;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12419_12541__$1)){
var c__6943__auto___12542 = cljs.core.chunk_first.call(null,seq__12419_12541__$1);
var G__12543 = cljs.core.chunk_rest.call(null,seq__12419_12541__$1);
var G__12544 = c__6943__auto___12542;
var G__12545 = cljs.core.count.call(null,c__6943__auto___12542);
var G__12546 = (0);
seq__12419_12530 = G__12543;
chunk__12420_12531 = G__12544;
count__12421_12532 = G__12545;
i__12422_12533 = G__12546;
continue;
} else {
var name_12547 = cljs.core.first.call(null,seq__12419_12541__$1);
var listener_12549 = (self__.tx_listeners[name_12547]);
listener_12549.call(null,null,txs);

var G__12550 = cljs.core.next.call(null,seq__12419_12541__$1);
var G__12551 = null;
var G__12552 = (0);
var G__12553 = (0);
seq__12419_12530 = G__12550;
chunk__12420_12531 = G__12551;
count__12421_12532 = G__12552;
i__12422_12533 = G__12553;
continue;
}
} else {
}
}
break;
}

return store__$1;
});

nativestore.core.NativeStore.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (store,key,f){
var self__ = this;
var store__$1 = this;
nativestore.core.js_assoc.call(null,self__.tx_listeners,key,f);

return store__$1;
});

nativestore.core.NativeStore.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (store,key){
var self__ = this;
var store__$1 = this;
nativestore.core.js_dissoc.call(null,self__.tx_listeners,key);

return store__$1;
});

nativestore.core.NativeStore.prototype.call = (function() {
var G__12554 = null;
var G__12554__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var store = self____$1;
return cljs.core._lookup.call(null,store,k,null);
});
var G__12554__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var store = self____$1;
return cljs.core._lookup.call(null,store,k,not_found);
});
G__12554 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12554__2.call(this,self__,k);
case 3:
return G__12554__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12554.cljs$core$IFn$_invoke$arity$2 = G__12554__2;
G__12554.cljs$core$IFn$_invoke$arity$3 = G__12554__3;
return G__12554;
})()
;

nativestore.core.NativeStore.prototype.apply = (function (self__,args12365){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12365)));
});

nativestore.core.NativeStore.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var store = this;
return cljs.core._lookup.call(null,store,k,null);
});

nativestore.core.NativeStore.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var store = this;
return cljs.core._lookup.call(null,store,k,not_found);
});

nativestore.core.NativeStore.prototype.nativestore$core$IClearable$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$IClearable$clear_BANG_$arity$1 = (function (store){
var self__ = this;
var store__$1 = this;
derive.core.force_invalidation.call(null,store__$1);

var seq__12423_12555 = cljs.core.seq.call(null,cljs.core.seq.call(null,nativestore.core._get_cursor.call(null,self__.root)));
var chunk__12424_12556 = null;
var count__12425_12557 = (0);
var i__12426_12558 = (0);
while(true){
if((i__12426_12558 < count__12425_12557)){
var obj_12559 = cljs.core._nth.call(null,chunk__12424_12556,i__12426_12558);
nativestore.core.delete_BANG_.call(null,store__$1,nativestore.core.key_fn.call(null,self__.root).call(null,obj_12559));

var G__12560 = seq__12423_12555;
var G__12561 = chunk__12424_12556;
var G__12562 = count__12425_12557;
var G__12563 = (i__12426_12558 + (1));
seq__12423_12555 = G__12560;
chunk__12424_12556 = G__12561;
count__12425_12557 = G__12562;
i__12426_12558 = G__12563;
continue;
} else {
var temp__4425__auto___12564 = cljs.core.seq.call(null,seq__12423_12555);
if(temp__4425__auto___12564){
var seq__12423_12565__$1 = temp__4425__auto___12564;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12423_12565__$1)){
var c__6943__auto___12566 = cljs.core.chunk_first.call(null,seq__12423_12565__$1);
var G__12567 = cljs.core.chunk_rest.call(null,seq__12423_12565__$1);
var G__12568 = c__6943__auto___12566;
var G__12569 = cljs.core.count.call(null,c__6943__auto___12566);
var G__12570 = (0);
seq__12423_12555 = G__12567;
chunk__12424_12556 = G__12568;
count__12425_12557 = G__12569;
i__12426_12558 = G__12570;
continue;
} else {
var obj_12571 = cljs.core.first.call(null,seq__12423_12565__$1);
nativestore.core.delete_BANG_.call(null,store__$1,nativestore.core.key_fn.call(null,self__.root).call(null,obj_12571));

var G__12572 = cljs.core.next.call(null,seq__12423_12565__$1);
var G__12573 = null;
var G__12574 = (0);
var G__12575 = (0);
seq__12423_12555 = G__12572;
chunk__12424_12556 = G__12573;
count__12425_12557 = G__12574;
i__12426_12558 = G__12575;
continue;
}
} else {
}
}
break;
}

var seq__12430_12576 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,self__.indices));
var chunk__12431_12577 = null;
var count__12432_12578 = (0);
var i__12433_12579 = (0);
while(true){
if((i__12433_12579 < count__12432_12578)){
var iname_12580 = cljs.core._nth.call(null,chunk__12431_12577,i__12433_12579);
nativestore.core.clear_BANG_.call(null,(self__.indices[iname_12580]));

var G__12581 = seq__12430_12576;
var G__12582 = chunk__12431_12577;
var G__12583 = count__12432_12578;
var G__12584 = (i__12433_12579 + (1));
seq__12430_12576 = G__12581;
chunk__12431_12577 = G__12582;
count__12432_12578 = G__12583;
i__12433_12579 = G__12584;
continue;
} else {
var temp__4425__auto___12585 = cljs.core.seq.call(null,seq__12430_12576);
if(temp__4425__auto___12585){
var seq__12430_12586__$1 = temp__4425__auto___12585;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12430_12586__$1)){
var c__6943__auto___12587 = cljs.core.chunk_first.call(null,seq__12430_12586__$1);
var G__12588 = cljs.core.chunk_rest.call(null,seq__12430_12586__$1);
var G__12589 = c__6943__auto___12587;
var G__12590 = cljs.core.count.call(null,c__6943__auto___12587);
var G__12591 = (0);
seq__12430_12576 = G__12588;
chunk__12431_12577 = G__12589;
count__12432_12578 = G__12590;
i__12433_12579 = G__12591;
continue;
} else {
var iname_12592 = cljs.core.first.call(null,seq__12430_12586__$1);
nativestore.core.clear_BANG_.call(null,(self__.indices[iname_12592]));

var G__12593 = cljs.core.next.call(null,seq__12430_12586__$1);
var G__12594 = null;
var G__12595 = (0);
var G__12596 = (0);
seq__12430_12576 = G__12593;
chunk__12431_12577 = G__12594;
count__12432_12578 = G__12595;
i__12433_12579 = G__12596;
continue;
}
} else {
}
}
break;
}

nativestore.core.clear_BANG_.call(null,self__.root);

return store__$1;
});

nativestore.core.NativeStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"indices","indices",422393184,null),new cljs.core.Symbol(null,"tx-listeners","tx-listeners",-491786474,null),cljs.core.with_meta(new cljs.core.Symbol(null,"listeners","listeners",2035075972,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

nativestore.core.NativeStore.cljs$lang$type = true;

nativestore.core.NativeStore.cljs$lang$ctorStr = "nativestore.core/NativeStore";

nativestore.core.NativeStore.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"nativestore.core/NativeStore");
});

nativestore.core.__GT_NativeStore = (function nativestore$core$__GT_NativeStore(root,indices,tx_listeners,listeners){
return (new nativestore.core.NativeStore(root,indices,tx_listeners,listeners));
});

nativestore.core.transact_BANG_ = (function nativestore$core$transact_BANG_(var_args){
var args__7205__auto__ = [];
var len__7198__auto___12600 = arguments.length;
var i__7199__auto___12601 = (0);
while(true){
if((i__7199__auto___12601 < len__7198__auto___12600)){
args__7205__auto__.push((arguments[i__7199__auto___12601]));

var G__12605 = (i__7199__auto___12601 + (1));
i__7199__auto___12601 = G__12605;
continue;
} else {
}
break;
}

var argseq__7206__auto__ = ((((2) < args__7205__auto__.length))?(new cljs.core.IndexedSeq(args__7205__auto__.slice((2)),(0))):null);
return nativestore.core.transact_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7206__auto__);
});

nativestore.core.transact_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (store,f,args){
return nativestore.core._transact_BANG_.call(null,store,f,args);
});

nativestore.core.transact_BANG_.cljs$lang$maxFixedArity = (2);

nativestore.core.transact_BANG_.cljs$lang$applyTo = (function (seq12597){
var G__12598 = cljs.core.first.call(null,seq12597);
var seq12597__$1 = cljs.core.next.call(null,seq12597);
var G__12599 = cljs.core.first.call(null,seq12597__$1);
var seq12597__$2 = cljs.core.next.call(null,seq12597__$1);
return nativestore.core.transact_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12598,G__12599,seq12597__$2);
});
nativestore.core.create = (function nativestore$core$create(){
return (new nativestore.core.NativeStore(nativestore.core.root_index.call(null),{},{},cljs.core.PersistentArrayMap.EMPTY));
});
nativestore.core.fetch = (function nativestore$core$fetch(var_args){
var args12610 = [];
var len__7198__auto___12615 = arguments.length;
var i__7199__auto___12616 = (0);
while(true){
if((i__7199__auto___12616 < len__7198__auto___12615)){
args12610.push((arguments[i__7199__auto___12616]));

var G__12617 = (i__7199__auto___12616 + (1));
i__7199__auto___12616 = G__12617;
continue;
} else {
}
break;
}

var G__12613 = args12610.length;
switch (G__12613) {
case 2:
return nativestore.core.fetch.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.fetch.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12610.length)].join('')));

}
});

nativestore.core.fetch.cljs$core$IFn$_invoke$arity$2 = (function (store,key){
return cljs.core.get.call(null,store,key);
});

nativestore.core.fetch.cljs$core$IFn$_invoke$arity$3 = (function (store,index,key){
return cljs.core.get.call(null,nativestore.core.get_index.call(null,store,index),key);
});

nativestore.core.fetch.cljs$lang$maxFixedArity = 3;
nativestore.core.first_val = (function nativestore$core$first_val(idx){
return nativestore.core.key_fn.call(null,idx).call(null,(idx.arry[(0)]));
});
nativestore.core.last_val = (function nativestore$core$last_val(idx){
return nativestore.core.key_fn.call(null,idx).call(null,(idx.arry[(idx.arry.length - (1))]));
});
/**
 * Walk the entire store, or an index
 */
nativestore.core.cursor = (function nativestore$core$cursor(var_args){
var args12620 = [];
var len__7198__auto___12630 = arguments.length;
var i__7199__auto___12631 = (0);
while(true){
if((i__7199__auto___12631 < len__7198__auto___12630)){
args12620.push((arguments[i__7199__auto___12631]));

var G__12632 = (i__7199__auto___12631 + (1));
i__7199__auto___12631 = G__12632;
continue;
} else {
}
break;
}

var G__12623 = args12620.length;
switch (G__12623) {
case 1:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12620.length)].join('')));

}
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$1 = (function (store){
return nativestore.core._get_cursor.call(null,store.root);
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$2 = (function (store,index){
var iname = cljs.core.name.call(null,index);
var index__$1 = nativestore.core.get_index.call(null,store,iname);
if(cljs.core.truth_(index__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Index "),cljs.core.str(iname),cljs.core.str(" is not defined.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"index","index",108845612,null)))].join('')));
}

nativestore.core.inform_tracker.call(null,store,(function (){var obj12625 = {};
(obj12625[iname] = []);

return obj12625;
})());

return nativestore.core._get_cursor.call(null,index__$1);
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$3 = (function (store,index,start){
var iname = cljs.core.name.call(null,index);
var index__$1 = nativestore.core.get_index.call(null,store,index);
if(cljs.core.truth_(index__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Index "),cljs.core.str(iname),cljs.core.str(" is not defined.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"index","index",108845612,null)))].join('')));
}

nativestore.core.inform_tracker.call(null,store,(function (){var obj12627 = {};
(obj12627[iname] = [start]);

return obj12627;
})());

return nativestore.core._get_cursor.call(null,index__$1,start);
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$4 = (function (store,index,start,end){
var iname = cljs.core.name.call(null,index);
var index__$1 = nativestore.core.get_index.call(null,store,index);
if(cljs.core.truth_(index__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Index "),cljs.core.str(iname),cljs.core.str(" is not defined.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"index","index",108845612,null)))].join('')));
}

nativestore.core.inform_tracker.call(null,store,(function (){var obj12629 = {};
(obj12629[iname] = [start,end]);

return obj12629;
})());

return nativestore.core._get_cursor.call(null,index__$1,start,end);
});

nativestore.core.cursor.cljs$lang$maxFixedArity = 4;
nativestore.core.field_key = (function nativestore$core$field_key(field){
var f = cljs.core.name.call(null,field);
return ((function (f){
return (function (obj){
return (obj[f]);
});
;})(f))
});
nativestore.core.type_field_key = (function nativestore$core$type_field_key(type,field){
var t = cljs.core.name.call(null,type);
var f = cljs.core.name.call(null,field);
return ((function (t,f){
return (function (obj){
if(cljs.core._EQ_.call(null,t,(obj["type"]))){
return (obj[f]);
} else {
return null;
}
});
;})(t,f))
});
nativestore.core.ensure_index = (function nativestore$core$ensure_index(var_args){
var args12636 = [];
var len__7198__auto___12642 = arguments.length;
var i__7199__auto___12643 = (0);
while(true){
if((i__7199__auto___12643 < len__7198__auto___12642)){
args12636.push((arguments[i__7199__auto___12643]));

var G__12644 = (i__7199__auto___12643 + (1));
i__7199__auto___12643 = G__12644;
continue;
} else {
}
break;
}

var G__12640 = args12636.length;
switch (G__12640) {
case 4:
return nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12636.length)].join('')));

}
});

nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$4 = (function (store,iname,key,comp){
if(cljs.core.truth_(nativestore.core.get_index.call(null,store,iname))){
return null;
} else {
return nativestore.core.add_index_BANG_.call(null,store,iname,nativestore.core.ordered_index.call(null,((cljs.core.fn_QMARK_.call(null,key))?key:nativestore.core.field_key.call(null,key)),comp));
}
});

nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$3 = (function (store,iname,key_or_idx){
if(((key_or_idx instanceof cljs.core.Keyword)) || ((key_or_idx instanceof cljs.core.Symbol))){
return nativestore.core.ensure_index.call(null,store,iname,key_or_idx,cljs.core.compare);
} else {
if(cljs.core.truth_(nativestore.core.get_index.call(null,store,iname))){
return null;
} else {
return nativestore.core.add_index_BANG_.call(null,store,iname,key_or_idx);
}
}
});

nativestore.core.ensure_index.cljs$lang$maxFixedArity = 4;
