// Compiled by ClojureScript 1.7.228 {}
goog.provide('derive.core');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Dependency tracker that is informed of encountered dependencies
 */
derive.core._STAR_tracker_STAR_ = null;
/**
 * Whether a dependency tracker should shadow lower level, used to
 *           implement stores
 */
derive.core._STAR_shadow_STAR_ = null;

/**
 * An immutable set of dependencies. Passed to dependency trackers
 *   during queries via record-dependency.
 * @interface
 */
derive.core.IDependencySet = function(){};

/**
 * Merge two dependencies
 */
derive.core.merge_deps = (function derive$core$merge_deps(this$,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySet$merge_deps$arity$2 == null)))){
return this$.derive$core$IDependencySet$merge_deps$arity$2(this$,deps);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.merge_deps[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,deps);
} else {
var m__6796__auto____$1 = (derive.core.merge_deps["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySet.merge-deps",this$);
}
}
}
});

/**
 * Match the current set to an incoming set - intersection semantics
 */
derive.core.match_deps = (function derive$core$match_deps(this$,set){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySet$match_deps$arity$2 == null)))){
return this$.derive$core$IDependencySet$match_deps$arity$2(this$,set);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.match_deps[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,set);
} else {
var m__6796__auto____$1 = (derive.core.match_deps["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,set);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySet.match-deps",this$);
}
}
}
});


/**
 * This interface is implemented by databases and derive methods to allow callers to
 * subscribe to subset of changes identified by the provided dependency set
 * @interface
 */
derive.core.IDependencySource = function(){};

/**
 * Call tracker method when deps match a change operation
 */
derive.core.subscribe_BANG_ = (function derive$core$subscribe_BANG_(var_args){
var args11340 = [];
var len__7198__auto___11380 = arguments.length;
var i__7199__auto___11381 = (0);
while(true){
if((i__7199__auto___11381 < len__7198__auto___11380)){
args11340.push((arguments[i__7199__auto___11381]));

var G__11382 = (i__7199__auto___11381 + (1));
i__7199__auto___11381 = G__11382;
continue;
} else {
}
break;
}

var G__11346 = args11340.length;
switch (G__11346) {
case 2:
return derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11340.length)].join('')));

}
});

derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,listener){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$subscribe_BANG_$arity$2 == null)))){
return this$.derive$core$IDependencySource$subscribe_BANG_$arity$2(this$,listener);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.subscribe_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,listener);
} else {
var m__6796__auto____$1 = (derive.core.subscribe_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,listener);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.subscribe!",this$);
}
}
}
});

derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,listener,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$subscribe_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencySource$subscribe_BANG_$arity$3(this$,listener,deps);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.subscribe_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,listener,deps);
} else {
var m__6796__auto____$1 = (derive.core.subscribe_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,listener,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.subscribe!",this$);
}
}
}
});

derive.core.subscribe_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Call tracker method when deps match a change operation
 */
derive.core.unsubscribe_BANG_ = (function derive$core$unsubscribe_BANG_(var_args){
var args11353 = [];
var len__7198__auto___11402 = arguments.length;
var i__7199__auto___11403 = (0);
while(true){
if((i__7199__auto___11403 < len__7198__auto___11402)){
args11353.push((arguments[i__7199__auto___11403]));

var G__11405 = (i__7199__auto___11403 + (1));
i__7199__auto___11403 = G__11405;
continue;
} else {
}
break;
}

var G__11360 = args11353.length;
switch (G__11360) {
case 2:
return derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11353.length)].join('')));

}
});

derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,listener){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$2 == null)))){
return this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$2(this$,listener);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.unsubscribe_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,listener);
} else {
var m__6796__auto____$1 = (derive.core.unsubscribe_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,listener);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.unsubscribe!",this$);
}
}
}
});

derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,listener,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$3(this$,listener,deps);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.unsubscribe_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,listener,deps);
} else {
var m__6796__auto____$1 = (derive.core.unsubscribe_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,listener,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.unsubscribe!",this$);
}
}
}
});

derive.core.unsubscribe_BANG_.cljs$lang$maxFixedArity = 3;

derive.core.empty_deps = (function derive$core$empty_deps(this$){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$empty_deps$arity$1 == null)))){
return this$.derive$core$IDependencySource$empty_deps$arity$1(this$);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.empty_deps[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$);
} else {
var m__6796__auto____$1 = (derive.core.empty_deps["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.empty-deps",this$);
}
}
}
});


/**
 * Implemented by function and component caches
 * @interface
 */
derive.core.IDependencyTracker = function(){};

/**
 * Dependency sources call this method if a tracker is bound in the current
 *   context with dependencies that are encountered during query processing.
 */
derive.core.depends_BANG_ = (function derive$core$depends_BANG_(this$,store,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyTracker$depends_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencyTracker$depends_BANG_$arity$3(this$,store,deps);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.depends_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,store,deps);
} else {
var m__6796__auto____$1 = (derive.core.depends_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,store,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyTracker.depends!",this$);
}
}
}
});

/**
 * The current dependencies encountered by this tracker
 */
derive.core.dependencies = (function derive$core$dependencies(this$){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyTracker$dependencies$arity$1 == null)))){
return this$.derive$core$IDependencyTracker$dependencies$arity$1(this$);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.dependencies[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$);
} else {
var m__6796__auto____$1 = (derive.core.dependencies["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyTracker.dependencies",this$);
}
}
}
});


/**
 * A utility API for tracking dependencies, allows us to provide more
 * advanced options for assembling tracker policies
 * @interface
 */
derive.core.IDependencyCache = function(){};

/**
 * Clear cache
 */
derive.core.reset_BANG_ = (function derive$core$reset_BANG_(this$){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$reset_BANG_$arity$1 == null)))){
return this$.derive$core$IDependencyCache$reset_BANG_$arity$1(this$);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.reset_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$);
} else {
var m__6796__auto____$1 = (derive.core.reset_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.reset!",this$);
}
}
}
});

/**
 * Returns cached value if exists for params
 */
derive.core.get_value = (function derive$core$get_value(this$,params){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$get_value$arity$2 == null)))){
return this$.derive$core$IDependencyCache$get_value$arity$2(this$,params);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.get_value[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,params);
} else {
var m__6796__auto____$1 = (derive.core.get_value["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,params);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.get-value",this$);
}
}
}
});

/**
 * Informs store that a particular params yeilds value given current store + deps
 */
derive.core.add_value_BANG_ = (function derive$core$add_value_BANG_(this$,params,value,dependency_map){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$add_value_BANG_$arity$4 == null)))){
return this$.derive$core$IDependencyCache$add_value_BANG_$arity$4(this$,params,value,dependency_map);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.add_value_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,params,value,dependency_map);
} else {
var m__6796__auto____$1 = (derive.core.add_value_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,params,value,dependency_map);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.add-value!",this$);
}
}
}
});

derive.core.rem_value_BANG_ = (function derive$core$rem_value_BANG_(this$,params){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$rem_value_BANG_$arity$2 == null)))){
return this$.derive$core$IDependencyCache$rem_value_BANG_$arity$2(this$,params);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.rem_value_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,params);
} else {
var m__6796__auto____$1 = (derive.core.rem_value_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,params);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.rem-value!",this$);
}
}
}
});

derive.core.invalidate_BANG_ = (function derive$core$invalidate_BANG_(this$,store,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$invalidate_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencyCache$invalidate_BANG_$arity$3(this$,store,deps);
} else {
var x__6795__auto__ = (((this$ == null))?null:this$);
var m__6796__auto__ = (derive.core.invalidate_BANG_[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,this$,store,deps);
} else {
var m__6796__auto____$1 = (derive.core.invalidate_BANG_["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,this$,store,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.invalidate!",this$);
}
}
}
});

cljs.core.PersistentHashSet.prototype.derive$core$IDependencySet$ = true;

cljs.core.PersistentHashSet.prototype.derive$core$IDependencySet$merge_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return clojure.set.union.call(null,this$__$1,deps);
});

cljs.core.PersistentHashSet.prototype.derive$core$IDependencySet$match_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return ((deps == null)) || (!(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,this$__$1,deps))));
});

cljs.core.PersistentTreeSet.prototype.derive$core$IDependencySet$ = true;

cljs.core.PersistentTreeSet.prototype.derive$core$IDependencySet$merge_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return clojure.set.union.call(null,this$__$1,deps);
});

cljs.core.PersistentTreeSet.prototype.derive$core$IDependencySet$match_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return ((deps == null)) || (!(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,this$__$1,deps))));
});
derive.core.matching_dep_QMARK_ = (function derive$core$matching_dep_QMARK_(dmap,store,deps){
return cljs.core.some.call(null,(function (p__11494){
var vec__11495 = p__11494;
var vstore = cljs.core.nth.call(null,vec__11495,(0),null);
var vdeps = cljs.core.nth.call(null,vec__11495,(1),null);
var and__6128__auto__ = cljs.core._EQ_.call(null,store,vstore);
if(and__6128__auto__){
var or__6140__auto__ = (deps == null);
if(or__6140__auto__){
return or__6140__auto__;
} else {
var or__6140__auto____$1 = (vdeps == null);
if(or__6140__auto____$1){
return or__6140__auto____$1;
} else {
return derive.core.match_deps.call(null,vdeps,deps);
}
}
} else {
return and__6128__auto__;
}
}),dmap);
});

/**
* @constructor
 * @implements {derive.core.IDependencyCache}
*/
derive.core.DefaultCache = (function (cache){
this.cache = cache;
})
derive.core.DefaultCache.prototype.derive$core$IDependencyCache$ = true;

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$get_value$arity$2 = (function (_,params){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.cache,params);
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$add_value_BANG_$arity$4 = (function (this$,params,value,dmap){
var self__ = this;
var this$__$1 = this;
self__.cache = cljs.core.assoc.call(null,self__.cache,params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [value,dmap], null));

return this$__$1;
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$rem_value_BANG_$arity$2 = (function (this$,params){
var self__ = this;
var this$__$1 = this;
return self__.cache = cljs.core.dissoc.call(null,self__.cache,params);
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$invalidate_BANG_$arity$3 = (function (this$,store,deps){
var self__ = this;
var this$__$1 = this;
var vec__11507 = cljs.core.reduce.call(null,((function (this$__$1){
return (function (p__11508,p__11509){
var vec__11510 = p__11508;
var c = cljs.core.nth.call(null,vec__11510,(0),null);
var i = cljs.core.nth.call(null,vec__11510,(1),null);
var vec__11511 = p__11509;
var params = cljs.core.nth.call(null,vec__11511,(0),null);
var vec__11512 = cljs.core.nth.call(null,vec__11511,(1),null);
var value = cljs.core.nth.call(null,vec__11512,(0),null);
var dmap = cljs.core.nth.call(null,vec__11512,(1),null);
if(cljs.core.truth_(derive.core.matching_dep_QMARK_.call(null,dmap,store,deps))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.dissoc_BANG_.call(null,c,params),cljs.core.conj.call(null,i,params)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,i], null);
}
});})(this$__$1))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$.call(null,self__.cache),cljs.core.PersistentVector.EMPTY], null),self__.cache);
var c = cljs.core.nth.call(null,vec__11507,(0),null);
var invalidated = cljs.core.nth.call(null,vec__11507,(1),null);
self__.cache = cljs.core.persistent_BANG_.call(null,c);

return invalidated;
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$reset_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
self__.cache = cljs.core.PersistentArrayMap.EMPTY;

return this$__$1;
});

derive.core.DefaultCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

derive.core.DefaultCache.cljs$lang$type = true;

derive.core.DefaultCache.cljs$lang$ctorStr = "derive.core/DefaultCache";

derive.core.DefaultCache.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"derive.core/DefaultCache");
});

derive.core.__GT_DefaultCache = (function derive$core$__GT_DefaultCache(cache){
return (new derive.core.DefaultCache(cache));
});

derive.core.default_cache = (function derive$core$default_cache(){
return (new derive.core.DefaultCache(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {derive.core.IDependencyTracker}
*/
derive.core.DefaultTracker = (function (dmap){
this.dmap = dmap;
})
derive.core.DefaultTracker.prototype.derive$core$IDependencyTracker$ = true;

derive.core.DefaultTracker.prototype.derive$core$IDependencyTracker$depends_BANG_$arity$3 = (function (this$,store,new_deps){
var self__ = this;
var this$__$1 = this;
self__.dmap = cljs.core.update_in.call(null,self__.dmap,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [store], null),cljs.core.fnil.call(null,derive.core.merge_deps,derive.core.empty_deps.call(null,store)),new_deps);

return this$__$1;
});

derive.core.DefaultTracker.prototype.derive$core$IDependencyTracker$dependencies$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.dmap;
});

derive.core.DefaultTracker.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"dmap","dmap",-1773751947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

derive.core.DefaultTracker.cljs$lang$type = true;

derive.core.DefaultTracker.cljs$lang$ctorStr = "derive.core/DefaultTracker";

derive.core.DefaultTracker.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"derive.core/DefaultTracker");
});

derive.core.__GT_DefaultTracker = (function derive$core$__GT_DefaultTracker(dmap){
return (new derive.core.DefaultTracker(dmap));
});

derive.core.default_tracker = (function derive$core$default_tracker(var_args){
var args11542 = [];
var len__7198__auto___11554 = arguments.length;
var i__7199__auto___11555 = (0);
while(true){
if((i__7199__auto___11555 < len__7198__auto___11554)){
args11542.push((arguments[i__7199__auto___11555]));

var G__11556 = (i__7199__auto___11555 + (1));
i__7199__auto___11555 = G__11556;
continue;
} else {
}
break;
}

var G__11546 = args11542.length;
switch (G__11546) {
case 0:
return derive.core.default_tracker.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return derive.core.default_tracker.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11542.length)].join('')));

}
});

derive.core.default_tracker.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new derive.core.DefaultTracker(cljs.core.PersistentArrayMap.EMPTY));
});

derive.core.default_tracker.cljs$core$IFn$_invoke$arity$1 = (function (dmap){
return (new derive.core.DefaultTracker(dmap));
});

derive.core.default_tracker.cljs$lang$maxFixedArity = 1;
derive.core.tracking_QMARK_ = (function derive$core$tracking_QMARK_(){
return !((derive.core._STAR_tracker_STAR_ == null));
});
derive.core.inform_tracker = (function derive$core$inform_tracker(var_args){
var args11567 = [];
var len__7198__auto___11592 = arguments.length;
var i__7199__auto___11593 = (0);
while(true){
if((i__7199__auto___11593 < len__7198__auto___11592)){
args11567.push((arguments[i__7199__auto___11593]));

var G__11597 = (i__7199__auto___11593 + (1));
i__7199__auto___11593 = G__11597;
continue;
} else {
}
break;
}

var G__11581 = args11567.length;
switch (G__11581) {
case 2:
return derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11567.length)].join('')));

}
});

derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$2 = (function (store,args){
if(cljs.core.truth_(derive.core.tracking_QMARK_.call(null))){
return derive.core.inform_tracker.call(null,derive.core._STAR_tracker_STAR_,store,args);
} else {
return null;
}
});

derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$3 = (function (tracker,store,args){
return derive.core.depends_BANG_.call(null,tracker,store,((cljs.core.set_QMARK_.call(null,args))?args:cljs.core.PersistentHashSet.fromArray([args], true)));
});

derive.core.inform_tracker.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {derive.core.IDependencySource}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.Fn}
*/
derive.core.DeriveFn = (function (fname,dfn,lfn,subscriptions,cache,listeners){
this.fname = fname;
this.dfn = dfn;
this.lfn = lfn;
this.subscriptions = subscriptions;
this.cache = cache;
this.listeners = listeners;
this.cljs$lang$protocol_mask$partition0$ = 1;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
derive.core.DeriveFn.prototype.cljs$core$Fn$ = true;

derive.core.DeriveFn.prototype.call = (function() {
var G__11647 = null;
var G__11647__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return self__.dfn.call(null,this$);
});
var G__11647__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));

return self__.dfn.call(null,this$,a);
});
var G__11647__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null));

return self__.dfn.call(null,this$,a,b);
});
var G__11647__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c], null));

return self__.dfn.call(null,this$,a,b,c);
});
var G__11647__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d], null));

return self__.dfn.call(null,this$,a,b,c,d);
});
var G__11647__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e], null));

return self__.dfn.call(null,this$,a,b,c,d,e);
});
var G__11647__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f);
});
var G__11647__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g);
});
var G__11647__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h);
});
var G__11647__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i);
});
var G__11647__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j);
});
var G__11647__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
});
var G__11647__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__11647__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__11647__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__11647__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__11647__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__11647__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__11647__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__11647__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__11647__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__11647__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], null));

return cljs.core.apply.call(null,self__.dfn,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
});
G__11647 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__11647__1.call(this,self__);
case 2:
return G__11647__2.call(this,self__,a);
case 3:
return G__11647__3.call(this,self__,a,b);
case 4:
return G__11647__4.call(this,self__,a,b,c);
case 5:
return G__11647__5.call(this,self__,a,b,c,d);
case 6:
return G__11647__6.call(this,self__,a,b,c,d,e);
case 7:
return G__11647__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__11647__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__11647__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__11647__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__11647__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__11647__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__11647__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__11647__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__11647__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__11647__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__11647__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__11647__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__11647__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__11647__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__11647__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__11647__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11647.cljs$core$IFn$_invoke$arity$1 = G__11647__1;
G__11647.cljs$core$IFn$_invoke$arity$2 = G__11647__2;
G__11647.cljs$core$IFn$_invoke$arity$3 = G__11647__3;
G__11647.cljs$core$IFn$_invoke$arity$4 = G__11647__4;
G__11647.cljs$core$IFn$_invoke$arity$5 = G__11647__5;
G__11647.cljs$core$IFn$_invoke$arity$6 = G__11647__6;
G__11647.cljs$core$IFn$_invoke$arity$7 = G__11647__7;
G__11647.cljs$core$IFn$_invoke$arity$8 = G__11647__8;
G__11647.cljs$core$IFn$_invoke$arity$9 = G__11647__9;
G__11647.cljs$core$IFn$_invoke$arity$10 = G__11647__10;
G__11647.cljs$core$IFn$_invoke$arity$11 = G__11647__11;
G__11647.cljs$core$IFn$_invoke$arity$12 = G__11647__12;
G__11647.cljs$core$IFn$_invoke$arity$13 = G__11647__13;
G__11647.cljs$core$IFn$_invoke$arity$14 = G__11647__14;
G__11647.cljs$core$IFn$_invoke$arity$15 = G__11647__15;
G__11647.cljs$core$IFn$_invoke$arity$16 = G__11647__16;
G__11647.cljs$core$IFn$_invoke$arity$17 = G__11647__17;
G__11647.cljs$core$IFn$_invoke$arity$18 = G__11647__18;
G__11647.cljs$core$IFn$_invoke$arity$19 = G__11647__19;
G__11647.cljs$core$IFn$_invoke$arity$20 = G__11647__20;
G__11647.cljs$core$IFn$_invoke$arity$21 = G__11647__21;
G__11647.cljs$core$IFn$_invoke$arity$22 = G__11647__22;
return G__11647;
})()
;

derive.core.DeriveFn.prototype.apply = (function (self__,args11619){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args11619)));
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var this$ = this;
return self__.dfn.call(null,this$);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));

return self__.dfn.call(null,this$,a);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null));

return self__.dfn.call(null,this$,a,b);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c], null));

return self__.dfn.call(null,this$,a,b,c);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d], null));

return self__.dfn.call(null,this$,a,b,c,d);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e], null));

return self__.dfn.call(null,this$,a,b,c,d,e);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], null));

return cljs.core.apply.call(null,self__.dfn,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$ = true;

derive.core.DeriveFn.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deps], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),cljs.core.disj,listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deps], null),cljs.core.disj,listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$empty_deps$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.PersistentHashSet.EMPTY;
});

derive.core.DeriveFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fname","fname",-1154144278,null),new cljs.core.Symbol(null,"dfn","dfn",1882439694,null),new cljs.core.Symbol(null,"lfn","lfn",-813958040,null),cljs.core.with_meta(new cljs.core.Symbol(null,"subscriptions","subscriptions",-1403485993,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"listeners","listeners",2035075972,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

derive.core.DeriveFn.cljs$lang$type = true;

derive.core.DeriveFn.cljs$lang$ctorStr = "derive.core/DeriveFn";

derive.core.DeriveFn.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"derive.core/DeriveFn");
});

derive.core.__GT_DeriveFn = (function derive$core$__GT_DeriveFn(fname,dfn,lfn,subscriptions,cache,listeners){
return (new derive.core.DeriveFn(fname,dfn,lfn,subscriptions,cache,listeners));
});

/**
 * Only primitive values and clojure data stuctures are legal
 * (must support value equality)
 */
derive.core.legal_param_QMARK_ = (function derive$core$legal_param_QMARK_(val){
var or__6140__auto__ = typeof val === 'string';
if(or__6140__auto__){
return or__6140__auto__;
} else {
var or__6140__auto____$1 = typeof val === 'number';
if(or__6140__auto____$1){
return or__6140__auto____$1;
} else {
var or__6140__auto____$2 = (val instanceof cljs.core.Symbol);
if(or__6140__auto____$2){
return or__6140__auto____$2;
} else {
var or__6140__auto____$3 = (val instanceof cljs.core.Keyword);
if(or__6140__auto____$3){
return or__6140__auto____$3;
} else {
var or__6140__auto____$4 = cljs.core._EQ_.call(null,val,true);
if(or__6140__auto____$4){
return or__6140__auto____$4;
} else {
var or__6140__auto____$5 = cljs.core._EQ_.call(null,val,false);
if(or__6140__auto____$5){
return or__6140__auto____$5;
} else {
var or__6140__auto____$6 = cljs.core.map_QMARK_.call(null,val);
if(or__6140__auto____$6){
return or__6140__auto____$6;
} else {
var or__6140__auto____$7 = cljs.core.vector_QMARK_.call(null,val);
if(or__6140__auto____$7){
return or__6140__auto____$7;
} else {
var or__6140__auto____$8 = cljs.core.list_QMARK_.call(null,val);
if(or__6140__auto____$8){
return or__6140__auto____$8;
} else {
var or__6140__auto____$9 = (val == null);
if(or__6140__auto____$9){
return or__6140__auto____$9;
} else {
var or__6140__auto____$10 = ((!((val == null)))?(((false) || (val.derive$core$IDependencySource$))?true:(((!val.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,derive.core.IDependencySource,val):false)):cljs.core.native_satisfies_QMARK_.call(null,derive.core.IDependencySource,val));
if(or__6140__auto____$10){
return or__6140__auto____$10;
} else {
return (cljs.core._EQ_.call(null,cljs.core.type.call(null,val),cljs.core.type.call(null,(new Date())))) || ((!((void 0 === moment))) && (cljs.core._EQ_.call(null,cljs.core.type.call(null,val),cljs.core.type.call(null,moment()))));
}
}
}
}
}
}
}
}
}
}
}
});
derive.core.legal_params_QMARK_ = (function derive$core$legal_params_QMARK_(vals){
return cljs.core.every_QMARK_.call(null,derive.core.legal_param_QMARK_,vals);
});
derive.core.empty_derive_fn = (function derive$core$empty_derive_fn(var_args){
var args__7205__auto__ = [];
var len__7198__auto___11699 = arguments.length;
var i__7199__auto___11700 = (0);
while(true){
if((i__7199__auto___11700 < len__7198__auto___11699)){
args__7205__auto__.push((arguments[i__7199__auto___11700]));

var G__11701 = (i__7199__auto___11700 + (1));
i__7199__auto___11700 = G__11701;
continue;
} else {
}
break;
}

var argseq__7206__auto__ = ((((0) < args__7205__auto__.length))?(new cljs.core.IndexedSeq(args__7205__auto__.slice((0)),(0))):null);
return derive.core.empty_derive_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__7206__auto__);
});

derive.core.empty_derive_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Uninitialized derive fn"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,false))].join('')));

});

derive.core.empty_derive_fn.cljs$lang$maxFixedArity = (0);

derive.core.empty_derive_fn.cljs$lang$applyTo = (function (seq11697){
return derive.core.empty_derive_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11697));
});
derive.core.create_derive_fn = (function derive$core$create_derive_fn(fname){
return (new derive.core.DeriveFn(fname,derive.core.empty_derive_fn,derive.core.empty_derive_fn,cljs.core.PersistentHashSet.EMPTY,derive.core.default_cache.call(null),cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Ensure we're subscribed to stores we encounter
 */
derive.core.ensure_subscription = (function derive$core$ensure_subscription(derive__$1,store){
if(cljs.core.truth_(derive__$1.subscriptions.call(null,store))){
return null;
} else {
derive.core.subscribe_BANG_.call(null,store,derive__$1.lfn);

return derive__$1.subscriptions = cljs.core.conj.call(null,derive__$1.subscriptions,store);
}
});
derive.core.release_subscriptions = (function derive$core$release_subscriptions(derive__$1){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (p1__11709_SHARP_){
return derive.core.unsubscribe_BANG_.call(null,p1__11709_SHARP_,derive__$1.lfn);
}),derive__$1.subscriptions));
});
/**
 * Handle deps and cache values from normal calls
 */
derive.core.derive_value = (function derive$core$derive_value(derive__$1,params){
return cljs.core.first.call(null,derive.core.get_value.call(null,derive__$1.cache,params));
});
derive.core.tracker_handler = (function derive$core$tracker_handler(dfn,params){
return (function (result,dmap){
var seq__11716_11723 = cljs.core.seq.call(null,dmap);
var chunk__11717_11724 = null;
var count__11718_11725 = (0);
var i__11719_11726 = (0);
while(true){
if((i__11719_11726 < count__11718_11725)){
var vec__11720_11727 = cljs.core._nth.call(null,chunk__11717_11724,i__11719_11726);
var store_11728 = cljs.core.nth.call(null,vec__11720_11727,(0),null);
var deps_11729 = cljs.core.nth.call(null,vec__11720_11727,(1),null);
derive.core.ensure_subscription.call(null,dfn,store_11728);

var G__11730 = seq__11716_11723;
var G__11731 = chunk__11717_11724;
var G__11732 = count__11718_11725;
var G__11733 = (i__11719_11726 + (1));
seq__11716_11723 = G__11730;
chunk__11717_11724 = G__11731;
count__11718_11725 = G__11732;
i__11719_11726 = G__11733;
continue;
} else {
var temp__4425__auto___11734 = cljs.core.seq.call(null,seq__11716_11723);
if(temp__4425__auto___11734){
var seq__11716_11735__$1 = temp__4425__auto___11734;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11716_11735__$1)){
var c__6943__auto___11736 = cljs.core.chunk_first.call(null,seq__11716_11735__$1);
var G__11737 = cljs.core.chunk_rest.call(null,seq__11716_11735__$1);
var G__11738 = c__6943__auto___11736;
var G__11739 = cljs.core.count.call(null,c__6943__auto___11736);
var G__11740 = (0);
seq__11716_11723 = G__11737;
chunk__11717_11724 = G__11738;
count__11718_11725 = G__11739;
i__11719_11726 = G__11740;
continue;
} else {
var vec__11722_11741 = cljs.core.first.call(null,seq__11716_11735__$1);
var store_11742 = cljs.core.nth.call(null,vec__11722_11741,(0),null);
var deps_11743 = cljs.core.nth.call(null,vec__11722_11741,(1),null);
derive.core.ensure_subscription.call(null,dfn,store_11742);

var G__11744 = cljs.core.next.call(null,seq__11716_11735__$1);
var G__11745 = null;
var G__11746 = (0);
var G__11747 = (0);
seq__11716_11723 = G__11744;
chunk__11717_11724 = G__11745;
count__11718_11725 = G__11746;
i__11719_11726 = G__11747;
continue;
}
} else {
}
}
break;
}

return derive.core.add_value_BANG_.call(null,dfn.cache,params,result,dmap);
});
});
derive.core.notify_listeners = (function derive$core$notify_listeners(store,deps){
var listeners = store.listeners;
var seq__11762 = cljs.core.seq.call(null,cljs.core.keys.call(null,listeners));
var chunk__11764 = null;
var count__11765 = (0);
var i__11766 = (0);
while(true){
if((i__11766 < count__11765)){
var ldeps = cljs.core._nth.call(null,chunk__11764,i__11766);
if(cljs.core.truth_((function (){var or__6140__auto__ = (ldeps == null);
if(or__6140__auto__){
return or__6140__auto__;
} else {
return derive.core.match_deps.call(null,ldeps,deps);
}
})())){
var seq__11768_11776 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11769_11777 = null;
var count__11770_11778 = (0);
var i__11771_11779 = (0);
while(true){
if((i__11771_11779 < count__11770_11778)){
var l_11780 = cljs.core._nth.call(null,chunk__11769_11777,i__11771_11779);
l_11780.call(null,store,deps);

var G__11781 = seq__11768_11776;
var G__11782 = chunk__11769_11777;
var G__11783 = count__11770_11778;
var G__11784 = (i__11771_11779 + (1));
seq__11768_11776 = G__11781;
chunk__11769_11777 = G__11782;
count__11770_11778 = G__11783;
i__11771_11779 = G__11784;
continue;
} else {
var temp__4425__auto___11785 = cljs.core.seq.call(null,seq__11768_11776);
if(temp__4425__auto___11785){
var seq__11768_11786__$1 = temp__4425__auto___11785;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11768_11786__$1)){
var c__6943__auto___11787 = cljs.core.chunk_first.call(null,seq__11768_11786__$1);
var G__11788 = cljs.core.chunk_rest.call(null,seq__11768_11786__$1);
var G__11789 = c__6943__auto___11787;
var G__11790 = cljs.core.count.call(null,c__6943__auto___11787);
var G__11791 = (0);
seq__11768_11776 = G__11788;
chunk__11769_11777 = G__11789;
count__11770_11778 = G__11790;
i__11771_11779 = G__11791;
continue;
} else {
var l_11792 = cljs.core.first.call(null,seq__11768_11786__$1);
l_11792.call(null,store,deps);

var G__11793 = cljs.core.next.call(null,seq__11768_11786__$1);
var G__11794 = null;
var G__11795 = (0);
var G__11796 = (0);
seq__11768_11776 = G__11793;
chunk__11769_11777 = G__11794;
count__11770_11778 = G__11795;
i__11771_11779 = G__11796;
continue;
}
} else {
}
}
break;
}

var G__11797 = seq__11762;
var G__11798 = chunk__11764;
var G__11799 = count__11765;
var G__11800 = (i__11766 + (1));
seq__11762 = G__11797;
chunk__11764 = G__11798;
count__11765 = G__11799;
i__11766 = G__11800;
continue;
} else {
var G__11801 = seq__11762;
var G__11802 = chunk__11764;
var G__11803 = count__11765;
var G__11804 = (i__11766 + (1));
seq__11762 = G__11801;
chunk__11764 = G__11802;
count__11765 = G__11803;
i__11766 = G__11804;
continue;
}
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__11762);
if(temp__4425__auto__){
var seq__11762__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11762__$1)){
var c__6943__auto__ = cljs.core.chunk_first.call(null,seq__11762__$1);
var G__11805 = cljs.core.chunk_rest.call(null,seq__11762__$1);
var G__11806 = c__6943__auto__;
var G__11807 = cljs.core.count.call(null,c__6943__auto__);
var G__11808 = (0);
seq__11762 = G__11805;
chunk__11764 = G__11806;
count__11765 = G__11807;
i__11766 = G__11808;
continue;
} else {
var ldeps = cljs.core.first.call(null,seq__11762__$1);
if(cljs.core.truth_((function (){var or__6140__auto__ = (ldeps == null);
if(or__6140__auto__){
return or__6140__auto__;
} else {
return derive.core.match_deps.call(null,ldeps,deps);
}
})())){
var seq__11772_11809 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11773_11810 = null;
var count__11774_11811 = (0);
var i__11775_11812 = (0);
while(true){
if((i__11775_11812 < count__11774_11811)){
var l_11813 = cljs.core._nth.call(null,chunk__11773_11810,i__11775_11812);
l_11813.call(null,store,deps);

var G__11814 = seq__11772_11809;
var G__11815 = chunk__11773_11810;
var G__11816 = count__11774_11811;
var G__11817 = (i__11775_11812 + (1));
seq__11772_11809 = G__11814;
chunk__11773_11810 = G__11815;
count__11774_11811 = G__11816;
i__11775_11812 = G__11817;
continue;
} else {
var temp__4425__auto___11818__$1 = cljs.core.seq.call(null,seq__11772_11809);
if(temp__4425__auto___11818__$1){
var seq__11772_11819__$1 = temp__4425__auto___11818__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11772_11819__$1)){
var c__6943__auto___11820 = cljs.core.chunk_first.call(null,seq__11772_11819__$1);
var G__11821 = cljs.core.chunk_rest.call(null,seq__11772_11819__$1);
var G__11822 = c__6943__auto___11820;
var G__11823 = cljs.core.count.call(null,c__6943__auto___11820);
var G__11824 = (0);
seq__11772_11809 = G__11821;
chunk__11773_11810 = G__11822;
count__11774_11811 = G__11823;
i__11775_11812 = G__11824;
continue;
} else {
var l_11825 = cljs.core.first.call(null,seq__11772_11819__$1);
l_11825.call(null,store,deps);

var G__11826 = cljs.core.next.call(null,seq__11772_11819__$1);
var G__11827 = null;
var G__11828 = (0);
var G__11829 = (0);
seq__11772_11809 = G__11826;
chunk__11773_11810 = G__11827;
count__11774_11811 = G__11828;
i__11775_11812 = G__11829;
continue;
}
} else {
}
}
break;
}

var G__11830 = cljs.core.next.call(null,seq__11762__$1);
var G__11831 = null;
var G__11832 = (0);
var G__11833 = (0);
seq__11762 = G__11830;
chunk__11764 = G__11831;
count__11765 = G__11832;
i__11766 = G__11833;
continue;
} else {
var G__11836 = cljs.core.next.call(null,seq__11762__$1);
var G__11837 = null;
var G__11838 = (0);
var G__11839 = (0);
seq__11762 = G__11836;
chunk__11764 = G__11837;
count__11765 = G__11838;
i__11766 = G__11839;
continue;
}
}
} else {
return null;
}
}
break;
}
});
/**
 * Force invalidate all listeners to this store
 */
derive.core.force_invalidation = (function derive$core$force_invalidation(store){
var listeners = store.listeners;
var seq__11854 = cljs.core.seq.call(null,cljs.core.keys.call(null,listeners));
var chunk__11855 = null;
var count__11856 = (0);
var i__11857 = (0);
while(true){
if((i__11857 < count__11856)){
var ldeps = cljs.core._nth.call(null,chunk__11855,i__11857);
var seq__11858_11869 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11859_11870 = null;
var count__11860_11871 = (0);
var i__11861_11872 = (0);
while(true){
if((i__11861_11872 < count__11860_11871)){
var l_11873 = cljs.core._nth.call(null,chunk__11859_11870,i__11861_11872);
l_11873.call(null,store,null);

var G__11874 = seq__11858_11869;
var G__11875 = chunk__11859_11870;
var G__11876 = count__11860_11871;
var G__11877 = (i__11861_11872 + (1));
seq__11858_11869 = G__11874;
chunk__11859_11870 = G__11875;
count__11860_11871 = G__11876;
i__11861_11872 = G__11877;
continue;
} else {
var temp__4425__auto___11878 = cljs.core.seq.call(null,seq__11858_11869);
if(temp__4425__auto___11878){
var seq__11858_11879__$1 = temp__4425__auto___11878;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11858_11879__$1)){
var c__6943__auto___11880 = cljs.core.chunk_first.call(null,seq__11858_11879__$1);
var G__11881 = cljs.core.chunk_rest.call(null,seq__11858_11879__$1);
var G__11882 = c__6943__auto___11880;
var G__11883 = cljs.core.count.call(null,c__6943__auto___11880);
var G__11884 = (0);
seq__11858_11869 = G__11881;
chunk__11859_11870 = G__11882;
count__11860_11871 = G__11883;
i__11861_11872 = G__11884;
continue;
} else {
var l_11885 = cljs.core.first.call(null,seq__11858_11879__$1);
l_11885.call(null,store,null);

var G__11886 = cljs.core.next.call(null,seq__11858_11879__$1);
var G__11887 = null;
var G__11888 = (0);
var G__11889 = (0);
seq__11858_11869 = G__11886;
chunk__11859_11870 = G__11887;
count__11860_11871 = G__11888;
i__11861_11872 = G__11889;
continue;
}
} else {
}
}
break;
}

var G__11890 = seq__11854;
var G__11891 = chunk__11855;
var G__11892 = count__11856;
var G__11893 = (i__11857 + (1));
seq__11854 = G__11890;
chunk__11855 = G__11891;
count__11856 = G__11892;
i__11857 = G__11893;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__11854);
if(temp__4425__auto__){
var seq__11854__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11854__$1)){
var c__6943__auto__ = cljs.core.chunk_first.call(null,seq__11854__$1);
var G__11894 = cljs.core.chunk_rest.call(null,seq__11854__$1);
var G__11895 = c__6943__auto__;
var G__11896 = cljs.core.count.call(null,c__6943__auto__);
var G__11897 = (0);
seq__11854 = G__11894;
chunk__11855 = G__11895;
count__11856 = G__11896;
i__11857 = G__11897;
continue;
} else {
var ldeps = cljs.core.first.call(null,seq__11854__$1);
var seq__11862_11898 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11863_11899 = null;
var count__11864_11900 = (0);
var i__11865_11901 = (0);
while(true){
if((i__11865_11901 < count__11864_11900)){
var l_11902 = cljs.core._nth.call(null,chunk__11863_11899,i__11865_11901);
l_11902.call(null,store,null);

var G__11903 = seq__11862_11898;
var G__11904 = chunk__11863_11899;
var G__11905 = count__11864_11900;
var G__11906 = (i__11865_11901 + (1));
seq__11862_11898 = G__11903;
chunk__11863_11899 = G__11904;
count__11864_11900 = G__11905;
i__11865_11901 = G__11906;
continue;
} else {
var temp__4425__auto___11907__$1 = cljs.core.seq.call(null,seq__11862_11898);
if(temp__4425__auto___11907__$1){
var seq__11862_11909__$1 = temp__4425__auto___11907__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11862_11909__$1)){
var c__6943__auto___11910 = cljs.core.chunk_first.call(null,seq__11862_11909__$1);
var G__11911 = cljs.core.chunk_rest.call(null,seq__11862_11909__$1);
var G__11912 = c__6943__auto___11910;
var G__11913 = cljs.core.count.call(null,c__6943__auto___11910);
var G__11914 = (0);
seq__11862_11898 = G__11911;
chunk__11863_11899 = G__11912;
count__11864_11900 = G__11913;
i__11865_11901 = G__11914;
continue;
} else {
var l_11915 = cljs.core.first.call(null,seq__11862_11909__$1);
l_11915.call(null,store,null);

var G__11916 = cljs.core.next.call(null,seq__11862_11909__$1);
var G__11917 = null;
var G__11918 = (0);
var G__11919 = (0);
seq__11862_11898 = G__11916;
chunk__11863_11899 = G__11917;
count__11864_11900 = G__11918;
i__11865_11901 = G__11919;
continue;
}
} else {
}
}
break;
}

var G__11920 = cljs.core.next.call(null,seq__11854__$1);
var G__11921 = null;
var G__11922 = (0);
var G__11923 = (0);
seq__11854 = G__11920;
chunk__11855 = G__11921;
count__11856 = G__11922;
i__11857 = G__11923;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Helper. Handle source listener events
 */
derive.core.derive_listener = (function derive$core$derive_listener(derive__$1,store,deps){
var cache = derive__$1.cache;
var param_set = cljs.core.set.call(null,derive.core.invalidate_BANG_.call(null,cache,store,deps));
if(cljs.core.empty_QMARK_.call(null,param_set)){
return null;
} else {
return derive.core.notify_listeners.call(null,derive__$1,param_set);
}
});
/**
 * Helper. Inform upstream when we're redefined
 */
derive.core.invalidate_all_listeners = (function derive$core$invalidate_all_listeners(derive__$1){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (f){
return f.call(null,derive__$1,null);
}),cljs.core.flatten.call(null,cljs.core.vals.call(null,derive__$1.listeners))));
});
/**
 * Call from will-unmount and when re-subscribing a component
 */
derive.core.clear_listener_BANG_ = (function derive$core$clear_listener_BANG_(owner){
var listener = (owner["__derive_listener"]);
var dmap = (owner["__derive_dmap"]);
var seq__11930_11936 = cljs.core.seq.call(null,dmap);
var chunk__11931_11937 = null;
var count__11932_11938 = (0);
var i__11933_11939 = (0);
while(true){
if((i__11933_11939 < count__11932_11938)){
var vec__11934_11940 = cljs.core._nth.call(null,chunk__11931_11937,i__11933_11939);
var store_11941 = cljs.core.nth.call(null,vec__11934_11940,(0),null);
var query_deps_11942 = cljs.core.nth.call(null,vec__11934_11940,(1),null);
derive.core.unsubscribe_BANG_.call(null,store_11941,listener,query_deps_11942);

var G__11943 = seq__11930_11936;
var G__11944 = chunk__11931_11937;
var G__11945 = count__11932_11938;
var G__11946 = (i__11933_11939 + (1));
seq__11930_11936 = G__11943;
chunk__11931_11937 = G__11944;
count__11932_11938 = G__11945;
i__11933_11939 = G__11946;
continue;
} else {
var temp__4425__auto___11947 = cljs.core.seq.call(null,seq__11930_11936);
if(temp__4425__auto___11947){
var seq__11930_11948__$1 = temp__4425__auto___11947;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11930_11948__$1)){
var c__6943__auto___11949 = cljs.core.chunk_first.call(null,seq__11930_11948__$1);
var G__11950 = cljs.core.chunk_rest.call(null,seq__11930_11948__$1);
var G__11951 = c__6943__auto___11949;
var G__11952 = cljs.core.count.call(null,c__6943__auto___11949);
var G__11953 = (0);
seq__11930_11936 = G__11950;
chunk__11931_11937 = G__11951;
count__11932_11938 = G__11952;
i__11933_11939 = G__11953;
continue;
} else {
var vec__11935_11954 = cljs.core.first.call(null,seq__11930_11948__$1);
var store_11955 = cljs.core.nth.call(null,vec__11935_11954,(0),null);
var query_deps_11956 = cljs.core.nth.call(null,vec__11935_11954,(1),null);
derive.core.unsubscribe_BANG_.call(null,store_11955,listener,query_deps_11956);

var G__11957 = cljs.core.next.call(null,seq__11930_11948__$1);
var G__11958 = null;
var G__11959 = (0);
var G__11960 = (0);
seq__11930_11936 = G__11957;
chunk__11931_11937 = G__11958;
count__11932_11938 = G__11959;
i__11933_11939 = G__11960;
continue;
}
} else {
}
}
break;
}

(owner["__derive_listener"] = null);

(owner["__derive_dmap"] = null);

return owner;
});
derive.core.save_listener_BANG_ = (function derive$core$save_listener_BANG_(owner,listener,dmap){
(owner["__derive_listener"] = listener);

(owner["__derive_dmap"] = dmap);

return owner;
});
/**
 * Call in on-changes
 */
derive.core.om_subscribe_handler = (function derive$core$om_subscribe_handler(owner){
return (function (listener,dmap){
return derive.core.save_listener_BANG_.call(null,derive.core.clear_listener_BANG_.call(null,owner),listener,dmap);
});
});
