// Compiled by ClojureScript 1.7.228 {}
goog.provide('clojure.core.reducers');
goog.require('cljs.core');
goog.require('cljs.core');
clojure.core.reducers.fjtask = (function clojure$core$reducers$fjtask(f){
return f;
});
clojure.core.reducers.fjinvoke = (function clojure$core$reducers$fjinvoke(f){
return f.call(null);
});
clojure.core.reducers.fjfork = (function clojure$core$reducers$fjfork(task){
return task;
});
clojure.core.reducers.fjjoin = (function clojure$core$reducers$fjjoin(task){
return task.call(null);
});
/**
 * Like core/reduce except:
 *   When init is not provided, (f) is used.
 *   Maps are reduced with reduce-kv
 */
clojure.core.reducers.reduce = (function clojure$core$reducers$reduce(var_args){
var args11168 = [];
var len__7198__auto___11179 = arguments.length;
var i__7199__auto___11180 = (0);
while(true){
if((i__7199__auto___11180 < len__7198__auto___11179)){
args11168.push((arguments[i__7199__auto___11180]));

var G__11182 = (i__7199__auto___11180 + (1));
i__7199__auto___11180 = G__11182;
continue;
} else {
}
break;
}

var G__11171 = args11168.length;
switch (G__11171) {
case 2:
return clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11168.length)].join('')));

}
});

clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return clojure.core.reducers.reduce.call(null,f,f.call(null),coll);
});

clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
if(cljs.core.map_QMARK_.call(null,coll)){
return cljs.core._kv_reduce.call(null,coll,f,init);
} else {
if((coll == null)){
return init;
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return cljs.core.array_reduce.call(null,coll,f,init);
} else {
return cljs.core._reduce.call(null,coll,f,init);

}
}
}
});

clojure.core.reducers.reduce.cljs$lang$maxFixedArity = 3;

/**
 * @interface
 */
clojure.core.reducers.CollFold = function(){};

clojure.core.reducers.coll_fold = (function clojure$core$reducers$coll_fold(coll,n,combinef,reducef){
if((!((coll == null))) && (!((coll.clojure$core$reducers$CollFold$coll_fold$arity$4 == null)))){
return coll.clojure$core$reducers$CollFold$coll_fold$arity$4(coll,n,combinef,reducef);
} else {
var x__6795__auto__ = (((coll == null))?null:coll);
var m__6796__auto__ = (clojure.core.reducers.coll_fold[goog.typeOf(x__6795__auto__)]);
if(!((m__6796__auto__ == null))){
return m__6796__auto__.call(null,coll,n,combinef,reducef);
} else {
var m__6796__auto____$1 = (clojure.core.reducers.coll_fold["_"]);
if(!((m__6796__auto____$1 == null))){
return m__6796__auto____$1.call(null,coll,n,combinef,reducef);
} else {
throw cljs.core.missing_protocol.call(null,"CollFold.coll-fold",coll);
}
}
}
});

/**
 * Reduces a collection using a (potentially parallel) reduce-combine
 *   strategy. The collection is partitioned into groups of approximately
 *   n (default 512), each of which is reduced with reducef (with a seed
 *   value obtained by calling (combinef) with no arguments). The results
 *   of these reductions are then reduced with combinef (default
 *   reducef). combinef must be associative, and, when called with no
 *   arguments, (combinef) must produce its identity element. These
 *   operations may be performed in parallel, but the results will
 *   preserve order.
 * 
 *   Note: Performing operations in parallel is currently not implemented.
 */
clojure.core.reducers.fold = (function clojure$core$reducers$fold(var_args){
var args11197 = [];
var len__7198__auto___11209 = arguments.length;
var i__7199__auto___11210 = (0);
while(true){
if((i__7199__auto___11210 < len__7198__auto___11209)){
args11197.push((arguments[i__7199__auto___11210]));

var G__11211 = (i__7199__auto___11210 + (1));
i__7199__auto___11210 = G__11211;
continue;
} else {
}
break;
}

var G__11206 = args11197.length;
switch (G__11206) {
case 2:
return clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11197.length)].join('')));

}
});

clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$2 = (function (reducef,coll){
return clojure.core.reducers.fold.call(null,reducef,reducef,coll);
});

clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$3 = (function (combinef,reducef,coll){
return clojure.core.reducers.fold.call(null,(512),combinef,reducef,coll);
});

clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$4 = (function (n,combinef,reducef,coll){
return clojure.core.reducers.coll_fold.call(null,coll,n,combinef,reducef);
});

clojure.core.reducers.fold.cljs$lang$maxFixedArity = 4;
/**
 * Given a reducible collection, and a transformation function xf,
 *   returns a reducible collection, where any supplied reducing
 *   fn will be transformed by xf. xf is a function of reducing fn to
 *   reducing fn.
 */
clojure.core.reducers.reducer = (function clojure$core$reducers$reducer(coll,xf){
if(typeof clojure.core.reducers.t_clojure$core$reducers11225 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
clojure.core.reducers.t_clojure$core$reducers11225 = (function (reducer,coll,xf,meta11226){
this.reducer = reducer;
this.coll = coll;
this.xf = xf;
this.meta11226 = meta11226;
this.cljs$lang$protocol_mask$partition0$ = 917504;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
clojure.core.reducers.t_clojure$core$reducers11225.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11227,meta11226__$1){
var self__ = this;
var _11227__$1 = this;
return (new clojure.core.reducers.t_clojure$core$reducers11225(self__.reducer,self__.coll,self__.xf,meta11226__$1));
});

clojure.core.reducers.t_clojure$core$reducers11225.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11227){
var self__ = this;
var _11227__$1 = this;
return self__.meta11226;
});

clojure.core.reducers.t_clojure$core$reducers11225.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f1){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,f1,f1.call(null));
});

clojure.core.reducers.t_clojure$core$reducers11225.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f1,init){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.coll,self__.xf.call(null,f1),init);
});

clojure.core.reducers.t_clojure$core$reducers11225.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"reducer","reducer",-948842876,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a reducible collection, and a transformation function xf,\n  returns a reducible collection, where any supplied reducing\n  fn will be transformed by xf. xf is a function of reducing fn to\n  reducing fn."], null)),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"meta11226","meta11226",-1451328302,null)], null);
});

clojure.core.reducers.t_clojure$core$reducers11225.cljs$lang$type = true;

clojure.core.reducers.t_clojure$core$reducers11225.cljs$lang$ctorStr = "clojure.core.reducers/t_clojure$core$reducers11225";

clojure.core.reducers.t_clojure$core$reducers11225.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"clojure.core.reducers/t_clojure$core$reducers11225");
});

clojure.core.reducers.__GT_t_clojure$core$reducers11225 = (function clojure$core$reducers$reducer_$___GT_t_clojure$core$reducers11225(reducer__$1,coll__$1,xf__$1,meta11226){
return (new clojure.core.reducers.t_clojure$core$reducers11225(reducer__$1,coll__$1,xf__$1,meta11226));
});

}

return (new clojure.core.reducers.t_clojure$core$reducers11225(clojure$core$reducers$reducer,coll,xf,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Given a foldable collection, and a transformation function xf,
 *   returns a foldable collection, where any supplied reducing
 *   fn will be transformed by xf. xf is a function of reducing fn to
 *   reducing fn.
 */
clojure.core.reducers.folder = (function clojure$core$reducers$folder(coll,xf){
if(typeof clojure.core.reducers.t_clojure$core$reducers11248 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {clojure.core.reducers.CollFold}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
clojure.core.reducers.t_clojure$core$reducers11248 = (function (folder,coll,xf,meta11250){
this.folder = folder;
this.coll = coll;
this.xf = xf;
this.meta11250 = meta11250;
this.cljs$lang$protocol_mask$partition0$ = 917504;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
clojure.core.reducers.t_clojure$core$reducers11248.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11251,meta11250__$1){
var self__ = this;
var _11251__$1 = this;
return (new clojure.core.reducers.t_clojure$core$reducers11248(self__.folder,self__.coll,self__.xf,meta11250__$1));
});

clojure.core.reducers.t_clojure$core$reducers11248.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11251){
var self__ = this;
var _11251__$1 = this;
return self__.meta11250;
});

clojure.core.reducers.t_clojure$core$reducers11248.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (_,f1){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.coll,self__.xf.call(null,f1),f1.call(null));
});

clojure.core.reducers.t_clojure$core$reducers11248.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f1,init){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.coll,self__.xf.call(null,f1),init);
});

clojure.core.reducers.t_clojure$core$reducers11248.prototype.clojure$core$reducers$CollFold$ = true;

clojure.core.reducers.t_clojure$core$reducers11248.prototype.clojure$core$reducers$CollFold$coll_fold$arity$4 = (function (_,n,combinef,reducef){
var self__ = this;
var ___$1 = this;
return clojure.core.reducers.coll_fold.call(null,self__.coll,n,combinef,self__.xf.call(null,reducef));
});

clojure.core.reducers.t_clojure$core$reducers11248.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"folder","folder",-1138554033,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a foldable collection, and a transformation function xf,\n  returns a foldable collection, where any supplied reducing\n  fn will be transformed by xf. xf is a function of reducing fn to\n  reducing fn."], null)),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"meta11250","meta11250",-2072460010,null)], null);
});

clojure.core.reducers.t_clojure$core$reducers11248.cljs$lang$type = true;

clojure.core.reducers.t_clojure$core$reducers11248.cljs$lang$ctorStr = "clojure.core.reducers/t_clojure$core$reducers11248";

clojure.core.reducers.t_clojure$core$reducers11248.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"clojure.core.reducers/t_clojure$core$reducers11248");
});

clojure.core.reducers.__GT_t_clojure$core$reducers11248 = (function clojure$core$reducers$folder_$___GT_t_clojure$core$reducers11248(folder__$1,coll__$1,xf__$1,meta11250){
return (new clojure.core.reducers.t_clojure$core$reducers11248(folder__$1,coll__$1,xf__$1,meta11250));
});

}

return (new clojure.core.reducers.t_clojure$core$reducers11248(clojure$core$reducers$folder,coll,xf,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Applies f to every value in the reduction of coll. Foldable.
 */
clojure.core.reducers.map = (function clojure$core$reducers$map(var_args){
var args11270 = [];
var len__7198__auto___11277 = arguments.length;
var i__7199__auto___11278 = (0);
while(true){
if((i__7199__auto___11278 < len__7198__auto___11277)){
args11270.push((arguments[i__7199__auto___11278]));

var G__11279 = (i__7199__auto___11278 + (1));
i__7199__auto___11278 = G__11279;
continue;
} else {
}
break;
}

var G__11274 = args11270.length;
switch (G__11274) {
case 1:
return clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11270.length)].join('')));

}
});

clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (x__6581__auto__){
return clojure.core.reducers.map.call(null,f,x__6581__auto__);
});
});

clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__11281 = null;
var G__11281__0 = (function (){
return f1.call(null);
});
var G__11281__2 = (function (ret,v){
return f1.call(null,ret,f.call(null,v));
});
var G__11281__3 = (function (ret,k,v){
return f1.call(null,ret,f.call(null,k,v));
});
G__11281 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__11281__0.call(this);
case 2:
return G__11281__2.call(this,ret,k);
case 3:
return G__11281__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11281.cljs$core$IFn$_invoke$arity$0 = G__11281__0;
G__11281.cljs$core$IFn$_invoke$arity$2 = G__11281__2;
G__11281.cljs$core$IFn$_invoke$arity$3 = G__11281__3;
return G__11281;
})()
}));
});

clojure.core.reducers.map.cljs$lang$maxFixedArity = 2;
/**
 * Applies f to every value in the reduction of coll, concatenating the result
 *   colls of (f val). Foldable.
 */
clojure.core.reducers.mapcat = (function clojure$core$reducers$mapcat(var_args){
var args11286 = [];
var len__7198__auto___11292 = arguments.length;
var i__7199__auto___11293 = (0);
while(true){
if((i__7199__auto___11293 < len__7198__auto___11292)){
args11286.push((arguments[i__7199__auto___11293]));

var G__11294 = (i__7199__auto___11293 + (1));
i__7199__auto___11293 = G__11294;
continue;
} else {
}
break;
}

var G__11288 = args11286.length;
switch (G__11288) {
case 1:
return clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11286.length)].join('')));

}
});

clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (x__6581__auto__){
return clojure.core.reducers.mapcat.call(null,f,x__6581__auto__);
});
});

clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__11300 = null;
var G__11300__0 = (function (){
return f1.call(null);
});
var G__11300__2 = (function (ret,v){
return clojure.core.reducers.reduce.call(null,f1,ret,f.call(null,v));
});
var G__11300__3 = (function (ret,k,v){
return clojure.core.reducers.reduce.call(null,f1,ret,f.call(null,k,v));
});
G__11300 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__11300__0.call(this);
case 2:
return G__11300__2.call(this,ret,k);
case 3:
return G__11300__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11300.cljs$core$IFn$_invoke$arity$0 = G__11300__0;
G__11300.cljs$core$IFn$_invoke$arity$2 = G__11300__2;
G__11300.cljs$core$IFn$_invoke$arity$3 = G__11300__3;
return G__11300;
})()
}));
});

clojure.core.reducers.mapcat.cljs$lang$maxFixedArity = 2;
/**
 * Retains values in the reduction of coll for which (pred val)
 *   returns logical true. Foldable.
 */
clojure.core.reducers.filter = (function clojure$core$reducers$filter(var_args){
var args11304 = [];
var len__7198__auto___11314 = arguments.length;
var i__7199__auto___11315 = (0);
while(true){
if((i__7199__auto___11315 < len__7198__auto___11314)){
args11304.push((arguments[i__7199__auto___11315]));

var G__11316 = (i__7199__auto___11315 + (1));
i__7199__auto___11315 = G__11316;
continue;
} else {
}
break;
}

var G__11309 = args11304.length;
switch (G__11309) {
case 1:
return clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11304.length)].join('')));

}
});

clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (x__6581__auto__){
return clojure.core.reducers.filter.call(null,pred,x__6581__auto__);
});
});

clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__11318 = null;
var G__11318__0 = (function (){
return f1.call(null);
});
var G__11318__2 = (function (ret,v){
if(cljs.core.truth_(pred.call(null,v))){
return f1.call(null,ret,v);
} else {
return ret;
}
});
var G__11318__3 = (function (ret,k,v){
if(cljs.core.truth_(pred.call(null,k,v))){
return f1.call(null,ret,k,v);
} else {
return ret;
}
});
G__11318 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__11318__0.call(this);
case 2:
return G__11318__2.call(this,ret,k);
case 3:
return G__11318__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11318.cljs$core$IFn$_invoke$arity$0 = G__11318__0;
G__11318.cljs$core$IFn$_invoke$arity$2 = G__11318__2;
G__11318.cljs$core$IFn$_invoke$arity$3 = G__11318__3;
return G__11318;
})()
}));
});

clojure.core.reducers.filter.cljs$lang$maxFixedArity = 2;
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat foldable
 *   collection.
 */
clojure.core.reducers.flatten = (function clojure$core$reducers$flatten(var_args){
var args11319 = [];
var len__7198__auto___11322 = arguments.length;
var i__7199__auto___11323 = (0);
while(true){
if((i__7199__auto___11323 < len__7198__auto___11322)){
args11319.push((arguments[i__7199__auto___11323]));

var G__11324 = (i__7199__auto___11323 + (1));
i__7199__auto___11323 = G__11324;
continue;
} else {
}
break;
}

var G__11321 = args11319.length;
switch (G__11321) {
case 0:
return clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11319.length)].join('')));

}
});

clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (x__6581__auto__){
return clojure.core.reducers.flatten.call(null,x__6581__auto__);
});
});

clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__11328 = null;
var G__11328__0 = (function (){
return f1.call(null);
});
var G__11328__2 = (function (ret,v){
if(cljs.core.sequential_QMARK_.call(null,v)){
return cljs.core._reduce.call(null,clojure.core.reducers.flatten.call(null,v),f1,ret);
} else {
return f1.call(null,ret,v);
}
});
G__11328 = function(ret,v){
switch(arguments.length){
case 0:
return G__11328__0.call(this);
case 2:
return G__11328__2.call(this,ret,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11328.cljs$core$IFn$_invoke$arity$0 = G__11328__0;
G__11328.cljs$core$IFn$_invoke$arity$2 = G__11328__2;
return G__11328;
})()
}));
});

clojure.core.reducers.flatten.cljs$lang$maxFixedArity = 1;
/**
 * Removes values in the reduction of coll for which (pred val)
 *   returns logical true. Foldable.
 */
clojure.core.reducers.remove = (function clojure$core$reducers$remove(var_args){
var args11329 = [];
var len__7198__auto___11332 = arguments.length;
var i__7199__auto___11333 = (0);
while(true){
if((i__7199__auto___11333 < len__7198__auto___11332)){
args11329.push((arguments[i__7199__auto___11333]));

var G__11334 = (i__7199__auto___11333 + (1));
i__7199__auto___11333 = G__11334;
continue;
} else {
}
break;
}

var G__11331 = args11329.length;
switch (G__11331) {
case 1:
return clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11329.length)].join('')));

}
});

clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (x__6581__auto__){
return clojure.core.reducers.remove.call(null,pred,x__6581__auto__);
});
});

clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return clojure.core.reducers.filter.call(null,cljs.core.complement.call(null,pred),coll);
});

clojure.core.reducers.remove.cljs$lang$maxFixedArity = 2;
/**
 * Ends the reduction of coll when (pred val) returns logical false.
 */
clojure.core.reducers.take_while = (function clojure$core$reducers$take_while(var_args){
var args11336 = [];
var len__7198__auto___11347 = arguments.length;
var i__7199__auto___11348 = (0);
while(true){
if((i__7199__auto___11348 < len__7198__auto___11347)){
args11336.push((arguments[i__7199__auto___11348]));

var G__11350 = (i__7199__auto___11348 + (1));
i__7199__auto___11348 = G__11350;
continue;
} else {
}
break;
}

var G__11341 = args11336.length;
switch (G__11341) {
case 1:
return clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11336.length)].join('')));

}
});

clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (x__6581__auto__){
return clojure.core.reducers.take_while.call(null,pred,x__6581__auto__);
});
});

clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return clojure.core.reducers.reducer.call(null,coll,(function (f1){
return (function() {
var G__11352 = null;
var G__11352__0 = (function (){
return f1.call(null);
});
var G__11352__2 = (function (ret,v){
if(pred.call(null,v)){
return f1.call(null,ret,v);
} else {
return cljs.core.reduced.call(null,ret);
}
});
var G__11352__3 = (function (ret,k,v){
if(pred.call(null,k,v)){
return f1.call(null,ret,k,v);
} else {
return cljs.core.reduced.call(null,ret);
}
});
G__11352 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__11352__0.call(this);
case 2:
return G__11352__2.call(this,ret,k);
case 3:
return G__11352__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11352.cljs$core$IFn$_invoke$arity$0 = G__11352__0;
G__11352.cljs$core$IFn$_invoke$arity$2 = G__11352__2;
G__11352.cljs$core$IFn$_invoke$arity$3 = G__11352__3;
return G__11352;
})()
}));
});

clojure.core.reducers.take_while.cljs$lang$maxFixedArity = 2;
/**
 * Ends the reduction of coll after consuming n values.
 */
clojure.core.reducers.take = (function clojure$core$reducers$take(var_args){
var args11359 = [];
var len__7198__auto___11368 = arguments.length;
var i__7199__auto___11369 = (0);
while(true){
if((i__7199__auto___11369 < len__7198__auto___11368)){
args11359.push((arguments[i__7199__auto___11369]));

var G__11370 = (i__7199__auto___11369 + (1));
i__7199__auto___11369 = G__11370;
continue;
} else {
}
break;
}

var G__11364 = args11359.length;
switch (G__11364) {
case 1:
return clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11359.length)].join('')));

}
});

clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (x__6581__auto__){
return clojure.core.reducers.take.call(null,n,x__6581__auto__);
});
});

clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return clojure.core.reducers.reducer.call(null,coll,(function (f1){
var cnt = cljs.core.atom.call(null,n);
return ((function (cnt){
return (function() {
var G__11377 = null;
var G__11377__0 = (function (){
return f1.call(null);
});
var G__11377__2 = (function (ret,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return cljs.core.reduced.call(null,ret);
} else {
return f1.call(null,ret,v);
}
});
var G__11377__3 = (function (ret,k,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return cljs.core.reduced.call(null,ret);
} else {
return f1.call(null,ret,k,v);
}
});
G__11377 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__11377__0.call(this);
case 2:
return G__11377__2.call(this,ret,k);
case 3:
return G__11377__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11377.cljs$core$IFn$_invoke$arity$0 = G__11377__0;
G__11377.cljs$core$IFn$_invoke$arity$2 = G__11377__2;
G__11377.cljs$core$IFn$_invoke$arity$3 = G__11377__3;
return G__11377;
})()
;})(cnt))
}));
});

clojure.core.reducers.take.cljs$lang$maxFixedArity = 2;
/**
 * Elides the first n values from the reduction of coll.
 */
clojure.core.reducers.drop = (function clojure$core$reducers$drop(var_args){
var args11389 = [];
var len__7198__auto___11398 = arguments.length;
var i__7199__auto___11399 = (0);
while(true){
if((i__7199__auto___11399 < len__7198__auto___11398)){
args11389.push((arguments[i__7199__auto___11399]));

var G__11401 = (i__7199__auto___11399 + (1));
i__7199__auto___11399 = G__11401;
continue;
} else {
}
break;
}

var G__11393 = args11389.length;
switch (G__11393) {
case 1:
return clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11389.length)].join('')));

}
});

clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (x__6581__auto__){
return clojure.core.reducers.drop.call(null,n,x__6581__auto__);
});
});

clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return clojure.core.reducers.reducer.call(null,coll,(function (f1){
var cnt = cljs.core.atom.call(null,n);
return ((function (cnt){
return (function() {
var G__11409 = null;
var G__11409__0 = (function (){
return f1.call(null);
});
var G__11409__2 = (function (ret,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return f1.call(null,ret,v);
} else {
return ret;
}
});
var G__11409__3 = (function (ret,k,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return f1.call(null,ret,k,v);
} else {
return ret;
}
});
G__11409 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__11409__0.call(this);
case 2:
return G__11409__2.call(this,ret,k);
case 3:
return G__11409__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11409.cljs$core$IFn$_invoke$arity$0 = G__11409__0;
G__11409.cljs$core$IFn$_invoke$arity$2 = G__11409__2;
G__11409.cljs$core$IFn$_invoke$arity$3 = G__11409__3;
return G__11409;
})()
;})(cnt))
}));
});

clojure.core.reducers.drop.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {clojure.core.reducers.CollFold}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IReduce}
*/
clojure.core.reducers.Cat = (function (cnt,left,right){
this.cnt = cnt;
this.left = left;
this.right = right;
this.cljs$lang$protocol_mask$partition0$ = 8912898;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
clojure.core.reducers.Cat.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.cnt;
});

clojure.core.reducers.Cat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.concat.call(null,cljs.core.seq.call(null,self__.left),cljs.core.seq.call(null,self__.right));
});

clojure.core.reducers.Cat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f1){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,f1,f1.call(null));
});

clojure.core.reducers.Cat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f1,init){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.right,f1,cljs.core._reduce.call(null,self__.left,f1,init));
});

clojure.core.reducers.Cat.prototype.clojure$core$reducers$CollFold$ = true;

clojure.core.reducers.Cat.prototype.clojure$core$reducers$CollFold$coll_fold$arity$4 = (function (this$,n,combinef,reducef){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,reducef);
});

clojure.core.reducers.Cat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null)], null);
});

clojure.core.reducers.Cat.cljs$lang$type = true;

clojure.core.reducers.Cat.cljs$lang$ctorStr = "clojure.core.reducers/Cat";

clojure.core.reducers.Cat.cljs$lang$ctorPrWriter = (function (this__6738__auto__,writer__6739__auto__,opt__6740__auto__){
return cljs.core._write.call(null,writer__6739__auto__,"clojure.core.reducers/Cat");
});

clojure.core.reducers.__GT_Cat = (function clojure$core$reducers$__GT_Cat(cnt,left,right){
return (new clojure.core.reducers.Cat(cnt,left,right));
});

/**
 * A high-performance combining fn that yields the catenation of the
 *   reduced values. The result is reducible, foldable, seqable and
 *   counted, providing the identity collections are reducible, seqable
 *   and counted. The single argument version will build a combining fn
 *   with the supplied identity constructor. Tests for identity
 *   with (zero? (count x)). See also foldcat.
 */
clojure.core.reducers.cat = (function clojure$core$reducers$cat(var_args){
var args11425 = [];
var len__7198__auto___11444 = arguments.length;
var i__7199__auto___11445 = (0);
while(true){
if((i__7199__auto___11445 < len__7198__auto___11444)){
args11425.push((arguments[i__7199__auto___11445]));

var G__11446 = (i__7199__auto___11445 + (1));
i__7199__auto___11445 = G__11446;
continue;
} else {
}
break;
}

var G__11430 = args11425.length;
switch (G__11430) {
case 0:
return clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11425.length)].join('')));

}
});

clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$0 = (function (){
return [];
});

clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$1 = (function (ctor){
return (function() {
var G__11451 = null;
var G__11451__0 = (function (){
return ctor.call(null);
});
var G__11451__2 = (function (left,right){
return clojure.core.reducers.cat.call(null,left,right);
});
G__11451 = function(left,right){
switch(arguments.length){
case 0:
return G__11451__0.call(this);
case 2:
return G__11451__2.call(this,left,right);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11451.cljs$core$IFn$_invoke$arity$0 = G__11451__0;
G__11451.cljs$core$IFn$_invoke$arity$2 = G__11451__2;
return G__11451;
})()
});

clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$2 = (function (left,right){
if((cljs.core.count.call(null,left) === (0))){
return right;
} else {
if((cljs.core.count.call(null,right) === (0))){
return left;
} else {
return (new clojure.core.reducers.Cat((cljs.core.count.call(null,left) + cljs.core.count.call(null,right)),left,right));

}
}
});

clojure.core.reducers.cat.cljs$lang$maxFixedArity = 2;
/**
 * .adds x to acc and returns acc
 */
clojure.core.reducers.append_BANG_ = (function clojure$core$reducers$append_BANG_(acc,x){
var G__11462 = acc;
G__11462.push(x);

return G__11462;
});
/**
 * Equivalent to (fold cat append! coll)
 */
clojure.core.reducers.foldcat = (function clojure$core$reducers$foldcat(coll){
return clojure.core.reducers.fold.call(null,clojure.core.reducers.cat,clojure.core.reducers.append_BANG_,coll);
});
/**
 * Builds a combining fn out of the supplied operator and identity
 *   constructor. op must be associative and ctor called with no args
 *   must return an identity value for it.
 */
clojure.core.reducers.monoid = (function clojure$core$reducers$monoid(op,ctor){
return (function() {
var clojure$core$reducers$monoid_$_m = null;
var clojure$core$reducers$monoid_$_m__0 = (function (){
return ctor.call(null);
});
var clojure$core$reducers$monoid_$_m__2 = (function (a,b){
return op.call(null,a,b);
});
clojure$core$reducers$monoid_$_m = function(a,b){
switch(arguments.length){
case 0:
return clojure$core$reducers$monoid_$_m__0.call(this);
case 2:
return clojure$core$reducers$monoid_$_m__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clojure$core$reducers$monoid_$_m.cljs$core$IFn$_invoke$arity$0 = clojure$core$reducers$monoid_$_m__0;
clojure$core$reducers$monoid_$_m.cljs$core$IFn$_invoke$arity$2 = clojure$core$reducers$monoid_$_m__2;
return clojure$core$reducers$monoid_$_m;
})()
});
clojure.core.reducers.foldvec = (function clojure$core$reducers$foldvec(v,n,combinef,reducef){
if(cljs.core.empty_QMARK_.call(null,v)){
return combinef.call(null);
} else {
if((cljs.core.count.call(null,v) <= n)){
return clojure.core.reducers.reduce.call(null,reducef,combinef.call(null),v);
} else {
var split = cljs.core.quot.call(null,cljs.core.count.call(null,v),(2));
var v1 = cljs.core.subvec.call(null,v,(0),split);
var v2 = cljs.core.subvec.call(null,v,split,cljs.core.count.call(null,v));
var fc = ((function (split,v1,v2){
return (function (child){
return ((function (split,v1,v2){
return (function (){
return clojure$core$reducers$foldvec.call(null,child,n,combinef,reducef);
});
;})(split,v1,v2))
});})(split,v1,v2))
;
return clojure.core.reducers.fjinvoke.call(null,((function (split,v1,v2,fc){
return (function (){
var f1 = fc.call(null,v1);
var t2 = clojure.core.reducers.fjtask.call(null,fc.call(null,v2));
clojure.core.reducers.fjfork.call(null,t2);

return combinef.call(null,f1.call(null),clojure.core.reducers.fjjoin.call(null,t2));
});})(split,v1,v2,fc))
);

}
}
});
(clojure.core.reducers.CollFold["null"] = true);

(clojure.core.reducers.coll_fold["null"] = (function (coll,n,combinef,reducef){
return combinef.call(null);
}));

(clojure.core.reducers.CollFold["object"] = true);

(clojure.core.reducers.coll_fold["object"] = (function (coll,n,combinef,reducef){
return clojure.core.reducers.reduce.call(null,reducef,combinef.call(null),coll);
}));

cljs.core.PersistentVector.prototype.clojure$core$reducers$CollFold$ = true;

cljs.core.PersistentVector.prototype.clojure$core$reducers$CollFold$coll_fold$arity$4 = (function (v,n,combinef,reducef){
var v__$1 = this;
return clojure.core.reducers.foldvec.call(null,v__$1,n,combinef,reducef);
});
