// Compiled by ClojureScript 1.7.228 {}
goog.provide('derive.core');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Dependency tracker that is informed of encountered dependencies
 */
derive.core._STAR_tracker_STAR_ = null;
/**
 * Whether a dependency tracker should shadow lower level, used to
 *           implement stores
 */
derive.core._STAR_shadow_STAR_ = null;

/**
 * An immutable set of dependencies. Passed to dependency trackers
 *   during queries via record-dependency.
 * @interface
 */
derive.core.IDependencySet = function(){};

/**
 * Merge two dependencies
 */
derive.core.merge_deps = (function derive$core$merge_deps(this$,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySet$merge_deps$arity$2 == null)))){
return this$.derive$core$IDependencySet$merge_deps$arity$2(this$,deps);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.merge_deps[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,deps);
} else {
var m__6793__auto____$1 = (derive.core.merge_deps["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySet.merge-deps",this$);
}
}
}
});

/**
 * Match the current set to an incoming set - intersection semantics
 */
derive.core.match_deps = (function derive$core$match_deps(this$,set){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySet$match_deps$arity$2 == null)))){
return this$.derive$core$IDependencySet$match_deps$arity$2(this$,set);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.match_deps[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,set);
} else {
var m__6793__auto____$1 = (derive.core.match_deps["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,set);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySet.match-deps",this$);
}
}
}
});


/**
 * This interface is implemented by databases and derive methods to allow callers to
 * subscribe to subset of changes identified by the provided dependency set
 * @interface
 */
derive.core.IDependencySource = function(){};

/**
 * Call tracker method when deps match a change operation
 */
derive.core.subscribe_BANG_ = (function derive$core$subscribe_BANG_(var_args){
var args11611 = [];
var len__7195__auto___11617 = arguments.length;
var i__7196__auto___11618 = (0);
while(true){
if((i__7196__auto___11618 < len__7195__auto___11617)){
args11611.push((arguments[i__7196__auto___11618]));

var G__11619 = (i__7196__auto___11618 + (1));
i__7196__auto___11618 = G__11619;
continue;
} else {
}
break;
}

var G__11613 = args11611.length;
switch (G__11613) {
case 2:
return derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11611.length)].join('')));

}
});

derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,listener){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$subscribe_BANG_$arity$2 == null)))){
return this$.derive$core$IDependencySource$subscribe_BANG_$arity$2(this$,listener);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.subscribe_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,listener);
} else {
var m__6793__auto____$1 = (derive.core.subscribe_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,listener);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.subscribe!",this$);
}
}
}
});

derive.core.subscribe_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,listener,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$subscribe_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencySource$subscribe_BANG_$arity$3(this$,listener,deps);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.subscribe_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,listener,deps);
} else {
var m__6793__auto____$1 = (derive.core.subscribe_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,listener,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.subscribe!",this$);
}
}
}
});

derive.core.subscribe_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Call tracker method when deps match a change operation
 */
derive.core.unsubscribe_BANG_ = (function derive$core$unsubscribe_BANG_(var_args){
var args11614 = [];
var len__7195__auto___11621 = arguments.length;
var i__7196__auto___11622 = (0);
while(true){
if((i__7196__auto___11622 < len__7195__auto___11621)){
args11614.push((arguments[i__7196__auto___11622]));

var G__11623 = (i__7196__auto___11622 + (1));
i__7196__auto___11622 = G__11623;
continue;
} else {
}
break;
}

var G__11616 = args11614.length;
switch (G__11616) {
case 2:
return derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11614.length)].join('')));

}
});

derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,listener){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$2 == null)))){
return this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$2(this$,listener);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.unsubscribe_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,listener);
} else {
var m__6793__auto____$1 = (derive.core.unsubscribe_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,listener);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.unsubscribe!",this$);
}
}
}
});

derive.core.unsubscribe_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,listener,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencySource$unsubscribe_BANG_$arity$3(this$,listener,deps);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.unsubscribe_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,listener,deps);
} else {
var m__6793__auto____$1 = (derive.core.unsubscribe_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,listener,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.unsubscribe!",this$);
}
}
}
});

derive.core.unsubscribe_BANG_.cljs$lang$maxFixedArity = 3;

derive.core.empty_deps = (function derive$core$empty_deps(this$){
if((!((this$ == null))) && (!((this$.derive$core$IDependencySource$empty_deps$arity$1 == null)))){
return this$.derive$core$IDependencySource$empty_deps$arity$1(this$);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.empty_deps[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$);
} else {
var m__6793__auto____$1 = (derive.core.empty_deps["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencySource.empty-deps",this$);
}
}
}
});


/**
 * Implemented by function and component caches
 * @interface
 */
derive.core.IDependencyTracker = function(){};

/**
 * Dependency sources call this method if a tracker is bound in the current
 *   context with dependencies that are encountered during query processing.
 */
derive.core.depends_BANG_ = (function derive$core$depends_BANG_(this$,store,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyTracker$depends_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencyTracker$depends_BANG_$arity$3(this$,store,deps);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.depends_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,store,deps);
} else {
var m__6793__auto____$1 = (derive.core.depends_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,store,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyTracker.depends!",this$);
}
}
}
});

/**
 * The current dependencies encountered by this tracker
 */
derive.core.dependencies = (function derive$core$dependencies(this$){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyTracker$dependencies$arity$1 == null)))){
return this$.derive$core$IDependencyTracker$dependencies$arity$1(this$);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.dependencies[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$);
} else {
var m__6793__auto____$1 = (derive.core.dependencies["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyTracker.dependencies",this$);
}
}
}
});


/**
 * A utility API for tracking dependencies, allows us to provide more
 * advanced options for assembling tracker policies
 * @interface
 */
derive.core.IDependencyCache = function(){};

/**
 * Clear cache
 */
derive.core.reset_BANG_ = (function derive$core$reset_BANG_(this$){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$reset_BANG_$arity$1 == null)))){
return this$.derive$core$IDependencyCache$reset_BANG_$arity$1(this$);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.reset_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$);
} else {
var m__6793__auto____$1 = (derive.core.reset_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.reset!",this$);
}
}
}
});

/**
 * Returns cached value if exists for params
 */
derive.core.get_value = (function derive$core$get_value(this$,params){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$get_value$arity$2 == null)))){
return this$.derive$core$IDependencyCache$get_value$arity$2(this$,params);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.get_value[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,params);
} else {
var m__6793__auto____$1 = (derive.core.get_value["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,params);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.get-value",this$);
}
}
}
});

/**
 * Informs store that a particular params yeilds value given current store + deps
 */
derive.core.add_value_BANG_ = (function derive$core$add_value_BANG_(this$,params,value,dependency_map){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$add_value_BANG_$arity$4 == null)))){
return this$.derive$core$IDependencyCache$add_value_BANG_$arity$4(this$,params,value,dependency_map);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.add_value_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,params,value,dependency_map);
} else {
var m__6793__auto____$1 = (derive.core.add_value_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,params,value,dependency_map);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.add-value!",this$);
}
}
}
});

derive.core.rem_value_BANG_ = (function derive$core$rem_value_BANG_(this$,params){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$rem_value_BANG_$arity$2 == null)))){
return this$.derive$core$IDependencyCache$rem_value_BANG_$arity$2(this$,params);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.rem_value_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,params);
} else {
var m__6793__auto____$1 = (derive.core.rem_value_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,params);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.rem-value!",this$);
}
}
}
});

derive.core.invalidate_BANG_ = (function derive$core$invalidate_BANG_(this$,store,deps){
if((!((this$ == null))) && (!((this$.derive$core$IDependencyCache$invalidate_BANG_$arity$3 == null)))){
return this$.derive$core$IDependencyCache$invalidate_BANG_$arity$3(this$,store,deps);
} else {
var x__6792__auto__ = (((this$ == null))?null:this$);
var m__6793__auto__ = (derive.core.invalidate_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,this$,store,deps);
} else {
var m__6793__auto____$1 = (derive.core.invalidate_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,this$,store,deps);
} else {
throw cljs.core.missing_protocol.call(null,"IDependencyCache.invalidate!",this$);
}
}
}
});

cljs.core.PersistentHashSet.prototype.derive$core$IDependencySet$ = true;

cljs.core.PersistentHashSet.prototype.derive$core$IDependencySet$merge_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return clojure.set.union.call(null,this$__$1,deps);
});

cljs.core.PersistentHashSet.prototype.derive$core$IDependencySet$match_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return ((deps == null)) || (!(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,this$__$1,deps))));
});

cljs.core.PersistentTreeSet.prototype.derive$core$IDependencySet$ = true;

cljs.core.PersistentTreeSet.prototype.derive$core$IDependencySet$merge_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return clojure.set.union.call(null,this$__$1,deps);
});

cljs.core.PersistentTreeSet.prototype.derive$core$IDependencySet$match_deps$arity$2 = (function (this$,deps){
var this$__$1 = this;
return ((deps == null)) || (!(cljs.core.empty_QMARK_.call(null,clojure.set.intersection.call(null,this$__$1,deps))));
});
derive.core.matching_dep_QMARK_ = (function derive$core$matching_dep_QMARK_(dmap,store,deps){
return cljs.core.some.call(null,(function (p__11627){
var vec__11628 = p__11627;
var vstore = cljs.core.nth.call(null,vec__11628,(0),null);
var vdeps = cljs.core.nth.call(null,vec__11628,(1),null);
var and__6125__auto__ = cljs.core._EQ_.call(null,store,vstore);
if(and__6125__auto__){
var or__6137__auto__ = (deps == null);
if(or__6137__auto__){
return or__6137__auto__;
} else {
var or__6137__auto____$1 = (vdeps == null);
if(or__6137__auto____$1){
return or__6137__auto____$1;
} else {
return derive.core.match_deps.call(null,vdeps,deps);
}
}
} else {
return and__6125__auto__;
}
}),dmap);
});

/**
* @constructor
 * @implements {derive.core.IDependencyCache}
*/
derive.core.DefaultCache = (function (cache){
this.cache = cache;
})
derive.core.DefaultCache.prototype.derive$core$IDependencyCache$ = true;

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$get_value$arity$2 = (function (_,params){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.cache,params);
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$add_value_BANG_$arity$4 = (function (this$,params,value,dmap){
var self__ = this;
var this$__$1 = this;
self__.cache = cljs.core.assoc.call(null,self__.cache,params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [value,dmap], null));

return this$__$1;
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$rem_value_BANG_$arity$2 = (function (this$,params){
var self__ = this;
var this$__$1 = this;
return self__.cache = cljs.core.dissoc.call(null,self__.cache,params);
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$invalidate_BANG_$arity$3 = (function (this$,store,deps){
var self__ = this;
var this$__$1 = this;
var vec__11629 = cljs.core.reduce.call(null,((function (this$__$1){
return (function (p__11630,p__11631){
var vec__11632 = p__11630;
var c = cljs.core.nth.call(null,vec__11632,(0),null);
var i = cljs.core.nth.call(null,vec__11632,(1),null);
var vec__11633 = p__11631;
var params = cljs.core.nth.call(null,vec__11633,(0),null);
var vec__11634 = cljs.core.nth.call(null,vec__11633,(1),null);
var value = cljs.core.nth.call(null,vec__11634,(0),null);
var dmap = cljs.core.nth.call(null,vec__11634,(1),null);
if(cljs.core.truth_(derive.core.matching_dep_QMARK_.call(null,dmap,store,deps))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.dissoc_BANG_.call(null,c,params),cljs.core.conj.call(null,i,params)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c,i], null);
}
});})(this$__$1))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$.call(null,self__.cache),cljs.core.PersistentVector.EMPTY], null),self__.cache);
var c = cljs.core.nth.call(null,vec__11629,(0),null);
var invalidated = cljs.core.nth.call(null,vec__11629,(1),null);
self__.cache = cljs.core.persistent_BANG_.call(null,c);

return invalidated;
});

derive.core.DefaultCache.prototype.derive$core$IDependencyCache$reset_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
self__.cache = cljs.core.PersistentArrayMap.EMPTY;

return this$__$1;
});

derive.core.DefaultCache.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

derive.core.DefaultCache.cljs$lang$type = true;

derive.core.DefaultCache.cljs$lang$ctorStr = "derive.core/DefaultCache";

derive.core.DefaultCache.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"derive.core/DefaultCache");
});

derive.core.__GT_DefaultCache = (function derive$core$__GT_DefaultCache(cache){
return (new derive.core.DefaultCache(cache));
});

derive.core.default_cache = (function derive$core$default_cache(){
return (new derive.core.DefaultCache(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {derive.core.IDependencyTracker}
*/
derive.core.DefaultTracker = (function (dmap){
this.dmap = dmap;
})
derive.core.DefaultTracker.prototype.derive$core$IDependencyTracker$ = true;

derive.core.DefaultTracker.prototype.derive$core$IDependencyTracker$depends_BANG_$arity$3 = (function (this$,store,new_deps){
var self__ = this;
var this$__$1 = this;
self__.dmap = cljs.core.update_in.call(null,self__.dmap,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [store], null),cljs.core.fnil.call(null,derive.core.merge_deps,derive.core.empty_deps.call(null,store)),new_deps);

return this$__$1;
});

derive.core.DefaultTracker.prototype.derive$core$IDependencyTracker$dependencies$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.dmap;
});

derive.core.DefaultTracker.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"dmap","dmap",-1773751947,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

derive.core.DefaultTracker.cljs$lang$type = true;

derive.core.DefaultTracker.cljs$lang$ctorStr = "derive.core/DefaultTracker";

derive.core.DefaultTracker.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"derive.core/DefaultTracker");
});

derive.core.__GT_DefaultTracker = (function derive$core$__GT_DefaultTracker(dmap){
return (new derive.core.DefaultTracker(dmap));
});

derive.core.default_tracker = (function derive$core$default_tracker(var_args){
var args11635 = [];
var len__7195__auto___11638 = arguments.length;
var i__7196__auto___11639 = (0);
while(true){
if((i__7196__auto___11639 < len__7195__auto___11638)){
args11635.push((arguments[i__7196__auto___11639]));

var G__11640 = (i__7196__auto___11639 + (1));
i__7196__auto___11639 = G__11640;
continue;
} else {
}
break;
}

var G__11637 = args11635.length;
switch (G__11637) {
case 0:
return derive.core.default_tracker.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return derive.core.default_tracker.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11635.length)].join('')));

}
});

derive.core.default_tracker.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new derive.core.DefaultTracker(cljs.core.PersistentArrayMap.EMPTY));
});

derive.core.default_tracker.cljs$core$IFn$_invoke$arity$1 = (function (dmap){
return (new derive.core.DefaultTracker(dmap));
});

derive.core.default_tracker.cljs$lang$maxFixedArity = 1;
derive.core.tracking_QMARK_ = (function derive$core$tracking_QMARK_(){
return !((derive.core._STAR_tracker_STAR_ == null));
});
derive.core.inform_tracker = (function derive$core$inform_tracker(var_args){
var args11642 = [];
var len__7195__auto___11645 = arguments.length;
var i__7196__auto___11646 = (0);
while(true){
if((i__7196__auto___11646 < len__7195__auto___11645)){
args11642.push((arguments[i__7196__auto___11646]));

var G__11647 = (i__7196__auto___11646 + (1));
i__7196__auto___11646 = G__11647;
continue;
} else {
}
break;
}

var G__11644 = args11642.length;
switch (G__11644) {
case 2:
return derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11642.length)].join('')));

}
});

derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$2 = (function (store,args){
if(cljs.core.truth_(derive.core.tracking_QMARK_.call(null))){
return derive.core.inform_tracker.call(null,derive.core._STAR_tracker_STAR_,store,args);
} else {
return null;
}
});

derive.core.inform_tracker.cljs$core$IFn$_invoke$arity$3 = (function (tracker,store,args){
return derive.core.depends_BANG_.call(null,tracker,store,((cljs.core.set_QMARK_.call(null,args))?args:cljs.core.PersistentHashSet.fromArray([args], true)));
});

derive.core.inform_tracker.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {derive.core.IDependencySource}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.Fn}
*/
derive.core.DeriveFn = (function (fname,dfn,lfn,subscriptions,cache,listeners){
this.fname = fname;
this.dfn = dfn;
this.lfn = lfn;
this.subscriptions = subscriptions;
this.cache = cache;
this.listeners = listeners;
this.cljs$lang$protocol_mask$partition0$ = 1;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
derive.core.DeriveFn.prototype.cljs$core$Fn$ = true;

derive.core.DeriveFn.prototype.call = (function() {
var G__11650 = null;
var G__11650__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return self__.dfn.call(null,this$);
});
var G__11650__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));

return self__.dfn.call(null,this$,a);
});
var G__11650__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null));

return self__.dfn.call(null,this$,a,b);
});
var G__11650__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c], null));

return self__.dfn.call(null,this$,a,b,c);
});
var G__11650__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d], null));

return self__.dfn.call(null,this$,a,b,c,d);
});
var G__11650__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e], null));

return self__.dfn.call(null,this$,a,b,c,d,e);
});
var G__11650__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f);
});
var G__11650__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g);
});
var G__11650__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h);
});
var G__11650__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i);
});
var G__11650__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j);
});
var G__11650__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
});
var G__11650__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__11650__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__11650__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__11650__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__11650__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__11650__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__11650__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__11650__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__11650__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__11650__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], null));

return cljs.core.apply.call(null,self__.dfn,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
});
G__11650 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__11650__1.call(this,self__);
case 2:
return G__11650__2.call(this,self__,a);
case 3:
return G__11650__3.call(this,self__,a,b);
case 4:
return G__11650__4.call(this,self__,a,b,c);
case 5:
return G__11650__5.call(this,self__,a,b,c,d);
case 6:
return G__11650__6.call(this,self__,a,b,c,d,e);
case 7:
return G__11650__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__11650__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__11650__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__11650__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__11650__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__11650__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__11650__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__11650__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__11650__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__11650__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__11650__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__11650__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__11650__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__11650__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__11650__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__11650__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11650.cljs$core$IFn$_invoke$arity$1 = G__11650__1;
G__11650.cljs$core$IFn$_invoke$arity$2 = G__11650__2;
G__11650.cljs$core$IFn$_invoke$arity$3 = G__11650__3;
G__11650.cljs$core$IFn$_invoke$arity$4 = G__11650__4;
G__11650.cljs$core$IFn$_invoke$arity$5 = G__11650__5;
G__11650.cljs$core$IFn$_invoke$arity$6 = G__11650__6;
G__11650.cljs$core$IFn$_invoke$arity$7 = G__11650__7;
G__11650.cljs$core$IFn$_invoke$arity$8 = G__11650__8;
G__11650.cljs$core$IFn$_invoke$arity$9 = G__11650__9;
G__11650.cljs$core$IFn$_invoke$arity$10 = G__11650__10;
G__11650.cljs$core$IFn$_invoke$arity$11 = G__11650__11;
G__11650.cljs$core$IFn$_invoke$arity$12 = G__11650__12;
G__11650.cljs$core$IFn$_invoke$arity$13 = G__11650__13;
G__11650.cljs$core$IFn$_invoke$arity$14 = G__11650__14;
G__11650.cljs$core$IFn$_invoke$arity$15 = G__11650__15;
G__11650.cljs$core$IFn$_invoke$arity$16 = G__11650__16;
G__11650.cljs$core$IFn$_invoke$arity$17 = G__11650__17;
G__11650.cljs$core$IFn$_invoke$arity$18 = G__11650__18;
G__11650.cljs$core$IFn$_invoke$arity$19 = G__11650__19;
G__11650.cljs$core$IFn$_invoke$arity$20 = G__11650__20;
G__11650.cljs$core$IFn$_invoke$arity$21 = G__11650__21;
G__11650.cljs$core$IFn$_invoke$arity$22 = G__11650__22;
return G__11650;
})()
;

derive.core.DeriveFn.prototype.apply = (function (self__,args11649){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args11649)));
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var this$ = this;
return self__.dfn.call(null,this$);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));

return self__.dfn.call(null,this$,a);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null));

return self__.dfn.call(null,this$,a,b);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c], null));

return self__.dfn.call(null,this$,a,b,c);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d], null));

return self__.dfn.call(null,this$,a,b,c,d);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e], null));

return self__.dfn.call(null,this$,a,b,c,d,e);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t], null));

return self__.dfn.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

derive.core.DeriveFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var this$ = this;
derive.core.inform_tracker.call(null,this$,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], null));

return cljs.core.apply.call(null,self__.dfn,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$ = true;

derive.core.DeriveFn.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deps], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),cljs.core.disj,listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deps], null),cljs.core.disj,listener);
});

derive.core.DeriveFn.prototype.derive$core$IDependencySource$empty_deps$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.PersistentHashSet.EMPTY;
});

derive.core.DeriveFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fname","fname",-1154144278,null),new cljs.core.Symbol(null,"dfn","dfn",1882439694,null),new cljs.core.Symbol(null,"lfn","lfn",-813958040,null),cljs.core.with_meta(new cljs.core.Symbol(null,"subscriptions","subscriptions",-1403485993,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"listeners","listeners",2035075972,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

derive.core.DeriveFn.cljs$lang$type = true;

derive.core.DeriveFn.cljs$lang$ctorStr = "derive.core/DeriveFn";

derive.core.DeriveFn.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"derive.core/DeriveFn");
});

derive.core.__GT_DeriveFn = (function derive$core$__GT_DeriveFn(fname,dfn,lfn,subscriptions,cache,listeners){
return (new derive.core.DeriveFn(fname,dfn,lfn,subscriptions,cache,listeners));
});

/**
 * Only primitive values and clojure data stuctures are legal
 * (must support value equality)
 */
derive.core.legal_param_QMARK_ = (function derive$core$legal_param_QMARK_(val){
var or__6137__auto__ = typeof val === 'string';
if(or__6137__auto__){
return or__6137__auto__;
} else {
var or__6137__auto____$1 = typeof val === 'number';
if(or__6137__auto____$1){
return or__6137__auto____$1;
} else {
var or__6137__auto____$2 = (val instanceof cljs.core.Symbol);
if(or__6137__auto____$2){
return or__6137__auto____$2;
} else {
var or__6137__auto____$3 = (val instanceof cljs.core.Keyword);
if(or__6137__auto____$3){
return or__6137__auto____$3;
} else {
var or__6137__auto____$4 = cljs.core._EQ_.call(null,val,true);
if(or__6137__auto____$4){
return or__6137__auto____$4;
} else {
var or__6137__auto____$5 = cljs.core._EQ_.call(null,val,false);
if(or__6137__auto____$5){
return or__6137__auto____$5;
} else {
var or__6137__auto____$6 = cljs.core.map_QMARK_.call(null,val);
if(or__6137__auto____$6){
return or__6137__auto____$6;
} else {
var or__6137__auto____$7 = cljs.core.vector_QMARK_.call(null,val);
if(or__6137__auto____$7){
return or__6137__auto____$7;
} else {
var or__6137__auto____$8 = cljs.core.list_QMARK_.call(null,val);
if(or__6137__auto____$8){
return or__6137__auto____$8;
} else {
var or__6137__auto____$9 = (val == null);
if(or__6137__auto____$9){
return or__6137__auto____$9;
} else {
var or__6137__auto____$10 = ((!((val == null)))?(((false) || (val.derive$core$IDependencySource$))?true:(((!val.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,derive.core.IDependencySource,val):false)):cljs.core.native_satisfies_QMARK_.call(null,derive.core.IDependencySource,val));
if(or__6137__auto____$10){
return or__6137__auto____$10;
} else {
return (cljs.core._EQ_.call(null,cljs.core.type.call(null,val),cljs.core.type.call(null,(new Date())))) || ((!((void 0 === moment))) && (cljs.core._EQ_.call(null,cljs.core.type.call(null,val),cljs.core.type.call(null,moment()))));
}
}
}
}
}
}
}
}
}
}
}
});
derive.core.legal_params_QMARK_ = (function derive$core$legal_params_QMARK_(vals){
return cljs.core.every_QMARK_.call(null,derive.core.legal_param_QMARK_,vals);
});
derive.core.empty_derive_fn = (function derive$core$empty_derive_fn(var_args){
var args__7202__auto__ = [];
var len__7195__auto___11676 = arguments.length;
var i__7196__auto___11677 = (0);
while(true){
if((i__7196__auto___11677 < len__7195__auto___11676)){
args__7202__auto__.push((arguments[i__7196__auto___11677]));

var G__11678 = (i__7196__auto___11677 + (1));
i__7196__auto___11677 = G__11678;
continue;
} else {
}
break;
}

var argseq__7203__auto__ = ((((0) < args__7202__auto__.length))?(new cljs.core.IndexedSeq(args__7202__auto__.slice((0)),(0))):null);
return derive.core.empty_derive_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__7203__auto__);
});

derive.core.empty_derive_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Uninitialized derive fn"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,false))].join('')));

});

derive.core.empty_derive_fn.cljs$lang$maxFixedArity = (0);

derive.core.empty_derive_fn.cljs$lang$applyTo = (function (seq11675){
return derive.core.empty_derive_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11675));
});
derive.core.create_derive_fn = (function derive$core$create_derive_fn(fname){
return (new derive.core.DeriveFn(fname,derive.core.empty_derive_fn,derive.core.empty_derive_fn,cljs.core.PersistentHashSet.EMPTY,derive.core.default_cache.call(null),cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Ensure we're subscribed to stores we encounter
 */
derive.core.ensure_subscription = (function derive$core$ensure_subscription(derive__$1,store){
if(cljs.core.truth_(derive__$1.subscriptions.call(null,store))){
return null;
} else {
derive.core.subscribe_BANG_.call(null,store,derive__$1.lfn);

return derive__$1.subscriptions = cljs.core.conj.call(null,derive__$1.subscriptions,store);
}
});
derive.core.release_subscriptions = (function derive$core$release_subscriptions(derive__$1){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (p1__11679_SHARP_){
return derive.core.unsubscribe_BANG_.call(null,p1__11679_SHARP_,derive__$1.lfn);
}),derive__$1.subscriptions));
});
/**
 * Handle deps and cache values from normal calls
 */
derive.core.derive_value = (function derive$core$derive_value(derive__$1,params){
return cljs.core.first.call(null,derive.core.get_value.call(null,derive__$1.cache,params));
});
derive.core.tracker_handler = (function derive$core$tracker_handler(dfn,params){
return (function (result,dmap){
var seq__11686_11692 = cljs.core.seq.call(null,dmap);
var chunk__11687_11693 = null;
var count__11688_11694 = (0);
var i__11689_11695 = (0);
while(true){
if((i__11689_11695 < count__11688_11694)){
var vec__11690_11696 = cljs.core._nth.call(null,chunk__11687_11693,i__11689_11695);
var store_11697 = cljs.core.nth.call(null,vec__11690_11696,(0),null);
var deps_11698 = cljs.core.nth.call(null,vec__11690_11696,(1),null);
derive.core.ensure_subscription.call(null,dfn,store_11697);

var G__11699 = seq__11686_11692;
var G__11700 = chunk__11687_11693;
var G__11701 = count__11688_11694;
var G__11702 = (i__11689_11695 + (1));
seq__11686_11692 = G__11699;
chunk__11687_11693 = G__11700;
count__11688_11694 = G__11701;
i__11689_11695 = G__11702;
continue;
} else {
var temp__4425__auto___11703 = cljs.core.seq.call(null,seq__11686_11692);
if(temp__4425__auto___11703){
var seq__11686_11704__$1 = temp__4425__auto___11703;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11686_11704__$1)){
var c__6940__auto___11705 = cljs.core.chunk_first.call(null,seq__11686_11704__$1);
var G__11706 = cljs.core.chunk_rest.call(null,seq__11686_11704__$1);
var G__11707 = c__6940__auto___11705;
var G__11708 = cljs.core.count.call(null,c__6940__auto___11705);
var G__11709 = (0);
seq__11686_11692 = G__11706;
chunk__11687_11693 = G__11707;
count__11688_11694 = G__11708;
i__11689_11695 = G__11709;
continue;
} else {
var vec__11691_11710 = cljs.core.first.call(null,seq__11686_11704__$1);
var store_11711 = cljs.core.nth.call(null,vec__11691_11710,(0),null);
var deps_11712 = cljs.core.nth.call(null,vec__11691_11710,(1),null);
derive.core.ensure_subscription.call(null,dfn,store_11711);

var G__11713 = cljs.core.next.call(null,seq__11686_11704__$1);
var G__11714 = null;
var G__11715 = (0);
var G__11716 = (0);
seq__11686_11692 = G__11713;
chunk__11687_11693 = G__11714;
count__11688_11694 = G__11715;
i__11689_11695 = G__11716;
continue;
}
} else {
}
}
break;
}

return derive.core.add_value_BANG_.call(null,dfn.cache,params,result,dmap);
});
});
derive.core.notify_listeners = (function derive$core$notify_listeners(store,deps){
var listeners = store.listeners;
var seq__11731 = cljs.core.seq.call(null,cljs.core.keys.call(null,listeners));
var chunk__11733 = null;
var count__11734 = (0);
var i__11735 = (0);
while(true){
if((i__11735 < count__11734)){
var ldeps = cljs.core._nth.call(null,chunk__11733,i__11735);
if(cljs.core.truth_((function (){var or__6137__auto__ = (ldeps == null);
if(or__6137__auto__){
return or__6137__auto__;
} else {
return derive.core.match_deps.call(null,ldeps,deps);
}
})())){
var seq__11737_11745 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11738_11746 = null;
var count__11739_11747 = (0);
var i__11740_11748 = (0);
while(true){
if((i__11740_11748 < count__11739_11747)){
var l_11749 = cljs.core._nth.call(null,chunk__11738_11746,i__11740_11748);
l_11749.call(null,store,deps);

var G__11750 = seq__11737_11745;
var G__11751 = chunk__11738_11746;
var G__11752 = count__11739_11747;
var G__11753 = (i__11740_11748 + (1));
seq__11737_11745 = G__11750;
chunk__11738_11746 = G__11751;
count__11739_11747 = G__11752;
i__11740_11748 = G__11753;
continue;
} else {
var temp__4425__auto___11754 = cljs.core.seq.call(null,seq__11737_11745);
if(temp__4425__auto___11754){
var seq__11737_11755__$1 = temp__4425__auto___11754;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11737_11755__$1)){
var c__6940__auto___11756 = cljs.core.chunk_first.call(null,seq__11737_11755__$1);
var G__11757 = cljs.core.chunk_rest.call(null,seq__11737_11755__$1);
var G__11758 = c__6940__auto___11756;
var G__11759 = cljs.core.count.call(null,c__6940__auto___11756);
var G__11760 = (0);
seq__11737_11745 = G__11757;
chunk__11738_11746 = G__11758;
count__11739_11747 = G__11759;
i__11740_11748 = G__11760;
continue;
} else {
var l_11761 = cljs.core.first.call(null,seq__11737_11755__$1);
l_11761.call(null,store,deps);

var G__11762 = cljs.core.next.call(null,seq__11737_11755__$1);
var G__11763 = null;
var G__11764 = (0);
var G__11765 = (0);
seq__11737_11745 = G__11762;
chunk__11738_11746 = G__11763;
count__11739_11747 = G__11764;
i__11740_11748 = G__11765;
continue;
}
} else {
}
}
break;
}

var G__11766 = seq__11731;
var G__11767 = chunk__11733;
var G__11768 = count__11734;
var G__11769 = (i__11735 + (1));
seq__11731 = G__11766;
chunk__11733 = G__11767;
count__11734 = G__11768;
i__11735 = G__11769;
continue;
} else {
var G__11770 = seq__11731;
var G__11771 = chunk__11733;
var G__11772 = count__11734;
var G__11773 = (i__11735 + (1));
seq__11731 = G__11770;
chunk__11733 = G__11771;
count__11734 = G__11772;
i__11735 = G__11773;
continue;
}
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__11731);
if(temp__4425__auto__){
var seq__11731__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11731__$1)){
var c__6940__auto__ = cljs.core.chunk_first.call(null,seq__11731__$1);
var G__11774 = cljs.core.chunk_rest.call(null,seq__11731__$1);
var G__11775 = c__6940__auto__;
var G__11776 = cljs.core.count.call(null,c__6940__auto__);
var G__11777 = (0);
seq__11731 = G__11774;
chunk__11733 = G__11775;
count__11734 = G__11776;
i__11735 = G__11777;
continue;
} else {
var ldeps = cljs.core.first.call(null,seq__11731__$1);
if(cljs.core.truth_((function (){var or__6137__auto__ = (ldeps == null);
if(or__6137__auto__){
return or__6137__auto__;
} else {
return derive.core.match_deps.call(null,ldeps,deps);
}
})())){
var seq__11741_11778 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11742_11779 = null;
var count__11743_11780 = (0);
var i__11744_11781 = (0);
while(true){
if((i__11744_11781 < count__11743_11780)){
var l_11782 = cljs.core._nth.call(null,chunk__11742_11779,i__11744_11781);
l_11782.call(null,store,deps);

var G__11783 = seq__11741_11778;
var G__11784 = chunk__11742_11779;
var G__11785 = count__11743_11780;
var G__11786 = (i__11744_11781 + (1));
seq__11741_11778 = G__11783;
chunk__11742_11779 = G__11784;
count__11743_11780 = G__11785;
i__11744_11781 = G__11786;
continue;
} else {
var temp__4425__auto___11787__$1 = cljs.core.seq.call(null,seq__11741_11778);
if(temp__4425__auto___11787__$1){
var seq__11741_11788__$1 = temp__4425__auto___11787__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11741_11788__$1)){
var c__6940__auto___11789 = cljs.core.chunk_first.call(null,seq__11741_11788__$1);
var G__11790 = cljs.core.chunk_rest.call(null,seq__11741_11788__$1);
var G__11791 = c__6940__auto___11789;
var G__11792 = cljs.core.count.call(null,c__6940__auto___11789);
var G__11793 = (0);
seq__11741_11778 = G__11790;
chunk__11742_11779 = G__11791;
count__11743_11780 = G__11792;
i__11744_11781 = G__11793;
continue;
} else {
var l_11794 = cljs.core.first.call(null,seq__11741_11788__$1);
l_11794.call(null,store,deps);

var G__11795 = cljs.core.next.call(null,seq__11741_11788__$1);
var G__11796 = null;
var G__11797 = (0);
var G__11798 = (0);
seq__11741_11778 = G__11795;
chunk__11742_11779 = G__11796;
count__11743_11780 = G__11797;
i__11744_11781 = G__11798;
continue;
}
} else {
}
}
break;
}

var G__11799 = cljs.core.next.call(null,seq__11731__$1);
var G__11800 = null;
var G__11801 = (0);
var G__11802 = (0);
seq__11731 = G__11799;
chunk__11733 = G__11800;
count__11734 = G__11801;
i__11735 = G__11802;
continue;
} else {
var G__11803 = cljs.core.next.call(null,seq__11731__$1);
var G__11804 = null;
var G__11805 = (0);
var G__11806 = (0);
seq__11731 = G__11803;
chunk__11733 = G__11804;
count__11734 = G__11805;
i__11735 = G__11806;
continue;
}
}
} else {
return null;
}
}
break;
}
});
/**
 * Force invalidate all listeners to this store
 */
derive.core.force_invalidation = (function derive$core$force_invalidation(store){
var listeners = store.listeners;
var seq__11819 = cljs.core.seq.call(null,cljs.core.keys.call(null,listeners));
var chunk__11820 = null;
var count__11821 = (0);
var i__11822 = (0);
while(true){
if((i__11822 < count__11821)){
var ldeps = cljs.core._nth.call(null,chunk__11820,i__11822);
var seq__11823_11831 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11824_11832 = null;
var count__11825_11833 = (0);
var i__11826_11834 = (0);
while(true){
if((i__11826_11834 < count__11825_11833)){
var l_11835 = cljs.core._nth.call(null,chunk__11824_11832,i__11826_11834);
l_11835.call(null,store,null);

var G__11836 = seq__11823_11831;
var G__11837 = chunk__11824_11832;
var G__11838 = count__11825_11833;
var G__11839 = (i__11826_11834 + (1));
seq__11823_11831 = G__11836;
chunk__11824_11832 = G__11837;
count__11825_11833 = G__11838;
i__11826_11834 = G__11839;
continue;
} else {
var temp__4425__auto___11840 = cljs.core.seq.call(null,seq__11823_11831);
if(temp__4425__auto___11840){
var seq__11823_11841__$1 = temp__4425__auto___11840;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11823_11841__$1)){
var c__6940__auto___11842 = cljs.core.chunk_first.call(null,seq__11823_11841__$1);
var G__11843 = cljs.core.chunk_rest.call(null,seq__11823_11841__$1);
var G__11844 = c__6940__auto___11842;
var G__11845 = cljs.core.count.call(null,c__6940__auto___11842);
var G__11846 = (0);
seq__11823_11831 = G__11843;
chunk__11824_11832 = G__11844;
count__11825_11833 = G__11845;
i__11826_11834 = G__11846;
continue;
} else {
var l_11847 = cljs.core.first.call(null,seq__11823_11841__$1);
l_11847.call(null,store,null);

var G__11848 = cljs.core.next.call(null,seq__11823_11841__$1);
var G__11849 = null;
var G__11850 = (0);
var G__11851 = (0);
seq__11823_11831 = G__11848;
chunk__11824_11832 = G__11849;
count__11825_11833 = G__11850;
i__11826_11834 = G__11851;
continue;
}
} else {
}
}
break;
}

var G__11852 = seq__11819;
var G__11853 = chunk__11820;
var G__11854 = count__11821;
var G__11855 = (i__11822 + (1));
seq__11819 = G__11852;
chunk__11820 = G__11853;
count__11821 = G__11854;
i__11822 = G__11855;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__11819);
if(temp__4425__auto__){
var seq__11819__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11819__$1)){
var c__6940__auto__ = cljs.core.chunk_first.call(null,seq__11819__$1);
var G__11856 = cljs.core.chunk_rest.call(null,seq__11819__$1);
var G__11857 = c__6940__auto__;
var G__11858 = cljs.core.count.call(null,c__6940__auto__);
var G__11859 = (0);
seq__11819 = G__11856;
chunk__11820 = G__11857;
count__11821 = G__11858;
i__11822 = G__11859;
continue;
} else {
var ldeps = cljs.core.first.call(null,seq__11819__$1);
var seq__11827_11860 = cljs.core.seq.call(null,cljs.core.get.call(null,listeners,ldeps));
var chunk__11828_11861 = null;
var count__11829_11862 = (0);
var i__11830_11863 = (0);
while(true){
if((i__11830_11863 < count__11829_11862)){
var l_11864 = cljs.core._nth.call(null,chunk__11828_11861,i__11830_11863);
l_11864.call(null,store,null);

var G__11865 = seq__11827_11860;
var G__11866 = chunk__11828_11861;
var G__11867 = count__11829_11862;
var G__11868 = (i__11830_11863 + (1));
seq__11827_11860 = G__11865;
chunk__11828_11861 = G__11866;
count__11829_11862 = G__11867;
i__11830_11863 = G__11868;
continue;
} else {
var temp__4425__auto___11869__$1 = cljs.core.seq.call(null,seq__11827_11860);
if(temp__4425__auto___11869__$1){
var seq__11827_11870__$1 = temp__4425__auto___11869__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11827_11870__$1)){
var c__6940__auto___11871 = cljs.core.chunk_first.call(null,seq__11827_11870__$1);
var G__11872 = cljs.core.chunk_rest.call(null,seq__11827_11870__$1);
var G__11873 = c__6940__auto___11871;
var G__11874 = cljs.core.count.call(null,c__6940__auto___11871);
var G__11875 = (0);
seq__11827_11860 = G__11872;
chunk__11828_11861 = G__11873;
count__11829_11862 = G__11874;
i__11830_11863 = G__11875;
continue;
} else {
var l_11876 = cljs.core.first.call(null,seq__11827_11870__$1);
l_11876.call(null,store,null);

var G__11877 = cljs.core.next.call(null,seq__11827_11870__$1);
var G__11878 = null;
var G__11879 = (0);
var G__11880 = (0);
seq__11827_11860 = G__11877;
chunk__11828_11861 = G__11878;
count__11829_11862 = G__11879;
i__11830_11863 = G__11880;
continue;
}
} else {
}
}
break;
}

var G__11881 = cljs.core.next.call(null,seq__11819__$1);
var G__11882 = null;
var G__11883 = (0);
var G__11884 = (0);
seq__11819 = G__11881;
chunk__11820 = G__11882;
count__11821 = G__11883;
i__11822 = G__11884;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Helper. Handle source listener events
 */
derive.core.derive_listener = (function derive$core$derive_listener(derive__$1,store,deps){
var cache = derive__$1.cache;
var param_set = cljs.core.set.call(null,derive.core.invalidate_BANG_.call(null,cache,store,deps));
if(cljs.core.empty_QMARK_.call(null,param_set)){
return null;
} else {
return derive.core.notify_listeners.call(null,derive__$1,param_set);
}
});
/**
 * Helper. Inform upstream when we're redefined
 */
derive.core.invalidate_all_listeners = (function derive$core$invalidate_all_listeners(derive__$1){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (f){
return f.call(null,derive__$1,null);
}),cljs.core.flatten.call(null,cljs.core.vals.call(null,derive__$1.listeners))));
});
/**
 * Call from will-unmount and when re-subscribing a component
 */
derive.core.clear_listener_BANG_ = (function derive$core$clear_listener_BANG_(owner){
var listener = (owner["__derive_listener"]);
var dmap = (owner["__derive_dmap"]);
var seq__11891_11897 = cljs.core.seq.call(null,dmap);
var chunk__11892_11898 = null;
var count__11893_11899 = (0);
var i__11894_11900 = (0);
while(true){
if((i__11894_11900 < count__11893_11899)){
var vec__11895_11901 = cljs.core._nth.call(null,chunk__11892_11898,i__11894_11900);
var store_11902 = cljs.core.nth.call(null,vec__11895_11901,(0),null);
var query_deps_11903 = cljs.core.nth.call(null,vec__11895_11901,(1),null);
derive.core.unsubscribe_BANG_.call(null,store_11902,listener,query_deps_11903);

var G__11904 = seq__11891_11897;
var G__11905 = chunk__11892_11898;
var G__11906 = count__11893_11899;
var G__11907 = (i__11894_11900 + (1));
seq__11891_11897 = G__11904;
chunk__11892_11898 = G__11905;
count__11893_11899 = G__11906;
i__11894_11900 = G__11907;
continue;
} else {
var temp__4425__auto___11908 = cljs.core.seq.call(null,seq__11891_11897);
if(temp__4425__auto___11908){
var seq__11891_11909__$1 = temp__4425__auto___11908;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11891_11909__$1)){
var c__6940__auto___11910 = cljs.core.chunk_first.call(null,seq__11891_11909__$1);
var G__11911 = cljs.core.chunk_rest.call(null,seq__11891_11909__$1);
var G__11912 = c__6940__auto___11910;
var G__11913 = cljs.core.count.call(null,c__6940__auto___11910);
var G__11914 = (0);
seq__11891_11897 = G__11911;
chunk__11892_11898 = G__11912;
count__11893_11899 = G__11913;
i__11894_11900 = G__11914;
continue;
} else {
var vec__11896_11915 = cljs.core.first.call(null,seq__11891_11909__$1);
var store_11916 = cljs.core.nth.call(null,vec__11896_11915,(0),null);
var query_deps_11917 = cljs.core.nth.call(null,vec__11896_11915,(1),null);
derive.core.unsubscribe_BANG_.call(null,store_11916,listener,query_deps_11917);

var G__11918 = cljs.core.next.call(null,seq__11891_11909__$1);
var G__11919 = null;
var G__11920 = (0);
var G__11921 = (0);
seq__11891_11897 = G__11918;
chunk__11892_11898 = G__11919;
count__11893_11899 = G__11920;
i__11894_11900 = G__11921;
continue;
}
} else {
}
}
break;
}

(owner["__derive_listener"] = null);

(owner["__derive_dmap"] = null);

return owner;
});
derive.core.save_listener_BANG_ = (function derive$core$save_listener_BANG_(owner,listener,dmap){
(owner["__derive_listener"] = listener);

(owner["__derive_dmap"] = dmap);

return owner;
});
/**
 * Call in on-changes
 */
derive.core.om_subscribe_handler = (function derive$core$om_subscribe_handler(owner){
return (function (listener,dmap){
return derive.core.save_listener_BANG_.call(null,derive.core.clear_listener_BANG_.call(null,owner),listener,dmap);
});
});
