// Compiled by ClojureScript 1.7.228 {}
goog.provide('nativestore.core');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('purnam.native$.functions');
goog.require('derive.core');

/**
 * @interface
 */
nativestore.core.IStore = function(){};

nativestore.core.insert_BANG_ = (function nativestore$core$insert_BANG_(store,obj){
if((!((store == null))) && (!((store.nativestore$core$IStore$insert_BANG_$arity$2 == null)))){
return store.nativestore$core$IStore$insert_BANG_$arity$2(store,obj);
} else {
var x__6792__auto__ = (((store == null))?null:store);
var m__6793__auto__ = (nativestore.core.insert_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,store,obj);
} else {
var m__6793__auto____$1 = (nativestore.core.insert_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,store,obj);
} else {
throw cljs.core.missing_protocol.call(null,"IStore.insert!",store);
}
}
}
});

nativestore.core.delete_BANG_ = (function nativestore$core$delete_BANG_(store,id){
if((!((store == null))) && (!((store.nativestore$core$IStore$delete_BANG_$arity$2 == null)))){
return store.nativestore$core$IStore$delete_BANG_$arity$2(store,id);
} else {
var x__6792__auto__ = (((store == null))?null:store);
var m__6793__auto__ = (nativestore.core.delete_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,store,id);
} else {
var m__6793__auto____$1 = (nativestore.core.delete_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,store,id);
} else {
throw cljs.core.missing_protocol.call(null,"IStore.delete!",store);
}
}
}
});


/**
 * @interface
 */
nativestore.core.IIndex = function(){};

nativestore.core.key_fn = (function nativestore$core$key_fn(idx){
if((!((idx == null))) && (!((idx.nativestore$core$IIndex$key_fn$arity$1 == null)))){
return idx.nativestore$core$IIndex$key_fn$arity$1(idx);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core.key_fn[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx);
} else {
var m__6793__auto____$1 = (nativestore.core.key_fn["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"IIndex.key-fn",idx);
}
}
}
});

nativestore.core.index_BANG_ = (function nativestore$core$index_BANG_(idx,obj){
if((!((idx == null))) && (!((idx.nativestore$core$IIndex$index_BANG_$arity$2 == null)))){
return idx.nativestore$core$IIndex$index_BANG_$arity$2(idx,obj);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core.index_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx,obj);
} else {
var m__6793__auto____$1 = (nativestore.core.index_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx,obj);
} else {
throw cljs.core.missing_protocol.call(null,"IIndex.index!",idx);
}
}
}
});

nativestore.core.unindex_BANG_ = (function nativestore$core$unindex_BANG_(idx,obj){
if((!((idx == null))) && (!((idx.nativestore$core$IIndex$unindex_BANG_$arity$2 == null)))){
return idx.nativestore$core$IIndex$unindex_BANG_$arity$2(idx,obj);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core.unindex_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx,obj);
} else {
var m__6793__auto____$1 = (nativestore.core.unindex_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx,obj);
} else {
throw cljs.core.missing_protocol.call(null,"IIndex.unindex!",idx);
}
}
}
});


/**
 * @interface
 */
nativestore.core.IClearable = function(){};

nativestore.core.clear_BANG_ = (function nativestore$core$clear_BANG_(idx){
if((!((idx == null))) && (!((idx.nativestore$core$IClearable$clear_BANG_$arity$1 == null)))){
return idx.nativestore$core$IClearable$clear_BANG_$arity$1(idx);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core.clear_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx);
} else {
var m__6793__auto____$1 = (nativestore.core.clear_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"IClearable.clear!",idx);
}
}
}
});


/**
 * @interface
 */
nativestore.core.ISortedIndex = function(){};

nativestore.core.comparator_fn = (function nativestore$core$comparator_fn(idx){
if((!((idx == null))) && (!((idx.nativestore$core$ISortedIndex$comparator_fn$arity$1 == null)))){
return idx.nativestore$core$ISortedIndex$comparator_fn$arity$1(idx);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core.comparator_fn[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx);
} else {
var m__6793__auto____$1 = (nativestore.core.comparator_fn["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"ISortedIndex.comparator-fn",idx);
}
}
}
});


/**
 * @interface
 */
nativestore.core.IScannable = function(){};

nativestore.core._get_cursor = (function nativestore$core$_get_cursor(var_args){
var args11973 = [];
var len__7195__auto___11976 = arguments.length;
var i__7196__auto___11977 = (0);
while(true){
if((i__7196__auto___11977 < len__7195__auto___11976)){
args11973.push((arguments[i__7196__auto___11977]));

var G__11978 = (i__7196__auto___11977 + (1));
i__7196__auto___11977 = G__11978;
continue;
} else {
}
break;
}

var G__11975 = args11973.length;
switch (G__11975) {
case 1:
return nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11973.length)].join('')));

}
});

nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$1 = (function (idx){
if((!((idx == null))) && (!((idx.nativestore$core$IScannable$_get_cursor$arity$1 == null)))){
return idx.nativestore$core$IScannable$_get_cursor$arity$1(idx);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core._get_cursor[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx);
} else {
var m__6793__auto____$1 = (nativestore.core._get_cursor["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx);
} else {
throw cljs.core.missing_protocol.call(null,"IScannable.-get-cursor",idx);
}
}
}
});

nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$2 = (function (idx,start){
if((!((idx == null))) && (!((idx.nativestore$core$IScannable$_get_cursor$arity$2 == null)))){
return idx.nativestore$core$IScannable$_get_cursor$arity$2(idx,start);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core._get_cursor[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx,start);
} else {
var m__6793__auto____$1 = (nativestore.core._get_cursor["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx,start);
} else {
throw cljs.core.missing_protocol.call(null,"IScannable.-get-cursor",idx);
}
}
}
});

nativestore.core._get_cursor.cljs$core$IFn$_invoke$arity$3 = (function (idx,start,end){
if((!((idx == null))) && (!((idx.nativestore$core$IScannable$_get_cursor$arity$3 == null)))){
return idx.nativestore$core$IScannable$_get_cursor$arity$3(idx,start,end);
} else {
var x__6792__auto__ = (((idx == null))?null:idx);
var m__6793__auto__ = (nativestore.core._get_cursor[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,idx,start,end);
} else {
var m__6793__auto____$1 = (nativestore.core._get_cursor["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,idx,start,end);
} else {
throw cljs.core.missing_protocol.call(null,"IScannable.-get-cursor",idx);
}
}
}
});

nativestore.core._get_cursor.cljs$lang$maxFixedArity = 3;


/**
 * @interface
 */
nativestore.core.IIndexedStore = function(){};

nativestore.core.add_index_BANG_ = (function nativestore$core$add_index_BANG_(store,name,index){
if((!((store == null))) && (!((store.nativestore$core$IIndexedStore$add_index_BANG_$arity$3 == null)))){
return store.nativestore$core$IIndexedStore$add_index_BANG_$arity$3(store,name,index);
} else {
var x__6792__auto__ = (((store == null))?null:store);
var m__6793__auto__ = (nativestore.core.add_index_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,store,name,index);
} else {
var m__6793__auto____$1 = (nativestore.core.add_index_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,store,name,index);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexedStore.add-index!",store);
}
}
}
});

nativestore.core.rem_index_BANG_ = (function nativestore$core$rem_index_BANG_(store,name){
if((!((store == null))) && (!((store.nativestore$core$IIndexedStore$rem_index_BANG_$arity$2 == null)))){
return store.nativestore$core$IIndexedStore$rem_index_BANG_$arity$2(store,name);
} else {
var x__6792__auto__ = (((store == null))?null:store);
var m__6793__auto__ = (nativestore.core.rem_index_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,store,name);
} else {
var m__6793__auto____$1 = (nativestore.core.rem_index_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,store,name);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexedStore.rem-index!",store);
}
}
}
});

nativestore.core.get_index = (function nativestore$core$get_index(store,name){
if((!((store == null))) && (!((store.nativestore$core$IIndexedStore$get_index$arity$2 == null)))){
return store.nativestore$core$IIndexedStore$get_index$arity$2(store,name);
} else {
var x__6792__auto__ = (((store == null))?null:store);
var m__6793__auto__ = (nativestore.core.get_index[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,store,name);
} else {
var m__6793__auto____$1 = (nativestore.core.get_index["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,store,name);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexedStore.get-index",store);
}
}
}
});


/**
 * @interface
 */
nativestore.core.ITransactionalStore = function(){};

nativestore.core._transact_BANG_ = (function nativestore$core$_transact_BANG_(store,f,args){
if((!((store == null))) && (!((store.nativestore$core$ITransactionalStore$_transact_BANG_$arity$3 == null)))){
return store.nativestore$core$ITransactionalStore$_transact_BANG_$arity$3(store,f,args);
} else {
var x__6792__auto__ = (((store == null))?null:store);
var m__6793__auto__ = (nativestore.core._transact_BANG_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,store,f,args);
} else {
var m__6793__auto____$1 = (nativestore.core._transact_BANG_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,store,f,args);
} else {
throw cljs.core.missing_protocol.call(null,"ITransactionalStore.-transact!",store);
}
}
}
});

/**
 * Mutates r1.  Keep list of merged IDs in sorted order
 */
nativestore.core.sorted_insert_BANG_ = (function nativestore$core$sorted_insert_BANG_(r1,r2){
return goog.array.forEach(r2,(function (v,i,a){
return goog.array.binaryInsert(r1,v);
}));
});
/**
 * Mutates r1. The updated range becomes the union of the two ranges
 */
nativestore.core.merge_range_BANG_ = (function nativestore$core$merge_range_BANG_(compfn,range1,range2){
var r1s = (range1[(0)]);
var r1e = (range1[(1)]);
var r2s = (range2[(0)]);
var r2e = (range2[(1)]);
if((compfn.call(null,r2s,r1s) < (0))){
(range1[(0)] = r2s);
} else {
}

if((compfn.call(null,r2e,r1e) > (0))){
return (range1[(1)] = r2e);
} else {
return null;
}
});
/**
 * Merge the index range or root set
 */
nativestore.core.merge_index_BANG_ = (function nativestore$core$merge_index_BANG_(nset,idx,range1,range2){
if((idx == null)){
return nativestore.core.sorted_insert_BANG_.call(null,range1,range2);
} else {
return nativestore.core.merge_range_BANG_.call(null,nativestore.core.comparator_fn.call(null,idx),range1,range2);
}
});
/**
 * Do two sorted sets of integers intersect?
 */
nativestore.core.intersect_QMARK_ = (function nativestore$core$intersect_QMARK_(set1,set2){
var len1 = (((set1 == null))?(0):set1.length);
var len2 = (((set2 == null))?(0):set2.length);
var i = (0);
var j = (0);
while(true){
if(((i === len1)) || ((j === len2))){
return false;
} else {
var v1 = (set1[i]);
var v2 = (set2[j]);
if(cljs.core._EQ_.call(null,v1,v2)){
return true;
} else {
if((cljs.core.compare.call(null,v1,v2) > (0))){
var G__11980 = i;
var G__11981 = (j + (1));
i = G__11980;
j = G__11981;
continue;
} else {
var G__11982 = (i + (1));
var G__11983 = j;
i = G__11982;
j = G__11983;
continue;

}
}
}
break;
}
});
/**
 * Does the interval of other overlap this?
 */
nativestore.core.overlap_QMARK_ = (function nativestore$core$overlap_QMARK_(compfn,range1,range2){
var r1s = (range1[(0)]);
var r1e = (range1[(1)]);
var r2s = (range2[(0)]);
var r2e = (range2[(1)]);
var res = !((function (){var or__6137__auto__ = (((r1e == null))?(compfn.call(null,r2e,r1s) < (0)):(compfn.call(null,r2s,r1e) > (0)));
if(or__6137__auto__){
return or__6137__auto__;
} else {
if((r2e == null)){
return (compfn.call(null,r1e,r2s) < (0));
} else {
return (compfn.call(null,r2e,r1s) < (0));
}
}
})());
return res;
});
nativestore.core.match_index_QMARK_ = (function nativestore$core$match_index_QMARK_(nset,idx,this_range,other_range){
if((idx == null)){
return nativestore.core.intersect_QMARK_.call(null,this_range,other_range);
} else {
return nativestore.core.overlap_QMARK_.call(null,nativestore.core.comparator_fn.call(null,idx),this_range,other_range);
}
});

/**
* @constructor
 * @implements {derive.core.IDependencySet}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IPrintWithWriter}
*/
nativestore.core.NativeDependencySet = (function (store,deps){
this.store = store;
this.deps = deps;
this.cljs$lang$protocol_mask$partition0$ = 2153775104;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.NativeDependencySet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#ndep ["),cljs.core.str(cljs.core.pr_str.call(null,self__.deps)),cljs.core.str("]")].join(''));
});

nativestore.core.NativeDependencySet.prototype.cljs$core$IHash$_hash$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return goog.getUid(o__$1);
});

nativestore.core.NativeDependencySet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
if((other instanceof nativestore.core.NativeDependencySet)){
return (cljs.core._hash.call(null,o__$1) === cljs.core._hash.call(null,other));
} else {
return false;
}
});

nativestore.core.NativeDependencySet.prototype.derive$core$IDependencySet$ = true;

nativestore.core.NativeDependencySet.prototype.derive$core$IDependencySet$merge_deps$arity$2 = (function (nset,other){
var self__ = this;
var nset__$1 = this;
var fdeps = (((other.deps == null))?other:other.deps);
goog.object.forEach(fdeps,((function (fdeps,nset__$1){
return (function (v,k){
var temp__4423__auto__ = (self__.deps[k]);
if(cljs.core.truth_(temp__4423__auto__)){
var mine = temp__4423__auto__;
return nativestore.core.merge_index_BANG_.call(null,nset__$1,nativestore.core.get_index.call(null,self__.store,k),mine,v);
} else {
return (self__.deps[k] = purnam.native$.functions.js_copy.call(null,v));
}
});})(fdeps,nset__$1))
);

return nset__$1;
});

nativestore.core.NativeDependencySet.prototype.derive$core$IDependencySet$match_deps$arity$2 = (function (nset,other){
var self__ = this;
var nset__$1 = this;
var fdeps = (((other.deps == null))?other:other.deps);
return goog.object.some(fdeps,((function (fdeps,nset__$1){
return (function (v,k,o){
var temp__4425__auto__ = (self__.deps[k]);
if(cljs.core.truth_(temp__4425__auto__)){
var local = temp__4425__auto__;
return nativestore.core.match_index_QMARK_.call(null,nset__$1,nativestore.core.get_index.call(null,self__.store,k),local,v);
} else {
return null;
}
});})(fdeps,nset__$1))
);
});

nativestore.core.NativeDependencySet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"deps","deps",-771075450,null)], null);
});

nativestore.core.NativeDependencySet.cljs$lang$type = true;

nativestore.core.NativeDependencySet.cljs$lang$ctorStr = "nativestore.core/NativeDependencySet";

nativestore.core.NativeDependencySet.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/NativeDependencySet");
});

nativestore.core.__GT_NativeDependencySet = (function nativestore$core$__GT_NativeDependencySet(store,deps){
return (new nativestore.core.NativeDependencySet(store,deps));
});

nativestore.core.make_dependencies = (function nativestore$core$make_dependencies(var_args){
var args11984 = [];
var len__7195__auto___11987 = arguments.length;
var i__7196__auto___11988 = (0);
while(true){
if((i__7196__auto___11988 < len__7195__auto___11987)){
args11984.push((arguments[i__7196__auto___11988]));

var G__11989 = (i__7196__auto___11988 + (1));
i__7196__auto___11988 = G__11989;
continue;
} else {
}
break;
}

var G__11986 = args11984.length;
switch (G__11986) {
case 1:
return nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11984.length)].join('')));

}
});

nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$1 = (function (store){
return (new nativestore.core.NativeDependencySet(store,{}));
});

nativestore.core.make_dependencies.cljs$core$IFn$_invoke$arity$2 = (function (store,init){
return (new nativestore.core.NativeDependencySet(store,init));
});

nativestore.core.make_dependencies.cljs$lang$maxFixedArity = 2;
nativestore.core.inform_tracker = (function nativestore$core$inform_tracker(var_args){
var args11991 = [];
var len__7195__auto___11994 = arguments.length;
var i__7196__auto___11995 = (0);
while(true){
if((i__7196__auto___11995 < len__7195__auto___11994)){
args11991.push((arguments[i__7196__auto___11995]));

var G__11996 = (i__7196__auto___11995 + (1));
i__7196__auto___11995 = G__11996;
continue;
} else {
}
break;
}

var G__11993 = args11991.length;
switch (G__11993) {
case 2:
return nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11991.length)].join('')));

}
});

nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$2 = (function (store,deps){
if(cljs.core.truth_(derive.core.tracking_QMARK_.call(null))){
return nativestore.core.inform_tracker.call(null,derive.core._STAR_tracker_STAR_,store,deps);
} else {
return null;
}
});

nativestore.core.inform_tracker.cljs$core$IFn$_invoke$arity$3 = (function (tracker,store,deps){
var dset = nativestore.core.make_dependencies.call(null,store,deps);
return derive.core.depends_BANG_.call(null,tracker,store,dset);
});

nativestore.core.inform_tracker.cljs$lang$maxFixedArity = 3;
/**
 * Inside a transaction?
 */
nativestore.core._STAR_transaction_STAR_ = null;

/**
 * @interface
 */
nativestore.core.IReference = function(){};

nativestore.core.resolve_ref = (function nativestore$core$resolve_ref(ref){
if((!((ref == null))) && (!((ref.nativestore$core$IReference$resolve_ref$arity$1 == null)))){
return ref.nativestore$core$IReference$resolve_ref$arity$1(ref);
} else {
var x__6792__auto__ = (((ref == null))?null:ref);
var m__6793__auto__ = (nativestore.core.resolve_ref[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,ref);
} else {
var m__6793__auto____$1 = (nativestore.core.resolve_ref["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,ref);
} else {
throw cljs.core.missing_protocol.call(null,"IReference.resolve-ref",ref);
}
}
}
});

nativestore.core.reference_id = (function nativestore$core$reference_id(ref){
if((!((ref == null))) && (!((ref.nativestore$core$IReference$reference_id$arity$1 == null)))){
return ref.nativestore$core$IReference$reference_id$arity$1(ref);
} else {
var x__6792__auto__ = (((ref == null))?null:ref);
var m__6793__auto__ = (nativestore.core.reference_id[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,ref);
} else {
var m__6793__auto____$1 = (nativestore.core.reference_id["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,ref);
} else {
throw cljs.core.missing_protocol.call(null,"IReference.reference-id",ref);
}
}
}
});

nativestore.core.reference_db = (function nativestore$core$reference_db(ref){
if((!((ref == null))) && (!((ref.nativestore$core$IReference$reference_db$arity$1 == null)))){
return ref.nativestore$core$IReference$reference_db$arity$1(ref);
} else {
var x__6792__auto__ = (((ref == null))?null:ref);
var m__6793__auto__ = (nativestore.core.reference_db[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,ref);
} else {
var m__6793__auto____$1 = (nativestore.core.reference_db["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,ref);
} else {
throw cljs.core.missing_protocol.call(null,"IReference.reference-db",ref);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {nativestore.core.IReference}
 * @implements {cljs.core.IPrintWithWriter}
*/
nativestore.core.NativeReference = (function (store,id){
this.store = store;
this.id = id;
this.cljs$lang$protocol_mask$partition0$ = 2149580800;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.NativeReference.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#ref ["),cljs.core.str(self__.id),cljs.core.str("]")].join(''));
});

nativestore.core.NativeReference.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (ref,other){
var self__ = this;
var ref__$1 = this;
return (cljs.core._EQ_.call(null,self__.store,other.store)) && (cljs.core._EQ_.call(null,self__.id,other.id));
});

nativestore.core.NativeReference.prototype.nativestore$core$IReference$ = true;

nativestore.core.NativeReference.prototype.nativestore$core$IReference$resolve_ref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.get.call(null,self__.store,self__.id);
});

nativestore.core.NativeReference.prototype.nativestore$core$IReference$reference_id$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.id;
});

nativestore.core.NativeReference.prototype.nativestore$core$IReference$reference_db$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.store;
});

nativestore.core.NativeReference.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
});

nativestore.core.NativeReference.cljs$lang$type = true;

nativestore.core.NativeReference.cljs$lang$ctorStr = "nativestore.core/NativeReference";

nativestore.core.NativeReference.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/NativeReference");
});

nativestore.core.__GT_NativeReference = (function nativestore$core$__GT_NativeReference(store,id){
return (new nativestore.core.NativeReference(store,id));
});

nativestore.core.reference = (function nativestore$core$reference(db,obj){
return (new nativestore.core.NativeReference(db,(((typeof obj === 'string') || (typeof obj === 'number') || (cljs.core.not.call(null,nativestore.core.native_QMARK_.call(null,obj))))?obj:nativestore.core.key_fn.call(null,db.root).call(null,obj))));
});
nativestore.core.identity_QMARK_ = (function nativestore$core$identity_QMARK_(n1,n2){
return cljs.core._EQ_.call(null,(n1["id"]),(n2["id"]));
});

/**
 * @interface
 */
nativestore.core.IReadOnly = function(){};

nativestore.core._read_only_QMARK_ = (function nativestore$core$_read_only_QMARK_(_){
if((!((_ == null))) && (!((_.nativestore$core$IReadOnly$_read_only_QMARK_$arity$1 == null)))){
return _.nativestore$core$IReadOnly$_read_only_QMARK_$arity$1(_);
} else {
var x__6792__auto__ = (((_ == null))?null:_);
var m__6793__auto__ = (nativestore.core._read_only_QMARK_[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,_);
} else {
var m__6793__auto____$1 = (nativestore.core._read_only_QMARK_["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"IReadOnly.-read-only?",_);
}
}
}
});


/**
 * @interface
 */
nativestore.core.INative = function(){};


/**
* @constructor
 * @implements {nativestore.core.IReadOnly}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IEncodeClojure}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {nativestore.core.INative}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.Native = (function (__keyset,__ro){
this.__keyset = __keyset;
this.__ro = __ro;
this.cljs$lang$protocol_mask$partition1$ = 8248;
this.cljs$lang$protocol_mask$partition0$ = 2155874062;
})
nativestore.core.Native.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (native$,k,v){
var self__ = this;
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

if(cljs.core.truth_((function (){var and__6125__auto__ = nativestore.core._read_only_QMARK_.call(null,native$__$1);
if(cljs.core.truth_(and__6125__auto__)){
return cljs.core.not.call(null,nativestore.core._STAR_transaction_STAR_);
} else {
return and__6125__auto__;
}
})())){
throw (new Error("Cannot mutate store values outside transact!: "));
} else {
}

cljs.core._vreset_BANG_.call(null,self__.__keyset,cljs.core.conj.call(null,cljs.core._deref.call(null,self__.__keyset),k));

(native$__$1[cljs.core.name.call(null,k)] = v);

return native$__$1;
});

nativestore.core.Native.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (native$,k){
var self__ = this;
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

return cljs.core._lookup.call(null,native$__$1,k,null);
});

nativestore.core.Native.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (native$,k,not_found){
var self__ = this;
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

var v = (native$__$1[cljs.core.name.call(null,k)]);
if((v == null)){
return not_found;
} else {
if(cljs.core.array_QMARK_.call(null,v)){
if((function (){var G__11998 = (v[(0)]);
if(!((G__11998 == null))){
if((false) || (G__11998.nativestore$core$IReference$)){
return true;
} else {
if((!G__11998.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,G__11998);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,G__11998);
}
})()){
var a__7028__auto__ = v;
var ret = cljs.core.aclone.call(null,a__7028__auto__);
var i = (0);
while(true){
if((i < a__7028__auto__.length)){
(ret[i] = nativestore.core.resolve_ref.call(null,(v[i])));

var G__12008 = (i + (1));
i = G__12008;
continue;
} else {
return ret;
}
break;
}
} else {
return v;
}
} else {
if(((!((v == null)))?(((false) || (v.nativestore$core$IReference$))?true:(((!v.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,v):false)):cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.IReference,v))){
return nativestore.core.resolve_ref.call(null,v);
} else {
return v;

}
}
}
});

nativestore.core.Native.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (native$,k){
var self__ = this;
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

if(cljs.core.truth_((function (){var and__6125__auto__ = nativestore.core._read_only_QMARK_.call(null,native$__$1);
if(cljs.core.truth_(and__6125__auto__)){
return cljs.core.not.call(null,nativestore.core._STAR_transaction_STAR_);
} else {
return and__6125__auto__;
}
})())){
throw (new Error("Cannot mutate store values outside transact!: "));
} else {
}

cljs.core._vreset_BANG_.call(null,self__.__keyset,cljs.core.disj.call(null,cljs.core._deref.call(null,self__.__keyset),k));

delete native$__$1[cljs.core.name.call(null,k)];

return native$__$1;
});

nativestore.core.Native.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
cljs.core._write.call(null,writer,"#native ");

return cljs.core.print_map.call(null,cljs.core._seq.call(null,native$__$1),cljs.core.pr_writer,writer,opts);
});

nativestore.core.Native.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var clone = (new nativestore.core.Native(cljs.core.volatile_BANG_.call(null,cljs.core.deref.call(null,self__.__keyset)),false));
var seq__12000_12009 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.__keyset));
var chunk__12001_12010 = null;
var count__12002_12011 = (0);
var i__12003_12012 = (0);
while(true){
if((i__12003_12012 < count__12002_12011)){
var key_12013 = cljs.core._nth.call(null,chunk__12001_12010,i__12003_12012);
(clone[cljs.core.name.call(null,key_12013)] = (this$__$1[cljs.core.name.call(null,key_12013)]));

var G__12014 = seq__12000_12009;
var G__12015 = chunk__12001_12010;
var G__12016 = count__12002_12011;
var G__12017 = (i__12003_12012 + (1));
seq__12000_12009 = G__12014;
chunk__12001_12010 = G__12015;
count__12002_12011 = G__12016;
i__12003_12012 = G__12017;
continue;
} else {
var temp__4425__auto___12018 = cljs.core.seq.call(null,seq__12000_12009);
if(temp__4425__auto___12018){
var seq__12000_12019__$1 = temp__4425__auto___12018;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12000_12019__$1)){
var c__6940__auto___12020 = cljs.core.chunk_first.call(null,seq__12000_12019__$1);
var G__12021 = cljs.core.chunk_rest.call(null,seq__12000_12019__$1);
var G__12022 = c__6940__auto___12020;
var G__12023 = cljs.core.count.call(null,c__6940__auto___12020);
var G__12024 = (0);
seq__12000_12009 = G__12021;
chunk__12001_12010 = G__12022;
count__12002_12011 = G__12023;
i__12003_12012 = G__12024;
continue;
} else {
var key_12025 = cljs.core.first.call(null,seq__12000_12019__$1);
(clone[cljs.core.name.call(null,key_12025)] = (this$__$1[cljs.core.name.call(null,key_12025)]));

var G__12026 = cljs.core.next.call(null,seq__12000_12019__$1);
var G__12027 = null;
var G__12028 = (0);
var G__12029 = (0);
seq__12000_12009 = G__12026;
chunk__12001_12010 = G__12027;
count__12002_12011 = G__12028;
i__12003_12012 = G__12029;
continue;
}
} else {
}
}
break;
}

return clone;
});

nativestore.core.Native.prototype.cljs$core$IEncodeClojure$ = true;

nativestore.core.Native.prototype.cljs$core$IEncodeClojure$_js__GT_clj$arity$2 = (function (native$,opts){
var self__ = this;
var native$__$1 = this;
return native$__$1;
});

nativestore.core.Native.prototype.cljs$core$ICounted$_count$arity$1 = (function (native$){
var self__ = this;
var native$__$1 = this;
return cljs.core.count.call(null,cljs.core.deref.call(null,self__.__keyset));
});

nativestore.core.Native.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new nativestore.core.Native(cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY),false));
});

nativestore.core.Native.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (native$,p__12004){
var self__ = this;
var vec__12005 = p__12004;
var k = cljs.core.nth.call(null,vec__12005,(0),null);
var v = cljs.core.nth.call(null,vec__12005,(1),null);
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

return cljs.core._assoc_BANG_.call(null,native$__$1,k,v);
});

nativestore.core.Native.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (native$,k){
var self__ = this;
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

var new$ = cljs.core.clone.call(null,native$__$1);
return cljs.core._dissoc_BANG_.call(null,new$,k);
});

nativestore.core.Native.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (native$,k,v){
var self__ = this;
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

var new$ = cljs.core.clone.call(null,native$__$1);
return cljs.core._assoc_BANG_.call(null,new$,k,v);
});

nativestore.core.Native.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (native$){
var self__ = this;
var native$__$1 = this;
return cljs.core.map.call(null,((function (native$__$1){
return (function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,k),(native$__$1[cljs.core.name.call(null,k)])], null);
});})(native$__$1))
,cljs.core.deref.call(null,self__.__keyset));
});

nativestore.core.Native.prototype.cljs$core$ICollection$_conj$arity$2 = (function (native$,p__12006){
var self__ = this;
var vec__12007 = p__12006;
var k = cljs.core.nth.call(null,vec__12007,(0),null);
var v = cljs.core.nth.call(null,vec__12007,(1),null);
var native$__$1 = this;
new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre","pre",2118456869),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(k instanceof cljs.core.Keyword)], null)], null);

return cljs.core._assoc.call(null,native$__$1,k,v);
});

nativestore.core.Native.prototype.nativestore$core$IReadOnly$ = true;

nativestore.core.Native.prototype.nativestore$core$IReadOnly$_read_only_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.__ro;
});

nativestore.core.Native.prototype.nativestore$core$INative$ = true;

nativestore.core.Native.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__keyset","__keyset",1751286013,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__ro","__ro",-1834159981,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

nativestore.core.Native.cljs$lang$type = true;

nativestore.core.Native.cljs$lang$ctorStr = "nativestore.core/Native";

nativestore.core.Native.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/Native");
});

nativestore.core.__GT_Native = (function nativestore$core$__GT_Native(__keyset,__ro){
return (new nativestore.core.Native(__keyset,__ro));
});

/**
 * Return a fresh native, optionally with the read-only set
 */
nativestore.core.native$ = (function nativestore$core$native(var_args){
var args12030 = [];
var len__7195__auto___12033 = arguments.length;
var i__7196__auto___12034 = (0);
while(true){
if((i__7196__auto___12034 < len__7195__auto___12033)){
args12030.push((arguments[i__7196__auto___12034]));

var G__12035 = (i__7196__auto___12034 + (1));
i__7196__auto___12034 = G__12035;
continue;
} else {
}
break;
}

var G__12032 = args12030.length;
switch (G__12032) {
case 0:
return nativestore.core.native$.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return nativestore.core.native$.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12030.length)].join('')));

}
});

nativestore.core.native$.cljs$core$IFn$_invoke$arity$0 = (function (){
return nativestore.core.native$.call(null,false);
});

nativestore.core.native$.cljs$core$IFn$_invoke$arity$1 = (function (ro_QMARK_){
return (new nativestore.core.Native(cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY),ro_QMARK_));
});

nativestore.core.native$.cljs$lang$maxFixedArity = 1;
/**
 * Is this object a #native?
 */
nativestore.core.native_QMARK_ = (function nativestore$core$native_QMARK_(native$){
if(!((native$ == null))){
if((false) || (native$.nativestore$core$INative$)){
return true;
} else {
if((!native$.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.INative,native$);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,nativestore.core.INative,native$);
}
});
/**
 * Copying conversion function, will return
 * a fresh, writable, #native
 */
nativestore.core.to_native = (function nativestore$core$to_native(obj){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,obj))){
return cljs.core.clone.call(null,obj);
} else {
if(cljs.core.object_QMARK_.call(null,obj)){
var native$ = nativestore.core.native$.call(null,false);
goog.object.forEach(obj,((function (native$){
return (function (v,k){
return cljs.core._assoc_BANG_.call(null,native$,k,v);
});})(native$))
);

return native$;
} else {
if(cljs.core.seqable_QMARK_.call(null,obj)){
var native$ = nativestore.core.native$.call(null,false);
var seq__12043 = cljs.core.seq.call(null,cljs.core.keys.call(null,obj));
var chunk__12044 = null;
var count__12045 = (0);
var i__12046 = (0);
while(true){
if((i__12046 < count__12045)){
var key = cljs.core._nth.call(null,chunk__12044,i__12046);
cljs.core._assoc_BANG_.call(null,native$,key,cljs.core.get.call(null,obj,key));

var G__12047 = seq__12043;
var G__12048 = chunk__12044;
var G__12049 = count__12045;
var G__12050 = (i__12046 + (1));
seq__12043 = G__12047;
chunk__12044 = G__12048;
count__12045 = G__12049;
i__12046 = G__12050;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__12043);
if(temp__4425__auto__){
var seq__12043__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12043__$1)){
var c__6940__auto__ = cljs.core.chunk_first.call(null,seq__12043__$1);
var G__12051 = cljs.core.chunk_rest.call(null,seq__12043__$1);
var G__12052 = c__6940__auto__;
var G__12053 = cljs.core.count.call(null,c__6940__auto__);
var G__12054 = (0);
seq__12043 = G__12051;
chunk__12044 = G__12052;
count__12045 = G__12053;
i__12046 = G__12054;
continue;
} else {
var key = cljs.core.first.call(null,seq__12043__$1);
cljs.core._assoc_BANG_.call(null,native$,key,cljs.core.get.call(null,obj,key));

var G__12055 = cljs.core.next.call(null,seq__12043__$1);
var G__12056 = null;
var G__12057 = (0);
var G__12058 = (0);
seq__12043 = G__12055;
chunk__12044 = G__12056;
count__12045 = G__12057;
i__12046 = G__12058;
continue;
}
} else {
return null;
}
}
break;
}
} else {
throw Error;

}
}
}
});
nativestore.core.read_only_BANG_ = (function nativestore$core$read_only_BANG_(native$){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,native$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"native?","native?",-276459341,null),new cljs.core.Symbol(null,"native","native",1027470649,null))))].join('')));
}

native$.__ro = true;

return native$;
});
nativestore.core.read_only_QMARK_ = (function nativestore$core$read_only_QMARK_(native$){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,native$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"native?","native?",-276459341,null),new cljs.core.Symbol(null,"native","native",1027470649,null))))].join('')));
}

return nativestore.core._read_only_QMARK_.call(null,native$);
});
nativestore.core.writeable_BANG_ = (function nativestore$core$writeable_BANG_(native$){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,native$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"native?","native?",-276459341,null),new cljs.core.Symbol(null,"native","native",1027470649,null))))].join('')));
}

native$.__ro = false;

return native$;
});
/**
 * Only called from internal methods
 */
nativestore.core.upsert_merge = (function nativestore$core$upsert_merge(var_args){
var args12059 = [];
var len__7195__auto___12070 = arguments.length;
var i__7196__auto___12071 = (0);
while(true){
if((i__7196__auto___12071 < len__7195__auto___12070)){
args12059.push((arguments[i__7196__auto___12071]));

var G__12072 = (i__7196__auto___12071 + (1));
i__7196__auto___12071 = G__12072;
continue;
} else {
}
break;
}

var G__12064 = args12059.length;
switch (G__12064) {
case 2:
return nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7214__auto__ = (new cljs.core.IndexedSeq(args12059.slice((2)),(0)));
return nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7214__auto__);

}
});

nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$2 = (function (o1,o2){
var _STAR_transaction_STAR_12065_12074 = nativestore.core._STAR_transaction_STAR_;
nativestore.core._STAR_transaction_STAR_ = (cljs.core.truth_(nativestore.core._STAR_transaction_STAR_)?nativestore.core._STAR_transaction_STAR_:true);

try{var seq__12066_12075 = cljs.core.seq.call(null,cljs.core.keys.call(null,o2));
var chunk__12067_12076 = null;
var count__12068_12077 = (0);
var i__12069_12078 = (0);
while(true){
if((i__12069_12078 < count__12068_12077)){
var k_12079 = cljs.core._nth.call(null,chunk__12067_12076,i__12069_12078);
var kstr_12080 = cljs.core.name.call(null,k_12079);
if(!(((o2[kstr_12080]) == null))){
cljs.core._assoc_BANG_.call(null,o1,kstr_12080,(o2[kstr_12080]));
} else {
cljs.core._dissoc_BANG_.call(null,o1,kstr_12080);
}

var G__12081 = seq__12066_12075;
var G__12082 = chunk__12067_12076;
var G__12083 = count__12068_12077;
var G__12084 = (i__12069_12078 + (1));
seq__12066_12075 = G__12081;
chunk__12067_12076 = G__12082;
count__12068_12077 = G__12083;
i__12069_12078 = G__12084;
continue;
} else {
var temp__4425__auto___12085 = cljs.core.seq.call(null,seq__12066_12075);
if(temp__4425__auto___12085){
var seq__12066_12086__$1 = temp__4425__auto___12085;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12066_12086__$1)){
var c__6940__auto___12087 = cljs.core.chunk_first.call(null,seq__12066_12086__$1);
var G__12088 = cljs.core.chunk_rest.call(null,seq__12066_12086__$1);
var G__12089 = c__6940__auto___12087;
var G__12090 = cljs.core.count.call(null,c__6940__auto___12087);
var G__12091 = (0);
seq__12066_12075 = G__12088;
chunk__12067_12076 = G__12089;
count__12068_12077 = G__12090;
i__12069_12078 = G__12091;
continue;
} else {
var k_12092 = cljs.core.first.call(null,seq__12066_12086__$1);
var kstr_12093 = cljs.core.name.call(null,k_12092);
if(!(((o2[kstr_12093]) == null))){
cljs.core._assoc_BANG_.call(null,o1,kstr_12093,(o2[kstr_12093]));
} else {
cljs.core._dissoc_BANG_.call(null,o1,kstr_12093);
}

var G__12094 = cljs.core.next.call(null,seq__12066_12086__$1);
var G__12095 = null;
var G__12096 = (0);
var G__12097 = (0);
seq__12066_12075 = G__12094;
chunk__12067_12076 = G__12095;
count__12068_12077 = G__12096;
i__12069_12078 = G__12097;
continue;
}
} else {
}
}
break;
}
}finally {nativestore.core._STAR_transaction_STAR_ = _STAR_transaction_STAR_12065_12074;
}
return o1;
});

nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$variadic = (function (o1,o2,more){
return cljs.core.apply.call(null,nativestore.core.upsert_merge,nativestore.core.upsert_merge.call(null,o1,o2),more);
});

nativestore.core.upsert_merge.cljs$lang$applyTo = (function (seq12060){
var G__12061 = cljs.core.first.call(null,seq12060);
var seq12060__$1 = cljs.core.next.call(null,seq12060);
var G__12062 = cljs.core.first.call(null,seq12060__$1);
var seq12060__$2 = cljs.core.next.call(null,seq12060__$1);
return nativestore.core.upsert_merge.cljs$core$IFn$_invoke$arity$variadic(G__12061,G__12062,seq12060__$2);
});

nativestore.core.upsert_merge.cljs$lang$maxFixedArity = (2);

/**
* @constructor
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IReduce}
*/
nativestore.core.Cursor = (function (idx,start,end,valid_QMARK_,empty_QMARK_){
this.idx = idx;
this.start = start;
this.end = end;
this.valid_QMARK_ = valid_QMARK_;
this.empty_QMARK_ = empty_QMARK_;
this.cljs$lang$protocol_mask$partition0$ = 8912896;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.Cursor.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,f,f.call(null));
});

nativestore.core.Cursor.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (this$,f,init){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.empty_QMARK_)){
return init;
} else {
var a = (function (){var or__6137__auto__ = self__.idx.arry;
if(cljs.core.truth_(or__6137__auto__)){
return or__6137__auto__;
} else {
return (self__.idx["arry"]);
}
})();
var i = self__.start;
var ret = init;
while(true){
if((i <= self__.end)){
var G__12098 = (i + (1));
var G__12099 = f.call(null,ret,(a[i]));
i = G__12098;
ret = G__12099;
continue;
} else {
return ret;
}
break;
}
}
});

nativestore.core.Cursor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.seq.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,this$__$1));
});

nativestore.core.Cursor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"valid?","valid?",1428119148,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"empty?","empty?",76408555,null)], null);
});

nativestore.core.Cursor.cljs$lang$type = true;

nativestore.core.Cursor.cljs$lang$ctorStr = "nativestore.core/Cursor";

nativestore.core.Cursor.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/Cursor");
});

nativestore.core.__GT_Cursor = (function nativestore$core$__GT_Cursor(idx,start,end,valid_QMARK_,empty_QMARK_){
return (new nativestore.core.Cursor(idx,start,end,valid_QMARK_,empty_QMARK_));
});


/**
* @constructor
 * @implements {nativestore.core.IScannable}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {nativestore.core.IClearable}
 * @implements {nativestore.core.IIndex}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.HashIndex = (function (keyfn,hashmap){
this.keyfn = keyfn;
this.hashmap = hashmap;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.HashIndex.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (idx,val){
var self__ = this;
var idx__$1 = this;
return cljs.core._lookup.call(null,idx__$1,val,null);
});

nativestore.core.HashIndex.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (idx,val,not_found){
var self__ = this;
var idx__$1 = this;
return purnam.native$.functions.js_lookup.call(null,self__.hashmap,val,not_found);
});

nativestore.core.HashIndex.prototype.call = (function() {
var G__12103 = null;
var G__12103__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k);
});
var G__12103__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k,not_found);
});
G__12103 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12103__2.call(this,self__,k);
case 3:
return G__12103__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12103.cljs$core$IFn$_invoke$arity$2 = G__12103__2;
G__12103.cljs$core$IFn$_invoke$arity$3 = G__12103__3;
return G__12103;
})()
;

nativestore.core.HashIndex.prototype.apply = (function (self__,args12100){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12100)));
});

nativestore.core.HashIndex.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k);
});

nativestore.core.HashIndex.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k,not_found);
});

nativestore.core.HashIndex.prototype.cljs$core$ICounted$_count$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return cljs.core.js_keys.call(null,self__.hashmap).length;
});

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$ = true;

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$key_fn$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return self__.keyfn;
});

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$index_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var key = self__.keyfn.call(null,obj);
var old = purnam.native$.functions.js_lookup.call(null,self__.hashmap,key);
return purnam.native$.functions.js_assoc.call(null,self__.hashmap,key,(cljs.core.truth_(old)?nativestore.core.upsert_merge.call(null,old,obj):obj));
});

nativestore.core.HashIndex.prototype.nativestore$core$IIndex$unindex_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var key = self__.keyfn.call(null,obj);
return purnam.native$.functions.js_dissoc.call(null,self__.hashmap,key,obj);
});

nativestore.core.HashIndex.prototype.nativestore$core$IClearable$ = true;

nativestore.core.HashIndex.prototype.nativestore$core$IClearable$clear_BANG_$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return goog.array.clear(self__.hashmap);
});

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$ = true;

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
var vals = (function (){var obj12102 = {"arry":goog.object.getValues(idx__$1.hashmap)};
return obj12102;
})();
return (new nativestore.core.Cursor(vals,(0),((vals["arry"]).length - (1)),true,false));
});

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$2 = (function (idx,start){
var self__ = this;
var idx__$1 = this;
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Hash index does not support range queries"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,false))].join('')));

});

nativestore.core.HashIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$3 = (function (idx,start,end){
var self__ = this;
var idx__$1 = this;
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Hash index does not support range queries"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,false))].join('')));

});

nativestore.core.HashIndex.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"hashmap","hashmap",1013955299,null)], null);
});

nativestore.core.HashIndex.cljs$lang$type = true;

nativestore.core.HashIndex.cljs$lang$ctorStr = "nativestore.core/HashIndex";

nativestore.core.HashIndex.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/HashIndex");
});

nativestore.core.__GT_HashIndex = (function nativestore$core$__GT_HashIndex(keyfn,hashmap){
return (new nativestore.core.HashIndex(keyfn,hashmap));
});

nativestore.core.root_index = (function nativestore$core$root_index(){
return (new nativestore.core.HashIndex((function (p1__12104_SHARP_){
return (p1__12104_SHARP_["id"]);
}),{}));
});

/**
* @constructor
 * @implements {nativestore.core.IScannable}
 * @implements {cljs.core.IFn}
 * @implements {nativestore.core.ISortedIndex}
 * @implements {nativestore.core.IClearable}
 * @implements {nativestore.core.IIndex}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.BinaryIndex = (function (keyfn,compfn,arry){
this.keyfn = keyfn;
this.compfn = compfn;
this.arry = arry;
this.cljs$lang$protocol_mask$partition0$ = 257;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
nativestore.core.BinaryIndex.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (idx,val){
var self__ = this;
var idx__$1 = this;
return cljs.core._lookup.call(null,idx__$1,val,null);
});

nativestore.core.BinaryIndex.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (idx,val,not_found){
var self__ = this;
var idx__$1 = this;
var index = goog.array.binarySearch(self__.arry,val,((function (idx__$1){
return (function (p1__12105_SHARP_,p2__12106_SHARP_){
return self__.compfn.call(null,p1__12105_SHARP_,self__.keyfn.call(null,p2__12106_SHARP_));
});})(idx__$1))
);
if((index >= (0))){
var end = index;
while(true){
if(cljs.core._EQ_.call(null,self__.compfn.call(null,val,self__.keyfn.call(null,(self__.arry[end]))),(0))){
var G__12116 = (end + (1));
end = G__12116;
continue;
} else {
return goog.array.slice(self__.arry,index,end);
}
break;
}
} else {
return not_found;
}
});

nativestore.core.BinaryIndex.prototype.call = (function() {
var G__12117 = null;
var G__12117__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k);
});
var G__12117__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var idx = self____$1;
return cljs.core._lookup.call(null,idx,k,not_found);
});
G__12117 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12117__2.call(this,self__,k);
case 3:
return G__12117__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12117.cljs$core$IFn$_invoke$arity$2 = G__12117__2;
G__12117.cljs$core$IFn$_invoke$arity$3 = G__12117__3;
return G__12117;
})()
;

nativestore.core.BinaryIndex.prototype.apply = (function (self__,args12115){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12115)));
});

nativestore.core.BinaryIndex.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k);
});

nativestore.core.BinaryIndex.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var idx = this;
return cljs.core._lookup.call(null,idx,k,not_found);
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$key_fn$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return self__.keyfn;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$index_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var loc_12118 = goog.array.binarySearch(self__.arry,obj,((function (idx__$1){
return (function (p1__12107_SHARP_,p2__12108_SHARP_){
return self__.compfn.call(null,self__.keyfn.call(null,p1__12107_SHARP_),self__.keyfn.call(null,p2__12108_SHARP_));
});})(idx__$1))
);
if((loc_12118 >= (0))){
goog.array.insertAt(self__.arry,obj,loc_12118);
} else {
goog.array.insertAt(self__.arry,obj,(- (loc_12118 + (1))));
}

return idx__$1;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IIndex$unindex_BANG_$arity$2 = (function (idx,obj){
var self__ = this;
var idx__$1 = this;
var loc_12119 = goog.array.indexOf(self__.arry,obj);
if((loc_12119 >= (0))){
goog.array.removeAt(self__.arry,loc_12119);
} else {
}

return idx__$1;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IClearable$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$IClearable$clear_BANG_$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return goog.array.clear(self__.arry);
});

nativestore.core.BinaryIndex.prototype.nativestore$core$ISortedIndex$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$ISortedIndex$comparator_fn$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return self__.compfn;
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$ = true;

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$1 = (function (idx){
var self__ = this;
var idx__$1 = this;
return (new nativestore.core.Cursor(idx__$1,(0),(idx__$1.arry.length - (1)),true,false));
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$2 = (function (idx,start){
var self__ = this;
var idx__$1 = this;
var head = goog.array.binarySearch(self__.arry,start,((function (idx__$1){
return (function (p1__12109_SHARP_,p2__12110_SHARP_){
return self__.compfn.call(null,p1__12109_SHARP_,self__.keyfn.call(null,p2__12110_SHARP_));
});})(idx__$1))
);
var head__$1 = (((head >= (0)))?head:(- (head + (1))));
return (new nativestore.core.Cursor(idx__$1,head__$1,(idx__$1.arry.length - (1)),true,false));
});

nativestore.core.BinaryIndex.prototype.nativestore$core$IScannable$_get_cursor$arity$3 = (function (idx,start,end){
var self__ = this;
var idx__$1 = this;
var headidx = goog.array.binarySearch(self__.arry,start,((function (idx__$1){
return (function (p1__12111_SHARP_,p2__12112_SHARP_){
return self__.compfn.call(null,p1__12111_SHARP_,self__.keyfn.call(null,p2__12112_SHARP_));
});})(idx__$1))
);
var head = (((headidx >= (0)))?headidx:(- (headidx + (1))));
var tailidx = goog.array.binarySearch(self__.arry,end,((function (headidx,head,idx__$1){
return (function (p1__12113_SHARP_,p2__12114_SHARP_){
return self__.compfn.call(null,p1__12113_SHARP_,self__.keyfn.call(null,p2__12114_SHARP_));
});})(headidx,head,idx__$1))
);
var tail = (((tailidx >= (0)))?tailidx:(- (tailidx + (1))));
var tail__$1 = ((!((tail >= idx__$1.arry.length)))?(function (){var tail__$1 = tail;
while(true){
var next = self__.keyfn.call(null,(self__.arry[tail__$1]));
var c = self__.compfn.call(null,end,next);
if(cljs.core._EQ_.call(null,c,(0))){
if(cljs.core.not_EQ_.call(null,(tail__$1 + (1)),idx__$1.arry.length)){
var G__12120 = (tail__$1 + (1));
tail__$1 = G__12120;
continue;
} else {
return tail__$1;
}
} else {
return (tail__$1 - (1));
}
break;
}
})():tail);
var empty_QMARK_ = (cljs.core._EQ_.call(null,head,tail__$1)) && (((tailidx < (0))) && ((headidx < (0))));
return (new nativestore.core.Cursor(idx__$1,head,tail__$1,true,empty_QMARK_));
});

nativestore.core.BinaryIndex.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),new cljs.core.Symbol(null,"compfn","compfn",-1175460791,null),new cljs.core.Symbol(null,"arry","arry",-2021358270,null)], null);
});

nativestore.core.BinaryIndex.cljs$lang$type = true;

nativestore.core.BinaryIndex.cljs$lang$ctorStr = "nativestore.core/BinaryIndex";

nativestore.core.BinaryIndex.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/BinaryIndex");
});

nativestore.core.__GT_BinaryIndex = (function nativestore$core$__GT_BinaryIndex(keyfn,compfn,arry){
return (new nativestore.core.BinaryIndex(keyfn,compfn,arry));
});

nativestore.core.ordered_index = (function nativestore$core$ordered_index(keyfn,compfn){
return (new nativestore.core.BinaryIndex(keyfn,compfn,[]));
});
/**
 * Return a js array key for compound ordering
 */
nativestore.core.compound_key_fn = (function nativestore$core$compound_key_fn(keyfns){
var cnt = cljs.core.count.call(null,keyfns);
return ((function (cnt){
return (function (obj){
var vals = (new Array(cnt));
var i = (0);
var keyfns__$1 = keyfns;
while(true){
if(cljs.core.empty_QMARK_.call(null,keyfns__$1)){
return vals;
} else {
var temp__4423__auto__ = cljs.core.first.call(null,keyfns__$1).call(null,obj);
if(cljs.core.truth_(temp__4423__auto__)){
var val = temp__4423__auto__;
(vals[i] = val);

var G__12121 = (i + (1));
var G__12122 = cljs.core.rest.call(null,keyfns__$1);
i = G__12121;
keyfns__$1 = G__12122;
continue;
} else {
return null;
}
}
break;
}
});
;})(cnt))
});
/**
 * Compare two compound keys using the array of comparators
 */
nativestore.core.compound_comparator = (function nativestore$core$compound_comparator(comps){
var cnt = cljs.core.count.call(null,comps);
return ((function (cnt){
return (function (akey1,akey2){
var i = (0);
var comps__$1 = comps;
var ans = (0);
while(true){
if(!(cljs.core.empty_QMARK_.call(null,comps__$1))){
var comp = cljs.core.first.call(null,comps__$1);
var res = comp.call(null,(akey1[i]),(akey2[i]));
if(cljs.core._EQ_.call(null,res,(0))){
var G__12123 = (i + (1));
var G__12124 = cljs.core.rest.call(null,comps__$1);
var G__12125 = res;
i = G__12123;
comps__$1 = G__12124;
ans = G__12125;
continue;
} else {
return res;
}
} else {
return ans;
}
break;
}
});
;})(cnt))
});
nativestore.core.compound_index = (function nativestore$core$compound_index(keyfns,compfns){
return (new nativestore.core.BinaryIndex(nativestore.core.compound_key_fn.call(null,keyfns),nativestore.core.compound_comparator.call(null,compfns),[]));
});
/**
 * Ensure submitted object is a native and set to read-only state
 */
nativestore.core.as_ro_native = (function nativestore$core$as_ro_native(obj){
if(cljs.core.truth_(nativestore.core.native_QMARK_.call(null,obj))){
return nativestore.core.read_only_BANG_.call(null,obj);
} else {
var native$ = nativestore.core.to_native.call(null,obj);
return nativestore.core.read_only_BANG_.call(null,native$);
}
});
/**
 * Use this to update store listeners when write dependencies
 * have been accumulatd
 */
nativestore.core.update_listeners = (function nativestore$core$update_listeners(result,dmap){
var vec__12127 = cljs.core.first.call(null,dmap);
var store = cljs.core.nth.call(null,vec__12127,(0),null);
var deps = cljs.core.nth.call(null,vec__12127,(1),null);
if(cljs.core.truth_(store)){
return derive.core.notify_listeners.call(null,store,deps);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {derive.core.IDependencySource}
 * @implements {cljs.core.IFn}
 * @implements {nativestore.core.IIndexedStore}
 * @implements {nativestore.core.ITransactionalStore}
 * @implements {cljs.core.ICounted}
 * @implements {nativestore.core.IClearable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {nativestore.core.IStore}
 * @implements {cljs.core.ILookup}
*/
nativestore.core.NativeStore = (function (root,indices,tx_listeners,listeners){
this.root = root;
this.indices = indices;
this.tx_listeners = tx_listeners;
this.listeners = listeners;
this.cljs$lang$protocol_mask$partition0$ = 2147483907;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
nativestore.core.NativeStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (store,id){
var self__ = this;
var store__$1 = this;
return cljs.core._lookup.call(null,store__$1,id,null);
});

nativestore.core.NativeStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (store,id,not_found){
var self__ = this;
var store__$1 = this;
nativestore.core.inform_tracker.call(null,store__$1,(function (){var obj12130 = {"root":[id]};
return obj12130;
})());

return cljs.core._lookup.call(null,self__.root,id,not_found);
});

nativestore.core.NativeStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (native$,writer,opts){
var self__ = this;
var native$__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#NativeStore[]")].join(''));
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$ = true;

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$subscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
return self__.listeners = cljs.core.update_in.call(null,self__.listeners,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deps], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),listener);
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$2 = (function (this$,listener){
var self__ = this;
var this$__$1 = this;
var old_set = cljs.core.get.call(null,self__.listeners,null);
var new_set = cljs.core.disj.call(null,self__.listeners,listener);
if(cljs.core.empty_QMARK_.call(null,new_set)){
return self__.listeners = cljs.core.dissoc.call(null,self__.listeners,null);
} else {
return self__.listeners = cljs.core.assoc.call(null,self__.listeners,null,new_set);
}
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$unsubscribe_BANG_$arity$3 = (function (this$,listener,deps){
var self__ = this;
var this$__$1 = this;
var old_set = cljs.core.get.call(null,self__.listeners,deps);
var new_set = ((cljs.core.set_QMARK_.call(null,old_set))?cljs.core.disj.call(null,old_set,listener):null);
if(cljs.core.empty_QMARK_.call(null,new_set)){
return self__.listeners = cljs.core.dissoc.call(null,self__.listeners,deps);
} else {
return self__.listeners = cljs.core.assoc.call(null,self__.listeners,deps,new_set);
}
});

nativestore.core.NativeStore.prototype.derive$core$IDependencySource$empty_deps$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return nativestore.core.make_dependencies.call(null,this$__$1);
});

nativestore.core.NativeStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (store){
var self__ = this;
var store__$1 = this;
return cljs.core._count.call(null,self__.root);
});

nativestore.core.NativeStore.prototype.nativestore$core$ITransactionalStore$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$ITransactionalStore$_transact_BANG_$arity$3 = (function (store,f,args){
var self__ = this;
var store__$1 = this;
var parent_shadow__11932__auto__ = derive.core._STAR_shadow_STAR_;
var handler__11933__auto__ = nativestore.core.update_listeners;
var shadow_QMARK___11934__auto__ = true;
var _STAR_tracker_STAR_12131 = derive.core._STAR_tracker_STAR_;
var _STAR_shadow_STAR_12132 = derive.core._STAR_shadow_STAR_;
derive.core._STAR_tracker_STAR_ = (cljs.core.truth_(derive.core._STAR_shadow_STAR_)?derive.core._STAR_tracker_STAR_:derive.core.default_tracker.call(null));

derive.core._STAR_shadow_STAR_ = (function (){var or__6137__auto__ = derive.core._STAR_shadow_STAR_;
if(cljs.core.truth_(or__6137__auto__)){
return or__6137__auto__;
} else {
return shadow_QMARK___11934__auto__;
}
})();

try{var result__11935__auto__ = (function (){var _STAR_transaction_STAR_12133 = nativestore.core._STAR_transaction_STAR_;
nativestore.core._STAR_transaction_STAR_ = [];

try{var result = cljs.core.apply.call(null,f,store__$1,args);
return cljs.core._notify_watches.call(null,store__$1,null,nativestore.core._STAR_transaction_STAR_);
}finally {nativestore.core._STAR_transaction_STAR_ = _STAR_transaction_STAR_12133;
}})();
if(cljs.core.truth_(parent_shadow__11932__auto__)){
} else {
var dmap__11936__auto___12184 = derive.core.dependencies.call(null,derive.core._STAR_tracker_STAR_);
handler__11933__auto__.call(null,result__11935__auto__,dmap__11936__auto___12184);
}

return result__11935__auto__;
}finally {derive.core._STAR_shadow_STAR_ = _STAR_shadow_STAR_12132;

derive.core._STAR_tracker_STAR_ = _STAR_tracker_STAR_12131;
}});

nativestore.core.NativeStore.prototype.nativestore$core$IStore$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$IStore$insert_BANG_$arity$2 = (function (store,obj){
var self__ = this;
var store__$1 = this;
var parent_shadow__11932__auto__ = derive.core._STAR_shadow_STAR_;
var handler__11933__auto__ = nativestore.core.update_listeners;
var shadow_QMARK___11934__auto__ = null;
var _STAR_tracker_STAR_12134 = derive.core._STAR_tracker_STAR_;
var _STAR_shadow_STAR_12135 = derive.core._STAR_shadow_STAR_;
derive.core._STAR_tracker_STAR_ = (cljs.core.truth_(derive.core._STAR_shadow_STAR_)?derive.core._STAR_tracker_STAR_:derive.core.default_tracker.call(null));

derive.core._STAR_shadow_STAR_ = (function (){var or__6137__auto__ = derive.core._STAR_shadow_STAR_;
if(cljs.core.truth_(or__6137__auto__)){
return or__6137__auto__;
} else {
return shadow_QMARK___11934__auto__;
}
})();

try{var result__11935__auto__ = (function (){var obj__$1 = nativestore.core.as_ro_native.call(null,obj);
var key_12185 = nativestore.core.key_fn.call(null,self__.root).call(null,obj__$1);
var __12186 = (cljs.core.truth_(key_12185)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Must have an ID field"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"key","key",124488940,null)))].join('')))})());
var names_12187 = cljs.core.js_keys.call(null,self__.indices);
var old_12188 = cljs.core.get.call(null,self__.root,key_12185);
var oldref_12189 = (cljs.core.truth_(old_12188)?purnam.native$.functions.js_copy.call(null,old_12188):null);
if(cljs.core.truth_(old_12188)){
var seq__12136_12190 = cljs.core.seq.call(null,names_12187);
var chunk__12137_12191 = null;
var count__12138_12192 = (0);
var i__12139_12193 = (0);
while(true){
if((i__12139_12193 < count__12138_12192)){
var iname_12194 = cljs.core._nth.call(null,chunk__12137_12191,i__12139_12193);
var idx_12195 = (self__.indices[iname_12194]);
var ikey_12196 = nativestore.core.key_fn.call(null,idx_12195).call(null,old_12188);
if(((ikey_12196 == null)) || (cljs.core._EQ_.call(null,ikey_12196,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12140 = cljs.core.name.call(null,iname_12194);
var obj12142 = {};
(obj12142[G__12140] = [ikey_12196,ikey_12196]);

return obj12142;
})());

nativestore.core.unindex_BANG_.call(null,idx_12195,old_12188);
}

var G__12197 = seq__12136_12190;
var G__12198 = chunk__12137_12191;
var G__12199 = count__12138_12192;
var G__12200 = (i__12139_12193 + (1));
seq__12136_12190 = G__12197;
chunk__12137_12191 = G__12198;
count__12138_12192 = G__12199;
i__12139_12193 = G__12200;
continue;
} else {
var temp__4425__auto___12201 = cljs.core.seq.call(null,seq__12136_12190);
if(temp__4425__auto___12201){
var seq__12136_12202__$1 = temp__4425__auto___12201;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12136_12202__$1)){
var c__6940__auto___12203 = cljs.core.chunk_first.call(null,seq__12136_12202__$1);
var G__12204 = cljs.core.chunk_rest.call(null,seq__12136_12202__$1);
var G__12205 = c__6940__auto___12203;
var G__12206 = cljs.core.count.call(null,c__6940__auto___12203);
var G__12207 = (0);
seq__12136_12190 = G__12204;
chunk__12137_12191 = G__12205;
count__12138_12192 = G__12206;
i__12139_12193 = G__12207;
continue;
} else {
var iname_12208 = cljs.core.first.call(null,seq__12136_12202__$1);
var idx_12209 = (self__.indices[iname_12208]);
var ikey_12210 = nativestore.core.key_fn.call(null,idx_12209).call(null,old_12188);
if(((ikey_12210 == null)) || (cljs.core._EQ_.call(null,ikey_12210,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12143 = cljs.core.name.call(null,iname_12208);
var obj12145 = {};
(obj12145[G__12143] = [ikey_12210,ikey_12210]);

return obj12145;
})());

nativestore.core.unindex_BANG_.call(null,idx_12209,old_12188);
}

var G__12211 = cljs.core.next.call(null,seq__12136_12202__$1);
var G__12212 = null;
var G__12213 = (0);
var G__12214 = (0);
seq__12136_12190 = G__12211;
chunk__12137_12191 = G__12212;
count__12138_12192 = G__12213;
i__12139_12193 = G__12214;
continue;
}
} else {
}
}
break;
}
} else {
}

nativestore.core.inform_tracker.call(null,store__$1,(function (){var obj12147 = {"root":[key_12185]};
return obj12147;
})());

nativestore.core.index_BANG_.call(null,self__.root,obj__$1);

var new_12215 = cljs.core.get.call(null,self__.root,key_12185);
var seq__12148_12216 = cljs.core.seq.call(null,names_12187);
var chunk__12149_12217 = null;
var count__12150_12218 = (0);
var i__12151_12219 = (0);
while(true){
if((i__12151_12219 < count__12150_12218)){
var iname_12220 = cljs.core._nth.call(null,chunk__12149_12217,i__12151_12219);
var idx_12221 = (self__.indices[iname_12220]);
var ikey_12222 = nativestore.core.key_fn.call(null,idx_12221).call(null,new_12215);
if(((ikey_12222 == null)) || (cljs.core._EQ_.call(null,ikey_12222,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12152 = cljs.core.name.call(null,iname_12220);
var obj12154 = {};
(obj12154[G__12152] = [ikey_12222,ikey_12222]);

return obj12154;
})());

nativestore.core.index_BANG_.call(null,idx_12221,new_12215);
}

var G__12223 = seq__12148_12216;
var G__12224 = chunk__12149_12217;
var G__12225 = count__12150_12218;
var G__12226 = (i__12151_12219 + (1));
seq__12148_12216 = G__12223;
chunk__12149_12217 = G__12224;
count__12150_12218 = G__12225;
i__12151_12219 = G__12226;
continue;
} else {
var temp__4425__auto___12227 = cljs.core.seq.call(null,seq__12148_12216);
if(temp__4425__auto___12227){
var seq__12148_12228__$1 = temp__4425__auto___12227;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12148_12228__$1)){
var c__6940__auto___12229 = cljs.core.chunk_first.call(null,seq__12148_12228__$1);
var G__12230 = cljs.core.chunk_rest.call(null,seq__12148_12228__$1);
var G__12231 = c__6940__auto___12229;
var G__12232 = cljs.core.count.call(null,c__6940__auto___12229);
var G__12233 = (0);
seq__12148_12216 = G__12230;
chunk__12149_12217 = G__12231;
count__12150_12218 = G__12232;
i__12151_12219 = G__12233;
continue;
} else {
var iname_12234 = cljs.core.first.call(null,seq__12148_12228__$1);
var idx_12235 = (self__.indices[iname_12234]);
var ikey_12236 = nativestore.core.key_fn.call(null,idx_12235).call(null,new_12215);
if(((ikey_12236 == null)) || (cljs.core._EQ_.call(null,ikey_12236,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12155 = cljs.core.name.call(null,iname_12234);
var obj12157 = {};
(obj12157[G__12155] = [ikey_12236,ikey_12236]);

return obj12157;
})());

nativestore.core.index_BANG_.call(null,idx_12235,new_12215);
}

var G__12237 = cljs.core.next.call(null,seq__12148_12228__$1);
var G__12238 = null;
var G__12239 = (0);
var G__12240 = (0);
seq__12148_12216 = G__12237;
chunk__12149_12217 = G__12238;
count__12150_12218 = G__12239;
i__12151_12219 = G__12240;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(nativestore.core._STAR_transaction_STAR_)){
nativestore.core._STAR_transaction_STAR_.push([new cljs.core.Keyword(null,"insert","insert",1286475395),oldref_12189,new_12215]);
} else {
cljs.core._notify_watches.call(null,store__$1,null,[[new cljs.core.Keyword(null,"insert","insert",1286475395),oldref_12189,new_12215]]);
}

return store__$1;
})();
if(cljs.core.truth_(parent_shadow__11932__auto__)){
} else {
var dmap__11936__auto___12241 = derive.core.dependencies.call(null,derive.core._STAR_tracker_STAR_);
handler__11933__auto__.call(null,result__11935__auto__,dmap__11936__auto___12241);
}

return result__11935__auto__;
}finally {derive.core._STAR_shadow_STAR_ = _STAR_shadow_STAR_12135;

derive.core._STAR_tracker_STAR_ = _STAR_tracker_STAR_12134;
}});

nativestore.core.NativeStore.prototype.nativestore$core$IStore$delete_BANG_$arity$2 = (function (store,id){
var self__ = this;
var store__$1 = this;
var parent_shadow__11932__auto__ = derive.core._STAR_shadow_STAR_;
var handler__11933__auto__ = nativestore.core.update_listeners;
var shadow_QMARK___11934__auto__ = null;
var _STAR_tracker_STAR_12158 = derive.core._STAR_tracker_STAR_;
var _STAR_shadow_STAR_12159 = derive.core._STAR_shadow_STAR_;
derive.core._STAR_tracker_STAR_ = (cljs.core.truth_(derive.core._STAR_shadow_STAR_)?derive.core._STAR_tracker_STAR_:derive.core.default_tracker.call(null));

derive.core._STAR_shadow_STAR_ = (function (){var or__6137__auto__ = derive.core._STAR_shadow_STAR_;
if(cljs.core.truth_(or__6137__auto__)){
return or__6137__auto__;
} else {
return shadow_QMARK___11934__auto__;
}
})();

try{var result__11935__auto__ = (function (){
var temp__4425__auto___12242 = cljs.core.get.call(null,self__.root,id);
if(cljs.core.truth_(temp__4425__auto___12242)){
var old_12243 = temp__4425__auto___12242;
var seq__12160_12244 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,self__.indices));
var chunk__12161_12245 = null;
var count__12162_12246 = (0);
var i__12163_12247 = (0);
while(true){
if((i__12163_12247 < count__12162_12246)){
var iname_12248 = cljs.core._nth.call(null,chunk__12161_12245,i__12163_12247);
var idx_12249 = (self__.indices[iname_12248]);
var ikey_12250 = nativestore.core.key_fn.call(null,idx_12249).call(null,old_12243);
if(((ikey_12250 == null)) || (cljs.core._EQ_.call(null,ikey_12250,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12164 = cljs.core.name.call(null,iname_12248);
var obj12166 = {};
(obj12166[G__12164] = [ikey_12250,ikey_12250]);

return obj12166;
})());

nativestore.core.unindex_BANG_.call(null,idx_12249,old_12243);
}

var G__12251 = seq__12160_12244;
var G__12252 = chunk__12161_12245;
var G__12253 = count__12162_12246;
var G__12254 = (i__12163_12247 + (1));
seq__12160_12244 = G__12251;
chunk__12161_12245 = G__12252;
count__12162_12246 = G__12253;
i__12163_12247 = G__12254;
continue;
} else {
var temp__4425__auto___12255__$1 = cljs.core.seq.call(null,seq__12160_12244);
if(temp__4425__auto___12255__$1){
var seq__12160_12256__$1 = temp__4425__auto___12255__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12160_12256__$1)){
var c__6940__auto___12257 = cljs.core.chunk_first.call(null,seq__12160_12256__$1);
var G__12258 = cljs.core.chunk_rest.call(null,seq__12160_12256__$1);
var G__12259 = c__6940__auto___12257;
var G__12260 = cljs.core.count.call(null,c__6940__auto___12257);
var G__12261 = (0);
seq__12160_12244 = G__12258;
chunk__12161_12245 = G__12259;
count__12162_12246 = G__12260;
i__12163_12247 = G__12261;
continue;
} else {
var iname_12262 = cljs.core.first.call(null,seq__12160_12256__$1);
var idx_12263 = (self__.indices[iname_12262]);
var ikey_12264 = nativestore.core.key_fn.call(null,idx_12263).call(null,old_12243);
if(((ikey_12264 == null)) || (cljs.core._EQ_.call(null,ikey_12264,false))){
} else {
nativestore.core.inform_tracker.call(null,store__$1,(function (){var G__12167 = cljs.core.name.call(null,iname_12262);
var obj12169 = {};
(obj12169[G__12167] = [ikey_12264,ikey_12264]);

return obj12169;
})());

nativestore.core.unindex_BANG_.call(null,idx_12263,old_12243);
}

var G__12265 = cljs.core.next.call(null,seq__12160_12256__$1);
var G__12266 = null;
var G__12267 = (0);
var G__12268 = (0);
seq__12160_12244 = G__12265;
chunk__12161_12245 = G__12266;
count__12162_12246 = G__12267;
i__12163_12247 = G__12268;
continue;
}
} else {
}
}
break;
}

nativestore.core.inform_tracker.call(null,store__$1,(function (){var obj12171 = {"root":[id]};
return obj12171;
})());

nativestore.core.unindex_BANG_.call(null,self__.root,old_12243);

if(cljs.core.truth_(nativestore.core._STAR_transaction_STAR_)){
nativestore.core._STAR_transaction_STAR_.push([new cljs.core.Keyword(null,"delete","delete",-1768633620),old_12243]);
} else {
cljs.core._notify_watches.call(null,store__$1,null,[new cljs.core.Keyword(null,"delete","delete",-1768633620),old_12243]);
}
} else {
}

return store__$1;
})()
;
if(cljs.core.truth_(parent_shadow__11932__auto__)){
} else {
var dmap__11936__auto___12269 = derive.core.dependencies.call(null,derive.core._STAR_tracker_STAR_);
handler__11933__auto__.call(null,result__11935__auto__,dmap__11936__auto___12269);
}

return result__11935__auto__;
}finally {derive.core._STAR_shadow_STAR_ = _STAR_shadow_STAR_12159;

derive.core._STAR_tracker_STAR_ = _STAR_tracker_STAR_12158;
}});

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$add_index_BANG_$arity$3 = (function (store,iname,index){
var self__ = this;
var store__$1 = this;
if(cljs.core.not.call(null,nativestore.core.get_index.call(null,store__$1,iname))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"get-index","get-index",2080583133,null),new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"iname","iname",-1981846785,null)))))].join('')));
}

purnam.native$.functions.js_assoc.call(null,self__.indices,iname,index);

return store__$1;
});

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$rem_index_BANG_$arity$2 = (function (store,iname){
var self__ = this;
var store__$1 = this;
if(cljs.core.truth_(nativestore.core.get_index.call(null,store__$1,iname))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"get-index","get-index",2080583133,null),new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"iname","iname",-1981846785,null))))].join('')));
}

purnam.native$.functions.js_dissoc.call(null,self__.indices,iname);

return store__$1;
});

nativestore.core.NativeStore.prototype.nativestore$core$IIndexedStore$get_index$arity$2 = (function (store,iname){
var self__ = this;
var store__$1 = this;
if((typeof iname === 'string') || ((iname instanceof cljs.core.Keyword))){
return purnam.native$.functions.js_lookup.call(null,self__.indices,cljs.core.name.call(null,iname));
} else {
return iname;
}
});

nativestore.core.NativeStore.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (store,_,txs){
var self__ = this;
var store__$1 = this;
var seq__12172_12270 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,self__.tx_listeners));
var chunk__12173_12271 = null;
var count__12174_12272 = (0);
var i__12175_12273 = (0);
while(true){
if((i__12175_12273 < count__12174_12272)){
var name_12274 = cljs.core._nth.call(null,chunk__12173_12271,i__12175_12273);
var listener_12275 = cljs.core.get.call(null,self__.tx_listeners,name_12274);
listener_12275.call(null,null,txs);

var G__12276 = seq__12172_12270;
var G__12277 = chunk__12173_12271;
var G__12278 = count__12174_12272;
var G__12279 = (i__12175_12273 + (1));
seq__12172_12270 = G__12276;
chunk__12173_12271 = G__12277;
count__12174_12272 = G__12278;
i__12175_12273 = G__12279;
continue;
} else {
var temp__4425__auto___12280 = cljs.core.seq.call(null,seq__12172_12270);
if(temp__4425__auto___12280){
var seq__12172_12281__$1 = temp__4425__auto___12280;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12172_12281__$1)){
var c__6940__auto___12282 = cljs.core.chunk_first.call(null,seq__12172_12281__$1);
var G__12283 = cljs.core.chunk_rest.call(null,seq__12172_12281__$1);
var G__12284 = c__6940__auto___12282;
var G__12285 = cljs.core.count.call(null,c__6940__auto___12282);
var G__12286 = (0);
seq__12172_12270 = G__12283;
chunk__12173_12271 = G__12284;
count__12174_12272 = G__12285;
i__12175_12273 = G__12286;
continue;
} else {
var name_12287 = cljs.core.first.call(null,seq__12172_12281__$1);
var listener_12288 = cljs.core.get.call(null,self__.tx_listeners,name_12287);
listener_12288.call(null,null,txs);

var G__12289 = cljs.core.next.call(null,seq__12172_12281__$1);
var G__12290 = null;
var G__12291 = (0);
var G__12292 = (0);
seq__12172_12270 = G__12289;
chunk__12173_12271 = G__12290;
count__12174_12272 = G__12291;
i__12175_12273 = G__12292;
continue;
}
} else {
}
}
break;
}

return store__$1;
});

nativestore.core.NativeStore.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (store,key,f){
var self__ = this;
var store__$1 = this;
purnam.native$.functions.js_assoc.call(null,self__.tx_listeners,key,f);

return store__$1;
});

nativestore.core.NativeStore.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (store,key){
var self__ = this;
var store__$1 = this;
purnam.native$.functions.js_dissoc.call(null,self__.tx_listeners,key);

return store__$1;
});

nativestore.core.NativeStore.prototype.call = (function() {
var G__12293 = null;
var G__12293__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var store = self____$1;
return cljs.core._lookup.call(null,store,k,null);
});
var G__12293__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var store = self____$1;
return cljs.core._lookup.call(null,store,k,not_found);
});
G__12293 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12293__2.call(this,self__,k);
case 3:
return G__12293__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12293.cljs$core$IFn$_invoke$arity$2 = G__12293__2;
G__12293.cljs$core$IFn$_invoke$arity$3 = G__12293__3;
return G__12293;
})()
;

nativestore.core.NativeStore.prototype.apply = (function (self__,args12128){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args12128)));
});

nativestore.core.NativeStore.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var store = this;
return cljs.core._lookup.call(null,store,k,null);
});

nativestore.core.NativeStore.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var store = this;
return cljs.core._lookup.call(null,store,k,not_found);
});

nativestore.core.NativeStore.prototype.nativestore$core$IClearable$ = true;

nativestore.core.NativeStore.prototype.nativestore$core$IClearable$clear_BANG_$arity$1 = (function (store){
var self__ = this;
var store__$1 = this;
derive.core.force_invalidation.call(null,store__$1);

var seq__12176_12294 = cljs.core.seq.call(null,cljs.core.seq.call(null,nativestore.core._get_cursor.call(null,self__.root)));
var chunk__12177_12295 = null;
var count__12178_12296 = (0);
var i__12179_12297 = (0);
while(true){
if((i__12179_12297 < count__12178_12296)){
var obj_12298 = cljs.core._nth.call(null,chunk__12177_12295,i__12179_12297);
nativestore.core.delete_BANG_.call(null,store__$1,nativestore.core.key_fn.call(null,self__.root).call(null,obj_12298));

var G__12299 = seq__12176_12294;
var G__12300 = chunk__12177_12295;
var G__12301 = count__12178_12296;
var G__12302 = (i__12179_12297 + (1));
seq__12176_12294 = G__12299;
chunk__12177_12295 = G__12300;
count__12178_12296 = G__12301;
i__12179_12297 = G__12302;
continue;
} else {
var temp__4425__auto___12303 = cljs.core.seq.call(null,seq__12176_12294);
if(temp__4425__auto___12303){
var seq__12176_12304__$1 = temp__4425__auto___12303;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12176_12304__$1)){
var c__6940__auto___12305 = cljs.core.chunk_first.call(null,seq__12176_12304__$1);
var G__12306 = cljs.core.chunk_rest.call(null,seq__12176_12304__$1);
var G__12307 = c__6940__auto___12305;
var G__12308 = cljs.core.count.call(null,c__6940__auto___12305);
var G__12309 = (0);
seq__12176_12294 = G__12306;
chunk__12177_12295 = G__12307;
count__12178_12296 = G__12308;
i__12179_12297 = G__12309;
continue;
} else {
var obj_12310 = cljs.core.first.call(null,seq__12176_12304__$1);
nativestore.core.delete_BANG_.call(null,store__$1,nativestore.core.key_fn.call(null,self__.root).call(null,obj_12310));

var G__12311 = cljs.core.next.call(null,seq__12176_12304__$1);
var G__12312 = null;
var G__12313 = (0);
var G__12314 = (0);
seq__12176_12294 = G__12311;
chunk__12177_12295 = G__12312;
count__12178_12296 = G__12313;
i__12179_12297 = G__12314;
continue;
}
} else {
}
}
break;
}

var seq__12180_12315 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,self__.indices));
var chunk__12181_12316 = null;
var count__12182_12317 = (0);
var i__12183_12318 = (0);
while(true){
if((i__12183_12318 < count__12182_12317)){
var iname_12319 = cljs.core._nth.call(null,chunk__12181_12316,i__12183_12318);
nativestore.core.clear_BANG_.call(null,(self__.indices[iname_12319]));

var G__12320 = seq__12180_12315;
var G__12321 = chunk__12181_12316;
var G__12322 = count__12182_12317;
var G__12323 = (i__12183_12318 + (1));
seq__12180_12315 = G__12320;
chunk__12181_12316 = G__12321;
count__12182_12317 = G__12322;
i__12183_12318 = G__12323;
continue;
} else {
var temp__4425__auto___12324 = cljs.core.seq.call(null,seq__12180_12315);
if(temp__4425__auto___12324){
var seq__12180_12325__$1 = temp__4425__auto___12324;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12180_12325__$1)){
var c__6940__auto___12326 = cljs.core.chunk_first.call(null,seq__12180_12325__$1);
var G__12327 = cljs.core.chunk_rest.call(null,seq__12180_12325__$1);
var G__12328 = c__6940__auto___12326;
var G__12329 = cljs.core.count.call(null,c__6940__auto___12326);
var G__12330 = (0);
seq__12180_12315 = G__12327;
chunk__12181_12316 = G__12328;
count__12182_12317 = G__12329;
i__12183_12318 = G__12330;
continue;
} else {
var iname_12331 = cljs.core.first.call(null,seq__12180_12325__$1);
nativestore.core.clear_BANG_.call(null,(self__.indices[iname_12331]));

var G__12332 = cljs.core.next.call(null,seq__12180_12325__$1);
var G__12333 = null;
var G__12334 = (0);
var G__12335 = (0);
seq__12180_12315 = G__12332;
chunk__12181_12316 = G__12333;
count__12182_12317 = G__12334;
i__12183_12318 = G__12335;
continue;
}
} else {
}
}
break;
}

nativestore.core.clear_BANG_.call(null,self__.root);

return store__$1;
});

nativestore.core.NativeStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"indices","indices",422393184,null),new cljs.core.Symbol(null,"tx-listeners","tx-listeners",-491786474,null),cljs.core.with_meta(new cljs.core.Symbol(null,"listeners","listeners",2035075972,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

nativestore.core.NativeStore.cljs$lang$type = true;

nativestore.core.NativeStore.cljs$lang$ctorStr = "nativestore.core/NativeStore";

nativestore.core.NativeStore.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"nativestore.core/NativeStore");
});

nativestore.core.__GT_NativeStore = (function nativestore$core$__GT_NativeStore(root,indices,tx_listeners,listeners){
return (new nativestore.core.NativeStore(root,indices,tx_listeners,listeners));
});

nativestore.core.transact_BANG_ = (function nativestore$core$transact_BANG_(var_args){
var args__7202__auto__ = [];
var len__7195__auto___12339 = arguments.length;
var i__7196__auto___12340 = (0);
while(true){
if((i__7196__auto___12340 < len__7195__auto___12339)){
args__7202__auto__.push((arguments[i__7196__auto___12340]));

var G__12341 = (i__7196__auto___12340 + (1));
i__7196__auto___12340 = G__12341;
continue;
} else {
}
break;
}

var argseq__7203__auto__ = ((((2) < args__7202__auto__.length))?(new cljs.core.IndexedSeq(args__7202__auto__.slice((2)),(0))):null);
return nativestore.core.transact_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7203__auto__);
});

nativestore.core.transact_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (store,f,args){
return nativestore.core._transact_BANG_.call(null,store,f,args);
});

nativestore.core.transact_BANG_.cljs$lang$maxFixedArity = (2);

nativestore.core.transact_BANG_.cljs$lang$applyTo = (function (seq12336){
var G__12337 = cljs.core.first.call(null,seq12336);
var seq12336__$1 = cljs.core.next.call(null,seq12336);
var G__12338 = cljs.core.first.call(null,seq12336__$1);
var seq12336__$2 = cljs.core.next.call(null,seq12336__$1);
return nativestore.core.transact_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12337,G__12338,seq12336__$2);
});
nativestore.core.create = (function nativestore$core$create(){
return (new nativestore.core.NativeStore(nativestore.core.root_index.call(null),{},{},cljs.core.PersistentArrayMap.EMPTY));
});
nativestore.core.fetch = (function nativestore$core$fetch(var_args){
var args12342 = [];
var len__7195__auto___12345 = arguments.length;
var i__7196__auto___12346 = (0);
while(true){
if((i__7196__auto___12346 < len__7195__auto___12345)){
args12342.push((arguments[i__7196__auto___12346]));

var G__12347 = (i__7196__auto___12346 + (1));
i__7196__auto___12346 = G__12347;
continue;
} else {
}
break;
}

var G__12344 = args12342.length;
switch (G__12344) {
case 2:
return nativestore.core.fetch.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.fetch.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12342.length)].join('')));

}
});

nativestore.core.fetch.cljs$core$IFn$_invoke$arity$2 = (function (store,key){
return cljs.core.get.call(null,store,key);
});

nativestore.core.fetch.cljs$core$IFn$_invoke$arity$3 = (function (store,index,key){
return cljs.core.get.call(null,nativestore.core.get_index.call(null,store,index),key);
});

nativestore.core.fetch.cljs$lang$maxFixedArity = 3;
nativestore.core.first_val = (function nativestore$core$first_val(idx){
return nativestore.core.key_fn.call(null,idx).call(null,(idx.arry[(0)]));
});
nativestore.core.last_val = (function nativestore$core$last_val(idx){
return nativestore.core.key_fn.call(null,idx).call(null,(idx.arry[(idx.arry.length - (1))]));
});
/**
 * Walk the entire store, or an index
 */
nativestore.core.cursor = (function nativestore$core$cursor(var_args){
var args12349 = [];
var len__7195__auto___12358 = arguments.length;
var i__7196__auto___12359 = (0);
while(true){
if((i__7196__auto___12359 < len__7195__auto___12358)){
args12349.push((arguments[i__7196__auto___12359]));

var G__12360 = (i__7196__auto___12359 + (1));
i__7196__auto___12359 = G__12360;
continue;
} else {
}
break;
}

var G__12351 = args12349.length;
switch (G__12351) {
case 1:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return nativestore.core.cursor.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12349.length)].join('')));

}
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$1 = (function (store){
return nativestore.core._get_cursor.call(null,store.root);
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$2 = (function (store,index){
var iname = cljs.core.name.call(null,index);
var index__$1 = nativestore.core.get_index.call(null,store,iname);
if(cljs.core.truth_(index__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Index "),cljs.core.str(iname),cljs.core.str(" is not defined.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"index","index",108845612,null)))].join('')));
}

nativestore.core.inform_tracker.call(null,store,(function (){var obj12353 = {};
(obj12353[iname] = []);

return obj12353;
})());

return nativestore.core._get_cursor.call(null,index__$1);
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$3 = (function (store,index,start){
var iname = cljs.core.name.call(null,index);
var index__$1 = nativestore.core.get_index.call(null,store,index);
if(cljs.core.truth_(index__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Index "),cljs.core.str(iname),cljs.core.str(" is not defined.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"index","index",108845612,null)))].join('')));
}

nativestore.core.inform_tracker.call(null,store,(function (){var obj12355 = {};
(obj12355[iname] = [start]);

return obj12355;
})());

return nativestore.core._get_cursor.call(null,index__$1,start);
});

nativestore.core.cursor.cljs$core$IFn$_invoke$arity$4 = (function (store,index,start,end){
var iname = cljs.core.name.call(null,index);
var index__$1 = nativestore.core.get_index.call(null,store,index);
if(cljs.core.truth_(index__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Index "),cljs.core.str(iname),cljs.core.str(" is not defined.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"index","index",108845612,null)))].join('')));
}

nativestore.core.inform_tracker.call(null,store,(function (){var obj12357 = {};
(obj12357[iname] = [start,end]);

return obj12357;
})());

return nativestore.core._get_cursor.call(null,index__$1,start,end);
});

nativestore.core.cursor.cljs$lang$maxFixedArity = 4;
nativestore.core.field_key = (function nativestore$core$field_key(field){
var f = cljs.core.name.call(null,field);
return ((function (f){
return (function (obj){
return (obj[f]);
});
;})(f))
});
nativestore.core.type_field_key = (function nativestore$core$type_field_key(type,field){
var t = cljs.core.name.call(null,type);
var f = cljs.core.name.call(null,field);
return ((function (t,f){
return (function (obj){
if(cljs.core._EQ_.call(null,t,(obj["type"]))){
return (obj[f]);
} else {
return null;
}
});
;})(t,f))
});
nativestore.core.ensure_index = (function nativestore$core$ensure_index(var_args){
var args12362 = [];
var len__7195__auto___12365 = arguments.length;
var i__7196__auto___12366 = (0);
while(true){
if((i__7196__auto___12366 < len__7195__auto___12365)){
args12362.push((arguments[i__7196__auto___12366]));

var G__12367 = (i__7196__auto___12366 + (1));
i__7196__auto___12366 = G__12367;
continue;
} else {
}
break;
}

var G__12364 = args12362.length;
switch (G__12364) {
case 4:
return nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12362.length)].join('')));

}
});

nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$4 = (function (store,iname,key,comp){
if(cljs.core.truth_(nativestore.core.get_index.call(null,store,iname))){
return null;
} else {
return nativestore.core.add_index_BANG_.call(null,store,iname,nativestore.core.ordered_index.call(null,((cljs.core.fn_QMARK_.call(null,key))?key:nativestore.core.field_key.call(null,key)),comp));
}
});

nativestore.core.ensure_index.cljs$core$IFn$_invoke$arity$3 = (function (store,iname,key_or_idx){
if(((key_or_idx instanceof cljs.core.Keyword)) || ((key_or_idx instanceof cljs.core.Symbol))){
return nativestore.core.ensure_index.call(null,store,iname,key_or_idx,cljs.core.compare);
} else {
if(cljs.core.truth_(nativestore.core.get_index.call(null,store,iname))){
return null;
} else {
return nativestore.core.add_index_BANG_.call(null,store,iname,key_or_idx);
}
}
});

nativestore.core.ensure_index.cljs$lang$maxFixedArity = 4;
