// Compiled by ClojureScript 1.7.228 {}
goog.provide('clojure.core.reducers');
goog.require('cljs.core');
goog.require('cljs.core');
clojure.core.reducers.fjtask = (function clojure$core$reducers$fjtask(f){
return f;
});
clojure.core.reducers.fjinvoke = (function clojure$core$reducers$fjinvoke(f){
return f.call(null);
});
clojure.core.reducers.fjfork = (function clojure$core$reducers$fjfork(task){
return task;
});
clojure.core.reducers.fjjoin = (function clojure$core$reducers$fjjoin(task){
return task.call(null);
});
/**
 * Like core/reduce except:
 *   When init is not provided, (f) is used.
 *   Maps are reduced with reduce-kv
 */
clojure.core.reducers.reduce = (function clojure$core$reducers$reduce(var_args){
var args12371 = [];
var len__7195__auto___12374 = arguments.length;
var i__7196__auto___12375 = (0);
while(true){
if((i__7196__auto___12375 < len__7195__auto___12374)){
args12371.push((arguments[i__7196__auto___12375]));

var G__12376 = (i__7196__auto___12375 + (1));
i__7196__auto___12375 = G__12376;
continue;
} else {
}
break;
}

var G__12373 = args12371.length;
switch (G__12373) {
case 2:
return clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12371.length)].join('')));

}
});

clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return clojure.core.reducers.reduce.call(null,f,f.call(null),coll);
});

clojure.core.reducers.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
if(cljs.core.map_QMARK_.call(null,coll)){
return cljs.core._kv_reduce.call(null,coll,f,init);
} else {
if((coll == null)){
return init;
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return cljs.core.array_reduce.call(null,coll,f,init);
} else {
return cljs.core._reduce.call(null,coll,f,init);

}
}
}
});

clojure.core.reducers.reduce.cljs$lang$maxFixedArity = 3;

/**
 * @interface
 */
clojure.core.reducers.CollFold = function(){};

clojure.core.reducers.coll_fold = (function clojure$core$reducers$coll_fold(coll,n,combinef,reducef){
if((!((coll == null))) && (!((coll.clojure$core$reducers$CollFold$coll_fold$arity$4 == null)))){
return coll.clojure$core$reducers$CollFold$coll_fold$arity$4(coll,n,combinef,reducef);
} else {
var x__6792__auto__ = (((coll == null))?null:coll);
var m__6793__auto__ = (clojure.core.reducers.coll_fold[goog.typeOf(x__6792__auto__)]);
if(!((m__6793__auto__ == null))){
return m__6793__auto__.call(null,coll,n,combinef,reducef);
} else {
var m__6793__auto____$1 = (clojure.core.reducers.coll_fold["_"]);
if(!((m__6793__auto____$1 == null))){
return m__6793__auto____$1.call(null,coll,n,combinef,reducef);
} else {
throw cljs.core.missing_protocol.call(null,"CollFold.coll-fold",coll);
}
}
}
});

/**
 * Reduces a collection using a (potentially parallel) reduce-combine
 *   strategy. The collection is partitioned into groups of approximately
 *   n (default 512), each of which is reduced with reducef (with a seed
 *   value obtained by calling (combinef) with no arguments). The results
 *   of these reductions are then reduced with combinef (default
 *   reducef). combinef must be associative, and, when called with no
 *   arguments, (combinef) must produce its identity element. These
 *   operations may be performed in parallel, but the results will
 *   preserve order.
 * 
 *   Note: Performing operations in parallel is currently not implemented.
 */
clojure.core.reducers.fold = (function clojure$core$reducers$fold(var_args){
var args12378 = [];
var len__7195__auto___12381 = arguments.length;
var i__7196__auto___12382 = (0);
while(true){
if((i__7196__auto___12382 < len__7195__auto___12381)){
args12378.push((arguments[i__7196__auto___12382]));

var G__12383 = (i__7196__auto___12382 + (1));
i__7196__auto___12382 = G__12383;
continue;
} else {
}
break;
}

var G__12380 = args12378.length;
switch (G__12380) {
case 2:
return clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12378.length)].join('')));

}
});

clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$2 = (function (reducef,coll){
return clojure.core.reducers.fold.call(null,reducef,reducef,coll);
});

clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$3 = (function (combinef,reducef,coll){
return clojure.core.reducers.fold.call(null,(512),combinef,reducef,coll);
});

clojure.core.reducers.fold.cljs$core$IFn$_invoke$arity$4 = (function (n,combinef,reducef,coll){
return clojure.core.reducers.coll_fold.call(null,coll,n,combinef,reducef);
});

clojure.core.reducers.fold.cljs$lang$maxFixedArity = 4;
/**
 * Given a reducible collection, and a transformation function xf,
 *   returns a reducible collection, where any supplied reducing
 *   fn will be transformed by xf. xf is a function of reducing fn to
 *   reducing fn.
 */
clojure.core.reducers.reducer = (function clojure$core$reducers$reducer(coll,xf){
if(typeof clojure.core.reducers.t_clojure$core$reducers12388 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
clojure.core.reducers.t_clojure$core$reducers12388 = (function (reducer,coll,xf,meta12389){
this.reducer = reducer;
this.coll = coll;
this.xf = xf;
this.meta12389 = meta12389;
this.cljs$lang$protocol_mask$partition0$ = 917504;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
clojure.core.reducers.t_clojure$core$reducers12388.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12390,meta12389__$1){
var self__ = this;
var _12390__$1 = this;
return (new clojure.core.reducers.t_clojure$core$reducers12388(self__.reducer,self__.coll,self__.xf,meta12389__$1));
});

clojure.core.reducers.t_clojure$core$reducers12388.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12390){
var self__ = this;
var _12390__$1 = this;
return self__.meta12389;
});

clojure.core.reducers.t_clojure$core$reducers12388.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f1){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,f1,f1.call(null));
});

clojure.core.reducers.t_clojure$core$reducers12388.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f1,init){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.coll,self__.xf.call(null,f1),init);
});

clojure.core.reducers.t_clojure$core$reducers12388.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"reducer","reducer",-948842876,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a reducible collection, and a transformation function xf,\n  returns a reducible collection, where any supplied reducing\n  fn will be transformed by xf. xf is a function of reducing fn to\n  reducing fn."], null)),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"meta12389","meta12389",-1505098084,null)], null);
});

clojure.core.reducers.t_clojure$core$reducers12388.cljs$lang$type = true;

clojure.core.reducers.t_clojure$core$reducers12388.cljs$lang$ctorStr = "clojure.core.reducers/t_clojure$core$reducers12388";

clojure.core.reducers.t_clojure$core$reducers12388.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"clojure.core.reducers/t_clojure$core$reducers12388");
});

clojure.core.reducers.__GT_t_clojure$core$reducers12388 = (function clojure$core$reducers$reducer_$___GT_t_clojure$core$reducers12388(reducer__$1,coll__$1,xf__$1,meta12389){
return (new clojure.core.reducers.t_clojure$core$reducers12388(reducer__$1,coll__$1,xf__$1,meta12389));
});

}

return (new clojure.core.reducers.t_clojure$core$reducers12388(clojure$core$reducers$reducer,coll,xf,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Given a foldable collection, and a transformation function xf,
 *   returns a foldable collection, where any supplied reducing
 *   fn will be transformed by xf. xf is a function of reducing fn to
 *   reducing fn.
 */
clojure.core.reducers.folder = (function clojure$core$reducers$folder(coll,xf){
if(typeof clojure.core.reducers.t_clojure$core$reducers12394 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {clojure.core.reducers.CollFold}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
clojure.core.reducers.t_clojure$core$reducers12394 = (function (folder,coll,xf,meta12395){
this.folder = folder;
this.coll = coll;
this.xf = xf;
this.meta12395 = meta12395;
this.cljs$lang$protocol_mask$partition0$ = 917504;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
clojure.core.reducers.t_clojure$core$reducers12394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12396,meta12395__$1){
var self__ = this;
var _12396__$1 = this;
return (new clojure.core.reducers.t_clojure$core$reducers12394(self__.folder,self__.coll,self__.xf,meta12395__$1));
});

clojure.core.reducers.t_clojure$core$reducers12394.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12396){
var self__ = this;
var _12396__$1 = this;
return self__.meta12395;
});

clojure.core.reducers.t_clojure$core$reducers12394.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (_,f1){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.coll,self__.xf.call(null,f1),f1.call(null));
});

clojure.core.reducers.t_clojure$core$reducers12394.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f1,init){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.coll,self__.xf.call(null,f1),init);
});

clojure.core.reducers.t_clojure$core$reducers12394.prototype.clojure$core$reducers$CollFold$ = true;

clojure.core.reducers.t_clojure$core$reducers12394.prototype.clojure$core$reducers$CollFold$coll_fold$arity$4 = (function (_,n,combinef,reducef){
var self__ = this;
var ___$1 = this;
return clojure.core.reducers.coll_fold.call(null,self__.coll,n,combinef,self__.xf.call(null,reducef));
});

clojure.core.reducers.t_clojure$core$reducers12394.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"folder","folder",-1138554033,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Given a foldable collection, and a transformation function xf,\n  returns a foldable collection, where any supplied reducing\n  fn will be transformed by xf. xf is a function of reducing fn to\n  reducing fn."], null)),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.Symbol(null,"meta12395","meta12395",-738890392,null)], null);
});

clojure.core.reducers.t_clojure$core$reducers12394.cljs$lang$type = true;

clojure.core.reducers.t_clojure$core$reducers12394.cljs$lang$ctorStr = "clojure.core.reducers/t_clojure$core$reducers12394";

clojure.core.reducers.t_clojure$core$reducers12394.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"clojure.core.reducers/t_clojure$core$reducers12394");
});

clojure.core.reducers.__GT_t_clojure$core$reducers12394 = (function clojure$core$reducers$folder_$___GT_t_clojure$core$reducers12394(folder__$1,coll__$1,xf__$1,meta12395){
return (new clojure.core.reducers.t_clojure$core$reducers12394(folder__$1,coll__$1,xf__$1,meta12395));
});

}

return (new clojure.core.reducers.t_clojure$core$reducers12394(clojure$core$reducers$folder,coll,xf,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Applies f to every value in the reduction of coll. Foldable.
 */
clojure.core.reducers.map = (function clojure$core$reducers$map(var_args){
var args12397 = [];
var len__7195__auto___12400 = arguments.length;
var i__7196__auto___12401 = (0);
while(true){
if((i__7196__auto___12401 < len__7195__auto___12400)){
args12397.push((arguments[i__7196__auto___12401]));

var G__12402 = (i__7196__auto___12401 + (1));
i__7196__auto___12401 = G__12402;
continue;
} else {
}
break;
}

var G__12399 = args12397.length;
switch (G__12399) {
case 1:
return clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12397.length)].join('')));

}
});

clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (x__6578__auto__){
return clojure.core.reducers.map.call(null,f,x__6578__auto__);
});
});

clojure.core.reducers.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__12404 = null;
var G__12404__0 = (function (){
return f1.call(null);
});
var G__12404__2 = (function (ret,v){
return f1.call(null,ret,f.call(null,v));
});
var G__12404__3 = (function (ret,k,v){
return f1.call(null,ret,f.call(null,k,v));
});
G__12404 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__12404__0.call(this);
case 2:
return G__12404__2.call(this,ret,k);
case 3:
return G__12404__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12404.cljs$core$IFn$_invoke$arity$0 = G__12404__0;
G__12404.cljs$core$IFn$_invoke$arity$2 = G__12404__2;
G__12404.cljs$core$IFn$_invoke$arity$3 = G__12404__3;
return G__12404;
})()
}));
});

clojure.core.reducers.map.cljs$lang$maxFixedArity = 2;
/**
 * Applies f to every value in the reduction of coll, concatenating the result
 *   colls of (f val). Foldable.
 */
clojure.core.reducers.mapcat = (function clojure$core$reducers$mapcat(var_args){
var args12405 = [];
var len__7195__auto___12408 = arguments.length;
var i__7196__auto___12409 = (0);
while(true){
if((i__7196__auto___12409 < len__7195__auto___12408)){
args12405.push((arguments[i__7196__auto___12409]));

var G__12410 = (i__7196__auto___12409 + (1));
i__7196__auto___12409 = G__12410;
continue;
} else {
}
break;
}

var G__12407 = args12405.length;
switch (G__12407) {
case 1:
return clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12405.length)].join('')));

}
});

clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (x__6578__auto__){
return clojure.core.reducers.mapcat.call(null,f,x__6578__auto__);
});
});

clojure.core.reducers.mapcat.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__12412 = null;
var G__12412__0 = (function (){
return f1.call(null);
});
var G__12412__2 = (function (ret,v){
return clojure.core.reducers.reduce.call(null,f1,ret,f.call(null,v));
});
var G__12412__3 = (function (ret,k,v){
return clojure.core.reducers.reduce.call(null,f1,ret,f.call(null,k,v));
});
G__12412 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__12412__0.call(this);
case 2:
return G__12412__2.call(this,ret,k);
case 3:
return G__12412__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12412.cljs$core$IFn$_invoke$arity$0 = G__12412__0;
G__12412.cljs$core$IFn$_invoke$arity$2 = G__12412__2;
G__12412.cljs$core$IFn$_invoke$arity$3 = G__12412__3;
return G__12412;
})()
}));
});

clojure.core.reducers.mapcat.cljs$lang$maxFixedArity = 2;
/**
 * Retains values in the reduction of coll for which (pred val)
 *   returns logical true. Foldable.
 */
clojure.core.reducers.filter = (function clojure$core$reducers$filter(var_args){
var args12413 = [];
var len__7195__auto___12416 = arguments.length;
var i__7196__auto___12417 = (0);
while(true){
if((i__7196__auto___12417 < len__7195__auto___12416)){
args12413.push((arguments[i__7196__auto___12417]));

var G__12418 = (i__7196__auto___12417 + (1));
i__7196__auto___12417 = G__12418;
continue;
} else {
}
break;
}

var G__12415 = args12413.length;
switch (G__12415) {
case 1:
return clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12413.length)].join('')));

}
});

clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (x__6578__auto__){
return clojure.core.reducers.filter.call(null,pred,x__6578__auto__);
});
});

clojure.core.reducers.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__12420 = null;
var G__12420__0 = (function (){
return f1.call(null);
});
var G__12420__2 = (function (ret,v){
if(cljs.core.truth_(pred.call(null,v))){
return f1.call(null,ret,v);
} else {
return ret;
}
});
var G__12420__3 = (function (ret,k,v){
if(cljs.core.truth_(pred.call(null,k,v))){
return f1.call(null,ret,k,v);
} else {
return ret;
}
});
G__12420 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__12420__0.call(this);
case 2:
return G__12420__2.call(this,ret,k);
case 3:
return G__12420__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12420.cljs$core$IFn$_invoke$arity$0 = G__12420__0;
G__12420.cljs$core$IFn$_invoke$arity$2 = G__12420__2;
G__12420.cljs$core$IFn$_invoke$arity$3 = G__12420__3;
return G__12420;
})()
}));
});

clojure.core.reducers.filter.cljs$lang$maxFixedArity = 2;
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat foldable
 *   collection.
 */
clojure.core.reducers.flatten = (function clojure$core$reducers$flatten(var_args){
var args12421 = [];
var len__7195__auto___12424 = arguments.length;
var i__7196__auto___12425 = (0);
while(true){
if((i__7196__auto___12425 < len__7195__auto___12424)){
args12421.push((arguments[i__7196__auto___12425]));

var G__12426 = (i__7196__auto___12425 + (1));
i__7196__auto___12425 = G__12426;
continue;
} else {
}
break;
}

var G__12423 = args12421.length;
switch (G__12423) {
case 0:
return clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12421.length)].join('')));

}
});

clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (x__6578__auto__){
return clojure.core.reducers.flatten.call(null,x__6578__auto__);
});
});

clojure.core.reducers.flatten.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return clojure.core.reducers.folder.call(null,coll,(function (f1){
return (function() {
var G__12428 = null;
var G__12428__0 = (function (){
return f1.call(null);
});
var G__12428__2 = (function (ret,v){
if(cljs.core.sequential_QMARK_.call(null,v)){
return cljs.core._reduce.call(null,clojure.core.reducers.flatten.call(null,v),f1,ret);
} else {
return f1.call(null,ret,v);
}
});
G__12428 = function(ret,v){
switch(arguments.length){
case 0:
return G__12428__0.call(this);
case 2:
return G__12428__2.call(this,ret,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12428.cljs$core$IFn$_invoke$arity$0 = G__12428__0;
G__12428.cljs$core$IFn$_invoke$arity$2 = G__12428__2;
return G__12428;
})()
}));
});

clojure.core.reducers.flatten.cljs$lang$maxFixedArity = 1;
/**
 * Removes values in the reduction of coll for which (pred val)
 *   returns logical true. Foldable.
 */
clojure.core.reducers.remove = (function clojure$core$reducers$remove(var_args){
var args12429 = [];
var len__7195__auto___12432 = arguments.length;
var i__7196__auto___12433 = (0);
while(true){
if((i__7196__auto___12433 < len__7195__auto___12432)){
args12429.push((arguments[i__7196__auto___12433]));

var G__12434 = (i__7196__auto___12433 + (1));
i__7196__auto___12433 = G__12434;
continue;
} else {
}
break;
}

var G__12431 = args12429.length;
switch (G__12431) {
case 1:
return clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12429.length)].join('')));

}
});

clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (x__6578__auto__){
return clojure.core.reducers.remove.call(null,pred,x__6578__auto__);
});
});

clojure.core.reducers.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return clojure.core.reducers.filter.call(null,cljs.core.complement.call(null,pred),coll);
});

clojure.core.reducers.remove.cljs$lang$maxFixedArity = 2;
/**
 * Ends the reduction of coll when (pred val) returns logical false.
 */
clojure.core.reducers.take_while = (function clojure$core$reducers$take_while(var_args){
var args12436 = [];
var len__7195__auto___12439 = arguments.length;
var i__7196__auto___12440 = (0);
while(true){
if((i__7196__auto___12440 < len__7195__auto___12439)){
args12436.push((arguments[i__7196__auto___12440]));

var G__12441 = (i__7196__auto___12440 + (1));
i__7196__auto___12440 = G__12441;
continue;
} else {
}
break;
}

var G__12438 = args12436.length;
switch (G__12438) {
case 1:
return clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12436.length)].join('')));

}
});

clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (x__6578__auto__){
return clojure.core.reducers.take_while.call(null,pred,x__6578__auto__);
});
});

clojure.core.reducers.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return clojure.core.reducers.reducer.call(null,coll,(function (f1){
return (function() {
var G__12443 = null;
var G__12443__0 = (function (){
return f1.call(null);
});
var G__12443__2 = (function (ret,v){
if(cljs.core.truth_(pred.call(null,v))){
return f1.call(null,ret,v);
} else {
return cljs.core.reduced.call(null,ret);
}
});
var G__12443__3 = (function (ret,k,v){
if(cljs.core.truth_(pred.call(null,k,v))){
return f1.call(null,ret,k,v);
} else {
return cljs.core.reduced.call(null,ret);
}
});
G__12443 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__12443__0.call(this);
case 2:
return G__12443__2.call(this,ret,k);
case 3:
return G__12443__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12443.cljs$core$IFn$_invoke$arity$0 = G__12443__0;
G__12443.cljs$core$IFn$_invoke$arity$2 = G__12443__2;
G__12443.cljs$core$IFn$_invoke$arity$3 = G__12443__3;
return G__12443;
})()
}));
});

clojure.core.reducers.take_while.cljs$lang$maxFixedArity = 2;
/**
 * Ends the reduction of coll after consuming n values.
 */
clojure.core.reducers.take = (function clojure$core$reducers$take(var_args){
var args12444 = [];
var len__7195__auto___12447 = arguments.length;
var i__7196__auto___12448 = (0);
while(true){
if((i__7196__auto___12448 < len__7195__auto___12447)){
args12444.push((arguments[i__7196__auto___12448]));

var G__12449 = (i__7196__auto___12448 + (1));
i__7196__auto___12448 = G__12449;
continue;
} else {
}
break;
}

var G__12446 = args12444.length;
switch (G__12446) {
case 1:
return clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12444.length)].join('')));

}
});

clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (x__6578__auto__){
return clojure.core.reducers.take.call(null,n,x__6578__auto__);
});
});

clojure.core.reducers.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return clojure.core.reducers.reducer.call(null,coll,(function (f1){
var cnt = cljs.core.atom.call(null,n);
return ((function (cnt){
return (function() {
var G__12451 = null;
var G__12451__0 = (function (){
return f1.call(null);
});
var G__12451__2 = (function (ret,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return cljs.core.reduced.call(null,ret);
} else {
return f1.call(null,ret,v);
}
});
var G__12451__3 = (function (ret,k,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return cljs.core.reduced.call(null,ret);
} else {
return f1.call(null,ret,k,v);
}
});
G__12451 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__12451__0.call(this);
case 2:
return G__12451__2.call(this,ret,k);
case 3:
return G__12451__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12451.cljs$core$IFn$_invoke$arity$0 = G__12451__0;
G__12451.cljs$core$IFn$_invoke$arity$2 = G__12451__2;
G__12451.cljs$core$IFn$_invoke$arity$3 = G__12451__3;
return G__12451;
})()
;})(cnt))
}));
});

clojure.core.reducers.take.cljs$lang$maxFixedArity = 2;
/**
 * Elides the first n values from the reduction of coll.
 */
clojure.core.reducers.drop = (function clojure$core$reducers$drop(var_args){
var args12452 = [];
var len__7195__auto___12455 = arguments.length;
var i__7196__auto___12456 = (0);
while(true){
if((i__7196__auto___12456 < len__7195__auto___12455)){
args12452.push((arguments[i__7196__auto___12456]));

var G__12457 = (i__7196__auto___12456 + (1));
i__7196__auto___12456 = G__12457;
continue;
} else {
}
break;
}

var G__12454 = args12452.length;
switch (G__12454) {
case 1:
return clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12452.length)].join('')));

}
});

clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (x__6578__auto__){
return clojure.core.reducers.drop.call(null,n,x__6578__auto__);
});
});

clojure.core.reducers.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return clojure.core.reducers.reducer.call(null,coll,(function (f1){
var cnt = cljs.core.atom.call(null,n);
return ((function (cnt){
return (function() {
var G__12459 = null;
var G__12459__0 = (function (){
return f1.call(null);
});
var G__12459__2 = (function (ret,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return f1.call(null,ret,v);
} else {
return ret;
}
});
var G__12459__3 = (function (ret,k,v){
cljs.core.swap_BANG_.call(null,cnt,cljs.core.dec);

if((cljs.core.deref.call(null,cnt) < (0))){
return f1.call(null,ret,k,v);
} else {
return ret;
}
});
G__12459 = function(ret,k,v){
switch(arguments.length){
case 0:
return G__12459__0.call(this);
case 2:
return G__12459__2.call(this,ret,k);
case 3:
return G__12459__3.call(this,ret,k,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12459.cljs$core$IFn$_invoke$arity$0 = G__12459__0;
G__12459.cljs$core$IFn$_invoke$arity$2 = G__12459__2;
G__12459.cljs$core$IFn$_invoke$arity$3 = G__12459__3;
return G__12459;
})()
;})(cnt))
}));
});

clojure.core.reducers.drop.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {clojure.core.reducers.CollFold}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IReduce}
*/
clojure.core.reducers.Cat = (function (cnt,left,right){
this.cnt = cnt;
this.left = left;
this.right = right;
this.cljs$lang$protocol_mask$partition0$ = 8912898;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
clojure.core.reducers.Cat.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.cnt;
});

clojure.core.reducers.Cat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.concat.call(null,cljs.core.seq.call(null,self__.left),cljs.core.seq.call(null,self__.right));
});

clojure.core.reducers.Cat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f1){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,f1,f1.call(null));
});

clojure.core.reducers.Cat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f1,init){
var self__ = this;
var ___$1 = this;
return cljs.core._reduce.call(null,self__.right,f1,cljs.core._reduce.call(null,self__.left,f1,init));
});

clojure.core.reducers.Cat.prototype.clojure$core$reducers$CollFold$ = true;

clojure.core.reducers.Cat.prototype.clojure$core$reducers$CollFold$coll_fold$arity$4 = (function (this$,n,combinef,reducef){
var self__ = this;
var this$__$1 = this;
return cljs.core._reduce.call(null,this$__$1,reducef);
});

clojure.core.reducers.Cat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null)], null);
});

clojure.core.reducers.Cat.cljs$lang$type = true;

clojure.core.reducers.Cat.cljs$lang$ctorStr = "clojure.core.reducers/Cat";

clojure.core.reducers.Cat.cljs$lang$ctorPrWriter = (function (this__6735__auto__,writer__6736__auto__,opt__6737__auto__){
return cljs.core._write.call(null,writer__6736__auto__,"clojure.core.reducers/Cat");
});

clojure.core.reducers.__GT_Cat = (function clojure$core$reducers$__GT_Cat(cnt,left,right){
return (new clojure.core.reducers.Cat(cnt,left,right));
});

/**
 * A high-performance combining fn that yields the catenation of the
 *   reduced values. The result is reducible, foldable, seqable and
 *   counted, providing the identity collections are reducible, seqable
 *   and counted. The single argument version will build a combining fn
 *   with the supplied identity constructor. Tests for identity
 *   with (zero? (count x)). See also foldcat.
 */
clojure.core.reducers.cat = (function clojure$core$reducers$cat(var_args){
var args12460 = [];
var len__7195__auto___12463 = arguments.length;
var i__7196__auto___12464 = (0);
while(true){
if((i__7196__auto___12464 < len__7195__auto___12463)){
args12460.push((arguments[i__7196__auto___12464]));

var G__12465 = (i__7196__auto___12464 + (1));
i__7196__auto___12464 = G__12465;
continue;
} else {
}
break;
}

var G__12462 = args12460.length;
switch (G__12462) {
case 0:
return clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12460.length)].join('')));

}
});

clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$0 = (function (){
return [];
});

clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$1 = (function (ctor){
return (function() {
var G__12467 = null;
var G__12467__0 = (function (){
return ctor.call(null);
});
var G__12467__2 = (function (left,right){
return clojure.core.reducers.cat.call(null,left,right);
});
G__12467 = function(left,right){
switch(arguments.length){
case 0:
return G__12467__0.call(this);
case 2:
return G__12467__2.call(this,left,right);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12467.cljs$core$IFn$_invoke$arity$0 = G__12467__0;
G__12467.cljs$core$IFn$_invoke$arity$2 = G__12467__2;
return G__12467;
})()
});

clojure.core.reducers.cat.cljs$core$IFn$_invoke$arity$2 = (function (left,right){
if((cljs.core.count.call(null,left) === (0))){
return right;
} else {
if((cljs.core.count.call(null,right) === (0))){
return left;
} else {
return (new clojure.core.reducers.Cat((cljs.core.count.call(null,left) + cljs.core.count.call(null,right)),left,right));

}
}
});

clojure.core.reducers.cat.cljs$lang$maxFixedArity = 2;
/**
 * .adds x to acc and returns acc
 */
clojure.core.reducers.append_BANG_ = (function clojure$core$reducers$append_BANG_(acc,x){
var G__12469 = acc;
G__12469.push(x);

return G__12469;
});
/**
 * Equivalent to (fold cat append! coll)
 */
clojure.core.reducers.foldcat = (function clojure$core$reducers$foldcat(coll){
return clojure.core.reducers.fold.call(null,clojure.core.reducers.cat,clojure.core.reducers.append_BANG_,coll);
});
/**
 * Builds a combining fn out of the supplied operator and identity
 *   constructor. op must be associative and ctor called with no args
 *   must return an identity value for it.
 */
clojure.core.reducers.monoid = (function clojure$core$reducers$monoid(op,ctor){
return (function() {
var clojure$core$reducers$monoid_$_m = null;
var clojure$core$reducers$monoid_$_m__0 = (function (){
return ctor.call(null);
});
var clojure$core$reducers$monoid_$_m__2 = (function (a,b){
return op.call(null,a,b);
});
clojure$core$reducers$monoid_$_m = function(a,b){
switch(arguments.length){
case 0:
return clojure$core$reducers$monoid_$_m__0.call(this);
case 2:
return clojure$core$reducers$monoid_$_m__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clojure$core$reducers$monoid_$_m.cljs$core$IFn$_invoke$arity$0 = clojure$core$reducers$monoid_$_m__0;
clojure$core$reducers$monoid_$_m.cljs$core$IFn$_invoke$arity$2 = clojure$core$reducers$monoid_$_m__2;
return clojure$core$reducers$monoid_$_m;
})()
});
clojure.core.reducers.foldvec = (function clojure$core$reducers$foldvec(v,n,combinef,reducef){
if(cljs.core.empty_QMARK_.call(null,v)){
return combinef.call(null);
} else {
if((cljs.core.count.call(null,v) <= n)){
return clojure.core.reducers.reduce.call(null,reducef,combinef.call(null),v);
} else {
var split = cljs.core.quot.call(null,cljs.core.count.call(null,v),(2));
var v1 = cljs.core.subvec.call(null,v,(0),split);
var v2 = cljs.core.subvec.call(null,v,split,cljs.core.count.call(null,v));
var fc = ((function (split,v1,v2){
return (function (child){
return ((function (split,v1,v2){
return (function (){
return clojure$core$reducers$foldvec.call(null,child,n,combinef,reducef);
});
;})(split,v1,v2))
});})(split,v1,v2))
;
return clojure.core.reducers.fjinvoke.call(null,((function (split,v1,v2,fc){
return (function (){
var f1 = fc.call(null,v1);
var t2 = clojure.core.reducers.fjtask.call(null,fc.call(null,v2));
clojure.core.reducers.fjfork.call(null,t2);

return combinef.call(null,f1.call(null),clojure.core.reducers.fjjoin.call(null,t2));
});})(split,v1,v2,fc))
);

}
}
});
(clojure.core.reducers.CollFold["null"] = true);

(clojure.core.reducers.coll_fold["null"] = (function (coll,n,combinef,reducef){
return combinef.call(null);
}));

(clojure.core.reducers.CollFold["object"] = true);

(clojure.core.reducers.coll_fold["object"] = (function (coll,n,combinef,reducef){
return clojure.core.reducers.reduce.call(null,reducef,combinef.call(null),coll);
}));

cljs.core.PersistentVector.prototype.clojure$core$reducers$CollFold$ = true;

cljs.core.PersistentVector.prototype.clojure$core$reducers$CollFold$coll_fold$arity$4 = (function (v,n,combinef,reducef){
var v__$1 = this;
return clojure.core.reducers.foldvec.call(null,v__$1,n,combinef,reducef);
});
