// Compiled by ClojureScript 0.0-2268
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('goog.net.jsloader');
goog.require('goog.net.jsloader');
figwheel.client.log_style = "color:rgb(0,128,0);";
/**
* @param {...*} var_args
*/
figwheel.client.log = (function() { 
var log__delegate = function (p__51175,args){var map__51177 = p__51175;var map__51177__$1 = ((cljs.core.seq_QMARK_.call(null,map__51177))?cljs.core.apply.call(null,cljs.core.hash_map,map__51177):map__51177);var debug = cljs.core.get.call(null,map__51177__$1,new cljs.core.Keyword(null,"debug","debug",-1608172596));if(cljs.core.truth_(debug))
{return console.log(cljs.core.to_array.call(null,args));
} else
{return null;
}
};
var log = function (p__51175,var_args){
var args = null;if (arguments.length > 1) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return log__delegate.call(this,p__51175,args);};
log.cljs$lang$maxFixedArity = 1;
log.cljs$lang$applyTo = (function (arglist__51178){
var p__51175 = cljs.core.first(arglist__51178);
var args = cljs.core.rest(arglist__51178);
return log__delegate(p__51175,args);
});
log.cljs$core$IFn$_invoke$arity$variadic = log__delegate;
return log;
})()
;
figwheel.client.reload_host = (function reload_host(p__51179){var map__51181 = p__51179;var map__51181__$1 = ((cljs.core.seq_QMARK_.call(null,map__51181))?cljs.core.apply.call(null,cljs.core.hash_map,map__51181):map__51181);var websocket_url = cljs.core.get.call(null,map__51181__$1,new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938));return cljs.core.first.call(null,clojure.string.split.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,websocket_url,/^ws:/,""),/^\/\//,""),/\//));
});
figwheel.client.add_cache_buster = (function add_cache_buster(url){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)+"?rel="+cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).getTime()));
});
figwheel.client.js_reload = (function js_reload(p__51182,callback){var map__51184 = p__51182;var map__51184__$1 = ((cljs.core.seq_QMARK_.call(null,map__51184))?cljs.core.apply.call(null,cljs.core.hash_map,map__51184):map__51184);var msg = map__51184__$1;var dependency_file = cljs.core.get.call(null,map__51184__$1,new cljs.core.Keyword(null,"dependency-file","dependency-file",-1682436382));var namespace = cljs.core.get.call(null,map__51184__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));var request_url = cljs.core.get.call(null,map__51184__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));if(cljs.core.truth_((function (){var or__7931__auto__ = dependency_file;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return goog.isProvided_(namespace);
}
})()))
{return goog.net.jsloader.load(figwheel.client.add_cache_buster.call(null,request_url)).addCallback(((function (map__51184,map__51184__$1,msg,dependency_file,namespace,request_url){
return (function (){return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null));
});})(map__51184,map__51184__$1,msg,dependency_file,namespace,request_url))
);
} else
{return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null));
}
});
figwheel.client.reload_js_file = (function reload_js_file(file_msg){var out = cljs.core.async.chan.call(null);figwheel.client.js_reload.call(null,file_msg,((function (out){
return (function (url){cljs.core.async.put_BANG_.call(null,out,url);
return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
return out;
});
figwheel.client.load_all_js_files = (function load_all_js_files(files){return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.async.filter_LT_.call(null,cljs.core.identity,cljs.core.async.merge.call(null,cljs.core.mapv.call(null,figwheel.client.reload_js_file,files))));
});
figwheel.client.add_request_url = (function add_request_url(p__51185,p__51186){var map__51189 = p__51185;var map__51189__$1 = ((cljs.core.seq_QMARK_.call(null,map__51189))?cljs.core.apply.call(null,cljs.core.hash_map,map__51189):map__51189);var opts = map__51189__$1;var url_rewriter = cljs.core.get.call(null,map__51189__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838));var map__51190 = p__51186;var map__51190__$1 = ((cljs.core.seq_QMARK_.call(null,map__51190))?cljs.core.apply.call(null,cljs.core.hash_map,map__51190):map__51190);var d = map__51190__$1;var file = cljs.core.get.call(null,map__51190__$1,new cljs.core.Keyword(null,"file","file",-1269645878));return cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"request-url","request-url",2100346596),url_rewriter.call(null,("//"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.reload_host.call(null,opts))+cljs.core.str.cljs$core$IFn$_invoke$arity$1(file))));
});
figwheel.client.add_request_urls = (function add_request_urls(opts,files){return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.add_request_url,opts),files);
});
figwheel.client.reload_js_files = (function reload_js_files(p__51191,p__51192){var map__51233 = p__51191;var map__51233__$1 = ((cljs.core.seq_QMARK_.call(null,map__51233))?cljs.core.apply.call(null,cljs.core.hash_map,map__51233):map__51233);var opts = map__51233__$1;var on_jsload = cljs.core.get.call(null,map__51233__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));var before_jsload = cljs.core.get.call(null,map__51233__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));var map__51234 = p__51192;var map__51234__$1 = ((cljs.core.seq_QMARK_.call(null,map__51234))?cljs.core.apply.call(null,cljs.core.hash_map,map__51234):map__51234);var files = cljs.core.get.call(null,map__51234__$1,new cljs.core.Keyword(null,"files","files",-472457450));var c__11142__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto__,map__51233,map__51233__$1,opts,on_jsload,before_jsload,map__51234,map__51234__$1,files){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto__,map__51233,map__51233__$1,opts,on_jsload,before_jsload,map__51234,map__51234__$1,files){
return (function (state_51256){var state_val_51257 = (state_51256[(1)]);if((state_val_51257 === (6)))
{var inst_51239 = (state_51256[(7)]);var inst_51248 = (state_51256[(2)]);var inst_51249 = [inst_51239];var inst_51250 = (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,inst_51249,null));var inst_51251 = cljs.core.apply.call(null,on_jsload,inst_51250);var state_51256__$1 = (function (){var statearr_51258 = state_51256;(statearr_51258[(8)] = inst_51248);
return statearr_51258;
})();var statearr_51259_51273 = state_51256__$1;(statearr_51259_51273[(2)] = inst_51251);
(statearr_51259_51273[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51257 === (5)))
{var inst_51254 = (state_51256[(2)]);var state_51256__$1 = state_51256;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51256__$1,inst_51254);
} else
{if((state_val_51257 === (4)))
{var state_51256__$1 = state_51256;var statearr_51260_51274 = state_51256__$1;(statearr_51260_51274[(2)] = null);
(statearr_51260_51274[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51257 === (3)))
{var inst_51239 = (state_51256[(7)]);var inst_51242 = console.log("%cFigwheel: loaded these files",figwheel.client.log_style);var inst_51243 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_51239);var inst_51244 = cljs.core.prn_str.call(null,inst_51243);var inst_51245 = console.log(inst_51244);var inst_51246 = cljs.core.async.timeout.call(null,(10));var state_51256__$1 = (function (){var statearr_51261 = state_51256;(statearr_51261[(9)] = inst_51242);
(statearr_51261[(10)] = inst_51245);
return statearr_51261;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51256__$1,(6),inst_51246);
} else
{if((state_val_51257 === (2)))
{var inst_51239 = (state_51256[(7)]);var inst_51239__$1 = (state_51256[(2)]);var inst_51240 = cljs.core.not_empty.call(null,inst_51239__$1);var state_51256__$1 = (function (){var statearr_51262 = state_51256;(statearr_51262[(7)] = inst_51239__$1);
return statearr_51262;
})();if(cljs.core.truth_(inst_51240))
{var statearr_51263_51275 = state_51256__$1;(statearr_51263_51275[(1)] = (3));
} else
{var statearr_51264_51276 = state_51256__$1;(statearr_51264_51276[(1)] = (4));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51257 === (1)))
{var inst_51235 = before_jsload.call(null,files);var inst_51236 = figwheel.client.add_request_urls.call(null,opts,files);var inst_51237 = figwheel.client.load_all_js_files.call(null,inst_51236);var state_51256__$1 = (function (){var statearr_51265 = state_51256;(statearr_51265[(11)] = inst_51235);
return statearr_51265;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51256__$1,(2),inst_51237);
} else
{return null;
}
}
}
}
}
}
});})(c__11142__auto__,map__51233,map__51233__$1,opts,on_jsload,before_jsload,map__51234,map__51234__$1,files))
;return ((function (switch__11077__auto__,c__11142__auto__,map__51233,map__51233__$1,opts,on_jsload,before_jsload,map__51234,map__51234__$1,files){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_51269 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_51269[(0)] = state_machine__11078__auto__);
(statearr_51269[(1)] = (1));
return statearr_51269;
});
var state_machine__11078__auto____1 = (function (state_51256){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_51256);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e51270){if((e51270 instanceof Object))
{var ex__11081__auto__ = e51270;var statearr_51271_51277 = state_51256;(statearr_51271_51277[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51256);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e51270;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__51278 = state_51256;
state_51256 = G__51278;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_51256){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_51256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto__,map__51233,map__51233__$1,opts,on_jsload,before_jsload,map__51234,map__51234__$1,files))
})();var state__11144__auto__ = (function (){var statearr_51272 = f__11143__auto__.call(null);(statearr_51272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto__);
return statearr_51272;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto__,map__51233,map__51233__$1,opts,on_jsload,before_jsload,map__51234,map__51234__$1,files))
);
return c__11142__auto__;
});
figwheel.client.current_links = (function current_links(){return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.truncate_url = (function truncate_url(url){return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol)+"//"),""),"http://",""),"https://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.matches_file_QMARK_ = (function matches_file_QMARK_(p__51279,link_href){var map__51281 = p__51279;var map__51281__$1 = ((cljs.core.seq_QMARK_.call(null,map__51281))?cljs.core.apply.call(null,cljs.core.hash_map,map__51281):map__51281);var request_url = cljs.core.get.call(null,map__51281__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));var file = cljs.core.get.call(null,map__51281__$1,new cljs.core.Keyword(null,"file","file",-1269645878));var trunc_href = figwheel.client.truncate_url.call(null,link_href);return (cljs.core._EQ_.call(null,file,trunc_href)) || (cljs.core._EQ_.call(null,figwheel.client.truncate_url.call(null,request_url),trunc_href));
});
figwheel.client.get_correct_link = (function get_correct_link(f_data){return cljs.core.some.call(null,(function (l){if(figwheel.client.matches_file_QMARK_.call(null,f_data,l.href))
{return l;
} else
{return null;
}
}),figwheel.client.current_links.call(null));
});
figwheel.client.clone_link = (function clone_link(link,url){var clone = document.createElement("link");clone.rel = "stylesheet";
clone.media = link.media;
clone.disabled = link.disabled;
clone.href = figwheel.client.add_cache_buster.call(null,url);
return clone;
});
figwheel.client.create_link = (function create_link(url){var link = document.createElement("link");link.rel = "stylesheet";
link.href = figwheel.client.add_cache_buster.call(null,url);
return link;
});
figwheel.client.add_link_to_doc = (function() {
var add_link_to_doc = null;
var add_link_to_doc__1 = (function (new_link){return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});
var add_link_to_doc__2 = (function (orig_link,klone){var parent = orig_link.parentNode;if(cljs.core._EQ_.call(null,orig_link,parent.lastChild))
{parent.appendChild(klone);
} else
{parent.insertBefore(klone,orig_link.nextSibling);
}
var c__11142__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto__,parent){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto__,parent){
return (function (state_51302){var state_val_51303 = (state_51302[(1)]);if((state_val_51303 === (2)))
{var inst_51299 = (state_51302[(2)]);var inst_51300 = parent.removeChild(orig_link);var state_51302__$1 = (function (){var statearr_51304 = state_51302;(statearr_51304[(7)] = inst_51299);
return statearr_51304;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51302__$1,inst_51300);
} else
{if((state_val_51303 === (1)))
{var inst_51297 = cljs.core.async.timeout.call(null,(200));var state_51302__$1 = state_51302;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51302__$1,(2),inst_51297);
} else
{return null;
}
}
});})(c__11142__auto__,parent))
;return ((function (switch__11077__auto__,c__11142__auto__,parent){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_51308 = [null,null,null,null,null,null,null,null];(statearr_51308[(0)] = state_machine__11078__auto__);
(statearr_51308[(1)] = (1));
return statearr_51308;
});
var state_machine__11078__auto____1 = (function (state_51302){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_51302);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e51309){if((e51309 instanceof Object))
{var ex__11081__auto__ = e51309;var statearr_51310_51312 = state_51302;(statearr_51310_51312[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51302);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e51309;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__51313 = state_51302;
state_51302 = G__51313;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_51302){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_51302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto__,parent))
})();var state__11144__auto__ = (function (){var statearr_51311 = f__11143__auto__.call(null);(statearr_51311[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto__);
return statearr_51311;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto__,parent))
);
return c__11142__auto__;
});
add_link_to_doc = function(orig_link,klone){
switch(arguments.length){
case 1:
return add_link_to_doc__1.call(this,orig_link);
case 2:
return add_link_to_doc__2.call(this,orig_link,klone);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = add_link_to_doc__1;
add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = add_link_to_doc__2;
return add_link_to_doc;
})()
;
figwheel.client.reload_css_file = (function reload_css_file(p__51314){var map__51316 = p__51314;var map__51316__$1 = ((cljs.core.seq_QMARK_.call(null,map__51316))?cljs.core.apply.call(null,cljs.core.hash_map,map__51316):map__51316);var f_data = map__51316__$1;var request_url = cljs.core.get.call(null,map__51316__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));var file = cljs.core.get.call(null,map__51316__$1,new cljs.core.Keyword(null,"file","file",-1269645878));var temp__4124__auto__ = figwheel.client.get_correct_link.call(null,f_data);if(cljs.core.truth_(temp__4124__auto__))
{var link = temp__4124__auto__;return figwheel.client.add_link_to_doc.call(null,link,figwheel.client.clone_link.call(null,link,request_url));
} else
{return figwheel.client.add_link_to_doc.call(null,figwheel.client.create_link.call(null,request_url));
}
});
figwheel.client.reload_css_files = (function reload_css_files(p__51317,files_msg){var map__51339 = p__51317;var map__51339__$1 = ((cljs.core.seq_QMARK_.call(null,map__51339))?cljs.core.apply.call(null,cljs.core.hash_map,map__51339):map__51339);var opts = map__51339__$1;var on_cssload = cljs.core.get.call(null,map__51339__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));var seq__51340_51360 = cljs.core.seq.call(null,figwheel.client.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));var chunk__51341_51361 = null;var count__51342_51362 = (0);var i__51343_51363 = (0);while(true){
if((i__51343_51363 < count__51342_51362))
{var f_51364 = cljs.core._nth.call(null,chunk__51341_51361,i__51343_51363);figwheel.client.reload_css_file.call(null,f_51364);
{
var G__51365 = seq__51340_51360;
var G__51366 = chunk__51341_51361;
var G__51367 = count__51342_51362;
var G__51368 = (i__51343_51363 + (1));
seq__51340_51360 = G__51365;
chunk__51341_51361 = G__51366;
count__51342_51362 = G__51367;
i__51343_51363 = G__51368;
continue;
}
} else
{var temp__4126__auto___51369 = cljs.core.seq.call(null,seq__51340_51360);if(temp__4126__auto___51369)
{var seq__51340_51370__$1 = temp__4126__auto___51369;if(cljs.core.chunked_seq_QMARK_.call(null,seq__51340_51370__$1))
{var c__8687__auto___51371 = cljs.core.chunk_first.call(null,seq__51340_51370__$1);{
var G__51372 = cljs.core.chunk_rest.call(null,seq__51340_51370__$1);
var G__51373 = c__8687__auto___51371;
var G__51374 = cljs.core.count.call(null,c__8687__auto___51371);
var G__51375 = (0);
seq__51340_51360 = G__51372;
chunk__51341_51361 = G__51373;
count__51342_51362 = G__51374;
i__51343_51363 = G__51375;
continue;
}
} else
{var f_51376 = cljs.core.first.call(null,seq__51340_51370__$1);figwheel.client.reload_css_file.call(null,f_51376);
{
var G__51377 = cljs.core.next.call(null,seq__51340_51370__$1);
var G__51378 = null;
var G__51379 = (0);
var G__51380 = (0);
seq__51340_51360 = G__51377;
chunk__51341_51361 = G__51378;
count__51342_51362 = G__51379;
i__51343_51363 = G__51380;
continue;
}
}
} else
{}
}
break;
}
var c__11142__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto__,map__51339,map__51339__$1,opts,on_cssload){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto__,map__51339,map__51339__$1,opts,on_cssload){
return (function (state_51350){var state_val_51351 = (state_51350[(1)]);if((state_val_51351 === (2)))
{var inst_51346 = (state_51350[(2)]);var inst_51347 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg);var inst_51348 = on_cssload.call(null,inst_51347);var state_51350__$1 = (function (){var statearr_51352 = state_51350;(statearr_51352[(7)] = inst_51346);
return statearr_51352;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51350__$1,inst_51348);
} else
{if((state_val_51351 === (1)))
{var inst_51344 = cljs.core.async.timeout.call(null,(100));var state_51350__$1 = state_51350;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51350__$1,(2),inst_51344);
} else
{return null;
}
}
});})(c__11142__auto__,map__51339,map__51339__$1,opts,on_cssload))
;return ((function (switch__11077__auto__,c__11142__auto__,map__51339,map__51339__$1,opts,on_cssload){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_51356 = [null,null,null,null,null,null,null,null];(statearr_51356[(0)] = state_machine__11078__auto__);
(statearr_51356[(1)] = (1));
return statearr_51356;
});
var state_machine__11078__auto____1 = (function (state_51350){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_51350);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e51357){if((e51357 instanceof Object))
{var ex__11081__auto__ = e51357;var statearr_51358_51381 = state_51350;(statearr_51358_51381[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51350);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e51357;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__51382 = state_51350;
state_51350 = G__51382;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_51350){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_51350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto__,map__51339,map__51339__$1,opts,on_cssload))
})();var state__11144__auto__ = (function (){var statearr_51359 = f__11143__auto__.call(null);(statearr_51359[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto__);
return statearr_51359;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto__,map__51339,map__51339__$1,opts,on_cssload))
);
return c__11142__auto__;
});
figwheel.client.compile_failed = (function compile_failed(fail_msg,compile_fail_callback){return compile_fail_callback.call(null,cljs.core.dissoc.call(null,fail_msg,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)));
});
figwheel.client.figwheel_closure_import_script = (function figwheel_closure_import_script(src){if(cljs.core.truth_(goog.inHtmlDocument_()))
{goog.net.jsloader.load(figwheel.client.add_cache_buster.call(null,src));
return true;
} else
{return false;
}
});
figwheel.client.patch_goog_base = (function patch_goog_base(){goog.provide = goog.exportPath_;
return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.figwheel_closure_import_script;
});
figwheel.client.watch_and_reload_STAR_ = (function watch_and_reload_STAR_(p__51383){var map__51388 = p__51383;var map__51388__$1 = ((cljs.core.seq_QMARK_.call(null,map__51388))?cljs.core.apply.call(null,cljs.core.hash_map,map__51388):map__51388);var opts = map__51388__$1;var on_compile_fail = cljs.core.get.call(null,map__51388__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));var jsload_callback = cljs.core.get.call(null,map__51388__$1,new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));var websocket_url = cljs.core.get.call(null,map__51388__$1,new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938));var retry_count = cljs.core.get.call(null,map__51388__$1,new cljs.core.Keyword(null,"retry-count","retry-count",1936122875));console.log("%cFigwheel: trying to open cljs reload socket",figwheel.client.log_style);
var socket = (new WebSocket(websocket_url));socket.onmessage = ((function (socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (msg_str){var msg = cljs.reader.read_string.call(null,msg_str.data);var pred__51389 = cljs.core._EQ_;var expr__51390 = new cljs.core.Keyword(null,"msg-name","msg-name",-353709863).cljs$core$IFn$_invoke$arity$1(msg);if(cljs.core.truth_(pred__51389.call(null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),expr__51390)))
{return figwheel.client.reload_js_files.call(null,opts,msg);
} else
{if(cljs.core.truth_(pred__51389.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),expr__51390)))
{return figwheel.client.reload_css_files.call(null,opts,msg);
} else
{if(cljs.core.truth_(pred__51389.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__51390)))
{return figwheel.client.compile_failed.call(null,msg,on_compile_fail);
} else
{return null;
}
}
}
});})(socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
socket.onopen = ((function (socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){figwheel.client.patch_goog_base.call(null);
return console.log("%cFigwheel: socket connection established",figwheel.client.log_style);
});})(socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
socket.onclose = ((function (socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){figwheel.client.log.call(null,opts,"Figwheel: socket closed or failed to open");
if((retry_count > (0)))
{return window.setTimeout(((function (socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (){return watch_and_reload_STAR_.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),(retry_count - (1))));
});})(socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
,(2000));
} else
{return null;
}
});})(socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
return socket.onerror = ((function (socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){return figwheel.client.log.call(null,opts,"Figwheel: socket error ");
});})(socket,map__51388,map__51388__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
});
figwheel.client.default_on_jsload = (function default_on_jsload(url){return document.querySelector("body").dispatchEvent((new CustomEvent("figwheel.js-reload",(function (){var obj51395 = {"detail":url};return obj51395;
})())));
});
figwheel.client.get_essential_messages = (function get_essential_messages(ed){if(cljs.core.truth_(ed))
{return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else
{return null;
}
});
figwheel.client.error_msg_format = (function error_msg_format(p__51396){var map__51398 = p__51396;var map__51398__$1 = ((cljs.core.seq_QMARK_.call(null,map__51398))?cljs.core.apply.call(null,cljs.core.hash_map,map__51398):map__51398);var class$ = cljs.core.get.call(null,map__51398__$1,new cljs.core.Keyword(null,"class","class",-2030961996));var message = cljs.core.get.call(null,map__51398__$1,new cljs.core.Keyword(null,"message","message",-406056002));return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)+" : "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(message));
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.default_on_compile_fail = (function default_on_compile_fail(p__51399){var map__51405 = p__51399;var map__51405__$1 = ((cljs.core.seq_QMARK_.call(null,map__51405))?cljs.core.apply.call(null,cljs.core.hash_map,map__51405):map__51405);var ed = map__51405__$1;var exception_data = cljs.core.get.call(null,map__51405__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));var formatted_exception = cljs.core.get.call(null,map__51405__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));console.log("%cFigwheel: Compile Exception",figwheel.client.log_style);
var seq__51406_51410 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));var chunk__51407_51411 = null;var count__51408_51412 = (0);var i__51409_51413 = (0);while(true){
if((i__51409_51413 < count__51408_51412))
{var msg_51414 = cljs.core._nth.call(null,chunk__51407_51411,i__51409_51413);console.log(msg_51414);
{
var G__51415 = seq__51406_51410;
var G__51416 = chunk__51407_51411;
var G__51417 = count__51408_51412;
var G__51418 = (i__51409_51413 + (1));
seq__51406_51410 = G__51415;
chunk__51407_51411 = G__51416;
count__51408_51412 = G__51417;
i__51409_51413 = G__51418;
continue;
}
} else
{var temp__4126__auto___51419 = cljs.core.seq.call(null,seq__51406_51410);if(temp__4126__auto___51419)
{var seq__51406_51420__$1 = temp__4126__auto___51419;if(cljs.core.chunked_seq_QMARK_.call(null,seq__51406_51420__$1))
{var c__8687__auto___51421 = cljs.core.chunk_first.call(null,seq__51406_51420__$1);{
var G__51422 = cljs.core.chunk_rest.call(null,seq__51406_51420__$1);
var G__51423 = c__8687__auto___51421;
var G__51424 = cljs.core.count.call(null,c__8687__auto___51421);
var G__51425 = (0);
seq__51406_51410 = G__51422;
chunk__51407_51411 = G__51423;
count__51408_51412 = G__51424;
i__51409_51413 = G__51425;
continue;
}
} else
{var msg_51426 = cljs.core.first.call(null,seq__51406_51420__$1);console.log(msg_51426);
{
var G__51427 = cljs.core.next.call(null,seq__51406_51420__$1);
var G__51428 = null;
var G__51429 = (0);
var G__51430 = (0);
seq__51406_51410 = G__51427;
chunk__51407_51411 = G__51428;
count__51408_51412 = G__51429;
i__51409_51413 = G__51430;
continue;
}
}
} else
{}
}
break;
}
return ed;
});
figwheel.client.default_before_load = (function default_before_load(files){console.log("%cFigwheel: loading files",figwheel.client.log_style);
return files;
});
figwheel.client.default_on_cssload = (function default_on_cssload(files){console.log("%cFigwheel: loaded CSS files",figwheel.client.log_style);
console.log(cljs.core.prn_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));
return files;
});
figwheel.client.watch_and_reload_with_opts = (function watch_and_reload_with_opts(opts){if(cljs.core.truth_(figwheel.client.hasOwnProperty("watch_and_reload_singleton")))
{return null;
} else
{figwheel.client.watch_and_reload_singleton = figwheel.client.watch_and_reload_STAR_.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),(100),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369),figwheel.client.default_on_jsload,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),(function (){var or__7931__auto__ = new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(opts);if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return figwheel.client.default_on_jsload;
}
})(),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318),figwheel.client.default_on_cssload,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),figwheel.client.default_before_load,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),figwheel.client.default_on_compile_fail,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838),cljs.core.identity,new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),("ws://"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.host)+"/figwheel-ws")], null),opts));
}
});
/**
* @param {...*} var_args
*/
figwheel.client.watch_and_reload = (function() { 
var watch_and_reload__delegate = function (p__51431){var map__51433 = p__51431;var map__51433__$1 = ((cljs.core.seq_QMARK_.call(null,map__51433))?cljs.core.apply.call(null,cljs.core.hash_map,map__51433):map__51433);var opts = map__51433__$1;return figwheel.client.watch_and_reload_with_opts.call(null,opts);
};
var watch_and_reload = function (var_args){
var p__51431 = null;if (arguments.length > 0) {
  p__51431 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return watch_and_reload__delegate.call(this,p__51431);};
watch_and_reload.cljs$lang$maxFixedArity = 0;
watch_and_reload.cljs$lang$applyTo = (function (arglist__51434){
var p__51431 = cljs.core.seq(arglist__51434);
return watch_and_reload__delegate(p__51431);
});
watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = watch_and_reload__delegate;
return watch_and_reload;
})()
;

//# sourceMappingURL=client.js.map