// Compiled by ClojureScript 0.0-2268
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('clojure.string');
goog.require('sablono.util');
goog.require('goog.dom');
goog.require('goog.dom');
goog.require('sablono.interpreter');
goog.require('sablono.interpreter');
goog.require('sablono.util');
goog.require('clojure.walk');
goog.require('clojure.string');
/**
* Add an optional attribute argument to a function that returns a element vector.
*/
sablono.core.wrap_attrs = (function wrap_attrs(func){return (function() { 
var G__50997__delegate = function (args){if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args)))
{var vec__50996 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));var tag = cljs.core.nth.call(null,vec__50996,(0),null);var body = cljs.core.nthnext.call(null,vec__50996,(1));if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body)))
{return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else
{return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else
{return cljs.core.apply.call(null,func,args);
}
};
var G__50997 = function (var_args){
var args = null;if (arguments.length > 0) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return G__50997__delegate.call(this,args);};
G__50997.cljs$lang$maxFixedArity = 0;
G__50997.cljs$lang$applyTo = (function (arglist__50998){
var args = cljs.core.seq(arglist__50998);
return G__50997__delegate(args);
});
G__50997.cljs$core$IFn$_invoke$arity$variadic = G__50997__delegate;
return G__50997;
})()
;
});
sablono.core.update_arglists = (function update_arglists(arglists){var iter__8656__auto__ = (function iter__51003(s__51004){return (new cljs.core.LazySeq(null,(function (){var s__51004__$1 = s__51004;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__51004__$1);if(temp__4126__auto__)
{var s__51004__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__51004__$2))
{var c__8654__auto__ = cljs.core.chunk_first.call(null,s__51004__$2);var size__8655__auto__ = cljs.core.count.call(null,c__8654__auto__);var b__51006 = cljs.core.chunk_buffer.call(null,size__8655__auto__);if((function (){var i__51005 = (0);while(true){
if((i__51005 < size__8655__auto__))
{var args = cljs.core._nth.call(null,c__8654__auto__,i__51005);cljs.core.chunk_append.call(null,b__51006,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));
{
var G__51007 = (i__51005 + (1));
i__51005 = G__51007;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51006),iter__51003.call(null,cljs.core.chunk_rest.call(null,s__51004__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51006),null);
}
} else
{var args = cljs.core.first.call(null,s__51004__$2);return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),iter__51003.call(null,cljs.core.rest.call(null,s__51004__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8656__auto__.call(null,arglists);
});
/**
* Render the React `component` as an HTML string.
*/
sablono.core.render = (function render(component){return React.renderComponentToString(component);
});
/**
* Include a list of external stylesheet files.
* @param {...*} var_args
*/
sablono.core.include_css = (function() { 
var include_css__delegate = function (styles){var iter__8656__auto__ = (function iter__51012(s__51013){return (new cljs.core.LazySeq(null,(function (){var s__51013__$1 = s__51013;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__51013__$1);if(temp__4126__auto__)
{var s__51013__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__51013__$2))
{var c__8654__auto__ = cljs.core.chunk_first.call(null,s__51013__$2);var size__8655__auto__ = cljs.core.count.call(null,c__8654__auto__);var b__51015 = cljs.core.chunk_buffer.call(null,size__8655__auto__);if((function (){var i__51014 = (0);while(true){
if((i__51014 < size__8655__auto__))
{var style = cljs.core._nth.call(null,c__8654__auto__,i__51014);cljs.core.chunk_append.call(null,b__51015,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));
{
var G__51016 = (i__51014 + (1));
i__51014 = G__51016;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51015),iter__51012.call(null,cljs.core.chunk_rest.call(null,s__51013__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51015),null);
}
} else
{var style = cljs.core.first.call(null,s__51013__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),iter__51012.call(null,cljs.core.rest.call(null,s__51013__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8656__auto__.call(null,styles);
};
var include_css = function (var_args){
var styles = null;if (arguments.length > 0) {
  styles = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return include_css__delegate.call(this,styles);};
include_css.cljs$lang$maxFixedArity = 0;
include_css.cljs$lang$applyTo = (function (arglist__51017){
var styles = cljs.core.seq(arglist__51017);
return include_css__delegate(styles);
});
include_css.cljs$core$IFn$_invoke$arity$variadic = include_css__delegate;
return include_css;
})()
;
/**
* Include the JavaScript library at `src`.
*/
sablono.core.include_js = (function include_js(src){return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
* Include Facebook's React JavaScript library.
*/
sablono.core.include_react = (function include_react(){return sablono.core.include_js.call(null,"http://fb.me/react-0.9.0.js");
});
/**
* Wraps some content in a HTML hyperlink with the supplied URL.
* @param {...*} var_args
*/
sablono.core.link_to51018 = (function() { 
var link_to51018__delegate = function (url,content){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
};
var link_to51018 = function (url,var_args){
var content = null;if (arguments.length > 1) {
  content = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return link_to51018__delegate.call(this,url,content);};
link_to51018.cljs$lang$maxFixedArity = 1;
link_to51018.cljs$lang$applyTo = (function (arglist__51019){
var url = cljs.core.first(arglist__51019);
var content = cljs.core.rest(arglist__51019);
return link_to51018__delegate(url,content);
});
link_to51018.cljs$core$IFn$_invoke$arity$variadic = link_to51018__delegate;
return link_to51018;
})()
;
sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to51018);
/**
* Wraps some content in a HTML hyperlink with the supplied e-mail
* address. If no content provided use the e-mail address as content.
* @param {...*} var_args
*/
sablono.core.mail_to51020 = (function() { 
var mail_to51020__delegate = function (e_mail,p__51021){var vec__51023 = p__51021;var content = cljs.core.nth.call(null,vec__51023,(0),null);return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),("mailto:"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail))], null),(function (){var or__7931__auto__ = content;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return e_mail;
}
})()], null);
};
var mail_to51020 = function (e_mail,var_args){
var p__51021 = null;if (arguments.length > 1) {
  p__51021 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return mail_to51020__delegate.call(this,e_mail,p__51021);};
mail_to51020.cljs$lang$maxFixedArity = 1;
mail_to51020.cljs$lang$applyTo = (function (arglist__51024){
var e_mail = cljs.core.first(arglist__51024);
var p__51021 = cljs.core.rest(arglist__51024);
return mail_to51020__delegate(e_mail,p__51021);
});
mail_to51020.cljs$core$IFn$_invoke$arity$variadic = mail_to51020__delegate;
return mail_to51020;
})()
;
sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to51020);
/**
* Wrap a collection in an unordered list.
*/
sablono.core.unordered_list51025 = (function unordered_list51025(coll){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__8656__auto__ = (function iter__51030(s__51031){return (new cljs.core.LazySeq(null,(function (){var s__51031__$1 = s__51031;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__51031__$1);if(temp__4126__auto__)
{var s__51031__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__51031__$2))
{var c__8654__auto__ = cljs.core.chunk_first.call(null,s__51031__$2);var size__8655__auto__ = cljs.core.count.call(null,c__8654__auto__);var b__51033 = cljs.core.chunk_buffer.call(null,size__8655__auto__);if((function (){var i__51032 = (0);while(true){
if((i__51032 < size__8655__auto__))
{var x = cljs.core._nth.call(null,c__8654__auto__,i__51032);cljs.core.chunk_append.call(null,b__51033,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));
{
var G__51034 = (i__51032 + (1));
i__51032 = G__51034;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51033),iter__51030.call(null,cljs.core.chunk_rest.call(null,s__51031__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51033),null);
}
} else
{var x = cljs.core.first.call(null,s__51031__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),iter__51030.call(null,cljs.core.rest.call(null,s__51031__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8656__auto__.call(null,coll);
})()], null);
});
sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list51025);
/**
* Wrap a collection in an ordered list.
*/
sablono.core.ordered_list51035 = (function ordered_list51035(coll){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__8656__auto__ = (function iter__51040(s__51041){return (new cljs.core.LazySeq(null,(function (){var s__51041__$1 = s__51041;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__51041__$1);if(temp__4126__auto__)
{var s__51041__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__51041__$2))
{var c__8654__auto__ = cljs.core.chunk_first.call(null,s__51041__$2);var size__8655__auto__ = cljs.core.count.call(null,c__8654__auto__);var b__51043 = cljs.core.chunk_buffer.call(null,size__8655__auto__);if((function (){var i__51042 = (0);while(true){
if((i__51042 < size__8655__auto__))
{var x = cljs.core._nth.call(null,c__8654__auto__,i__51042);cljs.core.chunk_append.call(null,b__51043,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));
{
var G__51044 = (i__51042 + (1));
i__51042 = G__51044;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51043),iter__51040.call(null,cljs.core.chunk_rest.call(null,s__51041__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51043),null);
}
} else
{var x = cljs.core.first.call(null,s__51041__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),iter__51040.call(null,cljs.core.rest.call(null,s__51041__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8656__auto__.call(null,coll);
})()], null);
});
sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list51035);
/**
* Create an image element.
*/
sablono.core.image51045 = (function() {
var image51045 = null;
var image51045__1 = (function (src){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});
var image51045__2 = (function (src,alt){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});
image51045 = function(src,alt){
switch(arguments.length){
case 1:
return image51045__1.call(this,src);
case 2:
return image51045__2.call(this,src,alt);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
image51045.cljs$core$IFn$_invoke$arity$1 = image51045__1;
image51045.cljs$core$IFn$_invoke$arity$2 = image51045__2;
return image51045;
})()
;
sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image51045);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
* Create a field name from the supplied argument the current field group.
*/
sablono.core.make_name = (function make_name(name){return cljs.core.reduce.call(null,(function (p1__51046_SHARP_,p2__51047_SHARP_){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51046_SHARP_)+"["+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__51047_SHARP_)+"]");
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Create a field id from the supplied argument and current field group.
*/
sablono.core.make_id = (function make_id(name){return cljs.core.reduce.call(null,(function (p1__51048_SHARP_,p2__51049_SHARP_){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51048_SHARP_)+"-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__51049_SHARP_));
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Creates a new <input> element.
*/
sablono.core.input_field_STAR_ = (function input_field_STAR_(type,name,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
* Creates a color input field.
*/
sablono.core.color_field51050 = (function() {
var color_field51050 = null;
var color_field51050__1 = (function (name__9902__auto__){return color_field51050.call(null,name__9902__auto__,null);
});
var color_field51050__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))),name__9902__auto__,value__9903__auto__);
});
color_field51050 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return color_field51050__1.call(this,name__9902__auto__);
case 2:
return color_field51050__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
color_field51050.cljs$core$IFn$_invoke$arity$1 = color_field51050__1;
color_field51050.cljs$core$IFn$_invoke$arity$2 = color_field51050__2;
return color_field51050;
})()
;
sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field51050);
/**
* Creates a date input field.
*/
sablono.core.date_field51051 = (function() {
var date_field51051 = null;
var date_field51051__1 = (function (name__9902__auto__){return date_field51051.call(null,name__9902__auto__,null);
});
var date_field51051__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))),name__9902__auto__,value__9903__auto__);
});
date_field51051 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return date_field51051__1.call(this,name__9902__auto__);
case 2:
return date_field51051__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
date_field51051.cljs$core$IFn$_invoke$arity$1 = date_field51051__1;
date_field51051.cljs$core$IFn$_invoke$arity$2 = date_field51051__2;
return date_field51051;
})()
;
sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field51051);
/**
* Creates a datetime input field.
*/
sablono.core.datetime_field51052 = (function() {
var datetime_field51052 = null;
var datetime_field51052__1 = (function (name__9902__auto__){return datetime_field51052.call(null,name__9902__auto__,null);
});
var datetime_field51052__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))),name__9902__auto__,value__9903__auto__);
});
datetime_field51052 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return datetime_field51052__1.call(this,name__9902__auto__);
case 2:
return datetime_field51052__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
datetime_field51052.cljs$core$IFn$_invoke$arity$1 = datetime_field51052__1;
datetime_field51052.cljs$core$IFn$_invoke$arity$2 = datetime_field51052__2;
return datetime_field51052;
})()
;
sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field51052);
/**
* Creates a datetime-local input field.
*/
sablono.core.datetime_local_field51053 = (function() {
var datetime_local_field51053 = null;
var datetime_local_field51053__1 = (function (name__9902__auto__){return datetime_local_field51053.call(null,name__9902__auto__,null);
});
var datetime_local_field51053__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))),name__9902__auto__,value__9903__auto__);
});
datetime_local_field51053 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return datetime_local_field51053__1.call(this,name__9902__auto__);
case 2:
return datetime_local_field51053__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
datetime_local_field51053.cljs$core$IFn$_invoke$arity$1 = datetime_local_field51053__1;
datetime_local_field51053.cljs$core$IFn$_invoke$arity$2 = datetime_local_field51053__2;
return datetime_local_field51053;
})()
;
sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field51053);
/**
* Creates a email input field.
*/
sablono.core.email_field51054 = (function() {
var email_field51054 = null;
var email_field51054__1 = (function (name__9902__auto__){return email_field51054.call(null,name__9902__auto__,null);
});
var email_field51054__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))),name__9902__auto__,value__9903__auto__);
});
email_field51054 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return email_field51054__1.call(this,name__9902__auto__);
case 2:
return email_field51054__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
email_field51054.cljs$core$IFn$_invoke$arity$1 = email_field51054__1;
email_field51054.cljs$core$IFn$_invoke$arity$2 = email_field51054__2;
return email_field51054;
})()
;
sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field51054);
/**
* Creates a file input field.
*/
sablono.core.file_field51055 = (function() {
var file_field51055 = null;
var file_field51055__1 = (function (name__9902__auto__){return file_field51055.call(null,name__9902__auto__,null);
});
var file_field51055__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))),name__9902__auto__,value__9903__auto__);
});
file_field51055 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return file_field51055__1.call(this,name__9902__auto__);
case 2:
return file_field51055__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
file_field51055.cljs$core$IFn$_invoke$arity$1 = file_field51055__1;
file_field51055.cljs$core$IFn$_invoke$arity$2 = file_field51055__2;
return file_field51055;
})()
;
sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field51055);
/**
* Creates a hidden input field.
*/
sablono.core.hidden_field51056 = (function() {
var hidden_field51056 = null;
var hidden_field51056__1 = (function (name__9902__auto__){return hidden_field51056.call(null,name__9902__auto__,null);
});
var hidden_field51056__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))),name__9902__auto__,value__9903__auto__);
});
hidden_field51056 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return hidden_field51056__1.call(this,name__9902__auto__);
case 2:
return hidden_field51056__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hidden_field51056.cljs$core$IFn$_invoke$arity$1 = hidden_field51056__1;
hidden_field51056.cljs$core$IFn$_invoke$arity$2 = hidden_field51056__2;
return hidden_field51056;
})()
;
sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field51056);
/**
* Creates a month input field.
*/
sablono.core.month_field51057 = (function() {
var month_field51057 = null;
var month_field51057__1 = (function (name__9902__auto__){return month_field51057.call(null,name__9902__auto__,null);
});
var month_field51057__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))),name__9902__auto__,value__9903__auto__);
});
month_field51057 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return month_field51057__1.call(this,name__9902__auto__);
case 2:
return month_field51057__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
month_field51057.cljs$core$IFn$_invoke$arity$1 = month_field51057__1;
month_field51057.cljs$core$IFn$_invoke$arity$2 = month_field51057__2;
return month_field51057;
})()
;
sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field51057);
/**
* Creates a number input field.
*/
sablono.core.number_field51058 = (function() {
var number_field51058 = null;
var number_field51058__1 = (function (name__9902__auto__){return number_field51058.call(null,name__9902__auto__,null);
});
var number_field51058__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))),name__9902__auto__,value__9903__auto__);
});
number_field51058 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return number_field51058__1.call(this,name__9902__auto__);
case 2:
return number_field51058__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
number_field51058.cljs$core$IFn$_invoke$arity$1 = number_field51058__1;
number_field51058.cljs$core$IFn$_invoke$arity$2 = number_field51058__2;
return number_field51058;
})()
;
sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field51058);
/**
* Creates a password input field.
*/
sablono.core.password_field51059 = (function() {
var password_field51059 = null;
var password_field51059__1 = (function (name__9902__auto__){return password_field51059.call(null,name__9902__auto__,null);
});
var password_field51059__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))),name__9902__auto__,value__9903__auto__);
});
password_field51059 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return password_field51059__1.call(this,name__9902__auto__);
case 2:
return password_field51059__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
password_field51059.cljs$core$IFn$_invoke$arity$1 = password_field51059__1;
password_field51059.cljs$core$IFn$_invoke$arity$2 = password_field51059__2;
return password_field51059;
})()
;
sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field51059);
/**
* Creates a range input field.
*/
sablono.core.range_field51060 = (function() {
var range_field51060 = null;
var range_field51060__1 = (function (name__9902__auto__){return range_field51060.call(null,name__9902__auto__,null);
});
var range_field51060__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))),name__9902__auto__,value__9903__auto__);
});
range_field51060 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return range_field51060__1.call(this,name__9902__auto__);
case 2:
return range_field51060__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
range_field51060.cljs$core$IFn$_invoke$arity$1 = range_field51060__1;
range_field51060.cljs$core$IFn$_invoke$arity$2 = range_field51060__2;
return range_field51060;
})()
;
sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field51060);
/**
* Creates a search input field.
*/
sablono.core.search_field51061 = (function() {
var search_field51061 = null;
var search_field51061__1 = (function (name__9902__auto__){return search_field51061.call(null,name__9902__auto__,null);
});
var search_field51061__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))),name__9902__auto__,value__9903__auto__);
});
search_field51061 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return search_field51061__1.call(this,name__9902__auto__);
case 2:
return search_field51061__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
search_field51061.cljs$core$IFn$_invoke$arity$1 = search_field51061__1;
search_field51061.cljs$core$IFn$_invoke$arity$2 = search_field51061__2;
return search_field51061;
})()
;
sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field51061);
/**
* Creates a tel input field.
*/
sablono.core.tel_field51062 = (function() {
var tel_field51062 = null;
var tel_field51062__1 = (function (name__9902__auto__){return tel_field51062.call(null,name__9902__auto__,null);
});
var tel_field51062__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))),name__9902__auto__,value__9903__auto__);
});
tel_field51062 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return tel_field51062__1.call(this,name__9902__auto__);
case 2:
return tel_field51062__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tel_field51062.cljs$core$IFn$_invoke$arity$1 = tel_field51062__1;
tel_field51062.cljs$core$IFn$_invoke$arity$2 = tel_field51062__2;
return tel_field51062;
})()
;
sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field51062);
/**
* Creates a text input field.
*/
sablono.core.text_field51063 = (function() {
var text_field51063 = null;
var text_field51063__1 = (function (name__9902__auto__){return text_field51063.call(null,name__9902__auto__,null);
});
var text_field51063__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))),name__9902__auto__,value__9903__auto__);
});
text_field51063 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return text_field51063__1.call(this,name__9902__auto__);
case 2:
return text_field51063__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_field51063.cljs$core$IFn$_invoke$arity$1 = text_field51063__1;
text_field51063.cljs$core$IFn$_invoke$arity$2 = text_field51063__2;
return text_field51063;
})()
;
sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field51063);
/**
* Creates a time input field.
*/
sablono.core.time_field51064 = (function() {
var time_field51064 = null;
var time_field51064__1 = (function (name__9902__auto__){return time_field51064.call(null,name__9902__auto__,null);
});
var time_field51064__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))),name__9902__auto__,value__9903__auto__);
});
time_field51064 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return time_field51064__1.call(this,name__9902__auto__);
case 2:
return time_field51064__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
time_field51064.cljs$core$IFn$_invoke$arity$1 = time_field51064__1;
time_field51064.cljs$core$IFn$_invoke$arity$2 = time_field51064__2;
return time_field51064;
})()
;
sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field51064);
/**
* Creates a url input field.
*/
sablono.core.url_field51065 = (function() {
var url_field51065 = null;
var url_field51065__1 = (function (name__9902__auto__){return url_field51065.call(null,name__9902__auto__,null);
});
var url_field51065__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))),name__9902__auto__,value__9903__auto__);
});
url_field51065 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return url_field51065__1.call(this,name__9902__auto__);
case 2:
return url_field51065__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
url_field51065.cljs$core$IFn$_invoke$arity$1 = url_field51065__1;
url_field51065.cljs$core$IFn$_invoke$arity$2 = url_field51065__2;
return url_field51065;
})()
;
sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field51065);
/**
* Creates a week input field.
*/
sablono.core.week_field51066 = (function() {
var week_field51066 = null;
var week_field51066__1 = (function (name__9902__auto__){return week_field51066.call(null,name__9902__auto__,null);
});
var week_field51066__2 = (function (name__9902__auto__,value__9903__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))),name__9902__auto__,value__9903__auto__);
});
week_field51066 = function(name__9902__auto__,value__9903__auto__){
switch(arguments.length){
case 1:
return week_field51066__1.call(this,name__9902__auto__);
case 2:
return week_field51066__2.call(this,name__9902__auto__,value__9903__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
week_field51066.cljs$core$IFn$_invoke$arity$1 = week_field51066__1;
week_field51066.cljs$core$IFn$_invoke$arity$2 = week_field51066__2;
return week_field51066;
})()
;
sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field51066);
sablono.core.file_upload = sablono.core.file_field;
/**
* Creates a check box.
*/
sablono.core.check_box51067 = (function() {
var check_box51067 = null;
var check_box51067__1 = (function (name){return check_box51067.call(null,name,null);
});
var check_box51067__2 = (function (name,checked_QMARK_){return check_box51067.call(null,name,checked_QMARK_,"true");
});
var check_box51067__3 = (function (name,checked_QMARK_,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});
check_box51067 = function(name,checked_QMARK_,value){
switch(arguments.length){
case 1:
return check_box51067__1.call(this,name);
case 2:
return check_box51067__2.call(this,name,checked_QMARK_);
case 3:
return check_box51067__3.call(this,name,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
check_box51067.cljs$core$IFn$_invoke$arity$1 = check_box51067__1;
check_box51067.cljs$core$IFn$_invoke$arity$2 = check_box51067__2;
check_box51067.cljs$core$IFn$_invoke$arity$3 = check_box51067__3;
return check_box51067;
})()
;
sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box51067);
/**
* Creates a radio button.
*/
sablono.core.radio_button51068 = (function() {
var radio_button51068 = null;
var radio_button51068__1 = (function (group){return radio_button51068.call(null,group,null);
});
var radio_button51068__2 = (function (group,checked_QMARK_){return radio_button51068.call(null,group,checked_QMARK_,"true");
});
var radio_button51068__3 = (function (group,checked_QMARK_,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group))+"-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value)))),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});
radio_button51068 = function(group,checked_QMARK_,value){
switch(arguments.length){
case 1:
return radio_button51068__1.call(this,group);
case 2:
return radio_button51068__2.call(this,group,checked_QMARK_);
case 3:
return radio_button51068__3.call(this,group,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
radio_button51068.cljs$core$IFn$_invoke$arity$1 = radio_button51068__1;
radio_button51068.cljs$core$IFn$_invoke$arity$2 = radio_button51068__2;
radio_button51068.cljs$core$IFn$_invoke$arity$3 = radio_button51068__3;
return radio_button51068;
})()
;
sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button51068);
/**
* Creates a seq of option tags from a collection.
*/
sablono.core.select_options51069 = (function() {
var select_options51069 = null;
var select_options51069__1 = (function (coll){return select_options51069.call(null,coll,null);
});
var select_options51069__2 = (function (coll,selected){var iter__8656__auto__ = (function iter__51078(s__51079){return (new cljs.core.LazySeq(null,(function (){var s__51079__$1 = s__51079;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__51079__$1);if(temp__4126__auto__)
{var s__51079__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__51079__$2))
{var c__8654__auto__ = cljs.core.chunk_first.call(null,s__51079__$2);var size__8655__auto__ = cljs.core.count.call(null,c__8654__auto__);var b__51081 = cljs.core.chunk_buffer.call(null,size__8655__auto__);if((function (){var i__51080 = (0);while(true){
if((i__51080 < size__8655__auto__))
{var x = cljs.core._nth.call(null,c__8654__auto__,i__51080);cljs.core.chunk_append.call(null,b__51081,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__51084 = x;var text = cljs.core.nth.call(null,vec__51084,(0),null);var val = cljs.core.nth.call(null,vec__51084,(1),null);var disabled_QMARK_ = cljs.core.nth.call(null,vec__51084,(2),null);var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);if(cljs.core.sequential_QMARK_.call(null,val))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),select_options51069.call(null,val,selected)], null);
} else
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));
{
var G__51086 = (i__51080 + (1));
i__51080 = G__51086;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51081),iter__51078.call(null,cljs.core.chunk_rest.call(null,s__51079__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__51081),null);
}
} else
{var x = cljs.core.first.call(null,s__51079__$2);return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__51085 = x;var text = cljs.core.nth.call(null,vec__51085,(0),null);var val = cljs.core.nth.call(null,vec__51085,(1),null);var disabled_QMARK_ = cljs.core.nth.call(null,vec__51085,(2),null);var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);if(cljs.core.sequential_QMARK_.call(null,val))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),select_options51069.call(null,val,selected)], null);
} else
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),iter__51078.call(null,cljs.core.rest.call(null,s__51079__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8656__auto__.call(null,coll);
});
select_options51069 = function(coll,selected){
switch(arguments.length){
case 1:
return select_options51069__1.call(this,coll);
case 2:
return select_options51069__2.call(this,coll,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
select_options51069.cljs$core$IFn$_invoke$arity$1 = select_options51069__1;
select_options51069.cljs$core$IFn$_invoke$arity$2 = select_options51069__2;
return select_options51069;
})()
;
sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options51069);
/**
* Creates a drop-down box using the <select> tag.
*/
sablono.core.drop_down51087 = (function() {
var drop_down51087 = null;
var drop_down51087__2 = (function (name,options){return drop_down51087.call(null,name,options,null);
});
var drop_down51087__3 = (function (name,options,selected){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});
drop_down51087 = function(name,options,selected){
switch(arguments.length){
case 2:
return drop_down51087__2.call(this,name,options);
case 3:
return drop_down51087__3.call(this,name,options,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_down51087.cljs$core$IFn$_invoke$arity$2 = drop_down51087__2;
drop_down51087.cljs$core$IFn$_invoke$arity$3 = drop_down51087__3;
return drop_down51087;
})()
;
sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down51087);
/**
* Creates a text area element.
*/
sablono.core.text_area51088 = (function() {
var text_area51088 = null;
var text_area51088__1 = (function (name){return text_area51088.call(null,name,null);
});
var text_area51088__2 = (function (name,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
text_area51088 = function(name,value){
switch(arguments.length){
case 1:
return text_area51088__1.call(this,name);
case 2:
return text_area51088__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_area51088.cljs$core$IFn$_invoke$arity$1 = text_area51088__1;
text_area51088.cljs$core$IFn$_invoke$arity$2 = text_area51088__2;
return text_area51088;
})()
;
sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area51088);
/**
* Creates a label for an input field with the supplied name.
*/
sablono.core.label51089 = (function label51089(name,text){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});
sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label51089);
/**
* Creates a submit button.
*/
sablono.core.submit_button51090 = (function submit_button51090(text){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});
sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button51090);
/**
* Creates a form reset button.
*/
sablono.core.reset_button51091 = (function reset_button51091(text){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});
sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button51091);
/**
* Create a form that points to a particular method and route.
* e.g. (form-to [:put "/post"]
* ...)
* @param {...*} var_args
*/
sablono.core.form_to51092 = (function() { 
var form_to51092__delegate = function (p__51093,body){var vec__51095 = p__51093;var method = cljs.core.nth.call(null,vec__51095,(0),null);var action = cljs.core.nth.call(null,vec__51095,(1),null);var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));var action_uri = sablono.util.to_uri.call(null,action);return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
};
var form_to51092 = function (p__51093,var_args){
var body = null;if (arguments.length > 1) {
  body = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return form_to51092__delegate.call(this,p__51093,body);};
form_to51092.cljs$lang$maxFixedArity = 1;
form_to51092.cljs$lang$applyTo = (function (arglist__51096){
var p__51093 = cljs.core.first(arglist__51096);
var body = cljs.core.rest(arglist__51096);
return form_to51092__delegate(p__51093,body);
});
form_to51092.cljs$core$IFn$_invoke$arity$variadic = form_to51092__delegate;
return form_to51092;
})()
;
sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to51092);

//# sourceMappingURL=core.js.map