// Compiled by ClojureScript 0.0-2268
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){if(typeof cljs.core.async.t51549 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51549 = (function (f,fn_handler,meta51550){
this.f = f;
this.fn_handler = fn_handler;
this.meta51550 = meta51550;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51549.cljs$lang$type = true;
cljs.core.async.t51549.cljs$lang$ctorStr = "cljs.core.async/t51549";
cljs.core.async.t51549.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51549");
});
cljs.core.async.t51549.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t51549.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return true;
});
cljs.core.async.t51549.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.f;
});
cljs.core.async.t51549.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51551){var self__ = this;
var _51551__$1 = this;return self__.meta51550;
});
cljs.core.async.t51549.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51551,meta51550__$1){var self__ = this;
var _51551__$1 = this;return (new cljs.core.async.t51549(self__.f,self__.fn_handler,meta51550__$1));
});
cljs.core.async.__GT_t51549 = (function __GT_t51549(f__$1,fn_handler__$1,meta51550){return (new cljs.core.async.t51549(f__$1,fn_handler__$1,meta51550));
});
}
return (new cljs.core.async.t51549(f,fn_handler,null));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){var G__51553 = buff;if(G__51553)
{var bit__8581__auto__ = null;if(cljs.core.truth_((function (){var or__7931__auto__ = bit__8581__auto__;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return G__51553.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})()))
{return true;
} else
{if((!G__51553.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__51553);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__51553);
}
});
/**
* Creates a channel with an optional buffer. If buf-or-n is a number,
* will create and use a fixed buffer of that size.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1));
});
chan = function(buf_or_n){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){if(null)
{return null;
} else
{throw (new Error(("Assert failed: <! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(ret))
{var val_51554 = cljs.core.deref.call(null,ret);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,val_51554);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (val_51554,ret){
return (function (){return fn1.call(null,val_51554);
});})(val_51554,ret))
);
}
} else
{}
return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){if(null)
{return null;
} else
{throw (new Error(("Assert failed: >! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);if(cljs.core.truth_(temp__4124__auto__))
{var ret = temp__4124__auto__;return cljs.core.deref.call(null,ret);
} else
{return true;
}
});
var put_BANG___3 = (function (port,val,fn1){return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));if(cljs.core.truth_(temp__4124__auto__))
{var retb = temp__4124__auto__;var ret = cljs.core.deref.call(null,retb);if(cljs.core.truth_(on_caller_QMARK_))
{fn1.call(null,ret);
} else
{cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}
return ret;
} else
{return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){var a = (new Array(n));var n__8787__auto___51555 = n;var x_51556 = (0);while(true){
if((x_51556 < n__8787__auto___51555))
{(a[x_51556] = (0));
{
var G__51557 = (x_51556 + (1));
x_51556 = G__51557;
continue;
}
} else
{}
break;
}
var i = (1);while(true){
if(cljs.core._EQ_.call(null,i,n))
{return a;
} else
{var j = cljs.core.rand_int.call(null,i);(a[i] = (a[j]));
(a[j] = i);
{
var G__51558 = (i + (1));
i = G__51558;
continue;
}
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){var flag = cljs.core.atom.call(null,true);if(typeof cljs.core.async.t51562 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51562 = (function (flag,alt_flag,meta51563){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta51563 = meta51563;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51562.cljs$lang$type = true;
cljs.core.async.t51562.cljs$lang$ctorStr = "cljs.core.async/t51562";
cljs.core.async.t51562.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51562");
});})(flag))
;
cljs.core.async.t51562.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t51562.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.deref.call(null,self__.flag);
});})(flag))
;
cljs.core.async.t51562.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.flag,null);
return true;
});})(flag))
;
cljs.core.async.t51562.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_51564){var self__ = this;
var _51564__$1 = this;return self__.meta51563;
});})(flag))
;
cljs.core.async.t51562.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_51564,meta51563__$1){var self__ = this;
var _51564__$1 = this;return (new cljs.core.async.t51562(self__.flag,self__.alt_flag,meta51563__$1));
});})(flag))
;
cljs.core.async.__GT_t51562 = ((function (flag){
return (function __GT_t51562(flag__$1,alt_flag__$1,meta51563){return (new cljs.core.async.t51562(flag__$1,alt_flag__$1,meta51563));
});})(flag))
;
}
return (new cljs.core.async.t51562(flag,alt_flag,null));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){if(typeof cljs.core.async.t51568 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51568 = (function (cb,flag,alt_handler,meta51569){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta51569 = meta51569;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51568.cljs$lang$type = true;
cljs.core.async.t51568.cljs$lang$ctorStr = "cljs.core.async/t51568";
cljs.core.async.t51568.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51568");
});
cljs.core.async.t51568.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t51568.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});
cljs.core.async.t51568.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){var self__ = this;
var ___$1 = this;cljs.core.async.impl.protocols.commit.call(null,self__.flag);
return self__.cb;
});
cljs.core.async.t51568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51570){var self__ = this;
var _51570__$1 = this;return self__.meta51569;
});
cljs.core.async.t51568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51570,meta51569__$1){var self__ = this;
var _51570__$1 = this;return (new cljs.core.async.t51568(self__.cb,self__.flag,self__.alt_handler,meta51569__$1));
});
cljs.core.async.__GT_t51568 = (function __GT_t51568(cb__$1,flag__$1,alt_handler__$1,meta51569){return (new cljs.core.async.t51568(cb__$1,flag__$1,alt_handler__$1,meta51569));
});
}
return (new cljs.core.async.t51568(cb,flag,alt_handler,null));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){var flag = cljs.core.async.alt_flag.call(null);var n = cljs.core.count.call(null,ports);var idxs = cljs.core.async.random_array.call(null,n);var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);var ret = (function (){var i = (0);while(true){
if((i < n))
{var idx = (cljs.core.truth_(priority)?i:(idxs[i]));var port = cljs.core.nth.call(null,ports,idx);var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__51571_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__51571_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__51572_SHARP_){return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__51572_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));if(cljs.core.truth_(vbox))
{return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__7931__auto__ = wport;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return port;
}
})()], null));
} else
{{
var G__51573 = (i + (1));
i = G__51573;
continue;
}
}
} else
{return null;
}
break;
}
})();var or__7931__auto__ = ret;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328)))
{var temp__4126__auto__ = (function (){var and__7919__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);if(cljs.core.truth_(and__7919__auto__))
{return cljs.core.async.impl.protocols.commit.call(null,flag);
} else
{return and__7919__auto__;
}
})();if(cljs.core.truth_(temp__4126__auto__))
{var got = temp__4126__auto__;return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else
{return null;
}
} else
{return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__51574){var map__51576 = p__51574;var map__51576__$1 = ((cljs.core.seq_QMARK_.call(null,map__51576))?cljs.core.apply.call(null,cljs.core.hash_map,map__51576):map__51576);var opts = map__51576__$1;if(null)
{return null;
} else
{throw (new Error(("Assert failed: alts! used not in (go ...) block\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,null)))));
}
};
var alts_BANG_ = function (ports,var_args){
var p__51574 = null;if (arguments.length > 1) {
  p__51574 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return alts_BANG___delegate.call(this,ports,p__51574);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__51577){
var ports = cljs.core.first(arglist__51577);
var p__51574 = cljs.core.rest(arglist__51577);
return alts_BANG___delegate(ports,p__51574);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes a function and a source channel, and returns a channel which
* contains the values produced by applying f to each value taken from
* the source channel
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){if(typeof cljs.core.async.t51585 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51585 = (function (ch,f,map_LT_,meta51586){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta51586 = meta51586;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51585.cljs$lang$type = true;
cljs.core.async.t51585.cljs$lang$ctorStr = "cljs.core.async/t51585";
cljs.core.async.t51585.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51585");
});
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){if(typeof cljs.core.async.t51588 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51588 = (function (fn1,_,meta51586,ch,f,map_LT_,meta51589){
this.fn1 = fn1;
this._ = _;
this.meta51586 = meta51586;
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta51589 = meta51589;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51588.cljs$lang$type = true;
cljs.core.async.t51588.cljs$lang$ctorStr = "cljs.core.async/t51588";
cljs.core.async.t51588.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51588");
});})(___$1))
;
cljs.core.async.t51588.prototype.cljs$core$async$impl$protocols$Handler$ = true;
cljs.core.async.t51588.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t51588.prototype.cljs$core$async$impl$protocols$Handler$lock_id$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;return cljs.core.async.impl.protocols.lock_id.call(null,self__.fn1);
});})(___$1))
;
cljs.core.async.t51588.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$3){var self__ = this;
var ___$4 = this;var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);return ((function (f1,___$4,___$1){
return (function (p1__51578_SHARP_){return f1.call(null,(((p1__51578_SHARP_ == null))?null:self__.f.call(null,p1__51578_SHARP_)));
});
;})(f1,___$4,___$1))
});})(___$1))
;
cljs.core.async.t51588.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_51590){var self__ = this;
var _51590__$1 = this;return self__.meta51589;
});})(___$1))
;
cljs.core.async.t51588.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_51590,meta51589__$1){var self__ = this;
var _51590__$1 = this;return (new cljs.core.async.t51588(self__.fn1,self__._,self__.meta51586,self__.ch,self__.f,self__.map_LT_,meta51589__$1));
});})(___$1))
;
cljs.core.async.__GT_t51588 = ((function (___$1){
return (function __GT_t51588(fn1__$1,___$2,meta51586__$1,ch__$2,f__$2,map_LT___$2,meta51589){return (new cljs.core.async.t51588(fn1__$1,___$2,meta51586__$1,ch__$2,f__$2,map_LT___$2,meta51589));
});})(___$1))
;
}
return (new cljs.core.async.t51588(fn1,___$1,self__.meta51586,self__.ch,self__.f,self__.map_LT_,null));
})());if(cljs.core.truth_((function (){var and__7919__auto__ = ret;if(cljs.core.truth_(and__7919__auto__))
{return !((cljs.core.deref.call(null,ret) == null));
} else
{return and__7919__auto__;
}
})()))
{return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else
{return ret;
}
});
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t51585.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t51585.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51587){var self__ = this;
var _51587__$1 = this;return self__.meta51586;
});
cljs.core.async.t51585.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51587,meta51586__$1){var self__ = this;
var _51587__$1 = this;return (new cljs.core.async.t51585(self__.ch,self__.f,self__.map_LT_,meta51586__$1));
});
cljs.core.async.__GT_t51585 = (function __GT_t51585(ch__$1,f__$1,map_LT___$1,meta51586){return (new cljs.core.async.t51585(ch__$1,f__$1,map_LT___$1,meta51586));
});
}
return (new cljs.core.async.t51585(ch,f,map_LT_,null));
});
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value before supplying it to the target channel.
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){if(typeof cljs.core.async.t51594 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51594 = (function (ch,f,map_GT_,meta51595){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta51595 = meta51595;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51594.cljs$lang$type = true;
cljs.core.async.t51594.cljs$lang$ctorStr = "cljs.core.async/t51594";
cljs.core.async.t51594.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51594");
});
cljs.core.async.t51594.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t51594.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});
cljs.core.async.t51594.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t51594.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t51594.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t51594.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t51594.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51596){var self__ = this;
var _51596__$1 = this;return self__.meta51595;
});
cljs.core.async.t51594.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51596,meta51595__$1){var self__ = this;
var _51596__$1 = this;return (new cljs.core.async.t51594(self__.ch,self__.f,self__.map_GT_,meta51595__$1));
});
cljs.core.async.__GT_t51594 = (function __GT_t51594(ch__$1,f__$1,map_GT___$1,meta51595){return (new cljs.core.async.t51594(ch__$1,f__$1,map_GT___$1,meta51595));
});
}
return (new cljs.core.async.t51594(ch,f,map_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns true to the
* target channel.
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){if(typeof cljs.core.async.t51600 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t51600 = (function (ch,p,filter_GT_,meta51601){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta51601 = meta51601;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t51600.cljs$lang$type = true;
cljs.core.async.t51600.cljs$lang$ctorStr = "cljs.core.async/t51600";
cljs.core.async.t51600.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t51600");
});
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$WritePort$ = true;
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.p.call(null,val)))
{return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else
{return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$Channel$ = true;
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});
cljs.core.async.t51600.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});
cljs.core.async.t51600.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_51602){var self__ = this;
var _51602__$1 = this;return self__.meta51601;
});
cljs.core.async.t51600.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_51602,meta51601__$1){var self__ = this;
var _51602__$1 = this;return (new cljs.core.async.t51600(self__.ch,self__.p,self__.filter_GT_,meta51601__$1));
});
cljs.core.async.__GT_t51600 = (function __GT_t51600(ch__$1,p__$1,filter_GT___$1,meta51601){return (new cljs.core.async.t51600(ch__$1,p__$1,filter_GT___$1,meta51601));
});
}
return (new cljs.core.async.t51600(ch,p,filter_GT_,null));
});
/**
* Takes a predicate and a target channel, and returns a channel which
* supplies only the values for which the predicate returns false to the
* target channel.
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns true. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11142__auto___51685 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___51685,out){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___51685,out){
return (function (state_51664){var state_val_51665 = (state_51664[(1)]);if((state_val_51665 === (7)))
{var inst_51660 = (state_51664[(2)]);var state_51664__$1 = state_51664;var statearr_51666_51686 = state_51664__$1;(statearr_51666_51686[(2)] = inst_51660);
(statearr_51666_51686[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (1)))
{var state_51664__$1 = state_51664;var statearr_51667_51687 = state_51664__$1;(statearr_51667_51687[(2)] = null);
(statearr_51667_51687[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (4)))
{var inst_51646 = (state_51664[(7)]);var inst_51646__$1 = (state_51664[(2)]);var inst_51647 = (inst_51646__$1 == null);var state_51664__$1 = (function (){var statearr_51668 = state_51664;(statearr_51668[(7)] = inst_51646__$1);
return statearr_51668;
})();if(cljs.core.truth_(inst_51647))
{var statearr_51669_51688 = state_51664__$1;(statearr_51669_51688[(1)] = (5));
} else
{var statearr_51670_51689 = state_51664__$1;(statearr_51670_51689[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (6)))
{var inst_51646 = (state_51664[(7)]);var inst_51651 = p.call(null,inst_51646);var state_51664__$1 = state_51664;if(cljs.core.truth_(inst_51651))
{var statearr_51671_51690 = state_51664__$1;(statearr_51671_51690[(1)] = (8));
} else
{var statearr_51672_51691 = state_51664__$1;(statearr_51672_51691[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (3)))
{var inst_51662 = (state_51664[(2)]);var state_51664__$1 = state_51664;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51664__$1,inst_51662);
} else
{if((state_val_51665 === (2)))
{var state_51664__$1 = state_51664;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51664__$1,(4),ch);
} else
{if((state_val_51665 === (11)))
{var inst_51654 = (state_51664[(2)]);var state_51664__$1 = state_51664;var statearr_51673_51692 = state_51664__$1;(statearr_51673_51692[(2)] = inst_51654);
(statearr_51673_51692[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (9)))
{var state_51664__$1 = state_51664;var statearr_51674_51693 = state_51664__$1;(statearr_51674_51693[(2)] = null);
(statearr_51674_51693[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (5)))
{var inst_51649 = cljs.core.async.close_BANG_.call(null,out);var state_51664__$1 = state_51664;var statearr_51675_51694 = state_51664__$1;(statearr_51675_51694[(2)] = inst_51649);
(statearr_51675_51694[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (10)))
{var inst_51657 = (state_51664[(2)]);var state_51664__$1 = (function (){var statearr_51676 = state_51664;(statearr_51676[(8)] = inst_51657);
return statearr_51676;
})();var statearr_51677_51695 = state_51664__$1;(statearr_51677_51695[(2)] = null);
(statearr_51677_51695[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51665 === (8)))
{var inst_51646 = (state_51664[(7)]);var state_51664__$1 = state_51664;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51664__$1,(11),out,inst_51646);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___51685,out))
;return ((function (switch__11077__auto__,c__11142__auto___51685,out){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_51681 = [null,null,null,null,null,null,null,null,null];(statearr_51681[(0)] = state_machine__11078__auto__);
(statearr_51681[(1)] = (1));
return statearr_51681;
});
var state_machine__11078__auto____1 = (function (state_51664){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_51664);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e51682){if((e51682 instanceof Object))
{var ex__11081__auto__ = e51682;var statearr_51683_51696 = state_51664;(statearr_51683_51696[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51664);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e51682;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__51697 = state_51664;
state_51664 = G__51697;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_51664){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_51664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___51685,out))
})();var state__11144__auto__ = (function (){var statearr_51684 = f__11143__auto__.call(null);(statearr_51684[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___51685);
return statearr_51684;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___51685,out))
);
return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Takes a predicate and a source channel, and returns a channel which
* contains only the values taken from the source channel for which the
* predicate returns false. The returned channel will be unbuffered by
* default, or a buf-or-n can be supplied. The channel will close
* when the source channel closes.
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){var c__11142__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto__){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto__){
return (function (state_51863){var state_val_51864 = (state_51863[(1)]);if((state_val_51864 === (7)))
{var inst_51859 = (state_51863[(2)]);var state_51863__$1 = state_51863;var statearr_51865_51906 = state_51863__$1;(statearr_51865_51906[(2)] = inst_51859);
(statearr_51865_51906[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (20)))
{var inst_51829 = (state_51863[(7)]);var inst_51840 = (state_51863[(2)]);var inst_51841 = cljs.core.next.call(null,inst_51829);var inst_51815 = inst_51841;var inst_51816 = null;var inst_51817 = (0);var inst_51818 = (0);var state_51863__$1 = (function (){var statearr_51866 = state_51863;(statearr_51866[(8)] = inst_51818);
(statearr_51866[(9)] = inst_51816);
(statearr_51866[(10)] = inst_51840);
(statearr_51866[(11)] = inst_51815);
(statearr_51866[(12)] = inst_51817);
return statearr_51866;
})();var statearr_51867_51907 = state_51863__$1;(statearr_51867_51907[(2)] = null);
(statearr_51867_51907[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (1)))
{var state_51863__$1 = state_51863;var statearr_51868_51908 = state_51863__$1;(statearr_51868_51908[(2)] = null);
(statearr_51868_51908[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (4)))
{var inst_51804 = (state_51863[(13)]);var inst_51804__$1 = (state_51863[(2)]);var inst_51805 = (inst_51804__$1 == null);var state_51863__$1 = (function (){var statearr_51869 = state_51863;(statearr_51869[(13)] = inst_51804__$1);
return statearr_51869;
})();if(cljs.core.truth_(inst_51805))
{var statearr_51870_51909 = state_51863__$1;(statearr_51870_51909[(1)] = (5));
} else
{var statearr_51871_51910 = state_51863__$1;(statearr_51871_51910[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (15)))
{var state_51863__$1 = state_51863;var statearr_51875_51911 = state_51863__$1;(statearr_51875_51911[(2)] = null);
(statearr_51875_51911[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (21)))
{var state_51863__$1 = state_51863;var statearr_51876_51912 = state_51863__$1;(statearr_51876_51912[(2)] = null);
(statearr_51876_51912[(1)] = (23));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (13)))
{var inst_51818 = (state_51863[(8)]);var inst_51816 = (state_51863[(9)]);var inst_51815 = (state_51863[(11)]);var inst_51817 = (state_51863[(12)]);var inst_51825 = (state_51863[(2)]);var inst_51826 = (inst_51818 + (1));var tmp51872 = inst_51816;var tmp51873 = inst_51815;var tmp51874 = inst_51817;var inst_51815__$1 = tmp51873;var inst_51816__$1 = tmp51872;var inst_51817__$1 = tmp51874;var inst_51818__$1 = inst_51826;var state_51863__$1 = (function (){var statearr_51877 = state_51863;(statearr_51877[(8)] = inst_51818__$1);
(statearr_51877[(9)] = inst_51816__$1);
(statearr_51877[(11)] = inst_51815__$1);
(statearr_51877[(14)] = inst_51825);
(statearr_51877[(12)] = inst_51817__$1);
return statearr_51877;
})();var statearr_51878_51913 = state_51863__$1;(statearr_51878_51913[(2)] = null);
(statearr_51878_51913[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (22)))
{var state_51863__$1 = state_51863;var statearr_51879_51914 = state_51863__$1;(statearr_51879_51914[(2)] = null);
(statearr_51879_51914[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (6)))
{var inst_51804 = (state_51863[(13)]);var inst_51813 = f.call(null,inst_51804);var inst_51814 = cljs.core.seq.call(null,inst_51813);var inst_51815 = inst_51814;var inst_51816 = null;var inst_51817 = (0);var inst_51818 = (0);var state_51863__$1 = (function (){var statearr_51880 = state_51863;(statearr_51880[(8)] = inst_51818);
(statearr_51880[(9)] = inst_51816);
(statearr_51880[(11)] = inst_51815);
(statearr_51880[(12)] = inst_51817);
return statearr_51880;
})();var statearr_51881_51915 = state_51863__$1;(statearr_51881_51915[(2)] = null);
(statearr_51881_51915[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (17)))
{var inst_51829 = (state_51863[(7)]);var inst_51833 = cljs.core.chunk_first.call(null,inst_51829);var inst_51834 = cljs.core.chunk_rest.call(null,inst_51829);var inst_51835 = cljs.core.count.call(null,inst_51833);var inst_51815 = inst_51834;var inst_51816 = inst_51833;var inst_51817 = inst_51835;var inst_51818 = (0);var state_51863__$1 = (function (){var statearr_51882 = state_51863;(statearr_51882[(8)] = inst_51818);
(statearr_51882[(9)] = inst_51816);
(statearr_51882[(11)] = inst_51815);
(statearr_51882[(12)] = inst_51817);
return statearr_51882;
})();var statearr_51883_51916 = state_51863__$1;(statearr_51883_51916[(2)] = null);
(statearr_51883_51916[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (3)))
{var inst_51861 = (state_51863[(2)]);var state_51863__$1 = state_51863;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_51863__$1,inst_51861);
} else
{if((state_val_51864 === (12)))
{var inst_51849 = (state_51863[(2)]);var state_51863__$1 = state_51863;var statearr_51884_51917 = state_51863__$1;(statearr_51884_51917[(2)] = inst_51849);
(statearr_51884_51917[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (2)))
{var state_51863__$1 = state_51863;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_51863__$1,(4),in$);
} else
{if((state_val_51864 === (23)))
{var inst_51857 = (state_51863[(2)]);var state_51863__$1 = state_51863;var statearr_51885_51918 = state_51863__$1;(statearr_51885_51918[(2)] = inst_51857);
(statearr_51885_51918[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (19)))
{var inst_51844 = (state_51863[(2)]);var state_51863__$1 = state_51863;var statearr_51886_51919 = state_51863__$1;(statearr_51886_51919[(2)] = inst_51844);
(statearr_51886_51919[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (11)))
{var inst_51815 = (state_51863[(11)]);var inst_51829 = (state_51863[(7)]);var inst_51829__$1 = cljs.core.seq.call(null,inst_51815);var state_51863__$1 = (function (){var statearr_51887 = state_51863;(statearr_51887[(7)] = inst_51829__$1);
return statearr_51887;
})();if(inst_51829__$1)
{var statearr_51888_51920 = state_51863__$1;(statearr_51888_51920[(1)] = (14));
} else
{var statearr_51889_51921 = state_51863__$1;(statearr_51889_51921[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (9)))
{var inst_51851 = (state_51863[(2)]);var inst_51852 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);var state_51863__$1 = (function (){var statearr_51890 = state_51863;(statearr_51890[(15)] = inst_51851);
return statearr_51890;
})();if(cljs.core.truth_(inst_51852))
{var statearr_51891_51922 = state_51863__$1;(statearr_51891_51922[(1)] = (21));
} else
{var statearr_51892_51923 = state_51863__$1;(statearr_51892_51923[(1)] = (22));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (5)))
{var inst_51807 = cljs.core.async.close_BANG_.call(null,out);var state_51863__$1 = state_51863;var statearr_51893_51924 = state_51863__$1;(statearr_51893_51924[(2)] = inst_51807);
(statearr_51893_51924[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (14)))
{var inst_51829 = (state_51863[(7)]);var inst_51831 = cljs.core.chunked_seq_QMARK_.call(null,inst_51829);var state_51863__$1 = state_51863;if(inst_51831)
{var statearr_51894_51925 = state_51863__$1;(statearr_51894_51925[(1)] = (17));
} else
{var statearr_51895_51926 = state_51863__$1;(statearr_51895_51926[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (16)))
{var inst_51847 = (state_51863[(2)]);var state_51863__$1 = state_51863;var statearr_51896_51927 = state_51863__$1;(statearr_51896_51927[(2)] = inst_51847);
(statearr_51896_51927[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_51864 === (10)))
{var inst_51818 = (state_51863[(8)]);var inst_51816 = (state_51863[(9)]);var inst_51823 = cljs.core._nth.call(null,inst_51816,inst_51818);var state_51863__$1 = state_51863;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51863__$1,(13),out,inst_51823);
} else
{if((state_val_51864 === (18)))
{var inst_51829 = (state_51863[(7)]);var inst_51838 = cljs.core.first.call(null,inst_51829);var state_51863__$1 = state_51863;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_51863__$1,(20),out,inst_51838);
} else
{if((state_val_51864 === (8)))
{var inst_51818 = (state_51863[(8)]);var inst_51817 = (state_51863[(12)]);var inst_51820 = (inst_51818 < inst_51817);var inst_51821 = inst_51820;var state_51863__$1 = state_51863;if(cljs.core.truth_(inst_51821))
{var statearr_51897_51928 = state_51863__$1;(statearr_51897_51928[(1)] = (10));
} else
{var statearr_51898_51929 = state_51863__$1;(statearr_51898_51929[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto__))
;return ((function (switch__11077__auto__,c__11142__auto__){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_51902 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_51902[(0)] = state_machine__11078__auto__);
(statearr_51902[(1)] = (1));
return statearr_51902;
});
var state_machine__11078__auto____1 = (function (state_51863){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_51863);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e51903){if((e51903 instanceof Object))
{var ex__11081__auto__ = e51903;var statearr_51904_51930 = state_51863;(statearr_51904_51930[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_51863);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e51903;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__51931 = state_51863;
state_51863 = G__51931;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_51863){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_51863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto__))
})();var state__11144__auto__ = (function (){var statearr_51905 = f__11143__auto__.call(null);(statearr_51905[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto__);
return statearr_51905;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto__))
);
return c__11142__auto__;
});
/**
* Takes a function and a source channel, and returns a channel which
* contains the values in each collection produced by applying f to
* each value taken from the source channel. f must return a
* collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The channel will close when the source channel
* closes.
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Takes a function and a target channel, and returns a channel which
* applies f to each value put, then supplies each element of the result
* to the target channel. f must return a collection.
* 
* The returned channel will be unbuffered by default, or a buf-or-n
* can be supplied. The target channel will be closed when the source
* channel closes.
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){var in$ = cljs.core.async.chan.call(null,buf_or_n);cljs.core.async.mapcat_STAR_.call(null,f,in$,out);
return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){var c__11142__auto___52026 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___52026){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___52026){
return (function (state_52002){var state_val_52003 = (state_52002[(1)]);if((state_val_52003 === (7)))
{var inst_51998 = (state_52002[(2)]);var state_52002__$1 = state_52002;var statearr_52004_52027 = state_52002__$1;(statearr_52004_52027[(2)] = inst_51998);
(statearr_52004_52027[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (1)))
{var state_52002__$1 = state_52002;var statearr_52005_52028 = state_52002__$1;(statearr_52005_52028[(2)] = null);
(statearr_52005_52028[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (4)))
{var inst_51981 = (state_52002[(7)]);var inst_51981__$1 = (state_52002[(2)]);var inst_51982 = (inst_51981__$1 == null);var state_52002__$1 = (function (){var statearr_52006 = state_52002;(statearr_52006[(7)] = inst_51981__$1);
return statearr_52006;
})();if(cljs.core.truth_(inst_51982))
{var statearr_52007_52029 = state_52002__$1;(statearr_52007_52029[(1)] = (5));
} else
{var statearr_52008_52030 = state_52002__$1;(statearr_52008_52030[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (13)))
{var state_52002__$1 = state_52002;var statearr_52009_52031 = state_52002__$1;(statearr_52009_52031[(2)] = null);
(statearr_52009_52031[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (6)))
{var inst_51981 = (state_52002[(7)]);var state_52002__$1 = state_52002;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52002__$1,(11),to,inst_51981);
} else
{if((state_val_52003 === (3)))
{var inst_52000 = (state_52002[(2)]);var state_52002__$1 = state_52002;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52002__$1,inst_52000);
} else
{if((state_val_52003 === (12)))
{var state_52002__$1 = state_52002;var statearr_52010_52032 = state_52002__$1;(statearr_52010_52032[(2)] = null);
(statearr_52010_52032[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (2)))
{var state_52002__$1 = state_52002;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52002__$1,(4),from);
} else
{if((state_val_52003 === (11)))
{var inst_51991 = (state_52002[(2)]);var state_52002__$1 = state_52002;if(cljs.core.truth_(inst_51991))
{var statearr_52011_52033 = state_52002__$1;(statearr_52011_52033[(1)] = (12));
} else
{var statearr_52012_52034 = state_52002__$1;(statearr_52012_52034[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (9)))
{var state_52002__$1 = state_52002;var statearr_52013_52035 = state_52002__$1;(statearr_52013_52035[(2)] = null);
(statearr_52013_52035[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (5)))
{var state_52002__$1 = state_52002;if(cljs.core.truth_(close_QMARK_))
{var statearr_52014_52036 = state_52002__$1;(statearr_52014_52036[(1)] = (8));
} else
{var statearr_52015_52037 = state_52002__$1;(statearr_52015_52037[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (14)))
{var inst_51996 = (state_52002[(2)]);var state_52002__$1 = state_52002;var statearr_52016_52038 = state_52002__$1;(statearr_52016_52038[(2)] = inst_51996);
(statearr_52016_52038[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (10)))
{var inst_51988 = (state_52002[(2)]);var state_52002__$1 = state_52002;var statearr_52017_52039 = state_52002__$1;(statearr_52017_52039[(2)] = inst_51988);
(statearr_52017_52039[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52003 === (8)))
{var inst_51985 = cljs.core.async.close_BANG_.call(null,to);var state_52002__$1 = state_52002;var statearr_52018_52040 = state_52002__$1;(statearr_52018_52040[(2)] = inst_51985);
(statearr_52018_52040[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___52026))
;return ((function (switch__11077__auto__,c__11142__auto___52026){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_52022 = [null,null,null,null,null,null,null,null];(statearr_52022[(0)] = state_machine__11078__auto__);
(statearr_52022[(1)] = (1));
return statearr_52022;
});
var state_machine__11078__auto____1 = (function (state_52002){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_52002);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e52023){if((e52023 instanceof Object))
{var ex__11081__auto__ = e52023;var statearr_52024_52041 = state_52002;(statearr_52024_52041[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52002);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e52023;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__52042 = state_52002;
state_52002 = G__52042;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_52002){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_52002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___52026))
})();var state__11144__auto__ = (function (){var statearr_52025 = f__11143__auto__.call(null);(statearr_52025[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___52026);
return statearr_52025;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___52026))
);
return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){var tc = cljs.core.async.chan.call(null,t_buf_or_n);var fc = cljs.core.async.chan.call(null,f_buf_or_n);var c__11142__auto___52143 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___52143,tc,fc){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___52143,tc,fc){
return (function (state_52118){var state_val_52119 = (state_52118[(1)]);if((state_val_52119 === (7)))
{var inst_52114 = (state_52118[(2)]);var state_52118__$1 = state_52118;var statearr_52120_52144 = state_52118__$1;(statearr_52120_52144[(2)] = inst_52114);
(statearr_52120_52144[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (1)))
{var state_52118__$1 = state_52118;var statearr_52121_52145 = state_52118__$1;(statearr_52121_52145[(2)] = null);
(statearr_52121_52145[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (4)))
{var inst_52095 = (state_52118[(7)]);var inst_52095__$1 = (state_52118[(2)]);var inst_52096 = (inst_52095__$1 == null);var state_52118__$1 = (function (){var statearr_52122 = state_52118;(statearr_52122[(7)] = inst_52095__$1);
return statearr_52122;
})();if(cljs.core.truth_(inst_52096))
{var statearr_52123_52146 = state_52118__$1;(statearr_52123_52146[(1)] = (5));
} else
{var statearr_52124_52147 = state_52118__$1;(statearr_52124_52147[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (13)))
{var state_52118__$1 = state_52118;var statearr_52125_52148 = state_52118__$1;(statearr_52125_52148[(2)] = null);
(statearr_52125_52148[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (6)))
{var inst_52095 = (state_52118[(7)]);var inst_52101 = p.call(null,inst_52095);var state_52118__$1 = state_52118;if(cljs.core.truth_(inst_52101))
{var statearr_52126_52149 = state_52118__$1;(statearr_52126_52149[(1)] = (9));
} else
{var statearr_52127_52150 = state_52118__$1;(statearr_52127_52150[(1)] = (10));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (3)))
{var inst_52116 = (state_52118[(2)]);var state_52118__$1 = state_52118;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52118__$1,inst_52116);
} else
{if((state_val_52119 === (12)))
{var state_52118__$1 = state_52118;var statearr_52128_52151 = state_52118__$1;(statearr_52128_52151[(2)] = null);
(statearr_52128_52151[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (2)))
{var state_52118__$1 = state_52118;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52118__$1,(4),ch);
} else
{if((state_val_52119 === (11)))
{var inst_52095 = (state_52118[(7)]);var inst_52105 = (state_52118[(2)]);var state_52118__$1 = state_52118;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52118__$1,(8),inst_52105,inst_52095);
} else
{if((state_val_52119 === (9)))
{var state_52118__$1 = state_52118;var statearr_52129_52152 = state_52118__$1;(statearr_52129_52152[(2)] = tc);
(statearr_52129_52152[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (5)))
{var inst_52098 = cljs.core.async.close_BANG_.call(null,tc);var inst_52099 = cljs.core.async.close_BANG_.call(null,fc);var state_52118__$1 = (function (){var statearr_52130 = state_52118;(statearr_52130[(8)] = inst_52098);
return statearr_52130;
})();var statearr_52131_52153 = state_52118__$1;(statearr_52131_52153[(2)] = inst_52099);
(statearr_52131_52153[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (14)))
{var inst_52112 = (state_52118[(2)]);var state_52118__$1 = state_52118;var statearr_52132_52154 = state_52118__$1;(statearr_52132_52154[(2)] = inst_52112);
(statearr_52132_52154[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (10)))
{var state_52118__$1 = state_52118;var statearr_52133_52155 = state_52118__$1;(statearr_52133_52155[(2)] = fc);
(statearr_52133_52155[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52119 === (8)))
{var inst_52107 = (state_52118[(2)]);var state_52118__$1 = state_52118;if(cljs.core.truth_(inst_52107))
{var statearr_52134_52156 = state_52118__$1;(statearr_52134_52156[(1)] = (12));
} else
{var statearr_52135_52157 = state_52118__$1;(statearr_52135_52157[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___52143,tc,fc))
;return ((function (switch__11077__auto__,c__11142__auto___52143,tc,fc){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_52139 = [null,null,null,null,null,null,null,null,null];(statearr_52139[(0)] = state_machine__11078__auto__);
(statearr_52139[(1)] = (1));
return statearr_52139;
});
var state_machine__11078__auto____1 = (function (state_52118){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_52118);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e52140){if((e52140 instanceof Object))
{var ex__11081__auto__ = e52140;var statearr_52141_52158 = state_52118;(statearr_52141_52158[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52118);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e52140;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__52159 = state_52118;
state_52118 = G__52159;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_52118){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_52118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___52143,tc,fc))
})();var state__11144__auto__ = (function (){var statearr_52142 = f__11143__auto__.call(null);(statearr_52142[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___52143);
return statearr_52142;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___52143,tc,fc))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){var c__11142__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto__){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto__){
return (function (state_52206){var state_val_52207 = (state_52206[(1)]);if((state_val_52207 === (7)))
{var inst_52202 = (state_52206[(2)]);var state_52206__$1 = state_52206;var statearr_52208_52224 = state_52206__$1;(statearr_52208_52224[(2)] = inst_52202);
(statearr_52208_52224[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52207 === (6)))
{var inst_52192 = (state_52206[(7)]);var inst_52195 = (state_52206[(8)]);var inst_52199 = f.call(null,inst_52192,inst_52195);var inst_52192__$1 = inst_52199;var state_52206__$1 = (function (){var statearr_52209 = state_52206;(statearr_52209[(7)] = inst_52192__$1);
return statearr_52209;
})();var statearr_52210_52225 = state_52206__$1;(statearr_52210_52225[(2)] = null);
(statearr_52210_52225[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52207 === (5)))
{var inst_52192 = (state_52206[(7)]);var state_52206__$1 = state_52206;var statearr_52211_52226 = state_52206__$1;(statearr_52211_52226[(2)] = inst_52192);
(statearr_52211_52226[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52207 === (4)))
{var inst_52195 = (state_52206[(8)]);var inst_52195__$1 = (state_52206[(2)]);var inst_52196 = (inst_52195__$1 == null);var state_52206__$1 = (function (){var statearr_52212 = state_52206;(statearr_52212[(8)] = inst_52195__$1);
return statearr_52212;
})();if(cljs.core.truth_(inst_52196))
{var statearr_52213_52227 = state_52206__$1;(statearr_52213_52227[(1)] = (5));
} else
{var statearr_52214_52228 = state_52206__$1;(statearr_52214_52228[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52207 === (3)))
{var inst_52204 = (state_52206[(2)]);var state_52206__$1 = state_52206;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52206__$1,inst_52204);
} else
{if((state_val_52207 === (2)))
{var state_52206__$1 = state_52206;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52206__$1,(4),ch);
} else
{if((state_val_52207 === (1)))
{var inst_52192 = init;var state_52206__$1 = (function (){var statearr_52215 = state_52206;(statearr_52215[(7)] = inst_52192);
return statearr_52215;
})();var statearr_52216_52229 = state_52206__$1;(statearr_52216_52229[(2)] = null);
(statearr_52216_52229[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
});})(c__11142__auto__))
;return ((function (switch__11077__auto__,c__11142__auto__){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_52220 = [null,null,null,null,null,null,null,null,null];(statearr_52220[(0)] = state_machine__11078__auto__);
(statearr_52220[(1)] = (1));
return statearr_52220;
});
var state_machine__11078__auto____1 = (function (state_52206){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_52206);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e52221){if((e52221 instanceof Object))
{var ex__11081__auto__ = e52221;var statearr_52222_52230 = state_52206;(statearr_52222_52230[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52206);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e52221;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__52231 = state_52206;
state_52206 = G__52231;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_52206){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_52206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto__))
})();var state__11144__auto__ = (function (){var statearr_52223 = f__11143__auto__.call(null);(statearr_52223[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto__);
return statearr_52223;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto__))
);
return c__11142__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){var c__11142__auto__ = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto__){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto__){
return (function (state_52305){var state_val_52306 = (state_52305[(1)]);if((state_val_52306 === (7)))
{var inst_52287 = (state_52305[(2)]);var state_52305__$1 = state_52305;var statearr_52307_52330 = state_52305__$1;(statearr_52307_52330[(2)] = inst_52287);
(statearr_52307_52330[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (1)))
{var inst_52281 = cljs.core.seq.call(null,coll);var inst_52282 = inst_52281;var state_52305__$1 = (function (){var statearr_52308 = state_52305;(statearr_52308[(7)] = inst_52282);
return statearr_52308;
})();var statearr_52309_52331 = state_52305__$1;(statearr_52309_52331[(2)] = null);
(statearr_52309_52331[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (4)))
{var inst_52282 = (state_52305[(7)]);var inst_52285 = cljs.core.first.call(null,inst_52282);var state_52305__$1 = state_52305;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_52305__$1,(7),ch,inst_52285);
} else
{if((state_val_52306 === (13)))
{var inst_52299 = (state_52305[(2)]);var state_52305__$1 = state_52305;var statearr_52310_52332 = state_52305__$1;(statearr_52310_52332[(2)] = inst_52299);
(statearr_52310_52332[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (6)))
{var inst_52290 = (state_52305[(2)]);var state_52305__$1 = state_52305;if(cljs.core.truth_(inst_52290))
{var statearr_52311_52333 = state_52305__$1;(statearr_52311_52333[(1)] = (8));
} else
{var statearr_52312_52334 = state_52305__$1;(statearr_52312_52334[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (3)))
{var inst_52303 = (state_52305[(2)]);var state_52305__$1 = state_52305;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52305__$1,inst_52303);
} else
{if((state_val_52306 === (12)))
{var state_52305__$1 = state_52305;var statearr_52313_52335 = state_52305__$1;(statearr_52313_52335[(2)] = null);
(statearr_52313_52335[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (2)))
{var inst_52282 = (state_52305[(7)]);var state_52305__$1 = state_52305;if(cljs.core.truth_(inst_52282))
{var statearr_52314_52336 = state_52305__$1;(statearr_52314_52336[(1)] = (4));
} else
{var statearr_52315_52337 = state_52305__$1;(statearr_52315_52337[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (11)))
{var inst_52296 = cljs.core.async.close_BANG_.call(null,ch);var state_52305__$1 = state_52305;var statearr_52316_52338 = state_52305__$1;(statearr_52316_52338[(2)] = inst_52296);
(statearr_52316_52338[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (9)))
{var state_52305__$1 = state_52305;if(cljs.core.truth_(close_QMARK_))
{var statearr_52317_52339 = state_52305__$1;(statearr_52317_52339[(1)] = (11));
} else
{var statearr_52318_52340 = state_52305__$1;(statearr_52318_52340[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (5)))
{var inst_52282 = (state_52305[(7)]);var state_52305__$1 = state_52305;var statearr_52319_52341 = state_52305__$1;(statearr_52319_52341[(2)] = inst_52282);
(statearr_52319_52341[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (10)))
{var inst_52301 = (state_52305[(2)]);var state_52305__$1 = state_52305;var statearr_52320_52342 = state_52305__$1;(statearr_52320_52342[(2)] = inst_52301);
(statearr_52320_52342[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52306 === (8)))
{var inst_52282 = (state_52305[(7)]);var inst_52292 = cljs.core.next.call(null,inst_52282);var inst_52282__$1 = inst_52292;var state_52305__$1 = (function (){var statearr_52321 = state_52305;(statearr_52321[(7)] = inst_52282__$1);
return statearr_52321;
})();var statearr_52322_52343 = state_52305__$1;(statearr_52322_52343[(2)] = null);
(statearr_52322_52343[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto__))
;return ((function (switch__11077__auto__,c__11142__auto__){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_52326 = [null,null,null,null,null,null,null,null];(statearr_52326[(0)] = state_machine__11078__auto__);
(statearr_52326[(1)] = (1));
return statearr_52326;
});
var state_machine__11078__auto____1 = (function (state_52305){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_52305);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e52327){if((e52327 instanceof Object))
{var ex__11081__auto__ = e52327;var statearr_52328_52344 = state_52305;(statearr_52328_52344[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52305);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e52327;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__52345 = state_52305;
state_52305 = G__52345;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_52305){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_52305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto__))
})();var state__11144__auto__ = (function (){var statearr_52329 = f__11143__auto__.call(null);(statearr_52329[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto__);
return statearr_52329;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto__))
);
return c__11142__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));cljs.core.async.onto_chan.call(null,ch,coll);
return ch;
});
cljs.core.async.Mux = (function (){var obj52347 = {};return obj52347;
})();
cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){if((function (){var and__7919__auto__ = _;if(and__7919__auto__)
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else
{return and__7919__auto__;
}
})())
{return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else
{var x__8558__auto__ = (((_ == null))?null:_);return (function (){var or__7931__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});
cljs.core.async.Mult = (function (){var obj52349 = {};return obj52349;
})();
cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.tap_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});
cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.untap_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});
/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var m = (function (){if(typeof cljs.core.async.t52571 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t52571 = (function (cs,ch,mult,meta52572){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta52572 = meta52572;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t52571.cljs$lang$type = true;
cljs.core.async.t52571.cljs$lang$ctorStr = "cljs.core.async/t52571";
cljs.core.async.t52571.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t52571");
});})(cs))
;
cljs.core.async.t52571.prototype.cljs$core$async$Mult$ = true;
cljs.core.async.t52571.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$2,close_QMARK_){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$2,close_QMARK_);
return null;
});})(cs))
;
cljs.core.async.t52571.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$2){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$2);
return null;
});})(cs))
;
cljs.core.async.t52571.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return null;
});})(cs))
;
cljs.core.async.t52571.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t52571.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(cs))
;
cljs.core.async.t52571.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_52573){var self__ = this;
var _52573__$1 = this;return self__.meta52572;
});})(cs))
;
cljs.core.async.t52571.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_52573,meta52572__$1){var self__ = this;
var _52573__$1 = this;return (new cljs.core.async.t52571(self__.cs,self__.ch,self__.mult,meta52572__$1));
});})(cs))
;
cljs.core.async.__GT_t52571 = ((function (cs){
return (function __GT_t52571(cs__$1,ch__$1,mult__$1,meta52572){return (new cljs.core.async.t52571(cs__$1,ch__$1,mult__$1,meta52572));
});})(cs))
;
}
return (new cljs.core.async.t52571(cs,ch,mult,null));
})();var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = ((function (cs,m,dchan,dctr){
return (function (_){if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,true);
} else
{return null;
}
});})(cs,m,dchan,dctr))
;var c__11142__auto___52792 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___52792,cs,m,dchan,dctr,done){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___52792,cs,m,dchan,dctr,done){
return (function (state_52704){var state_val_52705 = (state_52704[(1)]);if((state_val_52705 === (7)))
{var inst_52700 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52706_52793 = state_52704__$1;(statearr_52706_52793[(2)] = inst_52700);
(statearr_52706_52793[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (20)))
{var inst_52605 = (state_52704[(7)]);var inst_52615 = cljs.core.first.call(null,inst_52605);var inst_52616 = cljs.core.nth.call(null,inst_52615,(0),null);var inst_52617 = cljs.core.nth.call(null,inst_52615,(1),null);var state_52704__$1 = (function (){var statearr_52707 = state_52704;(statearr_52707[(8)] = inst_52616);
return statearr_52707;
})();if(cljs.core.truth_(inst_52617))
{var statearr_52708_52794 = state_52704__$1;(statearr_52708_52794[(1)] = (22));
} else
{var statearr_52709_52795 = state_52704__$1;(statearr_52709_52795[(1)] = (23));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (27)))
{var inst_52576 = (state_52704[(9)]);var inst_52647 = (state_52704[(10)]);var inst_52652 = (state_52704[(11)]);var inst_52645 = (state_52704[(12)]);var inst_52652__$1 = cljs.core._nth.call(null,inst_52645,inst_52647);var inst_52653 = cljs.core.async.put_BANG_.call(null,inst_52652__$1,inst_52576,done);var state_52704__$1 = (function (){var statearr_52710 = state_52704;(statearr_52710[(11)] = inst_52652__$1);
return statearr_52710;
})();if(cljs.core.truth_(inst_52653))
{var statearr_52711_52796 = state_52704__$1;(statearr_52711_52796[(1)] = (30));
} else
{var statearr_52712_52797 = state_52704__$1;(statearr_52712_52797[(1)] = (31));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (1)))
{var state_52704__$1 = state_52704;var statearr_52713_52798 = state_52704__$1;(statearr_52713_52798[(2)] = null);
(statearr_52713_52798[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (24)))
{var inst_52605 = (state_52704[(7)]);var inst_52622 = (state_52704[(2)]);var inst_52623 = cljs.core.next.call(null,inst_52605);var inst_52585 = inst_52623;var inst_52586 = null;var inst_52587 = (0);var inst_52588 = (0);var state_52704__$1 = (function (){var statearr_52714 = state_52704;(statearr_52714[(13)] = inst_52585);
(statearr_52714[(14)] = inst_52622);
(statearr_52714[(15)] = inst_52586);
(statearr_52714[(16)] = inst_52587);
(statearr_52714[(17)] = inst_52588);
return statearr_52714;
})();var statearr_52715_52799 = state_52704__$1;(statearr_52715_52799[(2)] = null);
(statearr_52715_52799[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (39)))
{var state_52704__$1 = state_52704;var statearr_52719_52800 = state_52704__$1;(statearr_52719_52800[(2)] = null);
(statearr_52719_52800[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (4)))
{var inst_52576 = (state_52704[(9)]);var inst_52576__$1 = (state_52704[(2)]);var inst_52577 = (inst_52576__$1 == null);var state_52704__$1 = (function (){var statearr_52720 = state_52704;(statearr_52720[(9)] = inst_52576__$1);
return statearr_52720;
})();if(cljs.core.truth_(inst_52577))
{var statearr_52721_52801 = state_52704__$1;(statearr_52721_52801[(1)] = (5));
} else
{var statearr_52722_52802 = state_52704__$1;(statearr_52722_52802[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (15)))
{var inst_52585 = (state_52704[(13)]);var inst_52586 = (state_52704[(15)]);var inst_52587 = (state_52704[(16)]);var inst_52588 = (state_52704[(17)]);var inst_52601 = (state_52704[(2)]);var inst_52602 = (inst_52588 + (1));var tmp52716 = inst_52585;var tmp52717 = inst_52586;var tmp52718 = inst_52587;var inst_52585__$1 = tmp52716;var inst_52586__$1 = tmp52717;var inst_52587__$1 = tmp52718;var inst_52588__$1 = inst_52602;var state_52704__$1 = (function (){var statearr_52723 = state_52704;(statearr_52723[(13)] = inst_52585__$1);
(statearr_52723[(15)] = inst_52586__$1);
(statearr_52723[(16)] = inst_52587__$1);
(statearr_52723[(17)] = inst_52588__$1);
(statearr_52723[(18)] = inst_52601);
return statearr_52723;
})();var statearr_52724_52803 = state_52704__$1;(statearr_52724_52803[(2)] = null);
(statearr_52724_52803[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (21)))
{var inst_52626 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52728_52804 = state_52704__$1;(statearr_52728_52804[(2)] = inst_52626);
(statearr_52728_52804[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (31)))
{var inst_52652 = (state_52704[(11)]);var inst_52656 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_52657 = cljs.core.async.untap_STAR_.call(null,m,inst_52652);var state_52704__$1 = (function (){var statearr_52729 = state_52704;(statearr_52729[(19)] = inst_52656);
return statearr_52729;
})();var statearr_52730_52805 = state_52704__$1;(statearr_52730_52805[(2)] = inst_52657);
(statearr_52730_52805[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (32)))
{var inst_52644 = (state_52704[(20)]);var inst_52647 = (state_52704[(10)]);var inst_52646 = (state_52704[(21)]);var inst_52645 = (state_52704[(12)]);var inst_52659 = (state_52704[(2)]);var inst_52660 = (inst_52647 + (1));var tmp52725 = inst_52644;var tmp52726 = inst_52646;var tmp52727 = inst_52645;var inst_52644__$1 = tmp52725;var inst_52645__$1 = tmp52727;var inst_52646__$1 = tmp52726;var inst_52647__$1 = inst_52660;var state_52704__$1 = (function (){var statearr_52731 = state_52704;(statearr_52731[(22)] = inst_52659);
(statearr_52731[(20)] = inst_52644__$1);
(statearr_52731[(10)] = inst_52647__$1);
(statearr_52731[(21)] = inst_52646__$1);
(statearr_52731[(12)] = inst_52645__$1);
return statearr_52731;
})();var statearr_52732_52806 = state_52704__$1;(statearr_52732_52806[(2)] = null);
(statearr_52732_52806[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (40)))
{var inst_52672 = (state_52704[(23)]);var inst_52676 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var inst_52677 = cljs.core.async.untap_STAR_.call(null,m,inst_52672);var state_52704__$1 = (function (){var statearr_52733 = state_52704;(statearr_52733[(24)] = inst_52676);
return statearr_52733;
})();var statearr_52734_52807 = state_52704__$1;(statearr_52734_52807[(2)] = inst_52677);
(statearr_52734_52807[(1)] = (41));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (33)))
{var inst_52663 = (state_52704[(25)]);var inst_52665 = cljs.core.chunked_seq_QMARK_.call(null,inst_52663);var state_52704__$1 = state_52704;if(inst_52665)
{var statearr_52735_52808 = state_52704__$1;(statearr_52735_52808[(1)] = (36));
} else
{var statearr_52736_52809 = state_52704__$1;(statearr_52736_52809[(1)] = (37));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (13)))
{var inst_52595 = (state_52704[(26)]);var inst_52598 = cljs.core.async.close_BANG_.call(null,inst_52595);var state_52704__$1 = state_52704;var statearr_52737_52810 = state_52704__$1;(statearr_52737_52810[(2)] = inst_52598);
(statearr_52737_52810[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (22)))
{var inst_52616 = (state_52704[(8)]);var inst_52619 = cljs.core.async.close_BANG_.call(null,inst_52616);var state_52704__$1 = state_52704;var statearr_52738_52811 = state_52704__$1;(statearr_52738_52811[(2)] = inst_52619);
(statearr_52738_52811[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (36)))
{var inst_52663 = (state_52704[(25)]);var inst_52667 = cljs.core.chunk_first.call(null,inst_52663);var inst_52668 = cljs.core.chunk_rest.call(null,inst_52663);var inst_52669 = cljs.core.count.call(null,inst_52667);var inst_52644 = inst_52668;var inst_52645 = inst_52667;var inst_52646 = inst_52669;var inst_52647 = (0);var state_52704__$1 = (function (){var statearr_52739 = state_52704;(statearr_52739[(20)] = inst_52644);
(statearr_52739[(10)] = inst_52647);
(statearr_52739[(21)] = inst_52646);
(statearr_52739[(12)] = inst_52645);
return statearr_52739;
})();var statearr_52740_52812 = state_52704__$1;(statearr_52740_52812[(2)] = null);
(statearr_52740_52812[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (41)))
{var inst_52663 = (state_52704[(25)]);var inst_52679 = (state_52704[(2)]);var inst_52680 = cljs.core.next.call(null,inst_52663);var inst_52644 = inst_52680;var inst_52645 = null;var inst_52646 = (0);var inst_52647 = (0);var state_52704__$1 = (function (){var statearr_52741 = state_52704;(statearr_52741[(20)] = inst_52644);
(statearr_52741[(10)] = inst_52647);
(statearr_52741[(21)] = inst_52646);
(statearr_52741[(12)] = inst_52645);
(statearr_52741[(27)] = inst_52679);
return statearr_52741;
})();var statearr_52742_52813 = state_52704__$1;(statearr_52742_52813[(2)] = null);
(statearr_52742_52813[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (43)))
{var state_52704__$1 = state_52704;var statearr_52743_52814 = state_52704__$1;(statearr_52743_52814[(2)] = null);
(statearr_52743_52814[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (29)))
{var inst_52688 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52744_52815 = state_52704__$1;(statearr_52744_52815[(2)] = inst_52688);
(statearr_52744_52815[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (44)))
{var inst_52697 = (state_52704[(2)]);var state_52704__$1 = (function (){var statearr_52745 = state_52704;(statearr_52745[(28)] = inst_52697);
return statearr_52745;
})();var statearr_52746_52816 = state_52704__$1;(statearr_52746_52816[(2)] = null);
(statearr_52746_52816[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (6)))
{var inst_52636 = (state_52704[(29)]);var inst_52635 = cljs.core.deref.call(null,cs);var inst_52636__$1 = cljs.core.keys.call(null,inst_52635);var inst_52637 = cljs.core.count.call(null,inst_52636__$1);var inst_52638 = cljs.core.reset_BANG_.call(null,dctr,inst_52637);var inst_52643 = cljs.core.seq.call(null,inst_52636__$1);var inst_52644 = inst_52643;var inst_52645 = null;var inst_52646 = (0);var inst_52647 = (0);var state_52704__$1 = (function (){var statearr_52747 = state_52704;(statearr_52747[(20)] = inst_52644);
(statearr_52747[(10)] = inst_52647);
(statearr_52747[(29)] = inst_52636__$1);
(statearr_52747[(21)] = inst_52646);
(statearr_52747[(12)] = inst_52645);
(statearr_52747[(30)] = inst_52638);
return statearr_52747;
})();var statearr_52748_52817 = state_52704__$1;(statearr_52748_52817[(2)] = null);
(statearr_52748_52817[(1)] = (25));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (28)))
{var inst_52644 = (state_52704[(20)]);var inst_52663 = (state_52704[(25)]);var inst_52663__$1 = cljs.core.seq.call(null,inst_52644);var state_52704__$1 = (function (){var statearr_52749 = state_52704;(statearr_52749[(25)] = inst_52663__$1);
return statearr_52749;
})();if(inst_52663__$1)
{var statearr_52750_52818 = state_52704__$1;(statearr_52750_52818[(1)] = (33));
} else
{var statearr_52751_52819 = state_52704__$1;(statearr_52751_52819[(1)] = (34));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (25)))
{var inst_52647 = (state_52704[(10)]);var inst_52646 = (state_52704[(21)]);var inst_52649 = (inst_52647 < inst_52646);var inst_52650 = inst_52649;var state_52704__$1 = state_52704;if(cljs.core.truth_(inst_52650))
{var statearr_52752_52820 = state_52704__$1;(statearr_52752_52820[(1)] = (27));
} else
{var statearr_52753_52821 = state_52704__$1;(statearr_52753_52821[(1)] = (28));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (34)))
{var state_52704__$1 = state_52704;var statearr_52754_52822 = state_52704__$1;(statearr_52754_52822[(2)] = null);
(statearr_52754_52822[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (17)))
{var state_52704__$1 = state_52704;var statearr_52755_52823 = state_52704__$1;(statearr_52755_52823[(2)] = null);
(statearr_52755_52823[(1)] = (18));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (3)))
{var inst_52702 = (state_52704[(2)]);var state_52704__$1 = state_52704;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52704__$1,inst_52702);
} else
{if((state_val_52705 === (12)))
{var inst_52631 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52756_52824 = state_52704__$1;(statearr_52756_52824[(2)] = inst_52631);
(statearr_52756_52824[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (2)))
{var state_52704__$1 = state_52704;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52704__$1,(4),ch);
} else
{if((state_val_52705 === (23)))
{var state_52704__$1 = state_52704;var statearr_52757_52825 = state_52704__$1;(statearr_52757_52825[(2)] = null);
(statearr_52757_52825[(1)] = (24));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (35)))
{var inst_52686 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52758_52826 = state_52704__$1;(statearr_52758_52826[(2)] = inst_52686);
(statearr_52758_52826[(1)] = (29));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (19)))
{var inst_52605 = (state_52704[(7)]);var inst_52609 = cljs.core.chunk_first.call(null,inst_52605);var inst_52610 = cljs.core.chunk_rest.call(null,inst_52605);var inst_52611 = cljs.core.count.call(null,inst_52609);var inst_52585 = inst_52610;var inst_52586 = inst_52609;var inst_52587 = inst_52611;var inst_52588 = (0);var state_52704__$1 = (function (){var statearr_52759 = state_52704;(statearr_52759[(13)] = inst_52585);
(statearr_52759[(15)] = inst_52586);
(statearr_52759[(16)] = inst_52587);
(statearr_52759[(17)] = inst_52588);
return statearr_52759;
})();var statearr_52760_52827 = state_52704__$1;(statearr_52760_52827[(2)] = null);
(statearr_52760_52827[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (11)))
{var inst_52605 = (state_52704[(7)]);var inst_52585 = (state_52704[(13)]);var inst_52605__$1 = cljs.core.seq.call(null,inst_52585);var state_52704__$1 = (function (){var statearr_52761 = state_52704;(statearr_52761[(7)] = inst_52605__$1);
return statearr_52761;
})();if(inst_52605__$1)
{var statearr_52762_52828 = state_52704__$1;(statearr_52762_52828[(1)] = (16));
} else
{var statearr_52763_52829 = state_52704__$1;(statearr_52763_52829[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (9)))
{var inst_52633 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52764_52830 = state_52704__$1;(statearr_52764_52830[(2)] = inst_52633);
(statearr_52764_52830[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (5)))
{var inst_52583 = cljs.core.deref.call(null,cs);var inst_52584 = cljs.core.seq.call(null,inst_52583);var inst_52585 = inst_52584;var inst_52586 = null;var inst_52587 = (0);var inst_52588 = (0);var state_52704__$1 = (function (){var statearr_52765 = state_52704;(statearr_52765[(13)] = inst_52585);
(statearr_52765[(15)] = inst_52586);
(statearr_52765[(16)] = inst_52587);
(statearr_52765[(17)] = inst_52588);
return statearr_52765;
})();var statearr_52766_52831 = state_52704__$1;(statearr_52766_52831[(2)] = null);
(statearr_52766_52831[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (14)))
{var state_52704__$1 = state_52704;var statearr_52767_52832 = state_52704__$1;(statearr_52767_52832[(2)] = null);
(statearr_52767_52832[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (45)))
{var inst_52694 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52768_52833 = state_52704__$1;(statearr_52768_52833[(2)] = inst_52694);
(statearr_52768_52833[(1)] = (44));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (26)))
{var inst_52636 = (state_52704[(29)]);var inst_52690 = (state_52704[(2)]);var inst_52691 = cljs.core.seq.call(null,inst_52636);var state_52704__$1 = (function (){var statearr_52769 = state_52704;(statearr_52769[(31)] = inst_52690);
return statearr_52769;
})();if(inst_52691)
{var statearr_52770_52834 = state_52704__$1;(statearr_52770_52834[(1)] = (42));
} else
{var statearr_52771_52835 = state_52704__$1;(statearr_52771_52835[(1)] = (43));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (16)))
{var inst_52605 = (state_52704[(7)]);var inst_52607 = cljs.core.chunked_seq_QMARK_.call(null,inst_52605);var state_52704__$1 = state_52704;if(inst_52607)
{var statearr_52772_52836 = state_52704__$1;(statearr_52772_52836[(1)] = (19));
} else
{var statearr_52773_52837 = state_52704__$1;(statearr_52773_52837[(1)] = (20));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (38)))
{var inst_52683 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52774_52838 = state_52704__$1;(statearr_52774_52838[(2)] = inst_52683);
(statearr_52774_52838[(1)] = (35));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (30)))
{var state_52704__$1 = state_52704;var statearr_52775_52839 = state_52704__$1;(statearr_52775_52839[(2)] = null);
(statearr_52775_52839[(1)] = (32));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (10)))
{var inst_52586 = (state_52704[(15)]);var inst_52588 = (state_52704[(17)]);var inst_52594 = cljs.core._nth.call(null,inst_52586,inst_52588);var inst_52595 = cljs.core.nth.call(null,inst_52594,(0),null);var inst_52596 = cljs.core.nth.call(null,inst_52594,(1),null);var state_52704__$1 = (function (){var statearr_52776 = state_52704;(statearr_52776[(26)] = inst_52595);
return statearr_52776;
})();if(cljs.core.truth_(inst_52596))
{var statearr_52777_52840 = state_52704__$1;(statearr_52777_52840[(1)] = (13));
} else
{var statearr_52778_52841 = state_52704__$1;(statearr_52778_52841[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (18)))
{var inst_52629 = (state_52704[(2)]);var state_52704__$1 = state_52704;var statearr_52779_52842 = state_52704__$1;(statearr_52779_52842[(2)] = inst_52629);
(statearr_52779_52842[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (42)))
{var state_52704__$1 = state_52704;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52704__$1,(45),dchan);
} else
{if((state_val_52705 === (37)))
{var inst_52576 = (state_52704[(9)]);var inst_52663 = (state_52704[(25)]);var inst_52672 = (state_52704[(23)]);var inst_52672__$1 = cljs.core.first.call(null,inst_52663);var inst_52673 = cljs.core.async.put_BANG_.call(null,inst_52672__$1,inst_52576,done);var state_52704__$1 = (function (){var statearr_52780 = state_52704;(statearr_52780[(23)] = inst_52672__$1);
return statearr_52780;
})();if(cljs.core.truth_(inst_52673))
{var statearr_52781_52843 = state_52704__$1;(statearr_52781_52843[(1)] = (39));
} else
{var statearr_52782_52844 = state_52704__$1;(statearr_52782_52844[(1)] = (40));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_52705 === (8)))
{var inst_52587 = (state_52704[(16)]);var inst_52588 = (state_52704[(17)]);var inst_52590 = (inst_52588 < inst_52587);var inst_52591 = inst_52590;var state_52704__$1 = state_52704;if(cljs.core.truth_(inst_52591))
{var statearr_52783_52845 = state_52704__$1;(statearr_52783_52845[(1)] = (10));
} else
{var statearr_52784_52846 = state_52704__$1;(statearr_52784_52846[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___52792,cs,m,dchan,dctr,done))
;return ((function (switch__11077__auto__,c__11142__auto___52792,cs,m,dchan,dctr,done){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_52788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_52788[(0)] = state_machine__11078__auto__);
(statearr_52788[(1)] = (1));
return statearr_52788;
});
var state_machine__11078__auto____1 = (function (state_52704){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_52704);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e52789){if((e52789 instanceof Object))
{var ex__11081__auto__ = e52789;var statearr_52790_52847 = state_52704;(statearr_52790_52847[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_52704);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e52789;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__52848 = state_52704;
state_52704 = G__52848;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_52704){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_52704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___52792,cs,m,dchan,dctr,done))
})();var state__11144__auto__ = (function (){var statearr_52791 = f__11143__auto__.call(null);(statearr_52791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___52792);
return statearr_52791;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___52792,cs,m,dchan,dctr,done))
);
return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);
return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){return cljs.core.async.untap_all_STAR_.call(null,mult);
});
cljs.core.async.Mix = (function (){var obj52850 = {};return obj52850;
})();
cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.admix_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});
cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});
cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});
cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){if((function (){var and__7919__auto__ = m;if(and__7919__auto__)
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else
{return and__7919__auto__;
}
})())
{return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else
{var x__8558__auto__ = (((m == null))?null:m);return (function (){var or__7931__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));var change = cljs.core.async.chan.call(null);var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){if(cljs.core.truth_(attr.call(null,v)))
{return cljs.core.conj.call(null,ret,c);
} else
{return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){var chs = cljs.core.deref.call(null,cs);var mode = cljs.core.deref.call(null,solo_mode);var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;var m = (function (){if(typeof cljs.core.async.t52970 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t52970 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta52971){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta52971 = meta52971;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t52970.cljs$lang$type = true;
cljs.core.async.t52970.cljs$lang$ctorStr = "cljs.core.async/t52970";
cljs.core.async.t52970.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t52970");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$async$Mix$ = true;
cljs.core.async.t52970.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){var self__ = this;
var ___$1 = this;cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.solo_modes.call(null,mode)))
{} else
{throw (new Error(("Assert failed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(("mode must be one of: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)))+"\n"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null)))))));
}
cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);
return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t52970.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){var self__ = this;
var ___$1 = this;return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_52972){var self__ = this;
var _52972__$1 = this;return self__.meta52971;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.t52970.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_52972,meta52971__$1){var self__ = this;
var _52972__$1 = this;return (new cljs.core.async.t52970(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta52971__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
cljs.core.async.__GT_t52970 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t52970(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta52971){return (new cljs.core.async.t52970(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta52971));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;
}
return (new cljs.core.async.t52970(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,null));
})();var c__11142__auto___53089 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___53089,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___53089,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_53042){var state_val_53043 = (state_53042[(1)]);if((state_val_53043 === (7)))
{var inst_52986 = (state_53042[(7)]);var inst_52991 = cljs.core.apply.call(null,cljs.core.hash_map,inst_52986);var state_53042__$1 = state_53042;var statearr_53044_53090 = state_53042__$1;(statearr_53044_53090[(2)] = inst_52991);
(statearr_53044_53090[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (20)))
{var inst_53001 = (state_53042[(8)]);var state_53042__$1 = state_53042;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53042__$1,(23),out,inst_53001);
} else
{if((state_val_53043 === (1)))
{var inst_52976 = (state_53042[(9)]);var inst_52976__$1 = calc_state.call(null);var inst_52977 = cljs.core.seq_QMARK_.call(null,inst_52976__$1);var state_53042__$1 = (function (){var statearr_53045 = state_53042;(statearr_53045[(9)] = inst_52976__$1);
return statearr_53045;
})();if(inst_52977)
{var statearr_53046_53091 = state_53042__$1;(statearr_53046_53091[(1)] = (2));
} else
{var statearr_53047_53092 = state_53042__$1;(statearr_53047_53092[(1)] = (3));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (24)))
{var inst_52994 = (state_53042[(10)]);var inst_52986 = inst_52994;var state_53042__$1 = (function (){var statearr_53048 = state_53042;(statearr_53048[(7)] = inst_52986);
return statearr_53048;
})();var statearr_53049_53093 = state_53042__$1;(statearr_53049_53093[(2)] = null);
(statearr_53049_53093[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (4)))
{var inst_52976 = (state_53042[(9)]);var inst_52982 = (state_53042[(2)]);var inst_52983 = cljs.core.get.call(null,inst_52982,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_52984 = cljs.core.get.call(null,inst_52982,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_52985 = cljs.core.get.call(null,inst_52982,new cljs.core.Keyword(null,"solos","solos",1441458643));var inst_52986 = inst_52976;var state_53042__$1 = (function (){var statearr_53050 = state_53042;(statearr_53050[(11)] = inst_52985);
(statearr_53050[(12)] = inst_52983);
(statearr_53050[(7)] = inst_52986);
(statearr_53050[(13)] = inst_52984);
return statearr_53050;
})();var statearr_53051_53094 = state_53042__$1;(statearr_53051_53094[(2)] = null);
(statearr_53051_53094[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (15)))
{var state_53042__$1 = state_53042;var statearr_53052_53095 = state_53042__$1;(statearr_53052_53095[(2)] = null);
(statearr_53052_53095[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (21)))
{var inst_52994 = (state_53042[(10)]);var inst_52986 = inst_52994;var state_53042__$1 = (function (){var statearr_53053 = state_53042;(statearr_53053[(7)] = inst_52986);
return statearr_53053;
})();var statearr_53054_53096 = state_53042__$1;(statearr_53054_53096[(2)] = null);
(statearr_53054_53096[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (13)))
{var inst_53038 = (state_53042[(2)]);var state_53042__$1 = state_53042;var statearr_53055_53097 = state_53042__$1;(statearr_53055_53097[(2)] = inst_53038);
(statearr_53055_53097[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (22)))
{var inst_53036 = (state_53042[(2)]);var state_53042__$1 = state_53042;var statearr_53056_53098 = state_53042__$1;(statearr_53056_53098[(2)] = inst_53036);
(statearr_53056_53098[(1)] = (13));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (6)))
{var inst_53040 = (state_53042[(2)]);var state_53042__$1 = state_53042;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53042__$1,inst_53040);
} else
{if((state_val_53043 === (25)))
{var state_53042__$1 = state_53042;var statearr_53057_53099 = state_53042__$1;(statearr_53057_53099[(2)] = null);
(statearr_53057_53099[(1)] = (26));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (17)))
{var inst_53016 = (state_53042[(14)]);var state_53042__$1 = state_53042;var statearr_53058_53100 = state_53042__$1;(statearr_53058_53100[(2)] = inst_53016);
(statearr_53058_53100[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (3)))
{var inst_52976 = (state_53042[(9)]);var state_53042__$1 = state_53042;var statearr_53059_53101 = state_53042__$1;(statearr_53059_53101[(2)] = inst_52976);
(statearr_53059_53101[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (12)))
{var inst_52997 = (state_53042[(15)]);var inst_53002 = (state_53042[(16)]);var inst_53016 = (state_53042[(14)]);var inst_53016__$1 = inst_52997.call(null,inst_53002);var state_53042__$1 = (function (){var statearr_53060 = state_53042;(statearr_53060[(14)] = inst_53016__$1);
return statearr_53060;
})();if(cljs.core.truth_(inst_53016__$1))
{var statearr_53061_53102 = state_53042__$1;(statearr_53061_53102[(1)] = (17));
} else
{var statearr_53062_53103 = state_53042__$1;(statearr_53062_53103[(1)] = (18));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (2)))
{var inst_52976 = (state_53042[(9)]);var inst_52979 = cljs.core.apply.call(null,cljs.core.hash_map,inst_52976);var state_53042__$1 = state_53042;var statearr_53063_53104 = state_53042__$1;(statearr_53063_53104[(2)] = inst_52979);
(statearr_53063_53104[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (23)))
{var inst_53027 = (state_53042[(2)]);var state_53042__$1 = state_53042;if(cljs.core.truth_(inst_53027))
{var statearr_53064_53105 = state_53042__$1;(statearr_53064_53105[(1)] = (24));
} else
{var statearr_53065_53106 = state_53042__$1;(statearr_53065_53106[(1)] = (25));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (19)))
{var inst_53024 = (state_53042[(2)]);var state_53042__$1 = state_53042;if(cljs.core.truth_(inst_53024))
{var statearr_53066_53107 = state_53042__$1;(statearr_53066_53107[(1)] = (20));
} else
{var statearr_53067_53108 = state_53042__$1;(statearr_53067_53108[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (11)))
{var inst_53001 = (state_53042[(8)]);var inst_53007 = (inst_53001 == null);var state_53042__$1 = state_53042;if(cljs.core.truth_(inst_53007))
{var statearr_53068_53109 = state_53042__$1;(statearr_53068_53109[(1)] = (14));
} else
{var statearr_53069_53110 = state_53042__$1;(statearr_53069_53110[(1)] = (15));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (9)))
{var inst_52994 = (state_53042[(10)]);var inst_52994__$1 = (state_53042[(2)]);var inst_52995 = cljs.core.get.call(null,inst_52994__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));var inst_52996 = cljs.core.get.call(null,inst_52994__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));var inst_52997 = cljs.core.get.call(null,inst_52994__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));var state_53042__$1 = (function (){var statearr_53070 = state_53042;(statearr_53070[(10)] = inst_52994__$1);
(statearr_53070[(15)] = inst_52997);
(statearr_53070[(17)] = inst_52996);
return statearr_53070;
})();return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_53042__$1,(10),inst_52995);
} else
{if((state_val_53043 === (5)))
{var inst_52986 = (state_53042[(7)]);var inst_52989 = cljs.core.seq_QMARK_.call(null,inst_52986);var state_53042__$1 = state_53042;if(inst_52989)
{var statearr_53071_53111 = state_53042__$1;(statearr_53071_53111[(1)] = (7));
} else
{var statearr_53072_53112 = state_53042__$1;(statearr_53072_53112[(1)] = (8));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (14)))
{var inst_53002 = (state_53042[(16)]);var inst_53009 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_53002);var state_53042__$1 = state_53042;var statearr_53073_53113 = state_53042__$1;(statearr_53073_53113[(2)] = inst_53009);
(statearr_53073_53113[(1)] = (16));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (26)))
{var inst_53032 = (state_53042[(2)]);var state_53042__$1 = state_53042;var statearr_53074_53114 = state_53042__$1;(statearr_53074_53114[(2)] = inst_53032);
(statearr_53074_53114[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (16)))
{var inst_53012 = (state_53042[(2)]);var inst_53013 = calc_state.call(null);var inst_52986 = inst_53013;var state_53042__$1 = (function (){var statearr_53075 = state_53042;(statearr_53075[(18)] = inst_53012);
(statearr_53075[(7)] = inst_52986);
return statearr_53075;
})();var statearr_53076_53115 = state_53042__$1;(statearr_53076_53115[(2)] = null);
(statearr_53076_53115[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (10)))
{var inst_53002 = (state_53042[(16)]);var inst_53001 = (state_53042[(8)]);var inst_53000 = (state_53042[(2)]);var inst_53001__$1 = cljs.core.nth.call(null,inst_53000,(0),null);var inst_53002__$1 = cljs.core.nth.call(null,inst_53000,(1),null);var inst_53003 = (inst_53001__$1 == null);var inst_53004 = cljs.core._EQ_.call(null,inst_53002__$1,change);var inst_53005 = (inst_53003) || (inst_53004);var state_53042__$1 = (function (){var statearr_53077 = state_53042;(statearr_53077[(16)] = inst_53002__$1);
(statearr_53077[(8)] = inst_53001__$1);
return statearr_53077;
})();if(cljs.core.truth_(inst_53005))
{var statearr_53078_53116 = state_53042__$1;(statearr_53078_53116[(1)] = (11));
} else
{var statearr_53079_53117 = state_53042__$1;(statearr_53079_53117[(1)] = (12));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (18)))
{var inst_52997 = (state_53042[(15)]);var inst_53002 = (state_53042[(16)]);var inst_52996 = (state_53042[(17)]);var inst_53019 = cljs.core.empty_QMARK_.call(null,inst_52997);var inst_53020 = inst_52996.call(null,inst_53002);var inst_53021 = cljs.core.not.call(null,inst_53020);var inst_53022 = (inst_53019) && (inst_53021);var state_53042__$1 = state_53042;var statearr_53080_53118 = state_53042__$1;(statearr_53080_53118[(2)] = inst_53022);
(statearr_53080_53118[(1)] = (19));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53043 === (8)))
{var inst_52986 = (state_53042[(7)]);var state_53042__$1 = state_53042;var statearr_53081_53119 = state_53042__$1;(statearr_53081_53119[(2)] = inst_52986);
(statearr_53081_53119[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___53089,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;return ((function (switch__11077__auto__,c__11142__auto___53089,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53085 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_53085[(0)] = state_machine__11078__auto__);
(statearr_53085[(1)] = (1));
return statearr_53085;
});
var state_machine__11078__auto____1 = (function (state_53042){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53042);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53086){if((e53086 instanceof Object))
{var ex__11081__auto__ = e53086;var statearr_53087_53120 = state_53042;(statearr_53087_53120[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53042);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53086;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__53121 = state_53042;
state_53042 = G__53121;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53042){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___53089,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();var state__11144__auto__ = (function (){var statearr_53088 = f__11143__auto__.call(null);(statearr_53088[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___53089);
return statearr_53088;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___53089,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);
return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});
cljs.core.async.Pub = (function (){var obj53123 = {};return obj53123;
})();
cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){if((function (){var and__7919__auto__ = p;if(and__7919__auto__)
{return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else
{return and__7919__auto__;
}
})())
{return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else
{var x__8558__auto__ = (((p == null))?null:p);return (function (){var or__7931__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.sub_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});
cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){if((function (){var and__7919__auto__ = p;if(and__7919__auto__)
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else
{return and__7919__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else
{var x__8558__auto__ = (((p == null))?null:p);return (function (){var or__7931__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});
cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){if((function (){var and__7919__auto__ = p;if(and__7919__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else
{return and__7919__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else
{var x__8558__auto__ = (((p == null))?null:p);return (function (){var or__7931__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){if((function (){var and__7919__auto__ = p;if(and__7919__auto__)
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else
{return and__7919__auto__;
}
})())
{return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else
{var x__8558__auto__ = (((p == null))?null:p);return (function (){var or__7931__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8558__auto__)]);if(or__7931__auto__)
{return or__7931__auto__;
} else
{var or__7931__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);if(or__7931__auto____$1)
{return or__7931__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;
/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);var ensure_mult = ((function (mults){
return (function (topic){var or__7931__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__7931__auto__,mults){
return (function (p1__53124_SHARP_){if(cljs.core.truth_(p1__53124_SHARP_.call(null,topic)))
{return p1__53124_SHARP_;
} else
{return cljs.core.assoc.call(null,p1__53124_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__7931__auto__,mults))
),topic);
}
});})(mults))
;var p = (function (){if(typeof cljs.core.async.t53239 !== 'undefined')
{} else
{
/**
* @constructor
*/
cljs.core.async.t53239 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta53240){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta53240 = meta53240;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t53239.cljs$lang$type = true;
cljs.core.async.t53239.cljs$lang$ctorStr = "cljs.core.async/t53239";
cljs.core.async.t53239.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"cljs.core.async/t53239");
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$async$Pub$ = true;
cljs.core.async.t53239.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2,close_QMARK_){var self__ = this;
var p__$1 = this;var m = self__.ensure_mult.call(null,topic);return cljs.core.async.tap.call(null,m,ch__$2,close_QMARK_);
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$2){var self__ = this;
var p__$1 = this;var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);if(cljs.core.truth_(temp__4126__auto__))
{var m = temp__4126__auto__;return cljs.core.async.untap.call(null,m,ch__$2);
} else
{return null;
}
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){var self__ = this;
var ___$1 = this;return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$async$Mux$ = true;
cljs.core.async.t53239.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){var self__ = this;
var ___$1 = this;return self__.ch;
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_53241){var self__ = this;
var _53241__$1 = this;return self__.meta53240;
});})(mults,ensure_mult))
;
cljs.core.async.t53239.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_53241,meta53240__$1){var self__ = this;
var _53241__$1 = this;return (new cljs.core.async.t53239(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta53240__$1));
});})(mults,ensure_mult))
;
cljs.core.async.__GT_t53239 = ((function (mults,ensure_mult){
return (function __GT_t53239(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta53240){return (new cljs.core.async.t53239(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta53240));
});})(mults,ensure_mult))
;
}
return (new cljs.core.async.t53239(ensure_mult,mults,buf_fn,topic_fn,ch,pub,null));
})();var c__11142__auto___53353 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___53353,mults,ensure_mult,p){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___53353,mults,ensure_mult,p){
return (function (state_53309){var state_val_53310 = (state_53309[(1)]);if((state_val_53310 === (7)))
{var inst_53305 = (state_53309[(2)]);var state_53309__$1 = state_53309;var statearr_53311_53354 = state_53309__$1;(statearr_53311_53354[(2)] = inst_53305);
(statearr_53311_53354[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (20)))
{var state_53309__$1 = state_53309;var statearr_53312_53355 = state_53309__$1;(statearr_53312_53355[(2)] = null);
(statearr_53312_53355[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (1)))
{var state_53309__$1 = state_53309;var statearr_53313_53356 = state_53309__$1;(statearr_53313_53356[(2)] = null);
(statearr_53313_53356[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (4)))
{var inst_53244 = (state_53309[(7)]);var inst_53244__$1 = (state_53309[(2)]);var inst_53245 = (inst_53244__$1 == null);var state_53309__$1 = (function (){var statearr_53314 = state_53309;(statearr_53314[(7)] = inst_53244__$1);
return statearr_53314;
})();if(cljs.core.truth_(inst_53245))
{var statearr_53315_53357 = state_53309__$1;(statearr_53315_53357[(1)] = (5));
} else
{var statearr_53316_53358 = state_53309__$1;(statearr_53316_53358[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (15)))
{var inst_53286 = (state_53309[(2)]);var state_53309__$1 = state_53309;var statearr_53317_53359 = state_53309__$1;(statearr_53317_53359[(2)] = inst_53286);
(statearr_53317_53359[(1)] = (12));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (21)))
{var inst_53292 = (state_53309[(8)]);var inst_53300 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_53292);var state_53309__$1 = state_53309;var statearr_53318_53360 = state_53309__$1;(statearr_53318_53360[(2)] = inst_53300);
(statearr_53318_53360[(1)] = (22));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (13)))
{var inst_53268 = (state_53309[(9)]);var inst_53270 = cljs.core.chunked_seq_QMARK_.call(null,inst_53268);var state_53309__$1 = state_53309;if(inst_53270)
{var statearr_53319_53361 = state_53309__$1;(statearr_53319_53361[(1)] = (16));
} else
{var statearr_53320_53362 = state_53309__$1;(statearr_53320_53362[(1)] = (17));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (22)))
{var inst_53302 = (state_53309[(2)]);var state_53309__$1 = (function (){var statearr_53321 = state_53309;(statearr_53321[(10)] = inst_53302);
return statearr_53321;
})();var statearr_53322_53363 = state_53309__$1;(statearr_53322_53363[(2)] = null);
(statearr_53322_53363[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (6)))
{var inst_53244 = (state_53309[(7)]);var inst_53292 = (state_53309[(8)]);var inst_53292__$1 = topic_fn.call(null,inst_53244);var inst_53293 = cljs.core.deref.call(null,mults);var inst_53294 = cljs.core.get.call(null,inst_53293,inst_53292__$1);var inst_53295 = cljs.core.async.muxch_STAR_.call(null,inst_53294);var state_53309__$1 = (function (){var statearr_53323 = state_53309;(statearr_53323[(8)] = inst_53292__$1);
return statearr_53323;
})();return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53309__$1,(19),inst_53295,inst_53244);
} else
{if((state_val_53310 === (17)))
{var inst_53268 = (state_53309[(9)]);var inst_53277 = cljs.core.first.call(null,inst_53268);var inst_53278 = cljs.core.async.muxch_STAR_.call(null,inst_53277);var inst_53279 = cljs.core.async.close_BANG_.call(null,inst_53278);var inst_53280 = cljs.core.next.call(null,inst_53268);var inst_53254 = inst_53280;var inst_53255 = null;var inst_53256 = (0);var inst_53257 = (0);var state_53309__$1 = (function (){var statearr_53324 = state_53309;(statearr_53324[(11)] = inst_53254);
(statearr_53324[(12)] = inst_53279);
(statearr_53324[(13)] = inst_53256);
(statearr_53324[(14)] = inst_53257);
(statearr_53324[(15)] = inst_53255);
return statearr_53324;
})();var statearr_53325_53364 = state_53309__$1;(statearr_53325_53364[(2)] = null);
(statearr_53325_53364[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (3)))
{var inst_53307 = (state_53309[(2)]);var state_53309__$1 = state_53309;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53309__$1,inst_53307);
} else
{if((state_val_53310 === (12)))
{var inst_53288 = (state_53309[(2)]);var state_53309__$1 = state_53309;var statearr_53326_53365 = state_53309__$1;(statearr_53326_53365[(2)] = inst_53288);
(statearr_53326_53365[(1)] = (9));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (2)))
{var state_53309__$1 = state_53309;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53309__$1,(4),ch);
} else
{if((state_val_53310 === (19)))
{var inst_53297 = (state_53309[(2)]);var state_53309__$1 = state_53309;if(cljs.core.truth_(inst_53297))
{var statearr_53327_53366 = state_53309__$1;(statearr_53327_53366[(1)] = (20));
} else
{var statearr_53328_53367 = state_53309__$1;(statearr_53328_53367[(1)] = (21));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (11)))
{var inst_53254 = (state_53309[(11)]);var inst_53268 = (state_53309[(9)]);var inst_53268__$1 = cljs.core.seq.call(null,inst_53254);var state_53309__$1 = (function (){var statearr_53329 = state_53309;(statearr_53329[(9)] = inst_53268__$1);
return statearr_53329;
})();if(inst_53268__$1)
{var statearr_53330_53368 = state_53309__$1;(statearr_53330_53368[(1)] = (13));
} else
{var statearr_53331_53369 = state_53309__$1;(statearr_53331_53369[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (9)))
{var inst_53290 = (state_53309[(2)]);var state_53309__$1 = state_53309;var statearr_53332_53370 = state_53309__$1;(statearr_53332_53370[(2)] = inst_53290);
(statearr_53332_53370[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (5)))
{var inst_53251 = cljs.core.deref.call(null,mults);var inst_53252 = cljs.core.vals.call(null,inst_53251);var inst_53253 = cljs.core.seq.call(null,inst_53252);var inst_53254 = inst_53253;var inst_53255 = null;var inst_53256 = (0);var inst_53257 = (0);var state_53309__$1 = (function (){var statearr_53333 = state_53309;(statearr_53333[(11)] = inst_53254);
(statearr_53333[(13)] = inst_53256);
(statearr_53333[(14)] = inst_53257);
(statearr_53333[(15)] = inst_53255);
return statearr_53333;
})();var statearr_53334_53371 = state_53309__$1;(statearr_53334_53371[(2)] = null);
(statearr_53334_53371[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (14)))
{var state_53309__$1 = state_53309;var statearr_53338_53372 = state_53309__$1;(statearr_53338_53372[(2)] = null);
(statearr_53338_53372[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (16)))
{var inst_53268 = (state_53309[(9)]);var inst_53272 = cljs.core.chunk_first.call(null,inst_53268);var inst_53273 = cljs.core.chunk_rest.call(null,inst_53268);var inst_53274 = cljs.core.count.call(null,inst_53272);var inst_53254 = inst_53273;var inst_53255 = inst_53272;var inst_53256 = inst_53274;var inst_53257 = (0);var state_53309__$1 = (function (){var statearr_53339 = state_53309;(statearr_53339[(11)] = inst_53254);
(statearr_53339[(13)] = inst_53256);
(statearr_53339[(14)] = inst_53257);
(statearr_53339[(15)] = inst_53255);
return statearr_53339;
})();var statearr_53340_53373 = state_53309__$1;(statearr_53340_53373[(2)] = null);
(statearr_53340_53373[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (10)))
{var inst_53254 = (state_53309[(11)]);var inst_53256 = (state_53309[(13)]);var inst_53257 = (state_53309[(14)]);var inst_53255 = (state_53309[(15)]);var inst_53262 = cljs.core._nth.call(null,inst_53255,inst_53257);var inst_53263 = cljs.core.async.muxch_STAR_.call(null,inst_53262);var inst_53264 = cljs.core.async.close_BANG_.call(null,inst_53263);var inst_53265 = (inst_53257 + (1));var tmp53335 = inst_53254;var tmp53336 = inst_53256;var tmp53337 = inst_53255;var inst_53254__$1 = tmp53335;var inst_53255__$1 = tmp53337;var inst_53256__$1 = tmp53336;var inst_53257__$1 = inst_53265;var state_53309__$1 = (function (){var statearr_53341 = state_53309;(statearr_53341[(11)] = inst_53254__$1);
(statearr_53341[(13)] = inst_53256__$1);
(statearr_53341[(14)] = inst_53257__$1);
(statearr_53341[(15)] = inst_53255__$1);
(statearr_53341[(16)] = inst_53264);
return statearr_53341;
})();var statearr_53342_53374 = state_53309__$1;(statearr_53342_53374[(2)] = null);
(statearr_53342_53374[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (18)))
{var inst_53283 = (state_53309[(2)]);var state_53309__$1 = state_53309;var statearr_53343_53375 = state_53309__$1;(statearr_53343_53375[(2)] = inst_53283);
(statearr_53343_53375[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53310 === (8)))
{var inst_53256 = (state_53309[(13)]);var inst_53257 = (state_53309[(14)]);var inst_53259 = (inst_53257 < inst_53256);var inst_53260 = inst_53259;var state_53309__$1 = state_53309;if(cljs.core.truth_(inst_53260))
{var statearr_53344_53376 = state_53309__$1;(statearr_53344_53376[(1)] = (10));
} else
{var statearr_53345_53377 = state_53309__$1;(statearr_53345_53377[(1)] = (11));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___53353,mults,ensure_mult,p))
;return ((function (switch__11077__auto__,c__11142__auto___53353,mults,ensure_mult,p){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53349 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_53349[(0)] = state_machine__11078__auto__);
(statearr_53349[(1)] = (1));
return statearr_53349;
});
var state_machine__11078__auto____1 = (function (state_53309){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53309);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53350){if((e53350 instanceof Object))
{var ex__11081__auto__ = e53350;var statearr_53351_53378 = state_53309;(statearr_53351_53378[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53309);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53350;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__53379 = state_53309;
state_53309 = G__53379;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53309){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___53353,mults,ensure_mult,p))
})();var state__11144__auto__ = (function (){var statearr_53352 = f__11143__auto__.call(null);(statearr_53352[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___53353);
return statearr_53352;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___53353,mults,ensure_mult,p))
);
return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){var chs__$1 = cljs.core.vec.call(null,chs);var out = cljs.core.async.chan.call(null,buf_or_n);var cnt = cljs.core.count.call(null,chs__$1);var rets = cljs.core.object_array.call(null,cnt);var dchan = cljs.core.async.chan.call(null,(1));var dctr = cljs.core.atom.call(null,null);var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){(rets[i] = ret);
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0)))
{return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else
{return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));var c__11142__auto___53516 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___53516,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___53516,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_53486){var state_val_53487 = (state_53486[(1)]);if((state_val_53487 === (7)))
{var state_53486__$1 = state_53486;var statearr_53488_53517 = state_53486__$1;(statearr_53488_53517[(2)] = null);
(statearr_53488_53517[(1)] = (8));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (1)))
{var state_53486__$1 = state_53486;var statearr_53489_53518 = state_53486__$1;(statearr_53489_53518[(2)] = null);
(statearr_53489_53518[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (4)))
{var inst_53450 = (state_53486[(7)]);var inst_53452 = (inst_53450 < cnt);var state_53486__$1 = state_53486;if(cljs.core.truth_(inst_53452))
{var statearr_53490_53519 = state_53486__$1;(statearr_53490_53519[(1)] = (6));
} else
{var statearr_53491_53520 = state_53486__$1;(statearr_53491_53520[(1)] = (7));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (15)))
{var inst_53482 = (state_53486[(2)]);var state_53486__$1 = state_53486;var statearr_53492_53521 = state_53486__$1;(statearr_53492_53521[(2)] = inst_53482);
(statearr_53492_53521[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (13)))
{var inst_53475 = cljs.core.async.close_BANG_.call(null,out);var state_53486__$1 = state_53486;var statearr_53493_53522 = state_53486__$1;(statearr_53493_53522[(2)] = inst_53475);
(statearr_53493_53522[(1)] = (15));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (6)))
{var state_53486__$1 = state_53486;var statearr_53494_53523 = state_53486__$1;(statearr_53494_53523[(2)] = null);
(statearr_53494_53523[(1)] = (11));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (3)))
{var inst_53484 = (state_53486[(2)]);var state_53486__$1 = state_53486;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53486__$1,inst_53484);
} else
{if((state_val_53487 === (12)))
{var inst_53472 = (state_53486[(8)]);var inst_53472__$1 = (state_53486[(2)]);var inst_53473 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_53472__$1);var state_53486__$1 = (function (){var statearr_53495 = state_53486;(statearr_53495[(8)] = inst_53472__$1);
return statearr_53495;
})();if(cljs.core.truth_(inst_53473))
{var statearr_53496_53524 = state_53486__$1;(statearr_53496_53524[(1)] = (13));
} else
{var statearr_53497_53525 = state_53486__$1;(statearr_53497_53525[(1)] = (14));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (2)))
{var inst_53449 = cljs.core.reset_BANG_.call(null,dctr,cnt);var inst_53450 = (0);var state_53486__$1 = (function (){var statearr_53498 = state_53486;(statearr_53498[(7)] = inst_53450);
(statearr_53498[(9)] = inst_53449);
return statearr_53498;
})();var statearr_53499_53526 = state_53486__$1;(statearr_53499_53526[(2)] = null);
(statearr_53499_53526[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (11)))
{var inst_53450 = (state_53486[(7)]);var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_53486,(10),Object,null,(9));var inst_53459 = chs__$1.call(null,inst_53450);var inst_53460 = done.call(null,inst_53450);var inst_53461 = cljs.core.async.take_BANG_.call(null,inst_53459,inst_53460);var state_53486__$1 = state_53486;var statearr_53500_53527 = state_53486__$1;(statearr_53500_53527[(2)] = inst_53461);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53486__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (9)))
{var inst_53450 = (state_53486[(7)]);var inst_53463 = (state_53486[(2)]);var inst_53464 = (inst_53450 + (1));var inst_53450__$1 = inst_53464;var state_53486__$1 = (function (){var statearr_53501 = state_53486;(statearr_53501[(7)] = inst_53450__$1);
(statearr_53501[(10)] = inst_53463);
return statearr_53501;
})();var statearr_53502_53528 = state_53486__$1;(statearr_53502_53528[(2)] = null);
(statearr_53502_53528[(1)] = (4));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (5)))
{var inst_53470 = (state_53486[(2)]);var state_53486__$1 = (function (){var statearr_53503 = state_53486;(statearr_53503[(11)] = inst_53470);
return statearr_53503;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53486__$1,(12),dchan);
} else
{if((state_val_53487 === (14)))
{var inst_53472 = (state_53486[(8)]);var inst_53477 = cljs.core.apply.call(null,f,inst_53472);var state_53486__$1 = state_53486;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53486__$1,(16),out,inst_53477);
} else
{if((state_val_53487 === (16)))
{var inst_53479 = (state_53486[(2)]);var state_53486__$1 = (function (){var statearr_53504 = state_53486;(statearr_53504[(12)] = inst_53479);
return statearr_53504;
})();var statearr_53505_53529 = state_53486__$1;(statearr_53505_53529[(2)] = null);
(statearr_53505_53529[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (10)))
{var inst_53454 = (state_53486[(2)]);var inst_53455 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);var state_53486__$1 = (function (){var statearr_53506 = state_53486;(statearr_53506[(13)] = inst_53454);
return statearr_53506;
})();var statearr_53507_53530 = state_53486__$1;(statearr_53507_53530[(2)] = inst_53455);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53486__$1);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53487 === (8)))
{var inst_53468 = (state_53486[(2)]);var state_53486__$1 = state_53486;var statearr_53508_53531 = state_53486__$1;(statearr_53508_53531[(2)] = inst_53468);
(statearr_53508_53531[(1)] = (5));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___53516,chs__$1,out,cnt,rets,dchan,dctr,done))
;return ((function (switch__11077__auto__,c__11142__auto___53516,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_53512[(0)] = state_machine__11078__auto__);
(statearr_53512[(1)] = (1));
return statearr_53512;
});
var state_machine__11078__auto____1 = (function (state_53486){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53486);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53513){if((e53513 instanceof Object))
{var ex__11081__auto__ = e53513;var statearr_53514_53532 = state_53486;(statearr_53514_53532[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53486);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53513;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__53533 = state_53486;
state_53486 = G__53533;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53486){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___53516,chs__$1,out,cnt,rets,dchan,dctr,done))
})();var state__11144__auto__ = (function (){var statearr_53515 = f__11143__auto__.call(null);(statearr_53515[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___53516);
return statearr_53515;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___53516,chs__$1,out,cnt,rets,dchan,dctr,done))
);
return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11142__auto___53641 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___53641,out){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___53641,out){
return (function (state_53617){var state_val_53618 = (state_53617[(1)]);if((state_val_53618 === (7)))
{var inst_53597 = (state_53617[(7)]);var inst_53596 = (state_53617[(8)]);var inst_53596__$1 = (state_53617[(2)]);var inst_53597__$1 = cljs.core.nth.call(null,inst_53596__$1,(0),null);var inst_53598 = cljs.core.nth.call(null,inst_53596__$1,(1),null);var inst_53599 = (inst_53597__$1 == null);var state_53617__$1 = (function (){var statearr_53619 = state_53617;(statearr_53619[(7)] = inst_53597__$1);
(statearr_53619[(8)] = inst_53596__$1);
(statearr_53619[(9)] = inst_53598);
return statearr_53619;
})();if(cljs.core.truth_(inst_53599))
{var statearr_53620_53642 = state_53617__$1;(statearr_53620_53642[(1)] = (8));
} else
{var statearr_53621_53643 = state_53617__$1;(statearr_53621_53643[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (1)))
{var inst_53588 = cljs.core.vec.call(null,chs);var inst_53589 = inst_53588;var state_53617__$1 = (function (){var statearr_53622 = state_53617;(statearr_53622[(10)] = inst_53589);
return statearr_53622;
})();var statearr_53623_53644 = state_53617__$1;(statearr_53623_53644[(2)] = null);
(statearr_53623_53644[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (4)))
{var inst_53589 = (state_53617[(10)]);var state_53617__$1 = state_53617;return cljs.core.async.impl.ioc_helpers.ioc_alts_BANG_.call(null,state_53617__$1,(7),inst_53589);
} else
{if((state_val_53618 === (6)))
{var inst_53613 = (state_53617[(2)]);var state_53617__$1 = state_53617;var statearr_53624_53645 = state_53617__$1;(statearr_53624_53645[(2)] = inst_53613);
(statearr_53624_53645[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (3)))
{var inst_53615 = (state_53617[(2)]);var state_53617__$1 = state_53617;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53617__$1,inst_53615);
} else
{if((state_val_53618 === (2)))
{var inst_53589 = (state_53617[(10)]);var inst_53591 = cljs.core.count.call(null,inst_53589);var inst_53592 = (inst_53591 > (0));var state_53617__$1 = state_53617;if(cljs.core.truth_(inst_53592))
{var statearr_53626_53646 = state_53617__$1;(statearr_53626_53646[(1)] = (4));
} else
{var statearr_53627_53647 = state_53617__$1;(statearr_53627_53647[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (11)))
{var inst_53589 = (state_53617[(10)]);var inst_53606 = (state_53617[(2)]);var tmp53625 = inst_53589;var inst_53589__$1 = tmp53625;var state_53617__$1 = (function (){var statearr_53628 = state_53617;(statearr_53628[(10)] = inst_53589__$1);
(statearr_53628[(11)] = inst_53606);
return statearr_53628;
})();var statearr_53629_53648 = state_53617__$1;(statearr_53629_53648[(2)] = null);
(statearr_53629_53648[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (9)))
{var inst_53597 = (state_53617[(7)]);var state_53617__$1 = state_53617;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53617__$1,(11),out,inst_53597);
} else
{if((state_val_53618 === (5)))
{var inst_53611 = cljs.core.async.close_BANG_.call(null,out);var state_53617__$1 = state_53617;var statearr_53630_53649 = state_53617__$1;(statearr_53630_53649[(2)] = inst_53611);
(statearr_53630_53649[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (10)))
{var inst_53609 = (state_53617[(2)]);var state_53617__$1 = state_53617;var statearr_53631_53650 = state_53617__$1;(statearr_53631_53650[(2)] = inst_53609);
(statearr_53631_53650[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53618 === (8)))
{var inst_53589 = (state_53617[(10)]);var inst_53597 = (state_53617[(7)]);var inst_53596 = (state_53617[(8)]);var inst_53598 = (state_53617[(9)]);var inst_53601 = (function (){var c = inst_53598;var v = inst_53597;var vec__53594 = inst_53596;var cs = inst_53589;return ((function (c,v,vec__53594,cs,inst_53589,inst_53597,inst_53596,inst_53598,state_val_53618,c__11142__auto___53641,out){
return (function (p1__53534_SHARP_){return cljs.core.not_EQ_.call(null,c,p1__53534_SHARP_);
});
;})(c,v,vec__53594,cs,inst_53589,inst_53597,inst_53596,inst_53598,state_val_53618,c__11142__auto___53641,out))
})();var inst_53602 = cljs.core.filterv.call(null,inst_53601,inst_53589);var inst_53589__$1 = inst_53602;var state_53617__$1 = (function (){var statearr_53632 = state_53617;(statearr_53632[(10)] = inst_53589__$1);
return statearr_53632;
})();var statearr_53633_53651 = state_53617__$1;(statearr_53633_53651[(2)] = null);
(statearr_53633_53651[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___53641,out))
;return ((function (switch__11077__auto__,c__11142__auto___53641,out){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53637 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_53637[(0)] = state_machine__11078__auto__);
(statearr_53637[(1)] = (1));
return statearr_53637;
});
var state_machine__11078__auto____1 = (function (state_53617){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53617);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53638){if((e53638 instanceof Object))
{var ex__11081__auto__ = e53638;var statearr_53639_53652 = state_53617;(statearr_53639_53652[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53617);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53638;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__53653 = state_53617;
state_53617 = G__53653;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53617){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___53641,out))
})();var state__11144__auto__ = (function (){var statearr_53640 = f__11143__auto__.call(null);(statearr_53640[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___53641);
return statearr_53640;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___53641,out))
);
return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11142__auto___53746 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___53746,out){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___53746,out){
return (function (state_53723){var state_val_53724 = (state_53723[(1)]);if((state_val_53724 === (7)))
{var inst_53705 = (state_53723[(7)]);var inst_53705__$1 = (state_53723[(2)]);var inst_53706 = (inst_53705__$1 == null);var inst_53707 = cljs.core.not.call(null,inst_53706);var state_53723__$1 = (function (){var statearr_53725 = state_53723;(statearr_53725[(7)] = inst_53705__$1);
return statearr_53725;
})();if(inst_53707)
{var statearr_53726_53747 = state_53723__$1;(statearr_53726_53747[(1)] = (8));
} else
{var statearr_53727_53748 = state_53723__$1;(statearr_53727_53748[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (1)))
{var inst_53700 = (0);var state_53723__$1 = (function (){var statearr_53728 = state_53723;(statearr_53728[(8)] = inst_53700);
return statearr_53728;
})();var statearr_53729_53749 = state_53723__$1;(statearr_53729_53749[(2)] = null);
(statearr_53729_53749[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (4)))
{var state_53723__$1 = state_53723;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53723__$1,(7),ch);
} else
{if((state_val_53724 === (6)))
{var inst_53718 = (state_53723[(2)]);var state_53723__$1 = state_53723;var statearr_53730_53750 = state_53723__$1;(statearr_53730_53750[(2)] = inst_53718);
(statearr_53730_53750[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (3)))
{var inst_53720 = (state_53723[(2)]);var inst_53721 = cljs.core.async.close_BANG_.call(null,out);var state_53723__$1 = (function (){var statearr_53731 = state_53723;(statearr_53731[(9)] = inst_53720);
return statearr_53731;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53723__$1,inst_53721);
} else
{if((state_val_53724 === (2)))
{var inst_53700 = (state_53723[(8)]);var inst_53702 = (inst_53700 < n);var state_53723__$1 = state_53723;if(cljs.core.truth_(inst_53702))
{var statearr_53732_53751 = state_53723__$1;(statearr_53732_53751[(1)] = (4));
} else
{var statearr_53733_53752 = state_53723__$1;(statearr_53733_53752[(1)] = (5));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (11)))
{var inst_53700 = (state_53723[(8)]);var inst_53710 = (state_53723[(2)]);var inst_53711 = (inst_53700 + (1));var inst_53700__$1 = inst_53711;var state_53723__$1 = (function (){var statearr_53734 = state_53723;(statearr_53734[(10)] = inst_53710);
(statearr_53734[(8)] = inst_53700__$1);
return statearr_53734;
})();var statearr_53735_53753 = state_53723__$1;(statearr_53735_53753[(2)] = null);
(statearr_53735_53753[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (9)))
{var state_53723__$1 = state_53723;var statearr_53736_53754 = state_53723__$1;(statearr_53736_53754[(2)] = null);
(statearr_53736_53754[(1)] = (10));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (5)))
{var state_53723__$1 = state_53723;var statearr_53737_53755 = state_53723__$1;(statearr_53737_53755[(2)] = null);
(statearr_53737_53755[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (10)))
{var inst_53715 = (state_53723[(2)]);var state_53723__$1 = state_53723;var statearr_53738_53756 = state_53723__$1;(statearr_53738_53756[(2)] = inst_53715);
(statearr_53738_53756[(1)] = (6));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53724 === (8)))
{var inst_53705 = (state_53723[(7)]);var state_53723__$1 = state_53723;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53723__$1,(11),out,inst_53705);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___53746,out))
;return ((function (switch__11077__auto__,c__11142__auto___53746,out){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53742 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_53742[(0)] = state_machine__11078__auto__);
(statearr_53742[(1)] = (1));
return statearr_53742;
});
var state_machine__11078__auto____1 = (function (state_53723){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53723);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53743){if((e53743 instanceof Object))
{var ex__11081__auto__ = e53743;var statearr_53744_53757 = state_53723;(statearr_53744_53757[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53723);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53743;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__53758 = state_53723;
state_53723 = G__53758;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53723){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___53746,out))
})();var state__11144__auto__ = (function (){var statearr_53745 = f__11143__auto__.call(null);(statearr_53745[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___53746);
return statearr_53745;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___53746,out))
);
return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Returns a channel that will contain values from ch. Consecutive duplicate
* values will be dropped.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11142__auto___53855 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___53855,out){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___53855,out){
return (function (state_53830){var state_val_53831 = (state_53830[(1)]);if((state_val_53831 === (7)))
{var inst_53825 = (state_53830[(2)]);var state_53830__$1 = state_53830;var statearr_53832_53856 = state_53830__$1;(statearr_53832_53856[(2)] = inst_53825);
(statearr_53832_53856[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (1)))
{var inst_53807 = null;var state_53830__$1 = (function (){var statearr_53833 = state_53830;(statearr_53833[(7)] = inst_53807);
return statearr_53833;
})();var statearr_53834_53857 = state_53830__$1;(statearr_53834_53857[(2)] = null);
(statearr_53834_53857[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (4)))
{var inst_53810 = (state_53830[(8)]);var inst_53810__$1 = (state_53830[(2)]);var inst_53811 = (inst_53810__$1 == null);var inst_53812 = cljs.core.not.call(null,inst_53811);var state_53830__$1 = (function (){var statearr_53835 = state_53830;(statearr_53835[(8)] = inst_53810__$1);
return statearr_53835;
})();if(inst_53812)
{var statearr_53836_53858 = state_53830__$1;(statearr_53836_53858[(1)] = (5));
} else
{var statearr_53837_53859 = state_53830__$1;(statearr_53837_53859[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (6)))
{var state_53830__$1 = state_53830;var statearr_53838_53860 = state_53830__$1;(statearr_53838_53860[(2)] = null);
(statearr_53838_53860[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (3)))
{var inst_53827 = (state_53830[(2)]);var inst_53828 = cljs.core.async.close_BANG_.call(null,out);var state_53830__$1 = (function (){var statearr_53839 = state_53830;(statearr_53839[(9)] = inst_53827);
return statearr_53839;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53830__$1,inst_53828);
} else
{if((state_val_53831 === (2)))
{var state_53830__$1 = state_53830;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53830__$1,(4),ch);
} else
{if((state_val_53831 === (11)))
{var inst_53810 = (state_53830[(8)]);var inst_53819 = (state_53830[(2)]);var inst_53807 = inst_53810;var state_53830__$1 = (function (){var statearr_53840 = state_53830;(statearr_53840[(10)] = inst_53819);
(statearr_53840[(7)] = inst_53807);
return statearr_53840;
})();var statearr_53841_53861 = state_53830__$1;(statearr_53841_53861[(2)] = null);
(statearr_53841_53861[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (9)))
{var inst_53810 = (state_53830[(8)]);var state_53830__$1 = state_53830;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53830__$1,(11),out,inst_53810);
} else
{if((state_val_53831 === (5)))
{var inst_53807 = (state_53830[(7)]);var inst_53810 = (state_53830[(8)]);var inst_53814 = cljs.core._EQ_.call(null,inst_53810,inst_53807);var state_53830__$1 = state_53830;if(inst_53814)
{var statearr_53843_53862 = state_53830__$1;(statearr_53843_53862[(1)] = (8));
} else
{var statearr_53844_53863 = state_53830__$1;(statearr_53844_53863[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (10)))
{var inst_53822 = (state_53830[(2)]);var state_53830__$1 = state_53830;var statearr_53845_53864 = state_53830__$1;(statearr_53845_53864[(2)] = inst_53822);
(statearr_53845_53864[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53831 === (8)))
{var inst_53807 = (state_53830[(7)]);var tmp53842 = inst_53807;var inst_53807__$1 = tmp53842;var state_53830__$1 = (function (){var statearr_53846 = state_53830;(statearr_53846[(7)] = inst_53807__$1);
return statearr_53846;
})();var statearr_53847_53865 = state_53830__$1;(statearr_53847_53865[(2)] = null);
(statearr_53847_53865[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___53855,out))
;return ((function (switch__11077__auto__,c__11142__auto___53855,out){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53851 = [null,null,null,null,null,null,null,null,null,null,null];(statearr_53851[(0)] = state_machine__11078__auto__);
(statearr_53851[(1)] = (1));
return statearr_53851;
});
var state_machine__11078__auto____1 = (function (state_53830){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53830);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53852){if((e53852 instanceof Object))
{var ex__11081__auto__ = e53852;var statearr_53853_53866 = state_53830;(statearr_53853_53866[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53830);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53852;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__53867 = state_53830;
state_53830 = G__53867;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53830){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___53855,out))
})();var state__11144__auto__ = (function (){var statearr_53854 = f__11143__auto__.call(null);(statearr_53854[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___53855);
return statearr_53854;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___53855,out))
);
return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Returns a channel that will contain vectors of n items taken from ch. The
* final vector in the return channel may be smaller than n if ch closed before
* the vector could be completely filled.
* 
* The output channel is unbuffered by default, unless buf-or-n is given
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11142__auto___54002 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___54002,out){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___54002,out){
return (function (state_53972){var state_val_53973 = (state_53972[(1)]);if((state_val_53973 === (7)))
{var inst_53968 = (state_53972[(2)]);var state_53972__$1 = state_53972;var statearr_53974_54003 = state_53972__$1;(statearr_53974_54003[(2)] = inst_53968);
(statearr_53974_54003[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (1)))
{var inst_53935 = (new Array(n));var inst_53936 = inst_53935;var inst_53937 = (0);var state_53972__$1 = (function (){var statearr_53975 = state_53972;(statearr_53975[(7)] = inst_53936);
(statearr_53975[(8)] = inst_53937);
return statearr_53975;
})();var statearr_53976_54004 = state_53972__$1;(statearr_53976_54004[(2)] = null);
(statearr_53976_54004[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (4)))
{var inst_53940 = (state_53972[(9)]);var inst_53940__$1 = (state_53972[(2)]);var inst_53941 = (inst_53940__$1 == null);var inst_53942 = cljs.core.not.call(null,inst_53941);var state_53972__$1 = (function (){var statearr_53977 = state_53972;(statearr_53977[(9)] = inst_53940__$1);
return statearr_53977;
})();if(inst_53942)
{var statearr_53978_54005 = state_53972__$1;(statearr_53978_54005[(1)] = (5));
} else
{var statearr_53979_54006 = state_53972__$1;(statearr_53979_54006[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (15)))
{var inst_53962 = (state_53972[(2)]);var state_53972__$1 = state_53972;var statearr_53980_54007 = state_53972__$1;(statearr_53980_54007[(2)] = inst_53962);
(statearr_53980_54007[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (13)))
{var state_53972__$1 = state_53972;var statearr_53981_54008 = state_53972__$1;(statearr_53981_54008[(2)] = null);
(statearr_53981_54008[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (6)))
{var inst_53937 = (state_53972[(8)]);var inst_53958 = (inst_53937 > (0));var state_53972__$1 = state_53972;if(cljs.core.truth_(inst_53958))
{var statearr_53982_54009 = state_53972__$1;(statearr_53982_54009[(1)] = (12));
} else
{var statearr_53983_54010 = state_53972__$1;(statearr_53983_54010[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (3)))
{var inst_53970 = (state_53972[(2)]);var state_53972__$1 = state_53972;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53972__$1,inst_53970);
} else
{if((state_val_53973 === (12)))
{var inst_53936 = (state_53972[(7)]);var inst_53960 = cljs.core.vec.call(null,inst_53936);var state_53972__$1 = state_53972;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53972__$1,(15),out,inst_53960);
} else
{if((state_val_53973 === (2)))
{var state_53972__$1 = state_53972;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53972__$1,(4),ch);
} else
{if((state_val_53973 === (11)))
{var inst_53952 = (state_53972[(2)]);var inst_53953 = (new Array(n));var inst_53936 = inst_53953;var inst_53937 = (0);var state_53972__$1 = (function (){var statearr_53984 = state_53972;(statearr_53984[(10)] = inst_53952);
(statearr_53984[(7)] = inst_53936);
(statearr_53984[(8)] = inst_53937);
return statearr_53984;
})();var statearr_53985_54011 = state_53972__$1;(statearr_53985_54011[(2)] = null);
(statearr_53985_54011[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (9)))
{var inst_53936 = (state_53972[(7)]);var inst_53950 = cljs.core.vec.call(null,inst_53936);var state_53972__$1 = state_53972;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_53972__$1,(11),out,inst_53950);
} else
{if((state_val_53973 === (5)))
{var inst_53936 = (state_53972[(7)]);var inst_53945 = (state_53972[(11)]);var inst_53937 = (state_53972[(8)]);var inst_53940 = (state_53972[(9)]);var inst_53944 = (inst_53936[inst_53937] = inst_53940);var inst_53945__$1 = (inst_53937 + (1));var inst_53946 = (inst_53945__$1 < n);var state_53972__$1 = (function (){var statearr_53986 = state_53972;(statearr_53986[(12)] = inst_53944);
(statearr_53986[(11)] = inst_53945__$1);
return statearr_53986;
})();if(cljs.core.truth_(inst_53946))
{var statearr_53987_54012 = state_53972__$1;(statearr_53987_54012[(1)] = (8));
} else
{var statearr_53988_54013 = state_53972__$1;(statearr_53988_54013[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (14)))
{var inst_53965 = (state_53972[(2)]);var inst_53966 = cljs.core.async.close_BANG_.call(null,out);var state_53972__$1 = (function (){var statearr_53990 = state_53972;(statearr_53990[(13)] = inst_53965);
return statearr_53990;
})();var statearr_53991_54014 = state_53972__$1;(statearr_53991_54014[(2)] = inst_53966);
(statearr_53991_54014[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (10)))
{var inst_53956 = (state_53972[(2)]);var state_53972__$1 = state_53972;var statearr_53992_54015 = state_53972__$1;(statearr_53992_54015[(2)] = inst_53956);
(statearr_53992_54015[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_53973 === (8)))
{var inst_53936 = (state_53972[(7)]);var inst_53945 = (state_53972[(11)]);var tmp53989 = inst_53936;var inst_53936__$1 = tmp53989;var inst_53937 = inst_53945;var state_53972__$1 = (function (){var statearr_53993 = state_53972;(statearr_53993[(7)] = inst_53936__$1);
(statearr_53993[(8)] = inst_53937);
return statearr_53993;
})();var statearr_53994_54016 = state_53972__$1;(statearr_53994_54016[(2)] = null);
(statearr_53994_54016[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___54002,out))
;return ((function (switch__11077__auto__,c__11142__auto___54002,out){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_53998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_53998[(0)] = state_machine__11078__auto__);
(statearr_53998[(1)] = (1));
return statearr_53998;
});
var state_machine__11078__auto____1 = (function (state_53972){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_53972);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e53999){if((e53999 instanceof Object))
{var ex__11081__auto__ = e53999;var statearr_54000_54017 = state_53972;(statearr_54000_54017[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_53972);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e53999;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__54018 = state_53972;
state_53972 = G__54018;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_53972){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_53972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___54002,out))
})();var state__11144__auto__ = (function (){var statearr_54001 = f__11143__auto__.call(null);(statearr_54001[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___54002);
return statearr_54001;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___54002,out))
);
return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Returns a channel that will contain vectors of items taken from ch. New
* vectors will be created whenever (f itm) returns a value that differs from
* the previous item's (f itm).
* 
* The output channel is unbuffered, unless buf-or-n is given
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){var out = cljs.core.async.chan.call(null,buf_or_n);var c__11142__auto___54161 = cljs.core.async.chan.call(null,(1));cljs.core.async.impl.dispatch.run.call(null,((function (c__11142__auto___54161,out){
return (function (){var f__11143__auto__ = (function (){var switch__11077__auto__ = ((function (c__11142__auto___54161,out){
return (function (state_54131){var state_val_54132 = (state_54131[(1)]);if((state_val_54132 === (7)))
{var inst_54127 = (state_54131[(2)]);var state_54131__$1 = state_54131;var statearr_54133_54162 = state_54131__$1;(statearr_54133_54162[(2)] = inst_54127);
(statearr_54133_54162[(1)] = (3));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (1)))
{var inst_54090 = [];var inst_54091 = inst_54090;var inst_54092 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);var state_54131__$1 = (function (){var statearr_54134 = state_54131;(statearr_54134[(7)] = inst_54091);
(statearr_54134[(8)] = inst_54092);
return statearr_54134;
})();var statearr_54135_54163 = state_54131__$1;(statearr_54135_54163[(2)] = null);
(statearr_54135_54163[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (4)))
{var inst_54095 = (state_54131[(9)]);var inst_54095__$1 = (state_54131[(2)]);var inst_54096 = (inst_54095__$1 == null);var inst_54097 = cljs.core.not.call(null,inst_54096);var state_54131__$1 = (function (){var statearr_54136 = state_54131;(statearr_54136[(9)] = inst_54095__$1);
return statearr_54136;
})();if(inst_54097)
{var statearr_54137_54164 = state_54131__$1;(statearr_54137_54164[(1)] = (5));
} else
{var statearr_54138_54165 = state_54131__$1;(statearr_54138_54165[(1)] = (6));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (15)))
{var inst_54121 = (state_54131[(2)]);var state_54131__$1 = state_54131;var statearr_54139_54166 = state_54131__$1;(statearr_54139_54166[(2)] = inst_54121);
(statearr_54139_54166[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (13)))
{var state_54131__$1 = state_54131;var statearr_54140_54167 = state_54131__$1;(statearr_54140_54167[(2)] = null);
(statearr_54140_54167[(1)] = (14));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (6)))
{var inst_54091 = (state_54131[(7)]);var inst_54116 = inst_54091.length;var inst_54117 = (inst_54116 > (0));var state_54131__$1 = state_54131;if(cljs.core.truth_(inst_54117))
{var statearr_54141_54168 = state_54131__$1;(statearr_54141_54168[(1)] = (12));
} else
{var statearr_54142_54169 = state_54131__$1;(statearr_54142_54169[(1)] = (13));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (3)))
{var inst_54129 = (state_54131[(2)]);var state_54131__$1 = state_54131;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54131__$1,inst_54129);
} else
{if((state_val_54132 === (12)))
{var inst_54091 = (state_54131[(7)]);var inst_54119 = cljs.core.vec.call(null,inst_54091);var state_54131__$1 = state_54131;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54131__$1,(15),out,inst_54119);
} else
{if((state_val_54132 === (2)))
{var state_54131__$1 = state_54131;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54131__$1,(4),ch);
} else
{if((state_val_54132 === (11)))
{var inst_54099 = (state_54131[(10)]);var inst_54095 = (state_54131[(9)]);var inst_54109 = (state_54131[(2)]);var inst_54110 = [];var inst_54111 = inst_54110.push(inst_54095);var inst_54091 = inst_54110;var inst_54092 = inst_54099;var state_54131__$1 = (function (){var statearr_54143 = state_54131;(statearr_54143[(7)] = inst_54091);
(statearr_54143[(11)] = inst_54109);
(statearr_54143[(8)] = inst_54092);
(statearr_54143[(12)] = inst_54111);
return statearr_54143;
})();var statearr_54144_54170 = state_54131__$1;(statearr_54144_54170[(2)] = null);
(statearr_54144_54170[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (9)))
{var inst_54091 = (state_54131[(7)]);var inst_54107 = cljs.core.vec.call(null,inst_54091);var state_54131__$1 = state_54131;return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54131__$1,(11),out,inst_54107);
} else
{if((state_val_54132 === (5)))
{var inst_54099 = (state_54131[(10)]);var inst_54092 = (state_54131[(8)]);var inst_54095 = (state_54131[(9)]);var inst_54099__$1 = f.call(null,inst_54095);var inst_54100 = cljs.core._EQ_.call(null,inst_54099__$1,inst_54092);var inst_54101 = cljs.core.keyword_identical_QMARK_.call(null,inst_54092,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));var inst_54102 = (inst_54100) || (inst_54101);var state_54131__$1 = (function (){var statearr_54145 = state_54131;(statearr_54145[(10)] = inst_54099__$1);
return statearr_54145;
})();if(cljs.core.truth_(inst_54102))
{var statearr_54146_54171 = state_54131__$1;(statearr_54146_54171[(1)] = (8));
} else
{var statearr_54147_54172 = state_54131__$1;(statearr_54147_54172[(1)] = (9));
}
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (14)))
{var inst_54124 = (state_54131[(2)]);var inst_54125 = cljs.core.async.close_BANG_.call(null,out);var state_54131__$1 = (function (){var statearr_54149 = state_54131;(statearr_54149[(13)] = inst_54124);
return statearr_54149;
})();var statearr_54150_54173 = state_54131__$1;(statearr_54150_54173[(2)] = inst_54125);
(statearr_54150_54173[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (10)))
{var inst_54114 = (state_54131[(2)]);var state_54131__$1 = state_54131;var statearr_54151_54174 = state_54131__$1;(statearr_54151_54174[(2)] = inst_54114);
(statearr_54151_54174[(1)] = (7));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if((state_val_54132 === (8)))
{var inst_54091 = (state_54131[(7)]);var inst_54099 = (state_54131[(10)]);var inst_54095 = (state_54131[(9)]);var inst_54104 = inst_54091.push(inst_54095);var tmp54148 = inst_54091;var inst_54091__$1 = tmp54148;var inst_54092 = inst_54099;var state_54131__$1 = (function (){var statearr_54152 = state_54131;(statearr_54152[(7)] = inst_54091__$1);
(statearr_54152[(14)] = inst_54104);
(statearr_54152[(8)] = inst_54092);
return statearr_54152;
})();var statearr_54153_54175 = state_54131__$1;(statearr_54153_54175[(2)] = null);
(statearr_54153_54175[(1)] = (2));
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11142__auto___54161,out))
;return ((function (switch__11077__auto__,c__11142__auto___54161,out){
return (function() {
var state_machine__11078__auto__ = null;
var state_machine__11078__auto____0 = (function (){var statearr_54157 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];(statearr_54157[(0)] = state_machine__11078__auto__);
(statearr_54157[(1)] = (1));
return statearr_54157;
});
var state_machine__11078__auto____1 = (function (state_54131){while(true){
var ret_value__11079__auto__ = (function (){try{while(true){
var result__11080__auto__ = switch__11077__auto__.call(null,state_54131);if(cljs.core.keyword_identical_QMARK_.call(null,result__11080__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
continue;
}
} else
{return result__11080__auto__;
}
break;
}
}catch (e54158){if((e54158 instanceof Object))
{var ex__11081__auto__ = e54158;var statearr_54159_54176 = state_54131;(statearr_54159_54176[(5)] = ex__11081__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54131);
return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else
{if(new cljs.core.Keyword(null,"else","else",-1508377146))
{throw e54158;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11079__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268)))
{{
var G__54177 = state_54131;
state_54131 = G__54177;
continue;
}
} else
{return ret_value__11079__auto__;
}
break;
}
});
state_machine__11078__auto__ = function(state_54131){
switch(arguments.length){
case 0:
return state_machine__11078__auto____0.call(this);
case 1:
return state_machine__11078__auto____1.call(this,state_54131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11078__auto____0;
state_machine__11078__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11078__auto____1;
return state_machine__11078__auto__;
})()
;})(switch__11077__auto__,c__11142__auto___54161,out))
})();var state__11144__auto__ = (function (){var statearr_54160 = f__11143__auto__.call(null);(statearr_54160[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11142__auto___54161);
return statearr_54160;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11144__auto__);
});})(c__11142__auto___54161,out))
);
return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map