/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.internal.AbstractApnsService;
import com.notnoop.exceptions.NetworkIOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedApnsService
extends AbstractApnsService {
    private static final Logger logger = LoggerFactory.getLogger(QueuedApnsService.class);
    private ApnsService service;
    private BlockingQueue<ApnsNotification> queue;
    private AtomicBoolean started = new AtomicBoolean(false);
    private final ThreadFactory threadFactory;
    private Thread thread;
    private volatile boolean shouldContinue;

    public QueuedApnsService(ApnsService service) {
        this(service, null);
    }

    public QueuedApnsService(ApnsService service, ThreadFactory tf) {
        super(null);
        this.service = service;
        this.queue = new LinkedBlockingQueue<ApnsNotification>();
        this.threadFactory = tf == null ? Executors.defaultThreadFactory() : tf;
        this.thread = null;
    }

    @Override
    public void push(ApnsNotification msg) {
        if (!this.started.get()) {
            throw new IllegalStateException("service hasn't be started or was closed");
        }
        this.queue.add(msg);
    }

    @Override
    public void start() {
        if (this.started.getAndSet(true)) {
            return;
        }
        this.service.start();
        this.shouldContinue = true;
        this.thread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                while (QueuedApnsService.this.shouldContinue) {
                    try {
                        ApnsNotification msg = (ApnsNotification)QueuedApnsService.this.queue.take();
                        QueuedApnsService.this.service.push(msg);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (NetworkIOException e) {
                    }
                    catch (Exception e) {
                        logger.warn("Unexpected message caught... Shouldn't be here", (Throwable)e);
                    }
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void stop() {
        this.started.set(false);
        this.shouldContinue = false;
        this.thread.interrupt();
        this.service.stop();
    }

    @Override
    public Map<String, Date> getInactiveDevices() throws NetworkIOException {
        return this.service.getInactiveDevices();
    }

    @Override
    public void testConnection() throws NetworkIOException {
        this.service.testConnection();
    }
}

