/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils.Simulator;

import com.notnoop.apns.utils.Simulator.ApnsInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class InputOutputSocket {
    private final Socket socket;
    private final ApnsInputStream inputStream;
    private final DataOutputStream outputStream;

    public InputOutputSocket(Socket socket) throws IOException {
        if (socket == null) {
            throw new NullPointerException("socket may not be null");
        }
        this.socket = socket;
        socket.setSoLinger(true, 1);
        this.outputStream = new DataOutputStream(socket.getOutputStream());
        this.inputStream = new ApnsInputStream(socket.getInputStream());
    }

    public Socket getSocket() {
        return this.socket;
    }

    public ApnsInputStream getInputStream() {
        return this.inputStream;
    }

    public synchronized void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void syncWrite(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        this.outputStream.flush();
    }
}

