/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils.Simulator;

import com.notnoop.apns.internal.Utilities;
import com.notnoop.apns.utils.Simulator.ApnsInputStream;
import com.notnoop.apns.utils.Simulator.InputOutputSocket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApnsServerSimulator {
    private static final Logger logger = LoggerFactory.getLogger(ApnsServerSimulator.class);
    private static AtomicInteger threadNameCount = new AtomicInteger(0);
    private final Semaphore startUp = new Semaphore(0);
    private final ServerSocketFactory sslFactory;
    private int effectiveGatewayPort;
    private int effectiveFeedbackPort;
    Thread gatewayThread;
    Thread feedbackThread;
    ServerSocket gatewaySocket;
    ServerSocket feedbackSocket;

    public ApnsServerSimulator(ServerSocketFactory sslFactory) {
        this.sslFactory = sslFactory;
    }

    public void start() {
        logger.debug("Starting APNSServerSimulator");
        this.gatewayThread = new GatewayListener();
        this.feedbackThread = new FeedbackRunner();
        this.gatewayThread.start();
        this.feedbackThread.start();
        this.startUp.acquireUninterruptibly(2);
    }

    public void stop() {
        logger.debug("Stopping APNSServerSimulator");
        try {
            if (this.gatewaySocket != null) {
                this.gatewaySocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.feedbackSocket != null) {
                this.feedbackSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.gatewayThread != null) {
            this.gatewayThread.interrupt();
        }
        if (this.feedbackThread != null) {
            this.feedbackThread.interrupt();
        }
        logger.debug("Stopped - APNSServerSimulator");
    }

    public int getEffectiveGatewayPort() {
        return this.effectiveGatewayPort;
    }

    public int getEffectiveFeedbackPort() {
        return this.effectiveFeedbackPort;
    }

    protected void fail(byte status, int identifier, InputOutputSocket inputOutputSocket) throws IOException {
        logger.debug("FAIL {} {}", (Object)status, (Object)identifier);
        ByteBuffer bb = ByteBuffer.allocate(6);
        bb.put((byte)8);
        bb.put(status);
        bb.putInt(identifier);
        inputOutputSocket.syncWrite(bb.array());
        inputOutputSocket.close();
        logger.debug("FAIL - closed");
    }

    protected void onNotification(Notification notification, InputOutputSocket inputOutputSocket) throws IOException {
    }

    protected List<byte[]> getBadTokens() {
        return new ArrayList<byte[]>();
    }

    public class Notification {
        private final int type;
        private final int identifier;
        private final int expiry;
        private final byte[] deviceToken;
        private final byte[] payload;
        private final byte priority;

        public Notification(int type, byte[] deviceToken, byte[] payload) {
            this(type, 0, 0, deviceToken, payload);
        }

        public Notification(int type, int identifier, int expiry, byte[] deviceToken, byte[] payload) {
            this(type, identifier, expiry, deviceToken, payload, 10);
        }

        public Notification(int type, int identifier, int expiry, byte[] deviceToken, byte[] payload, byte priority) {
            this.priority = priority;
            this.type = type;
            this.identifier = identifier;
            this.expiry = expiry;
            this.deviceToken = deviceToken;
            this.payload = payload;
        }

        public byte[] getPayload() {
            return (byte[])this.payload.clone();
        }

        public byte[] getDeviceToken() {
            return (byte[])this.deviceToken.clone();
        }

        public int getType() {
            return this.type;
        }

        public int getExpiry() {
            return this.expiry;
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public byte getPriority() {
            return this.priority;
        }

        public String toString() {
            return "Notification{type=" + this.type + ", identifier=" + this.identifier + ", expiry=" + this.expiry + ", deviceToken=" + Utilities.encodeHex((byte[])this.deviceToken) + ", priority=" + this.priority + '}';
        }
    }

    private class FeedbackRunner
    extends Thread {
        private FeedbackRunner() {
            super(new ThreadGroup("FeedbackRunner" + threadNameCount.incrementAndGet()), "");
            this.setName(this.getThreadGroup().getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.debug("Launched " + Thread.currentThread().getName());
                try {
                    ApnsServerSimulator.this.feedbackSocket = ApnsServerSimulator.this.sslFactory.createServerSocket(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                ApnsServerSimulator.this.effectiveFeedbackPort = ApnsServerSimulator.this.feedbackSocket.getLocalPort();
                ApnsServerSimulator.this.startUp.release();
                while (!this.isInterrupted()) {
                    try {
                        this.handleFeedbackConnection(new InputOutputSocket(ApnsServerSimulator.this.feedbackSocket.accept()));
                    }
                    catch (SocketException ex) {
                        this.interrupt();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                logger.debug("Terminating " + Thread.currentThread().getName());
                this.getThreadGroup().list();
                this.getThreadGroup().interrupt();
            }
        }

        private void handleFeedbackConnection(final InputOutputSocket inputOutputSocket) {
            Thread feedbackConnectionTread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        logger.debug("Feedback connection sending feedback");
                        FeedbackRunner.this.sendFeedback(inputOutputSocket);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    finally {
                        inputOutputSocket.close();
                    }
                }
            };
            feedbackConnectionTread.start();
        }

        private void sendFeedback(InputOutputSocket inputOutputSocket) throws IOException {
            List<byte[]> badTokens = ApnsServerSimulator.this.getBadTokens();
            for (byte[] token : badTokens) {
                this.writeFeedback(inputOutputSocket, token);
            }
        }

        private void writeFeedback(InputOutputSocket inputOutputSocket, byte[] token) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            int unixTime = (int)(new Date().getTime() / 1000L);
            dos.write(unixTime);
            dos.write((short)token.length);
            dos.write(token);
            dos.close();
            inputOutputSocket.syncWrite(os.toByteArray());
        }
    }

    private class GatewayListener
    extends Thread {
        private GatewayListener() {
            super(new ThreadGroup("GatewayListener" + threadNameCount.incrementAndGet()), "");
            this.setName(this.getThreadGroup().getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug("Launched " + Thread.currentThread().getName());
            try {
                try {
                    ApnsServerSimulator.this.gatewaySocket = ApnsServerSimulator.this.sslFactory.createServerSocket(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                ApnsServerSimulator.this.effectiveGatewayPort = ApnsServerSimulator.this.gatewaySocket.getLocalPort();
                ApnsServerSimulator.this.startUp.release();
                while (!this.isInterrupted()) {
                    try {
                        this.handleGatewayConnection(new InputOutputSocket(ApnsServerSimulator.this.gatewaySocket.accept()));
                    }
                    catch (SocketException ex) {
                        this.interrupt();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                logger.debug("Terminating " + Thread.currentThread().getName());
                this.getThreadGroup().list();
                this.getThreadGroup().interrupt();
            }
        }

        private void handleGatewayConnection(final InputOutputSocket inputOutputSocket) throws IOException {
            Thread gatewayConnectionTread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GatewayListener.this.parseNotifications(inputOutputSocket);
                    }
                    finally {
                        inputOutputSocket.close();
                    }
                }
            };
            gatewayConnectionTread.start();
        }

        private void parseNotifications(InputOutputSocket inputOutputSocket) {
            logger.debug("Running parseNotifications {}", (Object)inputOutputSocket.getSocket());
            while (!Thread.interrupted()) {
                try {
                    ApnsInputStream inputStream = inputOutputSocket.getInputStream();
                    byte notificationType = inputStream.readByte();
                    logger.debug("Received Notification (type {})", (Object)notificationType);
                    switch (notificationType) {
                        case 0: {
                            this.readLegacyNotification(inputOutputSocket);
                            break;
                        }
                        case 1: {
                            this.readEnhancedNotification(inputOutputSocket);
                            break;
                        }
                        case 2: {
                            this.readFramedNotifications(inputOutputSocket);
                        }
                    }
                }
                catch (IOException ioe) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void readFramedNotifications(InputOutputSocket inputOutputSocket) throws IOException {
            HashMap<Byte, ApnsInputStream.Item> map = new HashMap<Byte, ApnsInputStream.Item>();
            ApnsInputStream frameStream = inputOutputSocket.getInputStream().readFrame();
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    ApnsInputStream.Item item = frameStream.readItem();
                    map.put(item.getItemId(), item);
                }
            }
            catch (EOFException eof) {
                // empty catch block
            }
            byte[] deviceToken = this.get(map, (byte)1).getBlob();
            byte[] payload = this.get(map, (byte)2).getBlob();
            int identifier = this.get(map, (byte)3).getInt();
            int expiry = this.get(map, (byte)4).getInt();
            byte priority = this.get(map, (byte)5).getByte();
            Notification notification = new Notification(2, identifier, expiry, deviceToken, payload, priority);
            logger.debug("Read framed notification {}", (Object)notification);
            ApnsServerSimulator.this.onNotification(notification, inputOutputSocket);
        }

        private ApnsInputStream.Item get(Map<Byte, ApnsInputStream.Item> map, byte idDeviceToken) {
            ApnsInputStream.Item item = map.get(idDeviceToken);
            if (item == null) {
                item = ApnsInputStream.Item.DEFAULT;
            }
            return item;
        }

        private void readEnhancedNotification(InputOutputSocket inputOutputSocket) throws IOException {
            ApnsInputStream inputStream = inputOutputSocket.getInputStream();
            int identifier = inputStream.readInt();
            int expiry = inputStream.readInt();
            byte[] deviceToken = inputStream.readBlob();
            byte[] payload = inputStream.readBlob();
            Notification notification = new Notification(1, identifier, expiry, deviceToken, payload);
            logger.debug("Read enhanced notification {}", (Object)notification);
            ApnsServerSimulator.this.onNotification(notification, inputOutputSocket);
        }

        private void readLegacyNotification(InputOutputSocket inputOutputSocket) throws IOException {
            ApnsInputStream inputStream = inputOutputSocket.getInputStream();
            byte[] deviceToken = inputStream.readBlob();
            byte[] payload = inputStream.readBlob();
            Notification notification = new Notification(0, deviceToken, payload);
            logger.debug("Read legacy notification {}", (Object)notification);
            ApnsServerSimulator.this.onNotification(notification, inputOutputSocket);
        }

        @Override
        public void interrupt() {
            logger.debug("Interrupt, closing socket");
            super.interrupt();
            try {
                ApnsServerSimulator.this.gatewaySocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

