/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.utils;

import com.notnoop.apns.utils.FixedCertificates;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ServerSocketFactory;

public class ApnsServerStub {
    private final AtomicInteger toWaitBeforeSend = new AtomicInteger(0);
    private final ByteArrayOutputStream received;
    private final ByteArrayOutputStream toSend;
    private final Semaphore messages = new Semaphore(0);
    private final Semaphore startUp = new Semaphore(0);
    private final Semaphore gatewayOutLock = new Semaphore(0);
    private final Semaphore waitForError = new Semaphore(1);
    private final ServerSocketFactory sslFactory;
    private final int gatewayPort;
    private final int feedbackPort;
    private int effectiveGatewayPort;
    private int effectiveFeedbackPort;
    private OutputStream gatewayOutputStream = null;
    Thread gatewayThread;
    Thread feedbackThread;
    ServerSocket gatewaySocket;
    ServerSocket feedbackSocket;
    AtomicInteger readLen = new AtomicInteger();

    @Deprecated
    public static ApnsServerStub prepareAndStartServer(int gatePort, int feedPort) {
        ApnsServerStub server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), gatePort, feedPort);
        server.start();
        return server;
    }

    public static ApnsServerStub prepareAndStartServer() {
        ApnsServerStub server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory());
        server.start();
        return server;
    }

    public ApnsServerStub(ServerSocketFactory sslFactory) {
        this(sslFactory, 0, 0);
    }

    public ApnsServerStub(ServerSocketFactory sslFactory, int gatewayPort, int feedbackPort) {
        this.sslFactory = sslFactory;
        this.gatewayPort = gatewayPort;
        this.feedbackPort = feedbackPort;
        this.received = new ByteArrayOutputStream();
        this.toSend = new ByteArrayOutputStream();
    }

    public void start() {
        this.gatewayThread = new GatewayRunner();
        this.feedbackThread = new FeedbackRunner();
        this.gatewayThread.start();
        this.feedbackThread.start();
        this.startUp.acquireUninterruptibly(2);
    }

    public void stop() {
        try {
            if (this.gatewaySocket != null) {
                this.gatewaySocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.feedbackSocket != null) {
                this.feedbackSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.gatewayThread != null) {
            this.gatewayThread.stop();
        }
        if (this.feedbackThread != null) {
            this.feedbackThread.stop();
        }
    }

    public void sendError(int err, int id) {
        ByteBuffer buf = ByteBuffer.allocate(6);
        buf.put((byte)8).put((byte)err).putInt(id);
        try {
            this.gatewayOutLock.acquire();
            this.gatewayOutputStream.write(buf.array());
            this.gatewayOutputStream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getEffectiveGatewayPort() {
        return this.effectiveGatewayPort;
    }

    public int getEffectiveFeedbackPort() {
        return this.effectiveFeedbackPort;
    }

    public AtomicInteger getToWaitBeforeSend() {
        return this.toWaitBeforeSend;
    }

    public ByteArrayOutputStream getReceived() {
        return this.received;
    }

    public ByteArrayOutputStream getToSend() {
        return this.toSend;
    }

    public Semaphore getMessages() {
        return this.messages;
    }

    public Semaphore getWaitForError() {
        return this.waitForError;
    }

    public void stopAt(int length) {
        this.readLen.set(length);
    }

    public byte[] readFully(InputStream st) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            int read;
            while (this.readLen.getAndDecrement() > 0 && (read = st.read()) != -1) {
                stream.write(read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    private void waitBeforeSend() {
        int wait = this.toWaitBeforeSend.get();
        if (wait != 0) {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class FeedbackRunner
    extends Thread {
        private FeedbackRunner() {
        }

        @Override
        public void run() {
            try {
                ApnsServerStub.this.feedbackSocket = ApnsServerStub.this.sslFactory.createServerSocket(ApnsServerStub.this.feedbackPort);
            }
            catch (IOException e) {
                e.printStackTrace();
                ApnsServerStub.this.messages.release();
                throw new RuntimeException(e);
            }
            ApnsServerStub.this.effectiveFeedbackPort = ApnsServerStub.this.feedbackSocket.getLocalPort();
            try {
                ApnsServerStub.this.startUp.release();
                Socket socket = ApnsServerStub.this.feedbackSocket.accept();
                socket.setSoLinger(true, 1);
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                ApnsServerStub.this.waitBeforeSend();
                ApnsServerStub.this.toSend.writeTo(out);
                in.close();
                out.close();
            }
            catch (SocketException se) {
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            ApnsServerStub.this.messages.release();
        }
    }

    private class GatewayRunner
    extends Thread {
        private GatewayRunner() {
        }

        @Override
        public void run() {
            try {
                ApnsServerStub.this.gatewaySocket = ApnsServerStub.this.sslFactory.createServerSocket(ApnsServerStub.this.gatewayPort);
            }
            catch (IOException e) {
                ApnsServerStub.this.messages.release();
                throw new RuntimeException(e);
            }
            InputStream in = null;
            ApnsServerStub.this.effectiveGatewayPort = ApnsServerStub.this.gatewaySocket.getLocalPort();
            try {
                ApnsServerStub.this.startUp.release();
                while (true) {
                    Socket socket = ApnsServerStub.this.gatewaySocket.accept();
                    socket.setSoLinger(true, 1);
                    in = socket.getInputStream();
                    ApnsServerStub.this.gatewayOutputStream = socket.getOutputStream();
                    ApnsServerStub.this.gatewayOutLock.release();
                    byte[] read = ApnsServerStub.this.readFully(in);
                    ApnsServerStub.this.waitBeforeSend();
                    ApnsServerStub.this.received.write(read);
                    ApnsServerStub.this.messages.release();
                    ApnsServerStub.this.waitForError.acquire();
                    in.close();
                    ApnsServerStub.this.gatewayOutputStream.close();
                }
            }
            catch (Throwable e) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioex) {
                    System.err.println(ioex.toString());
                }
                try {
                    if (ApnsServerStub.this.gatewayOutputStream != null) {
                        ApnsServerStub.this.gatewayOutputStream.close();
                    }
                }
                catch (IOException ioex) {
                    System.err.println(ioex.toString());
                }
                ApnsServerStub.this.messages.release();
                return;
            }
        }
    }
}

