/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.ApnsServiceImpl;
import com.notnoop.apns.internal.QueuedApnsService;
import com.notnoop.exceptions.NetworkIOException;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueuedApnsServiceTest {
    EnhancedApnsNotification notification = new EnhancedApnsNotification(1, Integer.MAX_VALUE, "2342", "{}");

    @Test(expected=IllegalStateException.class)
    public void sendWithoutStarting() {
        QueuedApnsService service = new QueuedApnsService(null);
        service.push((ApnsNotification)this.notification);
    }

    @Test
    public void pushEventually() {
        ConnectionStub connection = (ConnectionStub)Mockito.spy((Object)new ConnectionStub(0, 1));
        ApnsService service = this.newService(connection, null);
        service.push((ApnsNotification)this.notification);
        connection.semaphore.acquireUninterruptibly();
        ((ConnectionStub)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)this.notification);
    }

    @Test
    public void pushEventuallySample() {
        ConnectionStub connection = (ConnectionStub)Mockito.spy((Object)new ConnectionStub(0, 1));
        ApnsService service = this.newService(connection, null);
        service.push("2342", "{}");
        connection.semaphore.acquireUninterruptibly();
        ((ConnectionStub)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)this.notification);
    }

    @Test
    public void doNotBlock() {
        int delay = 10000;
        ConnectionStub connection = (ConnectionStub)Mockito.spy((Object)new ConnectionStub(10000, 2));
        QueuedApnsService queued = new QueuedApnsService((ApnsService)new ApnsServiceImpl((ApnsConnection)connection, null));
        queued.start();
        long time1 = System.currentTimeMillis();
        queued.push((ApnsNotification)this.notification);
        queued.push((ApnsNotification)this.notification);
        long time2 = System.currentTimeMillis();
        Assert.assertTrue((String)"queued.push() blocks", (time2 - time1 < 10000L ? 1 : 0) != 0);
        connection.interrupt();
        connection.semaphore.acquireUninterruptibly();
        ((ConnectionStub)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)2))).sendMessage((ApnsNotification)this.notification);
        queued.stop();
    }

    protected ApnsService newService(ApnsConnection connection, ApnsFeedbackConnection feedback) {
        ApnsServiceImpl service = new ApnsServiceImpl(connection, null);
        QueuedApnsService queued = new QueuedApnsService((ApnsService)service);
        queued.start();
        return queued;
    }

    static class ConnectionStub
    implements ApnsConnection {
        Semaphore semaphore;
        int delay;
        volatile boolean stop;

        public ConnectionStub(int delay, int expectedCalls) {
            this.semaphore = new Semaphore(1 - expectedCalls);
            this.delay = delay;
        }

        public synchronized void sendMessage(ApnsNotification m) {
            long time = System.currentTimeMillis();
            while (!this.stop && System.currentTimeMillis() < time + (long)this.delay) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.semaphore.release();
        }

        protected void interrupt() {
            this.stop = true;
        }

        public ApnsConnection copy() {
            throw new RuntimeException("Not implemented");
        }

        public void close() throws IOException {
        }

        public void testConnection() throws NetworkIOException {
        }

        public void setCacheLength(int cacheLength) {
        }

        public int getCacheLength() {
            return -1;
        }
    }
}

