/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.internal.ApnsFeedbackParsingUtils;
import com.notnoop.apns.utils.ApnsServerStub;
import com.notnoop.apns.utils.FixedCertificates;
import java.io.IOException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FeedbackTest {
    ApnsServerStub server;
    SSLContext clientContext = FixedCertificates.clientContext();

    @Before
    public void startup() {
        this.server = ApnsServerStub.prepareAndStartServer();
    }

    @After
    public void tearDown() {
        this.server.stop();
        this.server = null;
    }

    @Test
    public void simpleFeedback() throws IOException {
        this.server.getToSend().write(ApnsFeedbackParsingUtils.simple);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).build();
        ApnsFeedbackParsingUtils.checkParsedSimple(service.getInactiveDevices());
    }

    @Test
    public void simpleFeedbackWithoutTimeout() throws IOException {
        this.server.getToSend().write(ApnsFeedbackParsingUtils.simple);
        this.server.getToWaitBeforeSend().set(2000);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).withReadTimeout(3000).build();
        ApnsFeedbackParsingUtils.checkParsedSimple(service.getInactiveDevices());
    }

    @Test
    public void simpleFeedbackWithTimeout() throws IOException {
        this.server.getToSend().write(ApnsFeedbackParsingUtils.simple);
        this.server.getToWaitBeforeSend().set(5000);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).withReadTimeout(1000).build();
        try {
            service.getInactiveDevices();
            Assert.fail((String)"RuntimeException expected");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Socket timeout exception expected", SocketTimeoutException.class, e.getCause().getClass());
        }
    }

    @Test
    public void threeFeedback() throws IOException {
        this.server.getToSend().write(ApnsFeedbackParsingUtils.three);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).build();
        ApnsFeedbackParsingUtils.checkParsedThree(service.getInactiveDevices());
    }

    @Test
    public void simpleQueuedFeedback() throws IOException {
        this.server.getToSend().write(ApnsFeedbackParsingUtils.simple);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).asQueued().build();
        ApnsFeedbackParsingUtils.checkParsedSimple(service.getInactiveDevices());
    }

    @Test
    public void threeQueuedFeedback() throws IOException {
        this.server.getToSend().write(ApnsFeedbackParsingUtils.three);
        ApnsService service = APNS.newService().withSSLContext(this.clientContext).withGatewayDestination("localhost", this.server.getEffectiveGatewayPort()).withFeedbackDestination("localhost", this.server.getEffectiveFeedbackPort()).asQueued().build();
        ApnsFeedbackParsingUtils.checkParsedThree(service.getInactiveDevices());
    }
}

