/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.integration.ApnsSimulatorTestBase;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import uk.org.lidalia.slf4jext.Level;
import uk.org.lidalia.slf4jtest.TestLoggerFactory;

public class ApnsSimulatorTest
extends ApnsSimulatorTestBase {
    @Rule
    public Timeout timeout = new Timeout(5000);

    @Test
    public void sendOne() throws InterruptedException {
        this.send(0);
        this.server.getQueue().poll(5L, TimeUnit.SECONDS);
        this.assertIdle();
        this.assertDelegateSentCount(1);
    }

    @Test
    public void sendThree() throws InterruptedException {
        this.sendCount(3, 0);
        this.assertNumberReceived(3);
        this.assertDelegateSentCount(3);
    }

    @Test
    public void sendThousand() throws InterruptedException {
        TestLoggerFactory.getInstance().setPrintLevel(Level.INFO);
        this.sendCount(1000, 0);
        this.assertNumberReceived(1000);
        this.assertDelegateSentCount(1000);
    }

    @Test
    public void sendDelay() throws InterruptedException {
        this.send(-3);
        this.server.getQueue().poll(5L, TimeUnit.SECONDS);
        this.assertIdle();
        this.assertDelegateSentCount(1);
    }

    @Test
    public void testConnectionClose() throws InterruptedException {
        this.send(8);
        this.assertNumberReceived(1);
        this.assertDelegateSentCount(1);
        ((ApnsDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).connectionClosed((DeliveryError)Matchers.any(DeliveryError.class), Matchers.anyInt());
    }

    @Test
    public void handleRetransmissionWithSeveralOutstandingMessages() throws InterruptedException {
        this.send(-1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1);
        this.assertNumberReceived(13);
        this.assertDelegateSentCount(20);
        ((ApnsDelegate)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).connectionClosed((DeliveryError)Matchers.any(DeliveryError.class), Matchers.anyInt());
    }

    @Test
    public void testClientDoesNotResendMessagesWhenServerClosesSocketWithoutErrorPacket() throws InterruptedException {
        this.send(-1, -1, -1, -1, -1, -100, -1, -1, -1, -1, -1, -1, -1);
        this.assertNumberReceived(6);
    }

    @Ignore
    @Test
    public void RaceCondition() {
        Assert.fail((String)"Assumption: monitoring thread crashes in read() when the sender thread closes the connection first.");
    }

    @Test
    public void abortNoWait() throws InterruptedException {
        this.send(8, 0);
        this.assertNumberReceived(2);
    }

    @Test
    public void doNotSpamLogWhenConnectionClosesBetweenFeedbackPackets() throws InterruptedException {
        this.send(-1, 8, -1);
        this.assertNumberReceived(3);
        List allLoggingEvents = TestLoggerFactory.getAllLoggingEvents();
        Assert.assertThat((Object)allLoggingEvents, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem(this.eventContains("Exception while waiting for error code"))));
    }

    @Test
    public void firstTokenBad_issue145() throws InterruptedException {
        this.send(8, 0);
        this.assertNumberReceived(2);
    }
}

