/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.utils.ApnsServerStub;
import com.notnoop.apns.utils.FixedCertificates;
import com.notnoop.apns.utils.junit.DumpThreadsOnErrorRule;
import com.notnoop.apns.utils.junit.Repeat;
import com.notnoop.apns.utils.junit.RepeatRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ApnsConnectionTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public RepeatRule rr = new RepeatRule();
    @Rule
    public DumpThreadsOnErrorRule dumpRule = new DumpThreadsOnErrorRule();
    ApnsServerStub server;
    static SimpleApnsNotification msg1 = new SimpleApnsNotification("a87d8878d878a79", "{\"aps\":{}}");
    static SimpleApnsNotification msg2 = new SimpleApnsNotification("a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg1 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg2 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg3 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    private int gatewayPort;

    @Before
    public void startup() {
        System.out.println("****** " + this.testName.getMethodName());
        this.server = ApnsServerStub.prepareAndStartServer();
        this.gatewayPort = this.server.getEffectiveGatewayPort();
    }

    @After
    public void tearDown() {
        this.server.stop();
        this.server = null;
    }

    @Repeat(count=50)
    @Test(timeout=2000L)
    public void sendOneSimple() throws InterruptedException {
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", this.gatewayPort).build();
        this.server.stopAt(msg1.length());
        service.push((ApnsNotification)msg1);
        this.server.getMessages().acquire();
        Assert.assertArrayEquals((byte[])msg1.marshall(), (byte[])this.server.getReceived().toByteArray());
    }

    @Repeat(count=50)
    @Test(timeout=2000L)
    public void sendOneQueued() throws InterruptedException {
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", this.gatewayPort).asQueued().build();
        this.server.stopAt(msg1.length());
        service.push((ApnsNotification)msg1);
        this.server.getMessages().acquire();
        Assert.assertArrayEquals((byte[])msg1.marshall(), (byte[])this.server.getReceived().toByteArray());
    }

    @Test
    public void sendOneSimpleWithoutTimeout() throws InterruptedException {
        this.server.getToWaitBeforeSend().set(2000);
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", this.gatewayPort).withReadTimeout(5000).build();
        this.server.stopAt(msg1.length());
        service.push((ApnsNotification)msg1);
        this.server.getMessages().acquire();
        Assert.assertArrayEquals((byte[])msg1.marshall(), (byte[])this.server.getReceived().toByteArray());
    }

    @Test
    public void sendOneSimpleWithTimeout() throws InterruptedException {
        this.server.getToWaitBeforeSend().set(5000);
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", this.gatewayPort).withReadTimeout(1000).build();
        this.server.stopAt(msg1.length());
        service.push((ApnsNotification)msg1);
        this.server.getMessages().acquire();
        Assert.assertArrayEquals((byte[])msg1.marshall(), (byte[])this.server.getReceived().toByteArray());
    }
}

