/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.AbstractApnsServerSocket;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsServerExceptionDelegate;
import com.notnoop.apns.ApnsServerService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.SimpleApnsNotification;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;

public class ApnsGatewayServerSocket
extends AbstractApnsServerSocket {
    private final ApnsServerService apnsServerService;

    public ApnsGatewayServerSocket(SSLContext sslContext, int port, ExecutorService executorService, ApnsServerService apnsServerService, ApnsServerExceptionDelegate exceptionDelegate) throws IOException {
        super(sslContext, port, executorService, exceptionDelegate);
        this.apnsServerService = apnsServerService;
    }

    @Override
    void handleSocket(Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (true) {
            int identifier = 0;
            try {
                int read = dataInputStream.read();
                if (read == -1) break;
                boolean enhancedFormat = read == 1;
                int expiry = 0;
                if (enhancedFormat) {
                    identifier = dataInputStream.readInt();
                    expiry = dataInputStream.readInt();
                }
                short deviceTokenLength = dataInputStream.readShort();
                byte[] deviceTokenBytes = this.toArray(inputStream, deviceTokenLength);
                short payloadLength = dataInputStream.readShort();
                byte[] payloadBytes = this.toArray(inputStream, payloadLength);
                Object message = enhancedFormat ? new EnhancedApnsNotification(identifier, expiry, deviceTokenBytes, payloadBytes) : new SimpleApnsNotification(deviceTokenBytes, payloadBytes);
                this.apnsServerService.messageReceived((ApnsNotification)message);
            }
            catch (IOException ioe) {
                this.writeResponse(socket, identifier, 8, 1);
                break;
            }
            catch (Exception e) {
                this.writeResponse(socket, identifier, 8, 1);
                break;
            }
        }
    }

    private void writeResponse(Socket socket, int identifier, int command, int status) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(bos);
            dataOutputStream.writeByte(command);
            dataOutputStream.writeByte(status);
            dataOutputStream.writeInt(identifier);
            dataOutputStream.flush();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private byte[] toArray(InputStream inputStream, int size) throws IOException {
        byte[] bytes = new byte[size];
        DataInputStream dis = new DataInputStream(inputStream);
        dis.readFully(bytes);
        return bytes;
    }
}

