/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.AbstractApnsServerSocket;
import com.notnoop.apns.ApnsServerExceptionDelegate;
import com.notnoop.apns.ApnsServerService;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;

public class ApnsFeedbackServerSocket
extends AbstractApnsServerSocket {
    private final ApnsServerService requestDelegate;

    public ApnsFeedbackServerSocket(SSLContext sslContext, int port, ExecutorService executorService, ApnsServerService requestDelegate, ApnsServerExceptionDelegate exceptionDelegate) throws IOException {
        super(sslContext, port, executorService, exceptionDelegate);
        this.requestDelegate = requestDelegate;
    }

    @Override
    void handleSocket(Socket socket) throws IOException {
        Map<byte[], Date> inactiveDevices = this.requestDelegate.getInactiveDevices();
        DataOutputStream dataStream = new DataOutputStream(socket.getOutputStream());
        for (Map.Entry<byte[], Date> entry : inactiveDevices.entrySet()) {
            int time = (int)(entry.getValue().getTime() / 1000L);
            dataStream.writeInt(time);
            byte[] bytes = entry.getKey();
            dataStream.writeShort(bytes.length);
            dataStream.write(bytes);
        }
        dataStream.close();
    }
}

