/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.tracing.zipkin.ZipkinBaseTest;
import io.vertx.tracing.zipkin.ZipkinTracer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import zipkin2.Span;

public class ZipkinHttpTest
extends ZipkinBaseTest {
    @Test
    public void testHttpServerRequestIgnorePolicy1(TestContext ctx) throws Exception {
        this.testHttpServerRequest(ctx, TracingPolicy.IGNORE, true, 0);
    }

    @Test
    public void testHttpServerRequestIgnorePolicy2(TestContext ctx) throws Exception {
        this.testHttpServerRequest(ctx, TracingPolicy.IGNORE, false, 0);
    }

    @Test
    public void testHttpServerRequestPropagatePolicy1(TestContext ctx) throws Exception {
        this.testHttpServerRequest(ctx, TracingPolicy.PROPAGATE, true, 2);
    }

    @Test
    public void testHttpServerRequestPropagatePolicy2(TestContext ctx) throws Exception {
        this.testHttpServerRequest(ctx, TracingPolicy.PROPAGATE, false, 0);
    }

    @Test
    public void testHttpServerRequestSupportPolicy1(TestContext ctx) throws Exception {
        this.testHttpServerRequest(ctx, TracingPolicy.ALWAYS, true, 2);
    }

    @Test
    public void testHttpServerRequestSupportPolicy2(TestContext ctx) throws Exception {
        this.testHttpServerRequest(ctx, TracingPolicy.ALWAYS, false, 1);
    }

    void testHttpServerRequest(TestContext ctx, TracingPolicy policy, boolean withTrace, int expectedSpans) throws Exception {
        Async listenLatch = ctx.async();
        this.vertx.createHttpServer(new HttpServerOptions().setTracingPolicy(policy)).requestHandler(req -> req.response().end()).listen(8080, ctx.asyncAssertSuccess(v -> listenLatch.complete()));
        listenLatch.awaitSuccess();
        this.sendRequest(withTrace);
        if (expectedSpans > 0) {
            List<zipkin2.Span> trace = ZipkinHttpTest.waitUntilTrace(this.zipkin, expectedSpans);
            Assert.assertEquals((long)expectedSpans, (long)trace.size());
        } else {
            Assert.assertEquals((long)0L, (long)this.zipkin.getTraces().size());
        }
    }

    @Test
    public void testHttpClientRequestIgnorePolicy1(TestContext ctx) throws Exception {
        this.testHttpClientRequest(ctx, TracingPolicy.IGNORE, true, 2);
        List traces = (List)ZipkinHttpTest.waitUntilTrace(() -> {
            List tmp = this.zipkin.getTraces();
            if (tmp.size() == 2) {
                return Optional.of(tmp);
            }
            return Optional.empty();
        });
        HashMap traceMap = new HashMap();
        traces.forEach(trace -> traceMap.put(trace.size(), this.assertSingleSpan((List<zipkin2.Span>)trace)));
        zipkin2.Span span1 = (zipkin2.Span)((List)traceMap.get(2)).get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span1.localServiceName());
        Assert.assertEquals((Object)"get", (Object)span1.name());
        Assert.assertEquals((Object)"GET", span1.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span1.tags().get("http.path"));
        Assert.assertEquals((long)8080L, (long)span1.remoteEndpoint().portAsInt());
        zipkin2.Span span2 = (zipkin2.Span)((List)traceMap.get(2)).get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"get", (Object)span2.name());
        Assert.assertEquals((Object)"GET", span2.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span2.tags().get("http.path"));
        zipkin2.Span span3 = (zipkin2.Span)((List)traceMap.get(1)).get(0);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span3.kind());
        Assert.assertEquals((Object)"get", (Object)span3.name());
        Assert.assertEquals((Object)"GET", span3.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span3.tags().get("http.path"));
    }

    @Test
    public void testHttpClientRequestIgnorePolicy2(TestContext ctx) throws Exception {
        this.testHttpClientRequest(ctx, TracingPolicy.IGNORE, false, 0);
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.zipkin.getTraces().size());
    }

    @Test
    public void testHttpClientRequestPropagatePolicy1(TestContext ctx) throws Exception {
        this.testHttpClientRequest(ctx, TracingPolicy.PROPAGATE, true, 4);
        List<zipkin2.Span> trace = this.assertSingleSpan(this.waitUntilTrace(4));
        zipkin2.Span span1 = trace.get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span1.localServiceName());
        Assert.assertEquals((Object)"get", (Object)span1.name());
        Assert.assertEquals((Object)"GET", span1.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span1.tags().get("http.path"));
        Assert.assertEquals((long)8080L, (long)span1.remoteEndpoint().portAsInt());
        zipkin2.Span span2 = trace.get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"get", (Object)span2.name());
        Assert.assertEquals((Object)"GET", span2.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span2.tags().get("http.path"));
        zipkin2.Span span3 = trace.get(2);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span3.kind());
        Assert.assertEquals((Object)"get", (Object)span3.name());
        Assert.assertEquals((Object)"GET", span3.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span3.tags().get("http.path"));
        Assert.assertEquals((long)8081L, (long)span3.remoteEndpoint().portAsInt());
        zipkin2.Span span4 = trace.get(3);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span4.kind());
        Assert.assertEquals((Object)"get", (Object)span4.name());
        Assert.assertEquals((Object)"GET", span4.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span4.tags().get("http.path"));
    }

    @Test
    public void testHttpClientRequestPropagatePolicy2(TestContext ctx) throws Exception {
        this.testHttpClientRequest(ctx, TracingPolicy.PROPAGATE, false, 0);
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.zipkin.getTraces().size());
    }

    @Test
    public void testHttpClientRequestAlwaysPolicy1(TestContext ctx) throws Exception {
        this.testHttpClientRequest(ctx, TracingPolicy.ALWAYS, true, 4);
        List<zipkin2.Span> trace = this.assertSingleSpan(this.waitUntilTrace(4));
        zipkin2.Span span1 = trace.get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"my-service-name", (Object)span1.localServiceName());
        Assert.assertEquals((Object)"get", (Object)span1.name());
        Assert.assertEquals((Object)"GET", span1.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span1.tags().get("http.path"));
        Assert.assertEquals((long)8080L, (long)span1.remoteEndpoint().portAsInt());
        zipkin2.Span span2 = trace.get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"get", (Object)span2.name());
        Assert.assertEquals((Object)"GET", span2.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span2.tags().get("http.path"));
        zipkin2.Span span3 = trace.get(2);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span3.kind());
        Assert.assertEquals((Object)"get", (Object)span3.name());
        Assert.assertEquals((Object)"GET", span3.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span3.tags().get("http.path"));
        Assert.assertEquals((long)8081L, (long)span3.remoteEndpoint().portAsInt());
        zipkin2.Span span4 = trace.get(3);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span4.kind());
        Assert.assertEquals((Object)"get", (Object)span4.name());
        Assert.assertEquals((Object)"GET", span4.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span4.tags().get("http.path"));
    }

    @Test
    public void testHttpClientRequestAlwaysPolicy2(TestContext ctx) throws Exception {
        this.testHttpClientRequest(ctx, TracingPolicy.ALWAYS, false, 2);
        List<zipkin2.Span> trace = this.assertSingleSpan(this.waitUntilTrace(2));
        zipkin2.Span span1 = trace.get(0);
        Assert.assertEquals((Object)Span.Kind.CLIENT, (Object)span1.kind());
        Assert.assertEquals((Object)"get", (Object)span1.name());
        Assert.assertEquals((Object)"GET", span1.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span1.tags().get("http.path"));
        Assert.assertEquals((long)8081L, (long)span1.remoteEndpoint().portAsInt());
        zipkin2.Span span2 = trace.get(1);
        Assert.assertEquals((Object)Span.Kind.SERVER, (Object)span2.kind());
        Assert.assertEquals((Object)"get", (Object)span2.name());
        Assert.assertEquals((Object)"GET", span2.tags().get("http.method"));
        Assert.assertEquals((Object)"/", span2.tags().get("http.path"));
    }

    private void testHttpClientRequest(TestContext ctx, TracingPolicy policy, boolean withTrace, int expectedSpans) throws Exception {
        Async listenLatch = ctx.async(2);
        HttpClient c = this.vertx.createHttpClient(new HttpClientOptions().setTracingPolicy(policy));
        this.vertx.createHttpServer(new HttpServerOptions().setTracingPolicy(TracingPolicy.PROPAGATE)).requestHandler(req -> c.request(HttpMethod.GET, 8081, "localhost", "/", ctx.asyncAssertSuccess(clientReq -> clientReq.send(ctx.asyncAssertSuccess(clientResp -> req.response().end()))))).listen(8080, ar -> {
            ctx.assertTrue(ar.succeeded(), "Could not bind on port 8080");
            listenLatch.countDown();
        });
        this.vertx.createHttpServer().requestHandler(req -> req.response().end()).listen(8081, ar -> {
            ctx.assertTrue(ar.succeeded(), "Could not bind on port 8081");
            listenLatch.countDown();
        });
        listenLatch.awaitSuccess();
        this.sendRequest(withTrace);
    }

    private void sendRequest(boolean withTrace) throws Exception {
        URL url = new URL("http://localhost:8080");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        if (withTrace) {
            ZipkinTracer tracer = (ZipkinTracer)((ContextInternal)this.vertx.getOrCreateContext()).tracer();
            Tracing tracing = tracer.getTracing();
            Span span = tracing.tracer().newTrace();
            span.kind(Span.Kind.CLIENT);
            span.name("get");
            span.tag("http.method", "GET");
            span.tag("http.path", "/");
            span.remoteIpAndPort("127.0.0.1", 8080);
            TraceContext.Injector injector = tracing.propagation().injector((Propagation.Setter)new Propagation.Setter<HttpURLConnection, String>(){

                public void put(HttpURLConnection c, String key, String value) {
                    c.setRequestProperty(key, value);
                }
            });
            injector.inject(span.context(), (Object)con);
            Assert.assertEquals((long)200L, (long)con.getResponseCode());
            span.finish();
        } else {
            Assert.assertEquals((long)200L, (long)con.getResponseCode());
        }
    }
}

